/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.ui.controls;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import tern.eclipse.ide.core.IIDETernRepository;
import tern.eclipse.ide.core.TernCorePlugin;
import tern.eclipse.ide.core.preferences.TernCorePreferenceConstants;
import tern.eclipse.ide.internal.ui.TernUIMessages;
import tern.eclipse.ide.internal.ui.dialogs.EditRepositoryDialog;
import tern.eclipse.ide.ui.TernUIPlugin;
import tern.eclipse.ide.ui.controls.AbstractTableBlock;
import tern.eclipse.ide.ui.controls.TernModulesBlock;
import tern.eclipse.ide.ui.viewers.TernRepositoryLabelProvider;
import tern.repository.ITernRepository;
import tern.server.ITernModule;
import tern.utils.TernModuleHelper;

public class TernRepositoryBlock
extends AbstractTableBlock {
    private CheckboxTableViewer repositoryViewer;
    private final IProject project;
    private TernModulesBlock modulesBlock;

    public TernRepositoryBlock(IProject project) {
        this.project = project;
    }

    public Control createControl(Composite ancestor) {
        Composite parent = new Composite(ancestor, 2048);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        Font font = ancestor.getFont();
        parent.setFont(font);
        parent.setLayoutData((Object)new GridData(1808));
        this.createRepositoryTable(parent);
        this.createModulesTable(parent);
        Dialog.applyDialogFont((Control)parent);
        return parent;
    }

    private void createRepositoryTable(Composite parent) {
        Table table = new Table(parent, 68132);
        GridData data = new GridData(1808);
        table.setLayoutData((Object)data);
        table.setFont(parent.getFont());
        table.setHeaderVisible(true);
        table.setLinesVisible(false);
        this.repositoryViewer = new CheckboxTableViewer(table);
        TableViewerColumn nameColumn = new TableViewerColumn((TableViewer)this.repositoryViewer, 0);
        nameColumn.getColumn().setWidth(100);
        nameColumn.getColumn().setResizable(true);
        nameColumn.getColumn().setText(TernUIMessages.TernRepositoryBlock_repositoryName);
        TableViewerColumn filenameColumn = new TableViewerColumn((TableViewer)this.repositoryViewer, 0);
        filenameColumn.getColumn().setWidth(300);
        filenameColumn.getColumn().setResizable(true);
        filenameColumn.getColumn().setText(TernUIMessages.TernRepositoryBlock_filenameColumn);
        this.repositoryViewer.setLabelProvider((IBaseLabelProvider)TernRepositoryLabelProvider.getInstance());
        this.repositoryViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TernRepositoryBlock.this.refreshModules();
            }
        });
        this.repositoryViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                IIDETernRepository repository = (IIDETernRepository)event.getElement();
                TernRepositoryBlock.this.checkAndSelect(repository);
            }
        });
        this.restoreColumnSettings();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.repositoryViewer.addSelectionChangedListener(listener);
    }

    private void createModulesTable(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        this.modulesBlock = new TernModulesBlock(this.project, TernUIMessages.TernRepositoryBlock_modules_desc);
        Control control = this.modulesBlock.createControl(parent);
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        control.setLayoutData((Object)data);
    }

    private void refreshModules() {
        IStructuredSelection selection = (IStructuredSelection)this.repositoryViewer.getSelection();
        if (!selection.isEmpty()) {
            ITernRepository repository = (ITernRepository)selection.getFirstElement();
            this.refreshModules(repository);
        }
    }

    private void refreshModules(ITernRepository repository) {
        IScopeContext[] lookupOrder = new IScopeContext[]{InstanceScope.INSTANCE, DefaultScope.INSTANCE};
        String moduleNames = Platform.getPreferencesService().getString(TernCorePlugin.getDefault().getBundle().getSymbolicName(), "defaultTernModules", TernCorePreferenceConstants.DEFAULT_TERN_MODULES_VALUE, lookupOrder);
        this.modulesBlock.loadModules(repository, moduleNames.split(","));
    }

    public void setCheckedModules(String[] selectedModules) {
        this.modulesBlock.loadModules((ITernRepository)this.getCurrentRepository(), selectedModules);
    }

    @Override
    protected Table getTable() {
        return this.repositoryViewer.getTable();
    }

    @Override
    protected IDialogSettings getDialogSettings() {
        return TernUIPlugin.getDefault().getDialogSettings();
    }

    @Override
    protected String getQualifier() {
        return "tern.eclipse.ide.ui.repository.";
    }

    public void loadRepositories() {
        IIDETernRepository checkedRepository = null;
        IIDETernRepository currentRepository = TernCorePlugin.getTernRepositoryManager().getRepository(this.project);
        ArrayList<IIDETernRepository> repositories = new ArrayList<IIDETernRepository>();
        IIDETernRepository clonedRepository = null;
        for (IIDETernRepository repository : TernCorePlugin.getTernRepositoryManager().getRepositories()) {
            IIDETernRepository iIDETernRepository = clonedRepository = repository.isDefault() ? repository : repository.copy();
            if (repository.equals(currentRepository)) {
                checkedRepository = clonedRepository;
            }
            repositories.add(clonedRepository);
        }
        this.repositoryViewer.setInput(repositories);
        if (checkedRepository != null) {
            this.setCheckedRepository(checkedRepository);
        }
    }

    public void setCheckedRepository(IIDETernRepository repository) {
        if (repository != null) {
            this.checkAndSelect(repository);
        }
    }

    public ITernRepository getCheckedRepository() {
        Object[] elements = this.repositoryViewer.getCheckedElements();
        return (ITernRepository)elements[0];
    }

    public void addRepository(Shell parentShell) {
        IIDETernRepository newTernRepository;
        EditRepositoryDialog dialog = new EditRepositoryDialog(parentShell, this.getRepositories());
        if (dialog.open() == 0 && (newTernRepository = dialog.getRepository()) != null) {
            this.getRepositories().add(newTernRepository);
            this.refresh();
        }
    }

    public void removeRepository(Shell parentShell) {
        IIDETernRepository repository;
        if (MessageDialog.openConfirm((Shell)parentShell, (String)TernUIMessages.TernRepositoryBlock_removeRepository_title, (String)TernUIMessages.TernRepositoryBlock_removeRepository_message) && (repository = this.getCurrentRepository()) != null) {
            this.getRepositories().remove(repository);
            this.refresh();
        }
    }

    public void refreshRepository() {
        IIDETernRepository repository = this.getCurrentRepository();
        if (repository != null) {
            repository.refresh();
            this.refreshModules();
        }
    }

    public void editRepository(Shell parentShell) {
        EditRepositoryDialog dialog;
        IIDETernRepository repository = this.getCurrentRepository();
        if (repository != null && !repository.isDefault() && (dialog = new EditRepositoryDialog(parentShell, this.getRepositories(), repository)).open() == 0) {
            this.repositoryViewer.refresh((Object)repository);
            repository.refresh();
            this.refreshModules();
        }
    }

    private Collection<IIDETernRepository> getRepositories() {
        return (Collection)this.repositoryViewer.getInput();
    }

    private void refresh() {
        this.repositoryViewer.refresh();
        this.refreshModules();
    }

    public void saveRepositories() {
        TernCorePlugin.getTernRepositoryManager().setRepositories(this.getRepositories());
        this.saveDefaultModules();
    }

    public void saveDefaultModules() {
        new InstanceScope().getNode(TernCorePlugin.getDefault().getBundle().getSymbolicName()).put("defaultTernModules", this.getDefaultModules());
    }

    private String getDefaultModules() {
        ITernModule[] modules = this.modulesBlock.getCheckedModules().toArray(ITernModule.EMPTY_MODULE);
        return TernModuleHelper.getModulesAsString((ITernModule[])modules);
    }

    private IIDETernRepository getCurrentRepository() {
        IStructuredSelection selection = (IStructuredSelection)this.repositoryViewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return (IIDETernRepository)selection.getFirstElement();
    }

    private void checkAndSelect(IIDETernRepository repository) {
        this.repositoryViewer.setCheckedElements(new Object[]{repository});
        this.repositoryViewer.setSelection((ISelection)new StructuredSelection((Object)repository));
    }
}

