/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.server.nodejs.internal.ui.preferences;

import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import tern.eclipse.ide.server.nodejs.core.IDENodejsProcessHelper;
import tern.eclipse.ide.server.nodejs.core.INodejsInstall;
import tern.eclipse.ide.server.nodejs.core.TernNodejsCorePlugin;
import tern.eclipse.ide.server.nodejs.internal.ui.TernNodejsUIMessages;
import tern.eclipse.ide.ui.preferences.FileComboFieldEditor;

public class NodeJSConfigEditor {
    private ComboFieldEditor nodeJSInstallField;
    private FileComboFieldEditor nativeNodePath;
    private Label nodePathTitle;
    private Text nodePath;

    public NodeJSConfigEditor(Composite parent, String nodeJSInstallPreferenceName, String nodeJSPathPrefrenceName) {
        this.nodeJSInstallField = this.createNodeJSInstall(parent, nodeJSInstallPreferenceName);
        this.nativeNodePath = this.createNativeNodePath(parent, nodeJSPathPrefrenceName);
        this.createNodePathInfo(parent);
    }

    private ComboFieldEditor createNodeJSInstall(final Composite parent, String nodeJSInstallPreferenceName) {
        String[][] data = NodeJSConfigEditor.createNodeInstalls();
        return new ComboFieldEditor(nodeJSInstallPreferenceName, TernNodejsUIMessages.TernNodejsPreferencesPage_nodeJSInstall, data, parent){

            protected void fireValueChanged(String property, Object oldValue, Object newValue) {
                INodejsInstall install = TernNodejsCorePlugin.getNodejsInstallManager().findNodejsInstall(newValue.toString());
                if (install == null || install.isNative()) {
                    NodeJSConfigEditor.this.nativeNodePath.setEnabled(true, parent);
                    String defaultPath = IDENodejsProcessHelper.getNodejsPath();
                    NodeJSConfigEditor.this.nativeNodePath.setStringValue(defaultPath);
                    NodeJSConfigEditor.this.nodePath.setText(defaultPath);
                } else {
                    NodeJSConfigEditor.this.nativeNodePath.setEnabled(false, parent);
                    NodeJSConfigEditor.this.nodePath.setText(install.getPath().getAbsolutePath());
                }
                super.fireValueChanged(property, oldValue, newValue);
            }
        };
    }

    public static String[][] createNodeInstalls() {
        INodejsInstall[] installs = TernNodejsCorePlugin.getNodejsInstallManager().getNodejsInstalls();
        String[][] data = new String[installs.length + 1][2];
        data[0][0] = TernNodejsUIMessages.TernNodejsPreferencesPage_nodeJSInstall_emptyValue;
        data[0][1] = "";
        int i = 0;
        while (i < installs.length) {
            data[i + 1][0] = installs[i].getName();
            data[i + 1][1] = installs[i].getId();
            ++i;
        }
        return data;
    }

    private FileComboFieldEditor createNativeNodePath(Composite parent, String nodeJSPathPrefrenceName) {
        String[] defaultPaths = IDENodejsProcessHelper.getDefaultNodejsPaths();
        return new FileComboFieldEditor(nodeJSPathPrefrenceName, TernNodejsUIMessages.TernNodejsPreferencesPage_nativeNodeJSPath, defaultPaths, parent){

            protected void fireValueChanged(String property, Object oldValue, Object newValue) {
                NodeJSConfigEditor.this.nodePath.setText(newValue.toString());
                super.fireValueChanged(property, oldValue, newValue);
            }
        };
    }

    private void createNodePathInfo(Composite parent) {
        this.nodePathTitle = new Label(parent, 0);
        this.nodePathTitle.setText(TernNodejsUIMessages.TernNodejsPreferencesPage_nodeJSPath);
        GridData gridData = new GridData(2);
        this.nodePathTitle.setLayoutData((Object)gridData);
        this.nodePath = new Text(parent, 72);
        this.nodePath.setText("");
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 200;
        this.nodePath.setLayoutData((Object)gridData);
    }

    public ComboFieldEditor getNodeJSInstallField() {
        return this.nodeJSInstallField;
    }

    public FileComboFieldEditor getNativeNodePath() {
        return this.nativeNodePath;
    }

    public void setEnabled(boolean enabled, Composite parent) {
        this.nodeJSInstallField.setEnabled(enabled, parent);
        this.nodePathTitle.setEnabled(enabled);
        this.nativeNodePath.setEnabled(enabled, parent);
        this.nodePath.setEnabled(enabled);
    }

    public void updateNodePath(INodejsInstall install, boolean isRemote, Composite parent) {
        if (install != null) {
            if (install.isNative()) {
                this.nodePath.setText(this.nativeNodePath.getStringValue());
            } else {
                this.nodePath.setText(install.getPath().getAbsolutePath());
            }
        }
        this.nativeNodePath.setEnabled(!isRemote && install != null && install.isNative(), parent);
    }
}

