/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.layouttpl.ui.wizard;

import com.liferay.ide.layouttpl.core.operation.INewLayoutTplDataModelProperties;
import com.liferay.ide.layouttpl.core.operation.NewLayoutTplDataModelProvider;
import com.liferay.ide.layouttpl.ui.LayoutTplUI;
import com.liferay.ide.layouttpl.ui.wizard.AddLayoutTplOperation;
import com.liferay.ide.layouttpl.ui.wizard.LayoutTplTemplateContextTypeIds;
import com.liferay.ide.layouttpl.ui.wizard.NewLayoutTplLayoutWizardPage;
import com.liferay.ide.layouttpl.ui.wizard.NewLayoutTplWizardPage;
import com.liferay.ide.project.ui.wizard.ValidProjectChecker;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizard;

public class NewLayoutTplWizard
extends DataModelWizard
implements INewWizard,
INewLayoutTplDataModelProperties {
    public static final String ID = "com.liferay.ide.eclipse.layouttpl.ui.wizard.layouttemplate";
    public static final String LAYOUTTPL_LAYOUT_PAGE = "layoutTplLayoutPage";
    public static final String LAYOUTTPL_PAGE = "layoutTplPage";
    public static final String[] WIZARD_PAGES = new String[]{"layoutTplPage", "layoutTplLayoutPage"};
    protected NewLayoutTplWizardPage layoutTplPage;
    protected NewLayoutTplLayoutWizardPage layoutTplStartPage;

    public NewLayoutTplWizard() {
        this(null);
    }

    public NewLayoutTplWizard(IDataModel dataModel) {
        super(dataModel);
        this.setWindowTitle(Msgs.newLayoutTemplate);
        this.setDefaultPageImageDescriptor(this.getDefaultImageDescriptor());
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.getDataModel();
        ValidProjectChecker checker = new ValidProjectChecker(ID);
        checker.checkValidProjectTypes();
    }

    protected void doAddPages() {
        this.layoutTplPage = new NewLayoutTplWizardPage(this.getDataModel(), LAYOUTTPL_PAGE);
        this.addPage((IWizardPage)this.layoutTplPage);
        this.layoutTplStartPage = new NewLayoutTplLayoutWizardPage(this.getDataModel(), LAYOUTTPL_LAYOUT_PAGE);
        this.addPage((IWizardPage)this.layoutTplStartPage);
    }

    protected ImageDescriptor getDefaultImageDescriptor() {
        return LayoutTplUI.imageDescriptorFromPlugin((String)"com.liferay.ide.layouttpl.ui", (String)"/icons/wizban/layout_template_wiz.png");
    }

    protected IDataModelProvider getDefaultProvider() {
        final TemplateStore templateStore = LayoutTplUI.getDefault().getTemplateStore();
        final TemplateContextType contextType = LayoutTplUI.getDefault().getTemplateContextRegistry().getContextType(LayoutTplTemplateContextTypeIds.NEW);
        return new NewLayoutTplDataModelProvider(){

            public IDataModelOperation getDefaultOperation() {
                return new AddLayoutTplOperation(this.getDataModel(), templateStore, contextType);
            }
        };
    }

    protected void openEditor(final IFile file) {
        if (file != null) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                    }
                    catch (PartInitException e) {
                        LayoutTplUI.logError((Exception)((Object)e));
                    }
                }
            });
        }
    }

    protected void openWebFile(IFile file) {
        try {
            this.openEditor(file);
        }
        catch (Exception cantOpen) {
            LayoutTplUI.logError(cantOpen);
        }
    }

    protected void postPerformFinish() throws InvocationTargetException {
        super.postPerformFinish();
        IFile layoutTplFile = (IFile)this.getDataModel().getProperty("INewLayoutTplModelProperties.LAYOUT_TPL_FILE_CREATED");
        if (layoutTplFile != null && layoutTplFile.exists()) {
            this.openWebFile(layoutTplFile);
        }
    }

    protected boolean runForked() {
        return false;
    }

    private static class Msgs
    extends NLS {
        public static String newLayoutTemplate;

        static {
            Msgs.initializeMessages((String)NewLayoutTplWizard.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

