/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.contenttype;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.ITextContentDescriber;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.parser.XMLTokenizer;

public final class XMLDocumentElementAttributeContentDescriber
implements ITextContentDescriber,
IExecutableExtension {
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_VALUE = "value";
    private static final QualifiedName[] SUPPORTED_OPTIONS = new QualifiedName[]{IContentDescription.BYTE_ORDER_MARK};
    private AttributeValuePatternPair[] fPairs = null;

    private static byte[] getByteOrderMark(InputStream input) throws IOException {
        int first = input.read();
        if (first == 239) {
            int second = input.read();
            int third = input.read();
            if (second == 187 && third == 191) {
                return IContentDescription.BOM_UTF_8;
            }
        } else if (first == 254) {
            if (input.read() == 255) {
                return IContentDescription.BOM_UTF_16BE;
            }
        } else if (first == 255 && input.read() == 254) {
            return IContentDescription.BOM_UTF_16LE;
        }
        return null;
    }

    private int checkCriteria(Reader contents) throws IOException {
        if (this.fPairs == null || this.fPairs.length == 0) {
            return 0;
        }
        String attributeName = null;
        String attributeValue = null;
        XMLTokenizer tokenizer = new XMLTokenizer(contents);
        String token = tokenizer.primGetNextToken();
        while (token != null && !"XML_TAG_CLOSE".equals(token) && !"XML_EMPTY_TAG_CLOSE".equals(token)) {
            if ("XML_TAG_ATTRIBUTE_NAME".equals(token)) {
                attributeName = tokenizer.yytext();
            } else if ("XML_TAG_ATTRIBUTE_VALUE".equals(token)) {
                attributeValue = StringUtils.strip((String)tokenizer.yytext());
                int i = 0;
                while (i < this.fPairs.length) {
                    boolean valueMatched;
                    boolean nameMatched = this.fPairs[i].attribute.matcher(attributeName).matches();
                    if (nameMatched && (valueMatched = this.fPairs[i].value.matcher(attributeValue).matches())) {
                        return 2;
                    }
                    ++i;
                }
            }
            token = tokenizer.primGetNextToken();
        }
        return 0;
    }

    public int describe(InputStream contents, IContentDescription description) throws IOException {
        contents.reset();
        byte[] bom = XMLDocumentElementAttributeContentDescriber.getByteOrderMark(contents);
        if (bom != null && description != null) {
            description.setProperty(IContentDescription.BYTE_ORDER_MARK, (Object)bom);
        }
        Object value = description != null ? description.getProperty(IContentDescription.CHARSET) : null;
        String charsetName = null;
        charsetName = value != null ? value.toString() : (Arrays.equals(IContentDescription.BOM_UTF_16BE, bom) ? "UTF-16BE" : (Arrays.equals(IContentDescription.BOM_UTF_16LE, bom) ? "UTF-16LE" : "UTF-8"));
        contents.reset();
        return this.checkCriteria(new InputStreamReader(contents, Charset.forName(charsetName)));
    }

    public int describe(Reader contents, IContentDescription description) throws IOException {
        contents.reset();
        return this.checkCriteria(contents);
    }

    public QualifiedName[] getSupportedOptions() {
        return SUPPORTED_OPTIONS;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (!(data instanceof String) && data instanceof Hashtable) {
            IConfigurationElement describerElement = config.getChildren("describer")[0];
            IConfigurationElement[] params = describerElement.getChildren("parameter");
            ArrayList<AttributeValuePatternPair> pairs = new ArrayList<AttributeValuePatternPair>();
            int i = 0;
            while (i < params.length) {
                String rawName = params[i].getAttribute(ATTRIBUTE_NAME);
                String rawValue = params[i].getAttribute(ATTRIBUTE_VALUE);
                if (rawName != null && rawValue != null) {
                    Pattern attributeName = Pattern.compile(rawName);
                    Pattern attributeValue = Pattern.compile(rawValue);
                    pairs.add(new AttributeValuePatternPair(attributeName, attributeValue));
                }
                ++i;
            }
            this.fPairs = pairs.toArray(new AttributeValuePatternPair[pairs.size()]);
        }
        if (this.fPairs == null || this.fPairs.length == 0) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.jsf.core", 0, "Attributes not specified", null));
        }
    }

    private static class AttributeValuePatternPair {
        Pattern attribute;
        Pattern value;

        public AttributeValuePatternPair(Pattern attribute, Pattern value) {
            this.attribute = attribute;
            this.value = value;
        }

        public String toString() {
            return this.attribute + " : " + this.value;
        }
    }
}

