/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.ui.editor;

import com.liferay.ide.core.ILiferayPortal;
import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.model.IModelChangedEvent;
import com.liferay.ide.core.model.IModelChangedListener;
import com.liferay.ide.portlet.core.PluginPackageModel;
import com.liferay.ide.portlet.ui.PortletUIPlugin;
import com.liferay.ide.portlet.ui.editor.DependenciesFormPage;
import com.liferay.ide.portlet.ui.editor.PluginPackageFormPage;
import com.liferay.ide.portlet.ui.editor.PluginPackageInputContext;
import com.liferay.ide.ui.editor.InputContext;
import com.liferay.ide.ui.editor.InputContextManager;
import com.liferay.ide.ui.editor.PluginPackageInputContextManager;
import com.liferay.ide.ui.form.IDEFormEditor;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertiesFileEditor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.internal.forms.widgets.BusyIndicator;
import org.eclipse.ui.part.FileEditorInput;

public class PluginPackageEditor
extends IDEFormEditor
implements IModelChangedListener {
    public static final String EDITOR_ID = "com.liferay.ide.eclipse.portlet.ui.editor.pluginpackage";
    protected BusyIndicator busyLabel;
    protected PropertiesFileEditor editor;
    private IResourceChangeListener fileChangeListener;
    protected boolean ignoreModelChanges = false;
    protected int lastPageIndex = -1;
    protected PluginPackageModel model;

    public void contextRemoved(InputContext context) {
    }

    public void editorContextAdded(InputContext context) {
    }

    public Object getAdapter(Class adapterClass) {
        Object adapter = super.getAdapter(adapterClass);
        if (adapter == null) {
            adapter = this.editor.getAdapter(adapterClass);
        }
        return adapter;
    }

    public IFileEditorInput getEditorInput() {
        return (IFileEditorInput)super.getEditorInput();
    }

    public IPath getPortalDir() {
        try {
            ILiferayProject liferayProject = LiferayCore.create((Object)this.getEditorInput().getFile().getProject());
            ILiferayPortal portal = (ILiferayPortal)liferayProject.adapt(ILiferayPortal.class);
            return portal.getAppServerPortalDir();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        Assert.isLegal((boolean)(editorInput instanceof IFileEditorInput), (String)"Invalid Input: Must be IFileEditorInput");
        super.init(site, editorInput);
        this.setPartName(editorInput.getName());
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void modelChanged(IModelChangedEvent event) {
        if (this.ignoreModelChanges) {
            return;
        }
        PluginPackageModel model = (PluginPackageModel)this.getModel();
        IDocument doc = model.getDocument();
        this.editor.getDocumentProvider().getDocument((Object)this.getEditorInput()).set(doc.get());
    }

    public void monitoredFileAdded(IFile monitoredFile) {
    }

    public boolean monitoredFileRemoved(IFile monitoredFile) {
        return false;
    }

    private void addPropertiesEditorPage() {
        this.editor = new PropertiesFileEditor();
        ((PluginPackageModel)this.getModel()).addModelChangedListener((IModelChangedListener)this);
        try {
            int index = this.addPage((IEditorPart)this.editor, (IEditorInput)this.getEditorInput());
            this.setPageText(index, Msgs.source);
        }
        catch (PartInitException e) {
            PortletUIPlugin.logError((Exception)((Object)e));
        }
    }

    protected void addDependenciesFormPage() {
        try {
            int index = this.addPage((IFormPage)new DependenciesFormPage((FormEditor)this));
            this.setPageText(index, Msgs.dependencies);
        }
        catch (PartInitException e) {
            PortletUIPlugin.logError((Exception)((Object)e));
        }
    }

    protected void addPages() {
        this.addPluginPackageFormPage();
        this.addPropertiesEditorPage();
        this.createFileChangeListener();
    }

    protected void addPluginPackageFormPage() {
        try {
            int index = this.addPage((IFormPage)new PluginPackageFormPage(this));
            this.setPageText(index, Msgs.properties);
        }
        catch (PartInitException e) {
            PortletUIPlugin.logError((Exception)((Object)e));
        }
    }

    protected final void createFileChangeListener() {
        this.fileChangeListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                PluginPackageEditor.this.handleFileChangedEvent(event);
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.fileChangeListener, 1);
    }

    protected InputContextManager createInputContextManager() {
        PluginPackageInputContextManager manager = new PluginPackageInputContextManager((IDEFormEditor)this);
        return manager;
    }

    protected void createResourceContexts(InputContextManager manager, IFileEditorInput input) {
        IFile file = input.getFile();
        if (file.exists()) {
            FileEditorInput in = new FileEditorInput(file);
            manager.putContext((IEditorInput)in, (InputContext)new PluginPackageInputContext(this, (IEditorInput)in, true));
        }
        manager.monitorFile(file);
    }

    public void dispose() {
        super.dispose();
        if (this.fileChangeListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.fileChangeListener);
            this.fileChangeListener = null;
        }
    }

    protected String getEditorID() {
        return EDITOR_ID;
    }

    public IFile getFile() {
        IFileEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof FileEditorInput) {
            return ((FileEditorInput)editorInput).getFile();
        }
        return null;
    }

    protected InputContext getInputContext(Object object) {
        InputContext context = null;
        if (object instanceof IFile) {
            context = this.fInputContextManager.findContext((IResource)((IFile)object));
        }
        return context;
    }

    protected final void handleFileChangedEvent(IResourceChangeEvent event) {
        IResourceDelta localDelta;
        IResourceDelta delta = event.getDelta();
        if (delta != null && this.getFile() != null && (localDelta = delta.findMember(this.getFile().getFullPath())) != null) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (localDelta.getKind() == 2) {
                        PluginPackageEditor.this.getSite().getPage().closeEditor((IEditorPart)PluginPackageEditor.this, false);
                    }
                }
            });
        }
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        if (this.lastPageIndex == 1 && newPageIndex != 1) {
            String props = this.editor.getDocumentProvider().getDocument((Object)this.getEditorInput()).get();
            try {
                this.ignoreModelChanges = true;
                if (this.getLastDirtyState()) {
                    ((PluginPackageModel)this.getModel()).load((InputStream)new ByteArrayInputStream(props.getBytes()), false);
                }
                this.ignoreModelChanges = false;
            }
            catch (CoreException e) {
                PortletUIPlugin.logError((Exception)((Object)e));
            }
        }
        this.lastPageIndex = newPageIndex;
    }

    private static class Msgs
    extends NLS {
        public static String dependencies;
        public static String properties;
        public static String source;

        static {
            Msgs.initializeMessages((String)PluginPackageEditor.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

