/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.ui.editor.internal;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.portlet.core.util.PortletUtil;
import com.liferay.ide.portlet.ui.PortletUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.forms.JumpActionHandler;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class ResourceBundleJumpActionHandler
extends JumpActionHandler {
    protected boolean computeEnablementState() {
        Element element = this.getModelElement();
        IProject project = (IProject)element.adapt(IProject.class);
        ValueProperty property = (ValueProperty)this.property().definition();
        String text = element.property(property).text(true);
        boolean isEnabled = super.computeEnablementState();
        if (isEnabled && text != null) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot wroot = workspace.getRoot();
            IClasspathEntry[] cpEntries = CoreUtil.getClasspathEntries((IProject)project);
            String ioFileName = PortletUtil.convertJavaToIoFileName((String)text, (String)"properties", (String[])new String[0]);
            if (cpEntries != null) {
                IClasspathEntry[] iClasspathEntryArray = cpEntries;
                int n = cpEntries.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry iClasspathEntry = iClasspathEntryArray[n2];
                    if (3 == iClasspathEntry.getEntryKind()) {
                        IPath entryPath = wroot.getFolder(iClasspathEntry.getPath()).getLocation();
                        IFile resourceBundleFile = wroot.getFileForLocation(entryPath = entryPath.append(ioFileName));
                        if (resourceBundleFile != null && resourceBundleFile.exists()) {
                            return true;
                        }
                    }
                    ++n2;
                }
            }
        }
        return false;
    }

    protected Object run(Presentation context) {
        Element element = this.getModelElement();
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ValueProperty property = (ValueProperty)this.property().definition();
        IProject project = (IProject)element.adapt(IProject.class);
        Value value = element.property(property);
        String text = value.text(false);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot wroot = workspace.getRoot();
        IClasspathEntry[] cpEntries = CoreUtil.getClasspathEntries((IProject)project);
        String ioFileName = PortletUtil.convertJavaToIoFileName((String)text, (String)"properties", (String[])new String[0]);
        IClasspathEntry[] iClasspathEntryArray = cpEntries;
        int n = cpEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry iClasspathEntry = iClasspathEntryArray[n2];
            if (3 == iClasspathEntry.getEntryKind()) {
                IPath entryPath = wroot.getFolder(iClasspathEntry.getPath()).getLocation();
                IFile resourceBundleFile = wroot.getFileForLocation(entryPath = entryPath.append(ioFileName));
                if (resourceBundleFile != null && resourceBundleFile.exists() && window != null) {
                    IWorkbenchPage page = window.getActivePage();
                    IEditorDescriptor editorDescriptor = null;
                    try {
                        editorDescriptor = IDE.getEditorDescriptor((String)resourceBundleFile.getName());
                    }
                    catch (PartInitException partInitException) {
                        // empty catch block
                    }
                    if (editorDescriptor != null) {
                        try {
                            IDE.openEditor((IWorkbenchPage)page, (IFile)resourceBundleFile, (String)editorDescriptor.getId(), (boolean)true);
                        }
                        catch (PartInitException e) {
                            PortletUIPlugin.logError((Exception)((Object)e));
                        }
                    }
                }
            }
            ++n2;
        }
        return null;
    }
}

