/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.ui.util;

import com.liferay.ide.core.properties.PropertiesFileLookup;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.PropertiesUtil;
import com.liferay.ide.portlet.ui.util.MessageKey;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.search.core.util.DOMUtils;
import org.w3c.dom.Node;

public class NodeUtils {
    public static MessageKey[] findMessageKeys(IDocument document, String key, boolean loadValues) {
        IJavaProject project;
        MessageKey[] retval = null;
        IFile file = DOMUtils.getFile((IDocument)document);
        if (file != null && file.exists() && (project = JavaCore.create((IProject)file.getProject())) != null && project.exists()) {
            ArrayList<MessageKey> keys = new ArrayList<MessageKey>();
            for (IFolder src : CoreUtil.getSourceFolders((IJavaProject)project)) {
                IFile[] props;
                if (!src.exists()) continue;
                IFile[] iFileArray = props = PropertiesUtil.visitPropertiesFiles((IResource)src, (String)".*");
                int n = props.length;
                int n2 = 0;
                while (n2 < n) {
                    IFile prop = iFileArray[n2];
                    try {
                        PropertiesFileLookup.KeyInfo info = new PropertiesFileLookup(prop.getContents(), key, loadValues).getKeyInfo(key);
                        if (info != null && info.offset >= 0) {
                            keys.add(new MessageKey(prop, key, info.offset, info.length, info.value));
                        }
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                    ++n2;
                }
            }
            retval = keys.toArray(new MessageKey[0]);
        }
        return retval;
    }

    public static Node getMessageKey(IDOMNode currentNode) {
        boolean messageNode;
        Node retval = null;
        boolean bl = messageNode = currentNode != null && currentNode.getNodeName() != null && currentNode.getNodeType() == 1 && (currentNode.getNodeName().endsWith("message") || currentNode.getNodeName().endsWith("error") || NodeUtils.isAuiLabel(currentNode));
        if (messageNode) {
            Node key = currentNode.getAttributes().getNamedItem("key");
            if (key != null && !CoreUtil.isNullOrEmpty((String)key.getNodeValue())) {
                retval = key;
            } else {
                Node label = currentNode.getAttributes().getNamedItem("label");
                if (label != null && !CoreUtil.isNullOrEmpty((String)label.getNodeValue())) {
                    retval = label;
                }
            }
        }
        return retval;
    }

    private static boolean isAuiLabel(IDOMNode currentNode) {
        return currentNode.getNodeName().startsWith("aui:") && currentNode.getAttributes().getNamedItem("label") != null;
    }
}

