/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.core.resource;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.wst.xml.search.core.resource.IResourceRequestor;
import org.eclipse.wst.xml.search.core.resource.IURIResolver;

public abstract class AbstractResourceRequestor
implements IResourceRequestor {
    protected static final String DOT_FOLDER = ".";

    @Override
    public boolean accept(Object selectedNode, IResource rootContainer, IResource resource, IURIResolver resolver, String matching, boolean fullMatch) {
        int resourceType = resource.getType();
        switch (resourceType) {
            case 8: {
                return this.accept(selectedNode, rootContainer, (IWorkspaceRoot)resource, resolver, matching, fullMatch);
            }
            case 4: {
                return this.accept(selectedNode, rootContainer, (IProject)resource, resolver, matching, fullMatch);
            }
            case 2: {
                return this.accept(selectedNode, rootContainer, (IFolder)resource, resolver, matching, fullMatch);
            }
            case 1: {
                return this.accept(selectedNode, rootContainer, (IFile)resource, resolver, matching, fullMatch);
            }
        }
        return false;
    }

    public boolean accept(Object selectedNode, IResource rootContainer, IWorkspaceRoot workspaceRoot, IURIResolver resolver, String matching, boolean fullMatch) {
        return true;
    }

    public boolean accept(Object selectedNode, IResource rootContainer, IProject project, IURIResolver resolver, String matching, boolean fullMatch) {
        return project.isOpen();
    }

    public boolean accept(Object selectedNode, IResource rootContainer, IFolder folder, IURIResolver resolver, String matching, boolean fullMatch) {
        return !folder.getName().startsWith(DOT_FOLDER);
    }

    protected abstract boolean accept(Object var1, IResource var2, IFile var3, IURIResolver var4, String var5, boolean var6);

    @Override
    public boolean acceptContainer() {
        return false;
    }

    @Override
    public boolean acceptFile() {
        return true;
    }
}

