/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.search.core.util.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DOMUtils {
    public static final IDOMNode getNodeByOffset(IDocument document, int offset) {
        IStructuredModel model = null;
        try {
            model = StructuredModelManager.getModelManager().getExistingModelForRead(document);
            IDOMNode iDOMNode = DOMUtils.getNodeByOffset(model, offset);
            return iDOMNode;
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    public static final IDOMNode getNodeByOffset(IStructuredModel model, int offset) {
        IndexedRegion node;
        if (model != null && (node = model.getIndexedRegion(offset)) instanceof IDOMNode) {
            return (IDOMNode)node;
        }
        return null;
    }

    public static IDOMAttr getAttrByRegion(IDOMNode element, ITextRegion region) {
        IStructuredDocumentRegion structuredDocumentRegionElement = element.getFirstStructuredDocumentRegion();
        ITextRegionList elementRegions = structuredDocumentRegionElement.getRegions();
        int index = elementRegions.indexOf(region);
        if (index < 0) {
            return null;
        }
        ITextRegion attrNameRegion = null;
        while (index >= 0) {
            if ((attrNameRegion = elementRegions.get(index--)).getType() == "XML_TAG_ATTRIBUTE_NAME") break;
        }
        if (attrNameRegion == null) {
            return null;
        }
        String attrName = structuredDocumentRegionElement.getText(attrNameRegion);
        return (IDOMAttr)element.getAttributes().getNamedItem(attrName);
    }

    public static final IDOMAttr getAttrByOffset(Node node, int offset) {
        if (node instanceof IndexedRegion && ((IndexedRegion)node).contains(offset) && node.hasAttributes()) {
            NamedNodeMap attrs = node.getAttributes();
            int i = 0;
            while (i < attrs.getLength()) {
                IndexedRegion attRegion = (IndexedRegion)attrs.item(i);
                if (attRegion.contains(offset)) {
                    return (IDOMAttr)attrs.item(i);
                }
                ++i;
            }
        }
        return null;
    }

    public static final IFile getFile(IDOMNode node) {
        return DOMUtils.getFile((IStructuredModel)node.getModel());
    }

    public static final IFile getFile(IDocument document) {
        if (document == null) {
            return null;
        }
        IStructuredModel model = null;
        try {
            model = StructuredModelManager.getModelManager().getExistingModelForRead(document);
            if (model != null) {
                IFile iFile = DOMUtils.getFile(model);
                return iFile;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return null;
    }

    public static final IFile getFile(IStructuredModel model) {
        String baselocation = model.getBaseLocation();
        if (baselocation != null) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            Path filePath = new Path(baselocation);
            if (filePath.segmentCount() > 1) {
                return root.getFile((IPath)filePath);
            }
        }
        return null;
    }

    public static final String getFileName(IDOMNode node) {
        return DOMUtils.getFileName((IStructuredModel)node.getModel());
    }

    public static final String getFileName(IStructuredModel model) {
        String baselocation = model.getBaseLocation();
        if (baselocation != null) {
            int index = baselocation.lastIndexOf(47);
            if (index == -1) {
                index = baselocation.lastIndexOf(92);
            }
            if (index == -1) {
                return baselocation;
            }
            return baselocation.substring(index + 1, baselocation.length());
        }
        return null;
    }

    public static String getNodeValue(Node node) {
        if (node == null) {
            return null;
        }
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 2: {
                return ((Attr)node).getValue();
            }
            case 3: {
                return DOMUtils.getTextContent((Text)node);
            }
        }
        return node.getNodeValue();
    }

    public static String getTextContent(Text text) {
        return DOMUtils.getTextContent(text, true);
    }

    public static String getTextContent(Text text, boolean normalize) {
        if (normalize) {
            return StringUtils.normalizeSpace(text.getData());
        }
        return text.getData();
    }

    public static Element getFirstChildElementByTagName(Node parentNode, String elementName) {
        Element result = null;
        if (parentNode.getNodeType() == 9) {
            result = ((Document)parentNode).getDocumentElement();
            if (!result.getNodeName().equals(elementName)) {
                result = null;
            }
        } else {
            NodeList nodes = parentNode.getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                if (node.getNodeType() == 1 && node.getNodeName().equals(elementName)) {
                    result = (Element)node;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public static Collection<Element> getFirstChildElementsByTagName(Node contextNode, String elementName) {
        ArrayList<Element> elements = null;
        Element result = null;
        if (contextNode.getNodeType() == 9) {
            result = ((Document)contextNode).getDocumentElement();
            if (!result.getNodeName().equals(elementName)) {
                result = null;
            }
        } else {
            NodeList nodes = contextNode.getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                if (node.getNodeType() == 1 && node.getNodeName().equals(elementName)) {
                    if (elements == null) {
                        elements = new ArrayList<Element>();
                    }
                    result = (Element)node;
                    elements.add(result);
                }
                ++i;
            }
        }
        if (elements == null) {
            return Collections.emptyList();
        }
        return elements;
    }

    public static IDOMAttr getAttr(IDOMElement element, String attrName) {
        String namespaceURI;
        IDOMAttr attr;
        if (StringUtils.isEmpty(attrName)) {
            return null;
        }
        String prefix = element.getPrefix();
        if (!StringUtils.isEmpty(prefix) && (attr = (IDOMAttr)element.getAttributeNodeNS(namespaceURI = element.getNamespaceURI(), attrName)) != null) {
            return attr;
        }
        return (IDOMAttr)element.getAttributeNode(attrName);
    }

    public static Text getTextNode(Node parentNode) {
        if (parentNode == null) {
            return null;
        }
        Node result = null;
        parentNode.normalize();
        NodeList nodeList = parentNode.getNodeType() == 9 ? ((Document)parentNode).getDocumentElement().getChildNodes() : parentNode.getChildNodes();
        int len = nodeList.getLength();
        if (len == 0) {
            return null;
        }
        int i = 0;
        while (i < len) {
            result = nodeList.item(i);
            if (result.getNodeType() == 3) {
                return (Text)result;
            }
            if (result.getNodeType() == 4) {
                return (Text)result;
            }
            ++i;
        }
        return null;
    }

    public static String getTextNodeAsString(Node parentNode) {
        if (parentNode == null) {
            return null;
        }
        Text txt = DOMUtils.getTextNode(parentNode);
        if (txt == null) {
            return null;
        }
        return txt.getNodeValue();
    }

    public static String getContentTypeId(IDOMNode node) {
        if (node == null) {
            return null;
        }
        return node.getModel().getContentTypeIdentifier();
    }

    public static boolean isContentTypeId(IDOMNode selectedNode, String[] contentTypeIds) {
        int i = 0;
        while (i < contentTypeIds.length) {
            if (DOMUtils.isContentTypeId(selectedNode, contentTypeIds[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isContentTypeId(IDOMNode node, String contentTypeId) {
        if (contentTypeId == null) {
            return false;
        }
        String nodeContentTypeId = DOMUtils.getContentTypeId(node);
        return contentTypeId.equals(nodeContentTypeId);
    }

    public static String getStructuredModelContentTypeId(IFile file) {
        if (file != null) {
            IContentDescription desc = null;
            IContentType type = null;
            try {
                desc = file.getContentDescription();
                if (desc != null) {
                    type = desc.getContentType();
                }
            }
            catch (CoreException coreException) {}
            if (type == null) {
                type = Platform.getContentTypeManager().findContentTypeFor(file.getName());
            }
            if (type != null) {
                return type.getId();
            }
        }
        return null;
    }

    public static boolean isContentTypeId(IFile file, Collection<String> contentTypeIds) {
        if (contentTypeIds == null) {
            return false;
        }
        String structuredModelContentTypeId = DOMUtils.getStructuredModelContentTypeId(file);
        if (structuredModelContentTypeId == null) {
            return false;
        }
        return contentTypeIds.contains(structuredModelContentTypeId);
    }

    public static boolean isContentTypeId(IFile file, String contentTypeId) {
        if (contentTypeId == null) {
            return false;
        }
        String structuredModelContentTypeId = DOMUtils.getStructuredModelContentTypeId(file);
        if (structuredModelContentTypeId == null) {
            return false;
        }
        return contentTypeId.equals(structuredModelContentTypeId);
    }

    public static Element getOwnerElement(Node node) {
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 2: {
                return ((Attr)node).getOwnerElement();
            }
            case 3: {
                return (Element)((Text)node).getParentNode();
            }
            case 4: {
                return (Element)((CDATASection)node).getParentNode();
            }
            case 1: {
                return (Element)node;
            }
        }
        return null;
    }
}

