/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.kaleo.ui;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.kaleo.core.model.ScriptLanguageType;
import com.liferay.ide.kaleo.ui.AbstractKaleoEditorHelper;
import com.liferay.ide.kaleo.ui.IKaleoEditorHelper;
import com.liferay.ide.kaleo.ui.KaleoTemplateContextType;
import com.liferay.ide.kaleo.ui.helpers.TextEditorHelper;
import com.liferay.ide.kaleo.ui.xml.KaleoTemplateContext;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class KaleoUI
extends AbstractUIPlugin {
    private static KaleoUI plugin;
    public static final String PLUGIN_ID = "com.liferay.ide.kaleo.ui";
    private static final String TEMPLATES_KEY = "com.liferay.ide.kaleo.ui.templates";
    private ContextTypeRegistry contextTypeRegistry;
    private TextEditorHelper defaultEditorHelper;
    private IKaleoEditorHelper[] kaleoEditorHelpers;
    private TemplateStore templateStore;

    public static ImageDescriptor createDescriptor(String pluginId, String image) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)("icons/" + image));
    }

    public static IStatus createErrorStatus(Exception e) {
        return KaleoUI.createErrorStatus(e.getMessage(), e);
    }

    public static IStatus createErrorStatus(String string) {
        return new Status(4, PLUGIN_ID, string);
    }

    public static IStatus createErrorStatus(String msg, Exception e) {
        return new Status(4, PLUGIN_ID, msg, (Throwable)e);
    }

    public static IStatus createInfoStatus(String msg) {
        return new Status(1, PLUGIN_ID, msg, null);
    }

    public static KaleoUI getDefault() {
        return plugin;
    }

    public static String getDefaultScriptForType(ScriptLanguageType scriptType, String nodeType) {
        URL scriptFileUrl = KaleoUI.getDefault().getBundle().getEntry("/scripts/default." + nodeType.toLowerCase() + "." + scriptType.toString().toLowerCase());
        try {
            return CoreUtil.readStreamToString((InputStream)scriptFileUrl.openStream());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static IKaleoEditorHelper getKaleoEditorHelper(String languageType) {
        IKaleoEditorHelper retval = null;
        IKaleoEditorHelper[] iKaleoEditorHelperArray = KaleoUI.getDefault().getKaleoEditorHelpers();
        int n = iKaleoEditorHelperArray.length;
        int n2 = 0;
        while (n2 < n) {
            IKaleoEditorHelper editoHelper = iKaleoEditorHelperArray[n2];
            if (editoHelper.getLanguageType().equals(languageType)) {
                retval = editoHelper;
                break;
            }
            ++n2;
        }
        if (retval == null) {
            retval = KaleoUI.getDefault().getDefaultTextEditorHelper();
        }
        return retval;
    }

    public static IKaleoEditorHelper getKaleoEditorHelperByEditorId(String editorId) {
        IKaleoEditorHelper retval = null;
        IKaleoEditorHelper[] iKaleoEditorHelperArray = KaleoUI.getDefault().getKaleoEditorHelpers();
        int n = iKaleoEditorHelperArray.length;
        int n2 = 0;
        while (n2 < n) {
            IKaleoEditorHelper editoHelper = iKaleoEditorHelperArray[n2];
            if (editoHelper.getEditorId().equals(editorId)) {
                retval = editoHelper;
                break;
            }
            ++n2;
        }
        return retval;
    }

    public static IPreferenceStore getPrefStore() {
        return KaleoUI.getDefault().getPreferenceStore();
    }

    public static void logError(Exception e) {
        KaleoUI.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, e.getMessage(), (Throwable)e));
    }

    public static void logError(String msg, Exception e) {
        KaleoUI.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, msg, (Throwable)e));
    }

    public static IStatus logInfo(String msg, IStatus status) {
        return new Status(1, PLUGIN_ID, msg, status.getException());
    }

    public ContextTypeRegistry getContextTypeRegistry() {
        if (this.contextTypeRegistry == null) {
            this.contextTypeRegistry = new ContributionContextTypeRegistry();
            KaleoTemplateContextType contextType = new KaleoTemplateContextType();
            this.contextTypeRegistry.addContextType((TemplateContextType)contextType);
        }
        return this.contextTypeRegistry;
    }

    private IKaleoEditorHelper getDefaultTextEditorHelper() {
        if (this.defaultEditorHelper == null) {
            this.defaultEditorHelper = new TextEditorHelper();
            this.defaultEditorHelper.setLanguageType("text");
            this.defaultEditorHelper.setEditorId("com.liferay.ide.kaleo.ui.editor.text");
            this.defaultEditorHelper.setFileExtension("txt");
            this.defaultEditorHelper.setContributorName(this.getBundle().getSymbolicName());
        }
        return this.defaultEditorHelper;
    }

    public IKaleoEditorHelper[] getKaleoEditorHelpers() {
        if (this.kaleoEditorHelpers == null) {
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.liferay.ide.kaleo.ui.editorHelpers");
            try {
                ArrayList<AbstractKaleoEditorHelper> helpers = new ArrayList<AbstractKaleoEditorHelper>();
                IConfigurationElement[] iConfigurationElementArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement element = iConfigurationElementArray[n2];
                    Object o = element.createExecutableExtension("class");
                    if (o instanceof AbstractKaleoEditorHelper) {
                        AbstractKaleoEditorHelper kaleoEditorHelper = (AbstractKaleoEditorHelper)o;
                        kaleoEditorHelper.setLanguageType(element.getAttribute("languageType"));
                        kaleoEditorHelper.setEditorId(element.getAttribute("editorId"));
                        kaleoEditorHelper.setFileExtension(element.getAttribute("fileExtension"));
                        kaleoEditorHelper.setContributorName(element.getContributor().getName());
                        helpers.add(kaleoEditorHelper);
                    }
                    ++n2;
                }
                this.kaleoEditorHelpers = helpers.toArray(new IKaleoEditorHelper[0]);
            }
            catch (Exception e) {
                KaleoUI.logError(e);
            }
        }
        return this.kaleoEditorHelpers;
    }

    public ContextTypeRegistry getTemplateContextRegistry() {
        if (this.contextTypeRegistry == null) {
            ContributionContextTypeRegistry registry = new ContributionContextTypeRegistry();
            KaleoTemplateContext[] kaleoTemplateContextArray = KaleoTemplateContext.values();
            int n = kaleoTemplateContextArray.length;
            int n2 = 0;
            while (n2 < n) {
                KaleoTemplateContext contextType = kaleoTemplateContextArray[n2];
                registry.addContextType(contextType.getContextTypeId());
                ++n2;
            }
            this.contextTypeRegistry = registry;
        }
        return this.contextTypeRegistry;
    }

    public TemplateStore getTemplateStore() {
        if (this.templateStore == null) {
            this.templateStore = new ContributionTemplateStore(this.getTemplateContextRegistry(), this.getPreferenceStore(), TEMPLATES_KEY);
            try {
                this.templateStore.load();
            }
            catch (IOException ex) {
                KaleoUI.logError("Unable to load pom templates", ex);
            }
        }
        return this.templateStore;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }
}

