/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.kaleo.ui.diagram;

import com.liferay.ide.kaleo.core.model.Transition;
import com.liferay.ide.kaleo.core.model.WorkflowNode;
import java.util.ArrayList;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.diagram.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.sapphire.ui.swt.gef.SapphireDiagramEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class ShowDiagramPartActionHandler
extends SapphireActionHandler {
    protected Object run(Presentation context) {
        final SapphireDiagramEditorPagePart diagramPart = (SapphireDiagramEditorPagePart)context.part().nearest(SapphireDiagramEditorPagePart.class);
        if (diagramPart != null) {
            ISapphirePart part;
            LabelProvider labelProvider = new LabelProvider(){

                public Image getImage(Object element) {
                    if (element instanceof DiagramNodePart) {
                        DiagramNodePart diagramNodePart = (DiagramNodePart)element;
                        Element modelElement = diagramNodePart.getLocalModelElement();
                        return diagramPart.getSwtResourceCache().image(modelElement.type().image());
                    }
                    if (element instanceof DiagramConnectionPart) {
                        return diagramPart.getSwtResourceCache().image(Transition.TYPE.image());
                    }
                    return diagramPart.getSwtResourceCache().image(WorkflowNode.TYPE.image());
                }

                public String getText(Object element) {
                    if (element instanceof DiagramNodePart) {
                        return ((DiagramNodePart)element).getId();
                    }
                    if (element instanceof DiagramConnectionPart) {
                        return ((DiagramConnectionPart)element).getLabel();
                    }
                    return element != null ? element.toString() : "";
                }
            };
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(((SwtPresentation)context).shell(), (ILabelProvider)labelProvider);
            ArrayList parts = new ArrayList();
            parts.addAll(diagramPart.getNodes());
            parts.addAll(diagramPart.getConnections());
            dialog.setElements(parts.toArray());
            dialog.setMultipleSelection(false);
            dialog.setHelpAvailable(false);
            dialog.setTitle("Find Part");
            dialog.setMessage("Select part:");
            dialog.open();
            Object[] result = dialog.getResult();
            if (result != null && result.length == 1 && ((part = (ISapphirePart)result[0]) instanceof DiagramNodePart || part instanceof DiagramConnectionPart)) {
                SapphireDiagramEditor diagramEditor = (SapphireDiagramEditor)diagramPart.adapt(SapphireDiagramEditor.class);
                GraphicalViewer viewer = diagramEditor.getGraphicalViewer();
                GraphicalEditPart editpart = diagramEditor.getGraphicalEditPart(part);
                if (editpart != null) {
                    viewer.flush();
                    viewer.select((EditPart)editpart);
                    viewer.reveal((EditPart)editpart);
                }
            }
        }
        return null;
    }
}

