/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.kaleo.ui.editor;

import com.liferay.ide.kaleo.ui.editor.ScriptCreationFactory;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class KaleoEditorPaletteFactory {
    public static PaletteRoot createPalette(AbstractUIPlugin bundle, String folderName, ImageDescriptor entryImage) {
        PaletteRoot root = new PaletteRoot();
        try {
            File paletteFolder = KaleoEditorPaletteFactory.getPaletteFolder(bundle, folderName);
            if (paletteFolder != null) {
                File[] fileArray = paletteFolder.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    KaleoEditorPaletteFactory.createPaletteEntries((PaletteContainer)root, file, entryImage);
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return root;
    }

    private static void createPaletteEntries(PaletteContainer container, File paletteFile, ImageDescriptor image) {
        if (paletteFile.isDirectory()) {
            PaletteDrawer newDrawer = new PaletteDrawer(paletteFile.getName());
            File[] fileArray = paletteFile.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                KaleoEditorPaletteFactory.createPaletteEntries((PaletteContainer)newDrawer, file, image);
                ++n2;
            }
            container.add((PaletteEntry)newDrawer);
        } else {
            ScriptCreationFactory factory = new ScriptCreationFactory(paletteFile);
            String label = new Path(paletteFile.getName()).removeFileExtension().toPortableString();
            CombinedTemplateCreationEntry entry = new CombinedTemplateCreationEntry(label, label, (CreationFactory)factory, image, image);
            container.add((PaletteEntry)entry);
        }
    }

    private static File getPaletteFolder(AbstractUIPlugin bundle, String folderName) {
        try {
            return new File(FileLocator.toFileURL((URL)bundle.getBundle().getEntry(folderName)).getFile());
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

