/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.kaleo.ui.editor;

import com.liferay.ide.kaleo.core.model.ScriptLanguageType;
import com.liferay.ide.kaleo.core.model.Scriptable;
import com.liferay.ide.kaleo.ui.editor.ScriptPropertyStorage;
import java.net.URI;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.EnumSerialization;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.ILocationProvider;

public class ScriptPropertyEditorInput
extends PlatformObject
implements IStorageEditorInput,
ILocationProvider {
    private Element modelElement;
    private ValueProperty valueProperty;

    public ScriptPropertyEditorInput(Element modelElement, ValueProperty property) {
        this.modelElement = modelElement;
        this.valueProperty = property;
    }

    public boolean exists() {
        return this.modelElement != null && this.valueProperty != null;
    }

    public Object getAdapter(Class adapter) {
        if (ILocationProvider.class.equals((Object)adapter)) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.valueProperty.name();
    }

    public IPath getPath(Object element) {
        return this.getStorage().getFullPath();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public ValueProperty getProperty() {
        return this.valueProperty;
    }

    public String getScriptLanguage() {
        String retval = null;
        try {
            ScriptLanguageType scriptType = (ScriptLanguageType)((Scriptable)this.modelElement.nearest(Scriptable.class)).getScriptLanguage().content();
            EnumSerialization enumValue = scriptType.getClass().getFields()[scriptType.ordinal()].getAnnotation(EnumSerialization.class);
            retval = enumValue.primary();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retval;
    }

    public IStorage getStorage() {
        return new ScriptPropertyStorage(this.modelElement, this.valueProperty);
    }

    public String getToolTipText() {
        return this.getStorage().getFullPath().toPortableString();
    }

    public URI getURI(Object element) {
        return this.getStorage().getFullPath().toFile().toURI();
    }
}

