/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.kaleo.ui.editor;

import com.liferay.ide.kaleo.ui.editor.DefinitionStorage;
import com.liferay.ide.kaleo.ui.navigator.WorkflowDefinitionEntry;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;

public class WorkflowDefinitionEditorInput
extends PlatformObject
implements IStorageEditorInput {
    private WorkflowDefinitionEntry defNode;

    public WorkflowDefinitionEditorInput(WorkflowDefinitionEntry defNode) {
        this.defNode = defNode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof WorkflowDefinitionEditorInput) {
            WorkflowDefinitionEditorInput input = (WorkflowDefinitionEditorInput)((Object)obj);
            return this.defNode.equals(input.getWorkflowDefinitionEntry());
        }
        return false;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.valueOf(this.defNode.getName()) + " [Version: " + this.defNode.getVersion());
        if (this.defNode.getDraftVersion() != -1) {
            builder.append(", Draft Version: " + this.defNode.getDraftVersion() + "]");
        } else {
            builder.append("]");
        }
        return builder.toString();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public IStorage getStorage() {
        return new DefinitionStorage(this.defNode);
    }

    public String getToolTipText() {
        return this.getName();
    }

    public WorkflowDefinitionEntry getWorkflowDefinitionEntry() {
        return this.defNode;
    }

    public void setWorkflowDefinitionEntry(WorkflowDefinitionEntry newNode) {
        this.defNode = newNode;
    }
}

