/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.kaleo.ui.editor;

import com.liferay.ide.kaleo.core.model.CanTransition;
import com.liferay.ide.kaleo.core.model.ConnectionBendpoint;
import com.liferay.ide.kaleo.core.model.Position;
import com.liferay.ide.kaleo.core.model.Transition;
import com.liferay.ide.kaleo.core.model.TransitionMetadata;
import com.liferay.ide.kaleo.core.model.WorkflowDefinition;
import com.liferay.ide.kaleo.core.model.WorkflowNode;
import com.liferay.ide.kaleo.core.model.WorkflowNodeMetadata;
import com.liferay.ide.kaleo.core.util.KaleoModelUtil;
import com.liferay.ide.kaleo.ui.editor.WorkflowDefinitionEditor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyEvent;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.ui.Point;
import org.eclipse.sapphire.ui.diagram.ConnectionAddEvent;
import org.eclipse.sapphire.ui.diagram.ConnectionBendpointsEvent;
import org.eclipse.sapphire.ui.diagram.ConnectionDeleteEvent;
import org.eclipse.sapphire.ui.diagram.ConnectionService;
import org.eclipse.sapphire.ui.diagram.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeAddEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeBounds;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeDeleteEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeMoveEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramPageEvent;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.diagram.layout.ConnectionHashKey;
import org.eclipse.sapphire.ui.diagram.layout.DiagramLayoutPersistenceService;
import org.eclipse.sapphire.util.ListFactory;

public class WorkflowDefinitionLayoutPersistenceService
extends DiagramLayoutPersistenceService {
    private boolean dirty;
    private HashMap<String, DiagramNodeBounds> nodeBounds;
    private HashMap<ConnectionHashKey, List<Point>> connectionBendPoints;
    private HashMap<ConnectionHashKey, Point> connectionLabelPositions;
    private HashMap<String, List<Transition>> unconnectedTransitions;
    private Listener connectionPartListener;
    private Listener bendpointListener;
    private Listener workflowNodeMetadataListener;
    private Listener workflowNodeListener;
    private Listener diagramPartListener;
    private boolean autoLayout = false;

    protected void init() {
        super.init();
        this.nodeBounds = new HashMap();
        this.connectionBendPoints = new HashMap();
        this.connectionLabelPositions = new HashMap();
        this.unconnectedTransitions = new HashMap();
        this.dirty = false;
        this.connectionPartListener = new FilteredListener<ConnectionBendpointsEvent>(){

            protected void handleTypedEvent(ConnectionBendpointsEvent event) {
                if (event.reset()) {
                    if (WorkflowDefinitionLayoutPersistenceService.this.autoLayout) {
                        WorkflowDefinitionLayoutPersistenceService.this.addConnectionToPersistenceCache(event.part());
                        WorkflowDefinitionLayoutPersistenceService.this.refreshDirtyState();
                    } else {
                        WorkflowDefinitionLayoutPersistenceService.this.write(event.part());
                    }
                } else {
                    WorkflowDefinitionLayoutPersistenceService.this.write(event.part());
                }
            }
        };
        this.load();
        this.refreshPersistedPartsCache();
        this.addDiagramPartListener();
        this.addModelListeners();
    }

    private void setGridVisible(boolean gridVisible) {
        ((WorkflowDefinitionEditor)((Object)this.part().adapt(WorkflowDefinitionEditor.class))).setGridVisible(gridVisible);
    }

    private void setGuidesVisible(boolean showGuides) {
        ((WorkflowDefinitionEditor)((Object)this.part().adapt(WorkflowDefinitionEditor.class))).setShowGuides(showGuides);
    }

    private void read(DiagramNodePart nodePart) {
        WorkflowNode workflowNode = (WorkflowNode)nodePart.getLocalModelElement().nearest(WorkflowNode.class);
        if (!workflowNode.disposed()) {
            String nodeId;
            WorkflowNodeMetadata metadata = (WorkflowNodeMetadata)workflowNode.getMetadata().content();
            if ((Integer)metadata.getPosition().getX().content() != -1 && (Integer)metadata.getPosition().getY().content() != -1) {
                this.writeWorkflowNodeMetaDataToBounds(metadata, nodePart);
            }
            if (this.nodeBounds.containsKey(nodeId = nodePart.getId()) && this.nodeBounds.get(nodeId) != null) {
                nodePart.setNodeBounds(this.nodeBounds.get(nodeId));
            } else {
                this.nodeBounds.put(nodeId, nodePart.getNodeBounds());
            }
        }
        SapphireDiagramEditorPagePart part = this.part();
        ConnectionService connService = (ConnectionService)part.service(ConnectionService.class);
        if (workflowNode instanceof CanTransition) {
            for (Transition transition : ((CanTransition)workflowNode).getTransitions()) {
                if (transition.getTarget().target() != null) continue;
                if (!this.unconnectedTransitions.containsKey(transition.getTarget().content())) {
                    this.unconnectedTransitions.put((String)transition.getTarget().content(), new LinkedList());
                }
                if (transition.disposed()) continue;
                this.unconnectedTransitions.get(transition.getTarget().content()).add(transition);
            }
        }
        if (this.unconnectedTransitions.containsKey(workflowNode.getName().content())) {
            List<Transition> transitions = this.unconnectedTransitions.get(workflowNode.getName().content());
            for (Transition transition : transitions) {
                DiagramConnectionPart connPart = this.getConnectionPart(connService, (Element)transition);
                DiagramNodePart nodePart1 = part.getDiagramNodePart((Element)transition.nearest(WorkflowNode.class));
                DiagramNodePart nodePart2 = part.getDiagramNodePart((Element)workflowNode);
                connPart.reconnect(nodePart1, nodePart2);
            }
            this.unconnectedTransitions.remove(workflowNode.getName().content());
        }
    }

    private void write(DiagramNodePart nodePart) {
        WorkflowNode workflowNode = (WorkflowNode)nodePart.getLocalModelElement().nearest(WorkflowNode.class);
        if (!workflowNode.disposed()) {
            if (this.isNodeLayoutChanged(nodePart)) {
                this.removeWorkflowNodeListeners();
                this.writeWorkflowNodeBoundsToMetaData(workflowNode, nodePart);
                this.addWorkflowNodeListeners();
            }
            this.refreshDirtyState();
        }
    }

    public DiagramLayoutPersistenceService.DiagramConnectionInfo read(DiagramConnectionPart connPart) {
        ConnectionHashKey key = ConnectionHashKey.createKey((DiagramConnectionPart)connPart);
        if (this.connectionBendPoints.containsKey(key) && this.connectionBendPoints.get(key) != null) {
            return new DiagramLayoutPersistenceService.DiagramConnectionInfo(this.connectionBendPoints.get(key));
        }
        return null;
    }

    private void write(DiagramConnectionPart connPart) {
        Transition transition = (Transition)connPart.getLocalModelElement().nearest(Transition.class);
        if (!transition.disposed()) {
            if (this.isConnectionLayoutChanged(connPart)) {
                this.removeBendpointListeners();
                this.writeTransitionBendPoints(transition, connPart);
                this.addBendpointListeners();
            }
            this.refreshDirtyState();
        }
    }

    public void dispose() {
        if (this.diagramPartListener != null) {
            this.part().detach(this.diagramPartListener);
        }
        this.removeWorkflowNodeListeners();
        this.removeBendpointListeners();
        super.dispose();
    }

    private void load() {
        SapphireDiagramEditorPagePart part = this.part();
        part.setGridVisible(((WorkflowDefinitionEditor)((Object)part.adapt(WorkflowDefinitionEditor.class))).isGridVisible());
        part.setShowGuides(((WorkflowDefinitionEditor)((Object)part.adapt(WorkflowDefinitionEditor.class))).isShowGuides());
        ConnectionService connService = (ConnectionService)part.service(ConnectionService.class);
        for (WorkflowNode workflowNode : this.definition().getDiagramNodes()) {
            DiagramNodePart nodePart = part.getDiagramNodePart((Element)workflowNode);
            if (nodePart == null) continue;
            WorkflowNodeMetadata metadata = (WorkflowNodeMetadata)workflowNode.getMetadata().content(false);
            DiagramNodeBounds bounds = new DiagramNodeBounds(((Integer)metadata.getPosition().getX().content()).intValue(), ((Integer)metadata.getPosition().getY().content()).intValue(), -1, -1, false, false);
            nodePart.setNodeBounds(bounds);
            ListFactory transitionsList = ListFactory.start();
            for (Transition transition : ((CanTransition)workflowNode.nearest(CanTransition.class)).getTransitions()) {
                transitionsList.add((Object)transition);
            }
            List transitions = transitionsList.result();
            for (Transition transition : transitions) {
                Position labelPosition;
                TransitionMetadata transitionMetadata;
                DiagramConnectionPart connPart = this.getConnectionPart(connService, (Element)transition);
                if (connPart == null || (transitionMetadata = this.getTransitionMetadata(transition, metadata)) == null) continue;
                ElementList bendpoints = transitionMetadata.getBendpoints();
                if (bendpoints.size() > 0) {
                    int index = 0;
                    for (ConnectionBendpoint bendpoint : bendpoints) {
                        connPart.addBendpoint(index++, ((Integer)bendpoint.getX().content()).intValue(), ((Integer)bendpoint.getY().content()).intValue());
                    }
                }
                if ((labelPosition = transitionMetadata.getLabelLocation()) == null) continue;
                connPart.setLabelPosition(new Point(((Integer)labelPosition.getX().content()).intValue(), ((Integer)labelPosition.getY().content()).intValue()));
            }
        }
        for (DiagramConnectionPart connPart : connService.list()) {
            connPart.attach(this.connectionPartListener);
        }
    }

    private void handleNodeLayoutChange(WorkflowNode workflowNode) {
        DiagramNodePart nodePart = this.part().getDiagramNodePart((Element)workflowNode);
        WorkflowNodeMetadata metadata = (WorkflowNodeMetadata)workflowNode.getMetadata().content();
        DiagramNodeBounds nodeBounds = new DiagramNodeBounds(((Integer)metadata.getPosition().getX().content()).intValue(), ((Integer)metadata.getPosition().getY().content()).intValue());
        nodePart.setNodeBounds(nodeBounds);
    }

    private void handleConnectionBendpointChange(Transition transition) {
        ConnectionService connService = (ConnectionService)this.part().service(ConnectionService.class);
        DiagramConnectionPart connPart = this.getConnectionPart(connService, (Element)transition);
        if (connPart != null) {
            ArrayList<Point> bendpoints = new ArrayList<Point>();
            WorkflowNodeMetadata metadata = (WorkflowNodeMetadata)((WorkflowNode)transition.nearest(WorkflowNode.class)).getMetadata().content(false);
            TransitionMetadata transitionMetadata = this.getTransitionMetadata(transition, metadata);
            for (ConnectionBendpoint bendpoint : transitionMetadata.getBendpoints()) {
                bendpoints.add(new Point(((Integer)bendpoint.getX().content()).intValue(), ((Integer)bendpoint.getY().content()).intValue()));
            }
            connPart.resetBendpoints(bendpoints);
        }
    }

    private void handleWorkflowNodeMetaChange(WorkflowNodeMetadata workflowNodeMetadata) {
        WorkflowNode workflowNode = (WorkflowNode)workflowNodeMetadata.nearest(WorkflowNode.class);
        if (workflowNode == null) {
            return;
        }
        DiagramNodePart nodePart = this.part().getDiagramNodePart((Element)workflowNode);
        if (nodePart != null && (nodePart.getNodeBounds().getX() != ((Integer)workflowNodeMetadata.getPosition().getX().content()).intValue() || nodePart.getNodeBounds().getY() != ((Integer)workflowNodeMetadata.getPosition().getY().content()).intValue())) {
            nodePart.setNodeBounds(new DiagramNodeBounds(((Integer)workflowNodeMetadata.getPosition().getX().content()).intValue(), ((Integer)workflowNodeMetadata.getPosition().getY().content()).intValue()));
        }
        ConnectionService connService = (ConnectionService)this.part().service(ConnectionService.class);
        if (workflowNode instanceof CanTransition) {
            ElementList transitions = ((CanTransition)workflowNode).getTransitions();
            for (Transition transition : transitions) {
                TransitionMetadata transitionMetadata;
                ArrayList<Point> bendpoints = new ArrayList<Point>();
                DiagramConnectionPart connPart = this.getConnectionPart(connService, (Element)transition);
                if (connPart == null || (transitionMetadata = this.getTransitionMetadata(transition, workflowNodeMetadata)) == null) continue;
                for (ConnectionBendpoint bendpoint : transitionMetadata.getBendpoints()) {
                    bendpoints.add(new Point(((Integer)bendpoint.getX().content()).intValue(), ((Integer)bendpoint.getY().content()).intValue()));
                }
                connPart.resetBendpoints(bendpoints);
            }
        }
    }

    private void addNodeToPersistenceCache(DiagramNodePart nodePart) {
        String nodeId = nodePart.getId();
        this.nodeBounds.put(nodeId, nodePart.getNodeBounds());
    }

    private void addConnectionToPersistenceCache(DiagramConnectionPart connPart) {
        ConnectionHashKey connKey = ConnectionHashKey.createKey((DiagramConnectionPart)connPart);
        this.connectionBendPoints.put(connKey, connPart.getBendpoints());
        if (connPart.getLabelPosition() != null) {
            this.connectionLabelPositions.put(connKey, new Point(connPart.getLabelPosition()));
        } else {
            this.connectionLabelPositions.put(connKey, new Point(-1, -1));
        }
    }

    private void addDiagramPartListener() {
        this.diagramPartListener = new Listener(){

            public void handle(Event event) {
                if (event instanceof DiagramNodeEvent) {
                    WorkflowDefinitionLayoutPersistenceService.this.handleDiagramNodeEvent((DiagramNodeEvent)event);
                } else if (event instanceof DiagramPageEvent) {
                    WorkflowDefinitionLayoutPersistenceService.this.handleDiagramPageEvent((DiagramPageEvent)event);
                } else if (event instanceof SapphireDiagramEditorPagePart.PreAutoLayoutEvent) {
                    WorkflowDefinitionLayoutPersistenceService.this.autoLayout = true;
                } else if (event instanceof SapphireDiagramEditorPagePart.PostAutoLayoutEvent) {
                    WorkflowDefinitionLayoutPersistenceService.this.autoLayout = false;
                } else if (event instanceof ConnectionAddEvent) {
                    WorkflowDefinitionLayoutPersistenceService.this.handleConnectionAddEvent((ConnectionAddEvent)event);
                } else if (event instanceof ConnectionDeleteEvent) {
                    WorkflowDefinitionLayoutPersistenceService.this.handleConnectionDeleteEvent((ConnectionDeleteEvent)event);
                }
            }
        };
        this.part().attach(this.diagramPartListener);
    }

    private void handleDiagramNodeEvent(DiagramNodeEvent event) {
        DiagramNodePart nodePart = event.part();
        if (event instanceof DiagramNodeAddEvent) {
            this.read(nodePart);
        } else if (event instanceof DiagramNodeDeleteEvent) {
            this.refreshDirtyState();
        } else if (event instanceof DiagramNodeMoveEvent) {
            DiagramNodeBounds nodeBounds = nodePart.getNodeBounds();
            if (nodeBounds.isAutoLayout()) {
                this.addNodeToPersistenceCache(nodePart);
                this.refreshDirtyState();
            } else if (!nodeBounds.isDefaultPosition()) {
                this.write(event.part());
            }
        }
    }

    protected void handleConnectionAddEvent(ConnectionAddEvent event) {
        DiagramConnectionPart connPart = event.part();
        connPart.attach(this.connectionPartListener);
        DiagramLayoutPersistenceService.DiagramConnectionInfo connectionInfo = this.read(connPart);
        if (connectionInfo != null) {
            connPart.resetBendpoints(connectionInfo.getBendPoints());
        }
    }

    protected void handleConnectionDeleteEvent(ConnectionDeleteEvent event) {
        this.refreshDirtyState();
    }

    private void handleDiagramPageEvent(DiagramPageEvent event) {
        SapphireDiagramEditorPagePart diagramPart = (SapphireDiagramEditorPagePart)event.part().adapt(SapphireDiagramEditorPagePart.class);
        switch (event.getDiagramPageEventType()) {
            case GridStateChange: {
                this.setGridVisible(diagramPart.isGridVisible());
                break;
            }
            case GuideStateChange: {
                this.setGuidesVisible(diagramPart.isShowGuides());
                break;
            }
            case DiagramSave: {
                this.doSave();
                break;
            }
        }
    }

    private void addModelListeners() {
        this.workflowNodeMetadataListener = new WorkflowNodeMetadataListener();
        this.addWorkflowNodeListeners();
        this.addBendpointListeners();
        this.addWorkflowNodteMetadataListeners();
    }

    private void addWorkflowNodteMetadataListeners() {
        if (this.workflowNodeMetadataListener != null) {
            this.definition().attach(this.workflowNodeMetadataListener, "/*/Metadata");
        }
    }

    private void addBendpointListeners() {
        if (this.bendpointListener != null) {
            this.definition().attach(this.bendpointListener, "/*/Metadata/TransitionsMetadata/Bendpoints/*");
        }
    }

    private void addWorkflowNodeListeners() {
        if (this.workflowNodeListener != null) {
            this.definition().attach(this.workflowNodeListener, "/*/Metadata/Position/*");
        }
    }

    private void writeWorkflowNodeMetaDataToBounds(WorkflowNodeMetadata metadata, DiagramNodePart nodePart) {
        nodePart.setNodeBounds(((Integer)metadata.getPosition().getX().content()).intValue(), ((Integer)metadata.getPosition().getY().content()).intValue());
    }

    private void writeWorkflowNodeBoundsToMetaData(WorkflowNode workflowNode, DiagramNodePart nodePart) {
        DiagramNodeBounds bounds = nodePart.getNodeBounds();
        WorkflowNodeMetadata metadata = (WorkflowNodeMetadata)workflowNode.getMetadata().content(true);
        if (bounds.getX() != ((Integer)metadata.getPosition().getX().content()).intValue()) {
            metadata.getPosition().setX(Integer.valueOf(bounds.getX()));
        }
        if (bounds.getY() != ((Integer)metadata.getPosition().getY().content()).intValue()) {
            metadata.getPosition().setY(Integer.valueOf(bounds.getY()));
        }
    }

    private void writeTransitionBendPoints(Transition transition, DiagramConnectionPart connPart) {
        WorkflowNodeMetadata metadata = (WorkflowNodeMetadata)((WorkflowNode)transition.nearest(WorkflowNode.class)).getMetadata().content(true);
        TransitionMetadata transitionMetadata = this.getTransitionMetadata(transition, metadata, true);
        transitionMetadata.setName((String)transition.getName().content());
        ElementList bendpointsInMetadataList = transitionMetadata.getBendpoints();
        int bendpointsInMetadataSize = bendpointsInMetadataList.size();
        List bendpointsInPartList = connPart.getBendpoints();
        int bendpointsInPartSize = bendpointsInPartList.size();
        int i = 0;
        int n = Math.min(bendpointsInMetadataSize, bendpointsInPartSize);
        while (i < n) {
            ConnectionBendpoint bendpointInMetadata = (ConnectionBendpoint)bendpointsInMetadataList.get(i);
            Point bendpointInPart = (Point)bendpointsInPartList.get(i);
            if (((Integer)bendpointInMetadata.getX().content()).intValue() != bendpointInPart.getX()) {
                bendpointInMetadata.setX(Integer.valueOf(bendpointInPart.getX()));
            }
            if (((Integer)bendpointInMetadata.getY().content()).intValue() != bendpointInPart.getY()) {
                bendpointInMetadata.setY(Integer.valueOf(bendpointInPart.getY()));
            }
            ++i;
        }
        if (bendpointsInMetadataSize < bendpointsInPartSize) {
            i = bendpointsInMetadataSize;
            while (i < bendpointsInPartSize) {
                ConnectionBendpoint bendpointInMetadata = (ConnectionBendpoint)bendpointsInMetadataList.insert();
                Point bendpointInPart = (Point)bendpointsInPartList.get(i);
                bendpointInMetadata.setX(Integer.valueOf(bendpointInPart.getX()));
                bendpointInMetadata.setY(Integer.valueOf(bendpointInPart.getY()));
                ++i;
            }
        } else if (bendpointsInMetadataSize > bendpointsInPartSize) {
            i = bendpointsInMetadataSize - 1;
            while (i >= bendpointsInPartSize) {
                bendpointsInMetadataList.remove(i);
                --i;
            }
        }
        if (connPart.getLabelPosition() != null && !connPart.getLabelPosition().equals((Object)KaleoModelUtil.DEFAULT_POINT)) {
            transitionMetadata.getLabelLocation().setX(Integer.valueOf(connPart.getLabelPosition().getX()));
            transitionMetadata.getLabelLocation().setY(Integer.valueOf(connPart.getLabelPosition().getY()));
        }
    }

    private void removeWorkflowNodeListeners() {
        if (this.workflowNodeListener != null) {
            this.definition().detach(this.workflowNodeListener, "/*/Metadata/Position/*");
        }
    }

    private void removeBendpointListeners() {
        if (this.bendpointListener != null) {
            this.definition().detach(this.bendpointListener, "/*/Metadata/TransitionsMetadata/Bendpoints/*");
        }
    }

    private void doSave() {
        this.refreshPersistedPartsCache();
        this.removeWorkflowNodeListeners();
        this.removeBendpointListeners();
        for (DiagramNodePart nodePart : this.part().getNodes()) {
            WorkflowNode workflowNode = (WorkflowNode)nodePart.getLocalModelElement();
            if (workflowNode.disposed()) continue;
            this.writeWorkflowNodeBoundsToMetaData(workflowNode, nodePart);
            DiagramNodeBounds nodePartBounds = nodePart.getNodeBounds();
            nodePartBounds.setAutoLayout(false);
            nodePart.setNodeBounds(nodePartBounds);
        }
        for (DiagramConnectionPart connPart : this.part().getConnections()) {
            Transition transition = (Transition)connPart.getLocalModelElement();
            if (transition.disposed()) continue;
            this.writeTransitionBendPoints(transition, connPart);
        }
        this.addWorkflowNodeListeners();
        this.addBendpointListeners();
    }

    private boolean isNodeLayoutChanged(DiagramNodePart nodePart) {
        DiagramNodeBounds newBounds = nodePart.getNodeBounds();
        boolean changed = false;
        String nodeId = nodePart.getId();
        if (this.nodeBounds.containsKey(nodeId)) {
            DiagramNodeBounds oldBounds = this.nodeBounds.get(nodeId);
            if (!newBounds.equals((Object)oldBounds)) {
                changed = true;
            }
        } else {
            changed = true;
        }
        return changed;
    }

    private boolean isConnectionLayoutChanged(DiagramConnectionPart connPart) {
        List bendpoints = connPart.getBendpoints();
        Point labelPosition = connPart.getLabelPosition();
        ConnectionHashKey key = ConnectionHashKey.createKey((DiagramConnectionPart)connPart);
        boolean changed = false;
        if (this.connectionBendPoints.containsKey(key)) {
            List<Point> oldBendpoints = this.connectionBendPoints.get(key);
            if (bendpoints.size() != oldBendpoints.size()) {
                changed = true;
            } else {
                int i = 0;
                while (i < bendpoints.size()) {
                    Point newPt = (Point)bendpoints.get(i);
                    Point oldPt = oldBendpoints.get(i);
                    if (newPt.getX() != oldPt.getX() || newPt.getY() != oldPt.getY()) {
                        changed = true;
                        break;
                    }
                    ++i;
                }
            }
            if (!bendpoints.equals(oldBendpoints)) {
                changed = true;
            }
        } else {
            changed = true;
        }
        if (!changed && this.connectionLabelPositions.containsKey(key)) {
            Point oldLabelPosition = this.connectionLabelPositions.get(key);
            if (labelPosition != null && !labelPosition.equals((Object)oldLabelPosition)) {
                changed = true;
            }
        } else {
            changed = true;
        }
        return changed;
    }

    private boolean isDiagramLayoutChanged() {
        boolean changed = false;
        SapphireDiagramEditorPagePart part = this.part();
        if (!part.disposed()) {
            ConnectionService connService = (ConnectionService)part.service(ConnectionService.class);
            for (DiagramNodePart nodePart : part.getNodes()) {
                if (nodePart.getLocalModelElement().disposed() || !this.isNodeLayoutChanged(nodePart)) continue;
                changed = true;
                break;
            }
            for (DiagramConnectionPart connPart : connService.list()) {
                if (connPart.getLocalModelElement().disposed() || !this.isConnectionLayoutChanged(connPart)) continue;
                changed = true;
                break;
            }
        }
        return changed;
    }

    public boolean dirty() {
        return this.dirty;
    }

    private void refreshDirtyState() {
        boolean after = this.isDiagramLayoutChanged();
        if (this.dirty != after) {
            boolean before = this.dirty;
            this.dirty = after;
            this.broadcast((Event)new DiagramLayoutPersistenceService.DirtyStateEvent((Service)this, before, after));
        }
    }

    private void refreshPersistedPartsCache() {
        this.nodeBounds.clear();
        this.connectionBendPoints.clear();
        ConnectionService connService = (ConnectionService)this.part().service(ConnectionService.class);
        for (DiagramConnectionPart connPart : connService.list()) {
            this.addConnectionToPersistenceCache(connPart);
        }
        for (DiagramNodePart nodePart : this.part().getNodes()) {
            this.addNodeToPersistenceCache(nodePart);
        }
    }

    private DiagramConnectionPart getConnectionPart(ConnectionService connService, Element element) {
        for (DiagramConnectionPart connPart : connService.list()) {
            if (connPart.getLocalModelElement() != element) continue;
            return connPart;
        }
        return null;
    }

    private TransitionMetadata getTransitionMetadata(Transition transition, WorkflowNodeMetadata nodeMetadata) {
        return this.getTransitionMetadata(transition, nodeMetadata, false);
    }

    private TransitionMetadata getTransitionMetadata(Transition transition, WorkflowNodeMetadata nodeMetadata, boolean createIfNecessary) {
        TransitionMetadata retval = null;
        ElementList transitionsData = nodeMetadata.getTransitionsMetadata();
        for (TransitionMetadata transitionData : transitionsData) {
            if (transition.getName().content() == null || !((String)transition.getName().content()).equals(transitionData.getName().content())) continue;
            retval = transitionData;
            break;
        }
        if (retval == null && createIfNecessary) {
            retval = (TransitionMetadata)nodeMetadata.getTransitionsMetadata().insert();
        }
        return retval;
    }

    private SapphireDiagramEditorPagePart part() {
        return (SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class);
    }

    private WorkflowDefinition definition() {
        return (WorkflowDefinition)this.part().getLocalModelElement().nearest(WorkflowDefinition.class);
    }

    class BendpointListener
    extends FilteredListener<PropertyEvent> {
        BendpointListener() {
        }

        public void handleTypedEvent(PropertyEvent event) {
            Transition transition;
            if (event != null && event.property() != null && (transition = (Transition)event.property().nearest(Transition.class)) != null) {
                WorkflowDefinitionLayoutPersistenceService.this.handleConnectionBendpointChange(transition);
            }
        }
    }

    class WorkflowNodeListener
    extends FilteredListener<PropertyEvent> {
        WorkflowNodeListener() {
        }

        public void handleTypedEvent(PropertyEvent event) {
            WorkflowNode diagramNode;
            if (event != null && event.property() != null && (diagramNode = (WorkflowNode)event.property().nearest(WorkflowNode.class)) != null) {
                WorkflowDefinitionLayoutPersistenceService.this.handleNodeLayoutChange(diagramNode);
            }
        }
    }

    class WorkflowNodeMetadataListener
    extends FilteredListener<PropertyEvent> {
        WorkflowNodeMetadataListener() {
        }

        protected void handleTypedEvent(PropertyEvent event) {
            if (event != null && event.property() != null && event.property().element() instanceof WorkflowNodeMetadata) {
                WorkflowDefinitionLayoutPersistenceService.this.handleWorkflowNodeMetaChange((WorkflowNodeMetadata)event.property().element());
            }
        }
    }
}

