/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.kaleo.ui.wizard;

import com.liferay.ide.kaleo.core.model.CanTransition;
import com.liferay.ide.kaleo.core.model.Condition;
import com.liferay.ide.kaleo.core.model.Fork;
import com.liferay.ide.kaleo.core.model.Join;
import com.liferay.ide.kaleo.core.model.JoinXor;
import com.liferay.ide.kaleo.core.model.Node;
import com.liferay.ide.kaleo.core.model.State;
import com.liferay.ide.kaleo.core.model.Task;
import com.liferay.ide.kaleo.core.model.Transition;
import com.liferay.ide.kaleo.core.model.WorkflowDefinition;
import com.liferay.ide.kaleo.core.op.ChooseDiagramNode;
import com.liferay.ide.kaleo.core.op.NewNodeOp;
import com.liferay.ide.kaleo.ui.diagram.NewNodeAddActionHandler;
import com.liferay.ide.ui.util.UIUtil;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.forms.swt.SapphireWizard;

public class NewNodeOpWizard
extends SapphireWizard<NewNodeOp> {
    private NewNodeAddActionHandler actionHandler;
    private Presentation context;
    private DiagramNodePart diagramNodePart;

    public NewNodeOpWizard(NewNodeOp modelElement, String wizardId, NewNodeAddActionHandler actionHandler, Presentation context) {
        super((Element)modelElement, DefinitionLoader.context(NewNodeOpWizard.class).sdef("WorkflowDefinitionWizards").wizard(wizardId));
        this.actionHandler = actionHandler;
        this.context = context;
    }

    protected Status performFinish(ProgressMonitor monitor) {
        final Object[] diagramNode = new Object[1];
        monitor.beginTask("Creating new node", 2);
        UIUtil.sync((Runnable)new Runnable(){

            @Override
            public void run() {
                diagramNode[0] = NewNodeOpWizard.this.actionHandler.insertDiagramPart(NewNodeOpWizard.this.context, false);
            }
        });
        monitor.worked(1);
        if (diagramNode[0] instanceof DiagramNodePart) {
            this.diagramNodePart = (DiagramNodePart)diagramNode[0];
            UIUtil.sync((Runnable)new Runnable(){

                @Override
                public void run() {
                    NewNodeOpWizard.this.performPostDiagramNodeAdded();
                }
            });
            monitor.worked(1);
        }
        return Status.createOkStatus();
    }

    protected void performPostDiagramNodeAdded() {
        NewNodeOp newNodeOp = (NewNodeOp)((NewNodeOp)this.element()).nearest(NewNodeOp.class);
        CanTransition newNode = (CanTransition)newNodeOp.adapt(CanTransition.class);
        CanTransition node = (CanTransition)this.diagramNodePart.getLocalModelElement().nearest(CanTransition.class);
        WorkflowDefinition workflowDefinition = (WorkflowDefinition)node.nearest(WorkflowDefinition.class);
        if (newNode != null && node != null) {
            node.setName((String)newNode.getName().content());
            if (newNodeOp.getConnectedNodes().size() > 0) {
                for (Node diagramNode : newNodeOp.getConnectedNodes()) {
                    String diagramNodeName = (String)diagramNode.getName().content(true);
                    if (diagramNode instanceof NewNodeOp.ConditionForOp) {
                        ((Condition)workflowDefinition.getConditions().insert()).setName(diagramNodeName);
                    } else if (diagramNode instanceof NewNodeOp.ForkForOp) {
                        ((Fork)workflowDefinition.getForks().insert()).setName(diagramNodeName);
                    } else if (diagramNode instanceof NewNodeOp.JoinForOp) {
                        ((Join)workflowDefinition.getJoins().insert()).setName(diagramNodeName);
                    } else if (diagramNode instanceof NewNodeOp.JoinXorForOp) {
                        ((JoinXor)workflowDefinition.getJoinXors().insert()).setName(diagramNodeName);
                    } else if (diagramNode instanceof NewNodeOp.StateForOp) {
                        ((State)workflowDefinition.getStates().insert()).setName(diagramNodeName);
                    } else if (diagramNode instanceof NewNodeOp.TaskForOp) {
                        ((Task)workflowDefinition.getTasks().insert()).setName(diagramNodeName);
                    }
                    if (diagramNode instanceof ChooseDiagramNode || node instanceof State || node instanceof Task || node instanceof Condition || node instanceof Fork) {
                        Transition newTransition = (Transition)node.getTransitions().insert();
                        newTransition.setName(diagramNodeName);
                        newTransition.setTarget(diagramNodeName);
                        continue;
                    }
                    Transition joinTransition = (Transition)((CanTransition)diagramNode.nearest(CanTransition.class)).getTransitions().insert();
                    joinTransition.setName((String)node.getName().content());
                    joinTransition.setTarget((String)node.getName().content());
                }
            }
        }
        this.actionHandler.postDiagramNodePartAdded((NewNodeOp)this.element(), newNode, node);
    }
}

