/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.liferay.blade.upgrade.liferay70.apichanges;

import com.liferay.blade.api.AutoMigrator;
import com.liferay.blade.api.FileMigrator;
import com.liferay.blade.upgrade.liferay70.ImportStatementMigrator;

import org.osgi.service.component.annotations.Component;

@Component(
	property = {
		"file.extensions=java,jsp,jspf",
		"problem.title=Classes in portal-service.jar moved",
		"problem.summary=Many classes from former portal-service.jar from Liferay Portal 6.x have been moved into application and framework API modules.",
		"problem.tickets=",
		"problem.section=#classes-in-portal-service-jar-moved",
		"auto.correct=import",
		"implName=PortalServiceImports"
	},
	service = {
		AutoMigrator.class,
		FileMigrator.class
	}
)
public class PortalServiceImports extends ImportStatementMigrator {

	private final static String[] IMPORTS = new String[] {
		"com.liferay.portal.kernel.mobile.device.rulegroup.action.ActionHandler",
		"com.liferay.portal.kernel.mobile.device.rulegroup.ActionHandlerManager",
		"com.liferay.portal.kernel.mobile.device.rulegroup.ActionHandlerManagerUtil",
		"com.liferay.portlet.mobiledevicerules.ActionTypeException",
		"com.liferay.portal.kernel.search.AlternateKeywordQueryHitsProcessor",
		"com.liferay.portlet.journal.ArticleContentException",
		"com.liferay.portlet.journal.ArticleContentSizeException",
		"com.liferay.portlet.journal.util.comparator.ArticleCreateDateComparator",
		"com.liferay.portlet.journal.util.comparator.ArticleDisplayDateComparator",
		"com.liferay.portlet.journal.ArticleDisplayDateException",
		"com.liferay.portlet.journal.ArticleExpirationDateException",
		"com.liferay.portlet.journal.util.comparator.ArticleIDComparator",
		"com.liferay.portlet.journal.ArticleIdException",
		"com.liferay.portlet.journal.util.comparator.ArticleModifiedDateComparator",
		"com.liferay.portlet.journal.util.comparator.ArticleReviewDateComparator",
		"com.liferay.portlet.journal.ArticleReviewDateException",
		"com.liferay.portlet.journal.ArticleSmallImageNameException",
		"com.liferay.portlet.journal.ArticleSmallImageSizeException",
		"com.liferay.portlet.journal.util.comparator.ArticleTitleComparator",
		"com.liferay.portlet.journal.ArticleTitleException",
		"com.liferay.portlet.journal.util.comparator.ArticleVersionComparator",
		"com.liferay.portlet.journal.ArticleVersionException",
		"com.liferay.portlet.assetpublisher.util.AssetPublisherUtil",
		"com.liferay.portal.kernel.audit.AuditMessageProcessor",
		"com.liferay.portal.kernel.monitoring.statistics.AverageStatistics",
		"com.liferay.portal.service.BackgroundTaskLocalService",
		"com.liferay.portal.service.BackgroundTaskLocalServiceUtil",
		"com.liferay.portal.service.BackgroundTaskLocalServiceWrapper",
		"com.liferay.portal.model.BackgroundTaskModel",
		"com.liferay.portal.service.persistence.BackgroundTaskPersistence",
		"com.liferay.portal.service.BackgroundTaskService",
		"com.liferay.portal.service.BackgroundTaskServiceUtil",
		"com.liferay.portal.service.BackgroundTaskServiceWrapper",
		"com.liferay.portal.model.BackgroundTaskSoap",
		"com.liferay.portal.service.persistence.BackgroundTaskUtil",
		"com.liferay.portal.model.BackgroundTaskWrapper",
		"com.liferay.portal.kernel.repository.cmis.BaseCmisRepository",
		"com.liferay.portal.kernel.repository.cmis.search.BaseCmisSearchQueryBuilder",
		"com.liferay.portlet.dynamicdatalists.util.BaseDDLExporter",
		"com.liferay.portlet.dynamicdatamapping.util.BaseDDMDisplay",
		"com.liferay.portlet.dynamicdatamapping.storage.BaseFieldRenderer",
		"com.liferay.portal.kernel.scripting.BaseScriptingExecutor",
		"com.liferay.portal.kernel.monitoring.statistics.BaseStatistics",
		"com.liferay.portlet.dynamicdatamapping.storage.BaseStorageAdapter",
		"com.liferay.portlet.shopping.BillingCityException",
		"com.liferay.portlet.shopping.BillingCountryException",
		"com.liferay.portlet.shopping.BillingEmailAddressException",
		"com.liferay.portlet.shopping.BillingFirstNameException",
		"com.liferay.portlet.shopping.BillingLastNameException",
		"com.liferay.portlet.shopping.BillingPhoneException",
		"com.liferay.portlet.shopping.BillingStateException",
		"com.liferay.portlet.shopping.BillingStreetException",
		"com.liferay.portlet.shopping.BillingZipException",
		"com.liferay.portal.kernel.cache.BlockingPortalCache",
		"com.liferay.portlet.bookmarks.model.BookmarksEntry",
		"com.liferay.portlet.bookmarks.service.persistence.BookmarksEntryFinder",
		"com.liferay.portlet.bookmarks.service.BookmarksEntryLocalService",
		"com.liferay.portlet.bookmarks.service.BookmarksEntryLocalServiceUtil",
		"com.liferay.portlet.bookmarks.service.BookmarksEntryLocalServiceWrapper",
		"com.liferay.portlet.bookmarks.model.BookmarksEntryModel",
		"com.liferay.portlet.bookmarks.service.persistence.BookmarksEntryPersistence",
		"com.liferay.portlet.bookmarks.service.BookmarksEntryService",
		"com.liferay.portlet.bookmarks.service.BookmarksEntryServiceUtil",
		"com.liferay.portlet.bookmarks.service.BookmarksEntryServiceWrapper",
		"com.liferay.portlet.bookmarks.model.BookmarksEntrySoap",
		"com.liferay.portlet.bookmarks.service.persistence.BookmarksEntryUtil",
		"com.liferay.portlet.bookmarks.model.BookmarksEntryWrapper",
		"com.liferay.portlet.bookmarks.model.BookmarksFolder",
		"com.liferay.portlet.bookmarks.model.BookmarksFolderConstants",
		"com.liferay.portlet.bookmarks.service.persistence.BookmarksFolderFinder",
		"com.liferay.portlet.bookmarks.service.BookmarksFolderLocalService",
		"com.liferay.portlet.bookmarks.service.BookmarksFolderLocalServiceUtil",
		"com.liferay.portlet.bookmarks.service.BookmarksFolderLocalServiceWrapper",
		"com.liferay.portlet.bookmarks.model.BookmarksFolderModel",
		"com.liferay.portlet.bookmarks.service.persistence.BookmarksFolderPersistence",
		"com.liferay.portlet.bookmarks.service.BookmarksFolderService",
		"com.liferay.portlet.bookmarks.service.BookmarksFolderServiceUtil",
		"com.liferay.portlet.bookmarks.service.BookmarksFolderServiceWrapper",
		"com.liferay.portlet.bookmarks.model.BookmarksFolderSoap",
		"com.liferay.portlet.bookmarks.service.persistence.BookmarksFolderUtil",
		"com.liferay.portlet.bookmarks.model.BookmarksFolderWrapper",
		"com.liferay.portal.kernel.bi.reporting.ByteArrayReportResultContainer",
		"com.liferay.portlet.shopping.CCExpirationException",
		"com.liferay.portlet.shopping.CCNameException",
		"com.liferay.portlet.shopping.CCNumberException",
		"com.liferay.portlet.shopping.CCTypeException",
		"com.liferay.portal.kernel.repository.cmis.search.CMISBetweenExpression",
		"com.liferay.portal.kernel.repository.cmis.search.CMISConjunction",
		"com.liferay.portal.kernel.repository.cmis.search.CMISContainsExpression",
		"com.liferay.portal.kernel.repository.cmis.search.CMISContainsNotExpression",
		"com.liferay.portal.kernel.repository.cmis.search.CMISContainsValueExpression",
		"com.liferay.portal.kernel.repository.cmis.search.CMISCriterion",
		"com.liferay.portal.kernel.repository.cmis.search.CMISDisjunction",
		"com.liferay.portal.kernel.repository.cmis.search.CMISFullTextConjunction",
		"com.liferay.portal.kernel.repository.cmis.search.CMISInFolderExpression",
		"com.liferay.portal.kernel.repository.cmis.search.CMISInTreeExpression",
		"com.liferay.portal.kernel.repository.cmis.search.CMISJunction",
		"com.liferay.portal.kernel.repository.cmis.search.CMISNotExpression",
		"com.liferay.portal.kernel.repository.cmis.search.CMISParameterValueUtil",
		"com.liferay.portal.kernel.repository.cmis.CMISRepositoryHandler",
		"com.liferay.portal.kernel.repository.cmis.CMISRepositoryUtil",
		"com.liferay.portal.kernel.repository.cmis.search.CMISSearchQueryBuilder",
		"com.liferay.portal.kernel.repository.cmis.search.CMISSimpleExpression",
		"com.liferay.portal.kernel.repository.cmis.search.CMISSimpleExpressionOperator",
		"com.liferay.portlet.shopping.CartMinOrderException",
		"com.liferay.portlet.shopping.CartMinQuantityException",
		"com.liferay.portal.kernel.search.CollatedSpellCheckHitsProcessor",
		"com.liferay.portal.kernel.servlet.filters.compoundsessionid.CompoundSessionIdServletRequest",
		"com.liferay.portlet.dynamicdatamapping.storage.query.Condition",
		"com.liferay.portal.security.ldap.ContactConverterKeys",
		"com.liferay.portlet.dynamicdatamapping.ContentException",
		"com.liferay.portlet.dynamicdatamapping.ContentNameException",
		"com.liferay.portal.kernel.bi.reporting.ContextClassloaderReportDesignRetriever",
		"com.liferay.portal.kernel.monitoring.statistics.CountStatistics",
		"com.liferay.portlet.shopping.CouponActiveException",
		"com.liferay.portlet.shopping.CouponCodeException",
		"com.liferay.portlet.shopping.CouponDateException",
		"com.liferay.portlet.shopping.CouponDescriptionException",
		"com.liferay.portlet.shopping.CouponDiscountException",
		"com.liferay.portlet.shopping.CouponEndDateException",
		"com.liferay.portlet.shopping.CouponLimitCategoriesException",
		"com.liferay.portlet.shopping.CouponLimitSKUsException",
		"com.liferay.portlet.shopping.CouponMinimumOrderException",
		"com.liferay.portlet.shopping.CouponNameException",
		"com.liferay.portlet.shopping.CouponStartDateException",
		"com.liferay.portlet.dynamicdatalists.util.DDL",
		"com.liferay.portlet.dynamicdatalists.util.DDLExporter",
		"com.liferay.portlet.dynamicdatalists.util.DDLExporterFactory",
		"com.liferay.portlet.dynamicdatalists.model.DDLRecord",
		"com.liferay.portlet.dynamicdatalists.model.DDLRecordConstants",
		"com.liferay.portlet.dynamicdatalists.service.persistence.DDLRecordFinder",
		"com.liferay.portlet.dynamicdatalists.service.DDLRecordLocalService",
		"com.liferay.portlet.dynamicdatalists.service.DDLRecordLocalServiceUtil",
		"com.liferay.portlet.dynamicdatalists.service.DDLRecordLocalServiceWrapper",
		"com.liferay.portlet.dynamicdatalists.model.DDLRecordModel",
		"com.liferay.portlet.dynamicdatalists.service.persistence.DDLRecordPersistence",
		"com.liferay.portlet.dynamicdatalists.service.DDLRecordService",
		"com.liferay.portlet.dynamicdatalists.service.DDLRecordServiceUtil",
		"com.liferay.portlet.dynamicdatalists.service.DDLRecordServiceWrapper",
		"com.liferay.portlet.dynamicdatalists.model.DDLRecordSet",
		"com.liferay.portlet.dynamicdatalists.model.DDLRecordSetConstants",
		"com.liferay.portlet.dynamicdatalists.service.persistence.DDLRecordSetFinder",
		"com.liferay.portlet.dynamicdatalists.service.DDLRecordSetLocalService",
		"com.liferay.portlet.dynamicdatalists.service.DDLRecordSetLocalServiceUtil",
		"com.liferay.portlet.dynamicdatalists.service.DDLRecordSetLocalServiceWrapper",
		"com.liferay.portlet.dynamicdatalists.model.DDLRecordSetModel",
		"com.liferay.portlet.dynamicdatalists.service.persistence.DDLRecordSetPersistence",
		"com.liferay.portlet.dynamicdatalists.service.DDLRecordSetService",
		"com.liferay.portlet.dynamicdatalists.service.DDLRecordSetServiceUtil",
		"com.liferay.portlet.dynamicdatalists.service.DDLRecordSetServiceWrapper",
		"com.liferay.portlet.dynamicdatalists.model.DDLRecordSetSoap",
		"com.liferay.portlet.dynamicdatalists.service.persistence.DDLRecordSetUtil",
		"com.liferay.portlet.dynamicdatalists.model.DDLRecordSetWrapper",
		"com.liferay.portlet.dynamicdatalists.model.DDLRecordSoap",
		"com.liferay.portlet.dynamicdatalists.service.persistence.DDLRecordUtil",
		"com.liferay.portlet.dynamicdatalists.model.DDLRecordVersion",
		"com.liferay.portlet.dynamicdatalists.model.DDLRecordVersionModel",
		"com.liferay.portlet.dynamicdatalists.service.persistence.DDLRecordVersionPersistence",
		"com.liferay.portlet.dynamicdatalists.model.DDLRecordVersionSoap",
		"com.liferay.portlet.dynamicdatalists.service.persistence.DDLRecordVersionUtil",
		"com.liferay.portlet.dynamicdatalists.util.comparator.DDLRecordVersionVersionComparator",
		"com.liferay.portlet.dynamicdatalists.model.DDLRecordVersionWrapper",
		"com.liferay.portlet.dynamicdatalists.model.DDLRecordWrapper",
		"com.liferay.portlet.dynamicdatamapping.util.DDM",
		"com.liferay.portlet.dynamicdatamapping.model.DDMContent",
		"com.liferay.portlet.dynamicdatamapping.service.DDMContentLocalService",
		"com.liferay.portlet.dynamicdatamapping.service.DDMContentLocalServiceUtil",
		"com.liferay.portlet.dynamicdatamapping.service.DDMContentLocalServiceWrapper",
		"com.liferay.portlet.dynamicdatamapping.model.DDMContentModel",
		"com.liferay.portlet.dynamicdatamapping.service.persistence.DDMContentPersistence",
		"com.liferay.portlet.dynamicdatamapping.model.DDMContentSoap",
		"com.liferay.portlet.dynamicdatamapping.service.persistence.DDMContentUtil",
		"com.liferay.portlet.dynamicdatamapping.model.DDMContentWrapper",
		"com.liferay.portlet.dynamicdatamapping.util.DDMDisplay",
		"com.liferay.portlet.dynamicdatamapping.util.DDMDisplayRegistry",
		"com.liferay.portlet.dynamicdatamapping.util.DDMIndexer",
		"com.liferay.portlet.dynamicdatamapping.model.DDMStorageLink",
		"com.liferay.portlet.dynamicdatamapping.service.DDMStorageLinkLocalService",
		"com.liferay.portlet.dynamicdatamapping.service.DDMStorageLinkLocalServiceUtil",
		"com.liferay.portlet.dynamicdatamapping.service.DDMStorageLinkLocalServiceWrapper",
		"com.liferay.portlet.dynamicdatamapping.model.DDMStorageLinkModel",
		"com.liferay.portlet.dynamicdatamapping.service.persistence.DDMStorageLinkPersistence",
		"com.liferay.portlet.dynamicdatamapping.model.DDMStorageLinkSoap",
		"com.liferay.portlet.dynamicdatamapping.service.persistence.DDMStorageLinkUtil",
		"com.liferay.portlet.dynamicdatamapping.model.DDMStorageLinkWrapper",
		"com.liferay.portlet.dynamicdatamapping.model.DDMStructureConstants",
		"com.liferay.portlet.dynamicdatamapping.service.persistence.DDMStructureFinder",
		"com.liferay.portlet.dynamicdatamapping.service.DDMStructureLinkLocalService",
		"com.liferay.portlet.dynamicdatamapping.service.DDMStructureLinkLocalServiceUtil",
		"com.liferay.portlet.dynamicdatamapping.service.DDMStructureLinkLocalServiceWrapper",
		"com.liferay.portlet.dynamicdatamapping.model.DDMStructureLinkModel",
		"com.liferay.portlet.dynamicdatamapping.service.persistence.DDMStructureLinkPersistence",
		"com.liferay.portlet.dynamicdatamapping.model.DDMStructureLinkSoap",
		"com.liferay.portlet.dynamicdatamapping.service.persistence.DDMStructureLinkUtil",
		"com.liferay.portlet.dynamicdatamapping.model.DDMStructureLinkWrapper",
		"com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalService",
		"com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil",
		"com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceWrapper",
		"com.liferay.portlet.dynamicdatamapping.model.DDMStructureModel",
		"com.liferay.portlet.dynamicdatamapping.service.persistence.DDMStructurePersistence",
		"com.liferay.portlet.dynamicdatamapping.service.DDMStructureService",
		"com.liferay.portlet.dynamicdatamapping.service.DDMStructureServiceUtil",
		"com.liferay.portlet.dynamicdatamapping.service.DDMStructureServiceWrapper",
		"com.liferay.portlet.dynamicdatamapping.model.DDMStructureSoap",
		"com.liferay.portlet.dynamicdatamapping.service.persistence.DDMStructureUtil",
		"com.liferay.portlet.dynamicdatamapping.model.DDMStructureWrapper",
		"com.liferay.portlet.dynamicdatamapping.model.DDMTemplateConstants",
		"com.liferay.portlet.dynamicdatamapping.service.persistence.DDMTemplateFinder",
		"com.liferay.portlet.dynamicdatamapping.util.DDMTemplateHelper",
		"com.liferay.portlet.dynamicdatamapping.service.DDMTemplateLocalService",
		"com.liferay.portlet.dynamicdatamapping.service.DDMTemplateLocalServiceUtil",
		"com.liferay.portlet.dynamicdatamapping.service.DDMTemplateLocalServiceWrapper",
		"com.liferay.portlet.dynamicdatamapping.model.DDMTemplateModel",
		"com.liferay.portlet.dynamicdatamapping.service.persistence.DDMTemplatePersistence",
		"com.liferay.portlet.dynamicdatamapping.service.DDMTemplateService",
		"com.liferay.portlet.dynamicdatamapping.service.DDMTemplateServiceUtil",
		"com.liferay.portlet.dynamicdatamapping.service.DDMTemplateServiceWrapper",
		"com.liferay.portlet.dynamicdatamapping.model.DDMTemplateSoap",
		"com.liferay.portlet.dynamicdatamapping.service.persistence.DDMTemplateUtil",
		"com.liferay.portlet.dynamicdatamapping.model.DDMTemplateWrapper",
		"com.liferay.portlet.dynamicdatamapping.util.DDMUtil",
		"com.liferay.portlet.dynamicdatamapping.util.DDMXML",
		"com.liferay.portal.security.ldap.DefaultAttributesTransformer",
		"com.liferay.portal.kernel.messaging.DefaultMessageBus",
		"com.liferay.portal.kernel.messaging.sender.DefaultSingleDestinationMessageSender",
		"com.liferay.portal.kernel.messaging.sender.DefaultSingleDestinationSynchronousMessageSender",
		"com.liferay.portal.kernel.messaging.sender.DefaultSynchronousMessageSender",
		"com.liferay.portal.kernel.messaging.jmx.DestinationStatisticsManager",
		"com.liferay.portal.kernel.messaging.jmx.DestinationStatisticsManagerMBean",
		"com.liferay.portal.kernel.messaging.sender.DirectSynchronousMessageSender",
		"com.liferay.portal.kernel.ldap.DummyContext",
		"com.liferay.portal.kernel.ldap.DummyDirContext",
		"com.liferay.portlet.journal.DuplicateArticleIdException",
		"com.liferay.portlet.journal.DuplicateArticleImageIdException",
		"com.liferay.portlet.shopping.DuplicateCouponCodeException",
		"com.liferay.portlet.journal.DuplicateFeedIdException",
		"com.liferay.portlet.shopping.DuplicateItemSKUException",
		"com.liferay.portal.kernel.ldap.DuplicateLDAPServerNameException",
		"com.liferay.portlet.wiki.DuplicateNodeNameException",
		"com.liferay.portlet.wiki.DuplicatePageException",
		"com.liferay.portlet.mobiledevicerules.DuplicateRuleGroupInstanceException",
		"com.liferay.portlet.polls.DuplicateVoteException",
		"com.liferay.portlet.bookmarks.util.comparator.EntryNameComparator",
		"com.liferay.portlet.bookmarks.util.comparator.EntryPriorityComparator",
		"com.liferay.portlet.bookmarks.util.comparator.EntryURLComparator",
		"com.liferay.portlet.bookmarks.util.comparator.EntryVisitsComparator",
		"com.liferay.portal.kernel.bi.rules.Fact",
		"com.liferay.portlet.journal.FeedContentFieldException",
		"com.liferay.portlet.journal.FeedIdException",
		"com.liferay.portlet.journal.FeedNameException",
		"com.liferay.portlet.journal.FeedTargetLayoutFriendlyUrlException",
		"com.liferay.portlet.journal.FeedTargetPortletIdException",
		"com.liferay.portlet.dynamicdatamapping.storage.FieldConstants",
		"com.liferay.portlet.dynamicdatamapping.storage.FieldRenderer",
		"com.liferay.portlet.dynamicdatamapping.storage.FieldRendererFactory",
		"com.liferay.portlet.dynamicdatamapping.storage.Fields",
		"com.liferay.portlet.flags.service.FlagsEntryService",
		"com.liferay.portlet.flags.service.FlagsEntryServiceUtil",
		"com.liferay.portlet.flags.service.FlagsEntryServiceWrapper",
		"com.liferay.portlet.flags.messaging.FlagsRequest",
		"com.liferay.portal.security.ldap.GroupConverterKeys",
		"com.liferay.portlet.wiki.ImportFilesException",
		"com.liferay.portlet.shopping.ItemLargeImageNameException",
		"com.liferay.portlet.shopping.ItemLargeImageSizeException",
		"com.liferay.portlet.shopping.ItemMediumImageNameException",
		"com.liferay.portlet.shopping.ItemMediumImageSizeException",
		"com.liferay.portlet.shopping.util.comparator.ItemMinQuantityComparator",
		"com.liferay.portlet.shopping.util.comparator.ItemNameComparator",
		"com.liferay.portlet.shopping.ItemNameException",
		"com.liferay.portlet.shopping.util.comparator.ItemPriceComparator",
		"com.liferay.portlet.shopping.util.comparator.ItemSKUComparator",
		"com.liferay.portlet.shopping.ItemSKUException",
		"com.liferay.portlet.shopping.ItemSmallImageNameException",
		"com.liferay.portlet.shopping.ItemSmallImageSizeException",
		"com.liferay.portal.kernel.scheduler.JobStateSerializeUtil",
		"com.liferay.portlet.journal.model.JournalArticle",
		"com.liferay.portlet.journal.model.JournalArticleConstants",
		"com.liferay.portlet.journal.model.JournalArticleDisplay",
		"com.liferay.portlet.journal.service.persistence.JournalArticleFinder",
		"com.liferay.portlet.journal.model.JournalArticleImage",
		"com.liferay.portlet.journal.service.JournalArticleImageLocalService",
		"com.liferay.portlet.journal.service.JournalArticleImageLocalServiceUtil",
		"com.liferay.portlet.journal.service.JournalArticleImageLocalServiceWrapper",
		"com.liferay.portlet.journal.model.JournalArticleImageModel",
		"com.liferay.portlet.journal.service.persistence.JournalArticleImagePersistence",
		"com.liferay.portlet.journal.model.JournalArticleImageSoap",
		"com.liferay.portlet.journal.service.persistence.JournalArticleImageUtil",
		"com.liferay.portlet.journal.model.JournalArticleImageWrapper",
		"com.liferay.portlet.journal.service.JournalArticleLocalService",
		"com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil",
		"com.liferay.portlet.journal.service.JournalArticleLocalServiceWrapper",
		"com.liferay.portlet.journal.model.JournalArticleModel",
		"com.liferay.portlet.journal.service.persistence.JournalArticlePersistence",
		"com.liferay.portlet.journal.model.JournalArticleResource",
		"com.liferay.portlet.journal.service.JournalArticleResourceLocalService",
		"com.liferay.portlet.journal.service.JournalArticleResourceLocalServiceUtil",
		"com.liferay.portlet.journal.service.JournalArticleResourceLocalServiceWrapper",
		"com.liferay.portlet.journal.model.JournalArticleResourceModel",
		"com.liferay.portlet.journal.service.persistence.JournalArticleResourcePersistence",
		"com.liferay.portlet.journal.model.JournalArticleResourceSoap",
		"com.liferay.portlet.journal.service.persistence.JournalArticleResourceUtil",
		"com.liferay.portlet.journal.model.JournalArticleResourceWrapper",
		"com.liferay.portlet.journal.service.JournalArticleService",
		"com.liferay.portlet.journal.service.JournalArticleServiceUtil",
		"com.liferay.portlet.journal.service.JournalArticleServiceWrapper",
		"com.liferay.portlet.journal.model.JournalArticleSoap",
		"com.liferay.portlet.journal.service.persistence.JournalArticleUtil",
		"com.liferay.portlet.journal.model.JournalArticleWrapper",
		"com.liferay.portlet.journalcontent.util.JournalContent",
		"com.liferay.portlet.journal.model.JournalContentSearch",
		"com.liferay.portlet.journal.service.JournalContentSearchLocalService",
		"com.liferay.portlet.journal.service.JournalContentSearchLocalServiceUtil",
		"com.liferay.portlet.journal.service.JournalContentSearchLocalServiceWrapper",
		"com.liferay.portlet.journal.model.JournalContentSearchModel",
		"com.liferay.portlet.journal.service.persistence.JournalContentSearchPersistence",
		"com.liferay.portlet.journal.model.JournalContentSearchSoap",
		"com.liferay.portlet.journal.service.persistence.JournalContentSearchUtil",
		"com.liferay.portlet.journal.model.JournalContentSearchWrapper",
		"com.liferay.portlet.journal.util.JournalConverter",
		"com.liferay.portlet.journal.model.JournalFeed",
		"com.liferay.portlet.journal.model.JournalFeedConstants",
		"com.liferay.portlet.journal.service.persistence.JournalFeedFinder",
		"com.liferay.portlet.journal.service.JournalFeedLocalService",
		"com.liferay.portlet.journal.service.JournalFeedLocalServiceUtil",
		"com.liferay.portlet.journal.service.JournalFeedLocalServiceWrapper",
		"com.liferay.portlet.journal.model.JournalFeedModel",
		"com.liferay.portlet.journal.service.persistence.JournalFeedPersistence",
		"com.liferay.portlet.journal.service.JournalFeedService",
		"com.liferay.portlet.journal.service.JournalFeedServiceUtil",
		"com.liferay.portlet.journal.service.JournalFeedServiceWrapper",
		"com.liferay.portlet.journal.model.JournalFeedSoap",
		"com.liferay.portlet.journal.service.persistence.JournalFeedUtil",
		"com.liferay.portlet.journal.model.JournalFeedWrapper",
		"com.liferay.portlet.journal.model.JournalFolder",
		"com.liferay.portlet.journal.service.persistence.JournalFolderFinder",
		"com.liferay.portlet.journal.service.JournalFolderLocalService",
		"com.liferay.portlet.journal.service.JournalFolderLocalServiceUtil",
		"com.liferay.portlet.journal.service.JournalFolderLocalServiceWrapper",
		"com.liferay.portlet.journal.model.JournalFolderModel",
		"com.liferay.portlet.journal.service.persistence.JournalFolderPersistence",
		"com.liferay.portlet.journal.service.JournalFolderService",
		"com.liferay.portlet.journal.service.JournalFolderServiceUtil",
		"com.liferay.portlet.journal.service.JournalFolderServiceWrapper",
		"com.liferay.portlet.journal.model.JournalFolderSoap",
		"com.liferay.portlet.journal.service.persistence.JournalFolderUtil",
		"com.liferay.portlet.journal.model.JournalFolderWrapper",
		"com.liferay.portlet.journal.model.JournalSearchConstants",
		"com.liferay.portlet.journal.model.JournalStructureConstants",
		"com.liferay.portal.kernel.ldap.LDAPFilterException",
		"com.liferay.portal.security.ldap.LDAPGroup",
		"com.liferay.portal.kernel.ldap.LDAPServerNameException",
		"com.liferay.portal.security.ldap.LDAPToPortalConverter",
		"com.liferay.portal.security.ldap.LDAPUser",
		"com.liferay.portal.kernel.ldap.LDAPUtil",
		"com.liferay.portal.service.LockLocalService",
		"com.liferay.portal.service.LockLocalServiceUtil",
		"com.liferay.portal.service.LockLocalServiceWrapper",
		"com.liferay.portal.model.LockModel",
		"com.liferay.portal.service.persistence.LockPersistence",
		"com.liferay.portal.model.LockSoap",
		"com.liferay.portal.service.persistence.LockUtil",
		"com.liferay.portal.model.LockWrapper",
		"com.liferay.portal.kernel.jmx.MBeanRegistry",
		"com.liferay.portlet.mobiledevicerules.model.MDRAction",
		"com.liferay.portlet.mobiledevicerules.service.MDRActionLocalService",
		"com.liferay.portlet.mobiledevicerules.service.MDRActionLocalServiceUtil",
		"com.liferay.portlet.mobiledevicerules.service.MDRActionLocalServiceWrapper",
		"com.liferay.portlet.mobiledevicerules.model.MDRActionModel",
		"com.liferay.portlet.mobiledevicerules.service.persistence.MDRActionPersistence",
		"com.liferay.portlet.mobiledevicerules.service.MDRActionService",
		"com.liferay.portlet.mobiledevicerules.service.MDRActionServiceUtil",
		"com.liferay.portlet.mobiledevicerules.service.MDRActionServiceWrapper",
		"com.liferay.portlet.mobiledevicerules.model.MDRActionSoap",
		"com.liferay.portlet.mobiledevicerules.service.persistence.MDRActionUtil",
		"com.liferay.portlet.mobiledevicerules.model.MDRActionWrapper",
		"com.liferay.portlet.mobiledevicerules.service.permission.MDRPermission",
		"com.liferay.portlet.mobiledevicerules.model.MDRRule",
		"com.liferay.portlet.mobiledevicerules.model.MDRRuleGroup",
		"com.liferay.portlet.mobiledevicerules.service.persistence.MDRRuleGroupFinder",
		"com.liferay.portlet.mobiledevicerules.service.MDRRuleGroupInstanceLocalService",
		"com.liferay.portlet.mobiledevicerules.service.MDRRuleGroupInstanceLocalServiceUtil",
		"com.liferay.portlet.mobiledevicerules.service.MDRRuleGroupInstanceLocalServiceWrapper",
		"com.liferay.portlet.mobiledevicerules.model.MDRRuleGroupInstanceModel",
		"com.liferay.portlet.mobiledevicerules.service.permission.MDRRuleGroupInstancePermission",
		"com.liferay.portlet.mobiledevicerules.service.persistence.MDRRuleGroupInstancePersistence",
		"com.liferay.portlet.mobiledevicerules.service.MDRRuleGroupInstanceService",
		"com.liferay.portlet.mobiledevicerules.service.MDRRuleGroupInstanceServiceUtil",
		"com.liferay.portlet.mobiledevicerules.service.MDRRuleGroupInstanceServiceWrapper",
		"com.liferay.portlet.mobiledevicerules.model.MDRRuleGroupInstanceSoap",
		"com.liferay.portlet.mobiledevicerules.service.persistence.MDRRuleGroupInstanceUtil",
		"com.liferay.portlet.mobiledevicerules.model.MDRRuleGroupInstanceWrapper",
		"com.liferay.portlet.mobiledevicerules.service.MDRRuleGroupLocalService",
		"com.liferay.portlet.mobiledevicerules.service.MDRRuleGroupLocalServiceUtil",
		"com.liferay.portlet.mobiledevicerules.service.MDRRuleGroupLocalServiceWrapper",
		"com.liferay.portlet.mobiledevicerules.model.MDRRuleGroupModel",
		"com.liferay.portlet.mobiledevicerules.service.permission.MDRRuleGroupPermission",
		"com.liferay.portlet.mobiledevicerules.service.persistence.MDRRuleGroupPersistence",
		"com.liferay.portlet.mobiledevicerules.service.MDRRuleGroupService",
		"com.liferay.portlet.mobiledevicerules.service.MDRRuleGroupServiceUtil",
		"com.liferay.portlet.mobiledevicerules.service.MDRRuleGroupServiceWrapper",
		"com.liferay.portlet.mobiledevicerules.model.MDRRuleGroupSoap",
		"com.liferay.portlet.mobiledevicerules.service.persistence.MDRRuleGroupUtil",
		"com.liferay.portlet.mobiledevicerules.model.MDRRuleGroupWrapper",
		"com.liferay.portlet.mobiledevicerules.service.MDRRuleLocalService",
		"com.liferay.portlet.mobiledevicerules.service.MDRRuleLocalServiceUtil",
		"com.liferay.portlet.mobiledevicerules.service.MDRRuleLocalServiceWrapper",
		"com.liferay.portlet.mobiledevicerules.model.MDRRuleModel",
		"com.liferay.portlet.mobiledevicerules.service.persistence.MDRRulePersistence",
		"com.liferay.portlet.mobiledevicerules.service.MDRRuleService",
		"com.liferay.portlet.mobiledevicerules.service.MDRRuleServiceUtil",
		"com.liferay.portlet.mobiledevicerules.service.MDRRuleServiceWrapper",
		"com.liferay.portlet.mobiledevicerules.model.MDRRuleSoap",
		"com.liferay.portlet.mobiledevicerules.service.persistence.MDRRuleUtil",
		"com.liferay.portlet.mobiledevicerules.model.MDRRuleWrapper",
		"com.liferay.portal.kernel.bi.reporting.MemoryReportDesignRetriever",
		"com.liferay.portal.kernel.messaging.jmx.MessageBusManager",
		"com.liferay.portal.kernel.messaging.jmx.MessageBusManagerMBean",
		"com.liferay.portal.security.ldap.Modifications",
		"com.liferay.portlet.mobiledevicerules.NoSuchActionException",
		"com.liferay.portlet.journal.NoSuchArticleException",
		"com.liferay.portlet.journal.NoSuchArticleImageException",
		"com.liferay.portlet.journal.NoSuchArticleResourceException",
		"com.liferay.portlet.shopping.NoSuchCartException",
		"com.liferay.portlet.polls.NoSuchChoiceException",
		"com.liferay.portlet.journal.NoSuchContentSearchException",
		"com.liferay.portlet.shopping.NoSuchCouponException",
		"com.liferay.portlet.journal.NoSuchFeedException",
		"com.liferay.portlet.shopping.NoSuchItemException",
		"com.liferay.portlet.shopping.NoSuchItemFieldException",
		"com.liferay.portlet.shopping.NoSuchItemPriceException",
		"com.liferay.portlet.wiki.NoSuchNodeException",
		"com.liferay.portlet.shopping.NoSuchOrderException",
		"com.liferay.portlet.shopping.NoSuchOrderItemException",
		"com.liferay.portlet.wiki.NoSuchPageException",
		"com.liferay.portlet.wiki.NoSuchPageResourceException",
		"com.liferay.portlet.polls.NoSuchQuestionException",
		"com.liferay.portlet.dynamicdatalists.NoSuchRecordException",
		"com.liferay.portlet.dynamicdatalists.NoSuchRecordSetException",
		"com.liferay.portlet.dynamicdatalists.NoSuchRecordVersionException",
		"com.liferay.portlet.mobiledevicerules.NoSuchRuleException",
		"com.liferay.portlet.mobiledevicerules.NoSuchRuleGroupException",
		"com.liferay.portlet.mobiledevicerules.NoSuchRuleGroupInstanceException",
		"com.liferay.portlet.dynamicdatamapping.NoSuchStorageLinkException",
		"com.liferay.portlet.dynamicdatamapping.NoSuchStructureLinkException",
		"com.liferay.portlet.dynamicdatamapping.NoSuchTemplateException",
		"com.liferay.portlet.journal.NoSuchTemplateException",
		"com.liferay.portlet.polls.NoSuchVoteException",
		"com.liferay.portlet.wiki.NodeNameException",
		"com.liferay.portlet.shopping.util.comparator.OrderDateComparator",
		"com.liferay.portlet.wiki.PageContentException",
		"com.liferay.portlet.wiki.util.comparator.PageCreateDateComparator",
		"com.liferay.portlet.wiki.util.comparator.PageTitleComparator",
		"com.liferay.portlet.wiki.PageTitleException",
		"com.liferay.portlet.wiki.util.comparator.PageVersionComparator",
		"com.liferay.portlet.wiki.PageVersionException",
		"com.liferay.portlet.polls.model.PollsChoice",
		"com.liferay.portlet.polls.service.PollsChoiceLocalService",
		"com.liferay.portlet.polls.service.PollsChoiceLocalServiceUtil",
		"com.liferay.portlet.polls.service.PollsChoiceLocalServiceWrapper",
		"com.liferay.portlet.polls.model.PollsChoiceModel",
		"com.liferay.portlet.polls.service.persistence.PollsChoicePersistence",
		"com.liferay.portlet.polls.service.PollsChoiceService",
		"com.liferay.portlet.polls.service.PollsChoiceServiceUtil",
		"com.liferay.portlet.polls.service.PollsChoiceServiceWrapper",
		"com.liferay.portlet.polls.model.PollsChoiceSoap",
		"com.liferay.portlet.polls.service.persistence.PollsChoiceUtil",
		"com.liferay.portlet.polls.model.PollsChoiceWrapper",
		"com.liferay.portlet.polls.model.PollsQuestion",
		"com.liferay.portlet.polls.service.PollsQuestionLocalService",
		"com.liferay.portlet.polls.service.PollsQuestionLocalServiceUtil",
		"com.liferay.portlet.polls.service.PollsQuestionLocalServiceWrapper",
		"com.liferay.portlet.polls.model.PollsQuestionModel",
		"com.liferay.portlet.polls.service.persistence.PollsQuestionPersistence",
		"com.liferay.portlet.polls.service.PollsQuestionService",
		"com.liferay.portlet.polls.service.PollsQuestionServiceUtil",
		"com.liferay.portlet.polls.service.PollsQuestionServiceWrapper",
		"com.liferay.portlet.polls.model.PollsQuestionSoap",
		"com.liferay.portlet.polls.service.persistence.PollsQuestionUtil",
		"com.liferay.portlet.polls.model.PollsQuestionWrapper",
		"com.liferay.portlet.polls.model.PollsVote",
		"com.liferay.portlet.polls.service.PollsVoteLocalService",
		"com.liferay.portlet.polls.service.PollsVoteLocalServiceUtil",
		"com.liferay.portlet.polls.service.PollsVoteLocalServiceWrapper",
		"com.liferay.portlet.polls.model.PollsVoteModel",
		"com.liferay.portlet.polls.service.persistence.PollsVotePersistence",
		"com.liferay.portlet.polls.service.PollsVoteService",
		"com.liferay.portlet.polls.service.PollsVoteServiceUtil",
		"com.liferay.portlet.polls.service.PollsVoteServiceWrapper",
		"com.liferay.portlet.polls.model.PollsVoteSoap",
		"com.liferay.portlet.polls.service.persistence.PollsVoteUtil",
		"com.liferay.portlet.polls.model.PollsVoteWrapper",
		"com.liferay.portal.kernel.executor.PortalExecutorFactory",
		"com.liferay.portal.security.ldap.PortalToLDAPConverter",
		"com.liferay.portlet.portletdisplaytemplate.util.PortletDisplayTemplate",
		"com.liferay.portlet.portletdisplaytemplate.util.PortletDisplayTemplateConstants",
		"com.liferay.portlet.portletdisplaytemplate.util.PortletDisplayTemplateUtil",
		"com.liferay.portal.kernel.search.QueryIndexingHitsProcessor",
		"com.liferay.portal.kernel.search.QuerySuggestionHitsProcessor",
		"com.liferay.portal.kernel.bi.rules.QueryType",
		"com.liferay.portlet.polls.QuestionChoiceException",
		"com.liferay.portlet.polls.QuestionDescriptionException",
		"com.liferay.portlet.polls.QuestionExpirationDateException",
		"com.liferay.portlet.polls.QuestionExpiredException",
		"com.liferay.portlet.polls.QuestionTitleException",
		"com.liferay.portlet.dynamicdatalists.RecordSetDDMStructureIdException",
		"com.liferay.portlet.dynamicdatalists.RecordSetDuplicateRecordSetKeyException",
		"com.liferay.portlet.dynamicdatalists.RecordSetNameException",
		"com.liferay.portal.kernel.jmx.RegistryAwareMBeanServer",
		"com.liferay.portal.kernel.bi.reporting.messaging.ReportCompilerRequestMessageListener",
		"com.liferay.portal.kernel.bi.reporting.ReportDataSourceType",
		"com.liferay.portal.kernel.bi.reporting.ReportDesignRetriever",
		"com.liferay.portal.kernel.bi.reporting.ReportEngine",
		"com.liferay.portal.kernel.bi.reporting.ReportExportException",
		"com.liferay.portal.kernel.bi.reporting.ReportFormat",
		"com.liferay.portal.kernel.bi.reporting.ReportFormatExporter",
		"com.liferay.portal.kernel.bi.reporting.ReportFormatExporterRegistry",
		"com.liferay.portal.kernel.bi.reporting.ReportGenerationException",
		"com.liferay.portal.kernel.bi.reporting.ReportRequest",
		"com.liferay.portal.kernel.bi.reporting.ReportRequestContext",
		"com.liferay.portal.kernel.bi.reporting.messaging.ReportRequestMessageListener",
		"com.liferay.portal.kernel.bi.reporting.ReportResultContainer",
		"com.liferay.portal.kernel.monitoring.statistics.RequestStatistics",
		"com.liferay.portlet.shopping.RequiredCouponException",
		"com.liferay.portlet.wiki.RequiredNodeException",
		"com.liferay.portlet.dynamicdatamapping.RequiredTemplateException",
		"com.liferay.portlet.journal.RequiredTemplateException",
		"com.liferay.portlet.mobiledevicerules.util.RuleGroupInstancePriorityComparator",
		"com.liferay.portal.kernel.mobile.device.rulegroup.RuleGroupProcessor",
		"com.liferay.portal.kernel.mobile.device.rulegroup.RuleGroupProcessorUtil",
		"com.liferay.portal.kernel.mobile.device.rulegroup.rule.RuleHandler",
		"com.liferay.portal.kernel.bi.rules.RulesEngine",
		"com.liferay.portal.kernel.bi.rules.RulesEngineException",
		"com.liferay.portal.kernel.bi.rules.RulesEngineUtil",
		"com.liferay.portal.kernel.bi.rules.RulesLanguage",
		"com.liferay.portal.kernel.bi.rules.RulesResourceRetriever",
		"com.liferay.portal.kernel.bi.reporting.servlet.ServletContextReportDesignRetriever",
		"com.liferay.portlet.shopping.ShippingCityException",
		"com.liferay.portlet.shopping.ShippingCountryException",
		"com.liferay.portlet.shopping.ShippingEmailAddressException",
		"com.liferay.portlet.shopping.ShippingFirstNameException",
		"com.liferay.portlet.shopping.ShippingLastNameException",
		"com.liferay.portlet.shopping.ShippingPhoneException",
		"com.liferay.portlet.shopping.ShippingStateException",
		"com.liferay.portlet.shopping.ShippingStreetException",
		"com.liferay.portlet.shopping.ShippingZipException",
		"com.liferay.portlet.shopping.model.ShoppingCart",
		"com.liferay.portlet.shopping.model.ShoppingCartItem",
		"com.liferay.portlet.shopping.service.ShoppingCartLocalService",
		"com.liferay.portlet.shopping.service.ShoppingCartLocalServiceUtil",
		"com.liferay.portlet.shopping.service.ShoppingCartLocalServiceWrapper",
		"com.liferay.portlet.shopping.model.ShoppingCartModel",
		"com.liferay.portlet.shopping.service.persistence.ShoppingCartPersistence",
		"com.liferay.portlet.shopping.model.ShoppingCartSoap",
		"com.liferay.portlet.shopping.service.persistence.ShoppingCartUtil",
		"com.liferay.portlet.shopping.model.ShoppingCartWrapper",
		"com.liferay.portlet.shopping.model.ShoppingCategory",
		"com.liferay.portlet.shopping.model.ShoppingCategoryConstants",
		"com.liferay.portlet.shopping.service.ShoppingCategoryLocalService",
		"com.liferay.portlet.shopping.service.ShoppingCategoryLocalServiceUtil",
		"com.liferay.portlet.shopping.service.ShoppingCategoryLocalServiceWrapper",
		"com.liferay.portlet.shopping.model.ShoppingCategoryModel",
		"com.liferay.portlet.shopping.service.persistence.ShoppingCategoryPersistence",
		"com.liferay.portlet.shopping.service.ShoppingCategoryService",
		"com.liferay.portlet.shopping.service.ShoppingCategoryServiceUtil",
		"com.liferay.portlet.shopping.service.ShoppingCategoryServiceWrapper",
		"com.liferay.portlet.shopping.model.ShoppingCategorySoap",
		"com.liferay.portlet.shopping.service.persistence.ShoppingCategoryUtil",
		"com.liferay.portlet.shopping.model.ShoppingCategoryWrapper",
		"com.liferay.portlet.shopping.model.ShoppingCoupon",
		"com.liferay.portlet.shopping.model.ShoppingCouponConstants",
		"com.liferay.portlet.shopping.service.persistence.ShoppingCouponFinder",
		"com.liferay.portlet.shopping.service.ShoppingCouponLocalService",
		"com.liferay.portlet.shopping.service.ShoppingCouponLocalServiceUtil",
		"com.liferay.portlet.shopping.service.ShoppingCouponLocalServiceWrapper",
		"com.liferay.portlet.shopping.model.ShoppingCouponModel",
		"com.liferay.portlet.shopping.service.persistence.ShoppingCouponPersistence",
		"com.liferay.portlet.shopping.service.ShoppingCouponService",
		"com.liferay.portlet.shopping.service.ShoppingCouponServiceUtil",
		"com.liferay.portlet.shopping.service.ShoppingCouponServiceWrapper",
		"com.liferay.portlet.shopping.model.ShoppingCouponSoap",
		"com.liferay.portlet.shopping.service.persistence.ShoppingCouponUtil",
		"com.liferay.portlet.shopping.model.ShoppingCouponWrapper",
		"com.liferay.portlet.shopping.model.ShoppingItem",
		"com.liferay.portlet.shopping.model.ShoppingItemField",
		"com.liferay.portlet.shopping.service.ShoppingItemFieldLocalService",
		"com.liferay.portlet.shopping.service.ShoppingItemFieldLocalServiceUtil",
		"com.liferay.portlet.shopping.service.ShoppingItemFieldLocalServiceWrapper",
		"com.liferay.portlet.shopping.model.ShoppingItemFieldModel",
		"com.liferay.portlet.shopping.service.persistence.ShoppingItemFieldPersistence",
		"com.liferay.portlet.shopping.model.ShoppingItemFieldSoap",
		"com.liferay.portlet.shopping.service.persistence.ShoppingItemFieldUtil",
		"com.liferay.portlet.shopping.model.ShoppingItemFieldWrapper",
		"com.liferay.portlet.shopping.service.persistence.ShoppingItemFinder",
		"com.liferay.portlet.shopping.service.ShoppingItemLocalService",
		"com.liferay.portlet.shopping.service.ShoppingItemLocalServiceUtil",
		"com.liferay.portlet.shopping.service.ShoppingItemLocalServiceWrapper",
		"com.liferay.portlet.shopping.model.ShoppingItemModel",
		"com.liferay.portlet.shopping.service.persistence.ShoppingItemPersistence",
		"com.liferay.portlet.shopping.model.ShoppingItemPrice",
		"com.liferay.portlet.shopping.model.ShoppingItemPriceConstants",
		"com.liferay.portlet.shopping.service.ShoppingItemPriceLocalService",
		"com.liferay.portlet.shopping.service.ShoppingItemPriceLocalServiceUtil",
		"com.liferay.portlet.shopping.service.ShoppingItemPriceLocalServiceWrapper",
		"com.liferay.portlet.shopping.model.ShoppingItemPriceModel",
		"com.liferay.portlet.shopping.service.persistence.ShoppingItemPricePersistence",
		"com.liferay.portlet.shopping.model.ShoppingItemPriceSoap",
		"com.liferay.portlet.shopping.service.persistence.ShoppingItemPriceUtil",
		"com.liferay.portlet.shopping.model.ShoppingItemPriceWrapper",
		"com.liferay.portlet.shopping.service.ShoppingItemService",
		"com.liferay.portlet.shopping.service.ShoppingItemServiceUtil",
		"com.liferay.portlet.shopping.service.ShoppingItemServiceWrapper",
		"com.liferay.portlet.shopping.model.ShoppingItemSoap",
		"com.liferay.portlet.shopping.service.persistence.ShoppingItemUtil",
		"com.liferay.portlet.shopping.model.ShoppingItemWrapper",
		"com.liferay.portlet.shopping.model.ShoppingOrder",
		"com.liferay.portlet.shopping.model.ShoppingOrderConstants",
		"com.liferay.portlet.shopping.service.persistence.ShoppingOrderFinder",
		"com.liferay.portlet.shopping.model.ShoppingOrderItem",
		"com.liferay.portlet.shopping.service.ShoppingOrderItemLocalService",
		"com.liferay.portlet.shopping.service.ShoppingOrderItemLocalServiceUtil",
		"com.liferay.portlet.shopping.service.ShoppingOrderItemLocalServiceWrapper",
		"com.liferay.portlet.shopping.model.ShoppingOrderItemModel",
		"com.liferay.portlet.shopping.service.persistence.ShoppingOrderItemPersistence",
		"com.liferay.portlet.shopping.model.ShoppingOrderItemSoap",
		"com.liferay.portlet.shopping.service.persistence.ShoppingOrderItemUtil",
		"com.liferay.portlet.shopping.model.ShoppingOrderItemWrapper",
		"com.liferay.portlet.shopping.service.ShoppingOrderLocalService",
		"com.liferay.portlet.shopping.service.ShoppingOrderLocalServiceUtil",
		"com.liferay.portlet.shopping.service.ShoppingOrderLocalServiceWrapper",
		"com.liferay.portlet.shopping.model.ShoppingOrderModel",
		"com.liferay.portlet.shopping.service.persistence.ShoppingOrderPersistence",
		"com.liferay.portlet.shopping.service.ShoppingOrderService",
		"com.liferay.portlet.shopping.service.ShoppingOrderServiceUtil",
		"com.liferay.portlet.shopping.service.ShoppingOrderServiceWrapper",
		"com.liferay.portlet.shopping.model.ShoppingOrderSoap",
		"com.liferay.portlet.shopping.service.persistence.ShoppingOrderUtil",
		"com.liferay.portlet.shopping.model.ShoppingOrderWrapper",
		"com.liferay.portal.kernel.search.SortFactoryImpl",
		"com.liferay.portal.kernel.monitoring.statistics.Statistics",
		"com.liferay.portlet.dynamicdatamapping.storage.StorageAdapter",
		"com.liferay.portlet.dynamicdatamapping.storage.StorageEngine",
		"com.liferay.portlet.dynamicdatamapping.StorageException",
		"com.liferay.portlet.dynamicdatamapping.StorageFieldNameException",
		"com.liferay.portlet.dynamicdatamapping.StructureDuplicateStructureKeyException",
		"com.liferay.portlet.dynamicdatamapping.StructureFieldException",
		"com.liferay.portlet.dynamicdatamapping.util.comparator.StructureIdComparator",
		"com.liferay.portlet.dynamicdatamapping.util.comparator.StructureModifiedDateComparator",
		"com.liferay.portlet.dynamicdatamapping.util.comparator.StructureStructureKeyComparator",
		"com.liferay.portal.kernel.monitoring.statistics.SummaryStatistics",
		"com.liferay.portal.kernel.messaging.sender.SynchronousMessageListener",
		"com.liferay.portlet.dynamicdatamapping.TemplateDuplicateTemplateKeyException",
		"com.liferay.portlet.dynamicdatamapping.util.comparator.TemplateIdComparator",
		"com.liferay.portlet.dynamicdatamapping.util.comparator.TemplateModifiedDateComparator",
		"com.liferay.portlet.dynamicdatamapping.TemplateNameException",
		"com.liferay.portlet.journal.TemplateNameException",
		"com.liferay.portlet.dynamicdatamapping.TemplateScriptException",
		"com.liferay.portlet.dynamicdatamapping.TemplateSmallImageNameException",
		"com.liferay.portlet.journal.TemplateSmallImageNameException",
		"com.liferay.portlet.dynamicdatamapping.TemplateSmallImageSizeException",
		"com.liferay.portlet.journal.TemplateSmallImageSizeException",
		"com.liferay.portal.kernel.mobile.device.rulegroup.rule.UnknownRuleHandlerException",
		"com.liferay.portal.security.ldap.UserConverterKeys",
		"com.liferay.portlet.wiki.WikiFormatException",
		"com.liferay.portlet.wiki.model.WikiNode",
		"com.liferay.portlet.wiki.service.WikiNodeLocalService",
		"com.liferay.portlet.wiki.service.WikiNodeLocalServiceUtil",
		"com.liferay.portlet.wiki.service.WikiNodeLocalServiceWrapper",
		"com.liferay.portlet.wiki.model.WikiNodeModel",
		"com.liferay.portlet.wiki.service.persistence.WikiNodePersistence",
		"com.liferay.portlet.wiki.service.WikiNodeService",
		"com.liferay.portlet.wiki.service.WikiNodeServiceUtil",
		"com.liferay.portlet.wiki.service.WikiNodeServiceWrapper",
		"com.liferay.portlet.wiki.model.WikiNodeSoap",
		"com.liferay.portlet.wiki.service.persistence.WikiNodeUtil",
		"com.liferay.portlet.wiki.model.WikiNodeWrapper",
		"com.liferay.portlet.wiki.model.WikiPage",
		"com.liferay.portlet.wiki.model.WikiPageConstants",
		"com.liferay.portlet.wiki.model.WikiPageDisplay",
		"com.liferay.portlet.wiki.service.persistence.WikiPageFinder",
		"com.liferay.portlet.wiki.service.WikiPageLocalService",
		"com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil",
		"com.liferay.portlet.wiki.service.WikiPageLocalServiceWrapper",
		"com.liferay.portlet.wiki.model.WikiPageModel",
		"com.liferay.portlet.wiki.service.persistence.WikiPagePersistence",
		"com.liferay.portlet.wiki.model.WikiPageResource",
		"com.liferay.portlet.wiki.service.WikiPageResourceLocalService",
		"com.liferay.portlet.wiki.service.WikiPageResourceLocalServiceUtil",
		"com.liferay.portlet.wiki.service.WikiPageResourceLocalServiceWrapper",
		"com.liferay.portlet.wiki.model.WikiPageResourceModel",
		"com.liferay.portlet.wiki.service.persistence.WikiPageResourcePersistence",
		"com.liferay.portlet.wiki.model.WikiPageResourceSoap",
		"com.liferay.portlet.wiki.service.persistence.WikiPageResourceUtil",
		"com.liferay.portlet.wiki.model.WikiPageResourceWrapper",
		"com.liferay.portlet.wiki.service.WikiPageService",
		"com.liferay.portlet.wiki.service.WikiPageServiceUtil",
		"com.liferay.portlet.wiki.service.WikiPageServiceWrapper",
		"com.liferay.portlet.wiki.model.WikiPageSoap",
		"com.liferay.portlet.wiki.service.persistence.WikiPageUtil",
		"com.liferay.portlet.wiki.model.WikiPageWrapper"
	};

	private final static String[] IMPORTS_FIXED = new String[] {
		"com.liferay.mobile.device.rules.action.ActionHandler",
		"com.liferay.mobile.device.rules.action.ActionHandlerManager",
		"com.liferay.mobile.device.rules.action.ActionHandlerManagerUtil",
		"com.liferay.mobile.device.rules.exception.ActionTypeException",
		"com.liferay.portal.search.internal.hits.AlternateKeywordQueryHitsProcessor",
		"com.liferay.journal.exception.ArticleContentException",
		"com.liferay.journal.exception.ArticleContentSizeException",
		"com.liferay.journal.util.comparator.ArticleCreateDateComparator",
		"com.liferay.journal.util.comparator.ArticleDisplayDateComparator",
		"com.liferay.journal.exception.ArticleDisplayDateException",
		"com.liferay.journal.exception.ArticleExpirationDateException",
		"com.liferay.journal.util.comparator.ArticleIDComparator",
		"com.liferay.journal.exception.ArticleIdException",
		"com.liferay.journal.util.comparator.ArticleModifiedDateComparator",
		"com.liferay.journal.util.comparator.ArticleReviewDateComparator",
		"com.liferay.journal.exception.ArticleReviewDateException",
		"com.liferay.journal.exception.ArticleSmallImageNameException",
		"com.liferay.journal.exception.ArticleSmallImageSizeException",
		"com.liferay.journal.util.comparator.ArticleTitleComparator",
		"com.liferay.journal.exception.ArticleTitleException",
		"com.liferay.journal.util.comparator.ArticleVersionComparator",
		"com.liferay.journal.exception.ArticleVersionException",
		"com.liferay.asset.publisher.web.util.AssetPublisherUtil",
		"com.liferay.portal.security.audit.AuditMessageProcessor",
		"com.liferay.portal.monitoring.internal.statistics.AverageStatistics",
		"com.liferay.portal.background.task.service.BackgroundTaskLocalService",
		"com.liferay.portal.background.task.service.BackgroundTaskLocalServiceUtil",
		"com.liferay.portal.background.task.service.BackgroundTaskLocalServiceWrapper",
		"com.liferay.portal.background.task.model.BackgroundTaskModel",
		"com.liferay.portal.background.task.service.persistence.BackgroundTaskPersistence",
		"com.liferay.portal.background.task.service.BackgroundTaskService",
		"com.liferay.portal.background.task.service.BackgroundTaskServiceUtil",
		"com.liferay.portal.background.task.service.BackgroundTaskServiceWrapper",
		"com.liferay.portal.background.task.model.BackgroundTaskSoap",
		"com.liferay.portal.background.task.service.persistence.BackgroundTaskUtil",
		"com.liferay.portal.background.task.model.BackgroundTaskWrapper",
		"com.liferay.document.library.repository.cmis.BaseCmisRepository",
		"com.liferay.document.library.repository.cmis.search.BaseCmisSearchQueryBuilder",
		"com.liferay.dynamic.data.lists.exporter.impl.BaseDDLExporter",
		"com.liferay.dynamic.data.mapping.util.BaseDDMDisplay",
		"com.liferay.dynamic.data.mapping.storage.BaseFieldRenderer",
		"com.liferay.portal.scripting.BaseScriptingExecutor",
		"com.liferay.portal.monitoring.internal.statistics.BaseStatistics",
		"com.liferay.dynamic.data.mapping.storage.BaseStorageAdapter",
		"com.liferay.shopping.exception.BillingCityException",
		"com.liferay.shopping.exception.BillingCountryException",
		"com.liferay.shopping.exception.BillingEmailAddressException",
		"com.liferay.shopping.exception.BillingFirstNameException",
		"com.liferay.shopping.exception.BillingLastNameException",
		"com.liferay.shopping.exception.BillingPhoneException",
		"com.liferay.shopping.exception.BillingStateException",
		"com.liferay.shopping.exception.BillingStreetException",
		"com.liferay.shopping.exception.BillingZipException",
		"com.liferay.portal.cache.BlockingPortalCache",
		"com.liferay.bookmarks.model.BookmarksEntry",
		"com.liferay.bookmarks.service.persistence.BookmarksEntryFinder",
		"com.liferay.bookmarks.service.BookmarksEntryLocalService",
		"com.liferay.bookmarks.service.BookmarksEntryLocalServiceUtil",
		"com.liferay.bookmarks.service.BookmarksEntryLocalServiceWrapper",
		"com.liferay.bookmarks.model.BookmarksEntryModel",
		"com.liferay.bookmarks.service.persistence.BookmarksEntryPersistence",
		"com.liferay.bookmarks.service.BookmarksEntryService",
		"com.liferay.bookmarks.service.BookmarksEntryServiceUtil",
		"com.liferay.bookmarks.service.BookmarksEntryServiceWrapper",
		"com.liferay.bookmarks.model.BookmarksEntrySoap",
		"com.liferay.bookmarks.service.persistence.BookmarksEntryUtil",
		"com.liferay.bookmarks.model.BookmarksEntryWrapper",
		"com.liferay.bookmarks.model.BookmarksFolder",
		"com.liferay.bookmarks.model.BookmarksFolderConstants",
		"com.liferay.bookmarks.service.persistence.BookmarksFolderFinder",
		"com.liferay.bookmarks.service.BookmarksFolderLocalService",
		"com.liferay.bookmarks.service.BookmarksFolderLocalServiceUtil",
		"com.liferay.bookmarks.service.BookmarksFolderLocalServiceWrapper",
		"com.liferay.bookmarks.model.BookmarksFolderModel",
		"com.liferay.bookmarks.service.persistence.BookmarksFolderPersistence",
		"com.liferay.bookmarks.service.BookmarksFolderService",
		"com.liferay.bookmarks.service.BookmarksFolderServiceUtil",
		"com.liferay.bookmarks.service.BookmarksFolderServiceWrapper",
		"com.liferay.bookmarks.model.BookmarksFolderSoap",
		"com.liferay.bookmarks.service.persistence.BookmarksFolderUtil",
		"com.liferay.bookmarks.model.BookmarksFolderWrapper",
		"com.liferay.portal.reports.engine.ByteArrayReportResultContainer",
		"com.liferay.shopping.exception.CCExpirationException",
		"com.liferay.shopping.exception.CCNameException",
		"com.liferay.shopping.exception.CCNumberException",
		"com.liferay.shopping.exception.CCTypeException",
		"com.liferay.document.library.repository.cmis.search.CMISBetweenExpression",
		"com.liferay.document.library.repository.cmis.search.CMISConjunction",
		"com.liferay.document.library.repository.cmis.search.CMISContainsExpression",
		"com.liferay.document.library.repository.cmis.search.CMISContainsNotExpression",
		"com.liferay.document.library.repository.cmis.search.CMISContainsValueExpression",
		"com.liferay.document.library.repository.cmis.search.CMISCriterion",
		"com.liferay.document.library.repository.cmis.search.CMISDisjunction",
		"com.liferay.document.library.repository.cmis.search.CMISFullTextConjunction",
		"com.liferay.document.library.repository.cmis.search.CMISInFolderExpression",
		"com.liferay.document.library.repository.cmis.search.CMISInTreeExpression",
		"com.liferay.document.library.repository.cmis.search.CMISJunction",
		"com.liferay.document.library.repository.cmis.search.CMISNotExpression",
		"com.liferay.document.library.repository.cmis.search.CMISParameterValueUtil",
		"com.liferay.document.library.repository.cmis.CMISRepositoryHandler",
		"com.liferay.document.library.repository.cmis.internal.CMISRepositoryUtil",
		"com.liferay.document.library.repository.cmis.search.CMISSearchQueryBuilder",
		"com.liferay.document.library.repository.cmis.search.CMISSimpleExpression",
		"com.liferay.document.library.repository.cmis.search.CMISSimpleExpressionOperator",
		"com.liferay.shopping.exception.CartMinOrderException",
		"com.liferay.shopping.exception.CartMinQuantityException",
		"com.liferay.portal.search.internal.hits.CollatedSpellCheckHitsProcessor",
		"com.liferay.portal.compound.session.id.CompoundSessionIdServletRequest",
		"com.liferay.portal.workflow.kaleo.definition.Condition",
		"com.liferay.portal.security.ldap.ContactConverterKeys",
		"com.liferay.dynamic.data.mapping.exception.ContentException",
		"com.liferay.dynamic.data.mapping.exception.ContentNameException",
		"com.liferay.portal.reports.engine.ContextClassloaderReportDesignRetriever",
		"com.liferay.portal.monitoring.internal.statistics.CountStatistics",
		"com.liferay.shopping.exception.CouponActiveException",
		"com.liferay.shopping.exception.CouponCodeException",
		"com.liferay.shopping.exception.CouponDateException",
		"com.liferay.shopping.exception.CouponDescriptionException",
		"com.liferay.shopping.exception.CouponDiscountException",
		"com.liferay.shopping.exception.CouponEndDateException",
		"com.liferay.shopping.exception.CouponLimitCategoriesException",
		"com.liferay.shopping.exception.CouponLimitSKUsException",
		"com.liferay.shopping.exception.CouponMinimumOrderException",
		"com.liferay.shopping.exception.CouponNameException",
		"com.liferay.shopping.exception.CouponStartDateException",
		"com.liferay.dynamic.data.lists.util.DDL",
		"com.liferay.dynamic.data.lists.exporter.DDLExporter",
		"com.liferay.dynamic.data.lists.exporter.DDLExporterFactory",
		"com.liferay.dynamic.data.lists.model.DDLRecord",
		"com.liferay.dynamic.data.lists.model.DDLRecordConstants",
		"com.liferay.dynamic.data.lists.service.persistence.DDLRecordFinder",
		"com.liferay.dynamic.data.lists.service.DDLRecordLocalService",
		"com.liferay.dynamic.data.lists.service.DDLRecordLocalServiceUtil",
		"com.liferay.dynamic.data.lists.service.DDLRecordLocalServiceWrapper",
		"com.liferay.dynamic.data.lists.model.DDLRecordModel",
		"com.liferay.dynamic.data.lists.service.persistence.DDLRecordPersistence",
		"com.liferay.dynamic.data.lists.service.DDLRecordService",
		"com.liferay.dynamic.data.lists.service.DDLRecordServiceUtil",
		"com.liferay.dynamic.data.lists.service.DDLRecordServiceWrapper",
		"com.liferay.dynamic.data.lists.model.DDLRecordSet",
		"com.liferay.dynamic.data.lists.model.DDLRecordSetConstants",
		"com.liferay.dynamic.data.lists.service.persistence.DDLRecordSetFinder",
		"com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService",
		"com.liferay.dynamic.data.lists.service.DDLRecordSetLocalServiceUtil",
		"com.liferay.dynamic.data.lists.service.DDLRecordSetLocalServiceWrapper",
		"com.liferay.dynamic.data.lists.model.DDLRecordSetModel",
		"com.liferay.dynamic.data.lists.service.persistence.DDLRecordSetPersistence",
		"com.liferay.dynamic.data.lists.service.DDLRecordSetService",
		"com.liferay.dynamic.data.lists.service.DDLRecordSetServiceUtil",
		"com.liferay.dynamic.data.lists.service.DDLRecordSetServiceWrapper",
		"com.liferay.dynamic.data.lists.model.DDLRecordSetSoap",
		"com.liferay.dynamic.data.lists.service.persistence.DDLRecordSetUtil",
		"com.liferay.dynamic.data.lists.model.DDLRecordSetWrapper",
		"com.liferay.dynamic.data.lists.model.DDLRecordSoap",
		"com.liferay.dynamic.data.lists.service.persistence.DDLRecordUtil",
		"com.liferay.dynamic.data.lists.model.DDLRecordVersion",
		"com.liferay.dynamic.data.lists.model.DDLRecordVersionModel",
		"com.liferay.dynamic.data.lists.service.persistence.DDLRecordVersionPersistence",
		"com.liferay.dynamic.data.lists.model.DDLRecordVersionSoap",
		"com.liferay.dynamic.data.lists.service.persistence.DDLRecordVersionUtil",
		"com.liferay.dynamic.data.lists.util.comparator.DDLRecordVersionVersionComparator",
		"com.liferay.dynamic.data.lists.model.DDLRecordVersionWrapper",
		"com.liferay.dynamic.data.lists.model.DDLRecordWrapper",
		"com.liferay.dynamic.data.mapping.util.DDM",
		"com.liferay.dynamic.data.mapping.model.DDMContent",
		"com.liferay.dynamic.data.mapping.service.DDMContentLocalService",
		"com.liferay.dynamic.data.mapping.service.DDMContentLocalServiceUtil",
		"com.liferay.dynamic.data.mapping.service.DDMContentLocalServiceWrapper",
		"com.liferay.dynamic.data.mapping.model.DDMContentModel",
		"com.liferay.dynamic.data.mapping.service.persistence.DDMContentPersistence",
		"com.liferay.dynamic.data.mapping.model.DDMContentSoap",
		"com.liferay.dynamic.data.mapping.service.persistence.DDMContentUtil",
		"com.liferay.dynamic.data.mapping.model.DDMContentWrapper",
		"com.liferay.dynamic.data.mapping.util.DDMDisplay",
		"com.liferay.dynamic.data.mapping.util.DDMDisplayRegistry",
		"com.liferay.dynamic.data.mapping.util.DDMIndexer",
		"com.liferay.dynamic.data.mapping.model.DDMStorageLink",
		"com.liferay.dynamic.data.mapping.service.DDMStorageLinkLocalService",
		"com.liferay.dynamic.data.mapping.service.DDMStorageLinkLocalServiceUtil",
		"com.liferay.dynamic.data.mapping.service.DDMStorageLinkLocalServiceWrapper",
		"com.liferay.dynamic.data.mapping.model.DDMStorageLinkModel",
		"com.liferay.dynamic.data.mapping.service.persistence.DDMStorageLinkPersistence",
		"com.liferay.dynamic.data.mapping.model.DDMStorageLinkSoap",
		"com.liferay.dynamic.data.mapping.service.persistence.DDMStorageLinkUtil",
		"com.liferay.dynamic.data.mapping.model.DDMStorageLinkWrapper",
		"com.liferay.dynamic.data.mapping.model.DDMStructureConstants",
		"com.liferay.dynamic.data.mapping.service.persistence.DDMStructureFinder",
		"com.liferay.dynamic.data.mapping.service.DDMStructureLinkLocalService",
		"com.liferay.dynamic.data.mapping.service.DDMStructureLinkLocalServiceUtil",
		"com.liferay.dynamic.data.mapping.service.DDMStructureLinkLocalServiceWrapper",
		"com.liferay.dynamic.data.mapping.model.DDMStructureLinkModel",
		"com.liferay.dynamic.data.mapping.service.persistence.DDMStructureLinkPersistence",
		"com.liferay.dynamic.data.mapping.model.DDMStructureLinkSoap",
		"com.liferay.dynamic.data.mapping.service.persistence.DDMStructureLinkUtil",
		"com.liferay.dynamic.data.mapping.model.DDMStructureLinkWrapper",
		"com.liferay.dynamic.data.mapping.service.DDMStructureLocalService",
		"com.liferay.dynamic.data.mapping.service.DDMStructureLocalServiceUtil",
		"com.liferay.dynamic.data.mapping.service.DDMStructureLocalServiceWrapper",
		"com.liferay.dynamic.data.mapping.model.DDMStructureModel",
		"com.liferay.dynamic.data.mapping.service.persistence.DDMStructurePersistence",
		"com.liferay.dynamic.data.mapping.service.DDMStructureService",
		"com.liferay.dynamic.data.mapping.service.DDMStructureServiceUtil",
		"com.liferay.dynamic.data.mapping.service.DDMStructureServiceWrapper",
		"com.liferay.dynamic.data.mapping.model.DDMStructureSoap",
		"com.liferay.dynamic.data.mapping.service.persistence.DDMStructureUtil",
		"com.liferay.dynamic.data.mapping.model.DDMStructureWrapper",
		"com.liferay.dynamic.data.mapping.model.DDMTemplateConstants",
		"com.liferay.dynamic.data.mapping.service.persistence.DDMTemplateFinder",
		"com.liferay.dynamic.data.mapping.util.DDMTemplateHelper",
		"com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService",
		"com.liferay.dynamic.data.mapping.service.DDMTemplateLocalServiceUtil",
		"com.liferay.dynamic.data.mapping.service.DDMTemplateLocalServiceWrapper",
		"com.liferay.dynamic.data.mapping.model.DDMTemplateModel",
		"com.liferay.dynamic.data.mapping.service.persistence.DDMTemplatePersistence",
		"com.liferay.dynamic.data.mapping.service.DDMTemplateService",
		"com.liferay.dynamic.data.mapping.service.DDMTemplateServiceUtil",
		"com.liferay.dynamic.data.mapping.service.DDMTemplateServiceWrapper",
		"com.liferay.dynamic.data.mapping.model.DDMTemplateSoap",
		"com.liferay.dynamic.data.mapping.service.persistence.DDMTemplateUtil",
		"com.liferay.dynamic.data.mapping.model.DDMTemplateWrapper",
		"com.liferay.dynamic.data.mapping.util.DDMUtil",
		"com.liferay.dynamic.data.mapping.util.DDMXML",
		"com.liferay.portal.security.ldap.internal.DefaultAttributesTransformer",
		"com.liferay.portal.messaging.internal.DefaultMessageBus",
		"com.liferay.portal.messaging.internal.sender.DefaultSingleDestinationMessageSender",
		"com.liferay.portal.messaging.internal.sender.DefaultSingleDestinationSynchronousMessageSender",
		"com.liferay.portal.messaging.internal.sender.DefaultSynchronousMessageSender",
		"com.liferay.portal.messaging.internal.jmx.DestinationStatisticsManager",
		"com.liferay.portal.messaging.internal.jmx.DestinationStatisticsManagerMBean",
		"com.liferay.portal.messaging.internal.sender.DirectSynchronousMessageSender",
		"com.liferay.portal.security.ldap.dummy.DummyContext",
		"com.liferay.portal.security.ldap.dummy.DummyDirContext",
		"com.liferay.journal.exception.DuplicateArticleIdException",
		"com.liferay.journal.exception.DuplicateArticleImageIdException",
		"com.liferay.shopping.exception.DuplicateCouponCodeException",
		"com.liferay.journal.exception.DuplicateFeedIdException",
		"com.liferay.shopping.exception.DuplicateItemSKUException",
		"com.liferay.portal.security.ldap.DuplicateLDAPServerNameException",
		"com.liferay.wiki.exception.DuplicateNodeNameException",
		"com.liferay.wiki.exception.DuplicatePageException",
		"com.liferay.mobile.device.rules.exception.DuplicateRuleGroupInstanceException",
		"com.liferay.polls.exception.DuplicateVoteException",
		"com.liferay.bookmarks.util.comparator.EntryNameComparator",
		"com.liferay.bookmarks.util.comparator.EntryPriorityComparator",
		"com.liferay.bookmarks.util.comparator.EntryURLComparator",
		"com.liferay.bookmarks.util.comparator.EntryVisitsComparator",
		"com.liferay.portal.rules.engine.Fact",
		"com.liferay.journal.exception.FeedContentFieldException",
		"com.liferay.journal.exception.FeedIdException",
		"com.liferay.journal.exception.FeedNameException",
		"com.liferay.journal.exception.FeedTargetLayoutFriendlyUrlException",
		"com.liferay.journal.exception.FeedTargetPortletIdException",
		"com.liferay.document.library.lar.xstream.FieldConstants",
		"com.liferay.dynamic.data.mapping.storage.FieldRenderer",
		"com.liferay.dynamic.data.mapping.storage.FieldRendererFactory",
		"com.liferay.dynamic.data.mapping.storage.Fields",
		"com.liferay.flags.service.FlagsEntryService",
		"com.liferay.flags.service.FlagsEntryServiceUtil",
		"com.liferay.flags.service.FlagsEntryServiceWrapper",
		"com.liferay.flags.messaging.FlagsRequest",
		"com.liferay.portal.security.ldap.GroupConverterKeys",
		"com.liferay.wiki.exception.ImportFilesException",
		"com.liferay.shopping.exception.ItemLargeImageNameException",
		"com.liferay.shopping.exception.ItemLargeImageSizeException",
		"com.liferay.shopping.exception.ItemMediumImageNameException",
		"com.liferay.shopping.exception.ItemMediumImageSizeException",
		"com.liferay.shopping.util.comparator.ItemMinQuantityComparator",
		"com.liferay.shopping.util.comparator.ItemNameComparator",
		"com.liferay.shopping.exception.ItemNameException",
		"com.liferay.shopping.util.comparator.ItemPriceComparator",
		"com.liferay.shopping.util.comparator.ItemSKUComparator",
		"com.liferay.shopping.exception.ItemSKUException",
		"com.liferay.shopping.exception.ItemSmallImageNameException",
		"com.liferay.shopping.exception.ItemSmallImageSizeException",
		"com.liferay.portal.scheduler.JobStateSerializeUtil",
		"com.liferay.journal.model.JournalArticle",
		"com.liferay.journal.model.JournalArticleConstants",
		"com.liferay.journal.model.JournalArticleDisplay",
		"com.liferay.journal.service.persistence.JournalArticleFinder",
		"com.liferay.journal.model.JournalArticleImage",
		"com.liferay.journal.service.JournalArticleImageLocalService",
		"com.liferay.journal.service.JournalArticleImageLocalServiceUtil",
		"com.liferay.journal.service.JournalArticleImageLocalServiceWrapper",
		"com.liferay.journal.model.JournalArticleImageModel",
		"com.liferay.journal.service.persistence.JournalArticleImagePersistence",
		"com.liferay.journal.model.JournalArticleImageSoap",
		"com.liferay.journal.service.persistence.JournalArticleImageUtil",
		"com.liferay.journal.model.JournalArticleImageWrapper",
		"com.liferay.journal.service.JournalArticleLocalService",
		"com.liferay.journal.service.JournalArticleLocalServiceUtil",
		"com.liferay.journal.service.JournalArticleLocalServiceWrapper",
		"com.liferay.journal.model.JournalArticleModel",
		"com.liferay.journal.service.persistence.JournalArticlePersistence",
		"com.liferay.journal.model.JournalArticleResource",
		"com.liferay.journal.service.JournalArticleResourceLocalService",
		"com.liferay.journal.service.JournalArticleResourceLocalServiceUtil",
		"com.liferay.journal.service.JournalArticleResourceLocalServiceWrapper",
		"com.liferay.journal.model.JournalArticleResourceModel",
		"com.liferay.journal.service.persistence.JournalArticleResourcePersistence",
		"com.liferay.journal.model.JournalArticleResourceSoap",
		"com.liferay.journal.service.persistence.JournalArticleResourceUtil",
		"com.liferay.journal.model.JournalArticleResourceWrapper",
		"com.liferay.journal.service.JournalArticleService",
		"com.liferay.journal.service.JournalArticleServiceUtil",
		"com.liferay.journal.service.JournalArticleServiceWrapper",
		"com.liferay.journal.model.JournalArticleSoap",
		"com.liferay.journal.service.persistence.JournalArticleUtil",
		"com.liferay.journal.model.JournalArticleWrapper",
		"com.liferay.journal.util.JournalContent",
		"com.liferay.journal.model.JournalContentSearch",
		"com.liferay.journal.service.JournalContentSearchLocalService",
		"com.liferay.journal.service.JournalContentSearchLocalServiceUtil",
		"com.liferay.journal.service.JournalContentSearchLocalServiceWrapper",
		"com.liferay.journal.model.JournalContentSearchModel",
		"com.liferay.journal.service.persistence.JournalContentSearchPersistence",
		"com.liferay.journal.model.JournalContentSearchSoap",
		"com.liferay.journal.service.persistence.JournalContentSearchUtil",
		"com.liferay.journal.model.JournalContentSearchWrapper",
		"com.liferay.journal.util.JournalConverter",
		"com.liferay.journal.model.JournalFeed",
		"com.liferay.journal.model.JournalFeedConstants",
		"com.liferay.journal.service.persistence.JournalFeedFinder",
		"com.liferay.journal.service.JournalFeedLocalService",
		"com.liferay.journal.service.JournalFeedLocalServiceUtil",
		"com.liferay.journal.service.JournalFeedLocalServiceWrapper",
		"com.liferay.journal.model.JournalFeedModel",
		"com.liferay.journal.service.persistence.JournalFeedPersistence",
		"com.liferay.journal.service.JournalFeedService",
		"com.liferay.journal.service.JournalFeedServiceUtil",
		"com.liferay.journal.service.JournalFeedServiceWrapper",
		"com.liferay.journal.model.JournalFeedSoap",
		"com.liferay.journal.service.persistence.JournalFeedUtil",
		"com.liferay.journal.model.JournalFeedWrapper",
		"com.liferay.journal.model.JournalFolder",
		"com.liferay.journal.service.persistence.JournalFolderFinder",
		"com.liferay.journal.service.JournalFolderLocalService",
		"com.liferay.journal.service.JournalFolderLocalServiceUtil",
		"com.liferay.journal.service.JournalFolderLocalServiceWrapper",
		"com.liferay.journal.model.JournalFolderModel",
		"com.liferay.journal.service.persistence.JournalFolderPersistence",
		"com.liferay.journal.service.JournalFolderService",
		"com.liferay.journal.service.JournalFolderServiceUtil",
		"com.liferay.journal.service.JournalFolderServiceWrapper",
		"com.liferay.journal.model.JournalFolderSoap",
		"com.liferay.journal.service.persistence.JournalFolderUtil",
		"com.liferay.journal.model.JournalFolderWrapper",
		"com.liferay.journal.model.JournalSearchConstants",
		"com.liferay.journal.model.JournalStructureConstants",
		"com.liferay.portal.security.ldap.validator.LDAPFilterException",
		"com.liferay.portal.security.ldap.exportimport.LDAPGroup",
		"com.liferay.portal.security.ldap.LDAPServerNameException",
		"com.liferay.portal.security.ldap.exportimport.LDAPToPortalConverter",
		"com.liferay.portal.security.ldap.exportimport.LDAPUser",
		"com.liferay.portal.security.ldap.util.LDAPUtil",
		"com.liferay.portal.lock.service.LockLocalService",
		"com.liferay.portal.lock.service.LockLocalServiceUtil",
		"com.liferay.portal.lock.service.LockLocalServiceWrapper",
		"com.liferay.portal.lock.model.LockModel",
		"com.liferay.portal.lock.service.persistence.LockPersistence",
		"com.liferay.portal.lock.model.LockSoap",
		"com.liferay.portal.lock.service.persistence.LockUtil",
		"com.liferay.portal.lock.model.LockWrapper",
		"com.liferay.portal.jmx.MBeanRegistry",
		"com.liferay.mobile.device.rules.model.MDRAction",
		"com.liferay.mobile.device.rules.service.MDRActionLocalService",
		"com.liferay.mobile.device.rules.service.MDRActionLocalServiceUtil",
		"com.liferay.mobile.device.rules.service.MDRActionLocalServiceWrapper",
		"com.liferay.mobile.device.rules.model.MDRActionModel",
		"com.liferay.mobile.device.rules.service.persistence.MDRActionPersistence",
		"com.liferay.mobile.device.rules.service.MDRActionService",
		"com.liferay.mobile.device.rules.service.MDRActionServiceUtil",
		"com.liferay.mobile.device.rules.service.MDRActionServiceWrapper",
		"com.liferay.mobile.device.rules.model.MDRActionSoap",
		"com.liferay.mobile.device.rules.service.persistence.MDRActionUtil",
		"com.liferay.mobile.device.rules.model.MDRActionWrapper",
		"com.liferay.mobile.device.rules.service.permission.MDRPermission",
		"com.liferay.mobile.device.rules.model.MDRRule",
		"com.liferay.mobile.device.rules.model.MDRRuleGroup",
		"com.liferay.mobile.device.rules.service.persistence.MDRRuleGroupFinder",
		"com.liferay.mobile.device.rules.service.MDRRuleGroupInstanceLocalService",
		"com.liferay.mobile.device.rules.service.MDRRuleGroupInstanceLocalServiceUtil",
		"com.liferay.mobile.device.rules.service.MDRRuleGroupInstanceLocalServiceWrapper",
		"com.liferay.mobile.device.rules.model.MDRRuleGroupInstanceModel",
		"com.liferay.mobile.device.rules.service.permission.MDRRuleGroupInstancePermission",
		"com.liferay.mobile.device.rules.service.persistence.MDRRuleGroupInstancePersistence",
		"com.liferay.mobile.device.rules.service.MDRRuleGroupInstanceService",
		"com.liferay.mobile.device.rules.service.MDRRuleGroupInstanceServiceUtil",
		"com.liferay.mobile.device.rules.service.MDRRuleGroupInstanceServiceWrapper",
		"com.liferay.mobile.device.rules.model.MDRRuleGroupInstanceSoap",
		"com.liferay.mobile.device.rules.service.persistence.MDRRuleGroupInstanceUtil",
		"com.liferay.mobile.device.rules.model.MDRRuleGroupInstanceWrapper",
		"com.liferay.mobile.device.rules.service.MDRRuleGroupLocalService",
		"com.liferay.mobile.device.rules.service.MDRRuleGroupLocalServiceUtil",
		"com.liferay.mobile.device.rules.service.MDRRuleGroupLocalServiceWrapper",
		"com.liferay.mobile.device.rules.model.MDRRuleGroupModel",
		"com.liferay.mobile.device.rules.service.permission.MDRRuleGroupPermission",
		"com.liferay.mobile.device.rules.service.persistence.MDRRuleGroupPersistence",
		"com.liferay.mobile.device.rules.service.MDRRuleGroupService",
		"com.liferay.mobile.device.rules.service.MDRRuleGroupServiceUtil",
		"com.liferay.mobile.device.rules.service.MDRRuleGroupServiceWrapper",
		"com.liferay.mobile.device.rules.model.MDRRuleGroupSoap",
		"com.liferay.mobile.device.rules.service.persistence.MDRRuleGroupUtil",
		"com.liferay.mobile.device.rules.model.MDRRuleGroupWrapper",
		"com.liferay.mobile.device.rules.service.MDRRuleLocalService",
		"com.liferay.mobile.device.rules.service.MDRRuleLocalServiceUtil",
		"com.liferay.mobile.device.rules.service.MDRRuleLocalServiceWrapper",
		"com.liferay.mobile.device.rules.model.MDRRuleModel",
		"com.liferay.mobile.device.rules.service.persistence.MDRRulePersistence",
		"com.liferay.mobile.device.rules.service.MDRRuleService",
		"com.liferay.mobile.device.rules.service.MDRRuleServiceUtil",
		"com.liferay.mobile.device.rules.service.MDRRuleServiceWrapper",
		"com.liferay.mobile.device.rules.model.MDRRuleSoap",
		"com.liferay.mobile.device.rules.service.persistence.MDRRuleUtil",
		"com.liferay.mobile.device.rules.model.MDRRuleWrapper",
		"com.liferay.portal.reports.engine.MemoryReportDesignRetriever",
		"com.liferay.portal.messaging.internal.jmx.MessageBusManager",
		"com.liferay.portal.messaging.internal.jmx.MessageBusManagerMBean",
		"com.liferay.portal.security.ldap.exportimport.Modifications",
		"com.liferay.portal.workflow.kaleo.exception.NoSuchActionException",
		"com.liferay.journal.exception.NoSuchArticleException",
		"com.liferay.journal.exception.NoSuchArticleImageException",
		"com.liferay.journal.exception.NoSuchArticleResourceException",
		"com.liferay.shopping.exception.NoSuchCartException",
		"com.liferay.polls.exception.NoSuchChoiceException",
		"com.liferay.journal.exception.NoSuchContentSearchException",
		"com.liferay.shopping.exception.NoSuchCouponException",
		"com.liferay.journal.exception.NoSuchFeedException",
		"com.liferay.shopping.exception.NoSuchItemException",
		"com.liferay.shopping.exception.NoSuchItemFieldException",
		"com.liferay.shopping.exception.NoSuchItemPriceException",
		"com.liferay.wiki.exception.NoSuchNodeException",
		"com.liferay.shopping.exception.NoSuchOrderException",
		"com.liferay.shopping.exception.NoSuchOrderItemException",
		"com.liferay.wiki.exception.NoSuchPageException",
		"com.liferay.wiki.exception.NoSuchPageResourceException",
		"com.liferay.polls.exception.NoSuchQuestionException",
		"com.liferay.dynamic.data.lists.exception.NoSuchRecordException",
		"com.liferay.dynamic.data.lists.exception.NoSuchRecordSetException",
		"com.liferay.dynamic.data.lists.exception.NoSuchRecordVersionException",
		"com.liferay.mobile.device.rules.exception.NoSuchRuleException",
		"com.liferay.mobile.device.rules.exception.NoSuchRuleGroupException",
		"com.liferay.mobile.device.rules.exception.NoSuchRuleGroupInstanceException",
		"com.liferay.dynamic.data.mapping.exception.NoSuchStorageLinkException",
		"com.liferay.dynamic.data.mapping.exception.NoSuchStructureLinkException",
		"com.liferay.dynamic.data.mapping.exception.NoSuchTemplateException",
		"com.liferay.dynamic.data.mapping.exception.NoSuchTemplateException",
		"com.liferay.polls.exception.NoSuchVoteException",
		"com.liferay.wiki.exception.NodeNameException",
		"com.liferay.shopping.util.comparator.OrderDateComparator",
		"com.liferay.wiki.exception.PageContentException",
		"com.liferay.wiki.util.comparator.PageCreateDateComparator",
		"com.liferay.wiki.util.comparator.PageTitleComparator",
		"com.liferay.wiki.exception.PageTitleException",
		"com.liferay.wiki.util.comparator.PageVersionComparator",
		"com.liferay.wiki.exception.PageVersionException",
		"com.liferay.polls.model.PollsChoice",
		"com.liferay.polls.service.PollsChoiceLocalService",
		"com.liferay.polls.service.PollsChoiceLocalServiceUtil",
		"com.liferay.polls.service.PollsChoiceLocalServiceWrapper",
		"com.liferay.polls.model.PollsChoiceModel",
		"com.liferay.polls.service.persistence.PollsChoicePersistence",
		"com.liferay.polls.service.PollsChoiceService",
		"com.liferay.polls.service.PollsChoiceServiceUtil",
		"com.liferay.polls.service.PollsChoiceServiceWrapper",
		"com.liferay.polls.model.PollsChoiceSoap",
		"com.liferay.polls.service.persistence.PollsChoiceUtil",
		"com.liferay.polls.model.PollsChoiceWrapper",
		"com.liferay.polls.model.PollsQuestion",
		"com.liferay.polls.service.PollsQuestionLocalService",
		"com.liferay.polls.service.PollsQuestionLocalServiceUtil",
		"com.liferay.polls.service.PollsQuestionLocalServiceWrapper",
		"com.liferay.polls.model.PollsQuestionModel",
		"com.liferay.polls.service.persistence.PollsQuestionPersistence",
		"com.liferay.polls.service.PollsQuestionService",
		"com.liferay.polls.service.PollsQuestionServiceUtil",
		"com.liferay.polls.service.PollsQuestionServiceWrapper",
		"com.liferay.polls.model.PollsQuestionSoap",
		"com.liferay.polls.service.persistence.PollsQuestionUtil",
		"com.liferay.polls.model.PollsQuestionWrapper",
		"com.liferay.polls.model.PollsVote",
		"com.liferay.polls.service.PollsVoteLocalService",
		"com.liferay.polls.service.PollsVoteLocalServiceUtil",
		"com.liferay.polls.service.PollsVoteLocalServiceWrapper",
		"com.liferay.polls.model.PollsVoteModel",
		"com.liferay.polls.service.persistence.PollsVotePersistence",
		"com.liferay.polls.service.PollsVoteService",
		"com.liferay.polls.service.PollsVoteServiceUtil",
		"com.liferay.polls.service.PollsVoteServiceWrapper",
		"com.liferay.polls.model.PollsVoteSoap",
		"com.liferay.polls.service.persistence.PollsVoteUtil",
		"com.liferay.polls.model.PollsVoteWrapper",
		"com.liferay.portal.executor.internal.PortalExecutorFactory",
		"com.liferay.portal.security.ldap.exportimport.PortalToLDAPConverter",
		"com.liferay.portlet.display.template.PortletDisplayTemplate",
		"com.liferay.portlet.display.template.PortletDisplayTemplateConstants",
		"com.liferay.portlet.display.template.PortletDisplayTemplateUtil",
		"com.liferay.portal.search.internal.hits.QueryIndexingHitsProcessor",
		"com.liferay.portal.search.internal.hits.QuerySuggestionHitsProcessor",
		"com.liferay.portal.rules.engine.QueryType",
		"com.liferay.polls.exception.QuestionChoiceException",
		"com.liferay.polls.exception.QuestionDescriptionException",
		"com.liferay.polls.exception.QuestionExpirationDateException",
		"com.liferay.polls.exception.QuestionExpiredException",
		"com.liferay.polls.exception.QuestionTitleException",
		"com.liferay.dynamic.data.lists.exception.RecordSetDDMStructureIdException",
		"com.liferay.dynamic.data.lists.exception.RecordSetDuplicateRecordSetKeyException",
		"com.liferay.dynamic.data.lists.exception.RecordSetNameException",
		"com.liferay.portal.jmx.internal.RegistryAwareMBeanServer",
		"com.liferay.portal.reports.engine.messaging.ReportCompilerRequestMessageListener",
		"com.liferay.portal.reports.engine.ReportDataSourceType",
		"com.liferay.portal.reports.engine.ReportDesignRetriever",
		"com.liferay.portal.reports.engine.ReportEngine",
		"com.liferay.portal.reports.engine.ReportExportException",
		"com.liferay.portal.reports.engine.ReportFormat",
		"com.liferay.portal.reports.engine.ReportFormatExporter",
		"com.liferay.portal.reports.engine.ReportFormatExporterRegistry",
		"com.liferay.portal.reports.engine.ReportGenerationException",
		"com.liferay.portal.reports.engine.ReportRequest",
		"com.liferay.portal.reports.engine.ReportRequestContext",
		"com.liferay.portal.reports.engine.messaging.ReportRequestMessageListener",
		"com.liferay.portal.reports.engine.ReportResultContainer",
		"com.liferay.portal.monitoring.internal.statistics.RequestStatistics",
		"com.liferay.shopping.exception.RequiredCouponException",
		"com.liferay.wiki.exception.RequiredNodeException",
		"com.liferay.dynamic.data.mapping.exception.RequiredTemplateException",
		"com.liferay.dynamic.data.mapping.exception.RequiredTemplateException",
		"com.liferay.mobile.device.rules.util.comparator.RuleGroupInstancePriorityComparator",
		"com.liferay.mobile.device.rules.rule.RuleGroupProcessor",
		"com.liferay.mobile.device.rules.rule.RuleGroupProcessorUtil",
		"com.liferay.mobile.device.rules.rule.RuleHandler",
		"com.liferay.portal.rules.engine.RulesEngine",
		"com.liferay.portal.rules.engine.RulesEngineException",
		"com.liferay.portal.rules.engine.RulesEngineUtil",
		"com.liferay.portal.rules.engine.RulesLanguage",
		"com.liferay.portal.rules.engine.RulesResourceRetriever",
		"com.liferay.portal.reports.engine.servlet.ServletContextReportDesignRetriever",
		"com.liferay.shopping.exception.ShippingCityException",
		"com.liferay.shopping.exception.ShippingCountryException",
		"com.liferay.shopping.exception.ShippingEmailAddressException",
		"com.liferay.shopping.exception.ShippingFirstNameException",
		"com.liferay.shopping.exception.ShippingLastNameException",
		"com.liferay.shopping.exception.ShippingPhoneException",
		"com.liferay.shopping.exception.ShippingStateException",
		"com.liferay.shopping.exception.ShippingStreetException",
		"com.liferay.shopping.exception.ShippingZipException",
		"com.liferay.shopping.model.ShoppingCart",
		"com.liferay.shopping.model.ShoppingCartItem",
		"com.liferay.shopping.service.ShoppingCartLocalService",
		"com.liferay.shopping.service.ShoppingCartLocalServiceUtil",
		"com.liferay.shopping.service.ShoppingCartLocalServiceWrapper",
		"com.liferay.shopping.model.ShoppingCartModel",
		"com.liferay.shopping.service.persistence.ShoppingCartPersistence",
		"com.liferay.shopping.model.ShoppingCartSoap",
		"com.liferay.shopping.service.persistence.ShoppingCartUtil",
		"com.liferay.shopping.model.ShoppingCartWrapper",
		"com.liferay.shopping.model.ShoppingCategory",
		"com.liferay.shopping.model.ShoppingCategoryConstants",
		"com.liferay.shopping.service.ShoppingCategoryLocalService",
		"com.liferay.shopping.service.ShoppingCategoryLocalServiceUtil",
		"com.liferay.shopping.service.ShoppingCategoryLocalServiceWrapper",
		"com.liferay.shopping.model.ShoppingCategoryModel",
		"com.liferay.shopping.service.persistence.ShoppingCategoryPersistence",
		"com.liferay.shopping.service.ShoppingCategoryService",
		"com.liferay.shopping.service.ShoppingCategoryServiceUtil",
		"com.liferay.shopping.service.ShoppingCategoryServiceWrapper",
		"com.liferay.shopping.model.ShoppingCategorySoap",
		"com.liferay.shopping.service.persistence.ShoppingCategoryUtil",
		"com.liferay.shopping.model.ShoppingCategoryWrapper",
		"com.liferay.shopping.model.ShoppingCoupon",
		"com.liferay.shopping.model.ShoppingCouponConstants",
		"com.liferay.shopping.service.persistence.ShoppingCouponFinder",
		"com.liferay.shopping.service.ShoppingCouponLocalService",
		"com.liferay.shopping.service.ShoppingCouponLocalServiceUtil",
		"com.liferay.shopping.service.ShoppingCouponLocalServiceWrapper",
		"com.liferay.shopping.model.ShoppingCouponModel",
		"com.liferay.shopping.service.persistence.ShoppingCouponPersistence",
		"com.liferay.shopping.service.ShoppingCouponService",
		"com.liferay.shopping.service.ShoppingCouponServiceUtil",
		"com.liferay.shopping.service.ShoppingCouponServiceWrapper",
		"com.liferay.shopping.model.ShoppingCouponSoap",
		"com.liferay.shopping.service.persistence.ShoppingCouponUtil",
		"com.liferay.shopping.model.ShoppingCouponWrapper",
		"com.liferay.shopping.model.ShoppingItem",
		"com.liferay.shopping.model.ShoppingItemField",
		"com.liferay.shopping.service.ShoppingItemFieldLocalService",
		"com.liferay.shopping.service.ShoppingItemFieldLocalServiceUtil",
		"com.liferay.shopping.service.ShoppingItemFieldLocalServiceWrapper",
		"com.liferay.shopping.model.ShoppingItemFieldModel",
		"com.liferay.shopping.service.persistence.ShoppingItemFieldPersistence",
		"com.liferay.shopping.model.ShoppingItemFieldSoap",
		"com.liferay.shopping.service.persistence.ShoppingItemFieldUtil",
		"com.liferay.shopping.model.ShoppingItemFieldWrapper",
		"com.liferay.shopping.service.persistence.ShoppingItemFinder",
		"com.liferay.shopping.service.ShoppingItemLocalService",
		"com.liferay.shopping.service.ShoppingItemLocalServiceUtil",
		"com.liferay.shopping.service.ShoppingItemLocalServiceWrapper",
		"com.liferay.shopping.model.ShoppingItemModel",
		"com.liferay.shopping.service.persistence.ShoppingItemPersistence",
		"com.liferay.shopping.model.ShoppingItemPrice",
		"com.liferay.shopping.model.ShoppingItemPriceConstants",
		"com.liferay.shopping.service.ShoppingItemPriceLocalService",
		"com.liferay.shopping.service.ShoppingItemPriceLocalServiceUtil",
		"com.liferay.shopping.service.ShoppingItemPriceLocalServiceWrapper",
		"com.liferay.shopping.model.ShoppingItemPriceModel",
		"com.liferay.shopping.service.persistence.ShoppingItemPricePersistence",
		"com.liferay.shopping.model.ShoppingItemPriceSoap",
		"com.liferay.shopping.service.persistence.ShoppingItemPriceUtil",
		"com.liferay.shopping.model.ShoppingItemPriceWrapper",
		"com.liferay.shopping.service.ShoppingItemService",
		"com.liferay.shopping.service.ShoppingItemServiceUtil",
		"com.liferay.shopping.service.ShoppingItemServiceWrapper",
		"com.liferay.shopping.model.ShoppingItemSoap",
		"com.liferay.shopping.service.persistence.ShoppingItemUtil",
		"com.liferay.shopping.model.ShoppingItemWrapper",
		"com.liferay.shopping.model.ShoppingOrder",
		"com.liferay.shopping.model.ShoppingOrderConstants",
		"com.liferay.shopping.service.persistence.ShoppingOrderFinder",
		"com.liferay.shopping.model.ShoppingOrderItem",
		"com.liferay.shopping.service.ShoppingOrderItemLocalService",
		"com.liferay.shopping.service.ShoppingOrderItemLocalServiceUtil",
		"com.liferay.shopping.service.ShoppingOrderItemLocalServiceWrapper",
		"com.liferay.shopping.model.ShoppingOrderItemModel",
		"com.liferay.shopping.service.persistence.ShoppingOrderItemPersistence",
		"com.liferay.shopping.model.ShoppingOrderItemSoap",
		"com.liferay.shopping.service.persistence.ShoppingOrderItemUtil",
		"com.liferay.shopping.model.ShoppingOrderItemWrapper",
		"com.liferay.shopping.service.ShoppingOrderLocalService",
		"com.liferay.shopping.service.ShoppingOrderLocalServiceUtil",
		"com.liferay.shopping.service.ShoppingOrderLocalServiceWrapper",
		"com.liferay.shopping.model.ShoppingOrderModel",
		"com.liferay.shopping.service.persistence.ShoppingOrderPersistence",
		"com.liferay.shopping.service.ShoppingOrderService",
		"com.liferay.shopping.service.ShoppingOrderServiceUtil",
		"com.liferay.shopping.service.ShoppingOrderServiceWrapper",
		"com.liferay.shopping.model.ShoppingOrderSoap",
		"com.liferay.shopping.service.persistence.ShoppingOrderUtil",
		"com.liferay.shopping.model.ShoppingOrderWrapper",
		"com.liferay.portal.search.internal.SortFactoryImpl",
		"com.liferay.portal.monitoring.statistics.Statistics",
		"com.liferay.dynamic.data.mapping.storage.StorageAdapter",
		"com.liferay.dynamic.data.mapping.storage.StorageEngine",
		"com.liferay.dynamic.data.mapping.exception.StorageException",
		"com.liferay.dynamic.data.mapping.exception.StorageFieldNameException",
		"com.liferay.dynamic.data.mapping.exception.StructureDuplicateStructureKeyException",
		"com.liferay.dynamic.data.mapping.exception.StructureFieldException",
		"com.liferay.dynamic.data.mapping.util.comparator.StructureIdComparator",
		"com.liferay.dynamic.data.mapping.util.comparator.StructureModifiedDateComparator",
		"com.liferay.dynamic.data.mapping.util.comparator.StructureStructureKeyComparator",
		"com.liferay.portal.monitoring.statistics.SummaryStatistics",
		"com.liferay.portal.messaging.internal.sender.SynchronousMessageListener",
		"com.liferay.dynamic.data.mapping.exception.TemplateDuplicateTemplateKeyException",
		"com.liferay.dynamic.data.mapping.util.comparator.TemplateIdComparator",
		"com.liferay.dynamic.data.mapping.util.comparator.TemplateModifiedDateComparator",
		"com.liferay.dynamic.data.mapping.exception.TemplateNameException",
		"com.liferay.dynamic.data.mapping.exception.TemplateNameException",
		"com.liferay.dynamic.data.mapping.exception.TemplateScriptException",
		"com.liferay.dynamic.data.mapping.exception.TemplateSmallImageNameException",
		"com.liferay.dynamic.data.mapping.exception.TemplateSmallImageNameException",
		"com.liferay.dynamic.data.mapping.exception.TemplateSmallImageSizeException",
		"com.liferay.dynamic.data.mapping.exception.TemplateSmallImageSizeException",
		"com.liferay.mobile.device.rules.rule.UnknownRuleHandlerException",
		"com.liferay.portal.security.ldap.UserConverterKeys",
		"com.liferay.wiki.exception.WikiFormatException",
		"com.liferay.wiki.model.WikiNode",
		"com.liferay.wiki.service.WikiNodeLocalService",
		"com.liferay.wiki.service.WikiNodeLocalServiceUtil",
		"com.liferay.wiki.service.WikiNodeLocalServiceWrapper",
		"com.liferay.wiki.model.WikiNodeModel",
		"com.liferay.wiki.service.persistence.WikiNodePersistence",
		"com.liferay.wiki.service.WikiNodeService",
		"com.liferay.wiki.service.WikiNodeServiceUtil",
		"com.liferay.wiki.service.WikiNodeServiceWrapper",
		"com.liferay.wiki.model.WikiNodeSoap",
		"com.liferay.wiki.service.persistence.WikiNodeUtil",
		"com.liferay.wiki.model.WikiNodeWrapper",
		"com.liferay.wiki.model.WikiPage",
		"com.liferay.wiki.model.WikiPageConstants",
		"com.liferay.wiki.model.WikiPageDisplay",
		"com.liferay.wiki.service.persistence.WikiPageFinder",
		"com.liferay.wiki.service.WikiPageLocalService",
		"com.liferay.wiki.service.WikiPageLocalServiceUtil",
		"com.liferay.wiki.service.WikiPageLocalServiceWrapper",
		"com.liferay.wiki.model.WikiPageModel",
		"com.liferay.wiki.service.persistence.WikiPagePersistence",
		"com.liferay.wiki.model.WikiPageResource",
		"com.liferay.wiki.service.WikiPageResourceLocalService",
		"com.liferay.wiki.service.WikiPageResourceLocalServiceUtil",
		"com.liferay.wiki.service.WikiPageResourceLocalServiceWrapper",
		"com.liferay.wiki.model.WikiPageResourceModel",
		"com.liferay.wiki.service.persistence.WikiPageResourcePersistence",
		"com.liferay.wiki.model.WikiPageResourceSoap",
		"com.liferay.wiki.service.persistence.WikiPageResourceUtil",
		"com.liferay.wiki.model.WikiPageResourceWrapper",
		"com.liferay.wiki.service.WikiPageService",
		"com.liferay.wiki.service.WikiPageServiceUtil",
		"com.liferay.wiki.service.WikiPageServiceWrapper",
		"com.liferay.wiki.model.WikiPageSoap",
		"com.liferay.wiki.service.persistence.WikiPageUtil",
		"com.liferay.wiki.model.WikiPageWrapper"
	};

	public PortalServiceImports() {
		super(IMPORTS, IMPORTS_FIXED);
	}

}
