(function(mod) {
  if (typeof exports == "object" && typeof module == "object") // CommonJS
    return mod(require("tern/lib/infer"), require("tern/lib/tern"));
  if (typeof define == "function" && define.amd) // AMD
    return define([ "tern/lib/infer", "tern/lib/tern" ], mod);
  mod(tern, tern);
})(function(infer, tern) {
  "use strict";

  tern.registerPlugin("qooxdoo4.1", function(server, options) {
    server._ckeditor = {};
    return {
      defs : defs
    };
  });

  var defs = {"!name":"qooxdoo","!define":{},"q":{"!proto":"qxWeb","!doc":"<p>Compatibility class for {@link qxWeb}.</p>"},"qx":{"application":{"AbstractGui":{"!proto":"qx.core.Object","!doc":"<p>Abstract base class for <span class=\"caps\">GUI</span> applications using qooxdoo widgets.</p>","prototype":{"_createRootWidget":{"!doc":"<p>Create the root widget. This method is abstract and must be overridden\nby sub classes.</p>","!type":"fn() -> +qx.ui.core.Widget"},"close":{"!type":"fn(val: +undefined)"},"finalize":{"!type":"fn()"},"getRoot":{"!doc":"<p>Returns the application&#8217;s root widget. The root widgets can act as container\nfor popups. It is configured with a {@link qx.ui.layout.Basic} (if the\napplication is an inline application) layout or a {@link qx.ui.layout.Canvas}\n(if the application is a standalone application) layout .</p>\n\n<p>The root has the same add method as the configured layout\n({@link qx.ui.layout.Basic} or {@link qx.ui.layout.Canvas}).</p>","!type":"fn() -> +qx.ui.core.Widget"},"main":{"!type":"fn()"},"render":{"!doc":"<p>Updates the <span class=\"caps\">GUI</span> rendering</p>","!type":"fn()"},"terminate":{"!type":"fn()"}}},"Basic":{"!proto":"qx.core.Object","!doc":"<p>For a basic, out-of-browser application (running e.g. on Node.js, Rhino).</p>","prototype":{"close":{"!type":"fn()"},"finalize":{"!type":"fn()"},"main":{"!type":"fn()"},"terminate":{"!type":"fn()"}}},"IApplication":{"!doc":"<p>This interface defines what an application class has to implement.</p>","prototype":{"close":{"!doc":"<p>Called in the document.beforeunload event of the browser. If the method\nreturns a string value, the user will be asked by the browser, whether\nhe really wants to leave the page. The return string will be displayed in\nthe message box.</p>","!type":"fn() -> string"},"finalize":{"!doc":"<p>Called when the application&#8217;s main method was executed to handle\n&#8220;final&#8221; tasks like rendering or retrieving data.</p>","!type":"fn()"},"main":{"!doc":"<p>Called when the application relevant classes are loaded and ready.</p>","!type":"fn()"},"terminate":{"!doc":"<p>This method contains the last code which is run inside the page and may contain cleanup code.</p>","!type":"fn()"}}},"Inline":{"!proto":"qx.application.AbstractGui","!doc":"<p>For a <span class=\"caps\">GUI</span> application on a traditional, <span class=\"caps\">HTML</span>-dominated web page.</p>\n\n<p>The ideal environment for typical portal sites which use just a few qooxdoo\nwidgets. {@link qx.ui.root.Inline} can be used to embed qooxdoo widgets\ninto the page flow.</p>","prototype":{"_createRootWidget":{"!type":"fn()"}}},"Mobile":{"!proto":"qx.core.Object","!doc":"<p>For a mobile application. Supports the mobile widget set.</p>","!type":"fn()","prototype":{"_createRootWidget":{"!doc":"<p>Creates the application&#8217;s root widget. Override this function to create\nyour own root widget.</p>","!type":"fn() -> +qx.ui.mobile.core.Widget"},"close":{"!type":"fn()"},"finalize":{"!type":"fn()"},"getRoot":{"!doc":"<p>Returns the application&#8217;s root widget.</p>","!type":"fn() -> +qx.ui.mobile.core.Widget"},"getRouting":{"!doc":"<p>Returns the application&#8217;s routing.</p>","!type":"fn() -> +qx.application.Routing"},"main":{"!type":"fn()"},"terminate":{"!type":"fn()"}}},"Native":{"!proto":"qx.core.Object","!doc":"<p>For a Non-GUI application, supporting low-level <span class=\"caps\">DOM</span> operations and <span class=\"caps\">AJAX</span>\ncommunication.</p>","prototype":{"close":{"!type":"fn()"},"finalize":{"!type":"fn()"},"main":{"!type":"fn()"},"terminate":{"!type":"fn()"}}},"Routing":{"!doc":"<p>Basic application routing manager.</p>\n\n<p>Define routes to react on certain <span class=\"caps\">GET</span> / <span class=\"caps\">POST</span> / <span class=\"caps\">DELETE</span> / <span class=\"caps\">PUT</span> operations.</p>\n\n<ul>\n<li><span class=\"caps\">GET</span> is triggered when the hash value of the url is changed. Can be called<br />\n  manually by calling the {@link #executeGet} method.</li>\n<li><span class=\"caps\">POST</span> / <span class=\"caps\">DELETE</span> / <span class=\"caps\">PUT</span> has to be triggered manually right now (will be changed later)<br />\n   by calling the {@link #executePost}, {@link #executeDelete}, {@link #executePut} method.</li>\n</ul>\n\n<p>This manager can also be used to provide browser history.</p>\n\n<p><strong>Example</strong></p>\n\n<p>Here is a little example of how to use the widget.</p>\n\n<pre class=\"javascript\">\n  var r = new qx.application.Routing();\n\n  // show the start page, when no hash is given or the hash is \"#/\"\n  r.onGet(\"/\", function(data) {\n    startPage.show();\n  }, this);\n\n  // whenever the url /address is called show the address book page.\n  r.onGet(\"/address\", function(data) {\n    addressBookPage.show();\n  }, this);\n\n  // address with the parameter \"id\"\n  r.onGet(\"/address/{id}\", function(data) {\n    addressPage.show();\n    model.loadAddress(data.params.id);\n  }, this);\n\n  // Alternative you can use regExp for a route\n  r.onGet(/address\\/(.*)/, function(data) {\n    addressPage.show();\n    model.loadAddress(data.params.0);\n  }, this);\n\n  // make sure that the data is always loaded\n  r.onGet(\"/address.*\", function(data) {\n    if (!model.isLoaded()) {\n      model.loadAddresses();\n    }\n  }, this);\n\n  // update the address\n  r.onPost(\"/address/{id}\", function(data) {\n    model.updateAddress(data.params.id);\n  }, this);\n\n  // delete the address and navigate back\n  r.onDelete(\"/address/{id}\", function(data) {\n    model.deleteAddress(data.params.id);\n    r.executeGet(\"/address\", {reverse:true});\n  }, this);\n</pre>\n\n<p>This example defines different routes to handle navigation events.</p>","!type":"fn()","prototype":{"__addToHistory":{"!doc":"<p>Adds the custom data of a given path to the history.</p>","!type":"fn(path: string, customData: Object)"},"__getFromHistory":{"!doc":"<p>Returns a history entry for a certain path.</p>","!type":"fn(path: string) -> +Map"},"__onChangeHash":{"!doc":"<p>Hash change event handler.</p>","!type":"fn(evt: +qx.event.type.Data)"},"__replaceCustomData":{"!doc":"<p>Replaces the customData in the history objects with the recent custom data.</p>","!type":"fn(path: string, customData: Object)"},"_executeGet":{"!doc":"<p>Executes the get operation and informs all matching route handler.</p>","!type":"fn(path: string, customData: Object, fromEvent: Object)"},"_getPathOrFallback":{"!doc":"<p>Checks if path is valid and registered in channel &#8220;get&#8221; and then just returns it.\nIf the path is not valid either the <code>defaultPath</code> (if given) or the\n{@link #DEFAULT_PATH} will be returned.</p>","!type":"fn(path: string, defaultPath?: string) -> string"},"back":{"!doc":"<p>Navigates back to the previously executed path.</p>","!type":"fn(customData?: +Map)"},"dispose":{"!doc":"<p>Decouples the Routing from the navigation handler.</p>","!type":"fn()"},"execute":{"!doc":"<p>This is a shorthand for {@link #executeGet}.</p>","!type":"fn(path: string, customData: Object)"},"executeDelete":{"!doc":"<p>Executes the delete operation and informs all matching route handler.</p>","!type":"fn(path: string, params: +Map, customData: Object)"},"executeGet":{"!doc":"<p>Executes the get operation and informs all matching route handler.</p>","!type":"fn(path: string, customData: Object)"},"executePost":{"!doc":"<p>Executes the post operation and informs all matching route handler.</p>","!type":"fn(path: string, params: +Map, customData: Object)"},"executePut":{"!doc":"<p>Executes the put operation and informs all matching route handler.</p>","!type":"fn(path: string, params: +Map, customData: Object)"},"getState":{"!doc":"<p>Returns state value (history hash) of the navigation handler.</p>","!type":"fn() -> string"},"init":{"!doc":"<p>Initialization method used to execute the get route for the currently set history path.\nIf no path is set, either the given argument named <code>defaultPath</code>\nor the {@link #DEFAULT_PATH} will be used for initialization.</p>","!type":"fn(defaultPath?: string)"},"on":{"!doc":"<p>This is a shorthand for {@link #onGet}.</p>","!type":"fn(route: string, handler: fn(), scope: Object) -> string"},"onAny":{"!doc":"<p>Adds a route handler for the &#8220;any&#8221; operation. The &#8220;any&#8221; operation is called\nbefore all other operations.</p>","!type":"fn(route: string, handler: fn(), scope: Object) -> string"},"onDelete":{"!doc":"<p>Adds a route handler for the &#8220;delete&#8221; operation. The route gets called\nwhen the {@link #executeDelete} method found a match.</p>","!type":"fn(route: string, handler: fn(), scope: Object) -> string"},"onGet":{"!doc":"<p>Adds a route handler for the &#8220;get&#8221; operation. The route gets called\nwhen the {@link #executeGet} method found a match.</p>","!type":"fn(route: string, handler: fn(), scope: Object) -> string"},"onPost":{"!doc":"<p>Adds a route handler for the &#8220;post&#8221; operation. The route gets called\nwhen the {@link #executePost} method found a match.</p>","!type":"fn(route: string, handler: fn(), scope: Object) -> string"},"onPut":{"!doc":"<p>Adds a route handler for the &#8220;put&#8221; operation. The route gets called\nwhen the {@link #executePut} method found a match.</p>","!type":"fn(route: string, handler: fn(), scope: Object) -> string"},"remove":{"!doc":"<p>Removes a registered route by the given id.</p>","!type":"fn(id: string)"}}},"Standalone":{"!proto":"qx.application.AbstractGui","!doc":"<p>For a <span class=\"caps\">GUI</span> application that looks &amp; feels like native desktop application\n(often called &#8220;RIA&#8221; &#8211; Rich Internet Application).</p>\n\n<p>Such a stand-alone application typically creates and updates all content\ndynamically. Often it is called a &#8220;single-page application&#8221;, since the\ndocument itself is never reloaded or changed. Communication with the server\nis done with <span class=\"caps\">AJAX</span>.</p>","prototype":{"_createRootWidget":{"!type":"fn()"}}}},"bom":{"AnimationFrame":{"!proto":"qx.event.Emitter","!doc":"<p>This is a cross browser wrapper for requestAnimationFrame. For further\ninformation about the feature, take a look at spec:\n<a href=\"http://www.w3.org/TR/animation-timing/\">http://www.w3.org/TR/animation-timing/</a></p>\n\n<p>This class offers two ways of using this feature. First, the plain\n<span class=\"caps\">API</span> the spec describes.</p>\n\n<p>Here is a sample usage:</p>\n\n<pre class=\"javascript\">var start = +(new Date());\nvar clb = function(time) {\n  if (time >= start + duration) {\n    // ... do some last tasks\n  } else {\n    var timePassed = time - start;\n    // ... calculate the current step and apply it\n    qx.bom.AnimationFrame.request(clb, this);\n  }\n};\nqx.bom.AnimationFrame.request(clb, this);\n</pre>\n\n<p>Another way of using it is to use it as an instance emitting events.</p>\n\n<p>Here is a sample usage of that <span class=\"caps\">API</span>:</p>\n\n<pre class=\"javascript\">var frame = new qx.bom.AnimationFrame();\nframe.on(\"end\", function() {\n  // ... do some last tasks\n}, this);\nframe.on(\"frame\", function(timePassed) {\n  // ... calculate the current step and apply it\n}, this);\nframe.startSequence(duration);\n</pre>","prototype":{"cancelSequence":{"!doc":"<p>Cancels a started sequence of frames. It will do nothing if no\nsequence is running.</p>","!type":"fn()"},"startSequence":{"!doc":"<p>Method used to start a series of animation frames. The series will end as\nsoon as the given duration is over.</p>","!type":"fn(duration: number)"}},"calculateTiming":{"!doc":"<p>Calculation of the predefined timing functions. Approximation of the real\nbezier curves has been used for easier calculation. This is good and close\nenough for the predefined functions like <code>ease</code> or\n<code>linear</code>.</p>","!type":"fn(func: string, x: +Integer) -> +Integer"},"request":{"!doc":"<p>Request for an animation frame. If the native <code>requestAnimationFrame</code>\nmethod is supported, it will be used. Otherwise, we use timeouts with a\n30ms delay. The HighResolutionTime will be used if supported but the time given\nto the callback will still be a timestamp starting at 1 January 1970 00:00:00 <span class=\"caps\">UTC</span>.</p>","!type":"fn(callback: fn(), context: Object) -> number"}},"Blocker":{"!proto":"qx.core.Object","!doc":"<p>This class provides an unified blocker which offers three different modes.</p>\n\n<p><strong>Blocker modes</strong></p>\n\n<ul>\n<li>block the whole document</li>\n<li>block the content of an element</li>\n<li>act as an underlying blocker for an element to shim native controls</li>\n</ul>\n\n<p>The third mode is mainly necessary for IE browsers.</p>\n\n<p>The first mode is the easiest to use. Just use the {@link #block} method\nwithout a parameter.\nThe second and third mode are taking a <span class=\"caps\">DOM</span> element as parameter for the\n{@link #block} method. Additionally one need to setup the &#8220;zIndex&#8221; value\ncorrectly to get the right results (see at {@link #setBlockerZIndex} method).</p>\n\n<p>The zIndex value defaults to the value &#8220;10000&#8221;. Either you set an appropiate\nvalue for the blocker zIndex or for your <span class=\"caps\">DOM</span> element to block. If you want\nto block the content of your <span class=\"caps\">DOM</span> element it has to have at least the zIndex\nvalue of &#8220;10001&#8221; with default blocker values.</p>","!type":"fn()","prototype":{"__calculateStyles":{"!doc":"<p>Calculates the necessary styles for the blocker element.\nEither the values of the document or of the element to block are used.</p>","!type":"fn() -> +Map"},"__init":{"!doc":"<p>Setups the elements and registers a &#8220;resize&#8221; event.</p>","!type":"fn()"},"__isWholeDocumentBlockTarget":{"!doc":"<p>Checks whether the whole document is be blocked.</p>","!type":"fn() -> bool"},"__onResize":{"!doc":"<p>Reacts on window resize and adapts the new size for the blocker element\nif the whole document is blocked.</p>","!type":"fn(e: +qx.event.type.Event)"},"__removeBlocker":{"!doc":"<p>Remove the blocker elements.</p>","!type":"fn()"},"__resizeBlocker":{"!doc":"<p>Does the resizing for blocker element and blocker iframe element (IE)</p>","!type":"fn(dimension: Object)"},"__setupBlockerElement":{"!doc":"<p>Create blocker element and set initial styles.</p>","!type":"fn()"},"__setupIframeElement":{"!doc":"<p>Create iframe blocker element and set initial styles.</p>\n\n<p>Needed to block native form elements\n// see: <a href=\"http://www.macridesweb.com/oltest/IframeShim.html\">http://www.macridesweb.com/oltest/IframeShim.html</a></p>","!type":"fn()"},"__styleAndInsertBlocker":{"!doc":"<p>Apply the given styles and inserts the blocker.</p>","!type":"fn(styles: Object)"},"block":{"!doc":"<p>Blocks the whole document (if no parameter is given) or acts as an\nunderlying blocker for native controls.</p>","!type":"fn(element?: +element)"},"getBlockerColor":{"!doc":"<p>Returns the current blocker color.</p>","!type":"fn() -> string"},"getBlockerElement":{"!doc":"<p>Returns the blocker element. Useful if the element should be animated.</p>","!type":"fn() -> +Element"},"getBlockerOpacity":{"!doc":"<p>Returns the blocker opacity value.</p>","!type":"fn() -> +Integer"},"getBlockerZIndex":{"!doc":"<p>Returns the blocker zIndex value</p>","!type":"fn() -> +Integer"},"isBlocked":{"!doc":"<p>Whether the blocker is already active.</p>","!type":"fn() -> bool"},"setBlockerColor":{"!doc":"<p>Sets the color of the blocker element. Be sure to set also a suitable\nopacity value to get the desired result.</p>","!type":"fn(color: string)"},"setBlockerOpacity":{"!doc":"<p>Sets the blocker opacity. Be sure to set also a suitable blocker color\nvalue to get the desired result.</p>","!type":"fn(opacity: string)"},"setBlockerZIndex":{"!doc":"<p>Set the zIndex of the blocker element. For most use cases you do not need\nto manipulate this value.</p>","!type":"fn(zIndex: +Integer)"},"unblock":{"!doc":"<p>Releases the blocking</p>","!type":"fn()"}}},"client":{"Browser":{"!doc":"<p>Basic browser detection for qooxdoo.</p>\n\n<p>This class is used by {@link qx.core.Environment} and should not be used\ndirectly. Please check its class comment for details how to use it.</p>","getDocumentMode":{"!doc":"<p>Returns in which document mode the current document is (only for IE).</p>","!type":"fn() -> number"},"getName":{"!doc":"<p>Checks for the name of the browser and returns it.</p>","!type":"fn() -> string"},"getQuirksMode":{"!doc":"<p>Check if in quirks mode.</p>","!type":"fn() -> bool"},"getVersion":{"!doc":"<p>Determines the version of the current browser.</p>","!type":"fn() -> string"}},"Css":{"!doc":"<p>The purpose of this class is to contain all checks about css.</p>\n\n<p>This class is used by {@link qx.core.Environment} and should not be used\ndirectly. Please check its class comment for details how to use it.</p>","__isFilterSupported":{"!doc":"<p>Checks if the given filter is supported.</p>","!type":"fn(filterClass: string, initParams: string) -> bool"},"getAlphaImageLoaderNeeded":{"!doc":"<p>Checks if the Alpha Image Loader must be used to display transparent PNGs.</p>","!type":"fn() -> bool"},"getAppearance":{"!doc":"<p>Returns the (possibly vendor-prefixed) name the browser uses for the\n<code>appearance</code> style property.</p>","!type":"fn() -> string"},"getBorderImage":{"!doc":"<p>Returns the (possibly vendor-prefixed) name the browser uses for the\n<code>borderImage</code> style property.</p>","!type":"fn() -> string"},"getBorderImageSyntax":{"!doc":"<p>Returns the type of syntax this client supports for its <span class=\"caps\">CSS</span> border-image\nimplementation. Some browsers do not support the &#8220;fill&#8221; keyword defined\nin the W3C draft (<a href=\"http://www.w3.org/TR/css3-background/\">http://www.w3.org/TR/css3-background/</a>) and will not\nshow the border image if it&#8217;s set. Others follow the standard closely and\nwill omit the center image if &#8220;fill&#8221; is not set.</p>","!type":"fn() -> bool"},"getBorderRadius":{"!doc":"<p>Returns the (possibly vendor-prefixed) name the browser uses for the\n<code>borderRadius</code> style property.</p>","!type":"fn() -> string"},"getBoxModel":{"!doc":"<p>Checks what box model is used in the current environemnt.</p>","!type":"fn() -> string"},"getBoxShadow":{"!doc":"<p>Returns the (possibly vendor-prefixed) name the browser uses for the\n<code>boxShadow</code> style property.</p>","!type":"fn() -> string"},"getBoxSizing":{"!doc":"<p>Returns the (possibly vendor-prefixed) name the browser uses for the\n<code>boxSizing</code> style property.</p>","!type":"fn() -> string"},"getFilterGradient":{"!doc":"<p>Returns <code>true</code> if the browser supports setting gradients\nusing the filter style. This usually only applies for IE browsers\nstarting from IE5.5.\n<a href=\"http://msdn.microsoft.com/en-us/library/ms532997\">http://msdn.microsoft.com/en-us/library/ms532997</a>(v=vs.85).aspx</p>","!type":"fn() -> bool"},"getFilterTextShadow":{"!doc":"<p>Returns <code>true</code> if the browser supports setting text shadow\nusing the filter style. This usually only applies for IE browsers\nstarting from IE5.5.</p>","!type":"fn() -> bool"},"getFlexboxSyntax":{"!doc":"<p>Returns which Flexbox syntax is supported by the browser.\n<code>display: box;</code> old 2009 version of Flexbox.\n<code>display: flexbox;</code> tweener phase in 2011.\n<code>display: flex;</code> current specification.</p>","!type":"fn() -> string"},"getFloat":{"!doc":"<p>Returns the vendor-specific name of the <code>float</code> style property</p>","!type":"fn() -> string"},"getInlineBlock":{"!doc":"<p>Returns the browser-specific name used for the <code>display</code> style\nproperty&#8217;s <code>inline-block</code> value.</p>","!type":"fn() -> string"},"getLegacyWebkitGradient":{"!doc":"<p>Checks if <b>only</b> the old WebKit (version < 534.16) syntax for\nlinear gradients is supported, e.g.\n<code>linear-gradient(0deg, #fff, #000)</code></p>","!type":"fn() -> bool"},"getLinearGradient":{"!doc":"<p>Returns the (possibly vendor-prefixed) name this client uses for\n<code>linear-gradient</code>.\n<a href=\"http://dev.w3.org/csswg/css3-images/#linear-gradients\">http://dev.w3.org/csswg/css3-images/#linear-gradients</a></p>","!type":"fn() -> string"},"getOpacity":{"!doc":"<p>Checks if <span class=\"caps\">CSS</span> opacity is supported</p>","!type":"fn() -> bool"},"getPlaceholder":{"!doc":"<p>Checks if a placeholder could be used.</p>","!type":"fn() -> bool"},"getPointerEvents":{"!doc":"<p>Checks if pointer events are available.</p>","!type":"fn() -> bool"},"getRadialGradient":{"!doc":"<p>Returns the (possibly vendor-prefixed) name this client uses for\n<code>radial-gradient</code>.</p>","!type":"fn() -> string"},"getRgba":{"!doc":"<p>Checks if rgba colors can be used:\n<a href=\"http://www.w3.org/TR/2010/PR-css3-color-20101028/#rgba-color\">http://www.w3.org/TR/2010/PR-css3-color-20101028/#rgba-color</a></p>","!type":"fn() -> bool"},"getTextOverflow":{"!doc":"<p>Returns the (possibly vendor-prefixed) name the browser uses for the\n<code>textOverflow</code> style property.</p>","!type":"fn() -> string"},"getTextShadow":{"!doc":"<p>Checks if <span class=\"caps\">CSS</span> texShadow is supported</p>","!type":"fn() -> bool"},"getTranslate3d":{"!doc":"<p>Checks if translate3d can be used.</p>","!type":"fn() -> bool"},"getUserModify":{"!doc":"<p>Returns the (possibly vendor-prefixed) name the browser uses for the\n<code>userModify</code> style property.</p>","!type":"fn() -> string"},"getUserSelect":{"!doc":"<p>Returns the (possibly vendor-prefixed) name the browser uses for the\n<code>userSelect</code> style property.</p>","!type":"fn() -> string"},"getUserSelectNone":{"!doc":"<p>Returns the (possibly vendor-prefixed) value for the\n<code>userSelect</code> style property that disables selection. For Gecko,\n&#8221;-moz-none&#8221; is returned since &#8220;none&#8221; only makes the target element appear\nas if its text could not be selected</p>","!type":"fn() -> string"}},"CssAnimation":{"!doc":"<p>Responsible for checking all relevant animation properties.</p>\n\n<p>Spec: <a href=\"http://www.w3.org/TR/css3-animations/\">http://www.w3.org/TR/css3-animations/</a></p>","getAnimationEnd":{"!doc":"<p>Checks for the event name of animation end.</p>","!type":"fn() -> string"},"getAnimationIteration":{"!doc":"<p>Checks for the event name of animation end.</p>","!type":"fn() -> string"},"getAnimationStart":{"!doc":"<p>Checks for the event name of animation start.</p>","!type":"fn() -> string"},"getFillMode":{"!doc":"<p>Checks for the &#8216;animation-fill-mode&#8217; <span class=\"caps\">CSS</span> style.</p>","!type":"fn() -> string"},"getKeyFrames":{"!doc":"<p>Checks what selector should be used to add keyframes to stylesheets.</p>","!type":"fn() -> string"},"getName":{"!doc":"<p>Checks for the style name used for animations.</p>","!type":"fn() -> string"},"getPlayState":{"!doc":"<p>Checks for the &#8216;animation-play-state&#8217; <span class=\"caps\">CSS</span> style.</p>","!type":"fn() -> string"},"getRequestAnimationFrame":{"!doc":"<p>Checks for the requestAnimationFrame method and return the prefixed name.</p>","!type":"fn() -> string"},"getSupport":{"!doc":"<p>Main check method which returns an object if <span class=\"caps\">CSS</span> animations are\nsupported. This object contains all necessary keys to work with <span class=\"caps\">CSS</span>\nanimations.\n<ul>\n <li><code>name</code> The name of the css animation style</li>\n <li><code>play-state</code> The name of the play-state style</li>\n <li><code>start-event</code> The name of the start event</li>\n <li><code>iternation-event</code> The name of the iternation event</li>\n <li><code>end-event</code> The name of the end event</li>\n <li><code>fill-mode</code> The fill-mode style</li>\n <li><code>keyframes</code> The name of the keyframes selector.</li>\n</ul></p>","!type":"fn() -> Object"}},"CssTransform":{"!doc":"<p>Responsible for checking all relevant <span class=\"caps\">CSS</span> transform properties.</p>\n\n<p>Specs:\n<a href=\"http://www.w3.org/TR/css3-2d-transforms/\">http://www.w3.org/TR/css3-2d-transforms/</a>\n<a href=\"http://www.w3.org/TR/css3-3d-transforms/\">http://www.w3.org/TR/css3-3d-transforms/</a></p>","get3D":{"!doc":"<p>Checks if 3D transforms are supported.</p>","!type":"fn() -> bool"},"getBackFaceVisibility":{"!doc":"<p>Checks for the style name used to set the backface visibility.</p>","!type":"fn() -> string"},"getName":{"!doc":"<p>Checks for the style name used for transforms.</p>","!type":"fn() -> string"},"getOrigin":{"!doc":"<p>Checks for the style name used to set the transform origin.</p>","!type":"fn() -> string"},"getPerspective":{"!doc":"<p>Checks for the style name used to set the transform origin.</p>","!type":"fn() -> string"},"getPerspectiveOrigin":{"!doc":"<p>Checks for the style name used to set the perspective origin.</p>","!type":"fn() -> string"},"getStyle":{"!doc":"<p>Checks for the style name used to set the transform origin.</p>","!type":"fn() -> string"},"getSupport":{"!doc":"<p>Main check method which returns an object if <span class=\"caps\">CSS</span> animations are\nsupported. This object contains all necessary keys to work with <span class=\"caps\">CSS</span>\nanimations.\n<ul>\n <li><code>name</code> The name of the css transform style</li>\n <li><code>style</code> The name of the css transform-style style</li>\n <li><code>origin</code> The name of the transform-origin style</li>\n <li><code>3d</code> Whether 3d transforms are supported</li>\n <li><code>perspective</code> The name of the perspective style</li>\n <li><code>perspective-origin</code> The name of the perspective-origin style</li>\n <li><code>backface-visibility</code> The name of the backface-visibility style</li>\n</ul></p>","!type":"fn() -> Object"}},"CssTransition":{"!doc":"<p><span class=\"caps\">CSS</span> Transition support checks.</p>\n\n<p>Spec: <a href=\"http://www.w3.org/TR/css3-transitions/\">http://www.w3.org/TR/css3-transitions/</a></p>","getSupport":{"!doc":"<p>Main check method which returns an object if <span class=\"caps\">CSS</span> transitions are\nsupported. The object contains the following keys:\n<ul>\n <li><code>name</code> The name of the <span class=\"caps\">CSS</span> transition property</li>\n <li><code>end-event</code> The name of the end event</li>\n</ul></p>","!type":"fn() -> Object"},"getTransitionName":{"!doc":"<p>Returns the (possibly vendor-prefixed) name of the <span class=\"caps\">CSS</span> transition property</p>","!type":"fn() -> string"}},"Device":{"!doc":"<p>The class is responsible for device detection. This is specially usefull\nif you are on a mobile device.</p>\n\n<p>This class is used by {@link qx.core.Environment} and should not be used\ndirectly. Please check its class comment for details how to use it.</p>","detectDeviceType":{"!doc":"<p>Detects the device type, based on given userAgentString.</p>","!type":"fn(userAgentString: string) -> string"},"detectMobileDevice":{"!doc":"<p>Detects if a device is a mobile phone. (Tablets excluded.)</p>","!type":"fn(userAgentString: string) -> bool"},"detectTabletDevice":{"!doc":"<p>Detects if a device is a tablet device.</p>","!type":"fn(userAgentString: string) -> bool"},"getDevicePixelRatio":{"!doc":"<p>Detects the device&#8217;s pixel ratio. Returns 1 if detection is not possible.</p>","!type":"fn() -> number"},"getName":{"!doc":"<p>Returns the name of the current device if detectable. It falls back to\n<code>pc</code> if the detection for other devices fails.</p>","!type":"fn() -> string"},"getTouch":{"!doc":"<p>Detects if either touch events or pointer events are supported.\nAdditionally it checks if touch is enabled for pointer events.</p>","!type":"fn() -> bool"},"getType":{"!doc":"<p>Determines on what type of device the application is running.\nValid values are: &#8220;mobile&#8221;, &#8220;tablet&#8221; or &#8220;desktop&#8221;.</p>","!type":"fn() -> string"}},"EcmaScript":{"!doc":"<p>The main purpose of this class to hold all checks about ECMAScript.</p>\n\n<p>This class is used by {@link qx.core.Environment} and should not be used\ndirectly. Please check its class comment for details how to use it.</p>","getArrayEvery":{"!doc":"<p>Checks if &#8216;every&#8217; is supported on the Array object.</p>","!type":"fn() -> bool"},"getArrayFilter":{"!doc":"<p>Checks if &#8216;filter&#8217; is supported on the Array object.</p>","!type":"fn() -> bool"},"getArrayForEach":{"!doc":"<p>Checks if &#8216;forEach&#8217; is supported on the Array object.</p>","!type":"fn() -> bool"},"getArrayIndexOf":{"!doc":"<p>Checks if &#8216;indexOf&#8217; is supported on the Array object.</p>","!type":"fn() -> bool"},"getArrayLastIndexOf":{"!doc":"<p>Checks if &#8216;lastIndexOf&#8217; is supported on the Array object.</p>","!type":"fn() -> bool"},"getArrayMap":{"!doc":"<p>Checks if &#8216;map&#8217; is supported on the Array object.</p>","!type":"fn() -> bool"},"getArrayReduce":{"!doc":"<p>Checks if &#8216;reduce&#8217; is supported on the Array object.</p>","!type":"fn() -> bool"},"getArrayReduceRight":{"!doc":"<p>Checks if &#8216;reduceRight&#8217; is supported on the Array object.</p>","!type":"fn() -> bool"},"getArraySome":{"!doc":"<p>Checks if &#8216;some&#8217; is supported on the Array object.</p>","!type":"fn() -> bool"},"getDateNow":{"!doc":"<p>Checks if &#8216;now&#8217; is supported on the Date object.</p>","!type":"fn() -> bool"},"getErrorToString":{"!doc":"<p>Checks if &#8216;toString&#8217; is supported on the Error object and\nits working as expected.</p>","!type":"fn() -> bool"},"getFunctionBind":{"!doc":"<p>Checks if &#8216;bind&#8217; is supported on the Function object.</p>","!type":"fn() -> bool"},"getObjectKeys":{"!doc":"<p>Checks if &#8216;keys&#8217; is supported on the Object object.</p>","!type":"fn() -> bool"},"getStackTrace":{"!doc":"<p>Returns the name of the Error object property that holds stack trace\ninformation or null if the client does not provide any.</p>","!type":"fn() -> string"},"getStringTrim":{"!doc":"<p>Checks if &#8216;trim&#8217; is supported on the String object.</p>","!type":"fn() -> bool"}},"Engine":{"!doc":"<p>This class comes with all relevant information regarding\nthe client&#8217;s engine.</p>\n\n<p>This class is used by {@link qx.core.Environment} and should not be used\ndirectly. Please check its class comment for details how to use it.</p>","__isGecko":{"!doc":"<p>Internal helper for checking for gecko.</p>\n\n<p>Note:\n &#8220;window.controllers&#8221; is gone/hidden with Firefox 30+\n &#8220;window.navigator.mozApps&#8221; is supported since Firefox 11+\n &#8220;window.navigator.product&#8221; is actually useless cause the HTML5 spec\n   states it should be the constant &#8220;Gecko&#8221;.</p>\n\n<p>- <a href=\"https://developer.mozilla.org/en-US/docs/Web/API/Window.controllers\">https://developer.mozilla.org/en-US/docs/Web/API/Window.controllers</a>\n &#8211; <a href=\"https://developer.mozilla.org/en-US/docs/Web/API/Navigator.mozApps\">https://developer.mozilla.org/en-US/docs/Web/API/Navigator.mozApps</a>\n &#8211; <a href=\"http://www.w3.org/html/wg/drafts/html/master/webappapis.html#navigatorid\">http://www.w3.org/html/wg/drafts/html/master/webappapis.html#navigatorid</a></p>","!type":"fn() -> bool"},"__isMaple":{"!doc":"<p>Internal helper for checking for Maple .\nMaple is used in Samsung <span class=\"caps\">SMART</span> TV 2010-2011 models. It&#8217;s based on Gecko\nengine 1.8.1.11.</p>","!type":"fn() -> bool"},"__isMshtml":{"!doc":"<p>Internal helper to check for <span class=\"caps\">MSHTML</span>.</p>","!type":"fn() -> bool"},"__isOpera":{"!doc":"<p>Internal helper for checking for opera (presto powered).</p>\n\n<p>Note that with opera >= 15 their engine switched to blink, so\nthings like &#8220;window.opera&#8221; don&#8217;t work anymore or changed (e.g. user agent).</p>","!type":"fn() -> bool"},"__isWebkit":{"!doc":"<p>Internal helper for checking for webkit.</p>","!type":"fn() -> bool"},"getName":{"!doc":"<p>Returns the name of the engine.</p>","!type":"fn() -> string"},"getVersion":{"!doc":"<p>Returns the version of the engine.</p>","!type":"fn() -> string"}},"Event":{"!doc":"<p>Internal class which contains the checks used by {@link qx.core.Environment}.\nAll checks in here are marked as internal which means you should never use\nthem directly.</p>\n\n<p>This class should contain all checks about events.</p>","getCustomEvent":{"!doc":"<p>Checks if the CustomEvent constructor is available and supports\ncustom event types.</p>","!type":"fn() -> bool"},"getDispatchEvent":{"!doc":"<p>Checks if the DOM2 dispatchEvent method is available</p>","!type":"fn() -> bool"},"getHashChange":{"!doc":"<p>Checks if the <code>hashchange</code> event is available</p>","!type":"fn() -> bool"},"getHelp":{"!doc":"<p>Checks if the proprietary <code>help</code> event is available.</p>","!type":"fn() -> bool"},"getMouseEvent":{"!doc":"<p>Checks if the MouseEvent constructor is available and supports\ncustom event types.</p>","!type":"fn() -> bool"},"getMouseWheel":{"!doc":"<p>Checks if the MouseWheel event is available and on which target.</p>","!type":"fn(win?: +Window) -> +Map"},"getMsPointer":{"!doc":"<p>Checks if MSPointer events are available.</p>","!type":"fn() -> bool"},"getTouch":{"!doc":"<p>Checks if touch events are supported.</p>","!type":"fn() -> bool"}},"Flash":{"!doc":"<p>This class contains all Flash detection.</p>\n\n<p>It is used by {@link qx.core.Environment} and should not be used\ndirectly. Please check its class comment for details how to use it.</p>","__supportsVersion":{"!doc":"<p>Check if the first given version is supported by either the current\nversion available on the system or the optional given second parameter.</p>","!type":"fn(input: string, availableVersion: string) -> bool"},"getExpressInstall":{"!doc":"<p>Checks if the flash installation is an expres installation.</p>","!type":"fn() -> bool"},"getStrictSecurityModel":{"!doc":"<p>Checks if a strict security model is available.</p>","!type":"fn() -> bool"},"getVersion":{"!doc":"<p>Checks for the version of flash and returns it as a string. If the\nversion could not be detected, an empty string will be returned.</p>","!type":"fn() -> string"},"isAvailable":{"!doc":"<p>Checks if the flash plugin is available.</p>","!type":"fn() -> bool"}},"Html":{"!doc":"<p>Internal class which contains the checks used by {@link qx.core.Environment}.\nAll checks in here are marked as internal which means you should never use\nthem directly.</p>\n\n<p>This class should contain all checks about <span class=\"caps\">HTML</span>.</p>","getAudio":{"!doc":"<p>Whether the client supports audio.</p>","!type":"fn() -> bool"},"getAudioAif":{"!doc":"<p>Whether the client can play aif audio format.</p>","!type":"fn() -> string"},"getAudioAu":{"!doc":"<p>Whether the client can play au audio format.</p>","!type":"fn() -> string"},"getAudioMp3":{"!doc":"<p>Whether the client can play mp3 audio format.</p>","!type":"fn() -> string"},"getAudioOgg":{"!doc":"<p>Whether the client can play ogg audio format.</p>","!type":"fn() -> string"},"getAudioWav":{"!doc":"<p>Whether the client can play wave audio wave format.</p>","!type":"fn() -> string"},"getCanvas":{"!doc":"<p>Checks if canvas could be used</p>","!type":"fn() -> bool"},"getClassList":{"!doc":"<p>Whether the browser supports <span class=\"caps\">CSS</span> class lists.\n<a href=\"https://developer.mozilla.org/en-US/docs/DOM/element.classList\">https://developer.mozilla.org/en-US/docs/DOM/element.classList</a></p>","!type":"fn() -> bool"},"getCompareDocumentPosition":{"!doc":"<p>Check for element.compareDocumentPosition</p>","!type":"fn() -> bool"},"getConsole":{"!doc":"<p>Check for a console object.</p>","!type":"fn() -> bool"},"getContains":{"!doc":"<p>Check for element.contains</p>","!type":"fn() -> bool"},"getDataset":{"!doc":"<p>Checks if dataset could be used</p>","!type":"fn() -> bool"},"getDataUrl":{"!doc":"<p>Asynchronous check for using data urls.</p>","!type":"fn(callback: fn())"},"getFileReader":{"!doc":"<p>Whether the client supports File Readers</p>","!type":"fn() -> bool"},"getGeoLocation":{"!doc":"<p>Whether the client supports Geo Location.</p>","!type":"fn() -> bool"},"getHistoryState":{"!doc":"<p>Check for HTML5 history manipulation support.</p>","!type":"fn() -> bool"},"getIsEqualNode":{"!doc":"<p>Check for the isEqualNode <span class=\"caps\">DOM</span> method.</p>","!type":"fn() -> bool"},"getLocalStorage":{"!doc":"<p>Whether the client supports local storage.</p>","!type":"fn() -> bool"},"getNaturalDimensions":{"!doc":"<p>Check for the <code>naturalHeight</code> and <code>naturalWidth</code>\nimage element attributes.</p>","!type":"fn() -> bool"},"getSelection":{"!doc":"<p>Returns the name of the native object/function used to access the\ndocument&#8217;s text selection.</p>","!type":"fn() -> string"},"getSessionStorage":{"!doc":"<p>Whether the client supports session storage.</p>","!type":"fn() -> bool"},"getSvg":{"!doc":"<p>Checks if <span class=\"caps\">SVG</span> could be used</p>","!type":"fn() -> bool"},"getTextContent":{"!doc":"<p>Check for element.textContent. Legacy IEs do not support this, use\ninnerText instead.</p>","!type":"fn() -> bool"},"getUserDataStorage":{"!doc":"<p>Whether the client supports user data to persist data. This is only\nrelevant for IE < 8.</p>","!type":"fn() -> bool"},"getVideo":{"!doc":"<p>Whether the client supports video.</p>","!type":"fn() -> bool"},"getVideoH264":{"!doc":"<p>Whether the client supports mp4 video.</p>","!type":"fn() -> string"},"getVideoOgg":{"!doc":"<p>Whether the client supports ogg video.</p>","!type":"fn() -> string"},"getVideoWebm":{"!doc":"<p>Whether the client supports webm video.</p>","!type":"fn() -> string"},"getVml":{"!doc":"<p>Checks if <span class=\"caps\">VML</span> is supported</p>","!type":"fn() -> bool"},"getWebWorker":{"!doc":"<p>Whether the client supports Web Workers.</p>","!type":"fn() -> bool"},"getXPath":{"!doc":"<p>Checks if XPath could be used.</p>","!type":"fn() -> bool"},"getXul":{"!doc":"<p>Checks if <span class=\"caps\">XUL</span> could be used.</p>","!type":"fn() -> bool"}},"Json":{"!doc":"<p><span class=\"caps\">JSON</span> detection.</p>\n\n<p>This class is used by {@link qx.core.Environment} and should not be used\ndirectly. Please check its class comment for details how to use it.</p>","getJson":{"!doc":"<p>Checks if native <span class=\"caps\">JSON</span> could be used and is full-featured.</p>","!type":"fn() -> bool"}},"Locale":{"!doc":"<p>This class comes with all relevant information regarding\nthe client&#8217;s selected locale.</p>\n\n<p>This class is used by {@link qx.core.Environment} and should not be used\ndirectly. Please check its class comment for details how to use it.</p>","__getNavigatorLocale":{"!doc":"<p>Internal helper for accessing the navigators language.</p>","!type":"fn() -> string"},"getLocale":{"!doc":"<p>The name of the system locale e.g. &#8220;de&#8221; when the full locale is &#8220;de_AT&#8221;</p>","!type":"fn() -> string"},"getVariant":{"!doc":"<p>The name of the variant for the system locale e.g. &#8220;at&#8221; when the\nfull locale is &#8220;de_AT&#8221;</p>","!type":"fn() -> string"}},"OperatingSystem":{"!doc":"<p>This class is responsible for checking the operating systems name.</p>\n\n<p>This class is used by {@link qx.core.Environment} and should not be used\ndirectly. Please check its class comment for details how to use it.</p>","__getVersionForDesktopOs":{"!doc":"<p>Detect OS version for desktop devices</p>","!type":"fn(userAgent: string) -> string"},"__getVersionForMobileOs":{"!doc":"<p>Detect OS version for mobile devices</p>","!type":"fn(userAgent: string) -> string"},"getName":{"!doc":"<p>Checks for the name of the operating system.</p>","!type":"fn() -> string"},"getVersion":{"!doc":"<p>Checks for the version of the operating system using the internal map.</p>","!type":"fn() -> string"}},"Pdfjs":{"!doc":"<p>Exposes PluginDetect_PDFjs to qooxdoo.</p>\n\n<p>Contains detection for <span class=\"caps\">PDF</span>.js which is a Portable Document Format (PDF)\nviewer that is built with HTML5. <span class=\"caps\">PDF</span>.js is built into Firefox 19+ and\nused as default viewer there. You can enable/disable it via &#8220;about:config&#8221;\nand &#8220;pdfjs.disabled&#8221; (true/false).</p>\n\n<p>As soon as there is an official way to detect this, which seems to be\nworked on [1]<sup class=\"footnote\"><a href=\"#fn2\">2</a></sup>, we should switch.</p>\n\n<p>[1] <a href=\"https://bugzilla.mozilla.org/show_bug.cgi?id=840439\">https://bugzilla.mozilla.org/show_bug.cgi?id=840439</a>\n[2] <a href=\"https://bugzilla.mozilla.org/show_bug.cgi?id=558184\">https://bugzilla.mozilla.org/show_bug.cgi?id=558184</a></p>\n\n<p>This class is used by {@link qx.core.Environment} and should not be used\ndirectly. Please check its class comment for details how to use it.</p>","__isAvailable":{"!doc":"<p>Internal helper for checking the availability of <span class=\"caps\">PDF</span>.js.</p>","!type":"fn(callback: fn(), context: Object)"},"getPdfjs":{"!doc":"<p>Checks if <span class=\"caps\">PDF</span>.js is available.</p>","!type":"fn(callback: fn(), context: Object)"}},"PhoneGap":{"!doc":"<p>The purpose of this class is to contain all checks for PhoneGap/Cordova.</p>\n\n<p>This class is used by {@link qx.core.Environment} and should not be used\ndirectly. Please check its class comment for details how to use it.</p>","getNotification":{"!doc":"<p>Checks if notifications can be displayed.</p>","!type":"fn() -> bool"},"getPhoneGap":{"!doc":"<p>Checks if PhoneGap/Cordova is available.</p>","!type":"fn() -> bool"}},"Plugin":{"!doc":"<p>Contains detection for QuickTime, Windows Media, DivX, Silverlight adn gears.\nIf no version could be detected the version is set to an empty string as\ndefault.</p>\n\n<p>This class is used by {@link qx.core.Environment} and should not be used\ndirectly. Please check its class comment for details how to use it.</p>","__getVersion":{"!doc":"<p>Internal helper for getting the version of a given plugin.</p>","!type":"fn(activeXName: string, pluginNames: +Array) -> string"},"__isAvailable":{"!doc":"<p>Internal helper for getting the availability of a given plugin.</p>","!type":"fn(activeXName: string, pluginNames: +Array) -> bool"},"getActiveX":{"!doc":"<p>Checks for ActiveX availability.</p>","!type":"fn() -> bool"},"getDivX":{"!doc":"<p>Checks if the divx plugin is available.</p>","!type":"fn() -> bool"},"getDivXVersion":{"!doc":"<p>Fetches the version of the divx plugin.</p>","!type":"fn() -> string"},"getGears":{"!doc":"<p>Checkes for the availability of google gears plugin.</p>","!type":"fn() -> bool"},"getPdf":{"!doc":"<p>Checks if the pdf plugin is available.</p>\n\n<p>There are two built-in <span class=\"caps\">PDF</span> viewer shipped with browsers:</p>\n\n<ul>\n <li>Chrome PDF Viewer</li>\n <li>PDF.js (Firefox)</li>\n</ul>\n\n<p>While the Chrome <span class=\"caps\">PDF</span> Viewer is implemented as plugin and therefore\ndetected by this method <span class=\"caps\">PDF</span>.js is <strong>not</strong>.</p>\n\n<p>See the dedicated environment key (<em>plugin.pdfjs</em>) instead,\nwhich you might check additionally.</p>","!type":"fn() -> bool"},"getPdfVersion":{"!doc":"<p>Fetches the version of the pdf plugin.</p>\n\n<p>There are two built-in <span class=\"caps\">PDF</span> viewer shipped with browsers:</p>\n\n<ul>\n <li>Chrome PDF Viewer</li>\n <li>PDF.js (Firefox)</li>\n</ul>\n\n<p>While the Chrome <span class=\"caps\">PDF</span> Viewer is implemented as plugin and therefore\ndetected by this method <span class=\"caps\">PDF</span>.js is <strong>not</strong>.</p>\n\n<p>See the dedicated environment key (<em>plugin.pdfjs</em>) instead,\nwhich you might check additionally.</p>","!type":"fn() -> string"},"getQuicktime":{"!doc":"<p>Checks if the quicktime plugin is available.</p>","!type":"fn() -> bool"},"getQuicktimeVersion":{"!doc":"<p>Fetches the version of the quicktime plugin.</p>","!type":"fn() -> string"},"getSilverlight":{"!doc":"<p>Checks if the silverlight plugin is available.</p>","!type":"fn() -> bool"},"getSilverlightVersion":{"!doc":"<p>Fetches the version of the silverlight plugin.</p>","!type":"fn() -> string"},"getSkype":{"!doc":"<p>Checks for Skypes &#8216;Click to call&#8217; availability.</p>","!type":"fn() -> bool"},"getWindowsMedia":{"!doc":"<p>Checks if the windows media plugin is available.</p>","!type":"fn() -> bool"},"getWindowsMediaVersion":{"!doc":"<p>Fetches the version of the windows media plugin.</p>","!type":"fn() -> string"}},"Runtime":{"!doc":"<p>Basic runtime detection for qooxdoo.</p>\n\n<p>This class is used by {@link qx.core.Environment} and should not be used\ndirectly. Please check its class comment for details how to use it.</p>","getName":{"!doc":"<p>Checks for the name of the runtime and returns it. In general, it checks\nfor rhino and node.js and if that could not be detected, it falls back\nto the browser name defined by {@link qx.bom.client.Browser#getName}.</p>","!type":"fn() -> string"}},"Scroll":{"!doc":"<p>This class is responsible for checking the scrolling behavior of the client.</p>\n\n<p>This class is used by {@link qx.core.Environment} and should not be used\ndirectly. Please check its class comment for details how to use it.</p>","getNativeScroll":{"!doc":"<p>Checks if native scroll can be used for the current mobile device.</p>","!type":"fn() -> bool"},"scrollBarOverlayed":{"!doc":"<p>Check if the scrollbars should be positioned on top of the content. This\nis true of <span class=\"caps\">OSX</span> Lion when the scrollbars disappear automatically.</p>","!type":"fn() -> bool"}},"Stylesheet":{"!doc":"<p>Internal class which contains the checks used by {@link qx.core.Environment}.\nAll checks in here are marked as internal which means you should never use\nthem directly.</p>\n\n<p>This class contains checks related to Stylesheet objects.</p>","__getStylesheet":{"!doc":"<p>Returns a stylesheet to be used for feature checks</p>","!type":"fn() -> +Stylesheet"},"getAddImport":{"!doc":"<p>Decides whether to use the legacy IE-only stylesheet.addImport or the\n<span class=\"caps\">DOM</span>-standard stylesheet.insertRule(&#8217;@import [...]&#8217;)</p>","!type":"fn() -> bool"},"getCreateStyleSheet":{"!doc":"<p>Check for IE&#8217;s non-standard document.createStyleSheet function.\nIn IE9 (standards mode), the typeof check returns &#8220;function&#8221; so false is\nreturned. This is intended since IE9 supports the <span class=\"caps\">DOM</span>-standard\ncreateElement(&#8220;style&#8221;) which should be used instead.</p>","!type":"fn() -> bool"},"getDeleteRule":{"!doc":"<p>Check for stylesheet.deleteRule. Legacy IEs do not support this.</p>","!type":"fn() -> bool"},"getInsertRule":{"!doc":"<p>Check for stylesheet.insertRule. Legacy IEs do not support this.</p>","!type":"fn() -> bool"},"getRemoveImport":{"!doc":"<p>Decides whether to use the legacy IE-only stylesheet.removeImport or the\n<span class=\"caps\">DOM</span>-standard stylesheet.deleteRule(&#8217;@import [...]&#8217;)</p>","!type":"fn() -> bool"}},"Transport":{"!doc":"<p>Determines browser-dependent information about the transport layer.</p>\n\n<p>This class is used by {@link qx.core.Environment} and should not be used\ndirectly. Please check its class comment for details how to use it.</p>","getMaxConcurrentRequestCount":{"!doc":"<p>Returns the maximum number of parallel requests the current browser\nsupports per host addressed.</p>\n\n<p>Note that this assumes one connection can support one request at a time\nonly. Technically, this is not correct when pipelining is enabled (which\nit currently is only for IE 8 and Opera). In this case, the number\nreturned will be too low, as one connection supports multiple pipelined\nrequests. This is accepted for now because pipelining cannot be\ndetected from JavaScript and because modern browsers have enough\nparallel connections already &#8211; it&#8217;s unlikely an app will require more\nthan 4 parallel XMLHttpRequests to one server at a time.</p>","!type":"fn() -> +Integer"},"getSsl":{"!doc":"<p>Checks whether the app is loaded with <span class=\"caps\">SSL</span> enabled which means via https.</p>","!type":"fn() -> bool"},"getXmlHttpRequest":{"!doc":"<p>Checks what kind of XMLHttpRequest object the browser supports\nfor the current protocol, if any.</p>\n\n<p>The standard XMLHttpRequest is preferred over ActiveX <span class=\"caps\">XMLHTTP</span>.</p>","!type":"fn() -> string"}},"Xml":{"!doc":"<p>Internal class which contains the checks used by {@link qx.core.Environment}.\nAll checks in here are marked as internal which means you should never use\nthem directly.</p>\n\n<p>This class should contain all <span class=\"caps\">XML</span>-related checks</p>","getAttributeNS":{"!doc":"<p>Checks if the getAttributeNS and setAttributeNS methods are supported on\n<span class=\"caps\">XML</span> <span class=\"caps\">DOM</span> elements</p>","!type":"fn() -> bool"},"getCreateElementNS":{"!doc":"<p>Checks if the createElementNS method is supported on <span class=\"caps\">XML</span> <span class=\"caps\">DOM</span> documents</p>","!type":"fn() -> bool"},"getCreateNode":{"!doc":"<p>Checks if the proprietary createNode method is supported on <span class=\"caps\">XML</span> <span class=\"caps\">DOM</span>\ndocuments</p>","!type":"fn() -> bool"},"getDomParser":{"!doc":"<p>Checks if an <span class=\"caps\">XML</span> DOMParser is available</p>","!type":"fn() -> bool"},"getDomProperties":{"!doc":"<p>Checks if <span class=\"caps\">MSXML</span>-style <span class=\"caps\">DOM</span> Level 2 properties are supported.</p>","!type":"fn() -> bool"},"getElementsByTagNameNS":{"!doc":"<p>Checks availablity of the getElementsByTagNameNS <span class=\"caps\">XML</span> <span class=\"caps\">DOM</span> method.</p>","!type":"fn() -> bool"},"getImplementation":{"!doc":"<p>Checks if <span class=\"caps\">XML</span> is supported</p>","!type":"fn() -> bool"},"getQualifiedItem":{"!doc":"<p>Checks if the proprietary getQualifiedItem method is supported for <span class=\"caps\">XML</span>\nelement attributes</p>","!type":"fn() -> bool"},"getSelectNodes":{"!doc":"<p>Checks if the proprietary selectNodes method is available on <span class=\"caps\">XML</span> <span class=\"caps\">DOM</span>\nnodes.</p>","!type":"fn() -> bool"},"getSelectSingleNode":{"!doc":"<p>Checks if the proprietary selectSingleNode method is available on <span class=\"caps\">XML</span> <span class=\"caps\">DOM</span>\nnodes.</p>","!type":"fn() -> bool"}}},"Cookie":{"!doc":"<p>A wrapper for Cookie handling.</p>","del":{"!doc":"<p>Deletes the string value of a cookie.</p>","!type":"fn(key: string, path?: string, domain?: string)"},"get":{"!doc":"<p>Returns the string value of a cookie.</p>","!type":"fn(key: string) -> +null"},"set":{"!doc":"<p>Sets the string value of a cookie.</p>","!type":"fn(key: string, value: string, expires?: number, path?: string, domain?: string, secure?: bool)"}},"Document":{"!doc":"<p>Includes library functions to work with the current document.</p>","getHeight":{"!doc":"<p>Returns the height of the document.</p>\n\n<p>Internet Explorer in standard mode stores the proprietary <code>scrollHeight</code> property\non the <code>documentElement</code>, but in quirks mode on the body element. All\nother known browsers simply store the correct value on the <code>documentElement</code>.</p>\n\n<p>If the viewport is higher than the document the viewport height is returned.</p>\n\n<p>As the html element has no visual appearance it also can not scroll. This\nmeans that we must use the body <code>scrollHeight</code> in all non mshtml clients.</p>\n\n<p>Verified to correctly work with:</p>\n\n<ul>\n<li>Mozilla Firefox 2.0.0.4</li>\n<li>Opera 9.2.1</li>\n<li>Safari 3.0 beta (3.0.2)</li>\n<li>Internet Explorer 7.0</li>\n</ul>","!type":"fn(win?: +Window) -> +Integer"},"getWidth":{"!doc":"<p>Returns the width of the document.</p>\n\n<p>Internet Explorer in standard mode stores the proprietary <code>scrollWidth</code> property\non the <code>documentElement</code>, but in quirks mode on the body element. All\nother known browsers simply store the correct value on the <code>documentElement</code>.</p>\n\n<p>If the viewport is wider than the document the viewport width is returned.</p>\n\n<p>As the html element has no visual appearance it also can not scroll. This\nmeans that we must use the body <code>scrollWidth</code> in all non mshtml clients.</p>\n\n<p>Verified to correctly work with:</p>\n\n<ul>\n<li>Mozilla Firefox 2.0.0.4</li>\n<li>Opera 9.2.1</li>\n<li>Safari 3.0 beta (3.0.2)</li>\n<li>Internet Explorer 7.0</li>\n</ul>","!type":"fn(win?: +Window) -> +Integer"},"isQuirksMode":{"!doc":"<p>Whether the document is in quirks mode (e.g. non <span class=\"caps\">XHTML</span>, HTML4 Strict or missing doctype)</p>","!type":"fn(win?: +Window) -> bool"},"isStandardMode":{"!doc":"<p>Whether the document is in standard mode (e.g. <span class=\"caps\">XHTML</span>, HTML4 Strict or doctype defined)</p>","!type":"fn(win?: +Window) -> bool"}},"element":{"Animation":{"!doc":"<p>Wrapper for {@link qx.bom.element.AnimationCss} and\n{@link qx.bom.element.AnimationJs}. It offers the pubilc <span class=\"caps\">API</span> and decides using\nfeature checks either to use <span class=\"caps\">CSS</span> animations or JS animations.</p>\n\n<p>If you use this class, the restrictions of the JavaScript animations apply.\nThis means that you can not use transforms and custom bezier timing functions.</p>","__hasOnlyCssKeys":{"!doc":"<p>Detection helper which detects if only <span class=\"caps\">CSS</span> keys are in\nthe animations key frames.</p>","!type":"fn(el: +Element, keyFrames: +Map) -> bool"},"animate":{"!doc":"<p>This function takes care of the feature check and starts the animation.\nIt takes a <span class=\"caps\">DOM</span> element to apply the animation to, and a description.\nThe description should be a map, which could look like this:</p>\n\n<pre class=\"javascript\">\n{\n  \"duration\": 1000,\n  \"keep\": 100,\n  \"keyFrames\": {\n    0 : {\"opacity\": 1, \"scale\": 1},\n    100 : {\"opacity\": 0, \"scale\": 0}\n  },\n  \"origin\": \"50% 50%\",\n  \"repeat\": 1,\n  \"timing\": \"ease-out\",\n  \"alternate\": false,\n  \"delay\" : 2000\n}\n</pre>\n\n<p><strong>duration</strong> is the time in milliseconds one animation cycle should take.</p>\n\n<p><strong>keep</strong> is the key frame to apply at the end of the animation. (optional)\n  Keep in mind that the keep key is reversed in case you use an reverse\n  animation or set the alternate key and a even repeat count.</p>\n\n<p><strong>keyFrames</strong> is a map of separate frames. Each frame is defined by a\n  number which is the percentage value of time in the animation. The value\n  is a map itself which holds css properties or transforms\n  {@link qx.bom.element.Transform} (Transforms only for <span class=\"caps\">CSS</span> Animations).</p>\n\n<p><strong>origin</strong> maps to the transform origin {@link qx.bom.element.Transform#setOrigin}\n  (Only for <span class=\"caps\">CSS</span> animations).</p>\n\n<p><strong>repeat</strong> is the amount of time the animation should be run in\n  sequence. You can also use &#8220;infinite&#8221;.</p>\n\n<p><strong>timing</strong> takes one of the predefined value:\n  <code>ease</code> | <code>linear</code> | <code>ease-in</code>\n  | <code>ease-out</code> | <code>ease-in-out</code> |\n  <code>cubic-bezier(&lt;number&gt;, &lt;number&gt;, &lt;number&gt;, &lt;number&gt;)</code>\n  (cubic-bezier only available for <span class=\"caps\">CSS</span> animations)</p>\n\n<p><strong>alternate</strong> defines if every other animation should be run in reverse order.</p>\n\n<p><strong>delay</strong> is the time in milliseconds the animation should wait before start.</p>","!type":"fn(el: +Element, desc: +Map, duration?: +Integer) -> +qx.bom.element.AnimationHandle"},"animateReverse":{"!doc":"<p>Starts an animation in reversed order. For further details, take a look at\nthe {@link #animate} method.</p>","!type":"fn(el: +Element, desc: +Map, duration?: +Integer) -> +qx.bom.element.AnimationHandle"}},"AnimationCss":{"!doc":"<p>This class is responsible for applying CSS3 animations to plain <span class=\"caps\">DOM</span> elements.</p>\n\n<p>The implementation is mostly a cross-browser wrapper for applying the\nanimations, including transforms. If the browser does not support\n<span class=\"caps\">CSS</span> animations, but you have set a keep frame, the keep frame will be applied\nimmediately, thus making the animations optional.</p>\n\n<p>The <span class=\"caps\">API</span> aligns closely to the spec wherever possible.</p>\n\n<p><a href=\"http://www.w3.org/TR/css3-animations/\">http://www.w3.org/TR/css3-animations/</a></p>\n\n<p>{@link qx.bom.element.Animation} is the class, which takes care of the\nfeature detection for <span class=\"caps\">CSS</span> animations and decides which implementation\n(CSS or JavaScript) should be used. Most likely, this implementation should\nbe the one to use.</p>","__addKeyFrames":{"!doc":"<p>Helper to add the given frames to an internal <span class=\"caps\">CSS</span> stylesheet. It parses\nthe description and adds the key frames to the sheet.</p>","!type":"fn(frames: +Map, reverse: bool) -> string"},"__keepFrame":{"!doc":"<p>Helper method which takes an element and a key frame description and\napplies the properties defined in the given frame to the element. This\nmethod is used to keep the state of the animation.</p>","!type":"fn(el: +Element, endFrame: +Map)"},"__normalizeDesc":{"!doc":"<p>Preprocessing of the description to make sure every necessary key is\nset to its default.</p>","!type":"fn(desc: +Map)"},"__onAnimationEnd":{"!doc":"<p>Handler for the animation end.</p>","!type":"fn(e: +Event)"},"__onAnimationIteration":{"!doc":"<p>Handler for the animation iteration.</p>","!type":"fn(e: +Event)"},"__onAnimationStart":{"!doc":"<p>Handler for the animation start.</p>","!type":"fn(e: +Event)"},"__validateDesc":{"!doc":"<p>Debugging helper to validate the description.</p>","!type":"fn(desc: +Map)"},"_animate":{"!doc":"<p>Internal method to start an animation either reverse or not.\n{@link qx.bom.element.Animation}.</p>","!type":"fn(el: +Element, desc: +Map, duration?: +Integer, reverse: bool) -> +qx.bom.element.AnimationHandle"},"animate":{"!doc":"<p>This is the main function to start the animation. For further details,\ntake a look at the documentation of the wrapper\n{@link qx.bom.element.Animation}.</p>","!type":"fn(el: +Element, desc: +Map, duration?: +Integer) -> +qx.bom.element.AnimationHandle"},"animateReverse":{"!doc":"<p>This is the main function to start the animation in reverse mode.\nFor further details, take a look at the documentation of the wrapper\n{@link qx.bom.element.Animation}.</p>","!type":"fn(el: +Element, desc: +Map, duration?: +Integer) -> +qx.bom.element.AnimationHandle"}},"AnimationHandle":{"!proto":"qx.event.Emitter","!doc":"<p>This is a simple handle, which will be returned when an animation is\nstarted using the {@link qx.bom.element.Animation#animate} method. It\nbasically controls the animation.</p>","!type":"fn()","prototype":{"isEnded":{"!doc":"<p>Accessor of the ended state.</p>","!type":"fn() -> bool"},"isPaused":{"!doc":"<p>Accessor of the paused state.</p>","!type":"fn() -> bool"},"isPlaying":{"!doc":"<p>Accessor of the playing state.</p>","!type":"fn() -> bool"},"pause":{"!doc":"<p>Pauses the animation, if running. If not running, it will be ignored.</p>","!type":"fn()"},"play":{"!doc":"<p>Resumes an animation. This does not start the animation once it has ended.\nIn this case you need to start a new Animation.</p>","!type":"fn()"},"stop":{"!doc":"<p>Stops the animation if running.</p>","!type":"fn()"}}},"AnimationJs":{"!doc":"<p>This class offers the same <span class=\"caps\">API</span> as the CSS3 animation layer in\n{@link qx.bom.element.AnimationCss} but uses JavaScript to fake the behavior.</p>\n\n<p>{@link qx.bom.element.Animation} is the class, which takes care of the\nfeature detection for <span class=\"caps\">CSS</span> animations and decides which implementation\n(CSS or JavaScript) should be used. Most likely, this implementation should\nbe the one to use.</p>","__applyRepeat":{"!doc":"<p>Takes care of the repeat key of the description.</p>","!type":"fn(steps: +Integer, repeat: +Integer) -> +Integer"},"__applyStyles":{"!doc":"<p>Central method to apply css styles and element properties.</p>","!type":"fn(el: +Element, styles: +Map)"},"__calculateDelta":{"!doc":"<p>Precalculation of the delta which will be applied during the animation.\nThe whole deltas will be calculated prior to the animation and stored\nin a single array. This method takes care of that calculation.</p>","!type":"fn(steps: +Integer, stepTime: +Integer, keys: +Array, keyFrames: +Map, duration: +Integer, timing: string) -> +Array"},"__getNextValue":{"!doc":"<p>Returns the next value based on the given arguments.</p>","!type":"fn(nextItem: string, lastItem: string, timing: string, x: number) -> string"},"__getOrderedKeys":{"!doc":"<p>Helper which returns the orderd keys of the key frame map.</p>","!type":"fn(keyFrames: +Map) -> +Array"},"__getStepTime":{"!doc":"<p>Dynamic calculation of the steps time considering a max step time.</p>","!type":"fn(duration: number, keys: +Array) -> +Integer"},"__getUnit":{"!doc":"<p>Ties to parse out the unit of the given value.</p>","!type":"fn(item: string) -> string"},"__normalizeKeyFrames":{"!doc":"<p>Try to normalize the keyFrames by adding the default / set values of the\nelement.</p>","!type":"fn(keyFrames: +Map, el: +Element)"},"__normalizeKeyFrameTransforms":{"!doc":"<p>Checks for transform keys and returns a cloned frame\nwith the right transform style set.</p>","!type":"fn(frame: +Map) -> +Map"},"_animate":{"!doc":"<p>Helper to start the animation, either in reversed order or not.</p>","!type":"fn(el: +Element, desc: +Map, duration?: +Integer, reverse: bool) -> +qx.bom.element.AnimationHandle"},"animate":{"!doc":"<p>This is the main function to start the animation. For further details,\ntake a look at the documentation of the wrapper\n{@link qx.bom.element.Animation}.</p>","!type":"fn(el: +Element, desc: +Map, duration?: +Integer) -> +qx.bom.element.AnimationHandle"},"animateReverse":{"!doc":"<p>This is the main function to start the animation in reversed mode.\nFor further details, take a look at the documentation of the wrapper\n{@link qx.bom.element.Animation}.</p>","!type":"fn(el: +Element, desc: +Map, duration?: +Integer) -> +qx.bom.element.AnimationHandle"},"pause":{"!doc":"<p>Internal helper for the {@link qx.bom.element.AnimationHandle} to pause\nthe animation.</p>","!type":"fn(handle: +qx.bom.element.AnimationHandle) -> +qx.bom.element.AnimationHandle"},"play":{"!doc":"<p>Internal helper for the {@link qx.bom.element.AnimationHandle} to play\nthe animation.</p>","!type":"fn(handle: +qx.bom.element.AnimationHandle) -> +qx.bom.element.AnimationHandle"},"stop":{"!doc":"<p>Internal helper for the {@link qx.bom.element.AnimationHandle} to stop\nthe animation.</p>","!type":"fn(handle: +qx.bom.element.AnimationHandle) -> +qx.bom.element.AnimationHandle"}},"Attribute":{"!doc":"<p>Attribute/Property handling for <span class=\"caps\">DOM</span> <span class=\"caps\">HTML</span> elements.</p>\n\n<p>Also includes support for <span class=\"caps\">HTML</span> properties like <code>checked</code>\nor <code>value</code>. This feature set is supported cross-browser\nthrough one common interface and is independent of the differences between\nthe multiple implementations.</p>\n\n<p>Supports applying text and <span class=\"caps\">HTML</span> content using the attribute names\n<code>text</code> and <code>html</code>.</p>","compile":{"!doc":"<p>Compiles an incoming attribute map to a string which\ncould be used when building <span class=\"caps\">HTML</span> blocks using innerHTML.</p>\n\n<p>This method silently ignores runtime attributes like\n<code>html</code> or <code>text</code>.</p>","!type":"fn(map: +Map) -> string"},"get":{"!doc":"<p>Returns the value of the given <span class=\"caps\">HTML</span> attribute</p>","!type":"fn(element: +Element, name: string) -> Object"},"reset":{"!doc":"<p>Resets an <span class=\"caps\">HTML</span> attribute on the given <span class=\"caps\">DOM</span> element</p>","!type":"fn(element: +Element, name: string)"},"set":{"!doc":"<p>Sets an <span class=\"caps\">HTML</span> attribute on the given <span class=\"caps\">DOM</span> element</p>","!type":"fn(element: +Element, name: string, value: Object)"}},"Background":{"!doc":"<p>The background class contains methods to compute and set the background image\nof a <span class=\"caps\">DOM</span> element.</p>\n\n<p>It fixes a background position issue in Firefox 2.</p>","__computePosition":{"!doc":"<p>Computes the background position <span class=\"caps\">CSS</span> value</p>","!type":"fn(left: +Integer, top: +Integer) -> string"},"__isBase64EncodedImage":{"!doc":"<p>Checks if the given image <span class=\"caps\">URL</span> is a base64-encoded one.</p>","!type":"fn(url: string) -> bool"},"compile":{"!doc":"<p>Compiles the background into a <span class=\"caps\">CSS</span> compatible string.</p>","!type":"fn(source?: string, repeat?: string, left?: +Integer, top?: +Integer) -> string"},"getStyles":{"!doc":"<p>Get standard css background styles</p>","!type":"fn(source: string, repeat?: string, left?: +Integer, top?: +Integer) -> +Map"},"set":{"!doc":"<p>Set the background on the given <span class=\"caps\">DOM</span> element</p>","!type":"fn(element: +Element, source?: string, repeat?: string, left?: +Integer, top?: +Integer)"}},"BoxSizing":{"!doc":"<p>Contains methods to control and query the element&#8217;s box-sizing property.</p>\n\n<p>Supported values:</p>\n\n<ul>\n<li>&#8220;content-box&#8221; = W3C model (dimensions are content specific)</li>\n<li>&#8220;border-box&#8221; = Microsoft model (dimensions are box specific incl. border and padding)</li>\n</ul>","__usesNativeBorderBox":{"!doc":"<p>Whether the given elements defaults to the &#8220;border-box&#8221; Microsoft model in all cases.</p>","!type":"fn(element: +Element) -> bool"},"compile":{"!doc":"<p>Compiles the given box sizing into a <span class=\"caps\">CSS</span> compatible string.</p>","!type":"fn(value: string) -> string"},"get":{"!doc":"<p>Returns the box sizing for the given element.</p>","!type":"fn(element: +Element) -> string"},"reset":{"!doc":"<p>Removes the local box sizing applied to the element</p>","!type":"fn(element: +Element)"},"set":{"!doc":"<p>Applies a new box sizing to the given element</p>","!type":"fn(element: +Element, value: string)"}},"Class":{"!doc":"<p><span class=\"caps\">CSS</span> class name support for <span class=\"caps\">HTML</span> elements. Supports multiple class names\nfor each element. Can query and apply class names to <span class=\"caps\">HTML</span> elements.</p>","add":{"!doc":"<p>Adds a className to the given element\nIf successfully added the given className will be returned</p>","!type":"fn(element: +Element, name: string) -> string"},"addClasses":{"!doc":"<p>Adds multiple classes to the given element</p>","!type":"fn(element: +Element, classes: string) -> string"},"get":{"!doc":"<p>Gets the classname of the given element</p>","!type":"fn(element: +Element) -> string"},"has":{"!doc":"<p>Whether the given element has the given className.</p>","!type":"fn(element: +Element, name: string) -> bool"},"remove":{"!doc":"<p>Removes a className from the given element</p>","!type":"fn(element: +Element, name: string) -> string"},"removeClasses":{"!doc":"<p>Removes multiple classes from the given element</p>","!type":"fn(element: +Element, classes: string) -> string"},"replace":{"!doc":"<p>Replaces the first given class name with the second one</p>","!type":"fn(element: +Element, oldName: string, newName: string) -> string"},"toggle":{"!doc":"<p>Toggles a className of the given element</p>","!type":"fn(element: +Element, name: string, toggle?: bool) -> string"}},"Clip":{"!doc":"<p>Contains methods to control and query the element&#8217;s clip property</p>","compile":{"!doc":"<p>Compiles the given clipping into a <span class=\"caps\">CSS</span> compatible string. This\nis a simple square which describes the visible area of an <span class=\"caps\">DOM</span> element.\nChanging the clipping does not change the dimensions of\nan element.</p>","!type":"fn(map: +Map) -> string"},"get":{"!doc":"<p>Gets the clipping of the given element.</p>","!type":"fn(element: +Element, mode: number) -> +Map"},"reset":{"!doc":"<p>Resets the clipping of the given <span class=\"caps\">DOM</span> element.</p>","!type":"fn(element: +Element)"},"set":{"!doc":"<p>Sets the clipping of the given element. This is a simple\nsquare which describes the visible area of an <span class=\"caps\">DOM</span> element.\nChanging the clipping does not change the dimensions of\nan element.</p>","!type":"fn(element: +Element, map: +Map)"}},"Cursor":{"!doc":"<p>Contains methods to control and query the element&#8217;s cursor property</p>","compile":{"!doc":"<p>Compiles the given cursor into a <span class=\"caps\">CSS</span> compatible string.</p>","!type":"fn(cursor: string) -> string"},"get":{"!doc":"<p>Returns the computed cursor style for the given element.</p>","!type":"fn(element: +Element, mode: number) -> string"},"reset":{"!doc":"<p>Removes the local cursor style applied to the element</p>","!type":"fn(element: +Element)"},"set":{"!doc":"<p>Applies a new cursor style to the given element</p>","!type":"fn(element: +Element, value: string)"}},"Dataset":{"!doc":"<p>Data-* attribute handling for <span class=\"caps\">DOM</span> <span class=\"caps\">HTML</span> elements.</p>\n\n<p>This feature set is supported cross-browser\nthrough one common interface and is independent of the differences between\nthe multiple implementations.</p>","get":{"!doc":"<p>Returns the value of the given <span class=\"caps\">HTML</span> &#8220;data-*&#8221; attribute</p>","!type":"fn(element: +Element, name: string) -> Object"},"getAll":{"!doc":"<p>Returns a map containing all the <span class=\"caps\">HTML</span> &#8220;data-*&#8221; attributes of the specified element</p>","!type":"fn(element: +Element) -> +Map"},"remove":{"!doc":"<p>Remove an <span class=\"caps\">HTML</span> &#8220;data-*&#8221; attribute from the given <span class=\"caps\">DOM</span> element</p>","!type":"fn(element: +Element, name: string)"},"set":{"!doc":"<p>Sets a data attribute on the given <span class=\"caps\">DOM</span> element.</p>","!type":"fn(element: +Element, name: string, value: Object)"}},"Decoration":{"!doc":"<p>Powerful creation and update features for images used for decoration\npurposes like for rounded borders, icons, etc.</p>\n\n<p>Includes support for image clipping, <span class=\"caps\">PNG</span> alpha channel support, additional\nrepeat options like <code>scale-x</code> or <code>scale-y</code>.</p>","__checkForPotentialClippedImage":{"!doc":"<p>Output a warning if the image can be clipped.</p>","!type":"fn(source: string)"},"__getDimension":{"!doc":"<p>Returns the dimension of the image by calling\n{@link qx.util.ResourceManager} or {@link qx.io.ImageLoader}\ndepending on if the image is a managed one.</p>","!type":"fn(source: string) -> +Map"},"__getStylesForClippedScaleX":{"!doc":"<p>Generates the style infos for horizontally scaled clipped images.</p>","!type":"fn(style: +Map, data: +Array, height: +Integer) -> +Map"},"__getStylesForClippedScaleY":{"!doc":"<p>Generates the style infos for vertically scaled clipped images.</p>","!type":"fn(style: +Map, data: +Array, width: +Integer) -> +Map"},"__getStylesForSingleRepeat":{"!doc":"<p>Generate all style infos for single repeated images</p>","!type":"fn(style: +Map, source: string, repeat: string)"},"__normalizeWidthHeight":{"!doc":"<p>Normalize the given width and height values</p>","!type":"fn(style: +Map, width?: +Integer, height?: +Integer)"},"__processRepeats":{"!doc":"<p>Process repeated images.</p>","!type":"fn(style: +Map, repeat: string, sourceid: string) -> +Map"},"__processScale":{"!doc":"<p>Process scaled images.</p>","!type":"fn(style: +Map, repeat: string, source: string) -> +Map"},"__processScaleXScaleY":{"!doc":"<p>Process images which are either scaled horizontally or\nvertically.</p>","!type":"fn(style: +Map, repeat: string, sourceid: string) -> +Map"},"create":{"!doc":"<p>Creates the <span class=\"caps\">HTML</span> for a decorator image element with the given options.</p>","!type":"fn(source: string, repeat: string, style: +Map) -> string"},"getAttributes":{"!doc":"<p>This method is used to collect all needed attributes for\nthe tag name detected by {@link #getTagName}.</p>","!type":"fn(source: string, repeat: string, style: +Map) -> string"},"getTagName":{"!doc":"<p>Translates the given repeat option to a tag name. Useful\nfor systems which depends on early information of the tag\nname to prepare element like {@link qx.html.Image}.</p>","!type":"fn(repeat: string, source?: string) -> string"},"processAlphaFix":{"!doc":"<p>Get all styles for IE browser which need to load the image\nwith the help of the AlphaImageLoader</p>","!type":"fn(style: +Map, repeat: string, source: string) -> +Map"},"update":{"!doc":"<p>Updates the element to display the given source\nwith the repeat option.</p>","!type":"fn(element: +Element, source: string, repeat: string, style: +Map)"}},"Dimension":{"!doc":"<p>Contains support for calculating dimensions of <span class=\"caps\">HTML</span> elements.</p>\n\n<p>We differ between the box (or border) size which is available via\n{@link #getWidth} and {@link #getHeight} and the content or scroll\nsizes which are available via {@link #getContentWidth} and\n{@link #getContentHeight}.</p>","getContentHeight":{"!doc":"<p>Returns the content height.</p>\n\n<p>The content height is basically the maximum\nheight used or the maximum height which can be used by the content. This\nexcludes all kind of styles of the element like borders, paddings, margins,\nand even scrollbars.</p>\n\n<p>Please note that with visible scrollbars the content height returned\nmay be larger than the box height returned via {@link #getHeight}.</p>","!type":"fn(element: +Element) -> +Integer"},"getContentSize":{"!doc":"<p>Returns the rendered content size of the given element.</p>","!type":"fn(element: +Element) -> +Map"},"getContentWidth":{"!doc":"<p>Returns the content width.</p>\n\n<p>The content width is basically the maximum\nwidth used or the maximum width which can be used by the content. This\nexcludes all kind of styles of the element like borders, paddings, margins,\nand even scrollbars.</p>\n\n<p>Please note that with visible scrollbars the content width returned\nmay be larger than the box width returned via {@link #getWidth}.</p>","!type":"fn(element: +Element) -> +Integer"},"getHeight":{"!doc":"<p>Returns the rendered height of the given element.</p>\n\n<p>This is the visible height of the object, which need not to be identical\nto the height configured via <span class=\"caps\">CSS</span>. This highly depends on the current\nbox-sizing for the document and maybe even for the element.</p>","!type":"fn(element: +Element) -> +Integer"},"getSize":{"!doc":"<p>Returns the rendered size of the given element.</p>","!type":"fn(element: +Element) -> +Map"},"getWidth":{"!doc":"<p>Returns the rendered width of the given element.</p>\n\n<p>This is the visible width of the object, which need not to be identical\nto the width configured via <span class=\"caps\">CSS</span>. This highly depends on the current\nbox-sizing for the document and maybe even for the element.</p>","!type":"fn(element: +Element) -> +Integer"}},"Location":{"!doc":"<p>Query the location of an arbitrary <span class=\"caps\">DOM</span> element in relation to its top\nlevel body element. Works in all major browsers:</p>\n\n<ul>\n<li>Mozilla 1.5 + 2.0</li>\n<li>Internet Explorer 6.0 + 7.0 (both standard &amp; quirks mode)</li>\n<li>Opera 9.2</li>\n<li>Safari 3.0 beta</li>\n</ul>","__computeOffset":{"!doc":"<p>Computes the sum of all offsets of the given element node.</p>","!type":"fn(elem: +Element) -> +Map"},"__computeScroll":{"!doc":"<p>Computes the scroll offset of the given element relative to the document\n<code>body</code>.</p>","!type":"fn(elem: +Element) -> +Map"},"__getBodyLocation":{"!doc":"<p>Get the location of the body element relative to the document.</p>","!type":"fn(body: +Element) -> +Map"},"__num":{"!doc":"<p>Queries a style property for the given element and parses it to an integer value</p>","!type":"fn(elem: +Element, style: string) -> +Integer"},"__style":{"!doc":"<p>Queries a style property for the given element</p>","!type":"fn(elem: +Element, style: string) -> string"},"get":{"!doc":"<p>Computes the location of the given element in context of\nthe document dimensions.</p>\n\n<p>Supported modes:</p>\n\n<ul>\n<li><code>margin</code>: Calculate from the margin box of the element (bigger than the visual appearance: including margins of given element)</li>\n<li><code>box</code>: Calculates the offset box of the element (default, uses the same size as visible)</li>\n<li><code>border</code>: Calculate the border box (useful to align to border edges of two elements).</li>\n<li><code>scroll</code>: Calculate the scroll box (relevant for absolute positioned content).</li>\n<li><code>padding</code>: Calculate the padding box (relevant for static/relative positioned content).</li>\n</ul>","!type":"fn(elem: +Element, mode?: string) -> +Map"},"getBottom":{"!doc":"<p>Computes the location of the given element in context of\nthe document dimensions. For supported modes please\nhave a look at the {@link qx.bom.element.Location#get} method.</p>","!type":"fn(elem: +Element, mode: string) -> +Integer"},"getLeft":{"!doc":"<p>Computes the location of the given element in context of\nthe document dimensions. For supported modes please\nhave a look at the {@link qx.bom.element.Location#get} method.</p>","!type":"fn(elem: +Element, mode: string) -> +Integer"},"getOffsetParent":{"!doc":"<p>Detects the offset parent of the given element</p>","!type":"fn(element: +Element) -> +Element"},"getPosition":{"!doc":"<p>Returns the distance between the given element to its offset parent.</p>","!type":"fn(elem: +Element) -> +Map"},"getRelative":{"!doc":"<p>Returns the distance between two <span class=\"caps\">DOM</span> elements. For supported modes please\nhave a look at the {@link qx.bom.element.Location#get} method.</p>","!type":"fn(elem1: +Element, elem2: +Element, mode1?: string, mode2?: string) -> +Map"},"getRight":{"!doc":"<p>Computes the location of the given element in context of\nthe document dimensions. For supported modes please\nhave a look at the {@link qx.bom.element.Location#get} method.</p>","!type":"fn(elem: +Element, mode: string) -> +Integer"},"getTop":{"!doc":"<p>Computes the location of the given element in context of\nthe document dimensions. For supported modes please\nhave a look at the {@link qx.bom.element.Location#get} method.</p>","!type":"fn(elem: +Element, mode: string) -> +Integer"}},"Opacity":{"!doc":"<p>Cross-browser opacity support.</p>\n\n<p>Optimized for animations (contains workarounds for typical flickering\nin some browsers). Reduced class dependencies for optimal size and\nperformance.</p>","compile":{"!doc":"<p>Compiles the given opacity value into a cross-browser <span class=\"caps\">CSS</span> string.\nAccepts numbers between zero and one\nwhere &#8220;0&#8221; means transparent, &#8220;1&#8221; means opaque.</p>","!type":"fn(opacity: +Float) -> string"},"get":{"!doc":"<p>Gets computed opacity of given element. Accepts numbers between zero and one\nwhere &#8220;0&#8221; means transparent, &#8220;1&#8221; means opaque.</p>","!type":"fn(element: +Element, mode: number) -> +Float"},"reset":{"!doc":"<p>Resets opacity of given element.</p>","!type":"fn(element: +Element)"},"set":{"!doc":"<p>Sets opacity of given element. Accepts numbers between zero and one\nwhere &#8220;0&#8221; means transparent, &#8220;1&#8221; means opaque.</p>","!type":"fn(element: +Element, opacity: +Float)"}},"Scroll":{"!doc":"<p>Contains methods to control and query the element&#8217;s scroll properties</p>","getScrollbarWidth":{"!doc":"<p>Get the typical native scrollbar size in the environment</p>","!type":"fn() -> number"},"intoView":{"!doc":"<p>The method scrolls the element into view.</p>","!type":"fn(element: +Element, stop?: +Element, alignX: string, alignY: string)"},"intoViewX":{"!doc":"<p>The method scrolls the element into view (x-axis only).</p>","!type":"fn(element: +Element, stop?: +Element, align?: string)"},"intoViewY":{"!doc":"<p>The method scrolls the element into view (y-axis only).</p>","!type":"fn(element: +Element, stop?: +Element, align?: string)"}},"Style":{"!doc":"<p>Style querying and modification of <span class=\"caps\">HTML</span> elements.</p>\n\n<p>Automatically normalizes cross-browser differences for setting and reading\n<span class=\"caps\">CSS</span> attributes. Optimized for performance.</p>","__detectVendorProperties":{"!doc":"<p>Detect vendor specific properties.</p>","!type":"fn()"},"__getStyleName":{"!doc":"<p>Gets the (possibly vendor-prefixed) name of a style property and stores\nit to avoid multiple checks.</p>","!type":"fn(name: string) -> string"},"compile":{"!doc":"<p>Compiles the given styles into a string which can be used to\nconcat a <span class=\"caps\">HTML</span> string for innerHTML usage.</p>","!type":"fn(map: +Map) -> string"},"get":{"!doc":"<p>Gets the value of a style property.</p>\n\n<p><strong>Computed</strong></p>\n\n<p>Returns the computed value of a style property. Compared to the cascaded style,\nthis one also interprets the values e.g. translates <code>em</code> units to\n<code>px</code>.</p>\n\n<p><strong>Cascaded</strong></p>\n\n<p>Returns the cascaded value of a style property.</p>\n\n<p><strong>Local</strong></p>\n\n<p>Ignores inheritance cascade. Does not interpret values.</p>","!type":"fn(element: +Element, name: string, mode: number, smart?: bool) -> Object"},"getCss":{"!doc":"<p>Returns the full content of the style attribute.</p>","!type":"fn(element: +Element) -> string"},"isPropertySupported":{"!doc":"<p>Checks whether the browser supports the given <span class=\"caps\">CSS</span> property.</p>","!type":"fn(propertyName: string) -> bool"},"reset":{"!doc":"<p>Resets the value of a style property</p>","!type":"fn(element: +Element, name: string, smart?: bool)"},"set":{"!doc":"<p>Sets the value of a style property</p>","!type":"fn(element: +Element, name: string, value: Object, smart?: bool)"},"setCss":{"!doc":"<p>Set the full <span class=\"caps\">CSS</span> content of the style attribute</p>","!type":"fn(element: +Element, value: string)"},"setStyles":{"!doc":"<p>Convenience method to modify a set of styles at once.</p>","!type":"fn(element: +Element, styles: +Map, smart?: bool)"}},"Transform":{"!doc":"<p>This class is responsible for applying CSS3 transforms to plain <span class=\"caps\">DOM</span> elements.\nThe implementation is mostly a cross browser wrapper for applying the\ntransforms.\nThe <span class=\"caps\">API</span> is keep to the spec as close as possible.</p>\n\n<p><a href=\"http://www.w3.org/TR/css3-3d-transforms/\">http://www.w3.org/TR/css3-3d-transforms/</a></p>","__mapToCss":{"!doc":"<p>Internal helper which converts the given transforms map to a valid <span class=\"caps\">CSS</span>\nstring.</p>","!type":"fn(transforms: +Map) -> string"},"getBackfaceVisibility":{"!doc":"<p>Returns the backface-visibility property of the given element.</p>\n\n<p>Spec: <a href=\"http://www.w3.org/TR/css3-3d-transforms/#backface-visibility-property\">http://www.w3.org/TR/css3-3d-transforms/#backface-visibility-property</a></p>","!type":"fn(el: +Element) -> bool"},"getCss":{"!doc":"<p>Converts the given map to a string which could be added to a css\nstylesheet.</p>","!type":"fn(transforms: +Map) -> string"},"getOrigin":{"!doc":"<p>Returns the transform-origin property of the given element.</p>\n\n<p>Spec: <a href=\"http://www.w3.org/TR/css3-3d-transforms/#transform-origin-property\">http://www.w3.org/TR/css3-3d-transforms/#transform-origin-property</a></p>","!type":"fn(el: +Element) -> string"},"getPerspective":{"!doc":"<p>Returns the perspective property of the given element.</p>\n\n<p>Spec: <a href=\"http://www.w3.org/TR/css3-3d-transforms/#perspective-property\">http://www.w3.org/TR/css3-3d-transforms/#perspective-property</a></p>","!type":"fn(el: +Element) -> string"},"getPerspectiveOrigin":{"!doc":"<p>Returns the perspective-origin property of the given element.</p>\n\n<p>Spec: <a href=\"http://www.w3.org/TR/css3-3d-transforms/#perspective-origin-property\">http://www.w3.org/TR/css3-3d-transforms/#perspective-origin-property</a></p>","!type":"fn(el: +Element) -> string"},"getStyle":{"!doc":"<p>Returns the transform-style property of the given element.</p>\n\n<p>Spec: <a href=\"http://www.w3.org/TR/css3-3d-transforms/#transform-style-property\">http://www.w3.org/TR/css3-3d-transforms/#transform-style-property</a></p>","!type":"fn(el: +Element) -> string"},"rotate":{"!doc":"<p>Rotates the given element by the given value. For further details, take\na look at the {@link #transform} method.</p>","!type":"fn(el: +Element, value: string)"},"scale":{"!doc":"<p>Scales the given element by the given value. For further details, take\na look at the {@link #transform} method.</p>","!type":"fn(el: +Element, value: number)"},"setBackfaceVisibility":{"!doc":"<p>Sets the backface-visibility property of the given element.</p>\n\n<p>Spec: <a href=\"http://www.w3.org/TR/css3-3d-transforms/#backface-visibility-property\">http://www.w3.org/TR/css3-3d-transforms/#backface-visibility-property</a></p>","!type":"fn(el: +Element, value: bool)"},"setOrigin":{"!doc":"<p>Sets the transform-origin property of the given element.</p>\n\n<p>Spec: <a href=\"http://www.w3.org/TR/css3-3d-transforms/#transform-origin-property\">http://www.w3.org/TR/css3-3d-transforms/#transform-origin-property</a></p>","!type":"fn(el: +Element, value: string)"},"setPerspective":{"!doc":"<p>Sets the perspective property of the given element.</p>\n\n<p>Spec: <a href=\"http://www.w3.org/TR/css3-3d-transforms/#perspective-property\">http://www.w3.org/TR/css3-3d-transforms/#perspective-property</a></p>","!type":"fn(el: +Element, value: number)"},"setPerspectiveOrigin":{"!doc":"<p>Sets the perspective-origin property of the given element.</p>\n\n<p>Spec: <a href=\"http://www.w3.org/TR/css3-3d-transforms/#perspective-origin-property\">http://www.w3.org/TR/css3-3d-transforms/#perspective-origin-property</a></p>","!type":"fn(el: +Element, value: string)"},"setStyle":{"!doc":"<p>Sets the transform-style property of the given element.</p>\n\n<p>Spec: <a href=\"http://www.w3.org/TR/css3-3d-transforms/#transform-style-property\">http://www.w3.org/TR/css3-3d-transforms/#transform-style-property</a></p>","!type":"fn(el: +Element, value: string)"},"skew":{"!doc":"<p>Skews the given element by the given value. For further details, take\na look at the {@link #transform} method.</p>","!type":"fn(el: +Element, value: string)"},"transform":{"!doc":"<p>Method to apply multiple transforms at once to the given element. It\ntakes a map containing the transforms you want to apply plus the values\ne.g.<code>{scale: 2, rotate: &#8220;5deg&#8221;}</code>.\nThe values can be either singular, which means a single value will\nbe added to the <span class=\"caps\">CSS</span>. If you give an array, the values will be split up\nand each array entry will be used for the X, Y or Z dimension in that\norder e.g. <code>{scale: [2, 0.5]}</code> will result in a element\ndouble the size in X direction and half the size in Y direction.\nMake sure your browser supports all transformations you apply.</p>","!type":"fn(el: +Element, transforms: +Map)"},"translate":{"!doc":"<p>Translates the given element by the given value. For further details, take\na look at the {@link #transform} method.</p>","!type":"fn(el: +Element, value: string)"}}},"Element":{"!doc":"<p>This class is mainly a convenience wrapper for <span class=\"caps\">DOM</span> elements to\nqooxdoo&#8217;s event system.</p>","activate":{"!doc":"<p>Activates the given element. The active element receives all key board events.</p>","!type":"fn(element: +Element)"},"addListener":{"!doc":"<p>Add an event listener to a <span class=\"caps\">DOM</span> element. The event listener is passed an\ninstance of {@link Event} containing all relevant information\nabout the event as parameter.</p>","!type":"fn(element: +Element, type: string, listener: fn(), self?: Object, capture: bool) -> string"},"blur":{"!doc":"<p>Blurs the given element</p>","!type":"fn(element: +Element)"},"capture":{"!doc":"<p>Captures the given element</p>","!type":"fn(element: +Element, containerCapture?: bool)"},"clone":{"!doc":"<p>Clone given <span class=\"caps\">DOM</span> element. May optionally clone all attached\nevents (recursively) as well.</p>","!type":"fn(element: +Element, events?: bool) -> +Element"},"deactivate":{"!doc":"<p>Deactivates the given element. The active element receives all key board events.</p>","!type":"fn(element: +Element)"},"focus":{"!doc":"<p>Focuses the given element. The element needs to have a positive <code>tabIndex</code> value.</p>","!type":"fn(element: +Element)"},"hasListener":{"!doc":"<p>Check whether there are one or more listeners for an event type\nregistered at the element.</p>","!type":"fn(element: +Element, type: string, capture?: bool) -> bool"},"releaseCapture":{"!doc":"<p>Releases the given element (from a previous {@link #capture} call)</p>","!type":"fn(element: +Element)"},"removeListener":{"!doc":"<p>Remove an event listener from a from <span class=\"caps\">DOM</span> node.</p>\n\n<p>Note: All registered event listeners will automatically be removed from\n  the <span class=\"caps\">DOM</span> at page unload so it is not necessary to detach events yourself.</p>","!type":"fn(element: +Element, type: string, listener: fn(), self?: Object, capture: bool) -> bool"},"removeListenerById":{"!doc":"<p>Removes an event listener from an event target by an id returned by\n{@link #addListener}</p>","!type":"fn(target: Object, id: string) -> bool"}},"Event":{"!doc":"<p>Wrapper around native event management capabilities of the browser.\nThis class should not be used directly normally. It&#8217;s better\nto use {@link qx.event.Registration} instead.</p>","addNativeListener":{"!doc":"<p>Use the low level browser functionality to attach event listeners\nto <span class=\"caps\">DOM</span> nodes.</p>\n\n<p>Use this with caution. This is only thought for event handlers and\nqualified developers. These are not mem-leak protected!</p>","!type":"fn(target: Object, type: string, listener: fn(), useCapture?: bool)"},"fire":{"!doc":"<p>Fires a synthetic native event on the given element.</p>","!type":"fn(target: +Element, type: string) -> bool"},"getEventName":{"!doc":"<p>Returns the (possibly vendor-prefixed) name of the given event type.\n<strong><span class=\"caps\">NOTE</span>:</strong> Incorrect capitalization of type names will <strong>not</strong> be corrected. See\n{@link #supportsEvent} for details.</p>","!type":"fn(target: Object, type: string) -> string"},"getRelatedTarget":{"!doc":"<p>Computes the related target from the native <span class=\"caps\">DOM</span> event</p>","!type":"fn(e: +Event) -> +Element"},"getTarget":{"!doc":"<p>Returns the target of the event.</p>","!type":"fn(e: +Event) -> Object"},"preventDefault":{"!doc":"<p>Prevent the native default of the event to be processed.</p>\n\n<p>This is useful to stop native keybindings, native selection\nand other native functionality behind events.</p>","!type":"fn(e: +Event)"},"removeNativeListener":{"!doc":"<p>Use the low level browser functionality to remove event listeners\nfrom <span class=\"caps\">DOM</span> nodes.</p>","!type":"fn(target: Object, type: string, listener: fn(), useCapture?: bool)"},"stopPropagation":{"!doc":"<p>Stops the propagation of the given event to the parent element.</p>\n\n<p>Only useful for events which bubble e.g. mousedown.</p>","!type":"fn(e: +Event)"},"supportsEvent":{"!doc":"<p>Whether the given target supports the given event type.</p>\n\n<p>Useful for testing for support of new features like\ntouch events, gesture events, orientation change, on/offline, etc.</p>\n\n<p><strong><span class=\"caps\">NOTE</span>:</strong> This check is <strong>case-insensitive</strong>.\n<code>supportsEvent(window, &#8220;cLicK&#8221;)</code> will return <code>true</code>\nbut <code>window.addEventListener(&#8220;cLicK&#8221;, callback)</code> will fail\nsilently!</p>","!type":"fn(target: Object, type: string) -> bool"}},"FileReader":{"!proto":"qx.core.Object","!doc":"<p><span class=\"caps\">EXPERIMENTAL</span> &#8211; <span class=\"caps\">NOT</span> <span class=\"caps\">READY</span> <span class=\"caps\">FOR</span> <span class=\"caps\">PRODUCTION</span></p>\n\n<p>FileReaders allow retrieving the data from a local file, after the file\nname was selected by an &lt;input type=&#8220;file&#8221;&gt; element.</p>\n\n<p>For more information see:\n<a href=\"http://www.w3.org/TR/FileAPI/\">http://www.w3.org/TR/FileAPI/</a></p>","!type":"fn()","getFile":{"!doc":"<p>Return the native File object selected from an &lt;input type=&#8220;file&#8221;&gt;\nelement.</p>","!type":"fn(inputElement: +Element, index: +Integer) -> +File"},"getNumFiles":{"!doc":"<p>Return the number of files selected by the user, from an &lt;input\ntype=&#8220;file&#8221;&gt; element.</p>","!type":"fn(inputElement: +Element) -> +Integer"},"prototype":{"_handleAbort":{"!doc":"<p>&#8220;abort&#8221; handler</p>","!type":"fn(e: Object)"},"_handleError":{"!doc":"<p>&#8220;error&#8221; handler</p>","!type":"fn(e: Object)"},"_handleLoad":{"!doc":"<p>&#8220;load&#8221; handler</p>","!type":"fn(e: Object)"},"_handleLoadEnd":{"!doc":"<p>&#8220;loadend&#8221; handler</p>","!type":"fn(e: Object)"},"_handleLoadStart":{"!doc":"<p>&#8220;loadstart&#8221; handler</p>","!type":"fn(e: Object)"},"_handleProgress":{"!doc":"<p>&#8220;progress&#8221; handler</p>","!type":"fn(e: Object)"},"readAsBinaryString":{"!doc":"<p>Begin reading from the file referenced by the specified file\nobject. This is an asynchronous request. When the file is fully loaded,\nthe &#8220;load&#8221; event will be fired.</p>\n\n<p>The data will be provided in a binary format where each byte is in the\nrange [0,255].</p>\n\n<p><span class=\"caps\">NOTE</span>: On FireFox, this method works if the page was loaded via the\nfile:// protocol. In Chrome, it does not.</p>","!type":"fn(fileObj: +File)"},"readAsDataURL":{"!doc":"<p>Begin reading from the file referenced by the specified file\nobject. This is an asynchronous request. When the file is fully loaded,\nthe &#8220;load&#8221; event will be fired.</p>\n\n<p>The data is returned in DataURL format.</p>\n\n<p><span class=\"caps\">NOTE</span>: On FireFox, this method works if the page was loaded via the\nfile:// protocol. In Chrome, it does not.</p>","!type":"fn(fileObj: +File)"},"readAsText":{"!doc":"<p>Begin reading from the file referenced by the specified file\nobject. This is an asynchronous request. When the file is fully loaded,\nthe &#8220;load&#8221; event will be fired.</p>\n\n<p>The data will be provided as text, in the specified encoding.</p>\n\n<p><span class=\"caps\">NOTE</span>: On FireFox, this method works if the page was loaded via the\nfile:// protocol. In Chrome, it does not.</p>","!type":"fn(fileObj: +File, encoding?: string)"}}},"Flash":{"!doc":"<p>Flash&#8482; embed via script</p>\n\n<p>Include:</p>\n\n<ul>\n<li>Simple movie embedding (returning a cross-browser working <span class=\"caps\">DOM</span> node)</li>\n<li>Support for custom parameters and attributes</li>\n<li>Support for Flash&#8482; variables</li>\n</ul>\n\n<p>Does not include the following features from SWFFix:</p>\n\n<ul>\n<li>Active content workarounds for already inserted movies (via markup)</li>\n<li>Express install support</li>\n<li>Transformation of standard conformance markup to cross browser support</li>\n<li>Support for alternative content (alt text)</li>\n</ul>","__createSwf":{"!doc":"<p>Creates a <span class=\"caps\">DOM</span> element with a flash movie.</p>","!type":"fn(element: +Element, attributes: +Map, params: +Map, win: +Window)"},"__destroyObjectInIE":{"!doc":"<p>Destroy the flash object and remove from <span class=\"caps\">DOM</span>, to fix memory leaks.</p>","!type":"fn(element: +Element)"},"__fixOutOfMemoryError":{"!doc":"<p>Internal helper to prevent leaks in IE</p>","!type":"fn()"},"__getFlashObject":{"!doc":"<p>Return the flash object element from <span class=\"caps\">DOM</span> node.</p>","!type":"fn(element: +Element) -> +Element"},"create":{"!doc":"<p>Creates an <span class=\"caps\">DOM</span> element</p>\n\n<p>The dimension of the movie should define through <span class=\"caps\">CSS</span> styles {@link qx.bom.element.Style}</p>\n\n<p>It is possible to add these parameters as supported by Flash movies:\n<a href=\"http://helpx.adobe.com/flash/kb/flash-object-embed-tag-attributes.html\">http://helpx.adobe.com/flash/kb/flash-object-embed-tag-attributes.html</a></p>","!type":"fn(element: +Element, attributes: +Map, variables?: +Map, params?: +Map, win?: +Window) -> +Element"},"destroy":{"!doc":"<p>Destroys the flash object from <span class=\"caps\">DOM</span>, but not the parent <span class=\"caps\">DOM</span> element.</p>\n\n<p>Note: Removing the flash object like this:</p>\n\n<pre>\n var div = qx.dom.Element.create(\"div\");\n document.body.appendChild(div);\n\n var flashObject = qx.bom.Flash.create(div, { movie : \"Flash.swf\", id : \"id\" });\n div.removeChild(div.firstChild);\n</pre>\n\n<p>involve memory leaks in Internet Explorer.</p>","!type":"fn(element: +Element, win?: +Window)"}},"Font":{"!proto":"qx.core.Object","!doc":"<p>A wrapper for <span class=\"caps\">CSS</span> font styles. Fond objects can be applied to instances\nof {@link qx.html.Element}.</p>","!type":"fn()","fromConfig":{"!doc":"<p>Converts a map property definition into a font object.</p>","!type":"fn(config: +Map) -> +qx.bom.Font"},"fromString":{"!doc":"<p>Converts a typical <span class=\"caps\">CSS</span> font definition string to an font object</p>\n\n<p>Example string: <code>bold italic 20px Arial</code></p>","!type":"fn(str: string) -> +qx.bom.Font"},"getDefaultStyles":{"!doc":"<p>Returns a map of all properties in empty state.</p>\n\n<p>This is useful for resetting previously configured\nfont styles.</p>","!type":"fn() -> +Map"},"prototype":{"_applyBold":{"!doc":"<p>Applies changes of the property value of the property <code>bold</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #bold}.</p>","!type":"fn(value: bool, old: bool)"},"_applyColor":{"!doc":"<p>Applies changes of the property value of the property <code>color</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #color}.</p>","!type":"fn(value: +Color, old: +Color)"},"_applyDecoration":{"!doc":"<p>Applies changes of the property value of the property <code>decoration</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #decoration}.</p>","!type":"fn(value: Object, old: Object)"},"_applyFamily":{"!doc":"<p>Applies changes of the property value of the property <code>family</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #family}.</p>","!type":"fn(value: +Array, old: +Array)"},"_applyItalic":{"!doc":"<p>Applies changes of the property value of the property <code>italic</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #italic}.</p>","!type":"fn(value: bool, old: bool)"},"_applyLineHeight":{"!doc":"<p>Applies changes of the property value of the property <code>lineHeight</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #lineHeight}.</p>","!type":"fn(value: number, old: number)"},"_applySize":{"!doc":"<p>Applies changes of the property value of the property <code>size</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #size}.</p>","!type":"fn(value: +Integer, old: +Integer)"},"_applyTextShadow":{"!doc":"<p>Applies changes of the property value of the property <code>textShadow</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #textShadow}.</p>","!type":"fn(value: string, old: string)"},"getBold":{"!doc":"<p>Returns the (computed) value of the property <code>bold</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #bold}.</p>","!type":"fn() -> Object"},"getColor":{"!doc":"<p>Returns the (computed) value of the property <code>color</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #color}.</p>","!type":"fn() -> Object"},"getDecoration":{"!doc":"<p>Returns the (computed) value of the property <code>decoration</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #decoration}.</p>","!type":"fn() -> Object"},"getFamily":{"!doc":"<p>Returns the (computed) value of the property <code>family</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #family}.</p>","!type":"fn() -> Object"},"getItalic":{"!doc":"<p>Returns the (computed) value of the property <code>italic</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #italic}.</p>","!type":"fn() -> Object"},"getLineHeight":{"!doc":"<p>Returns the (computed) value of the property <code>lineHeight</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #lineHeight}.</p>","!type":"fn() -> Object"},"getSize":{"!doc":"<p>Returns the (computed) value of the property <code>size</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #size}.</p>","!type":"fn() -> Object"},"getStyles":{"!doc":"<p>Get a map of all <span class=\"caps\">CSS</span> styles, which will be applied to the widget. Only\nthe styles which are set are returned.</p>","!type":"fn() -> +Map"},"getTextShadow":{"!doc":"<p>Returns the (computed) value of the property <code>textShadow</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #textShadow}.</p>","!type":"fn() -> Object"},"initBold":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>bold</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #bold}.</p>","!type":"fn(value: Object) -> Object"},"initColor":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>color</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #color}.</p>","!type":"fn(value: Object) -> Object"},"initDecoration":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>decoration</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #decoration}.</p>","!type":"fn(value: Object) -> Object"},"initFamily":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>family</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #family}.</p>","!type":"fn(value: Object) -> Object"},"initItalic":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>italic</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #italic}.</p>","!type":"fn(value: Object) -> Object"},"initLineHeight":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>lineHeight</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #lineHeight}.</p>","!type":"fn(value: Object) -> Object"},"initSize":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>size</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #size}.</p>","!type":"fn(value: Object) -> Object"},"initTextShadow":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>textShadow</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #textShadow}.</p>","!type":"fn(value: Object) -> Object"},"isBold":{"!doc":"<p>Check whether the (computed) value of the boolean property <code>bold</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #bold}.</p>","!type":"fn() -> bool"},"isItalic":{"!doc":"<p>Check whether the (computed) value of the boolean property <code>italic</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #italic}.</p>","!type":"fn() -> bool"},"resetBold":{"!doc":"<p>Resets the user value of the property <code>bold</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #bold}.</p>","!type":"fn()"},"resetColor":{"!doc":"<p>Resets the user value of the property <code>color</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #color}.</p>","!type":"fn()"},"resetDecoration":{"!doc":"<p>Resets the user value of the property <code>decoration</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #decoration}.</p>","!type":"fn()"},"resetFamily":{"!doc":"<p>Resets the user value of the property <code>family</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #family}.</p>","!type":"fn()"},"resetItalic":{"!doc":"<p>Resets the user value of the property <code>italic</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #italic}.</p>","!type":"fn()"},"resetLineHeight":{"!doc":"<p>Resets the user value of the property <code>lineHeight</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #lineHeight}.</p>","!type":"fn()"},"resetSize":{"!doc":"<p>Resets the user value of the property <code>size</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #size}.</p>","!type":"fn()"},"resetTextShadow":{"!doc":"<p>Resets the user value of the property <code>textShadow</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #textShadow}.</p>","!type":"fn()"},"setBold":{"!doc":"<p>Sets the user value of the property <code>bold</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #bold}.</p>","!type":"fn(value: Object) -> Object"},"setColor":{"!doc":"<p>Sets the user value of the property <code>color</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #color}.</p>","!type":"fn(value: Object) -> Object"},"setDecoration":{"!doc":"<p>Sets the user value of the property <code>decoration</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #decoration}.</p>","!type":"fn(value: Object) -> Object"},"setFamily":{"!doc":"<p>Sets the user value of the property <code>family</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #family}.</p>","!type":"fn(value: Object) -> Object"},"setItalic":{"!doc":"<p>Sets the user value of the property <code>italic</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #italic}.</p>","!type":"fn(value: Object) -> Object"},"setLineHeight":{"!doc":"<p>Sets the user value of the property <code>lineHeight</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #lineHeight}.</p>","!type":"fn(value: Object) -> Object"},"setSize":{"!doc":"<p>Sets the user value of the property <code>size</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #size}.</p>","!type":"fn(value: Object) -> Object"},"setTextShadow":{"!doc":"<p>Sets the user value of the property <code>textShadow</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #textShadow}.</p>","!type":"fn(value: Object) -> Object"},"toggleBold":{"!doc":"<p>Toggles the (computed) value of the boolean property <code>bold</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #bold}.</p>","!type":"fn() -> bool"},"toggleItalic":{"!doc":"<p>Toggles the (computed) value of the boolean property <code>italic</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #italic}.</p>","!type":"fn() -> bool"}}},"GeoLocation":{"!proto":"qx.core.Object","!doc":"<p><span class=\"caps\">EXPERIMENTAL</span> &#8211; <span class=\"caps\">NOT</span> <span class=\"caps\">READY</span> <span class=\"caps\">FOR</span> <span class=\"caps\">PRODUCTION</span></p>\n\n<p>GeoLocation provides access to geographical location information\nassociated with the hosting device.</p>\n\n<p>For more information see:\n<a href=\"http://www.w3.org/TR/geolocation-API/\">http://www.w3.org/TR/geolocation-API/</a></p>","!type":"fn()","prototype":{"_errorHandler":{"!doc":"<p>The Error handler.</p>","!type":"fn(error: fn())"},"_successHandler":{"!doc":"<p>Success handler.</p>","!type":"fn(position: fn())"},"getCurrentPosition":{"!doc":"<p>Retrieves the current position and calls the &#8220;position&#8221; event.</p>","!type":"fn(enableHighAccuracy: fn(), timeout: fn(), maximumAge: fn())"},"startWatchPosition":{"!doc":"<p>Starts to watch the position. Calls the &#8220;position&#8221; event, when the position changed.</p>","!type":"fn(enableHighAccuracy: fn(), timeout: fn(), maximumAge: fn())"},"stopWatchPosition":{"!doc":"<p>Stops watching the position.</p>","!type":"fn()"}},"getInstance":{"!doc":"<p>Returns a singleton instance of this class. On the first call the class\nis instantiated by calling the constructor with no arguments. All following\ncalls will return this instance.</p>\n\n<p>This method has been added by setting the &#8220;type&#8221; key in the class definition\n({@link qx.Class#define}) to &#8220;singleton&#8221;.</p>","!type":"fn() -> +qx.bom.GeoLocation"}},"HashHistory":{"!proto":"qx.bom.History","!doc":"<p>History manager implementation for IE greater 7. IE reloads iframe\ncontent on history actions even just hash value changed. This\nimplementation forwards history states (hashes) to a helper iframe.</p>","!type":"fn()","prototype":{"__attachListeners":{"!doc":"<p>Attach hash change listeners</p>","!type":"fn()"},"__createIframe":{"!doc":"<p><span class=\"caps\">IMPORTANT</span> <span class=\"caps\">NOTE</span> <span class=\"caps\">FOR</span> IE:\nSetting the source before adding the iframe to the document.\nOtherwise IE will bring up a &#8220;Unsecure items&#8230;&#8221; warning in <span class=\"caps\">SSL</span> mode</p>","!type":"fn() -> +Element"},"__detatchListeners":{"!doc":"<p>Remove hash change listeners</p>","!type":"fn()"},"__initIframe":{"!doc":"<p>Initializes the iframe</p>","!type":"fn()"},"__onHashChange":{"!doc":"<p>hash change event handler</p>","!type":"fn()"},"__waitForIFrame":{"!doc":"<p>Waits for the IFrame being loaded. Once the IFrame is loaded\nthe callback is called with the provided context.</p>","!type":"fn(callback: fn(), context?: Object, retry: +Integer)"},"_getHash":{"!doc":"<p>Returns the fragment identifier of the top window <span class=\"caps\">URL</span>. For gecko browsers we\nhave to use a regular expression to avoid encoding problems.</p>","!type":"fn() -> string"},"_readState":{"!doc":"<p>Browser dependent function to read the current state of the history</p>","!type":"fn() -> string"},"_setHash":{"!doc":"<p>Sets the fragment identifier of the window <span class=\"caps\">URL</span></p>","!type":"fn(value: string)"},"_writeState":{"!doc":"<p>Save a state into the browser history.</p>","!type":"fn(state: string)"},"addToHistory":{"!type":"fn(state: +undefined, newTitle: +undefined)"}}},"History":{"!proto":"qx.core.Object","!doc":"<p>A helper for using the browser history in JavaScript Applications without\nreloading the main page.</p>\n\n<p>Adds entries to the browser history and fires a &#8220;request&#8221; event when one of\nthe entries was requested by the user (e.g. by clicking on the back button).</p>\n\n<p>This class is an abstract template class. Concrete implementations have to\nprovide implementations for the {@link #_readState} and {@link #_writeState}\nmethods.</p>\n\n<p>Browser history support is currently available for Internet Explorer 6/7,\nFirefox, Opera 9 and WebKit. Safari 2 and older are not yet supported.</p>\n\n<p>This module is based on the ideas behind the <span class=\"caps\">YUI</span> Browser History Manager\nby Julien Lecomte (Yahoo), which is described at\n<a href=\"http://yuiblog.com/blog/2007/02/21/browser-history-manager/\">http://yuiblog.com/blog/2007/02/21/browser-history-manager/</a>. The Yahoo\nimplementation can be found at <a href=\"http://developer.yahoo.com/yui/history/\">http://developer.yahoo.com/yui/history/</a>.\nThe original code is licensed under a <span class=\"caps\">BSD</span> license\n(<a href=\"http://developer.yahoo.com/yui/license.txt\">http://developer.yahoo.com/yui/license.txt</a>).</p>","!type":"fn()","getInstance":{"!doc":"<p>Get the singleton instance of the history manager.</p>","!type":"fn() -> +History"},"prototype":{"_applyState":{"!doc":"<p>Applies changes of the property value of the property <code>state</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #state}.</p>","!type":"fn(value: string, old: string)"},"_applyTitle":{"!doc":"<p>Applies changes of the property value of the property <code>title</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #title}.</p>","!type":"fn(title: string, old: string)"},"_decode":{"!doc":"<p>Decodes a fragment identifier into a string</p>","!type":"fn(value: string) -> string"},"_encode":{"!doc":"<p>Encodes the state value into a format suitable as fragment identifier.</p>","!type":"fn(value: string) -> string"},"_getHash":{"!doc":"<p>Returns the fragment identifier of the top window <span class=\"caps\">URL</span>. For gecko browsers we\nhave to use a regular expression to avoid encoding problems.</p>","!type":"fn() -> string"},"_onHistoryLoad":{"!doc":"<p>Called on changes to the history using the browser buttons.</p>","!type":"fn(state: string)"},"_readState":{"!doc":"<p>Browser dependent function to read the current state of the history</p>","!type":"fn() -> string"},"_setHash":{"!doc":"<p>Sets the fragment identifier of the window <span class=\"caps\">URL</span></p>","!type":"fn(value: string)"},"_setInitialState":{"!doc":"<p>Populates the &#8216;state&#8217; property with the initial state value</p>","!type":"fn()"},"_writeState":{"!doc":"<p>Save a state into the browser history.</p>","!type":"fn()"},"addToHistory":{"!doc":"<p>Adds an entry to the browser history.</p>","!type":"fn(state: string, newTitle?: string)"},"getState":{"!doc":"<p>Returns the (computed) value of the property <code>state</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #state}.</p>","!type":"fn() -> Object"},"getTitle":{"!doc":"<p>Returns the (computed) value of the property <code>title</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #title}.</p>","!type":"fn() -> Object"},"initState":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>state</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #state}.</p>","!type":"fn(value: Object) -> Object"},"initTitle":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>title</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #title}.</p>","!type":"fn(value: Object) -> Object"},"navigateBack":{"!doc":"<p>Navigates back in the browser history.\nSimulates a back button click.</p>","!type":"fn()"},"navigateForward":{"!doc":"<p>Navigates forward in the browser history.\nSimulates a forward button click.</p>","!type":"fn()"},"resetState":{"!doc":"<p>Resets the user value of the property <code>state</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #state}.</p>","!type":"fn()"},"resetTitle":{"!doc":"<p>Resets the user value of the property <code>title</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #title}.</p>","!type":"fn()"},"setState":{"!doc":"<p>Sets the user value of the property <code>state</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #state}.</p>","!type":"fn(value: Object) -> Object"},"setTitle":{"!doc":"<p>Sets the user value of the property <code>title</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #title}.</p>","!type":"fn(value: Object) -> Object"}}},"Html":{"!doc":"<p>This class is mainly a convenience wrapper for <span class=\"caps\">DOM</span> elements to\nqooxdoo&#8217;s event system.</p>","__convertHtmlString":{"!doc":"<p>Translates a <span class=\"caps\">HTML</span> string into an array of elements.</p>","!type":"fn(html: string, context: +Document) -> +Array"},"__fixNonDirectlyClosableHelper":{"!doc":"<p>Helper method for <span class=\"caps\">XHTML</span> replacement.</p>","!type":"fn(all: string, front: string, tag: string) -> string"},"clean":{"!doc":"<p>Cleans-up the given <span class=\"caps\">HTML</span> and append it to a fragment</p>\n\n<p>When no <code>context</code> is given the global document is used to\ncreate new <span class=\"caps\">DOM</span> elements.</p>\n\n<p>When a <code>fragment</code> is given the nodes are appended to this\nfragment except the script tags. These are returned in a separate Array.</p>\n\n<p>Please note: <span class=\"caps\">HTML</span> coming from user input must be validated prior\nto passing it to this method. <span class=\"caps\">HTML</span> is temporarily inserted to the <span class=\"caps\">DOM</span>\nusing <code>innerHTML</code>. As a consequence, scripts included in\nattribute event handlers may be executed.</p>","!type":"fn(objs: +Element, context?: +Document, fragment?: +Element) -> +Element"},"extractScripts":{"!doc":"<p>Extracts script elements from an element list. Optionally\nattaches them to a given document fragment</p>","!type":"fn(elements: +Element, fragment?: +Document) -> +Element"},"fixEmptyTags":{"!doc":"<p>Fixes &#8220;XHTML&#8221;-style tags in all browsers.\nReplaces tags which are not allowed to be closed directly such as\n<code>div</code> or <code>p</code>. They are patched to use opening and\nclosing tags instead, e.g. <code>&lt;p&gt;</code> => <code>&lt;p&gt;&lt;/p&gt;</code></p>","!type":"fn(html: string) -> string"}},"Iframe":{"!doc":"<p>Cross browser abstractions to work with iframes.</p>","__rememberUrl":{"!doc":"<p>Remember actual <span class=\"caps\">URL</span> of iframe.</p>","!type":"fn(iframe: +Element)"},"create":{"!doc":"<p>Creates an <span class=\"caps\">DOM</span> element.</p>\n\n<p>Attributes may be given directly with this call. This is critical\nfor some attributes e.g. name, type, ... in many clients.</p>","!type":"fn(attributes?: +Map, win?: +Window) -> +Element"},"getBody":{"!doc":"<p>Get the <span class=\"caps\">HTML</span> body element of the iframe.</p>","!type":"fn(iframe: +Element) -> +Element"},"getDocument":{"!doc":"<p>Get the <span class=\"caps\">DOM</span> document object of an iframe.</p>","!type":"fn(iframe: +Element) -> +Document"},"getWindow":{"!doc":"<p>Get the <span class=\"caps\">DOM</span> window object of an iframe.</p>","!type":"fn(iframe: +Element) -> +Window"},"queryCurrentUrl":{"!doc":"<p>Returns the current (served) <span class=\"caps\">URL</span> inside the iframe</p>","!type":"fn(iframe: +Element) -> string"},"setSource":{"!doc":"<p>Sets iframe&#8217;s source attribute to given value</p>","!type":"fn(iframe: +Element, source: string)"}},"IframeHistory":{"!proto":"qx.bom.History","!doc":"<p>Implements an iFrame based history manager for IE 6/7/8.</p>\n\n<p>Creates a hidden iFrame and uses document.write to store entries in the\nhistory browser&#8217;s stack.</p>","!type":"fn()","prototype":{"__clearWriteSateTimer":{"!doc":"<p>Helper function to clear the write state timer.</p>","!type":"fn()"},"__createIframe":{"!doc":"<p><span class=\"caps\">IMPORTANT</span> <span class=\"caps\">NOTE</span> <span class=\"caps\">FOR</span> IE:\nSetting the source before adding the iframe to the document.\nOtherwise IE will bring up a &#8220;Unsecure items&#8230;&#8221; warning in <span class=\"caps\">SSL</span> mode</p>","!type":"fn() -> +Iframe"},"__initIframe":{"!doc":"<p>Initializes the iframe</p>","!type":"fn(handler?: fn())"},"__initTimer":{"!doc":"<p>Initialize the polling timer</p>","!type":"fn()"},"__isCurrentLocationState":{"!doc":"<p>Checks whether the given location state is the current one.</p>","!type":"fn(locationState: string) -> bool"},"__onHashChange":{"!doc":"<p>Hash change listener.</p>","!type":"fn(e: +qx.event.type.Event)"},"__storeLocationState":{"!doc":"<p>Stores the given location state.</p>","!type":"fn(locationState: string) -> string"},"__waitForIFrame":{"!doc":"<p>Waits for the IFrame being loaded. Once the IFrame is loaded\nthe callback is called with the provided context.</p>","!type":"fn(callback: fn(), context?: Object, retry: +Integer)"},"_applyState":{"!doc":"<p>Applies changes of the property value of the property <code>state</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #state}.</p>","!type":"fn(value: string, old: string)"},"_onHistoryLoad":{"!type":"fn(state: +undefined)"},"_readState":{"!doc":"<p>Get state from the iframe</p>","!type":"fn() -> string"},"_setHash":{"!type":"fn(value: +undefined)"},"_setInitialState":{"!type":"fn()"},"_setState":{"!doc":"<p>Helper function to set state property. This will only be called\nby _onHistoryLoad. It determines, that no apply of state will be called.</p>","!type":"fn(state: string)"},"_writeState":{"!doc":"<p>Store state to the iframe</p>","!type":"fn(state: string)"},"addToHistory":{"!type":"fn(state: +undefined, newTitle: +undefined)"}}},"Input":{"!doc":"<p>Cross browser abstractions to work with input elements.</p>","create":{"!doc":"<p>Creates an <span class=\"caps\">DOM</span> input/textarea/select element.</p>\n\n<p>Attributes may be given directly with this call. This is critical\nfor some attributes e.g. name, type, ... in many clients.</p>\n\n<p>Note: <code>select</code> and <code>textarea</code> elements are created\nusing the identically named <code>type</code>.</p>","!type":"fn(type: string, attributes: +Map, win: +Window) -> +Element"},"getValue":{"!doc":"<p>Returns the currently configured value.</p>\n\n<p>Works with simple input fields as well as with\nselect boxes or option elements.</p>\n\n<p>Returns an array in cases of multi-selection in\nselect boxes but in all other cases a string.</p>","!type":"fn(element: +Element) -> string"},"setValue":{"!doc":"<p>Applies the given value to the element.</p>\n\n<p>Normally the value is given as a string/number value and applied\nto the field content (textfield, textarea) or used to\ndetect whether the field is checked (checkbox, radiobutton).</p>\n\n<p>Supports array values for selectboxes (multiple-selection)\nand checkboxes or radiobuttons (for convenience).</p>\n\n<p>Please note: To modify the value attribute of a checkbox or\nradiobutton use {@link qx.bom.element.Attribute#set} instead.</p>","!type":"fn(element: +Element, value: string)"},"setWrap":{"!doc":"<p>Sets the text wrap behaviour of a text area element.\nThis property uses the attribute &#8220;wrap&#8221; respectively\nthe style property &#8220;whiteSpace&#8221;</p>","!type":"fn(element: +Element, wrap: bool)"}},"Label":{"!doc":"<p>Cross browser abstractions to work with labels.</p>","__createMeasureElement":{"!doc":"<p>Creates the measure element</p>","!type":"fn(html?: bool) -> +Element"},"__getStyles":{"!doc":"<p>Returns a map of all styles which should be applied as\na basic set.</p>","!type":"fn(html?: bool) -> +Map"},"__measureSize":{"!doc":"<p>Measure the size of the given element</p>","!type":"fn(element: +Element, styles?: +Map) -> +Map"},"__prepareHtml":{"!doc":"<p>Generates the helper <span class=\"caps\">DOM</span> element for <span class=\"caps\">HTML</span> measuring</p>","!type":"fn() -> +Element"},"__prepareText":{"!doc":"<p>Generates the helper <span class=\"caps\">DOM</span> element for text measuring</p>","!type":"fn() -> +Element"},"create":{"!doc":"<p>Creates a label.</p>\n\n<p>The default mode is &#8216;text&#8217; which means that the overlapping text is cut off\nusing ellipsis automatically. Text wrapping is disabled in this mode\nas well. Spaces are normalized. Umlauts and other special symbols are only\nallowed in unicode mode as normal characters.</p>\n\n<p>In the <span class=\"caps\">HTML</span> mode you can insert any <span class=\"caps\">HTML</span>, but loose the capability to cut\nof overlapping text. Automatic text wrapping is enabled by default.</p>\n\n<p>It is not possible to modify the mode afterwards.</p>","!type":"fn(content: string, html?: bool, win?: +Window) -> +Element"},"getHtmlSize":{"!doc":"<p>Returns the preferred dimensions of the given <span class=\"caps\">HTML</span> content.</p>","!type":"fn(content: string, styles?: +Map, width: +Integer) -> +Map"},"getTextSize":{"!doc":"<p>Returns the preferred dimensions of the given text.</p>","!type":"fn(text: string, styles: +Map) -> +Map"},"getValue":{"!doc":"<p>Returns the content of the element.</p>","!type":"fn(element: +Element) -> string"},"setValue":{"!doc":"<p>Sets the content of the element.</p>\n\n<p>The possibilities of the value depends on the mode\ndefined using {@link #create}.</p>","!type":"fn(element: +Element, value: string)"}},"Lifecycle":{"!doc":"<p>Low-level application life-cycle management.</p>\n\n<p>One can use the static methods {@link #onReady} and {@link #onShutdown} to\nadd callback functions, in order to get informed about the ready state or\nthe shutdown of the low-level application, respectively.</p>","onReady":{"!doc":"<p>Register a callback function, which is called in the optionally provided\ncontext, when the application is ready.</p>","!type":"fn(callback: fn(), context?: Object)"},"onShutdown":{"!doc":"<p>Register a callback function, which is called in the optionally provided\ncontext, when the application is shutdown.\n<b><span class=\"caps\">IMPORTANT</span> <span class=\"caps\">NOTE</span></b>: Since it is <i>not</i> guaranteed that a\n<code>shutdown</code> event is fired, you <i>cannot</i> fully rely on\ngetting informed.</p>","!type":"fn(callback: fn(), context?: Object)"}},"media":{"Abstract":{"!proto":"qx.core.Object","!doc":"<p><span class=\"caps\">EXPERIMENTAL</span> &#8211; <span class=\"caps\">NOT</span> <span class=\"caps\">READY</span> <span class=\"caps\">FOR</span> <span class=\"caps\">PRODUCTION</span></p>\n\n<p>Media element. Other media types can derive from this class.</p>","!type":"fn()","prototype":{"_handleEndedEvent":{"!doc":"<p>Ended event handler.</p>","!type":"fn()"},"_handleLoadedDataEvent":{"!doc":"<p>Loaded Data event handler.</p>","!type":"fn()"},"_handleLoadedMetaDataEvent":{"!doc":"<p>Loaded Metadata event handler.</p>","!type":"fn()"},"_handlePauseEvent":{"!doc":"<p>Pause event handler.</p>","!type":"fn()"},"_handlePlayEvent":{"!doc":"<p>Play event handler.</p>","!type":"fn()"},"_handleTimeUpdateEvent":{"!doc":"<p>Time Update event handler.</p>","!type":"fn()"},"_handleVolumeChangeEvent":{"!doc":"<p>Volume Change event handler.</p>","!type":"fn()"},"canPlayType":{"!doc":"<p>Whether the browser can play the file format.</p>","!type":"fn(type: string) -> bool"},"getAutoplay":{"!doc":"<p>Whether the media is played directly when it is loaded / the page is loaded.</p>","!type":"fn() -> bool"},"getCurrentTime":{"!doc":"<p>Gets current time of the playback.</p>","!type":"fn() -> number"},"getDuration":{"!doc":"<p>Gets the duration of the loaded media file.</p>","!type":"fn() -> number"},"getId":{"!doc":"<p>Gets the id of the media.</p>","!type":"fn() -> string"},"getMediaObject":{"!doc":"<p>Returns the media object, so that you can add it to the <span class=\"caps\">DOM</span>.</p>","!type":"fn() -> Object"},"getPreload":{"!doc":"<p>Returns how much buffering the media resource will likely need.</p>","!type":"fn() -> string"},"getSource":{"!doc":"<p>Gets the source url of the media file.</p>","!type":"fn() -> string"},"getVolume":{"!doc":"<p>Gets the current playback volume, as a number in the range 0.0 to 1.0,\nwhere 0.0 is the quietest and 1.0 the loudest.</p>","!type":"fn() -> number"},"hasControls":{"!doc":"<p>Checks if the media element shows its controls.</p>","!type":"fn() -> bool"},"hideControls":{"!doc":"<p>Hides the controls of the media element.</p>","!type":"fn()"},"isEnded":{"!doc":"<p>Checks if the media is ended or not.</p>","!type":"fn() -> bool"},"isLoop":{"!doc":"<p>Whether the media element is to seek back to the start of the media resource upon reaching the end.</p>","!type":"fn() -> bool"},"isMuted":{"!doc":"<p>Checks if the media element is muted or not</p>","!type":"fn() -> bool"},"isPaused":{"!doc":"<p>Checks if the media is paused or not.</p>","!type":"fn() -> bool"},"pause":{"!doc":"<p>Pauses playback of the media.</p>","!type":"fn()"},"play":{"!doc":"<p>Starts playback of the media.</p>","!type":"fn()"},"setAutoplay":{"!doc":"<p>Plays the media directly when it is loaded / the page is loaded.</p>","!type":"fn(autoplay: bool)"},"setCurrentTime":{"!doc":"<p>Sets the value of current time.</p>","!type":"fn(value: number)"},"setId":{"!doc":"<p>Sets the id of the media.</p>","!type":"fn(id: string)"},"setLoop":{"!doc":"<p>Indicates that the media element is to seek back to the start of the media resource upon reaching the end.</p>","!type":"fn(value: bool)"},"setMuted":{"!doc":"<p>Sets the media element to mute.</p>","!type":"fn(muted: bool)"},"setPreload":{"!doc":"<p>Hints how much buffering the media resource will likely need.</p>","!type":"fn(preload: string)"},"setSource":{"!doc":"<p>Sets the source url of the media file.</p>","!type":"fn(source: string)"},"setVolume":{"!doc":"<p>Sets the current playback volume, as a number in the range 0.0 to 1.0,\nwhere 0.0 is the quietest and 1.0 the loudest.</p>","!type":"fn(volume: number)"},"showControls":{"!doc":"<p>Shows the controls of the media element.</p>","!type":"fn()"}}},"Audio":{"!proto":"qx.bom.media.Abstract","!doc":"<p><span class=\"caps\">EXPERIMENTAL</span> &#8211; <span class=\"caps\">NOT</span> <span class=\"caps\">READY</span> <span class=\"caps\">FOR</span> <span class=\"caps\">PRODUCTION</span></p>\n\n<p>Media object for playing sounds.</p>","!type":"fn()"},"Video":{"!proto":"qx.bom.media.Abstract","!doc":"<p><span class=\"caps\">EXPERIMENTAL</span> &#8211; <span class=\"caps\">NOT</span> <span class=\"caps\">READY</span> <span class=\"caps\">FOR</span> <span class=\"caps\">PRODUCTION</span></p>\n\n<p>Media object for playing videos.</p>","!type":"fn()","prototype":{"getHeight":{"!doc":"<p>Gets the height of the video element.</p>","!type":"fn() -> number"},"getPoster":{"!doc":"<p>Gets the poster of the video.</p>","!type":"fn() -> string"},"getVideoHeight":{"!doc":"<p>Gets the height of the video.</p>","!type":"fn() -> number"},"getVideoWidth":{"!doc":"<p>Gets the width of the video.</p>","!type":"fn() -> number"},"getWidth":{"!doc":"<p>Gets the width of the video element.</p>","!type":"fn() -> number"},"setHeight":{"!doc":"<p>Sets the height of the video element.</p>","!type":"fn(value: number)"},"setPoster":{"!doc":"<p>Sets the poster of the video.</p>","!type":"fn(value: string)"},"setWidth":{"!doc":"<p>Sets the width of the video element.</p>","!type":"fn(value: number)"}}}},"MediaQuery":{"!proto":"qx.event.Emitter","!doc":"<p>This class is to test css media queries. It implements a polyfill for\nwindow.matchMedia if not supported natively.</p>","!type":"fn()","prototype":{"__changed":{"!doc":"<p>Callback for mediaqueries changes</p>","!type":"fn()"},"__init":{"!doc":"<p>Initialize the mediaquery listener</p>","!type":"fn()"},"__initMatchMedia":{"!doc":"<p>Initialize matchMedia polyfill</p>","!type":"fn(window: +Window)"},"getQuery":{"!doc":"<p>Returns the query string used to initialize the listener.</p>","!type":"fn() -> string"},"isMatching":{"!doc":"<p>Access the matching state of the media query.</p>","!type":"fn() -> bool"}}},"MediaQueryListener":{"!proto":"qx.bom.MediaQuery","!doc":"<p>This class is to test css media queries. It implements a polyfill for\nwindow.matchMedia if not supported natively.</p>","!type":"fn()"},"NativeHistory":{"!proto":"qx.bom.History","!doc":"<p>Default history manager implementation. Either polls for <span class=\"caps\">URL</span> fragment\nidentifier (hash) changes or uses the native &#8220;hashchange&#8221; event.</p>","!type":"fn()","prototype":{"__attachListeners":{"!doc":"<p>Attach hash change listeners</p>","!type":"fn()"},"__detatchListeners":{"!doc":"<p>Remove hash change listeners</p>","!type":"fn()"},"__onHashChange":{"!doc":"<p>hash change event handler</p>","!type":"fn()"},"_readState":{"!doc":"<p>Browser dependent function to read the current state of the history</p>","!type":"fn() -> string"}}},"PageVisibility":{"!proto":"qx.event.Emitter","!doc":"<p>This class offers a constant <span class=\"caps\">API</span> over the Page Visibility Spec:\n<a href=\"http://www.w3.org/TR/page-visibility/\">http://www.w3.org/TR/page-visibility/</a></p>\n\n<p>It forwards all the browsers support and provides always a fallback which is\nof course visible all the time.</p>","getInstance":{"!doc":"<p>Get an instance of the PageVisibility object using the default document.</p>","!type":"fn() -> +qx.bom.PageVisibility"},"!type":"fn()","prototype":{"__checkAttributeNames":{"!doc":"<p>Internal helper to feature check the attribute names and the event name.\nAs the event can not be detected using the on attribute, we need\nto guess the event name by checking for the hidden attribute.</p>","!type":"fn()"},"getVisibilityState":{"!doc":"<p>Returns the visibility state of the page. If we can not detect it,\n<code>&#8220;visible&#8221;</code> will always be returned.</p>","!type":"fn() -> string"},"isHidden":{"!doc":"<p>Returns weather the page is hidden or not. If we can not detect it,\n<code>false</code> will always be returned.</p>","!type":"fn() -> bool"}}},"Range":{"!doc":"<p>Low-level Range <span class=\"caps\">API</span> which is used together with the low-level Selection <span class=\"caps\">API</span>.\nThis is especially useful whenever a developer want to work on text level,\ne.g. for an editor.</p>","get":{"!doc":"<p>Returns the range object of the given node.</p>","!type":"fn(node: +Node) -> +Range"}},"request":{"IRequest":{"!doc":"<p>Interface of a low-level transport compatible with\n{@link qx.io.request.AbstractRequest}.</p>\n\n<p>Based on interface specified in\n<a href=\"http://www.w3.org/TR/XMLHttpRequest/\">XmlHttpRequest</a>. Also\nborrows some methods as described in\n<a href=\"http://www.w3.org/TR/XMLHttpRequest2/\">XmlHttpRequest2</a>.</p>","prototype":{"abort":{"!doc":"<p>Abort request</p>","!type":"fn()"},"getAllResponseHeaders":{"!doc":"<p>Get all response headers from response.</p>","!type":"fn() -> string"},"getResponseHeader":{"!doc":"<p>Get a single response header from response.</p>","!type":"fn(header: string) -> string"},"onabort":{"!doc":"<p>Event handler for event fired when request is aborted.</p>","!type":"fn()"},"onerror":{"!doc":"<p>Event handler for event fired on a network error.</p>","!type":"fn()"},"onload":{"!doc":"<p>Event handler for event fired on successful retrieval.</p>","!type":"fn()"},"onloadend":{"!doc":"<p>Event handler for event fired on retrieval.</p>","!type":"fn()"},"onreadystatechange":{"!doc":"<p>Event handler for event fired at every state change.</p>","!type":"fn()"},"ontimeout":{"!doc":"<p>Event handler for event fired when timeout interval has passed.</p>","!type":"fn()"},"open":{"!doc":"<p>Initializes (prepares) request.</p>","!type":"fn(method: string, url: string, async?: bool)"},"send":{"!doc":"<p>Sends request.</p>","!type":"fn(data?: string)"},"setRequestHeader":{"!doc":"<p>Sets a request header to be used by the request.</p>","!type":"fn(key: string, value: string)"}}},"Jsonp":{"!proto":"qx.bom.request.Script","!doc":"<p>A special script loader handling <span class=\"caps\">JSONP</span> responses. Automatically\nprovides callbacks and populates responseJson property.</p>\n\n<p>Example:</p>\n\n<pre class=\"javascript\">\n var req = new qx.bom.request.Jsonp();\n\n // Some services have a fixed callback name\n // req.setCallbackName(\"callback\");\n\n req.onload = function() {\n   // Handle data received\n   req.responseJson;\n }\n\n req.open(\"GET\", url);\n req.send();\n</pre>","!type":"fn()","prototype":{"__callBase":{"!doc":"<p>Call overriden method.</p>","!type":"fn(method: string, args: +Array)"},"__deleteCustomCallback":{"!doc":"<p>Delete custom callback if dynamically created before.</p>","!type":"fn()"},"__generateId":{"!doc":"<p>Generate ID.</p>","!type":"fn()"},"_onNativeLoad":{"!doc":"<p>Handle native load.</p>","!type":"fn()"},"callback":{"!doc":"<p>Callback provided for <span class=\"caps\">JSONP</span> response to pass data.</p>\n\n<p>Called internally to populate responseJson property\nand indicate successful status.</p>\n\n<p>Note: If you write a custom callback you&#8217;ll need to call\nthis method in order to notify the request about the data\nloaded. Writing a custom callback should not be necessary\nin most cases.</p>","!type":"fn(data: Object)"},"dispose":{"!type":"fn()"},"getGeneratedUrl":{"!doc":"<p>Returns the generated <span class=\"caps\">URL</span> for the current / last request</p>","!type":"fn() -> string"},"open":{"!doc":"<p>Initializes (prepares) request.</p>","!type":"fn(method: string, url: string)"},"setCallbackName":{"!doc":"<p>Set callback name.</p>\n\n<p>Must be set to the name of the callback function that is called by the\nscript returned from the <span class=\"caps\">JSONP</span> service. By default, the callback name\nreferences this instance&#8217;s {@link #callback} method, allowing to connect\nmultiple <span class=\"caps\">JSONP</span> responses to different requests.</p>\n\n<p>If the <span class=\"caps\">JSONP</span> service allows to set custom callback names, it should not\nbe necessary to change the default. However, some services use a fixed\ncallback name. This is when setting the callbackName is useful. A\nfunction is created and made available globally under the given name.\nThe function receives the <span class=\"caps\">JSON</span> data and dispatches it to this instance&#8217;s\n{@link #callback} method. Please note that this function is only created\nif it does not exist before.</p>","!type":"fn(name: string) -> +qx.bom.request.Jsonp"},"setCallbackParam":{"!doc":"<p>Set callback parameter.</p>\n\n<p>Some <span class=\"caps\">JSONP</span> services expect the callback name to be passed labeled with a\nspecial <span class=\"caps\">URL</span> parameter key, e.g. &#8220;jsonp&#8221; in &#8221;?jsonp=myCallback&#8221;. The\ndefault is &#8220;callback&#8221;.</p>","!type":"fn(param: string) -> +qx.bom.request.Jsonp"},"setPrefix":{"!doc":"<p>Set the prefix used in front of &#8216;qx.&#8217; in case &#8216;qx&#8217; is not available\n(for qx.Website e.g.)</p>","!type":"fn(prefix: string)"}}},"Script":{"!doc":"<p>Script loader with interface similar to\n<a href=\"http://www.w3.org/TR/XMLHttpRequest/\">XmlHttpRequest</a>.</p>\n\n<p>The script loader can be used to load scripts from arbitrary sources.\n<span class=\"desktop\">\nFor <span class=\"caps\">JSONP</span> requests, consider the {@link qx.bom.request.Jsonp} transport\nthat derives from the script loader.\n</span></p>\n\n<div class=\"desktop\">\nExample:\n\n<pre class=\"javascript\">\n var req = new qx.bom.request.Script();\n req.onload = function() {\n   // Script is loaded and parsed and\n   // globals set are available\n }\n\n req.open(\"GET\", url);\n req.send();\n</pre>\n\n</div>","!type":"fn()","prototype":{"__createScriptElement":{"!doc":"<p>Create and configure script element.</p>","!type":"fn() -> +Element"},"__disposeScriptElement":{"!doc":"<p>Remove script element from <span class=\"caps\">DOM</span>.</p>","!type":"fn()"},"__environmentGet":{"!doc":"<p>Proxy Environment.get to guard against env not being present yet.</p>","!type":"fn(key: string) -> Object"},"__failure":{"!doc":"<p>Handle failure.</p>","!type":"fn()"},"__initXhrProperties":{"!doc":"<p>Initialize properties.</p>","!type":"fn()"},"__supportsErrorHandler":{"!doc":"<p>Looks up whether browser supports error handler.</p>","!type":"fn() -> bool"},"_emit":{"!doc":"<p>Helper to emit events and call the callback methods.</p>","!type":"fn(event: string)"},"_getScriptElement":{"!doc":"<p>Get script element used for request.</p>","!type":"fn() -> +Element"},"_getUrl":{"!doc":"<p>Get <span class=\"caps\">URL</span> of request.</p>","!type":"fn() -> string"},"_onNativeError":{"!doc":"<p>Handle native error.</p>","!type":"fn()"},"_onNativeLoad":{"!doc":"<p>Handle native load.</p>","!type":"fn()"},"_onTimeout":{"!doc":"<p>Handle timeout.</p>","!type":"fn()"},"_readyStateChange":{"!doc":"<p>Change readyState.</p>","!type":"fn(readyState: number)"},"_success":{"!doc":"<p>Handle success.</p>","!type":"fn()"},"abort":{"!doc":"<p>Aborts request.</p>","!type":"fn() -> +qx.bom.request.Script"},"dispose":{"!doc":"<p>Dispose object.</p>","!type":"fn()"},"getAllResponseHeaders":{"!doc":"<p>Get all response headers from response.</p>\n\n<p>Note: This method exists for compatibility reasons. The script\ntransport does not receive response headers.</p>","!type":"fn() -> string"},"getResponseHeader":{"!doc":"<p>Get a single response header from response.</p>\n\n<p>Note: This method exists for compatibility reasons. The script\ntransport does not receive response headers.</p>","!type":"fn(key: string) -> string"},"isDisposed":{"!doc":"<p>Check if the request has already beed disposed.</p>","!type":"fn() -> bool"},"on":{"!doc":"<p>Add an event listener for the given event name.</p>","!type":"fn(name: string, listener: fn(), ctx?: Object) -> +qx.bom.request.Script"},"onabort":{"!doc":"<p>Event handler for <span class=\"caps\">XHR</span> event &#8220;abort&#8221; that is fired when request\nis aborted.</p>\n\n<p>Replace with custom method to listen to the &#8220;abort&#8221; event.</p>","!type":"fn()"},"onerror":{"!doc":"<p>Event handler for <span class=\"caps\">XHR</span> event &#8220;error&#8221; that is fired on a network error.</p>\n\n<p>Note: Some browsers do not support the &#8220;error&#8221; event.</p>\n\n<p>Replace with custom method to listen to the &#8220;error&#8221; event.</p>","!type":"fn()"},"onload":{"!doc":"<p>Event handler for <span class=\"caps\">XHR</span> event &#8220;load&#8221; that is fired on successful retrieval.</p>\n\n<p>Note: This handler is called even when an invalid script is returned.</p>\n\n<p>Warning: Internet Explorer < 9 receives a false &#8220;load&#8221; for invalid URLs.\nThis &#8220;load&#8221; is fired about 2 seconds after sending the request. To\ndistinguish from a real &#8220;load&#8221;, consider defining a custom check\nfunction using {@link #setDetermineSuccess} and query the status\nproperty. However, the script loaded needs to have a known impact on\nthe global namespace. If this does not work for you, you may be able\nto set a timeout lower than 2 seconds, depending on script size,\ncomplexity and execution time.</p>\n\n<p>Replace with custom method to listen to the &#8220;load&#8221; event.</p>","!type":"fn()"},"onloadend":{"!doc":"<p>Event handler for <span class=\"caps\">XHR</span> event &#8220;loadend&#8221; that is fired on retrieval.</p>\n\n<p>Note: This handler is called even when a network error (or similar)\noccurred.</p>\n\n<p>Replace with custom method to listen to the &#8220;loadend&#8221; event.</p>","!type":"fn()"},"onreadystatechange":{"!doc":"<p>Event handler for an event that fires at every state change.</p>\n\n<p>Replace with custom method to get informed about the communication progress.</p>","!type":"fn()"},"ontimeout":{"!doc":"<p>Event handler for <span class=\"caps\">XHR</span> event &#8220;timeout&#8221; that is fired when timeout\ninterval has passed.</p>\n\n<p>Replace with custom method to listen to the &#8220;timeout&#8221; event.</p>","!type":"fn()"},"open":{"!doc":"<p>Initializes (prepares) request.</p>","!type":"fn(method: string, url: string)"},"send":{"!doc":"<p>Sends request.</p>","!type":"fn() -> +qx.bom.request.Script"},"setDetermineSuccess":{"!doc":"<p>Determine if loaded script has expected impact on global namespace.</p>\n\n<p>The function is called once the script was loaded and must return a\nboolean indicating if the response is to be considered successful.</p>","!type":"fn(check: fn())"},"setRequestHeader":{"!doc":"<p>Appends a query parameter to <span class=\"caps\">URL</span>.</p>\n\n<p>This method exists for compatibility reasons. The script transport\ndoes not support request headers. However, many services parse query\nparameters like request headers.</p>\n\n<p>Note: The request must be initialized before using this method.</p>","!type":"fn(key: string, value: string) -> +qx.bom.request.Script"}}},"SimpleXhr":{"!proto":"Object","!doc":"<p>This class is internal because it&#8217;s tailored to {@link qx.io.rest.Resource}\nwhich needs more functionality than {@link qx.bom.request.Xhr} provides.\nThe usage of {@link qx.io.request.Xhr} isn&#8217;t possible either due to it&#8217;s qx.Class nature.</p>\n\n<p>For alternatives to this class have a look at:</p>\n\n<ul>\n<li>&#8220;qx.bom.request.Xhr&#8221; (low level, cross-browser <span class=\"caps\">XHR</span> abstraction compatible with spec)</li>\n<li>&#8220;qx.io.request.Xhr&#8221; (high level <span class=\"caps\">XHR</span> abstraction)</li>\n</ul>\n\n<p>A wrapper of {@link qx.bom.request.Xhr} which offers:</p>\n\n<ul>\n<li>set/get <span class=\"caps\">HTTP</span> method, <span class=\"caps\">URL</span>, request data and headers</li>\n<li>retrieve the parsed response as object (content-type recognition)</li>\n<li>more fine-grained events such as success, fail, ...</li>\n<li>supports hash code for request identification</li>\n</ul>\n\n<p>It does <strong>not</strong> comply the interface defined by {@link qx.bom.request.IRequest}.</p>\n\n<div class=\"desktop\">\nExample:\n\n<pre class=\"javascript\">\n var req = new qx.bom.request.SimpleXhr(\"/some/path/file.json\");\n req.setRequestData({\"a\":\"b\"});\n req.once(\"success\", function successHandler() {\n   var response = req.getResponse();\n }, this);\n req.once(\"fail\", function successHandler() {\n   var response = req.getResponse();\n }, this);\n req.send();\n</pre>\n\n</div>","!type":"fn()","prototype":{"__onReadyStateDone":{"!doc":"<p>Called internally when readyState is <span class=\"caps\">DONE</span>.</p>","!type":"fn()"},"_createResponseParser":{"!doc":"<p>Creates response parser.</p>","!type":"fn() -> +qx.util.ResponseParser"},"_createTransport":{"!doc":"<p>Creates <span class=\"caps\">XHR</span> transport.</p>\n\n<p>May be overriden to change type of resource.</p>","!type":"fn() -> +qx.bom.request.IRequest"},"_onAbort":{"!doc":"<p>Handles &#8220;abort&#8221; event.</p>","!type":"fn()"},"_onError":{"!doc":"<p>Handles &#8220;error&#8221; event.</p>","!type":"fn()"},"_onLoadEnd":{"!doc":"<p>Handles &#8220;loadEnd&#8221; event.</p>","!type":"fn()"},"_onReadyStateChange":{"!doc":"<p>Handles &#8220;readyStateChange&#8221; event.</p>","!type":"fn()"},"_onTimeout":{"!doc":"<p>Handles &#8220;timeout&#8221; event.</p>","!type":"fn()"},"_registerTransportListener":{"!doc":"<p>Registers common listeners on given transport.</p>","!type":"fn(transport: +qx.bom.request.IRequest) -> +qx.bom.request.IRequest"},"_serializeData":{"!doc":"<p>Serializes data.</p>","!type":"fn(data: string, contentType?: string) -> string"},"_setResponse":{"!doc":"<p>Sets the response.</p>","!type":"fn(response: string)"},"abort":{"!doc":"<p>Aborts request.</p>\n\n<p>Cancels any network activity.</p>","!type":"fn() -> +qx.bom.request.SimpleXhr"},"addListenerOnce":{"!doc":"<p>Adds an event listener for the given event name which is executed only once.</p>","!type":"fn(name: string, listener: fn(), ctx?: Object) -> +qx.bom.request.Xhr"},"dispose":{"!doc":"<p>Disposes object and wrapped transport.</p>","!type":"fn() -> bool"},"getMethod":{"!doc":"<p>Gets the <span class=\"caps\">HTTP</span>-Method.</p>","!type":"fn() -> string"},"getRequestData":{"!doc":"<p>Gets the request data.</p>","!type":"fn() -> string"},"getRequestHeader":{"!doc":"<p>Gets a request header.</p>","!type":"fn(key: string) -> string"},"getResponse":{"!doc":"<p>Gets parsed response.</p>\n\n<p>If problems occured an empty string (&#8221;&#8221;) is more likely to be returned (instead of null).</p>","!type":"fn() -> string"},"getTimeout":{"!doc":"<p>The current timeout in milliseconds.</p>","!type":"fn() -> number"},"getTransport":{"!doc":"<p>Gets low-level transport.</p>\n\n<p>Note: To be used with caution!</p>\n\n<p>This method can be used to query the transport directly,\nbut should be used with caution. Especially, it\nis not advisable to call any destructive methods\nsuch as <code>open</code> or <code>send</code>.</p>","!type":"fn() -> Object"},"getUrl":{"!doc":"<p>Gets the <span class=\"caps\">URL</span>.</p>","!type":"fn() -> string"},"isCaching":{"!doc":"<p>Whether requests are cached.</p>","!type":"fn() -> bool"},"isDisposed":{"!doc":"<p>Returns true if the object is disposed.</p>","!type":"fn() -> bool"},"isDone":{"!doc":"<p>Whether request completed (is done).</p>","!type":"fn() -> bool"},"send":{"!doc":"<p>Sends request.</p>\n\n<p>Relies on set before:\n* a <span class=\"caps\">HTTP</span> method\n* an <span class=\"caps\">URL</span>\n* optional request headers\n* optional request data</p>","!type":"fn()"},"setMethod":{"!doc":"<p>Sets the <span class=\"caps\">HTTP</span>-Method.</p>","!type":"fn(method: string) -> +qx.bom.request.SimpleXhr"},"setParser":{"!doc":"<p>Sets (i.e. override) the parser for the response parsing.</p>","!type":"fn(parser: string) -> fn()"},"setRequestData":{"!doc":"<p>Sets the request data to be send as part of the request.</p>\n\n<p>The request data is transparently included as <span class=\"caps\">URL</span> query parameters or embedded in the\nrequest body as form data.</p>","!type":"fn(data: string) -> +qx.bom.request.SimpleXhr"},"setRequestHeader":{"!doc":"<p>Sets a request header.</p>","!type":"fn(key: string, value: string) -> +qx.bom.request.SimpleXhr"},"setTimeout":{"!doc":"<p>Sets the timout limit in milliseconds.</p>","!type":"fn(millis: number) -> +qx.bom.request.SimpleXhr"},"setUrl":{"!doc":"<p>Sets the <span class=\"caps\">URL</span>.</p>","!type":"fn(url: string) -> +qx.bom.request.SimpleXhr"},"toHashCode":{"!doc":"<p>Returns unique hash code of object.</p>","!type":"fn() -> +Integer"},"useCaching":{"!doc":"<p>Whether to allow request to be answered from cache.</p>\n\n<p>Allowed values:</p>\n\n<ul>\n<li><code>true</code>: Allow caching (Default)</li>\n<li><code>false</code>: Prohibit caching. Appends &#8216;nocache&#8217; parameter to <span class=\"caps\">URL</span>.</li>\n</ul>\n\n<p>Consider setting a Cache-Control header instead. A request&#8217;s Cache-Control\nheader may contain a number of directives controlling the behavior of\nany caches in between client and origin server and allows therefore a more\nfine grained control over caching. If such a header is provided, the setting\nof setCache() will be ignored.</p>\n\n<ul>\n<li><code>&#8220;no-cache&#8221;</code>: Force caches to submit request in order to<br />\nvalidate the freshness of the representation. Note that the requested<br />\nresource may still be served from cache if the representation is<br />\nconsidered fresh. Use this directive to ensure freshness but save<br />\nbandwidth when possible.</li>\n<li><code>&#8220;no-store&#8221;</code>: Do not keep a copy of the representation under<br />\nany conditions.</li>\n</ul>\n\n<p>See <a href=\"http://www.mnot.net/cache_docs/#CACHE-CONTROL\">\nCaching tutorial</a> for an excellent introduction to Caching in general.\nRefer to the corresponding section in the\n<a href=\"http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9\">\n<span class=\"caps\">HTTP</span> 1.1 specification</a> for more details and advanced directives.</p>\n\n<p>It is recommended to choose an appropriate Cache-Control directive rather\nthan prohibit caching using the nocache parameter.</p>","!type":"fn(value: bool) -> +qx.bom.request.SimpleXhr"}}},"Xhr":{"!proto":"Object","!doc":"<p>A wrapper of the XMLHttpRequest host object (or equivalent). The interface is\nsimilar to <a href=\"http://www.w3.org/TR/XMLHttpRequest/\">XmlHttpRequest</a>.</p>\n\n<p>Hides browser inconsistencies and works around bugs found in popular\nimplementations.</p>\n\n<div class=\"desktop\">\nExample:\n\n<pre class=\"javascript\">\n var req = new qx.bom.request.Xhr();\n req.onload = function() {\n   // Handle data received\n   req.responseText;\n }\n\n req.open(\"GET\", url);\n req.send();\n</pre>\n\n</div>","!type":"fn()","prototype":{"__checkDisposed":{"!doc":"<p>Throw when already disposed.</p>","!type":"fn()"},"__initNativeXhr":{"!doc":"<p>Init native <span class=\"caps\">XHR</span>.</p>","!type":"fn()"},"__isNetworkError":{"!doc":"<p>Check for network error.</p>","!type":"fn() -> bool"},"__normalizeResponseXML":{"!doc":"<p>Normalize responseXML property across browsers.</p>","!type":"fn()"},"__normalizeStatus":{"!doc":"<p>Normalize status property across browsers.</p>","!type":"fn()"},"__onNativeAbort":{"!doc":"<p>Track native abort.</p>\n\n<p>In case the end user cancels the request by other\nmeans than calling abort().</p>","!type":"fn()"},"__onNativeReadyStateChange":{"!doc":"<p>Handle native onreadystatechange.</p>\n\n<p>Calls user-defined function onreadystatechange on each\nstate change and syncs the <span class=\"caps\">XHR</span> status properties.</p>","!type":"fn()"},"__onTimeout":{"!doc":"<p>Handle faked timeout.</p>","!type":"fn()"},"__onUnload":{"!doc":"<p>Handler for native unload event.</p>","!type":"fn()"},"__readyStateChange":{"!doc":"<p>Handle readystatechange. Called internally when readyState is changed.</p>","!type":"fn()"},"__readyStateChangeDone":{"!doc":"<p>Handle readystatechange. Called internally by\n{@link #__readyStateChange} when readyState is <span class=\"caps\">DONE</span>.</p>","!type":"fn()"},"__supportsManyRequests":{"!doc":"<p>Helper method to determine whether browser supports reusing the\nsame native <span class=\"caps\">XHR</span> to send more requests.</p>","!type":"fn() -> bool"},"_createNativeXhr":{"!doc":"<p>Create XMLHttpRequest (or equivalent).</p>","!type":"fn() -> Object"},"_emit":{"!doc":"<p>Helper to emit events and call the callback methods.</p>","!type":"fn(event: string)"},"_getProtocol":{"!doc":"<p>Get protocol of requested <span class=\"caps\">URL</span>.</p>","!type":"fn() -> string"},"abort":{"!doc":"<p>Abort request &#8211; i.e. cancels any network activity.</p>\n\n<p>Note:\n On Windows 7 every browser strangely skips the loading phase\n when this method is called (because readyState never gets 3).</p>\n\n<p>So keep this in mind if you rely on the phases which are\n passed through. They will be &#8220;opened&#8221;, &#8220;sent&#8221;, &#8220;abort&#8221;\n instead of normally &#8220;opened&#8221;, &#8220;sent&#8221;, &#8220;loading&#8221;, &#8220;abort&#8221;.</p>","!type":"fn() -> +qx.bom.request.Xhr"},"dispose":{"!doc":"<p>Dispose object and wrapped native <span class=\"caps\">XHR</span>.</p>","!type":"fn() -> bool"},"getAllResponseHeaders":{"!doc":"<p>Get all response headers from response.</p>","!type":"fn() -> string"},"getRequest":{"!doc":"<p>Get wrapped native XMLHttpRequest (or equivalent).</p>\n\n<p>Can be XMLHttpRequest or ActiveX.</p>","!type":"fn() -> Object"},"getResponseHeader":{"!doc":"<p>Get a single response header from response.</p>","!type":"fn(header: string) -> string"},"isDisposed":{"!doc":"<p>Check if the request has already beed disposed.</p>","!type":"fn() -> bool"},"on":{"!doc":"<p>Add an event listener for the given event name.</p>","!type":"fn(name: string, listener: fn(), ctx?: Object) -> +qx.bom.request.Xhr"},"onabort":{"!doc":"<p>Event handler for <span class=\"caps\">XHR</span> event &#8220;abort&#8221; that is fired when request\nis aborted.</p>\n\n<p>Replace with custom method to listen to the &#8220;abort&#8221; event.</p>","!type":"fn()"},"onerror":{"!doc":"<p>Event handler for <span class=\"caps\">XHR</span> event &#8220;error&#8221; that is fired on a network error.</p>\n\n<p>Replace with custom method to listen to the &#8220;error&#8221; event.</p>","!type":"fn()"},"onload":{"!doc":"<p>Event handler for <span class=\"caps\">XHR</span> event &#8220;load&#8221; that is fired on successful retrieval.</p>\n\n<p>Note: This handler is called even when the <span class=\"caps\">HTTP</span> status indicates an error.</p>\n\n<p>Replace with custom method to listen to the &#8220;load&#8221; event.</p>","!type":"fn()"},"onloadend":{"!doc":"<p>Event handler for <span class=\"caps\">XHR</span> event &#8220;loadend&#8221; that is fired on retrieval.</p>\n\n<p>Note: This handler is called even when a network error (or similar)\noccurred.</p>\n\n<p>Replace with custom method to listen to the &#8220;loadend&#8221; event.</p>","!type":"fn()"},"onreadystatechange":{"!doc":"<p>Event handler for <span class=\"caps\">XHR</span> event that fires at every state change.</p>\n\n<p>Replace with custom method to get informed about the communication progress.</p>","!type":"fn()"},"ontimeout":{"!doc":"<p>Event handler for <span class=\"caps\">XHR</span> event &#8220;timeout&#8221; that is fired when timeout\ninterval has passed.</p>\n\n<p>Replace with custom method to listen to the &#8220;timeout&#8221; event.</p>","!type":"fn()"},"open":{"!doc":"<p>Initializes (prepares) request.</p>","!type":"fn(method?: string, url: string, async?: bool, user?: string, password?: string)"},"overrideMimeType":{"!doc":"<p>Overrides the <span class=\"caps\">MIME</span> type returned by the server\nand must be called before <code>send()</code>.</p>\n\n<p>Note:</p>\n\n<ul>\n<li>IE doesn&#8217;t support this method so in this case an Error is thrown.</li>\n<li>after calling this method <code>getResponseHeader(&#8220;Content-Type&#8221;)</code><br />\n  may return the original (Firefox 23, IE 10, Safari 6) or<br />\n  the overriden content type (Chrome 28+, Opera 15+).</li>\n</ul>","!type":"fn(mimeType: string) -> +qx.bom.request.Xhr"},"send":{"!doc":"<p>Sends request.</p>","!type":"fn(data?: string) -> +qx.bom.request.Xhr"},"setRequestHeader":{"!doc":"<p>Sets an <span class=\"caps\">HTTP</span> request header to be used by the request.</p>\n\n<p>Note: The request must be initialized before using this method.</p>","!type":"fn(key: string, value: string) -> +qx.bom.request.Xhr"}}}},"rest":{"Resource":{"!proto":"qx.event.Emitter","!doc":"<p>Client-side wrapper of a <span class=\"caps\">REST</span> resource.</p>\n\n<p>Each instance represents a resource in terms of <span class=\"caps\">REST</span>. A number of actions\n(usually <span class=\"caps\">HTTP</span> methods) unique to the resource can be defined and invoked.\nA resource with its actions is configured declaratively by passing a resource\ndescription to the constructor, or programatically using {@link #map}.</p>\n\n<p>Each action is associated to a route. A route is a combination of method,\n<span class=\"caps\">URL</span> pattern and optional parameter constraints.</p>\n\n<p>An action is invoked by calling a method with the same name. When a <span class=\"caps\">URL</span>\npattern of a route contains positional parameters, those parameters must be\npassed when invoking the associated action. Also, constraints defined in the\nroute must be satisfied.</p>\n\n<p>When an action is invoked, a request is configured according to the associated\nroute, is passed the <span class=\"caps\">URL</span> parameters, request body data, and finally send.\nWhat kind of request is send can be configured by overwriting {@link #_getRequest}.</p>\n\n<p>No contraints on the action&#8217;s name or the scope of the URLs are imposed. However,\nif you want to follow RESTful design patterns it is recommended to name actions\nthe same as the <span class=\"caps\">HTTP</span> action.</p>\n\n<pre class=\"javascript\">\nvar description = {\n \"get\": { method: \"GET\", url: \"/photo/{id}\" },\n \"put\": { method: \"PUT\", url: \"/photo/{id}\"},\n \"post\": { method: \"POST\", url: \"/photos/\"}\n};\nvar photo = new qx.bom.rest.Resource(description);\n// Can also be written: photo.invoke(\"get\", {id: 1});\nphoto.get({id: 1});\n\n// Additionally sets request data (provide it as string or set the content type)\n// In a RESTful environment this creates a new resource with the given 'id'\nphoto.configureRequest(function(req) {\n req.setRequestHeader(\"Content-Type\", \"application/json\");\n});\nphoto.put({id: 1}, {title: \"Monkey\"});\n\n// Additionally sets request data (provide it as string or set the content type)\n// In a RESTful environment this adds a new resource to the resource collection 'photos'\nphoto.configureRequest(function(req) {\n req.setRequestHeader(\"Content-Type\", \"application/json\");\n});\nphoto.post(null, {title: \"Monkey\"});\n</pre>\n\n<p>To check for existence of <span class=\"caps\">URL</span> parameters or constrain them to a certain format, you\ncan add a <code>check</code> property to the description. See {@link #map} for details.</p>\n\n<pre class=\"javascript\">\nvar description = {\n \"get\": { method: \"GET\", url: \"/photo/{id}\", check: { id: /\\d+/ } }\n};\nvar photo = new qx.bom.rest.Resource(description);\n// photo.get({id: \"FAIL\"});\n// -- Error: \"Parameter 'id' is invalid\"\n</pre>\n\n<p>If your description happens to use the same action more than once, consider\ndefining another resource.</p>\n\n<pre class=\"javascript\">\nvar description = {\n \"get\": { method: \"GET\", url: \"/photos\"},\n};\n// Distinguish \"photo\" (singular) and \"photos\" (plural) resource\nvar photos = new qx.bom.rest.Resource(description);\nphotos.get();\n</pre>\n\n<p>Basically, all routes of a resource should point to the same <span class=\"caps\">URL</span> (resource in\nterms of <span class=\"caps\">HTTP</span>). One acceptable exception of this constraint are resources where\nrequired parameters are part of the <span class=\"caps\">URL</span> (<code>/photos/1/</code>) or filter\nresources. For instance:</p>\n\n<pre class=\"javascript\">\nvar description = {\n \"get\": { method: \"GET\", url: \"/photos/{tag}\" }\n};\nvar photos = new qx.bom.rest.Resource(description);\nphotos.get();\nphotos.get({tag: \"wildlife\"})\n</pre>\n\n<p>Strictly speaking, the <code>photos</code> instance represents two distinct resources\nand could therefore just as well mapped to two distinct resources (for instance,\nnamed photos and photosTagged). What style to choose depends on the kind of data\nreturned. For instance, it seems sensible to stick with one resource if the filter\nonly limits the result set (i.e. the invidual results have the same properties).</p>\n\n<p>In order to respond to successful (or erroneous) invocations of actions,\neither listen to the generic &#8220;success&#8221; or &#8220;error&#8221; event and get the action\nfrom the event data, or listen to action specific events defined at runtime.\nAction specific events follow the pattern &#8221;&lt;action&gt;Success&#8221; and\n&#8221;&lt;action&gt;Error&#8221;, e.g. &#8220;indexSuccess&#8221;.</p>","!type":"fn()","placeholdersFromUrl":{"!doc":"<p>Get placeholders from <span class=\"caps\">URL</span>.</p>","!type":"fn(url: string) -> +Array"},"prototype":{"__checkParameters":{"!doc":"<p>Check parameters.</p>","!type":"fn(params: +Map, check: +Map)"},"__configureJsonRequest":{"!doc":"<p>Serialize data to <span class=\"caps\">JSON</span> when content type indicates.</p>","!type":"fn(req: +qx.bom.request.SimpleXhr, config: +Map, data: +Map)"},"__configureRequest":{"!doc":"<p>Configure request.</p>","!type":"fn(req: +qx.bom.request.SimpleXhr, config: +Map, data: +Map)"},"__createRequest":{"!doc":"<p>Create request.</p>","!type":"fn(action: string) -> +qx.bom.request.SimpleXhr"},"__declareEvent":{"!doc":"<p>Declare event at runtime.</p>","!type":"fn(type: string)"},"__mapFromDescription":{"!doc":"<p>Map actions from description.</p>\n\n<p>Allows to decoratively define routes.</p>","!type":"fn(description: +Map)"},"_getRequest":{"!doc":"<p>Get request.</p>\n\n<p>May be overriden to change type of request.</p>","!type":"fn() -> +qx.bom.request.SimpleXhr"},"_getRequestConfig":{"!doc":"<p>Get request configuration for action and parameters.</p>\n\n<p>This is were placeholders are replaced with parameters.</p>","!type":"fn(action: string, params: +Map) -> +Map"},"_getRequestHandler":{"!doc":"<p>Provides the request callbacks for &#8216;onsuccess&#8217;, &#8216;onfail&#8217; and &#8216;onloadend&#8217;.</p>","!type":"fn() -> +Map"},"_getThrottleCount":{"!doc":"<p>Override to adjust the throttle count.</p>","!type":"fn() -> +Integer"},"_getThrottleLimit":{"!doc":"<p>Override to adjust the throttle limit.</p>","!type":"fn() -> +Integer"},"_startPoll":{"!doc":"<p>Start a poll process.</p>","!type":"fn(action: string, listener: fn(), interval: number)"},"abort":{"!doc":"<p>Abort action.</p>\n\n<p>Example:</p>\n\n<pre class=\"javascript\">\n  // Abort all invocations of action\n  res.get({id: 1});\n  res.get({id: 2});\n  res.abort(\"get\");\n\n  // Abort specific invocation of action (by id)\n  var actionId = res.get({id: 1});\n  res.abort(actionId);\n</pre>","!type":"fn(varargs: string)"},"configureRequest":{"!doc":"<p>Configure request.</p>","!type":"fn(callback: fn())"},"destruct":{"!doc":"<p>Desctructs the Resource.</p>\n\n<p>All created requests, routes and pollTimers will be disposed.</p>","!type":"fn()"},"dispose":{"!doc":"<p>Dispose this object</p>","!type":"fn()"},"getRequestsByAction":{"!doc":"<p>Retrieve the currently stored request objects for an action.</p>","!type":"fn(action: string) -> +Array"},"invoke":{"!doc":"<p>Invoke action with parameters.</p>\n\n<p>Internally called by actions dynamically created.</p>\n\n<p>May be overriden to customize action and parameter handling.</p>","!type":"fn(action: string, params: +Map, data: +Map) -> number"},"isDisposed":{"!doc":"<p>Returns true if the object is disposed.</p>","!type":"fn() -> bool"},"longPoll":{"!doc":"<p>Long-poll action.</p>\n\n<p>Use Ajax long-polling to continously fetch a resource as soon as the\nserver signals new data. The server determines when new data is available,\nwhile the client keeps open a request. Requires configuration on the\nserver side. Basically, the server must not close a connection until\nnew data is available. For a high level introduction to long-polling,\nrefer to <a href=\"http://en.wikipedia.org/wiki/Comet_(programming)#Ajax_with_long_polling\">\nAjax with long polling</a>.</p>\n\n<p>Uses {@link #refresh} internally. Make sure you understand the\nimplications of IE&#8217;s tendency to cache overly agressive.</p>\n\n<p>Note no interval is given on the client side.</p>","!type":"fn(action: string) -> string"},"map":{"!doc":"<p>Map action to combination of method and <span class=\"caps\">URL</span> pattern.</p>\n\n<pre class=\"javascript\">\n  res.map(\"get\", \"GET\", \"/photos/{id}\", {id: /\\d+/});\n\n  // GET /photos/123\n  res.get({id: \"123\"});\n</pre>","!type":"fn(action: string, method: string, url: string, check?: +Map)"},"poll":{"!doc":"<p>Periodically invoke action.</p>\n\n<p>Replays parameters given when action was invoked originally. When the\naction was not yet invoked and requires parameters, parameters must be\ngiven.</p>\n\n<p>Please note that IE tends to cache overly agressive. One work-around is\nto disable caching on the client side by configuring the request with\n<code>setCache(false)</code>. If you control the server, a better\nwork-around is to include appropriate headers to explicitly control\ncaching. This way you still avoid requests that can be correctly answered\nfrom cache (e.g. when nothing has changed since the last poll). Please\nrefer to <a href=\"http://www.mnot.net/javascript/xmlhttprequest/cache.html\">\nXMLHttpRequest Caching Test</a> for available options.</p>","!type":"fn(action: string, interval: number, params?: +Map, immediately?: bool)"},"refresh":{"!doc":"<p>Resend request associated to action.</p>\n\n<p>Replays parameters given when action was invoked originally.</p>","!type":"fn(action: string)"},"restartPollByAction":{"!doc":"<p>Restarts a poll process by the associated action.</p>","!type":"fn(action: string)"},"setBaseUrl":{"!doc":"<p>Set base <span class=\"caps\">URL</span>.</p>\n\n<p>The base <span class=\"caps\">URL</span> is prepended to the URLs given in the description.\nChanges affect all future invocations.</p>","!type":"fn(baseUrl: string)"},"setRequestFactory":{"!doc":"<p>Set a request factory function to switch the request implementation.\nThe created requests have to implement {@link qx.io.request.AbstractRequest}.</p>","!type":"fn(fn: fn())"},"setRequestHandler":{"!doc":"<p>Sets request callbacks for &#8216;onsuccess&#8217;, &#8216;onfail&#8217; and &#8216;onloadend&#8217;.</p>","!type":"fn(handler: +Map)"},"stopPollByAction":{"!doc":"<p>Stops a poll process by the associated action.</p>","!type":"fn(action: string)"}}}},"Selection":{"!doc":"<p>Low-level selection <span class=\"caps\">API</span> to select elements like input and textarea elements\nas well as text nodes or elements which their child nodes.</p>","__isInputOrTextarea":{"!doc":"<p>Utility method to check for an input or textarea element</p>","!type":"fn(node: +Node) -> bool"},"get":{"!doc":"<p>Returns the current selected text.</p>","!type":"fn(node: +Node) -> string"},"getEnd":{"!doc":"<p>Returns the end of the selection</p>","!type":"fn(node: +Node) -> +Integer"},"getLength":{"!doc":"<p>Returns the length of the selection</p>","!type":"fn(node: +Node) -> +Integer"},"getSelectionObject":{"!doc":"<p>Returns the native selection object.</p>","!type":"fn(documentNode: +document) -> +Selection"},"getStart":{"!doc":"<p>Returns the start of the selection</p>","!type":"fn(node: +Node) -> +Integer"},"set":{"!doc":"<p>Sets a selection at the given node with the given start and end.\nFor text nodes, input and textarea elements the start and end parameters\nset the boundaries at the text.\nFor element nodes the start and end parameters are used to select the\nchildNodes of the given element.</p>","!type":"fn(node: +Node, start: +Integer, end: +Integer) -> bool"},"setAll":{"!doc":"<p>Selects all content/childNodes of the given node</p>","!type":"fn(node: +Node) -> bool"}},"Selector":{"!doc":"<p>The selector engine supports virtually all <span class=\"caps\">CSS</span> 3 Selectors  &#8211; this even\nincludes some parts that are infrequently implemented such as escaped\nselectors (<code>.foo\\\\+bar</code>), Unicode selectors, and results returned\nin document order. There are a few notable exceptions to the <span class=\"caps\">CSS</span> 3 selector\nsupport:</p>\n\n<ul>\n<li><code>:root</code></li>\n<li><code>:target</code></li>\n<li><code>:nth-last-child</code></li>\n<li><code>:nth-of-type</code></li>\n<li><code>:nth-last-of-type</code></li>\n<li><code>:first-of-type</code></li>\n<li><code>:last-of-type</code></li>\n<li><code>:only-of-type</code></li>\n<li><code>:lang()</code></li>\n</ul>\n\n<p>In addition to the <span class=\"caps\">CSS</span> 3 Selectors the engine supports the following\nadditional selectors or conventions.</p>\n\n<p><strong>Changes</strong></p>\n\n<ul>\n<li><code>:not(a.b)</code>: Supports non-simple selectors in <code>:not()</code> (most browsers only support <code>:not(a)</code>, for example).</li>\n<li><code>:not(div > p)</code>: Supports full selectors in <code>:not()</code>.</li>\n<li><code>:not(div, p)</code>: Supports multiple selectors in <code>:not()</code>.</li>\n<li><code>[NAME=VALUE]</code>: Doesn&#8217;t require quotes around the specified value in an attribute selector.</li>\n</ul>\n\n<p><strong>Additions</strong></p>\n\n<ul>\n<li><code>[NAME!=VALUE]</code>: Finds all elements whose <code><span class=\"caps\">NAME</span></code> attribute doesn&#8217;t match the specified value. Is equivalent to doing <code>:not([NAME=VALUE])</code>.</li>\n<li><code>:contains(TEXT)</code>: Finds all elements whose textual context contains the word <code><span class=\"caps\">TEXT</span></code> (case sensitive).</li>\n<li><code>:header</code>: Finds all elements that are a header element (h1, h2, h3, h4, h5, h6).</li>\n<li><code>:parent</code>: Finds all elements that contains another element.</li>\n</ul>\n\n<p><strong>Positional Selector Additions</strong></p>\n\n<ul>\n<li><code>:first</code>/</code>:last</code>: Finds the first or last matching element on the page. (e.g. <code>div:first</code> would find the first div on the page, in document order)</li>\n<li><code>:even</code>/<code>:odd</code>: Finds every other element on the page (counting begins at 0, so <code>:even</code> would match the first element).</li>\n<li><code>:eq</code>/<code>:nth</code>: Finds the Nth element on the page (e.g. <code>:eq(5)</code> finds the 6th element on the page).</li>\n<li><code>:lt</code>/<code>:gt</code>: Finds all elements at positions less than or greater than the specified positions.</li>\n</ul>\n\n<p><strong>Form Selector Additions</strong></p>\n\n<ul>\n<li><code>:input</code>: Finds all input elements (includes textareas, selects, and buttons).</li>\n<li><code>:text</code>, <code>:checkbox</code>, <code>:file</code>, <code>:password</code>, <code>:submit</code>, <code>:image</code>, <code>:reset</code>, <code>:button</code>: Finds the input element with the specified input type (<code>:button</code> also finds button elements).</li>\n</ul>\n\n<p>Based on Sizzle by John Resig, see:</p>\n\n<ul>\n<li><a href=\"http://sizzlejs.com/\">http://sizzlejs.com/</a></li>\n</ul>\n\n<p>For further usage details also have a look at the wiki page at:</p>\n\n<ul>\n<li><a href=\"https://github.com/jquery/sizzle/wiki/Sizzle-Home\">https://github.com/jquery/sizzle/wiki/Sizzle-Home</a></li>\n</ul>","matches":{"!doc":"<p>Returns an reduced array which only contains the elements from the given\narray which matches the given selector</p>","!type":"fn(selector: string, set: +Array) -> +Array"},"query":{"!doc":"<p>Queries the document for the given selector. Supports all CSS3 selectors\nplus some extensions as mentioned in the class description.</p>","!type":"fn(selector: string, context: +Element) -> +Array"}},"Shortcut":{"!proto":"qx.core.Object","!doc":"<p>Shortcuts can be used to globally define keyboard shortcuts.</p>","!type":"fn()","prototype":{"__matchesKeyEvent":{"!doc":"<p>Checks whether the given key event matches the shortcut&#8217;s shortcut</p>","!type":"fn(e: +qx.event.type.KeySequence) -> bool"},"__normalizeKeyIdentifier":{"!doc":"<p>Checks and normalizes the key identifier.</p>","!type":"fn(keyName: string) -> string"},"__onKeyDown":{"!doc":"<p>Key down event handler.</p>","!type":"fn(event: +qx.event.type.KeySequence)"},"__onKeyPress":{"!doc":"<p>Key press event handler.</p>","!type":"fn(event: +qx.event.type.KeySequence)"},"_applyEnabled":{"!doc":"<p>Applies changes of the property value of the property <code>enabled</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #enabled}.</p>","!type":"fn(value: bool, old: bool)"},"_applyShortcut":{"!doc":"<p>Applies changes of the property value of the property <code>shortcut</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #shortcut}.</p>","!type":"fn(value: string, old: string)"},"execute":{"!doc":"<p>Fire the &#8220;execute&#8221; event on this shortcut.</p>","!type":"fn(target: Object)"},"getAutoRepeat":{"!doc":"<p>Returns the (computed) value of the property <code>autoRepeat</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #autoRepeat}.</p>","!type":"fn() -> Object"},"getEnabled":{"!doc":"<p>Returns the (computed) value of the property <code>enabled</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #enabled}.</p>","!type":"fn() -> Object"},"getShortcut":{"!doc":"<p>Returns the (computed) value of the property <code>shortcut</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #shortcut}.</p>","!type":"fn() -> Object"},"initAutoRepeat":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>autoRepeat</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #autoRepeat}.</p>","!type":"fn(value: Object) -> Object"},"initEnabled":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>enabled</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #enabled}.</p>","!type":"fn(value: Object) -> Object"},"initShortcut":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>shortcut</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #shortcut}.</p>","!type":"fn(value: Object) -> Object"},"isAutoRepeat":{"!doc":"<p>Check whether the (computed) value of the boolean property <code>autoRepeat</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #autoRepeat}.</p>","!type":"fn() -> bool"},"isEnabled":{"!doc":"<p>Check whether the (computed) value of the boolean property <code>enabled</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #enabled}.</p>","!type":"fn() -> bool"},"resetAutoRepeat":{"!doc":"<p>Resets the user value of the property <code>autoRepeat</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #autoRepeat}.</p>","!type":"fn()"},"resetEnabled":{"!doc":"<p>Resets the user value of the property <code>enabled</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #enabled}.</p>","!type":"fn()"},"resetShortcut":{"!doc":"<p>Resets the user value of the property <code>shortcut</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #shortcut}.</p>","!type":"fn()"},"setAutoRepeat":{"!doc":"<p>Sets the user value of the property <code>autoRepeat</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #autoRepeat}.</p>","!type":"fn(value: Object) -> Object"},"setEnabled":{"!doc":"<p>Sets the user value of the property <code>enabled</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #enabled}.</p>","!type":"fn(value: Object) -> Object"},"setShortcut":{"!doc":"<p>Sets the user value of the property <code>shortcut</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #shortcut}.</p>","!type":"fn(value: Object) -> Object"},"toggleAutoRepeat":{"!doc":"<p>Toggles the (computed) value of the boolean property <code>autoRepeat</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #autoRepeat}.</p>","!type":"fn() -> bool"},"toggleEnabled":{"!doc":"<p>Toggles the (computed) value of the boolean property <code>enabled</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #enabled}.</p>","!type":"fn() -> bool"},"toString":{"!doc":"<p>Returns the shortcut as string using the currently selected locale.</p>","!type":"fn() -> string"}}},"Storage":{"!doc":"<p>This is a cross browser storage implementation. The <span class=\"caps\">API</span> is aligned with the\n<span class=\"caps\">API</span> of the <span class=\"caps\">HTML</span> web storage (<a href=\"http://www.w3.org/TR/webstorage/\">http://www.w3.org/TR/webstorage/</a>) which is also\nthe preferred implementation used. As fallback for IE < 8, we use user data.\nIf both techniques are unsupported, we supply a in memory storage, which is\nof course, not persistent.</p>","getLocal":{"!doc":"<p>Get an instance of a local storage.</p>","!type":"fn() -> +qx.bom.storage.Web"},"getSession":{"!doc":"<p>Get an instance of a session storage.</p>","!type":"fn() -> +qx.bom.storage.Web"}},"storage":{"Memory":{"!doc":"<p>Fallback storage implementation which offers the same <span class=\"caps\">API</span> as every other storage\nbut is not persistent. Basically, its just a storage <span class=\"caps\">API</span> on a JavaScript map.</p>","getLocal":{"!doc":"<p>Returns an instance of {@link qx.bom.storage.Memory} which is of course\nnot persisted on reload.</p>","!type":"fn() -> +qx.bom.storage.Memory"},"getSession":{"!doc":"<p>Returns an instance of {@link qx.bom.storage.Memory} which is of course\nnot persisted on reload.</p>","!type":"fn() -> +qx.bom.storage.Memory"},"!type":"fn()","prototype":{"clear":{"!doc":"<p>Deletes every stored item in the storage.</p>","!type":"fn()"},"forEach":{"!doc":"<p>Helper to access every stored item.</p>","!type":"fn(callback: fn(), scope: Object)"},"getItem":{"!doc":"<p>Returns the stored item.</p>","!type":"fn(key: string) -> Object"},"getKey":{"!doc":"<p>Returns the named key at the given index.</p>","!type":"fn(index: +Integer) -> string"},"getLength":{"!doc":"<p>Returns the amount of key-value pairs stored.</p>","!type":"fn() -> +Integer"},"getStorage":{"!doc":"<p>Returns the internal used map.</p>","!type":"fn() -> +Map"},"removeItem":{"!doc":"<p>Removes an item form the storage.</p>","!type":"fn(key: string)"},"setItem":{"!doc":"<p>Store an item in the storage.</p>","!type":"fn(key: string, value: Object)"}}},"UserData":{"!doc":"<p>Fallback storage implementation usable in IE browsers. It is recommended to use\nthese implementation only in IE < 8 because IE >= 8 supports\n{@link qx.bom.storage.Web}.</p>","getLocal":{"!doc":"<p>Returns an instance of {@link qx.bom.storage.UserData} used to store\ndata persistent.</p>","!type":"fn() -> +qx.bom.storage.UserData"},"getSession":{"!doc":"<p>Returns an instance of {@link qx.bom.storage.UserData} used to store\ndata persistent.</p>","!type":"fn() -> +qx.bom.storage.UserData"},"!type":"fn()","prototype":{"clear":{"!doc":"<p>Deletes every stored item in the storage.</p>","!type":"fn()"},"forEach":{"!doc":"<p>Helper to access every stored item.</p>","!type":"fn(callback: fn(), scope: Object)"},"getItem":{"!doc":"<p>Returns the stored item.</p>","!type":"fn(key: string) -> Object"},"getKey":{"!doc":"<p>Returns the named key at the given index.</p>","!type":"fn(index: +Integer) -> string"},"getLength":{"!doc":"<p>Returns the amount of key-value pairs stored.</p>","!type":"fn() -> +Integer"},"getStorage":{"!doc":"<p>Returns the map used to keep a in memory copy of the stored data.</p>","!type":"fn() -> +Map"},"removeItem":{"!doc":"<p>Removes an item form the storage.</p>","!type":"fn(key: string)"},"setItem":{"!doc":"<p>Store an item in the storage.</p>","!type":"fn(key: string, value: Object)"}}},"Web":{"!doc":"<p>Storage implementation using <span class=\"caps\">HTML</span> web storage:\n<a href=\"http://www.w3.org/TR/webstorage/\">http://www.w3.org/TR/webstorage/</a></p>","getLocal":{"!doc":"<p>Static accessor for the local storage.</p>","!type":"fn() -> +qx.bom.storage.Web"},"getSession":{"!doc":"<p>Static accessor for the session storage.</p>","!type":"fn() -> +qx.bom.storage.Web"},"!type":"fn()","prototype":{"clear":{"!doc":"<p>Deletes every stored item in the storage.</p>","!type":"fn()"},"forEach":{"!doc":"<p>Helper to access every stored item.</p>","!type":"fn(callback: fn(), scope: Object)"},"getItem":{"!doc":"<p>Returns the stored item.</p>","!type":"fn(key: string) -> Object"},"getKey":{"!doc":"<p>Returns the named key at the given index.</p>","!type":"fn(index: +Integer) -> string"},"getLength":{"!doc":"<p>Returns the amount of key-value pairs stored.</p>","!type":"fn() -> +Integer"},"getStorage":{"!doc":"<p>Returns the internal used storage (the native object).</p>","!type":"fn() -> +Storage"},"removeItem":{"!doc":"<p>Removes an item form the storage.</p>","!type":"fn(key: string)"},"setItem":{"!doc":"<p>Store an item in the storage.</p>","!type":"fn(key: string, value: Object)"}}}},"String":{"!doc":"<p>A Collection of utility functions to escape and unescape strings.</p>","escape":{"!doc":"<p>Escapes the characters in a <code>String</code> using <span class=\"caps\">HTML</span> entities.</p>\n\n<p>For example: <tt>&#8220;bread&#8221; &amp; &#8220;butter&#8221;</tt> => <tt>&amp;quot;bread&amp;quot; &amp;amp; &amp;quot;butter&amp;quot;</tt>.\nSupports all known <span class=\"caps\">HTML</span> 4.0 entities, including funky accents.</p>\n\n<ul>\n<li><a href=\"http://www.w3.org/TR/REC-html32#latin1\"><span class=\"caps\">HTML</span> 3.2 Character Entities for <span class=\"caps\">ISO</span> Latin-1</a></li>\n<li><a href=\"http://www.w3.org/TR/REC-html40/sgml/entities.html\"><span class=\"caps\">HTML</span> 4.0 Character entity references</a></li>\n<li><a href=\"http://www.w3.org/TR/html401/charset.html#h-5.3\"><span class=\"caps\">HTML</span> 4.01 Character References</a></li>\n<li><a href=\"http://www.w3.org/TR/html401/charset.html#code-position\"><span class=\"caps\">HTML</span> 4.01 Code positions</a></li>\n</ul>","!type":"fn(str: string) -> string"},"fromText":{"!doc":"<p>Converts a plain text string into <span class=\"caps\">HTML</span>.\nThis is similar to {@link #escape} but converts new lines to\n<tt>&amp;lt:br&amp;gt:</tt> and preserves whitespaces.</p>","!type":"fn(str: string) -> string"},"toText":{"!doc":"<p>Converts <span class=\"caps\">HTML</span> to plain text.</p>\n\n<ul>\n<li>Strips all <span class=\"caps\">HTML</span> tags</li>\n<li>converts <tt>&amp;lt:br&amp;gt:</tt> to new line</li>\n<li>unescapes <span class=\"caps\">HTML</span> entities</li>\n</ul>","!type":"fn(str: string) -> string"},"unescape":{"!doc":"<p>Unescapes a string containing entity escapes to a string\ncontaining the actual Unicode characters corresponding to the\nescapes. Supports <span class=\"caps\">HTML</span> 4.0 entities.</p>\n\n<p>For example, the string &#8221;&amp;lt;Fran&amp;ccedil;ais&amp;gt;&#8221;\nwill become &#8221;&lt;Fran&ccedil;ais&gt;&#8221;</p>\n\n<p>If an entity is unrecognized, it is left alone, and inserted\nverbatim into the result string. e.g. &#8221;&amp;gt;&amp;zzzz;x&#8221; will\nbecome &#8221;&gt;&amp;zzzz;x&#8221;.</p>","!type":"fn(str: string) -> Object"}},"Style":{"!doc":"<p>Responsible class for everything concerning styles without the need of\nan element.</p>\n\n<p>If you want to query or modify styles of <span class=\"caps\">HTML</span> elements,\ntake a look at {@link qx.bom.element.Style}.</p>","getAppliedStyle":{"!doc":"<p>Detects <span class=\"caps\">CSS</span> support by using the native <span class=\"caps\">CSS</span>.supports function or by\napplying a style to a <span class=\"caps\">DOM</span> element of the given type and verifying\nthe result. Also checks for vendor-prefixed variants of the\nvalue, e.g. &#8220;linear-gradient&#8221; -> &#8221;-webkit-linear-gradient&#8221;. Returns the\n(possibly vendor-prefixed) value if successful or <code>null</code> if\nthe property and/or value are not supported.</p>","!type":"fn(element: +Element, propertyName: string, value: string, prefixed?: bool) -> string"},"getCssName":{"!doc":"<p>Takes the name of a JavaScript style property and returns the\ncorresponding <span class=\"caps\">CSS</span> name.</p>\n\n<p>The name of the style property is taken as is, i.e. it gets not\nextended by vendor prefixes. The conversion into the <span class=\"caps\">CSS</span> name is\ndone by string manipulation, not involving the <span class=\"caps\">DOM</span>.</p>\n\n<p>Example:</p>\n\n<pre class=\"javascript\">qx.bom.Style.getCssName(\"MozTransform\"); //returns \"-moz-transform\"</pre>","!type":"fn(propertyName: string) -> string"},"getPropertyName":{"!doc":"<p>Takes the name of a style property and returns the name the browser uses\nfor its implementation, which might include a vendor prefix.</p>","!type":"fn(propertyName: string) -> string"}},"Stylesheet":{"!doc":"<p>Cross-browser wrapper to work with <span class=\"caps\">CSS</span> stylesheets.</p>","addImport":{"!doc":"<p>Add an import of an external <span class=\"caps\">CSS</span> file to a stylesheet</p>","!type":"fn(sheet: Object, url: string)"},"addRule":{"!doc":"<p>Insert a new <span class=\"caps\">CSS</span> rule into a given Stylesheet</p>","!type":"fn(sheet: Object, selector: string, entry: string)"},"createElement":{"!doc":"<p>Create a new Stylesheet node and append it to the document</p>","!type":"fn(text?: string) -> +Stylesheet"},"includeFile":{"!doc":"<p>Include a <span class=\"caps\">CSS</span> file</p>\n\n<em>Note:</em> Using a resource ID as the <code>href</code> parameter\nwill no longer be supported. Call\n<code>qx.util.ResourceManager.getInstance().toUri(href)</code> to get\nvalid URI to be used with this method.","!type":"fn(href: string, doc?: +Document)"},"removeAllImports":{"!doc":"<p>Remove all imports from a stylesheet</p>","!type":"fn(sheet: Object)"},"removeAllRules":{"!doc":"<p>Remove all <span class=\"caps\">CSS</span> rules from a stylesheet</p>","!type":"fn(sheet: Object)"},"removeImport":{"!doc":"<p>Removes an import from a stylesheet</p>","!type":"fn(sheet: Object, url: string)"},"removeRule":{"!doc":"<p>Remove a <span class=\"caps\">CSS</span> rule from a stylesheet</p>","!type":"fn(sheet: Object, selector: string)"},"removeSheet":{"!doc":"<p>Remove the given sheet from its owner.</p>","!type":"fn(sheet: Object)"}},"Template":{"!doc":"<p>The is a template class which can be used for <span class=\"caps\">HTML</span> templating. In fact,\nthis is a wrapper for mustache.js which is a &#8220;framework-agnostic way to\nrender logic-free views&#8221;.</p>\n\n<p>Here is a basic example how to use it:\nTemplate:</p>\n\n<pre class=\"javascript\">\nvar template = \"Hi, my name is {{name}}!\";\nvar view = {name: \"qooxdoo\"};\nqx.bom.Template.render(template, view);\n// return \"Hi, my name is qooxdoo!\"\n</pre>\n\n<p>For further details, please visit the mustache.js documentation here:\n  <a href=\"https://github.com/janl/mustache.js/blob/master/README.md\">https://github.com/janl/mustache.js/blob/master/README.md</a></p>","_createNodeFromTemplate":{"!doc":"<p>Accepts a parsed template and returns a (potentially nested) node.</p>","!type":"fn(template: string) -> +Element"},"get":{"!doc":"<p>Helper method which provides you with a direct access to templates\nstored as <span class=\"caps\">HTML</span> in the <span class=\"caps\">DOM</span>. The <span class=\"caps\">DOM</span> node with the given ID will be used\nas a template, parsed and a new <span class=\"caps\">DOM</span> node will be returned containing the\nparsed data. Keep in mind to have only one root <span class=\"caps\">DOM</span> element in the the\ntemplate.\nAdditionally, you should not put the template into a regular, hidden\n<span class=\"caps\">DOM</span> element because the template may not be valid <span class=\"caps\">HTML</span> due to the containing\nmustache tags. We suggest to put it into a script tag with the type\n<code>text/template</code>.</p>","!type":"fn(id: string, view: Object, partials: Object) -> +Element"},"render":{"!doc":"<p>Original and only template method of mustache.js. For further\ndocumentation, please visit <a href=\"https://github.com/janl/mustache.js\">https://github.com/janl/mustache.js</a></p>","!type":"fn(template: string, view: Object, partials: Object) -> string"},"renderToNode":{"!doc":"<p>Combines {@link #render} and {@link #get}. Input is equal to {@link #render}\nand output is equal to {@link #get}. The advantage over {@link #get}\nis that you don&#8217;t need a <span class=\"caps\">HTML</span> template but can use a template\nstring and still get a <span class=\"caps\">DOM</span> element. Keep in mind that templates\ncan only have one root element.</p>","!type":"fn(template: string, view: Object, partials: Object) -> +Element"}},"Viewport":{"!doc":"<p>Includes library functions to work with the client&#8217;s viewport (window).\nOrientation related functions are point to window.top as default.</p>","__getOrientationNormalizer":{"!doc":"<p>Returns an orientation normalizer value that should be added to device orientation\nto normalize behaviour on different devices.</p>","!type":"fn(win: +Window) -> +Map"},"getHeight":{"!doc":"<p>Returns the current height of the viewport (excluding the horizontal scrollbar\nif present).</p>","!type":"fn(win?: +Window) -> +Integer"},"getOrientation":{"!doc":"<p>Returns the current orientation of the viewport in degree.</p>\n\n<p>All possible values and their meaning:</p>\n\n<ul>\n<li><code>-90</code>: &#8220;Landscape&#8221;</li>\n<li><code>0</code>: &#8220;Portrait&#8221;</li>\n<li><code>90</code>: &#8220;Landscape&#8221;</li>\n<li><code>180</code>: &#8220;Portrait&#8221;</li>\n</ul>","!type":"fn(win?: +Window) -> +Integer"},"getScrollLeft":{"!doc":"<p>Returns the scroll position of the viewport</p>\n\n<p>All clients except IE < 9 support the non-standard property <code>pageXOffset</code>.\nAs this is easier to evaluate we prefer this property over <code>scrollLeft</code>.\nSince the window could differ from the one the application is running in, we can&#8217;t\nuse a one-time environment check to decide which property to use.</p>","!type":"fn(win?: +Window) -> +Integer"},"getScrollTop":{"!doc":"<p>Returns the scroll position of the viewport</p>\n\n<p>All clients except <span class=\"caps\">MSHTML</span> support the non-standard property <code>pageYOffset</code>.\nAs this is easier to evaluate we prefer this property over <code>scrollTop</code>.\nSince the window could differ from the one the application is running in, we can&#8217;t\nuse a one-time environment check to decide which property to use.</p>","!type":"fn(win?: +Window) -> +Integer"},"getWidth":{"!doc":"<p>Returns the current width of the viewport (excluding the vertical scrollbar\nif present).</p>","!type":"fn(win?: +Window) -> +Integer"},"isLandscape":{"!doc":"<p>Whether the viewport orientation is currently in landscape mode.</p>","!type":"fn(win?: +Window) -> bool"},"isPortrait":{"!doc":"<p>Whether the viewport orientation is currently in portrait mode.</p>","!type":"fn(win?: +Window) -> bool"}},"Vml":{"!doc":"<p>Helper class to work with <span class=\"caps\">VML</span> . If this class is used, it initialized <span class=\"caps\">VML</span>\nsupport.</p>\n\n<em>Note: This class is only available in Internet Explorer!</em>","create":{"!doc":"<p>Create <span class=\"caps\">VML</span> element</p>","!type":"fn(type: string, attributes?: +Map, win?: Object) -> +Element"},"createImage":{"!doc":"<p>Creates an <span class=\"caps\">VML</span> image and configures it. The image is always tiled.</p>","!type":"fn(source?: string, width?: +Integer, height?: +Integer, xOffset?: +Integer, yOffset?: +Integer, imageWidth?: +Integer, imageHeight?: +Integer) -> +Element"},"updateImage":{"!doc":"<p>Sets the image source and configures the image. The image element size\nresized to the given size and the image is always tiled.</p>","!type":"fn(image: +Element, source: string, width: +Integer, height: +Integer, xOffset?: +Integer, yOffset?: +Integer, imageWidth?: +Integer, imageHeight?: +Integer)"}},"webfonts":{"Manager":{"!proto":"qx.core.Object","!doc":"<p>Manages font-face definitions, making sure that each rule is only applied\nonce.</p>","!type":"fn()","prototype":{"__addRule":{"!doc":"<p>Adds a font-face rule to the document</p>","!type":"fn(rule: string)"},"__fixCssText":{"!doc":"<p>IE 6 and 7 omit the trailing quote after the format name when\nquerying cssText. This needs to be fixed before cssText is replaced\nor all rules will be invalid and no web fonts will work any more.</p>","!type":"fn(cssText: string) -> string"},"__flushQueue":{"!doc":"<p>Processes the next item in the queue</p>","!type":"fn()"},"__getRule":{"!doc":"<p>Assembles the body of a font-face rule for a single webFont.</p>","!type":"fn(familyName: string, sourcesMap: +Map) -> string"},"__getSourceForFormat":{"!doc":"<p>Returns the full src value for a given font <span class=\"caps\">URL</span> depending on the type</p>","!type":"fn(format: string, url: string) -> string"},"__getSourcesMap":{"!doc":"<p>Uses a naive regExp match to determine the format of each defined source\nfile for a webFont. Returns a map with the format names as keys and the\ncorresponding source URLs as values.</p>","!type":"fn(sources: string) -> +Map"},"__onFontChangeStatus":{"!doc":"<p>Removes the font-face declaration if a font could not be validated</p>","!type":"fn(ev: +qx.event.type.Data)"},"__removeRule":{"!doc":"<p>Removes the font-face declaration for the given font-family from the\nstylesheet</p>","!type":"fn(familyName: string)"},"__require":{"!doc":"<p>Does the actual work of adding stylesheet rules and triggering font\nvalidation</p>","!type":"fn(familyName: string, sources: string, callback?: fn(), context?: Object)"},"getPreferredFormats":{"!doc":"<p>Returns the preferred font format(s) for the currently used browser. Some\nbrowsers support multiple formats, e.g. <span class=\"caps\">WOFF</span> and <span class=\"caps\">TTF</span> or <span class=\"caps\">WOFF</span> and <span class=\"caps\">EOT</span>. In\nthose cases, <span class=\"caps\">WOFF</span> is considered the preferred format.</p>","!type":"fn() -> string"},"remove":{"!doc":"<p>Removes a font&#8217;s font-face definition from the style sheet. This means\nthe font will no longer be available and any elements using it will\nfall back to the their regular font-families.</p>","!type":"fn(familyName: string)"},"removeStyleSheet":{"!doc":"<p>Removes the styleSheet element used for all web font definitions from the\ndocument. This means all web fonts declared by the manager will no longer\nbe available and elements using them will fall back to their regular\nfont-families</p>","!type":"fn()"},"require":{"!doc":"<p>Adds the necessary font-face rule for a web font to the document. Also\ncreates a web font Validator ({@link qx.bom.webfonts.Validator}) that\nchecks if the webFont was applied correctly.</p>","!type":"fn(familyName: string, sourcesList: string, callback?: fn(), context?: Object)"}},"getInstance":{"!doc":"<p>Returns a singleton instance of this class. On the first call the class\nis instantiated by calling the constructor with no arguments. All following\ncalls will return this instance.</p>\n\n<p>This method has been added by setting the &#8220;type&#8221; key in the class definition\n({@link qx.Class#define}) to &#8220;singleton&#8221;.</p>","!type":"fn() -> +qx.bom.webfonts.Manager"}},"Validator":{"!proto":"qx.core.Object","!doc":"<p>Checks whether a given font is available on the document and fires events\naccordingly.</p>","!type":"fn()","removeDefaultHelperElements":{"!doc":"<p>Removes the two common helper elements used for all size comparisons from\nthe <span class=\"caps\">DOM</span></p>","!type":"fn()"},"prototype":{"__init":{"!doc":"<p>Creates the default helper elements and gets their widths</p>","!type":"fn()"},"__onTimerInterval":{"!doc":"<p>Triggers helper element size comparison and fires a ({@link #changeStatus})\nevent with the result.</p>","!type":"fn()"},"_applyFontFamily":{"!doc":"<p>Applies changes of the property value of the property <code>fontFamily</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #fontFamily}.</p>","!type":"fn(value: Object, old: Object)"},"_getHelperElement":{"!doc":"<p>Creates a span element with the comparison text ({@link #COMPARISON_STRING})\nand styled with the default <span class=\"caps\">CSS</span> ({@link #HELPER_CSS}) plus the given\nfont-family value and appends it to the <span class=\"caps\">DOM</span></p>","!type":"fn(fontFamily: string) -> +Element"},"_getRequestedHelpers":{"!doc":"<p>Creates the two helper elements styled with the font to be checked</p>","!type":"fn() -> +Map"},"_isFontValid":{"!doc":"<p>Checks if the font is available by comparing the widths of the elements\nusing the generic fonts to the widths of the elements using the font to\nbe validated</p>","!type":"fn() -> bool"},"_reset":{"!doc":"<p>Removes the helper elements from the <span class=\"caps\">DOM</span></p>","!type":"fn()"},"getFontFamily":{"!doc":"<p>Returns the (computed) value of the property <code>fontFamily</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #fontFamily}.</p>","!type":"fn() -> Object"},"getTimeout":{"!doc":"<p>Returns the (computed) value of the property <code>timeout</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #timeout}.</p>","!type":"fn() -> Object"},"initFontFamily":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>fontFamily</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #fontFamily}.</p>","!type":"fn(value: Object) -> Object"},"initTimeout":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>timeout</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #timeout}.</p>","!type":"fn(value: Object) -> Object"},"resetFontFamily":{"!doc":"<p>Resets the user value of the property <code>fontFamily</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #fontFamily}.</p>","!type":"fn()"},"resetTimeout":{"!doc":"<p>Resets the user value of the property <code>timeout</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #timeout}.</p>","!type":"fn()"},"setFontFamily":{"!doc":"<p>Sets the user value of the property <code>fontFamily</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #fontFamily}.</p>","!type":"fn(value: Object) -> Object"},"setTimeout":{"!doc":"<p>Sets the user value of the property <code>timeout</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #timeout}.</p>","!type":"fn(value: Object) -> Object"},"validate":{"!doc":"<p>Validates the font</p>","!type":"fn()"}}},"WebFont":{"!proto":"qx.bom.Font","!doc":"<p>Requests web fonts from {@link qx.bom.webfonts.Manager} and fires events\nwhen their loading status is known.</p>","prototype":{"_applySources":{"!doc":"<p>Applies changes of the property value of the property <code>sources</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #sources}.</p>","!type":"fn(value: Object, old: Object)"},"_onWebFontChangeStatus":{"!doc":"<p>Propagates web font status changes</p>","!type":"fn(ev: +qx.event.type.Data)"},"_quoteFontFamily":{"!doc":"<p>Makes sure font-family names containing spaces are properly quoted</p>","!type":"fn(familyName: string) -> string"},"getSources":{"!doc":"<p>Returns the (computed) value of the property <code>sources</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #sources}.</p>","!type":"fn() -> Object"},"initSources":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>sources</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #sources}.</p>","!type":"fn(value: Object) -> Object"},"resetSources":{"!doc":"<p>Resets the user value of the property <code>sources</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #sources}.</p>","!type":"fn()"},"setSources":{"!doc":"<p>Sets the user value of the property <code>sources</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #sources}.</p>","!type":"fn(value: Object) -> Object"}}}},"WebWorker":{"!proto":"qx.core.Object","!doc":"<p><span class=\"caps\">EXPERIMENTAL</span> &#8211; <span class=\"caps\">NOT</span> <span class=\"caps\">READY</span> <span class=\"caps\">FOR</span> <span class=\"caps\">PRODUCTION</span></p>\n\n<p>Web Workers allows us to run JavaScript in parallel on a web page,\nwithout blocking the user interface. A &#8216;worker&#8217; is just another script\nfile that will be loaded and executed in the background.</p>\n\n<p>For more information see:\n<a href=\"http://www.w3.org/TR/workers/\">http://www.w3.org/TR/workers/</a></p>","!type":"fn()","prototype":{"__initFake":{"!doc":"<p>Initialize the fake worker</p>","!type":"fn(src: string)"},"__initNative":{"!doc":"<p>Initialize the native worker</p>","!type":"fn(src: string)"},"_handleError":{"!doc":"<p>Error handler</p>","!type":"fn(e: +Event)"},"_handleMessage":{"!doc":"<p>Message handler</p>","!type":"fn(e: +Event)"},"postMessage":{"!doc":"<p>Send a message to the worker.</p>","!type":"fn(msg: string)"}}},"Window":{"!doc":"<p>Includes library functions to work with browser windows</p>","__checkForUnblocking":{"!doc":"<p>Interval method which checks if the native window was closed to also\nstop the associated timer.</p>","!type":"fn()"},"__generateConfigurationString":{"!doc":"<p>Returns the given config as string for direct use for the &#8220;window.open&#8221; method</p>","!type":"fn(options: +Array, modality: bool) -> string"},"__isCapableToOpenModalWindows":{"!doc":"<p>Whether the browser can open native modal window.</p>","!type":"fn() -> bool"},"close":{"!doc":"<p>Closes the given window</p>","!type":"fn(win: +Window) -> Object"},"getBlocker":{"!doc":"<p>If a modal window is opened with the option</p>\n\n<pre class=\"javascript\">\nuseNativeModalWindow = false;\n</pre>\n\n<p>an instance of <b>qx.bom.Blocker</b> is used to fake modality. This method\ncan be used to get a reference to the blocker to style it.</p>","!type":"fn() -> +qx.bom.Blocker"},"isClosed":{"!doc":"<p>Checks if the window is closed</p>","!type":"fn(win: +Window) -> bool"},"moveTo":{"!doc":"<p>Moving an opened window is not allowed in the most browsers anymore.</p>","!type":"fn(win: +Window, top: +Integer, left: +Integer)"},"open":{"!doc":"<p>Opens a native window with the given options.</p>\n\n<p>Modal windows can have the following options:</p>\n\n<ul>\n<li>top</li>\n</ul>\n\n<ul>\n<li>left</li>\n</ul>\n\n<ul>\n<li>width</li>\n</ul>\n\n<ul>\n<li>height</li>\n</ul>\n\n<ul>\n<li>scrollbars</li>\n</ul>\n\n<ul>\n<li>resizable</li>\n</ul>\n\n<p>Modeless windows have the following options:</p>\n\n<ul>\n<li>top</li>\n</ul>\n\n<ul>\n<li>left</li>\n</ul>\n\n<ul>\n<li>width</li>\n</ul>\n\n<ul>\n<li>height</li>\n</ul>\n\n<ul>\n<li>dependent</li>\n</ul>\n\n<ul>\n<li>resizable</li>\n</ul>\n\n<ul>\n<li>status</li>\n</ul>\n\n<ul>\n<li>location</li>\n</ul>\n\n<ul>\n<li>menubar</li>\n</ul>\n\n<ul>\n<li>scrollbars</li>\n</ul>\n\n<ul>\n<li>toolbar</li>\n</ul>\n\n<p>Except of dimension and location options all other options are boolean\nvalues.</p>\n\n<p><strong>Important infos for native modal windows</strong></p>\n\n<p>If you want to reference the opened window from within the native modal\nwindow you need to use</p>\n\n<pre class=\"javascript\">\nvar opener = window.dialogArguments[0];\n</pre>\n\n<p>since a reference to the opener is passed automatically to the modal window.</p>\n\n<p><strong>Passing window arguments</strong></p>\n\n<p>This is only working if the page of the modal window is from the same origin.\nThis is at least true for Firefox browsers.</p>","!type":"fn(url: string, name: string, options: +Map, modal: bool, useNativeModalDialog: bool, listener?: fn(), self?: Object) -> +Window"},"resizeTo":{"!doc":"<p>Resizing an opened window is not allowed in the most browsers anymore.</p>","!type":"fn(win: +Window, width: +Integer, height: +Integer)"}}},"Bootstrap":{"!doc":"<p>Internal class that is responsible for bootstrapping the qooxdoo\nframework at load time.</p>","base":{"!doc":"<p>Call the same method of the super class.</p>","!type":"fn(args: +arguments, varargs: Object) -> Object"},"bind":{"!doc":"<p>Returns a function whose &#8220;this&#8221; is altered.</p>\n\n<p><strong>Syntax</strong></p>\n\n<pre class=\"javascript\">qx.Bootstrap.bind(myFunction, [self, [varargs...]]);</pre>\n\n<p><strong>Example</strong></p>\n\n<pre class=\"javascript\">\nfunction myFunction()\n{\n  this.setStyle('color', 'red');\n  // note that 'this' here refers to myFunction, not an element\n  // we'll need to bind this function to the element we want to alter\n};\n\nvar myBoundFunction = qx.Bootstrap.bind(myFunction, myElement);\nmyBoundFunction(); // this will make the element myElement red.\n</pre>","!type":"fn(func: fn(), self?: Object, varargs?: +arguments) -> fn()"},"createNamespace":{"!doc":"<p>Creates a namespace and assigns the given object to it.</p>","!type":"fn(name: string, object: Object) -> string"},"debug":{"!doc":"<p>Sending a message at level &#8220;debug&#8221; to the logger.</p>","!type":"fn(object: Object, message: Object)"},"define":{"!doc":"<p>Define a new class using the qooxdoo class system.\nLightweight version of {@link qx.Class#define} with less features.</p>","!type":"fn(name?: string, config?: +Map) -> +Class"},"error":{"!doc":"<p>Sending a message at level &#8220;error&#8221; to the logger.</p>","!type":"fn(object: Object, message: Object)"},"extendClass":{"!doc":"<p>Inherit a clazz from a super class.</p>\n\n<p>This function differentiates between class and constructor because the\nconstructor written by the user might be wrapped and the <code>base</code>\nproperty has to be attached to the constructor, while the <code>superclass</code>\nproperty has to be attached to the wrapped constructor.</p>","!type":"fn(clazz: fn(), construct: fn(), superClass: fn(), name: fn(), basename: fn())"},"firstLow":{"!doc":"<p>Convert the first character of the string to lower case.</p>","!type":"fn(str: string) -> string"},"firstUp":{"!doc":"<p>Convert the first character of the string to upper case.</p>","!type":"fn(str: string) -> string"},"genericToString":{"!doc":"<p>This method will be attached to all classes to return\na nice identifier for them.</p>","!type":"fn() -> string"},"getByName":{"!doc":"<p>Find a class by its name</p>","!type":"fn(name: string) -> +Class"},"getClass":{"!doc":"<p>Get the internal class of the value. See\n<a href=\"http://perfectionkills.com/instanceof-considered-harmful-or-how-to-write-a-robust-isarray/\">http://perfectionkills.com/instanceof-considered-harmful-or-how-to-write-a-robust-isarray/</a>\nfor details.</p>","!type":"fn(value: Object) -> string"},"getEnvironmentSetting":{"!doc":"<p>Minimal accessor <span class=\"caps\">API</span> for the environment settings given from the\ngenerator.</p>\n\n<p><span class=\"caps\">WARNING</span>: This method only should be used if the\n{@link qx.core.Environment} class is not loaded!</p>","!type":"fn(key: string) -> Object"},"info":{"!doc":"<p>Sending a message at level &#8220;info&#8221; to the logger.</p>","!type":"fn(object: Object, message: Object)"},"isArray":{"!doc":"<p>Whether the value is an array.</p>","!type":"fn(value: Object) -> bool"},"isFunction":{"!doc":"<p>Whether the value is a function.</p>","!type":"fn(value: Object) -> bool"},"isObject":{"!doc":"<p>Whether the value is an object. Note that built-in types like Window are\nnot reported to be objects.</p>","!type":"fn(value: Object) -> bool"},"isString":{"!doc":"<p>Whether the value is a string.</p>","!type":"fn(value: Object) -> bool"},"keys":{"!doc":"<p>Get the keys of a map as array as returned by a &#8220;for&#8230; in&#8221; statement.</p>","!type":"fn(map: Object) -> +Array"},"objectGetLength":{"!doc":"<p>Get the number of own properties in the object.</p>","!type":"fn(map: Object) -> +Integer"},"objectMergeWith":{"!doc":"<p>Inserts all keys of the source object into the\ntarget objects. Attention: The target map gets modified.</p>","!type":"fn(target: Object, source: Object, overwrite?: bool) -> Object"},"setDisplayName":{"!doc":"<p>Sets the display name of the given function</p>","!type":"fn(fcn: fn(), classname: string, name: string)"},"setDisplayNames":{"!doc":"<p>Set the names of all functions defined in the given map</p>","!type":"fn(functionMap: Object, classname: string)"},"setEnvironmentSetting":{"!doc":"<p>Minimal mutator for the environment settings given from the generator.\nIt checks for the existance of the environment settings and sets the\nkey if its not given from the generator. If a setting is available from\nthe generator, the setting will be ignored.</p>\n\n<p><span class=\"caps\">WARNING</span>: This method only should be used if the\n{@link qx.core.Environment} class is not loaded!</p>","!type":"fn(key: string, value: Object)"},"setRoot":{"!doc":"<p>Offers the ability to change the root for creating namespaces from window to\nwhatever object is given.</p>","!type":"fn(root: Object)"},"trace":{"!doc":"<p>Prints the current stack trace at level &#8220;info&#8221;</p>","!type":"fn(object: Object)"},"warn":{"!doc":"<p>Sending a message at level &#8220;warn&#8221; to the logger.</p>","!type":"fn(object: Object, message: Object)"}},"Class":{"!doc":"<p>This class is one of the most important parts of qooxdoo&#8217;s\nobject-oriented features.</p>\n\n<p>Its {@link #define} method is used to create qooxdoo classes.</p>\n\n<p>Each instance of a class defined by {@link #define} has\nthe following keys attached to the constructor and the prototype:</p>\n\n<table>\n<tr><th><code>classname</code></th><td>The fully-qualified name of the class (e.g. <code>\"qx.ui.core.Widget\"</code>).</td></tr>\n<tr><th><code>basename</code></th><td>The namespace part of the class name (e.g. <code>\"qx.ui.core\"</code>).</td></tr>\n<tr><th><code>constructor</code></th><td>A reference to the constructor of the class.</td></tr>\n<tr><th><code>superclass</code></th><td>A reference to the constructor of the super class.</td></tr>\n</table>\n\n<p>Each method may access static members of the same class by using\n<code>this.self(arguments)</code> ({@link qx.core.Object#self}):</p>\n\n<pre class=\"javascript\">\nstatics : { FOO : \"bar\" },\nmembers: {\n  baz: function(x) {\n    this.self(arguments).FOO;\n    ...\n  }\n}\n</pre>\n\n<p>Each overriding method may call the overridden method by using\n<code>this.base(arguments [, ...])</code> ({@link qx.core.Object#base}). This is also true for calling\nthe constructor of the superclass.</p>\n\n<pre class=\"javascript\">\nmembers: {\n  foo: function(x) {\n    this.base(arguments, x);\n    ...\n  }\n}\n</pre>\n\n<p>By using <code>qx.Class</code> within an app, the native JS data types are\nconveniently polyfilled according to {@link qx.lang.normalize}.</p>","__addEvents":{"!doc":"<p>Attach events to the class</p>","!type":"fn(clazz: +Class, events: +Map, patch?: bool)"},"__addInterface":{"!doc":"<p>Add a single interface to a class</p>","!type":"fn(clazz: +Class, iface: +Interface)"},"__addMembers":{"!doc":"<p>Attach members to a class</p>","!type":"fn(clazz: +Class, members: +Map, patch?: bool, base?: bool, wrap?: bool)"},"__addMixin":{"!doc":"<p>Include all features of the mixin into the given class, recursively.</p>","!type":"fn(clazz: +Class, mixin: +Mixin, patch: bool)"},"__addProperties":{"!doc":"<p>Attach properties to classes</p>","!type":"fn(clazz: +Class, properties: +Map, patch?: bool)"},"__createClass":{"!doc":"<p>Creates a class by type. Supports modern inheritance etc.</p>","!type":"fn(name: string, type: string, extend: +Class, statics: +Map, construct: fn(), destruct: fn(), mixins: +Mixin) -> +Class"},"__createDefaultConstructor":{"!doc":"<p>Returns the default constructor.\nThis constructor just calls the constructor of the base class.</p>","!type":"fn() -> fn()"},"__createEmptyFunction":{"!doc":"<p>Returns an empty function. This is needed to get an empty function with an empty closure.</p>","!type":"fn() -> fn()"},"__mixinMemberWrapper":{"!doc":"<p>Wraps a member function of a mixin, which is included using &#8220;patch&#8221;. This\nallows &#8220;base&#8221; calls in the mixin member function.</p>","!type":"fn(member: fn(), base: fn()) -> fn()"},"__needsConstructorWrapper":{"!doc":"<p>Checks if the constructor needs to be wrapped.</p>","!type":"fn(base: +Class, mixins: +Mixin) -> bool"},"__retrospectWrapConstruct":{"!doc":"<p>Wrap the constructor of an already existing clazz. This function will\nreplace all references to the existing constructor with the new wrapped\nconstructor.</p>","!type":"fn(clazz: +Class) -> +Class"},"__validateAbstractInterfaces":{"!doc":"<p>Validates the interfaces required by abstract base classes</p>","!type":"fn(clazz: +Class)"},"__validateConfig":{"!doc":"<p>Validates an incoming configuration and checks for proper keys and values</p>","!type":"fn(name: string, config: +Map)"},"__validateProperty":{"!doc":"<p>Validates the given property</p>","!type":"fn(clazz: +Class, name: string, config: +Map, patch?: bool)"},"__wrapConstructor":{"!doc":"<p>Generate a wrapper of the original class constructor in order to enable\nsome of the advanced OO features (e.g. abstract class, singleton, mixins)</p>","!type":"fn(construct: fn(), name: string, type: string) -> fn()"},"define":{"!doc":"<p>Define a new class using the qooxdoo class system. This sets up the\nnamespace for the class and generates the class from the definition map.</p>\n\n<p>Example:</p>\n\n<pre class=\"javascript\">\nqx.Class.define(\"name\",\n{\n  extend : Object, // superclass\n  implement : [Interfaces],\n  include : [Mixins],\n\n  statics:\n  {\n    CONSTANT : 3.141,\n\n    publicMethod: function() {},\n    _protectedMethod: function() {},\n    __privateMethod: function() {}\n  },\n\n  properties:\n  {\n    \"tabIndex\": { check: \"Number\", init : -1 }\n  },\n\n  members:\n  {\n    publicField: \"foo\",\n    publicMethod: function() {},\n\n    _protectedField: \"bar\",\n    _protectedMethod: function() {},\n\n    __privateField: \"baz\",\n    __privateMethod: function() {}\n  }\n});\n</pre>","!type":"fn(name?: string, config?: +Map) -> +Class"},"genericToString":{"!doc":"<p>This method will be attached to all classes to return\na nice identifier for them.</p>","!type":"fn() -> string"},"getByInterface":{"!doc":"<p>Returns the class or one of its super classes which contains the\ndeclaration of the given interface. Returns null if the interface is not\nspecified anywhere.</p>","!type":"fn(clazz: +Class, iface: +Interface) -> +Class"},"getByMixin":{"!doc":"<p>Returns the class or one of its superclasses which contains the\ndeclaration for the given mixin. Returns null if the mixin is not\nspecified anywhere.</p>","!type":"fn(clazz: +Class, mixin: +Mixin) -> +Class"},"getByName":{"!doc":"<p>Find a class by its name</p>","!type":"fn(name: string) -> +Class"},"getByProperty":{"!doc":"<p>Returns the class or one of its superclasses which contains the\ndeclaration for the given property in its class definition. Returns null\nif the property is not specified anywhere.</p>","!type":"fn(clazz: +Class, name: string) -> +Class"},"getEventType":{"!doc":"<p>Returns the event type of the given event. Returns null if\nthe event does not exist.</p>","!type":"fn(clazz: +Class, name: string) -> string"},"getInstance":{"!doc":"<p>Helper method to handle singletons</p>","!type":"fn() -> Object"},"getInterfaces":{"!doc":"<p>Returns a list of all interfaces a given class has to implement.</p>","!type":"fn(clazz: +Class) -> +Interface"},"getMixins":{"!doc":"<p>Returns a list of all mixins available in a given class.</p>","!type":"fn(clazz: +Class) -> +Mixin"},"getProperties":{"!doc":"<p>Returns a list of all properties supported by the given class</p>","!type":"fn(clazz: +Class) -> string"},"getPropertyDefinition":{"!doc":"<p>Returns the definition of the given property. Returns null\nif the property does not exist.</p>","!type":"fn(clazz: +Class, name: string) -> +Map"},"getTotalNumber":{"!doc":"<p>Determine the total number of classes</p>","!type":"fn() -> number"},"hasInterface":{"!doc":"<p>Whether a given class or any of its super classes includes a given interface.</p>\n\n<p>This function will return &#8220;true&#8221; if the interface was defined\nin the class declaration ({@link qx.Class#define}) of the class\nor any of its super classes using the &#8220;implement&#8221;\nkey.</p>","!type":"fn(clazz: +Class, iface: +Interface) -> bool"},"hasMixin":{"!doc":"<p>Whether a given class or any of its superclasses includes a given mixin.</p>","!type":"fn(clazz: +Class, mixin: +Mixin) -> bool"},"hasOwnInterface":{"!doc":"<p>Whether a given class directly includes an interface.</p>\n\n<p>This function will only return &#8220;true&#8221; if the interface was defined\nin the class declaration ({@link qx.Class#define}) using the &#8220;implement&#8221;\nkey.</p>","!type":"fn(clazz: +Class, iface: +Interface) -> bool"},"hasOwnMixin":{"!doc":"<p>Whether a class directly includes a mixin.</p>","!type":"fn(clazz: +Class, mixin: +Mixin) -> bool"},"hasProperty":{"!doc":"<p>Whether a class has the given property</p>","!type":"fn(clazz: +Class, name: string) -> bool"},"implementsInterface":{"!doc":"<p>Whether a given class complies to an interface.</p>\n\n<p>Checks whether all methods defined in the interface are\nimplemented. The class does not need to implement\nthe interface explicitly in the <code>extend</code> key.</p>","!type":"fn(obj: Object, iface: +Interface) -> bool"},"include":{"!doc":"<p>Include all features of the given mixin into the class. The mixin must\nnot include any methods or properties that are already available in the\nclass. This would only be possible using the {@link #patch} method.</p>","!type":"fn(clazz: +Class, mixin: +Mixin)"},"isDefined":{"!doc":"<p>Whether the given class exists</p>","!type":"fn(name: string) -> bool"},"isSubClassOf":{"!doc":"<p>Whether a class is a direct or indirect sub class of another class,\nor both classes coincide.</p>","!type":"fn(clazz: +Class, superClass: +Class) -> bool"},"patch":{"!doc":"<p>Include all features of the given mixin into the class. The mixin may\ninclude features, which are already defined in the target class. Existing\nfeatures of equal name will be overwritten.\nPlease keep in mind that this functionality is not intended for regular\nuse, but as a formalized way (and a last resort) in order to patch\nexisting classes.</p>\n\n<b>WARNING</b>: You may break working classes and features.","!type":"fn(clazz: +Class, mixin: +Mixin)"},"supportsEvent":{"!doc":"<p>Whether a class supports the given event type</p>","!type":"fn(clazz: +Class, name: string) -> bool"},"undefine":{"!doc":"<p>Removes a class from qooxdoo defined by {@link #define}</p>","!type":"fn(name: string)"}},"core":{"Aspect":{"!doc":"<p>Basis for Aspect Oriented features in qooxdoo.</p>\n\n<p>This class makes it possible to attach functions (aspects) before or\nafter each function call of any function defined in {@link qx.Class#define}.</p>\n\n<p>Classes, which define own aspects must add an explicit require to this class\nin the header comment using the following code:</p>\n\n<pre>\n&#35;require(qx.core.Aspect)\n&#35;ignore(auto-require)\n</pre>\n\n<p>One example for a qooxdoo aspect is profiling ({@link qx.dev.Profile}).</p>","addAdvice":{"!doc":"<p>Register a function to be called just before or after each time\none of the selected functions is called.</p>","!type":"fn(fcn: fn(), position?: string, type?: string, name?: string)"},"wrap":{"!doc":"<p>This function is used by {@link qx.Class#define} to wrap all statics, members and\nconstructors.</p>","!type":"fn(fullName: string, fcn: fn(), type: string) -> fn()"}},"Assert":{"!doc":"<p>A collection of assertions.</p>\n\n<p>These methods can be used to assert incoming parameters, return values, ...\nIf an assertion fails an {@link AssertionError} is thrown.</p>\n\n<p>Assertions are used in unit tests as well.</p>","__fail":{"!doc":"<p>Assert that the condition evaluates to <code>true</code>. An\n{@link AssertionError} is thrown if otherwise.</p>","!type":"fn(comment: string, msgvarargs: Object)"},"__isQxInstance":{"!doc":"<p>Internal helper for checking the instance of a qooxdoo object using the\nclassname.</p>","!type":"fn(object: Object, classname: string) -> bool"},"__toString":{"!doc":"<p>Convert an unknown value to a string to display in error messages</p>","!type":"fn(value: Object) -> string"},"assert":{"!doc":"<p>Assert that the condition evaluates to <code>true</code>.</p>","!type":"fn(condition: Object, msg: string)"},"assertArgumentsCount":{"!doc":"<p>Assert that the number of arguments is within the given range</p>","!type":"fn(args: +arguments, minCount: +Integer, maxCount: +Integer, msg: string)"},"assertArray":{"!doc":"<p>Assert that the value is an array.</p>","!type":"fn(value: Object, msg: string)"},"assertArrayEquals":{"!doc":"<p>Assert that both array have identical array items.</p>","!type":"fn(expected: +Array, found: +Array, msg: string)"},"assertBoolean":{"!doc":"<p>Assert that the value is a boolean.</p>","!type":"fn(value: Object, msg: string)"},"assertCssColor":{"!doc":"<p>Assert that the value represents the given <span class=\"caps\">CSS</span> color value. This method\nparses the color strings and compares the <span class=\"caps\">RGB</span> values. It is able to\nparse values supported by {@link qx.util.ColorUtil#stringToRgb}.</p>","!type":"fn(expected: string, value: string, msg: string)"},"assertElement":{"!doc":"<p>Assert that the value is a <span class=\"caps\">DOM</span> element.</p>","!type":"fn(value: Object, msg: string)"},"assertEquals":{"!doc":"<p>Assert that both values are equal. (Uses the equality operator\n<code>==</code>.)</p>","!type":"fn(expected: Object, found: Object, msg: string)"},"assertEventFired":{"!doc":"<p>Assert that an event is fired.</p>","!type":"fn(obj: Object, event: string, invokeFunc: fn(), listenerFunc?: fn(), msg?: string)"},"assertEventNotFired":{"!doc":"<p>Assert that an event is not fired.</p>","!type":"fn(obj: Object, event: string, invokeFunc: fn(), msg: string)"},"assertException":{"!doc":"<p>Asserts that the callback raises a matching exception.</p>","!type":"fn(callback: fn(), exception?: +Error, re: string, msg: string)"},"assertFalse":{"!doc":"<p>Assert that the value is <code>false</code> (Identity check).</p>","!type":"fn(value: bool, msg: string)"},"assertFunction":{"!doc":"<p>Assert that the value is a function.</p>","!type":"fn(value: Object, msg: string)"},"assertIdentical":{"!doc":"<p>Assert that both values are identical. (Uses the identity operator\n<code>===</code>.)</p>","!type":"fn(expected: Object, found: Object, msg: string)"},"assertInArray":{"!doc":"<p>Assert that the value is an item in the given array.</p>","!type":"fn(value: Object, array: +Array, msg: string)"},"assertInRange":{"!doc":"<p>Assert that the value is inside the given range.</p>","!type":"fn(value: Object, min: number, max: number, msg: string)"},"assertInstance":{"!doc":"<p>Assert that the value is an instance of the given class.</p>","!type":"fn(value: Object, clazz: +Class, msg: string)"},"assertInteger":{"!doc":"<p>Assert that the value is an integer.</p>","!type":"fn(value: Object, msg: string)"},"assertInterface":{"!doc":"<p>Assert that the value implements the given interface.</p>","!type":"fn(value: Object, iface: +Class, msg: string)"},"assertJsonEquals":{"!doc":"<p>Assert that the first two arguments are equal, when serialized into\n<span class=\"caps\">JSON</span>.</p>","!type":"fn(expected: Object, found: Object, msg: string)"},"assertKeyInMap":{"!doc":"<p>Assert that the value is a key in the given map.</p>","!type":"fn(value: Object, map: +Map, msg: string)"},"assertMap":{"!doc":"<p>Assert that the value is a map either created using <code>new Object</code>\nor by using the object literal notation <code>{ ... }</code>.</p>","!type":"fn(value: Object, msg: string)"},"assertMatch":{"!doc":"<p>Assert that the given string matches the regular expression</p>","!type":"fn(str: string, re: string, msg: string)"},"assertNotEquals":{"!doc":"<p>Assert that both values are not equal. (Uses the not equality operator\n<code>!=</code>.)</p>","!type":"fn(expected: Object, found: Object, msg: string)"},"assertNotIdentical":{"!doc":"<p>Assert that both values are not identical. (Uses the not identity operator\n<code>!==</code>.)</p>","!type":"fn(expected: Object, found: Object, msg: string)"},"assertNotNull":{"!doc":"<p>Assert that the value is not <code>null</code>.</p>","!type":"fn(value: Object, msg: string)"},"assertNotUndefined":{"!doc":"<p>Assert that the value is not <code>undefined</code>.</p>","!type":"fn(value: Object, msg: string)"},"assertNull":{"!doc":"<p>Assert that the value is <code>null</code>.</p>","!type":"fn(value: Object, msg: string)"},"assertNumber":{"!doc":"<p>Assert that the value is a number.</p>","!type":"fn(value: Object, msg: string)"},"assertObject":{"!doc":"<p>Assert that the value is an object.</p>","!type":"fn(value: Object, msg: string)"},"assertPositiveInteger":{"!doc":"<p>Assert that the value is an integer >= 0.</p>","!type":"fn(value: Object, msg: string)"},"assertPositiveNumber":{"!doc":"<p>Assert that the value is a number >= 0.</p>","!type":"fn(value: Object, msg: string)"},"assertQxObject":{"!doc":"<p>Assert that the value is an instance of {@link qx.core.Object}.</p>","!type":"fn(value: Object, msg: string)"},"assertQxWidget":{"!doc":"<p>Assert that the value is an instance of {@link qx.ui.core.Widget}.</p>","!type":"fn(value: Object, msg: string)"},"assertRegExp":{"!doc":"<p>Assert that the value is a regular expression.</p>","!type":"fn(value: Object, msg: string)"},"assertString":{"!doc":"<p>Assert that the value is a string.</p>","!type":"fn(value: Object, msg: string)"},"assertTrue":{"!doc":"<p>Assert that the value is <code>true</code> (Identity check).</p>","!type":"fn(value: bool, msg: string)"},"assertType":{"!doc":"<p>Assert that the value has the given type using the <code>typeof</code>\noperator. Because the type is not always what it is supposed to be it is\nbetter to use more explicit checks like {@link #assertString} or\n{@link #assertArray}.</p>","!type":"fn(value: Object, type: string, msg: string)"},"assertUndefined":{"!doc":"<p>Assert that the value is <code>undefined</code>.</p>","!type":"fn(value: Object, msg: string)"},"fail":{"!doc":"<p>Raise an {@link AssertionError}.</p>","!type":"fn(msg: string, compact: bool)"}},"AssertionError":{"!proto":"qx.type.BaseError","!doc":"<p>Assertion errors are thrown if an assertion in {@link qx.core.Assert}\nfails.</p>","!type":"fn()","prototype":{"getStackTrace":{"!doc":"<p>Stack trace of the error</p>","!type":"fn() -> string"}}},"BaseInit":{"!doc":"<p>This is the base class for non-browser qooxdoo applications.</p>","__close":{"!doc":"<p>Runs before the document is unloaded. Calls the application&#8217;s close\nmethod to check if the unload process should be stopped.</p>","!type":"fn(e: +qx.event.type.Native)"},"__shutdown":{"!doc":"<p>Runs when the document is unloaded. Automatically terminates a previously\ncreated application instance.</p>","!type":"fn()"},"getApplication":{"!doc":"<p>Returns the instantiated qooxdoo application.</p>","!type":"fn() -> +qx.core.Object"},"ready":{"!doc":"<p>Runs when the application is loaded. Automatically creates an instance\nof the class defined by the setting <code>qx.application</code>.</p>","!type":"fn()"}},"Environment":{"!doc":"<p>This class is the single point to access all settings that may be different\nin different environments. This contains e.g. the browser name, engine\nversion but also qooxdoo or application specific settings.</p>\n\n<p>Its public <span class=\"caps\">API</span> can be found in its four main methods. One pair of methods\nis used to check the synchronous values of the environment. The other pair\nof methods is used for asynchronous checks.</p>\n\n<p>The most often used method should be {@link #get}, which returns the\ncurrent value for a given environment check.</p>\n\n<p>All qooxdoo settings can be changed via the generator&#8217;s config. See the manual\nfor more details about the environment key in the config. As you can see\nfrom the methods <span class=\"caps\">API</span>, there is no way to override an existing key. So if you\nneed to change a qooxdoo setting, you have to use the generator to do so.</p>\n\n<p>The generator is also responsible for requiring the necessary implementation\nclasses for each check. When using a check of a new category, make sure to\nrebuild you application and let the generator include the necessary files.</p>\n\n<p>The following table shows the available checks. If you are\ninterested in more details, check the reference to the implementation of\neach check. Please do not use those check implementations directly, as the\nEnvironment class comes with a smart caching feature.</p>\n\n<table border=\"0\" cellspacing=\"10\">\n  <tbody>\n    <tr>\n      <td colspan=\"4\"><h2>Synchronous checks</h2>\n      </td>\n    </tr>\n    <tr>\n      <th><h3>Key</h3></th>\n      <th><h3>Type</h3></th>\n      <th><h3>Example</h3></th>\n      <th><h3>Details</h3></th>\n    </tr>\n    <tr>\n      <td colspan=\"4\"><b>browser</b></td>\n    </tr>\n    <tr>\n      <td>browser.documentmode</td><td><i>Integer</i></td><td><code>0</code></td>\n      <td>{@link qx.bom.client.Browser#getDocumentMode}</td>\n    </tr>\n    <tr>\n      <td>browser.name</td><td><i>String</i></td><td><code> chrome </code></td>\n      <td>{@link qx.bom.client.Browser#getName}</td>\n    </tr>\n    <tr>\n      <td>browser.quirksmode</td><td><i>Boolean</i></td><td><code>false</code></td>\n      <td>{@link qx.bom.client.Browser#getQuirksMode}</td>\n    </tr>\n    <tr>\n      <td>browser.version</td><td><i>String</i></td><td><code>11.0</code></td>\n      <td>{@link qx.bom.client.Browser#getVersion}</td>\n    </tr>\n    <tr>\n      <td colspan=\"4\"><b>runtime</b></td>\n    </tr>\n    <tr>\n      <td>runtime.name</td><td><i> String </i></td><td><code> node.js </code></td>\n      <td>{@link qx.bom.client.Runtime#getName}</td>\n    </tr>\n    <tr>\n      <td colspan=\"4\"><b>css</b></td>\n    </tr>\n    <tr>\n      <td>css.borderradius</td><td><i>String</i> or <i>null</i></td><td><code>borderRadius</code></td>\n      <td>{@link qx.bom.client.Css#getBorderRadius}</td>\n    </tr>\n    <tr>\n      <td>css.borderimage</td><td><i>String</i> or <i>null</i></td><td><code>WebkitBorderImage</code></td>\n      <td>{@link qx.bom.client.Css#getBorderImage}</td>\n    </tr>\n    <tr>\n      <td>css.borderimage.standardsyntax</td><td><i>Boolean</i> or <i>null</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Css#getBorderImageSyntax}</td>\n    </tr>\n    <tr>\n      <td>css.boxmodel</td><td><i>String</i></td><td><code>content</code></td>\n      <td>{@link qx.bom.client.Css#getBoxModel}</td>\n    </tr>\n    <tr>\n      <td>css.boxshadow</td><td><i>String</i> or <i>null</i></td><td><code>boxShadow</code></td>\n      <td>{@link qx.bom.client.Css#getBoxShadow}</td>\n    </tr>\n    <tr>\n      <td>css.gradient.linear</td><td><i>String</i> or <i>null</i></td><td><code>-moz-linear-gradient</code></td>\n      <td>{@link qx.bom.client.Css#getLinearGradient}</td>\n    </tr>\n    <tr>\n      <td>css.gradient.filter</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Css#getFilterGradient}</td>\n    </tr>\n    <tr>\n      <td>css.gradient.radial</td><td><i>String</i> or <i>null</i></td><td><code>-moz-radial-gradient</code></td>\n      <td>{@link qx.bom.client.Css#getRadialGradient}</td>\n    </tr>\n    <tr>\n      <td>css.gradient.legacywebkit</td><td><i>Boolean</i></td><td><code>false</code></td>\n      <td>{@link qx.bom.client.Css#getLegacyWebkitGradient}</td>\n    </tr>\n    <tr>\n      <td>css.placeholder</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Css#getPlaceholder}</td>\n    </tr>\n    <tr>\n      <td>css.textoverflow</td><td><i>String</i> or <i>null</i></td><td><code>textOverflow</code></td>\n      <td>{@link qx.bom.client.Css#getTextOverflow}</td>\n    </tr>\n    <tr>\n      <td>css.rgba</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Css#getRgba}</td>\n    </tr>\n    <tr>\n      <td>css.usermodify</td><td><i>String</i> or <i>null</i></td><td><code>WebkitUserModify</code></td>\n      <td>{@link qx.bom.client.Css#getUserModify}</td>\n    </tr>\n    <tr>\n      <td>css.appearance</td><td><i>String</i> or <i>null</i></td><td><code>WebkitAppearance</code></td>\n      <td>{@link qx.bom.client.Css#getAppearance}</td>\n    </tr>\n    <tr>\n      <td>css.float</td><td><i>String</i> or <i>null</i></td><td><code>cssFloat</code></td>\n      <td>{@link qx.bom.client.Css#getFloat}</td>\n    </tr>\n    <tr>\n      <td>css.userselect</td><td><i>String</i> or <i>null</i></td><td><code>WebkitUserSelect</code></td>\n      <td>{@link qx.bom.client.Css#getUserSelect}</td>\n    </tr>\n    <tr>\n      <td>css.userselect.none</td><td><i>String</i> or <i>null</i></td><td><code>-moz-none</code></td>\n      <td>{@link qx.bom.client.Css#getUserSelectNone}</td>\n    </tr>\n    <tr>\n      <td>css.boxsizing</td><td><i>String</i> or <i>null</i></td><td><code>boxSizing</code></td>\n      <td>{@link qx.bom.client.Css#getBoxSizing}</td>\n    </tr>\n    <tr>\n      <td>css.animation</td><td><i>Object</i> or <i>null</i></td><td><code>{end-event: \"webkitAnimationEnd\", keyframes: \"@-webkit-keyframes\", play-state: null, name: \"WebkitAnimation\"}</code></td>\n      <td>{@link qx.bom.client.CssAnimation#getSupport}</td>\n    </tr>\n    <tr>\n      <td>css.animation.requestframe</td><td><i>String</i> or <i>null</i></td><td><code>mozRequestAnimationFrame</code></td>\n      <td>{@link qx.bom.client.CssAnimation#getRequestAnimationFrame}</td>\n    </tr>\n    <tr>\n      <td>css.transform</td><td><i>Object</i> or <i>null</i></td><td><code>{3d: true, origin: \"WebkitTransformOrigin\", name: \"WebkitTransform\", style: \"WebkitTransformStyle\", perspective: \"WebkitPerspective\", perspective-origin: \"WebkitPerspectiveOrigin\", backface-visibility: \"WebkitBackfaceVisibility\"}</code></td>\n      <td>{@link qx.bom.client.CssTransform#getSupport}</td>\n    </tr>\n    <tr>\n      <td>css.transform.3d</td><td><i>Boolean</i></td><td><code>false</code></td>\n      <td>{@link qx.bom.client.CssTransform#get3D}</td>\n    </tr>\n    <tr>\n      <td>css.transition</td><td><i>Object</i> or <i>null</i></td><td><code>{end-event: \"webkitTransitionEnd\", name: \"WebkitTransition\"}</code></td>\n      <td>{@link qx.bom.client.CssTransition#getSupport}</td>\n    </tr>\n    <tr>\n      <td>css.inlineblock</td><td><i>String</i> or <i>null</i></td><td><code>inline-block</code></td>\n      <td>{@link qx.bom.client.Css#getInlineBlock}</td>\n    </tr>\n    <tr>\n      <td>css.opacity</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Css#getOpacity}</td>\n    </tr>\n    <tr>\n      <td>css.textShadow</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Css#getTextShadow}</td>\n    </tr>\n    <tr>\n      <td>css.textShadow.filter</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Css#getFilterTextShadow}</td>\n    </tr>\n    <tr>\n      <td>css.alphaimageloaderneeded</td><td><i>Boolean</i></td><td><code>false</code></td>\n      <td>{@link qx.bom.client.Css#getAlphaImageLoaderNeeded}</td>\n    </tr>\n    <tr>\n      <td>css.pointerevents</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Css#getPointerEvents}</td>\n    </tr>\n    <tr>\n      <td>css.flexboxSyntax</td><td><i>String</i> or <i>null</i></td><td><code>\"flex\"</code></td>\n      <td>{@link qx.bom.client.Css#getFlexboxSyntax}</td>\n    </tr>\n    <tr>\n      <td colspan=\"4\"><b>device</b></td>\n    </tr>\n    <tr>\n      <td>device.name</td><td><i>String</i></td><td><code>pc</code></td>\n      <td>{@link qx.bom.client.Device#getName}</td>\n    </tr>\n    <tr>\n      <td>device.type</td><td><i>String</i></td><td><code>mobile</code></td>\n      <td>{@link qx.bom.client.Device#getType}</td>\n    </tr>\n    <tr>\n      <td>device.pixelRatio</td><td><i>Number</i></td><td><code>2</code></td>\n      <td>{@link qx.bom.client.Device#getDevicePixelRatio}</td>\n    </tr>\n    <tr>\n      <td>device.touch</td><td><i>String</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Device#getTouch}</td>\n    </tr>\n    <tr>\n      <td colspan=\"4\"><b>ecmascript</b></td>\n    </tr>\n    <tr>\n      <td>ecmascript.error.stacktrace</td><td><i>String</i> or <i>null</i></td><td><code>stack</code></td>\n      <td>{@link qx.bom.client.EcmaScript#getStackTrace}</td>\n    </tr>\n    <tr>\n      <td>ecmascript.array.indexof<td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.EcmaScript#getArrayIndexOf}</td>\n    </tr>\n    <tr>\n      <td>ecmascript.array.lastindexof<td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.EcmaScript#getArrayLastIndexOf}</td>\n    </tr>\n    <tr>\n      <td>ecmascript.array.foreach<td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.EcmaScript#getArrayForEach}</td>\n    </tr>\n    <tr>\n      <td>ecmascript.array.filter<td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.EcmaScript#getArrayFilter}</td>\n    </tr>\n    <tr>\n      <td>ecmascript.array.map<td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.EcmaScript#getArrayMap}</td>\n    </tr>\n    <tr>\n      <td>ecmascript.array.some<td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.EcmaScript#getArraySome}</td>\n    </tr>\n    <tr>\n      <td>ecmascript.array.every<td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.EcmaScript#getArrayEvery}</td>\n    </tr>\n    <tr>\n      <td>ecmascript.array.reduce<td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.EcmaScript#getArrayReduce}</td>\n    </tr>\n    <tr>\n      <td>ecmascript.array.reduceright<td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.EcmaScript#getArrayReduceRight}</td>\n    </tr>\n    <tr>\n      <td>ecmascript.function.bind<td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.EcmaScript#getFunctionBind}</td>\n    </tr>\n    <tr>\n      <td>ecmascript.object.keys<td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.EcmaScript#getObjectKeys}</td>\n    </tr>\n    <tr>\n      <td>ecmascript.date.now<td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.EcmaScript#getDateNow}</td>\n    </tr>\n    <tr>\n      <td>ecmascript.error.toString</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.EcmaScript#getErrorToString}</td>\n    </tr>\n    <tr>\n      <td>ecmascript.string.trim</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.EcmaScript#getStringTrim}</td>\n    </tr>\n    <tr>\n      <td colspan=\"4\"><b>engine</b></td>\n    </tr>\n    <tr>\n      <td>engine.name</td><td><i>String</i></td><td><code>webkit</code></td>\n      <td>{@link qx.bom.client.Engine#getName}</td>\n    </tr>\n    <tr>\n      <td>engine.version</td><td><i>String</i></td><td><code>534.24</code></td>\n      <td>{@link qx.bom.client.Engine#getVersion}</td>\n    </tr>\n\n<tr>\n      <td colspan=\"4\"><b>event</b></td>\n    </tr>\n     <tr>\n      <td>event.mspointer</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Event#getMsPointer}</td>\n    </tr>\n    <tr>\n      <td>event.touch</td><td><i>Boolean</i></td><td><code>false</code></td>\n      <td>{@link qx.bom.client.Event#getTouch}</td>\n    </tr>\n    <tr>\n      <td>event.help</td><td><i>Boolean</i></td><td><code>false</code></td>\n      <td>{@link qx.bom.client.Event#getHelp}</td>\n    </tr>\n    <tr>\n      <td>event.hashchange</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Event#getHashChange}</td>\n    </tr>\n    <tr>\n      <td>event.dispatchevent</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Event#getDispatchEvent}</td>\n    </tr>\n    <tr>\n      <td>event.customevent</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Event#getCustomEvent}</td>\n    </tr>\n    <tr>\n      <td>event.mouseevent</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Event#getMouseEvent}</td>\n    </tr>\n    <tr>\n      <td>event.mousewheel</td><td><i>Map</i></td><td><code>{type: \"wheel\", target: window}</code></td>\n      <td>{@link qx.bom.client.Event#getMouseWheel}</td>\n    </tr>\n\n<tr>\n      <td colspan=\"4\"><b>html</b></td>\n    </tr>\n    <tr>\n      <td>html.audio</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Html#getAudio}</td>\n    </tr>\n    <tr>\n      <td>html.audio.mp3</td><td><i>String</i></td><td><code>\"\"</code></td>\n      <td>{@link qx.bom.client.Html#getAudioMp3}</td>\n    </tr>\n    <tr>\n      <td>html.audio.ogg</td><td><i>String</i></td><td><code>\"maybe\"</code></td>\n      <td>{@link qx.bom.client.Html#getAudioOgg}</td>\n    </tr>\n    <tr>\n      <td>html.audio.wav</td><td><i>String</i></td><td><code>\"probably\"</code></td>\n      <td>{@link qx.bom.client.Html#getAudioWav}</td>\n    </tr>\n    <tr>\n      <td>html.audio.au</td><td><i>String</i></td><td><code>\"maybe\"</code></td>\n      <td>{@link qx.bom.client.Html#getAudioAu}</td>\n    </tr>\n    <tr>\n      <td>html.audio.aif</td><td><i>String</i></td><td><code>\"probably\"</code></td>\n      <td>{@link qx.bom.client.Html#getAudioAif}</td>\n    </tr>\n    <tr>\n      <td>html.canvas</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Html#getCanvas}</td>\n    </tr>\n    <tr>\n      <td>html.classlist</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Html#getClassList}</td>\n    </tr>\n    <tr>\n      <td>html.geolocation</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Html#getGeoLocation}</td>\n    </tr>\n    <tr>\n      <td>html.storage.local</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Html#getLocalStorage}</td>\n    </tr>\n    <tr>\n      <td>html.storage.session</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Html#getSessionStorage}</td>\n    </tr>\n    <tr>\n      <td>html.storage.userdata</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Html#getUserDataStorage}</td>\n    </tr>\n    <tr>\n      <td>html.svg</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Html#getSvg}</td>\n    </tr>\n    <tr>\n      <td>html.video</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Html#getVideo}</td>\n    </tr>\n    <tr>\n      <td>html.video.h264</td><td><i>String</i></td><td><code>\"probably\"</code></td>\n      <td>{@link qx.bom.client.Html#getVideoH264}</td>\n    </tr>\n    <tr>\n      <td>html.video.ogg</td><td><i>String</i></td><td><code>\"\"</code></td>\n      <td>{@link qx.bom.client.Html#getVideoOgg}</td>\n    </tr>\n    <tr>\n      <td>html.video.webm</td><td><i>String</i></td><td><code>\"maybe\"</code></td>\n      <td>{@link qx.bom.client.Html#getVideoWebm}</td>\n    </tr>\n    <tr>\n      <td>html.vml</td><td><i>Boolean</i></td><td><code>false</code></td>\n      <td>{@link qx.bom.client.Html#getVml}</td>\n    </tr>\n    <tr>\n      <td>html.webworker</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Html#getWebWorker}</td>\n    <tr>\n      <td>html.filereader</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Html#getFileReader}</td>\n    </tr>\n    <tr>\n      <td>html.xpath</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Html#getXPath}</td>\n    </tr>\n    <tr>\n      <td>html.xul</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Html#getXul}</td>\n    </tr>\n    <tr>\n      <td>html.console</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Html#getConsole}</td>\n    </tr>\n    <tr>\n      <td>html.element.contains</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Html#getContains}</td>\n    </tr>\n    <tr>\n      <td>html.element.compareDocumentPosition</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Html#getCompareDocumentPosition}</td>\n    </tr>\n    <tr>\n      <td>html.element.textContent</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Html#getTextContent}</td>\n    </tr>\n    <tr>\n      <td>html.image.naturaldimensions</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Html#getNaturalDimensions}</td>\n    </tr>\n    <tr>\n      <td>html.history.state</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Html#getHistoryState}</td>\n    </tr>\n    <tr>\n      <td>html.selection</td><td><i>String</i></td><td><code>getSelection</code></td>\n      <td>{@link qx.bom.client.Html#getSelection}</td>\n    </tr>\n    <tr>\n      <td>html.node.isequalnode</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Html#getIsEqualNode}</td>\n    </tr>\n    <tr>\n      <td colspan=\"4\"><b>XML</b></td>\n    </tr>\n    <tr>\n      <td>xml.implementation</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Xml#getImplementation}</td>\n    </tr>\n    <tr>\n      <td>xml.domparser</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Xml#getDomParser}</td>\n    </tr>\n    <tr>\n      <td>xml.selectsinglenode</td><td><i>Boolean</i></td><td><code>false</code></td>\n      <td>{@link qx.bom.client.Xml#getSelectSingleNode}</td>\n    </tr>\n    <tr>\n      <td>xml.selectnodes</td><td><i>Boolean</i></td><td><code>false</code></td>\n      <td>{@link qx.bom.client.Xml#getSelectNodes}</td>\n    </tr>\n    <tr>\n      <td>xml.getelementsbytagnamens</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Xml#getElementsByTagNameNS}</td>\n    </tr>\n    <tr>\n      <td>xml.domproperties</td><td><i>Boolean</i></td><td><code>false</code></td>\n      <td>{@link qx.bom.client.Xml#getDomProperties}</td>\n    </tr>\n    <tr>\n      <td>xml.attributens</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Xml#getAttributeNS}</td>\n    </tr>\n    <tr>\n      <td>xml.createelementns</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Xml#getCreateElementNS}</td>\n    </tr>\n    <tr>\n      <td>xml.createnode</td><td><i>Boolean</i></td><td><code>false</code></td>\n      <td>{@link qx.bom.client.Xml#getCreateNode}</td>\n    </tr>\n    <tr>\n      <td>xml.getqualifieditem</td><td><i>Boolean</i></td><td><code>false</code></td>\n      <td>{@link qx.bom.client.Xml#getQualifiedItem}</td>\n    </tr>\n\n<tr>\n      <td colspan=\"4\"><b>Stylesheets</b></td>\n    </tr>\n    <tr>\n      <td>html.stylesheet.createstylesheet</td><td><i>Boolean</i></td><td><code>false</code></td>\n      <td>{@link qx.bom.client.Stylesheet#getCreateStyleSheet}</td>\n    </tr>\n    <tr>\n      <td>html.stylesheet.insertrule</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Stylesheet#getInsertRule}</td>\n    </tr>\n    <tr>\n      <td>html.stylesheet.deleterule</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Stylesheet#getDeleteRule}</td>\n    </tr>\n    <tr>\n      <td>html.stylesheet.addimport</td><td><i>Boolean</i></td><td><code>false</code></td>\n      <td>{@link qx.bom.client.Stylesheet#getAddImport}</td>\n    </tr>\n    <tr>\n      <td>html.stylesheet.removeimport</td><td><i>Boolean</i></td><td><code>false</code></td>\n      <td>{@link qx.bom.client.Stylesheet#getRemoveImport}</td>\n    </tr>\n\n<tr>\n      <td colspan=\"4\"><b>io</b></td>\n    </tr>\n    <tr>\n      <td>io.maxrequests</td><td><i>Integer</i></td><td><code>4</code></td>\n      <td>{@link qx.bom.client.Transport#getMaxConcurrentRequestCount}</td>\n    </tr>\n    <tr>\n      <td>io.ssl</td><td><i>Boolean</i></td><td><code>false</code></td>\n      <td>{@link qx.bom.client.Transport#getSsl}</td>\n    </tr>\n    <tr>\n      <td>io.xhr</td><td><i>String</i></td><td><code>xhr</code></td>\n      <td>{@link qx.bom.client.Transport#getXmlHttpRequest}</td>\n    </tr>\n\n<tr>\n      <td colspan=\"4\"><b>locale</b></td>\n    </tr>\n    <tr>\n      <td>locale</td><td><i>String</i></td><td><code>de</code></td>\n      <td>{@link qx.bom.client.Locale#getLocale}</td>\n    </tr>\n    <tr>\n      <td>locale.variant</td><td><i>String</i></td><td><code>de</code></td>\n      <td>{@link qx.bom.client.Locale#getVariant}</td>\n    </tr>\n\n<tr>\n      <td colspan=\"4\"><b>os</b></td>\n    </tr>\n    <tr>\n      <td>os.name</td><td><i>String</i></td><td><code>osx</code></td>\n      <td>{@link qx.bom.client.OperatingSystem#getName}</td>\n    </tr>\n    <tr>\n      <td>os.version</td><td><i>String</i></td><td><code>10.6</code></td>\n      <td>{@link qx.bom.client.OperatingSystem#getVersion}</td>\n    </tr>\n    <tr>\n      <td>os.scrollBarOverlayed</td><td><i>Boolean</i></td><td><code>false</code></td>\n      <td>{@link qx.bom.client.Scroll#scrollBarOverlayed}</td>\n    </tr>\n\n<tr>\n      <td colspan=\"4\"><b>phonegap</b></td>\n    </tr>\n    <tr>\n      <td>phonegap</td><td><i>Boolean</i></td><td><code>false</code></td>\n      <td>{@link qx.bom.client.PhoneGap#getPhoneGap}</td>\n    </tr>\n    <tr>\n      <td>phonegap.notification</td><td><i>Boolean</i></td><td><code>false</code></td>\n      <td>{@link qx.bom.client.PhoneGap#getNotification}</td>\n    </tr>\n\n<tr>\n      <td colspan=\"4\"><b>plugin</b></td>\n    </tr>\n    <tr>\n      <td>plugin.divx</td><td><i>Boolean</i></td><td><code>false</code></td>\n      <td>{@link qx.bom.client.Plugin#getDivX}</td>\n    </tr>\n    <tr>\n      <td>plugin.divx.version</td><td><i>String</i></td><td></td>\n      <td>{@link qx.bom.client.Plugin#getDivXVersion}</td>\n    </tr>\n    <tr>\n      <td>plugin.flash</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Flash#isAvailable}</td>\n    </tr>\n    <tr>\n      <td>plugin.flash.express</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Flash#getExpressInstall}</td>\n    </tr>\n    <tr>\n      <td>plugin.flash.strictsecurity</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Flash#getStrictSecurityModel}</td>\n    </tr>\n    <tr>\n      <td>plugin.flash.version</td><td><i>String</i></td><td><code>10.2.154</code></td>\n      <td>{@link qx.bom.client.Flash#getVersion}</td>\n    </tr>\n    <tr>\n      <td>plugin.gears</td><td><i>Boolean</i></td><td><code>false</code></td>\n      <td>{@link qx.bom.client.Plugin#getGears}</td>\n    </tr>\n    <tr>\n      <td>plugin.activex</td><td><i>Boolean</i></td><td><code>false</code></td>\n      <td>{@link qx.bom.client.Plugin#getActiveX}</td>\n    </tr>\n    <tr>\n      <td>plugin.skype</td><td><i>Boolean</i></td><td><code>false</code></td>\n      <td>{@link qx.bom.client.Plugin#getSkype}</td>\n    </tr>\n    <tr>\n      <td>plugin.pdf</td><td><i>Boolean</i></td><td><code>false</code></td>\n      <td>{@link qx.bom.client.Plugin#getPdf}</td>\n    </tr>\n    <tr>\n      <td>plugin.pdf.version</td><td><i>String</i></td><td></td>\n      <td>{@link qx.bom.client.Plugin#getPdfVersion}</td>\n    </tr>\n    <tr>\n      <td>plugin.quicktime</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Plugin#getQuicktime}</td>\n    </tr>\n    <tr>\n      <td>plugin.quicktime.version</td><td><i>String</i></td><td><code>7.6</code></td>\n      <td>{@link qx.bom.client.Plugin#getQuicktimeVersion}</td>\n    </tr>\n    <tr>\n      <td>plugin.silverlight</td><td><i>Boolean</i></td><td><code>false</code></td>\n      <td>{@link qx.bom.client.Plugin#getSilverlight}</td>\n    </tr>\n    <tr>\n      <td>plugin.silverlight.version</td><td><i>String</i></td><td></td>\n      <td>{@link qx.bom.client.Plugin#getSilverlightVersion}</td>\n    </tr>\n    <tr>\n      <td>plugin.windowsmedia</td><td><i>Boolean</i></td><td><code>false</code></td>\n      <td>{@link qx.bom.client.Plugin#getWindowsMedia}</td>\n    </tr>\n    <tr>\n      <td>plugin.windowsmedia.version</td><td><i>String</i></td><td></td>\n      <td>{@link qx.bom.client.Plugin#getWindowsMediaVersion}</td>\n    </tr>\n\n<tr>\n      <td colspan=\"4\"><b>qx</b></td>\n    </tr>\n    <tr>\n      <td>qx.allowUrlSettings</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td><i>default:</i> <code>false</code></td>\n    </tr>\n    <tr>\n      <td>qx.allowUrlVariants</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td><i>default:</i> <code>false</code></td>\n    </tr>\n    <tr>\n      <td>qx.application</td><td><i>String</i></td><td><code>name.space</code></td>\n      <td><i>default:</i> <code>&lt;&lt;application name&gt;&gt;</code></td>\n    </tr>\n    <tr>\n      <td>qx.aspects</td><td><i>Boolean</i></td><td><code>false</code></td>\n      <td><i>default:</i> <code>false</code></td>\n    </tr>\n    <tr>\n      <td>qx.debug</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td><i>default:</i> <code>true</code></td>\n    </tr>\n    <tr>\n      <td>qx.debug.databinding</td><td><i>Boolean</i></td><td><code>false</code></td>\n      <td><i>default:</i> <code>false</code></td>\n    </tr>\n    <tr>\n      <td>qx.debug.dispose</td><td><i>Boolean</i></td><td><code>false</code></td>\n      <td><i>default:</i> <code>false</code></td>\n    </tr>\n    <tr>\n      <td>qx.debug.dispose.level</td><td><i>Integer</i></td><td><code>0</code></td>\n      <td><i>default:</i> <code>0</code></td>\n    </tr>\n    <tr>\n      <td>qx.debug.io</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td><i>default:</i> <code>false</code></td>\n    </tr>\n    <tr>\n    <tr>\n      <td>qx.debug.io.remote</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td><i>default:</i> <code>false</code></td>\n    </tr>\n    <tr>\n    <tr>\n      <td>qx.debug.io.remote.data</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td><i>default:</i> <code>false</code></td>\n    </tr>\n    <tr>\n      <td>qx.debug.property.level</td><td><i>Integer</i></td><td><code>0</code></td>\n      <td><i>default:</i> <code>0</code></td>\n    </tr>\n    <tr>\n      <td>qx.debug.ui.queue</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td><i>default:</i> <code>true</code></td>\n    </tr>\n    <tr>\n      <td>qx.dynlocale</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td><i>default:</i> <code>true</code></td>\n    </tr>\n    <tr>\n      <td>qx.dyntheme</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td><i>default:</i> <code>true</code></td>\n    </tr>\n    <tr>\n      <td>qx.globalErrorHandling</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td><i>default:</i> <code>true</code></td>\n    </tr>\n    <tr>\n      <td>qx.mobile.nativescroll</td><td><i>Boolean</i></td><td><code>false</code></td>\n      <td>{@link qx.bom.client.Scroll#getNativeScroll}</td>\n    </tr>\n    <tr>\n      <td>qx.optimization.basecalls</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>true if the corresp. <i>optimize</i> key is set in the config</td>\n    </tr>\n    <tr>\n      <td>qx.optimization.comments</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>true if the corresp. <i>optimize</i> key is set in the config</td>\n    </tr>\n    <tr>\n      <td>qx.optimization.privates</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>true if the corresp. <i>optimize</i> key is set in the config</td>\n    </tr>\n    <tr>\n      <td>qx.optimization.strings</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>true if the corresp. <i>optimize</i> key is set in the config</td>\n    </tr>\n    <tr>\n      <td>qx.optimization.variables</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>true if the corresp. <i>optimize</i> key is set in the config</td>\n    </tr>\n    <tr>\n      <td>qx.optimization.variants</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>true if the corresp. <i>optimize</i> key is set in the config</td>\n    </tr>\n    <tr>\n      <td>qx.revision</td><td><i>String</i></td><td><code>27348</code></td>\n    </tr>\n    <tr>\n      <td>qx.theme</td><td><i>String</i></td><td><code>qx.theme.Modern</code></td>\n      <td><i>default:</i> <code>&lt;&lt;initial theme name&gt;&gt;</code></td>\n    </tr>\n    <tr>\n      <td>qx.version</td><td><i>String</i></td><td><code>4.1</code></td>\n    </tr>\n    <tr>\n      <td>qx.blankpage</td><td><i>String</i></td><td><code>URI to blank.html page</code></td>\n    </tr>\n\n<tr>\n      <td colspan=\"4\"><b>module</b></td>\n    </tr>\n    <tr>\n      <td>module.databinding</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td><i>default:</i> <code>true</code></td>\n    </tr>\n    <tr>\n      <td>module.logger</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td><i>default:</i> <code>true</code></td>\n    </tr>\n    <tr>\n      <td>module.property</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td><i>default:</i> <code>true</code></td>\n    </tr>\n    <tr>\n      <td>module.events</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td><i>default:</i> <code>true</code></td>\n    </tr>\n    <tr>\n      <td colspan=\"4\"><h3>Asynchronous checks</h3>\n      </td>\n    </tr>\n    <tr>\n      <td>html.dataurl</td><td><i>Boolean</i></td><td><code>true</code></td>\n      <td>{@link qx.bom.client.Html#getDataUrl}</td>\n    </tr>\n    <tr>\n      <td>plugin.pdfjs</td><td><i>Boolean</i></td><td><code>false</code></td>\n      <td>{@link qx.bom.client.Pdfjs#getPdfjs}</td>\n    </tr>\n  </tbody>\n</table>","__createCheck":{"!doc":"<p>Internal helper which creates a function returning the given value.</p>","!type":"fn(value: Object) -> fn()"},"__importFromGenerator":{"!doc":"<p>Import checks from global qx.$environment into the Environment class.</p>","!type":"fn()"},"__importFromUrl":{"!doc":"<p>Checks the <span class=\"caps\">URL</span> for environment settings and imports these into the\nEnvironment class.</p>","!type":"fn()"},"__pickFromValues":{"!doc":"<p>Internal helper which tries to pick the given key from the given values\nmap. If that key is not found, it tries to use a key named &#8220;default&#8221;.\nIf there is also no default key, it prints out a warning and returns\nundefined.</p>","!type":"fn(key: string, values: +Map) -> Object"},"_getClassNameFromEnvKey":{"!doc":"<p>Maps an environment key to a check class and method name.</p>","!type":"fn(key: string) -> +Array"},"_initDefaultQxValues":{"!doc":"<p>Initializer for the default values of the framework settings.</p>","!type":"fn()"},"add":{"!doc":"<p>Add a check to the environment class. If there is already a check\nadded for the given key, the add will be ignored.</p>","!type":"fn(key: string, check: Object)"},"addAsync":{"!doc":"<p>Adds an asynchronous check to the environment. If there is already a check\nadded for the given key, the add will be ignored.</p>","!type":"fn(key: string, check: fn())"},"filter":{"!doc":"<p>Takes a given map containing the check names as keys and converts\nthe map to an array only containing the values for check evaluating\nto <code>true</code>. This is especially handy for conditional\nincludes of mixins.</p>","!type":"fn(map: +Map) -> +Array"},"get":{"!doc":"<p>The default accessor for the checks. It returns the value the current\nenvironment has for the given key. The key could be something like\n&#8220;qx.debug&#8221;, &#8220;css.textoverflow&#8221; or &#8220;io.ssl&#8221;. A complete list of\nchecks can be found in the class comment of this class.</p>\n\n<p>Please keep in mind that the result is cached. If you want to run the\ncheck function again in case something could have been changed, take a\nlook at the {@link #invalidateCacheKey} function.</p>","!type":"fn(key: string) -> Object"},"getAsync":{"!doc":"<p>Invokes the callback as soon as the check has been done. If no check\ncould be found, a warning will be printed.</p>","!type":"fn(key: string, callback: fn(), self: Object)"},"getAsyncChecks":{"!doc":"<p>Returns all currently defined asynchronous checks.</p>","!type":"fn() -> +Map"},"getChecks":{"!doc":"<p>Returns all currently defined synchronous checks.</p>","!type":"fn() -> +Map"},"invalidateCacheKey":{"!doc":"<p>Invalidates the cache for the given key.</p>","!type":"fn(key: string)"},"select":{"!doc":"<p>Returns the proper value dependent on the check for the given key.</p>","!type":"fn(key: string, values: +Map) -> Object"},"selectAsync":{"!doc":"<p>Selects the proper function dependent on the asynchronous check.</p>","!type":"fn(key: string, values: +Map, self: Object)"}},"GlobalError":{"!proto":"Error","!doc":"<p>This exception is thrown by the {@link qx.event.GlobalError} handler if a\nobserved method throws an exception.</p>","!type":"fn()","prototype":{"getArguments":{"!doc":"<p>Returns the arguments which are</p>","!type":"fn() -> Object"},"getSourceException":{"!doc":"<p>Get the source exception</p>","!type":"fn() -> +Error"},"toString":{"!doc":"<p>Returns the error message.</p>","!type":"fn() -> string"}}},"Init":{"!doc":"<p>This is the base class for all qooxdoo applications.</p>","__close":{"!doc":"<p>Runs before the document is unloaded. Calls the application&#8217;s close\nmethod to check if the unload process should be stopped.</p>","!type":"fn(e: +qx.event.type.Native)"},"__shutdown":{"!doc":"<p>Runs when the document is unloaded. Automatically terminates a previously\ncreated application instance.</p>","!type":"fn()"}},"MAssert":{"!doc":"<p>This mixin includes all assertions from {@link qx.core.Assert} to conveniently\ncall assertions. It is included into {@link qx.core.Object} if debugging code\nis enabled. It is further included into all unit tests\n{@link qx.dev.unit.TestCase}.</p>","prototype":{"assert":{"!doc":"<p>Assert that the condition evaluates to <code>true</code>.</p>","!type":"fn(condition: Object, msg: string)"},"assertArgumentsCount":{"!doc":"<p>Assert that the number of arguments is within the given range</p>","!type":"fn(args: +arguments, minCount: +Integer, maxCount: +Integer, msg: string)"},"assertArray":{"!doc":"<p>Assert that the value is an array.</p>","!type":"fn(value: Object, msg: string)"},"assertArrayEquals":{"!doc":"<p>Assert that both array have identical array items.</p>","!type":"fn(expected: +Array, found: +Array, msg: string)"},"assertBoolean":{"!doc":"<p>Assert that the value is a boolean.</p>","!type":"fn(value: Object, msg: string)"},"assertCssColor":{"!doc":"<p>Assert that the value represents the given <span class=\"caps\">CSS</span> color value. This method\nparses the color strings and compares the <span class=\"caps\">RGB</span> values. It is able to\nparse values supported by {@link qx.util.ColorUtil#stringToRgb}.</p>","!type":"fn(expected: string, value: string, msg: string)"},"assertElement":{"!doc":"<p>Assert that the value is a <span class=\"caps\">DOM</span> element.</p>","!type":"fn(value: Object, msg: string)"},"assertEquals":{"!doc":"<p>Assert that both values are equal. (Uses the equality operator\n<code>==</code>.)</p>","!type":"fn(expected: Object, found: Object, msg: string)"},"assertEventFired":{"!doc":"<p>Assert that an event is fired.</p>","!type":"fn(obj: Object, event: string, invokeFunc: fn(), listener?: fn(), msg?: string)"},"assertEventNotFired":{"!doc":"<p>Assert that an event is not fired.</p>","!type":"fn(obj: Object, event: string, invokeFunc: fn(), msg: string)"},"assertException":{"!doc":"<p>Asserts that the callback raises a matching exception.</p>","!type":"fn(callback: fn(), exception?: +Error, re: string, msg: string)"},"assertFalse":{"!doc":"<p>Assert that the value is <code>false</code> (Identity check).</p>","!type":"fn(value: bool, msg: string)"},"assertFunction":{"!doc":"<p>Assert that the value is a function.</p>","!type":"fn(value: Object, msg: string)"},"assertIdentical":{"!doc":"<p>Assert that both values are identical. (Uses the identity operator\n<code>===</code>.)</p>","!type":"fn(expected: Object, found: Object, msg: string)"},"assertInArray":{"!doc":"<p>Assert that the value is an item in the given array.</p>","!type":"fn(value: Object, array: +Array, msg: string)"},"assertInRange":{"!doc":"<p>Assert that the value is inside the given range.</p>","!type":"fn(value: Object, min: number, max: number, msg: string)"},"assertInstance":{"!doc":"<p>Assert that the value is an instance of the given class.</p>","!type":"fn(value: Object, clazz: +Class, msg: string)"},"assertInteger":{"!doc":"<p>Assert that the value is an integer.</p>","!type":"fn(value: Object, msg: string)"},"assertInterface":{"!doc":"<p>Assert that the value implements the given interface.</p>","!type":"fn(value: Object, iface: +Class, msg: string)"},"assertJsonEquals":{"!doc":"<p>Assert that the first two arguments are equal, when serialized into\n<span class=\"caps\">JSON</span>.</p>","!type":"fn(expected: Object, found: Object, msg: string)"},"assertKeyInMap":{"!doc":"<p>Assert that the value is a key in the given map.</p>","!type":"fn(value: Object, map: +Map, msg: string)"},"assertMap":{"!doc":"<p>Assert that the value is a map either created using <code>new Object</code>\nor by using the object literal notation <code>{ ... }</code>.</p>","!type":"fn(value: Object, msg: string)"},"assertMatch":{"!doc":"<p>Assert that the given string matches the regular expression</p>","!type":"fn(str: string, re: +RegExp, msg: string)"},"assertNotEquals":{"!doc":"<p>Assert that both values are not equal. (Uses the not equality operator\n<code>!=</code>.)</p>","!type":"fn(expected: Object, found: Object, msg: string)"},"assertNotIdentical":{"!doc":"<p>Assert that both values are not identical. (Uses the not identity operator\n<code>!==</code>.)</p>","!type":"fn(expected: Object, found: Object, msg: string)"},"assertNotNull":{"!doc":"<p>Assert that the value is not <code>null</code>.</p>","!type":"fn(value: Object, msg: string)"},"assertNotUndefined":{"!doc":"<p>Assert that the value is not <code>undefined</code>.</p>","!type":"fn(value: Object, msg: string)"},"assertNull":{"!doc":"<p>Assert that the value is <code>null</code>.</p>","!type":"fn(value: Object, msg: string)"},"assertNumber":{"!doc":"<p>Assert that the value is a number.</p>","!type":"fn(value: Object, msg: string)"},"assertObject":{"!doc":"<p>Assert that the value is an object.</p>","!type":"fn(value: Object, msg: string)"},"assertPositiveInteger":{"!doc":"<p>Assert that the value is an integer >= 0.</p>","!type":"fn(value: Object, msg: string)"},"assertPositiveNumber":{"!doc":"<p>Assert that the value is a number >= 0.</p>","!type":"fn(value: Object, msg: string)"},"assertQxObject":{"!doc":"<p>Assert that the value is an instance of {@link qx.core.Object}.</p>","!type":"fn(value: Object, msg: string)"},"assertQxWidget":{"!doc":"<p>Assert that the value is an instance of {@link qx.ui.core.Widget}.</p>","!type":"fn(value: Object, msg: string)"},"assertRegExp":{"!doc":"<p>Assert that the value is a regular expression.</p>","!type":"fn(value: Object, msg: string)"},"assertString":{"!doc":"<p>Assert that the value is a string.</p>","!type":"fn(value: Object, msg: string)"},"assertTrue":{"!doc":"<p>Assert that the value is <code>true</code> (Identity check).</p>","!type":"fn(value: bool, msg: string)"},"assertType":{"!doc":"<p>Assert that the value has the given type using the <code>typeof</code>\noperator. Because the type is not always what it is supposed to be it is\nbetter to use more explicit checks like {@link #assertString} or\n{@link #assertArray}.</p>","!type":"fn(value: Object, type: string, msg: string)"},"assertUndefined":{"!doc":"<p>Assert that the value is <code>undefined</code>.</p>","!type":"fn(value: Object, msg: string)"},"fail":{"!doc":"<p>Raise an {@link AssertionError}</p>","!type":"fn(msg: string, compact: bool)"}}},"MBindTo":{"!doc":"<p>Mixin to add a bindTo method to a class, making it easy to bind a function\nto an object instance for use in lieu of calls to static method\nqx.lang.Function.bind().</p>\n\n<p>The easiest (but not necessarily most efficient) way to use this mixin is\nto include it in qx.core.Object by adding this line some place in the\napplication code (typically in main()):</p>\n\n<pre>\n  qx.Class.include(qx.core.Object, qx.core.MBindTo);\n</pre>\n\n<p>If object footprint (memory use) is of significant concern, that may be a\nbit excessive since every object which is a descendent of qx.core.Object\nwill have the methods defined in the mixin. Instead, if a certain class\nwill have many functions bound to it (of particular use for callback\nfunctions), qx.Class.include() could be used to include this mixin in that\nclass instead of in qx.core.Object.</p>\n\n<p>Alternatively, that class may be subclassed, and the &#8216;include&#8217; key of the\nclass configuration could be used to always include this mixin in the\nsubclass. e.g.</p>\n\n<pre>\n  qx.Class.define(\"custom.Table\",\n  {\n    extend  : qx.ui.table.Table,\n    include : [ qx.core.MBindTo ]\n  });\n</pre>","prototype":{"bindTo":{"!doc":"<p>Bind a function to this object</p>","!type":"fn(func: fn(), varargs?: Object) -> fn()"}}},"MEvent":{"!doc":"<p>This mixin offers basic event handling capabilities. It includes the\ncommonly known methods for managing event listeners and firing events.</p>","prototype":{"addListener":{"!doc":"<p>Add event listener to this object.</p>","!type":"fn(type: string, listener: fn(), self?: Object, capture?: bool) -> string"},"addListenerOnce":{"!doc":"<p>Add event listener to this object, which is only called once. After the\nlistener is called the event listener gets removed.</p>","!type":"fn(type: string, listener: fn(), self?: Object, capture?: bool) -> string"},"dispatchEvent":{"!doc":"<p>Dispatch an event on this object</p>","!type":"fn(evt: +qx.event.type.Event) -> bool"},"fireDataEvent":{"!doc":"<p>Creates and dispatches an non-bubbling data event on this object.</p>","!type":"fn(type: string, data: Object, oldData?: Object, cancelable?: bool) -> bool"},"fireEvent":{"!doc":"<p>Creates and dispatches an event on this object.</p>","!type":"fn(type: string, clazz?: +Class, args?: +Array) -> bool"},"fireNonBubblingEvent":{"!doc":"<p>Create an event object and dispatch it on this object.\nThe event dispatched with this method does never bubble! Use only if you\nare sure that bubbling is not required.</p>","!type":"fn(type: string, clazz?: +Class, args?: +Array) -> bool"},"hasListener":{"!doc":"<p>Check if there are one or more listeners for an event type.</p>","!type":"fn(type: string, capture?: bool) -> bool"},"removeListener":{"!doc":"<p>Remove event listener from this object</p>","!type":"fn(type: string, listener: fn(), self?: Object, capture: bool) -> bool"},"removeListenerById":{"!doc":"<p>Removes an event listener from an event target by an id returned by\n{@link #addListener}</p>","!type":"fn(id: string) -> bool"}}},"MLogging":{"!doc":"<p>This mixin offers the basic logging features offered by {@link qx.log.Logger}.</p>","prototype":{"__logMessage":{"!doc":"<p>Helper that calls the appropriate logger function with the current object\nand any number of items.</p>","!type":"fn(level: string, varargs: +arguments)"},"debug":{"!doc":"<p>Logs a debug message.</p>","!type":"fn(varargs: Object)"},"error":{"!doc":"<p>Logs an error message.</p>","!type":"fn(varargs: Object)"},"info":{"!doc":"<p>Logs an info message.</p>","!type":"fn(varargs: Object)"},"trace":{"!doc":"<p>Prints the current stack trace</p>","!type":"fn()"},"warn":{"!doc":"<p>Logs a warning message.</p>","!type":"fn(varargs: Object)"}}},"MProperty":{"!doc":"<p>This mixin offers the bacis property features which include generic\nsetter, getter and resetter.</p>","prototype":{"get":{"!doc":"<p>Returns the value of the given property. If no generated getter could be\nfound, a fallback tries to access a handwritten getter.</p>","!type":"fn(prop: string) -> Object"},"reset":{"!doc":"<p>Resets the value of the given property. If no generated resetter could be\nfound, a handwritten resetter will be invoked, if available.</p>","!type":"fn(prop: string)"},"set":{"!doc":"<p>Sets multiple properties at once by using a property list or\nsets one property and its value by the first and second argument.\nAs a fallback, if no generated property setter could be found, a\nhandwritten setter will be searched and invoked if available.</p>","!type":"fn(data: +Map, value?: Object) -> Object"}}},"Object":{"!proto":"Object","!doc":"<p>The qooxdoo root class. All other classes are direct or indirect subclasses of this one.</p>\n\n<p>This class contains methods for:</p>\n\n<ul>\n<li>object management (creation and destruction)</li>\n<li>interfaces for event system</li>\n<li>generic setter/getter support</li>\n<li>interfaces for logging console</li>\n<li>user friendly OO interfaces like {@link #self} or {@link #base}</li>\n</ul>","!type":"fn()","prototype":{"_disposeArray":{"!doc":"<p>Disposes all members of the given array and deletes\nthe field which refers to the array afterwards.</p>","!type":"fn(field: string)"},"_disposeMap":{"!doc":"<p>Disposes all members of the given map and deletes\nthe field which refers to the map afterwards.</p>","!type":"fn(field: string)"},"_disposeObjects":{"!doc":"<p>Disconnects and disposes given objects from instance.\nOnly works with qx.core.Object based objects e.g. Widgets.</p>","!type":"fn(varargs: +arguments)"},"_disposeSingletonObjects":{"!doc":"<p>Disconnects and disposes given singleton objects from instance.\nOnly works with qx.core.Object based objects e.g. Widgets.</p>","!type":"fn(varargs: +arguments)"},"base":{"!doc":"<p>Call the same method of the super class.</p>","!type":"fn(args: +arguments, varargs: Object) -> Object"},"clone":{"!doc":"<p><span class=\"caps\">EXPERIMENTAL</span> &#8211; <span class=\"caps\">NOT</span> <span class=\"caps\">READY</span> <span class=\"caps\">FOR</span> <span class=\"caps\">PRODUCTION</span></p>\n\n<p>Returns a clone of this object. Copies over all user configured\nproperty values. Do not configure a parent nor apply the appearance\nstyles directly.</p>","!type":"fn() -> +qx.core.Object"},"dispose":{"!doc":"<p>Dispose this object</p>","!type":"fn()"},"getUserData":{"!doc":"<p>Load user defined data from the object</p>","!type":"fn(key: string) -> Object"},"isDisposed":{"!doc":"<p>Returns true if the object is disposed.</p>","!type":"fn() -> bool"},"self":{"!doc":"<p>Returns the static class (to access static members of this class)</p>","!type":"fn(args: +arguments) -> Object"},"setUserData":{"!doc":"<p>Store user defined data inside the object.</p>","!type":"fn(key: string, value: Object)"},"toHashCode":{"!doc":"<p>Return unique hash code of object</p>","!type":"fn() -> +Integer"},"toString":{"!doc":"<p>Returns a string representation of the qooxdoo object.</p>","!type":"fn() -> string"}}},"ObjectRegistry":{"!doc":"<p>Registration for all instances of qooxdoo classes. Mainly\nused to manage them for the final shutdown sequence and to\nuse weak references when connecting widgets to <span class=\"caps\">DOM</span> nodes etc.</p>","clearHashCode":{"!doc":"<p>Clears the unique identifier on the given object.</p>","!type":"fn(obj: Object)"},"fromHashCode":{"!doc":"<p>Get an object instance by its hash code as returned by {@link #toHashCode}.\nIf the object is already disposed or the hashCode is invalid,\n<code>null</code> is returned.</p>","!type":"fn(hash: string) -> +qx.core.Object"},"getNextHash":{"!doc":"<p>Returns the next hash code that will be used</p>","!type":"fn() -> +Integer"},"getPostId":{"!doc":"<p>Returns the postfix that identifies the current iframe</p>","!type":"fn() -> +Integer"},"getRegistry":{"!doc":"<p>Returns the object registry.</p>","!type":"fn() -> Object"},"getStackTraces":{"!doc":"<p>Returns the map of stack traces recorded when objects are registered\n(for dispose profiling)</p>","!type":"fn() -> +Map"},"register":{"!doc":"<p>Registers an object into the database. This adds a hashcode\nto the object (if not already done before) and stores it under\nthis hashcode. You can access this object later using the hashcode\nby calling {@link #fromHashCode}.</p>\n\n<p>All registered objects are automatically disposed on application\nshutdown. Each registered object must at least have a method\ncalled <code>dispose</code>.</p>","!type":"fn(obj: Object)"},"shutdown":{"!doc":"<p>Disposing all registered object and cleaning up registry. This is\nautomatically executed at application shutdown.</p>","!type":"fn()"},"toHashCode":{"!doc":"<p>Returns an unique identifier for the given object. If such an identifier\ndoes not yet exist, create it.</p>","!type":"fn(obj: Object) -> string"},"unregister":{"!doc":"<p>Removes the given object from the database.</p>","!type":"fn(obj: Object)"}},"Property":{"!doc":"<p>Internal class for handling of dynamic properties. Should only be used\nthrough the methods provided by {@link qx.Class}.</p>\n\n<p>For a complete documentation of properties take a look at\n<a href=\"http://manual.qooxdoo.org/4.1/pages/core.html#properties\">http://manual.qooxdoo.org/4.1/pages/core.html#properties</a>.</p>\n\n<p><strong>Normal properties</strong></p>\n\n<p>The <code>properties</code> key in the class definition map of {@link qx.Class#define}\nis used to generate the properties.</p>\n\n<p>Valid keys of a property definition are:</p>\n\n<table>\n  <tr><th>Name</th><th>Type</th><th>Description</th></tr>\n  <tr><th>check</th><td>Array, String, Function</td><td>\n    The check is used to check the type the incoming value of a property. This will only\n    be executed in the source version. The build version will not contain the checks.\n    The check can be:\n    <ul>\n      <li>a custom check function. The function takes the incoming value as a parameter and must\n          return a boolean value to indicate whether the values is valid.\n      </li>\n      <li>inline check code as a string e.g. <code>\"value &gt; 0 &amp;&amp; value &lt; 100\"</code></li>\n      <li>a class name e.g. <code>qx.ui.form.Button</code></li>\n      <li>a name of an interface the value must implement</li>\n      <li>an array of all valid values</li>\n      <li>one of the predefined checks: Boolean, String, Number, Integer, Float, Double,\n          Object, Array, Map, Class, Mixin, Interface, Theme, Error, RegExp, Function,\n          Date, Node, Element, Document, Window, Event\n      </li>\n    <ul>\n  </td></tr>\n  <tr><th>init</th><td>var</td><td>\n    Sets the default/initial value of the property. If no property value is set or the property\n    gets reset, the getter will return the <code>init</code> value.\n  </td></tr>\n  <tr><th>apply</th><td>String</td><td>\n    On change of the property value the method of the specified name will be called. The signature of\n    the method is <code>function(newValue, oldValue, propertyName)</code>. It is conventional to name\n    the callback <code>_apply</code> + <i>PropertyName</i>, with the property name camel-cased (e.g.\n    \"<i>_applyFooBar</i>\" for a property <i>fooBar</i>).\n  </td></tr>\n  <tr><th>event</th><td>String</td><td>\n    On change of the property value an event with the given name will be dispatched. The event type is\n    {@link qx.event.type.Data}.\n  </td></tr>\n  <tr><th>themeable</th><td>Boolean</td><td>\n    Whether this property can be set using themes.\n  </td></tr>\n  <tr><th>inheritable</th><td>Boolean</td><td>\n    Whether the property value should be inheritable. If the property does not have an user defined or an\n    init value, the property will try to get the value from the parent of the current object.\n  </td></tr>\n  <tr><th>nullable</th><td>Boolean</td><td>\n    Whether <code>null</code> is an allowed value of the property. This is complementary to the check\n    defined using the <code>check</code> key.\n  </td></tr>\n  <tr><th>refine</th><td>Boolean</td><td>\n    Whether the property definition is a refinement of a property in one of the super classes of the class.\n    Only the <code>init</code> value can be changed using refine.\n  </td></tr>\n  <tr><th>transform</th><td>String</td><td>\n    On setting of the property value the method of the specified name will\n    be called. The signature of the method is <code>function(value)</code>.\n    The parameter <code>value</code> is the value passed to the setter.\n    The function must return the modified or unmodified value.\n    Transformation occurs before the check function, so both may be\n    specified if desired.  Alternatively, the transform function may throw\n    an error if the value passed to it is invalid.\n  </td></tr>\n  <tr><th>validate</th><td>Function, String</td><td>\n    On setting of the property value the method of the specified name will\n    be called. The signature of the method is <code>function(value)</code>.\n    The parameter <code>value</code> is the value passed to the setter.\n    If the validation fails, an <code>qx.core.ValidationError</code> should\n    be thrown by the validation function. Otherwise, just do nothing in the\n    function.\n\n<p>If a string is given, the string should hold a reference to a member\n    method.</p>\n\n<code>\"<i>methodname</i>\"</code> for example\n    <code>\"__validateProperty\"</code>\n\n<p>There are some default validators in the {@link qx.util.Validate} class.\n    See this documentation for usage examples.\n  </td></tr>\n  <tr><th>dereference</th><td>Boolean</td><td>\n    By default, the references to the values (current, init, ...) of the\n    property will be stored as references on the object. When disposing\n    this object, the references will not be deleted. Setting the\n    dereference key to true tells the property system to delete all\n    connections made by this property on dispose. This can be necessary for\n    disconnecting <span class=\"caps\">DOM</span> objects to allow the garbage collector to work\n    properly.\n  </td></tr>\n  <tr><th>deferredInit</th><td>Boolean</td><td>\n    Allow for a deferred initialization for reference types. Defaults to false.\n  </td></tr>\n</table></p>\n\n<p><strong>Property groups</strong></p>\n\n<p>Property groups are defined in a similar way but support a different set of keys:</p>\n\n<table>\n  <tr><th>Name</th><th>Type</th><th>Description</th></tr>\n  <tr><th>group</th><td>String[]</td><td>\n    A list of property names which should be set using the property group.\n  </td></tr>\n  <tr><th>mode</th><td>String</td><td>\n    If mode is set to <code>\"shorthand\"</code>, the properties can be set using a CSS like shorthand mode.\n  </td></tr>\n  <tr><th>themeable</th><td>Boolean</td><td>\n    Whether this property can be set using themes.\n  </td></tr>\n</table>","__attachGroupMethods":{"!doc":"<p>Attach group methods</p>","!type":"fn(clazz: +Class, config: +Map, name: string)"},"__attachPropertyMethods":{"!doc":"<p>Attach property methods</p>","!type":"fn(clazz: +Class, config: +Map, name: string)"},"__createRefresher":{"!doc":"<p>Assemble the refresher code and return the generated function</p>","!type":"fn(inheritables: string) -> fn()"},"__emitCallCallback":{"!doc":"<p>Emit code to call the apply method and fire the change event</p>","!type":"fn(code: string, config: Object, name: string, variant: string)"},"__emitIncomingValueTransformation":{"!doc":"<p>Emit code to apply the &#8220;validate&#8221; and &#8220;transform&#8221; config keys.</p>","!type":"fn(code: string, clazz: +Class, config: Object, name: string)"},"__emitIncomingValueValidation":{"!doc":"<p>Emit code, which performs validation of the incoming value according to\nthe &#8220;nullable&#8221;, &#8220;check&#8221; and &#8220;inheritable&#8221; config keys.</p>","!type":"fn(code: string, config: Object, clazz: +Class, name: string, variant: string)"},"__emitNormalizeUndefinedValues":{"!doc":"<p>Emit code to normalize the old and incoming values from undefined to\n<code>null</code>.</p>","!type":"fn(code: string, config: Object, name: string, variant: string)"},"__emitOldNewComparison":{"!doc":"<p>Emit code, which returns if the incoming value equals the current value.</p>","!type":"fn(code: string, incomingValue: bool, store: Object, variant: string)"},"__emitRefreshChildrenValue":{"!doc":"<p>Emit code to update the inherited values of child objects</p>","!type":"fn(code: string, name: string)"},"__emitSetterPreConditions":{"!doc":"<p>Emit code to check the arguments pre-conditions</p>","!type":"fn(code: string, config: Object, name: string, variant: string, incomingValue: bool)"},"__emitStoreComputedAndOldValue":{"!doc":"<p>Emit code to store the incoming value and compute the &#8220;old&#8221; and &#8220;computed&#8221;\nvalues.</p>","!type":"fn(code: string, config: Object, name: string, variant: string, incomingValue: bool)"},"__emitStoreInheritedPropertyValue":{"!doc":"<p>Emit code to store the value of an inheritable property</p>","!type":"fn(code: string, config: Object, name: string, variant: string)"},"__emitStoreValue":{"!doc":"<p>Emit code to store the incoming value</p>","!type":"fn(code: string, name: string, variant: string, incomingValue: bool)"},"__executeOptimizedRefresh":{"!doc":"<p>Generate optimized refresh method and  attach it to the class&#8217; prototype</p>","!type":"fn(clazz: +Class)"},"__gatherDependency":{"!doc":"<p>This is a method which does nothing than gethering dependencies for the\nmodule system. Calling this method is useless because it does nothing.</p>","!type":"fn()"},"__getInheritablesOfClass":{"!doc":"<p>Get the names of all inheritable properties of the given class</p>","!type":"fn(clazz: +Class) -> string"},"__getStore":{"!doc":"<p>Get the object to store the value for the given variant</p>","!type":"fn(variant: string, name: string) -> Object"},"__shouldBeDereferenced":{"!doc":"<p>Returns if the reference for the given property check should be removed\non dispose.</p>","!type":"fn(check: Object) -> bool"},"__unwrapFunctionFromCode":{"!doc":"<p>Compiles a string builder object to a function, executes the function and\nreturns the return value.</p>","!type":"fn(instance: Object, members: Object, name: string, variant: string, code: +Array, args: +arguments) -> Object"},"attachMethods":{"!doc":"<p>Attach one property to class</p>","!type":"fn(clazz: +Class, name: string, config: +Map)"},"attachRefreshInheritables":{"!doc":"<p>Attach $refreshInheritables method stub to the given class</p>","!type":"fn(clazz: +Class)"},"error":{"!doc":"<p>Error method used by the property system to report errors.</p>","!type":"fn(obj: +qx.core.Object, id: +Integer, property: string, variant: string, value: Object)"},"executeOptimizedGetter":{"!doc":"<p>Generates the optimized getter\nSupported variants: get</p>","!type":"fn(instance: Object, clazz: +Class, name: string, variant: string) -> Object"},"executeOptimizedSetter":{"!doc":"<p>Generates the optimized setter\nSupported variants: set, reset, init, refresh, style, unstyle</p>","!type":"fn(instance: Object, clazz: +Class, name: string, variant: string, args: +arguments) -> Object"}},"ValidationError":{"!proto":"qx.type.BaseError","!doc":"<p>A validation Error which should be thrown if a validation fails.</p>"},"WindowError":{"!proto":"Error","!doc":"<p>This exception is thrown by the {@link qx.event.GlobalError} handler if a\n<code>window.onerror</code> event occurs in the browser.</p>","!type":"fn()","prototype":{"getLineNumber":{"!doc":"<p>Get the line number where the error was raised</p>","!type":"fn() -> +Integer"},"getUri":{"!doc":"<p>Get the <span class=\"caps\">URI</span> where error was raised</p>","!type":"fn() -> string"},"toString":{"!doc":"<p>Returns the error message.</p>","!type":"fn() -> string"}}}},"data":{"Array":{"!proto":"qx.core.Object","!doc":"<p>The data array is a special array used in the data binding context of\nqooxdoo. It does not extend the native array of JavaScript but its a wrapper\nfor it. All the native methods are included in the implementation and it\nalso fires events if the content or the length of the array changes in\nany way. Also the <code>.length</code> property is available on the array.</p>","!type":"fn()","prototype":{"__updateEventPropagation":{"!doc":"<p>Helper to update the event propagation for a range of items.</p>","!type":"fn(from: number, to: number)"},"__updateLength":{"!doc":"<p>Internal function which updates the length property of the array.\nEvery time the length will be updated, a {@link #changeLength} data\nevent will be fired.</p>","!type":"fn()"},"append":{"!doc":"<p>Append the items of the given array.</p>","!type":"fn(array: +Array)"},"concat":{"!doc":"<p>Concatenates the current and the given array into a new one.</p>","!type":"fn(array: +Array) -> +qx.data.Array"},"contains":{"!doc":"<p>Check if the given item is in the current array.</p>","!type":"fn(item: Object) -> bool"},"copy":{"!doc":"<p>Return a copy of the given arr</p>","!type":"fn() -> +qx.data.Array"},"equals":{"!doc":"<p>Check whether the given array has the same content as this.\nChecks only the equality of the arrays&#8217; content.</p>","!type":"fn(array: +qx.data.Array) -> bool"},"every":{"!doc":"<p>Tests whether every element in the array passes the test implemented by the\nprovided function.</p>","!type":"fn(callback: fn(), self?: Object) -> bool"},"filter":{"!doc":"<p>Creates a new array with all elements that pass the test implemented by\nthe provided function. It returns a new data array instance so make sure\nto think about disposing it.</p>","!type":"fn(callback: fn(), self?: Object) -> +qx.data.Array"},"forEach":{"!doc":"<p>Invokes the given function for every item in the array.</p>","!type":"fn(callback: fn(), context: Object)"},"getAutoDisposeItems":{"!doc":"<p>Returns the (computed) value of the property <code>autoDisposeItems</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #autoDisposeItems}.</p>","!type":"fn() -> Object"},"getItem":{"!doc":"<p>Replacement function for the getting of the array value.\narray<sup class=\"footnote\"><a href=\"#fn0\">0</a></sup> should be array.getItem(0).</p>","!type":"fn(index: number) -> Object"},"getLength":{"!doc":"<p>This method returns the current length stored under .length on each\narray.</p>","!type":"fn() -> number"},"indexOf":{"!doc":"<p>Returns the index of the item in the array. If the item is not in the\narray, -1 will be returned.</p>","!type":"fn(item: Object) -> number"},"initAutoDisposeItems":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>autoDisposeItems</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #autoDisposeItems}.</p>","!type":"fn(value: Object) -> Object"},"insertAfter":{"!doc":"<p>Insert an element into the array after a given item.</p>","!type":"fn(after: Object, item: Object)"},"insertAt":{"!doc":"<p>Insert an element at a given position.</p>","!type":"fn(index: +Integer, item: Object)"},"insertBefore":{"!doc":"<p>Insert an item into the array before a given item.</p>","!type":"fn(before: Object, item: Object)"},"isAutoDisposeItems":{"!doc":"<p>Check whether the (computed) value of the boolean property <code>autoDisposeItems</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #autoDisposeItems}.</p>","!type":"fn() -> bool"},"join":{"!doc":"<p>Returns the array as a string using the given connector string to\nconnect the values.</p>","!type":"fn(connector: string) -> string"},"lastIndexOf":{"!doc":"<p>Returns the last index of the item in the array. If the item is not in the\narray, -1 will be returned.</p>","!type":"fn(item: Object) -> number"},"map":{"!doc":"<p>Creates a new array with the results of calling a provided function on every\nelement in this array. It returns a new data array instance so make sure\nto think about disposing it.</p>","!type":"fn(callback: fn(), self?: Object) -> +qx.data.Array"},"max":{"!doc":"<p>Returns the highest value in the given array.\nSupports numeric values only.</p>","!type":"fn() -> number"},"min":{"!doc":"<p>Returns the lowest value in the array. Supports\nnumeric values only.</p>","!type":"fn() -> number"},"pop":{"!doc":"<p>Removes and returns the last element of the array.\nAn change event will be fired.</p>","!type":"fn() -> Object"},"push":{"!doc":"<p>Adds an element at the end of the array.</p>","!type":"fn(varargs: Object) -> number"},"reduce":{"!doc":"<p>Apply a function against an accumulator and each value of the array\n(from left-to-right) as to reduce it to a single value.</p>","!type":"fn(callback: fn(), initValue?: Object) -> Object"},"reduceRight":{"!doc":"<p>Apply a function against an accumulator and each value of the array\n(from right-to-left) as to reduce it to a single value.</p>","!type":"fn(callback: fn(), initValue?: Object) -> Object"},"remove":{"!doc":"<p>Remove the given item.</p>","!type":"fn(item: Object) -> Object"},"removeAll":{"!doc":"<p>Remove all elements from the array.</p>","!type":"fn() -> +Array"},"removeAt":{"!doc":"<p>Remove an element from the array at the given index.</p>","!type":"fn(index: +Integer) -> Object"},"resetAutoDisposeItems":{"!doc":"<p>Resets the user value of the property <code>autoDisposeItems</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #autoDisposeItems}.</p>","!type":"fn()"},"reverse":{"!doc":"<p>Reverses the order of the array. An change event will be fired.</p>","!type":"fn()"},"setAutoDisposeItems":{"!doc":"<p>Sets the user value of the property <code>autoDisposeItems</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #autoDisposeItems}.</p>","!type":"fn(value: Object) -> Object"},"setItem":{"!doc":"<p>Replacement function for the setting of an array value.\narray<sup class=\"footnote\"><a href=\"#fn0\">0</a></sup> = &#8220;a&#8221; should be array.setItem(0, &#8220;a&#8221;).\nA change event will be fired if the value changes. Setting the same\nvalue again will not lead to a change event.</p>","!type":"fn(index: number, item: Object)"},"shift":{"!doc":"<p>Removes the first element of the array and returns it. An change event\nwill be fired.</p>","!type":"fn() -> Object"},"slice":{"!doc":"<p>Returns a new array based on the range specified by the parameters.</p>","!type":"fn(from: number, to?: number) -> +qx.data.Array"},"some":{"!doc":"<p>Tests whether any element in the array passes the test implemented by the\nprovided function.</p>","!type":"fn(callback: fn(), self?: Object) -> bool"},"sort":{"!doc":"<p>Sorts the array. If a function is given, this will be used to\ncompare the items. <code>changeBubble</code> event will only be fired,\nif sorting result differs from original array.</p>","!type":"fn(func: fn())"},"splice":{"!doc":"<p>Method to remove and add new elements to the array. A change event\nwill be fired for every removal or addition unless the array is\nidentical before and after splicing.</p>","!type":"fn(startIndex: +Integer, amount: +Integer, varargs: Object) -> +qx.data.Array"},"sum":{"!doc":"<p>Returns the sum of all values in the array. Supports\nnumeric values only.</p>","!type":"fn() -> number"},"toArray":{"!doc":"<p>Returns the list data as native array. Beware of the fact that the\ninternal representation will be returnd and any manipulation of that\ncan cause a misbehavior of the array. This method should only be used for\ndebugging purposes.</p>","!type":"fn() -> +Array"},"toggleAutoDisposeItems":{"!doc":"<p>Toggles the (computed) value of the boolean property <code>autoDisposeItems</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #autoDisposeItems}.</p>","!type":"fn() -> bool"},"toString":{"!doc":"<p>Returns the toString of the original Array</p>","!type":"fn() -> string"},"unshift":{"!doc":"<p>Adds the given items to the beginning of the array. For every element,\na change event will be fired.</p>","!type":"fn(varargs: Object) -> +Integer"}}},"controller":{"Form":{"!proto":"qx.core.Object","!doc":"<h2>Form Controller</h2>\n\n<p><strong>General idea</strong></p>\n\n<p>The form controller is responsible for connecting a form with a model. If no\nmodel is given, a model can be created. This created model will fit exactly\nto the given form and can be used for serialization. All the connections\nbetween the form items and the model are handled by an internal\n{@link qx.data.controller.Object}.</p>\n\n<p><strong>Features</strong></p>\n\n<ul>\n<li>Connect a form to a model (bidirectional)</li>\n<li>Create a model for a given form</li>\n</ul>\n\n<p><strong>Usage</strong></p>\n\n<p>The controller only works if both a controller and a model are set.\nCreating a model will automatically set the created model.</p>\n\n<p><strong>Cross reference</strong></p>\n\n<ul>\n<li>If you want to bind single values, use {@link qx.data.controller.Object}</li>\n<li>If you want to bind a list like widget, use {@link qx.data.controller.List}</li>\n<li>If you want to bind a tree widget, use {@link qx.data.controller.Tree}</li>\n</ul>","!type":"fn()","prototype":{"__isModelSelectable":{"!doc":"<p>Returns whether the given item implements\n{@link qx.ui.core.ISingleSelection} and\n{@link qx.ui.form.IModelSelection}.</p>","!type":"fn(item: +qx.ui.form.IForm) -> bool"},"__setUpBinding":{"!doc":"<p>Internal helper for setting up the bindings using\n{@link qx.data.controller.Object#addTarget}. All bindings are set\nup bidirectional.</p>","!type":"fn()"},"__tearDownBinding":{"!doc":"<p>Internal helper for removing all set up bindings using\n{@link qx.data.controller.Object#removeTarget}.</p>","!type":"fn(oldTarget: +qx.ui.form.Form)"},"_applyModel":{"!doc":"<p>Applies changes of the property value of the property <code>model</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #model}.</p>","!type":"fn(value: +qx.core.Object, old: +qx.core.Object)"},"_applyTarget":{"!doc":"<p>Applies changes of the property value of the property <code>target</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #target}.</p>","!type":"fn(value: +qx.ui.form.Form, old: +qx.ui.form.Form)"},"addBindingOptions":{"!doc":"<p>The form controller uses for setting up the bindings the fundamental\nbinding layer, the {@link qx.data.SingleValueBinding}. To achieve a\nbinding in both directions, two bindings are neede. With this method,\nyou have the opportunity to set the options used for the bindings.</p>","!type":"fn(name: string, model2target: +Map, target2model: +Map)"},"createModel":{"!doc":"<p>Creates and sets a model using the {@link qx.data.marshal.Json} object.\nRemember that this method can only work if the form is set. The created\nmodel will fit exactly that form. Changing the form or adding an item to\nthe form will need a new model creation.</p>","!type":"fn(includeBubbleEvents: bool) -> +qx.core.Object"},"getModel":{"!doc":"<p>Returns the (computed) value of the property <code>model</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #model}.</p>","!type":"fn() -> Object"},"getTarget":{"!doc":"<p>Returns the (computed) value of the property <code>target</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #target}.</p>","!type":"fn() -> Object"},"initModel":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>model</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #model}.</p>","!type":"fn(value: Object) -> Object"},"initTarget":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>target</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #target}.</p>","!type":"fn(value: Object) -> Object"},"resetModel":{"!doc":"<p>Resets the user value of the property <code>model</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #model}.</p>","!type":"fn()"},"resetTarget":{"!doc":"<p>Resets the user value of the property <code>target</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #target}.</p>","!type":"fn()"},"setModel":{"!doc":"<p>Sets the user value of the property <code>model</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #model}.</p>","!type":"fn(value: Object) -> Object"},"setTarget":{"!doc":"<p>Sets the user value of the property <code>target</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #target}.</p>","!type":"fn(value: Object) -> Object"},"updateModel":{"!doc":"<p>Responsible for synching the data from entered in the form to the model.\nPlease keep in mind that this method only works if you create the form\nwith <code>selfUpdate</code> set to true. Otherwise, this method will\ndo nothing because updates will be synched automatically on every\nchange.</p>","!type":"fn()"}}},"IControllerDelegate":{"!doc":"<p>Objects, which are used as delegates for a data binding controller may\nimplement any of the methods described in this interface. The delegate does\nnot need implement all of the methods of this interface. If a method is not\nimplemented the controller provides a default implementation.</p>\n\n<p>Note: This interface is meant to document the delegate but should not be\nlisted in the <code>implement</code> key of a class unless all methods are\nreally implemented.</p>","prototype":{"bindItem":{"!doc":"<p>Sets up the binding for the given item and index.</p>\n\n<p>For every property you want to bind, use\n{@link qx.data.controller.List#bindProperty} like this:\n<code>\ncontroller.bindProperty(&#8220;path.in.the.model&#8221;, &#8220;label&#8221;, options, item, id);\n</code></p>","!type":"fn(controller: Object, item: +qx.ui.core.Widget, id: Object)"},"configureItem":{"!doc":"<p>Gives the user the opportunity to set individual styles and properties\non the by the controller created widgets.</p>","!type":"fn(item: Object)"},"createItem":{"!doc":"<p>Creates an item which will be added to the target as child. Be sure to\nimplement the {@link #bindItem} function as well to get the needed\nproperties bound.</p>","!type":"fn() -> +qx.ui.core.Widget"},"filter":{"!doc":"<p>Filter checks the current data and returns a boolean if the data should\nappear in the filtered data set or not.</p>\n\n<p>The filter currently works only with the {@link qx.data.controller.List}\ncontroller!</p>","!type":"fn(data: Object) -> bool"}}},"ISelection":{"!doc":"<p>Interface for data binding classes offering a selection.</p>","prototype":{"getSelection":{"!doc":"<p>Getter for the selection list.</p>","!type":"fn() -> +qx.data.IListData"},"resetSelection":{"!doc":"<p>Resets the selection to its default value.</p>","!type":"fn()"},"setSelection":{"!doc":"<p>Setter for the selection.</p>","!type":"fn(value: +qx.data.IListData)"}}},"List":{"!proto":"qx.core.Object","!doc":"<h2>List Controller</h2>\n\n<p><strong>General idea</strong>\nThe list controller is responsible for synchronizing every list like widget\nwith a data array. It does not matter if the array contains atomic values\nlike strings of complete objects where one property holds the value for\nthe label and another property holds the icon url. You can even use converters\nthat make the label show a text corresponding to the icon, by binding both\nlabel and icon to the same model property and converting one of them.</p>\n\n<p><strong>Features</strong></p>\n\n<ul>\n<li>Synchronize the model and the target</li>\n<li>Label and icon are bindable</li>\n<li>Takes care of the selection</li>\n<li>Passes on the options used by {@link qx.data.SingleValueBinding#bind}</li>\n</ul>\n\n<p><strong>Usage</strong></p>\n\n<p>As model, only {@link qx.data.Array}s do work. The currently supported\ntargets are</p>\n\n<ul>\n<li>{@link qx.ui.form.SelectBox}</li>\n<li>{@link qx.ui.form.List}</li>\n<li>{@link qx.ui.form.ComboBox}</li>\n</ul>\n\n<p>All the properties like model, target or any property path is bindable.\nEspecially the model is nice to bind to another selection for example.\nThe controller itself can only work if it has a model and a target set. The\nrest of the properties may be empty.</p>\n\n<p><strong>Cross reference</strong></p>\n\n<ul>\n<li>If you want to bind single values, use {@link qx.data.controller.Object}</li>\n<li>If you want to bind a tree widget, use {@link qx.data.controller.Tree}</li>\n<li>If you want to bind a form widget, use {@link qx.data.controller.Form}</li>\n</ul>","!type":"fn()","prototype":{"__addItem":{"!doc":"<p>Internal helper to add ListItems to the target including the creation\nof the binding.</p>","!type":"fn(index: number)"},"__buildUpLookupTable":{"!doc":"<p>Helper-Method which builds up the index lookup for the filter feature.\nIf no filter is set, the lookup table will be a 1:1 mapping.</p>","!type":"fn()"},"__changeModel":{"!doc":"<p>Event handler for the change event of the model. If the model changes,\nOnly the selection needs to be changed. The change of the data will\nbe done by the binding.</p>","!type":"fn()"},"__changeModelLength":{"!doc":"<p>Event handler for the changeLength of the model. If the length changes\nof the model, either ListItems need to be removed or added to the target.</p>","!type":"fn()"},"__lookup":{"!doc":"<p>Function for accessing the lookup table.</p>","!type":"fn(index: +Integer) -> number"},"__moveChangeListenerAtTheEnd":{"!doc":"<p>Helper method which removes and adds the change listener of the\ncontroller to the model. This is sometimes necessary to ensure that the\nlistener of the controller is executed as the last listener of the chain.</p>","!type":"fn()"},"__removeFilter":{"!doc":"<p>This helper is responsible for removing the filter and setting the\ncontroller to a valid state without a filtering.</p>","!type":"fn()"},"__removeItem":{"!doc":"<p>Internal helper to remove ListItems from the target. Also the binding\nwill be removed properly.</p>","!type":"fn()"},"__renewBindings":{"!doc":"<p>Internal helper method to renew all set bindings.</p>","!type":"fn()"},"_applyDelegate":{"!doc":"<p>If a new delegate is set, it applies the stored configuration for the\nlist items to the already created list items once.</p>","!type":"fn(value: +qx.core.Object, old: +qx.core.Object)"},"_applyIconOptions":{"!doc":"<p>Apply-method which will be called if the icon options has been changed.\nIt invokes a renewing of all set bindings.</p>","!type":"fn(value: +Map, old: +Map)"},"_applyIconPath":{"!doc":"<p>Apply-method which will be called if the icon path has been changed.\nIt invokes a renewing of all set bindings.</p>","!type":"fn(value: string, old: string)"},"_applyLabelOptions":{"!doc":"<p>Apply-method which will be called if the label options has been changed.\nIt invokes a renewing of all set bindings.</p>","!type":"fn(value: +Map, old: +Map)"},"_applyLabelPath":{"!doc":"<p>Apply-method which will be called if the label path has been changed.\nIt invokes a renewing of all set bindings.</p>","!type":"fn(value: string, old: string)"},"_applyModel":{"!doc":"<p>Apply-method which will be called if the model has been changed. It\nremoves all the listeners from the old model and adds the needed\nlisteners to the new model. It also invokes the initial filling of the\ntarget widgets if there is a target set.</p>","!type":"fn(value: +qx.data.Array, old: +qx.data.Array)"},"_applyTarget":{"!doc":"<p>Apply-method which will be called if the target has been changed.\nWhen the target changes, every binding needs to be reset and the old\ntarget needs to be cleaned up. If there is a model, the target will be\nfilled with the data of the model.</p>","!type":"fn(value: +qx.ui.core.Widget, old: +qx.ui.core.Widget)"},"_bindListItem":{"!doc":"<p>Sets up the binding for the given ListItem and index.</p>","!type":"fn(item: +qx.ui.form.ListItem, index: number)"},"_createItem":{"!doc":"<p>Creates a ListItem and delegates the configure method if a delegate is\nset and the needed function (configureItem) is available.</p>","!type":"fn() -> +qx.ui.form.ListItem"},"_onBindingSet":{"!doc":"<p>Method which will be called on the invoke of every binding. It takes\ncare of the selection on the change of the binding.</p>","!type":"fn(index: number, sourceObject: +qx.core.Object, targetObject: +qx.core.Object)"},"_removeBindingsFrom":{"!doc":"<p>Internal helper method to remove the binding of the given item.</p>","!type":"fn(item: number)"},"_setBindItem":{"!doc":"<p>Helper method for applying the delegate It checks if a bindItem\nis set end invokes the initial process to apply the given function.</p>","!type":"fn(value: Object, old: Object)"},"_setConfigureItem":{"!doc":"<p>Helper method for applying the delegate It checks if a configureItem\nis set end invokes the initial process to apply the given function.</p>","!type":"fn(value: Object, old: Object)"},"_setCreateItem":{"!doc":"<p>Helper method for applying the delegate It checks if a createItem\nis set end invokes the initial process to apply the given function.</p>","!type":"fn(value: Object, old: Object)"},"_setFilter":{"!doc":"<p>Apply-Method for setting the filter. It removes all bindings,\ncheck if the length has changed and adds or removes the items in the\ntarget. After that, the bindings will be set up again and the selection\nwill be updated.</p>","!type":"fn(value: fn(), old: fn())"},"bindDefaultProperties":{"!doc":"<p>Helper-Method for binding the default properties (label, icon and model)\nfrom the model to the target widget.</p>\n\n<p>This method should only be called in the\n{@link qx.data.controller.IControllerDelegate#bindItem} function\nimplemented by the {@link #delegate} property.</p>","!type":"fn(item: +qx.ui.form.ListItem, index: number)"},"bindProperty":{"!doc":"<p>Helper-Method for binding a given property from the model to the target\nwidget.\nThis method should only be called in the\n{@link qx.data.controller.IControllerDelegate#bindItem} function\nimplemented by the {@link #delegate} property.</p>","!type":"fn(sourcePath: string, targetProperty: string, options: +Map, targetWidget: +qx.ui.core.Widget, index: number)"},"bindPropertyReverse":{"!doc":"<p>Helper-Method for binding a given property from the target widget to\nthe model.\nThis method should only be called in the\n{@link qx.data.controller.IControllerDelegate#bindItem} function\nimplemented by the {@link #delegate} property.</p>","!type":"fn(targetPath: string, sourcePath: string, options: +Map, sourceWidget: +qx.ui.core.Widget, index: number)"},"getDelegate":{"!doc":"<p>Returns the (computed) value of the property <code>delegate</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #delegate}.</p>","!type":"fn() -> Object"},"getIconOptions":{"!doc":"<p>Returns the (computed) value of the property <code>iconOptions</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #iconOptions}.</p>","!type":"fn() -> Object"},"getIconPath":{"!doc":"<p>Returns the (computed) value of the property <code>iconPath</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #iconPath}.</p>","!type":"fn() -> Object"},"getLabelOptions":{"!doc":"<p>Returns the (computed) value of the property <code>labelOptions</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #labelOptions}.</p>","!type":"fn() -> Object"},"getLabelPath":{"!doc":"<p>Returns the (computed) value of the property <code>labelPath</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #labelPath}.</p>","!type":"fn() -> Object"},"getModel":{"!doc":"<p>Returns the (computed) value of the property <code>model</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #model}.</p>","!type":"fn() -> Object"},"getTarget":{"!doc":"<p>Returns the (computed) value of the property <code>target</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #target}.</p>","!type":"fn() -> Object"},"getVisibleModels":{"!doc":"<p>Returns all models currently visible by the list. This method is only\nuseful if you use the filter via the {@link #delegate}.</p>","!type":"fn() -> +qx.data.Array"},"initDelegate":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>delegate</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #delegate}.</p>","!type":"fn(value: Object) -> Object"},"initIconOptions":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>iconOptions</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #iconOptions}.</p>","!type":"fn(value: Object) -> Object"},"initIconPath":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>iconPath</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #iconPath}.</p>","!type":"fn(value: Object) -> Object"},"initLabelOptions":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>labelOptions</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #labelOptions}.</p>","!type":"fn(value: Object) -> Object"},"initLabelPath":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>labelPath</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #labelPath}.</p>","!type":"fn(value: Object) -> Object"},"initModel":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>model</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #model}.</p>","!type":"fn(value: Object) -> Object"},"initTarget":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>target</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #target}.</p>","!type":"fn(value: Object) -> Object"},"resetDelegate":{"!doc":"<p>Resets the user value of the property <code>delegate</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #delegate}.</p>","!type":"fn()"},"resetIconOptions":{"!doc":"<p>Resets the user value of the property <code>iconOptions</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #iconOptions}.</p>","!type":"fn()"},"resetIconPath":{"!doc":"<p>Resets the user value of the property <code>iconPath</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #iconPath}.</p>","!type":"fn()"},"resetLabelOptions":{"!doc":"<p>Resets the user value of the property <code>labelOptions</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #labelOptions}.</p>","!type":"fn()"},"resetLabelPath":{"!doc":"<p>Resets the user value of the property <code>labelPath</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #labelPath}.</p>","!type":"fn()"},"resetModel":{"!doc":"<p>Resets the user value of the property <code>model</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #model}.</p>","!type":"fn()"},"resetTarget":{"!doc":"<p>Resets the user value of the property <code>target</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #target}.</p>","!type":"fn()"},"setDelegate":{"!doc":"<p>Sets the user value of the property <code>delegate</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #delegate}.</p>","!type":"fn(value: Object) -> Object"},"setIconOptions":{"!doc":"<p>Sets the user value of the property <code>iconOptions</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #iconOptions}.</p>","!type":"fn(value: Object) -> Object"},"setIconPath":{"!doc":"<p>Sets the user value of the property <code>iconPath</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #iconPath}.</p>","!type":"fn(value: Object) -> Object"},"setLabelOptions":{"!doc":"<p>Sets the user value of the property <code>labelOptions</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #labelOptions}.</p>","!type":"fn(value: Object) -> Object"},"setLabelPath":{"!doc":"<p>Sets the user value of the property <code>labelPath</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #labelPath}.</p>","!type":"fn(value: Object) -> Object"},"setModel":{"!doc":"<p>Sets the user value of the property <code>model</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #model}.</p>","!type":"fn(value: Object) -> Object"},"setTarget":{"!doc":"<p>Sets the user value of the property <code>target</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #target}.</p>","!type":"fn(value: Object) -> Object"},"syncWidget":{"!doc":"<p>Internal method used to sync the selection. The controller uses the\nwidget queue to schedule the selection update. An asynchronous handling of\nthe selection is needed because the bindings (event listeners for the\nbinding) need to be executed before the selection is updated.</p>","!type":"fn()"},"update":{"!doc":"<p>Updates the filter and the target. This could be used if the filter\nuses an additional parameter which changes the filter result.</p>","!type":"fn()"}}},"MSelection":{"!doc":"<p>Mixin for the selection in the data binding controller.\nIt contains an selection property which can be manipulated.\nRemember to call the method {@link #_addChangeTargetListener} on every\nchange of the target.\nIt is also important that the elements stored in the target e.g. ListItems\ndo have the corresponding model stored as user data under the &#8220;model&#8221; key.</p>","!type":"fn()","prototype":{"__changeSelectionArray":{"!doc":"<p>Event handler for the change of the data array holding the selection.\nIf a change is in the selection array, the selection update will be\ninvoked.</p>","!type":"fn()"},"__getSelectableForModel":{"!doc":"<p>Returns the list item storing the given model in its model property.</p>","!type":"fn(model: Object) -> Object"},"__selectItem":{"!doc":"<p>Internal helper for selecting an item in the target. The item to select\nis defined by a given model item.</p>","!type":"fn(item: +qx.core.Object)"},"__targetSupportsMultiSelection":{"!doc":"<p>Helper-method returning true, if the target supports multi selection.</p>","!type":"fn() -> bool"},"__targetSupportsSingleSelection":{"!doc":"<p>Helper-method returning true, if the target supports single selection.</p>","!type":"fn() -> bool"},"_addChangeTargetListener":{"!doc":"<p>Helper method which should be called by the classes including this\nMixin when the target changes.</p>","!type":"fn(value: +qx.ui.core.Widget, old: +qx.ui.core.Widget)"},"_applySelection":{"!doc":"<p>Apply-method for setting a new selection array. Only the change listener\nwill be removed from the old array and added to the new.</p>","!type":"fn(value: +qx.data.Array, old: +qx.data.Array)"},"_changeTargetSelection":{"!doc":"<p>Event handler for a change in the target selection.\nIf the selection in the target has changed, the selected model objects\nwill be found and added to the selection array.</p>","!type":"fn()"},"_endSelectionModification":{"!doc":"<p>Helper-Method signaling that the internal changing of the targets\nselection is over.\n{@link #_startSelectionModification}</p>","!type":"fn()"},"_inSelectionModification":{"!doc":"<p>Helper-Method for checking the state of the selection modification.\n{@link #_startSelectionModification}\n{@link #_endSelectionModification}</p>","!type":"fn() -> bool"},"_startSelectionModification":{"!doc":"<p>Helper-Method signaling that currently the selection of the target is\nin change. That will block the change of the internal selection.\n{@link #_endSelectionModification}</p>","!type":"fn()"},"_updateSelection":{"!doc":"<p>Method for updating the selection. It checks for the case of single or\nmulti selection and after that checks if the selection in the selection\narray is the same as in the target widget.</p>","!type":"fn()"},"getSelection":{"!doc":"<p>Returns the (computed) value of the property <code>selection</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #selection}.</p>","!type":"fn() -> Object"},"initSelection":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>selection</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #selection}.</p>","!type":"fn(value: Object) -> Object"},"resetSelection":{"!doc":"<p>Resets the user value of the property <code>selection</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #selection}.</p>","!type":"fn()"},"setSelection":{"!doc":"<p>Sets the user value of the property <code>selection</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #selection}.</p>","!type":"fn(value: Object) -> Object"}}},"Object":{"!proto":"qx.core.Object","!doc":"<h2>Object Controller</h2>\n\n<p><strong>General idea</strong></p>\n\n<p>The idea of the object controller is to make the binding of one model object\ncontaining one or more properties as easy as possible. Therefore the\ncontroller can take a model as property. Every property in that model can be\nbound to one or more target properties. The binding will be for\natomic types only like Numbers, Strings, ...</p>\n\n<p><strong>Features</strong></p>\n\n<ul>\n<li>Manages the bindings between the model properties and the different targets</li>\n<li>No need for the user to take care of the binding ids</li>\n<li>Can create an bidirectional binding (read- / write-binding)</li>\n<li>Handles the change of the model which means adding the old targets</li>\n</ul>\n\n<p><strong>Usage</strong></p>\n\n<p>The controller only can work if a model is set. If the model property is\nnull, the controller is not working. But it can be null on any time.</p>\n\n<p><strong>Cross reference</strong></p>\n\n<ul>\n<li>If you want to bind a list like widget, use {@link qx.data.controller.List}</li>\n<li>If you want to bind a tree widget, use {@link qx.data.controller.Tree}</li>\n<li>If you want to bind a form widget, use {@link qx.data.controller.Form}</li>\n</ul>","!type":"fn()","prototype":{"__addTarget":{"!doc":"<p>Does the work for {@link #addTarget} but without saving the target\nto the internal target registry.</p>","!type":"fn(targetObject: +qx.core.Object, targetProperty: string, sourceProperty: string, bidirectional?: bool, options?: +Map, reverseOptions?: +Map)"},"__removeTargetFrom":{"!doc":"<p>Does the work for {@link #removeTarget} but without removing the target\nfrom the internal registry.</p>","!type":"fn(targetObject: +qx.core.Object, targetProperty: string, sourceProperty: string, sourceObject: string)"},"_applyModel":{"!doc":"<p>Apply-method which will be called if a new model has been set.\nAll bindings will be moved to the new model.</p>","!type":"fn(value: +qx.core.Object, old: +qx.core.Object)"},"addTarget":{"!doc":"<p>Adds a new target to the controller. After adding the target, the given\nproperty of the model will be bound to the targets property.</p>","!type":"fn(targetObject: +qx.core.Object, targetProperty: string, sourceProperty: string, bidirectional?: bool, options?: +Map, reverseOptions?: +Map)"},"getModel":{"!doc":"<p>Returns the (computed) value of the property <code>model</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #model}.</p>","!type":"fn() -> Object"},"initModel":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>model</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #model}.</p>","!type":"fn(value: Object) -> Object"},"removeTarget":{"!doc":"<p>Removes the target identified by the three properties.</p>","!type":"fn(targetObject: +qx.core.Object, targetProperty: string, sourceProperty: string)"},"resetModel":{"!doc":"<p>Resets the user value of the property <code>model</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #model}.</p>","!type":"fn()"},"setModel":{"!doc":"<p>Sets the user value of the property <code>model</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #model}.</p>","!type":"fn(value: Object) -> Object"}}},"Tree":{"!proto":"qx.core.Object","!doc":"<h2>Tree Controller</h2>\n\n<p><strong>General idea</strong></p>\n\n<p>The tree controller is the controller made for the {@link qx.ui.tree.Tree}\nwidget in qooxdoo. Therefore, it is responsible for creating and adding the\ntree folders to the tree given as target.</p>\n\n<p><strong>Features</strong></p>\n\n<ul>\n<li>Synchronize the model and the target</li>\n<li>Label and icon are bindable</li>\n<li>Takes care of the selection</li>\n<li>Passes on the options used by {@link qx.data.SingleValueBinding#bind}</li>\n</ul>\n\n<p><strong>Usage</strong></p>\n\n<p>As model, you can use every qooxdoo widget structure having one property,\nwhich is a data array holding the children of the current node. There can\nbe as many additional as you like.\nYou need to specify a model, a target, a child path and a label path to\nmake the controller work.</p>\n\n<p><strong>Cross reference</strong></p>\n\n<ul>\n<li>If you want to bind single values, use {@link qx.data.controller.Object}</li>\n<li>If you want to bind a list like widget, use {@link qx.data.controller.List}</li>\n<li>If you want to bin a form widget, use {@link qx.data.controller.Form}</li>\n</ul>","!type":"fn()","prototype":{"__addBinding":{"!doc":"<p>Internal helper method adding the right bindings from the given\nmodelNode to the given treeNode.</p>","!type":"fn(modelNode: +qx.core.Object, treeNode: +qx.ui.tree.TreeFolder)"},"__buildTree":{"!doc":"<p>Internal helper function to build up the tree corresponding to the data\nstored in the model. This function creates the root node and hands the\nrecursive creation of all subtrees to the {#__updateTreeChildren}\nfunction.</p>","!type":"fn()"},"__changeChildrenArray":{"!doc":"<p>Handler function taking care of the changes of the children array itself.</p>","!type":"fn(e: +qx.event.type.Data)"},"__changeModelChildren":{"!doc":"<p>Handler function handling the change of a length of a children array.\nThis method invokes a rebuild of the corresponding subtree.</p>","!type":"fn(ev: +qx.event.type.Event)"},"__emptyTarget":{"!doc":"<p>Removes all folders and bindings for the current set target.</p>","!type":"fn(tree: +qx.ui.tree.Tree)"},"__removeAllFolders":{"!doc":"<p>Removes all child folders of the given tree node. Also removes all\nbindings for the removed folders.</p>","!type":"fn(node: +qx.ui.tree.core.AbstractTreeItem)"},"__removeBinding":{"!doc":"<p>Internal helper method for removing bindings for a given model node.</p>","!type":"fn(modelNode: +qx.core.Object)"},"__removeFolder":{"!doc":"<p>Internal helper method removing the given folder form the given root\nnode. All set bindings will be removed and the old tree folder will be\ndestroyed.</p>","!type":"fn(treeFolder: +qx.ui.tree.core.AbstractTreeItem, rootNode: +qx.ui.tree.core.AbstractTreeItem)"},"__renewBindings":{"!doc":"<p>Helper method renewing all bindings with the currently saved options and\npaths.</p>","!type":"fn()"},"__updateTreeChildren":{"!doc":"<p>Main method building up the tree folders corresponding to the given\nmodel node. The new created subtree will be added to the given tree node.</p>","!type":"fn(rootNode: +qx.ui.tree.TreeFolder, modelNode: +qx.core.Object)"},"_applyChildPath":{"!doc":"<p>Apply-method which will be called after the child path had been\nchanged. This method invoke a new building of the tree.</p>","!type":"fn(value: string, old: string)"},"_applyDelegate":{"!doc":"<p>If a new delegate is set, it applies the stored configuration for the\ntree folder to the already created folders once.</p>","!type":"fn(value: +qx.core.Object, old: +qx.core.Object)"},"_applyIconOptions":{"!doc":"<p>Apply-method which will be called after the icon options had been\nchanged. This method will invoke a renewing of all bindings.</p>","!type":"fn(value: +Map, old: +Map)"},"_applyIconPath":{"!doc":"<p>Apply-method which will be called after the icon path had been\nchanged. This method invoke a new building of the tree.</p>","!type":"fn(value: string, old: string)"},"_applyLabelOptions":{"!doc":"<p>Apply-method which will be called after the label options had been\nchanged. This method will invoke a renewing of all bindings.</p>","!type":"fn(value: +Map, old: +Map)"},"_applyLabelPath":{"!doc":"<p>Apply-method which will be called after the label path had been\nchanged. This method invoke a new building of the tree.</p>","!type":"fn(value: string, old: string)"},"_applyModel":{"!doc":"<p>Apply-method which will be called after the model had been\nchanged. This method invoke a new building of the tree.</p>","!type":"fn(value: +qx.core.Object, old: +qx.core.Object)"},"_applyTarget":{"!doc":"<p>Apply-method which will be called after the target had been\nchanged. This method will clean up the old tree and will initially\nbuild up the new tree containing the data from the model.</p>","!type":"fn(value: +qx.ui.tree.Tree, old: +qx.ui.tree.Tree)"},"_createItem":{"!doc":"<p>Creates a TreeFolder and delegates the configure method if a delegate is\nset and the needed function (configureItem) is available.</p>","!type":"fn() -> +qx.ui.tree.core.AbstractTreeItem"},"_setBindItem":{"!doc":"<p>Helper method for applying the delegate It checks if a bindItem\nis set end invokes the initial process to apply the given function.</p>","!type":"fn(value: Object, old: Object)"},"_setConfigureItem":{"!doc":"<p>Helper method for applying the delegate It checks if a configureItem\nis set end invokes the initial process to apply the given function.</p>","!type":"fn(value: Object, old: Object)"},"_setCreateItem":{"!doc":"<p>Helper method for applying the delegate. It checks if a createItem\nis set and invokes the initial process to apply the given function.</p>","!type":"fn(value: Object, old: Object)"},"bindDefaultProperties":{"!doc":"<p>Helper method for binding the default properties (label and icon) from\nthe model to the target widget.</p>\n\n<p>This method should only be called in the\n{@link qx.data.controller.IControllerDelegate#bindItem} function\nimplemented by the {@link #delegate} property.</p>","!type":"fn(treeNode: +qx.ui.tree.core.AbstractTreeItem, modelNode: +qx.core.Object)"},"bindProperty":{"!doc":"<p>Helper method for binding a given property from the model to the target\nwidget.\nThis method should only be called in the\n{@link qx.data.controller.IControllerDelegate#bindItem} function\nimplemented by the {@link #delegate} property.</p>","!type":"fn(sourcePath: string, targetPath: string, options: +Map, targetWidget: +qx.ui.tree.core.AbstractTreeItem, modelNode: Object)"},"bindPropertyReverse":{"!doc":"<p>Helper method for binding a given property from the target widget to\nthe model.\nThis method should only be called in the\n{@link qx.data.controller.IControllerDelegate#bindItem} function\nimplemented by the {@link #delegate} property.</p>","!type":"fn(targetPath: string, sourcePath: string, options: +Map, sourceWidget: +qx.ui.tree.core.AbstractTreeItem, modelNode: Object)"},"getChildPath":{"!doc":"<p>Returns the (computed) value of the property <code>childPath</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #childPath}.</p>","!type":"fn() -> Object"},"getDelegate":{"!doc":"<p>Returns the (computed) value of the property <code>delegate</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #delegate}.</p>","!type":"fn() -> Object"},"getIconOptions":{"!doc":"<p>Returns the (computed) value of the property <code>iconOptions</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #iconOptions}.</p>","!type":"fn() -> Object"},"getIconPath":{"!doc":"<p>Returns the (computed) value of the property <code>iconPath</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #iconPath}.</p>","!type":"fn() -> Object"},"getLabelOptions":{"!doc":"<p>Returns the (computed) value of the property <code>labelOptions</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #labelOptions}.</p>","!type":"fn() -> Object"},"getLabelPath":{"!doc":"<p>Returns the (computed) value of the property <code>labelPath</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #labelPath}.</p>","!type":"fn() -> Object"},"getModel":{"!doc":"<p>Returns the (computed) value of the property <code>model</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #model}.</p>","!type":"fn() -> Object"},"getTarget":{"!doc":"<p>Returns the (computed) value of the property <code>target</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #target}.</p>","!type":"fn() -> Object"},"initChildPath":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>childPath</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #childPath}.</p>","!type":"fn(value: Object) -> Object"},"initDelegate":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>delegate</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #delegate}.</p>","!type":"fn(value: Object) -> Object"},"initIconOptions":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>iconOptions</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #iconOptions}.</p>","!type":"fn(value: Object) -> Object"},"initIconPath":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>iconPath</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #iconPath}.</p>","!type":"fn(value: Object) -> Object"},"initLabelOptions":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>labelOptions</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #labelOptions}.</p>","!type":"fn(value: Object) -> Object"},"initLabelPath":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>labelPath</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #labelPath}.</p>","!type":"fn(value: Object) -> Object"},"initModel":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>model</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #model}.</p>","!type":"fn(value: Object) -> Object"},"initTarget":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>target</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #target}.</p>","!type":"fn(value: Object) -> Object"},"resetChildPath":{"!doc":"<p>Resets the user value of the property <code>childPath</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #childPath}.</p>","!type":"fn()"},"resetDelegate":{"!doc":"<p>Resets the user value of the property <code>delegate</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #delegate}.</p>","!type":"fn()"},"resetIconOptions":{"!doc":"<p>Resets the user value of the property <code>iconOptions</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #iconOptions}.</p>","!type":"fn()"},"resetIconPath":{"!doc":"<p>Resets the user value of the property <code>iconPath</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #iconPath}.</p>","!type":"fn()"},"resetLabelOptions":{"!doc":"<p>Resets the user value of the property <code>labelOptions</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #labelOptions}.</p>","!type":"fn()"},"resetLabelPath":{"!doc":"<p>Resets the user value of the property <code>labelPath</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #labelPath}.</p>","!type":"fn()"},"resetModel":{"!doc":"<p>Resets the user value of the property <code>model</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #model}.</p>","!type":"fn()"},"resetTarget":{"!doc":"<p>Resets the user value of the property <code>target</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #target}.</p>","!type":"fn()"},"setChildPath":{"!doc":"<p>Sets the user value of the property <code>childPath</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #childPath}.</p>","!type":"fn(value: Object) -> Object"},"setDelegate":{"!doc":"<p>Sets the user value of the property <code>delegate</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #delegate}.</p>","!type":"fn(value: Object) -> Object"},"setIconOptions":{"!doc":"<p>Sets the user value of the property <code>iconOptions</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #iconOptions}.</p>","!type":"fn(value: Object) -> Object"},"setIconPath":{"!doc":"<p>Sets the user value of the property <code>iconPath</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #iconPath}.</p>","!type":"fn(value: Object) -> Object"},"setLabelOptions":{"!doc":"<p>Sets the user value of the property <code>labelOptions</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #labelOptions}.</p>","!type":"fn(value: Object) -> Object"},"setLabelPath":{"!doc":"<p>Sets the user value of the property <code>labelPath</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #labelPath}.</p>","!type":"fn(value: Object) -> Object"},"setModel":{"!doc":"<p>Sets the user value of the property <code>model</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #model}.</p>","!type":"fn(value: Object) -> Object"},"setTarget":{"!doc":"<p>Sets the user value of the property <code>target</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #target}.</p>","!type":"fn(value: Object) -> Object"}}},"website":{"List":{"!proto":"qx.core.Object","!doc":"<h2>website List Controller</h2>\n\n<p><strong>General idea</strong>\nThe list controller is responsible for synchronizing data given as model\nto a <span class=\"caps\">DOM</span> element. As definition for a single item, tempaltes are used. More\ndetails on tempaltes can be found in {@link qx.bom.Template}.</p>\n\n<p><strong>Features</strong></p>\n\n<ul>\n<li>Synchronize the model and the target</li>\n<li>Filtering</li>\n</ul>\n\n<p><strong>Usage</strong></p>\n\n<p>As model, {@link qx.data.Array}s and plain JavaScript Arrays work. As a\nTarget, you have to use a <span class=\"caps\">DOM</span> element e.g. a plain <span class=\"caps\">DIV</span> element. Make sure\nyou have the template you are referencing in the <span class=\"caps\">DOM</span>.</p>","!type":"fn()","prototype":{"__emptyTarget":{"!doc":"<p>Responsible for removing all items from the targe element.</p>","!type":"fn()"},"_applyDelegate":{"!doc":"<p>Applies changes of the property value of the property <code>delegate</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #delegate}.</p>","!type":"fn(value: Object, old: Object)"},"_applyModel":{"!doc":"<p>Applies changes of the property value of the property <code>model</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #model}.</p>","!type":"fn(value: +Array, old: +Array)"},"_applyTarget":{"!doc":"<p>Applies changes of the property value of the property <code>target</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #target}.</p>","!type":"fn(value: +Element, old: +Element)"},"_applyTemplateId":{"!doc":"<p>Applies changes of the property value of the property <code>templateId</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #templateId}.</p>","!type":"fn(value: Object, old: Object)"},"getDelegate":{"!doc":"<p>Returns the (computed) value of the property <code>delegate</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #delegate}.</p>","!type":"fn() -> Object"},"getModel":{"!doc":"<p>Returns the (computed) value of the property <code>model</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #model}.</p>","!type":"fn() -> Object"},"getTarget":{"!doc":"<p>Returns the (computed) value of the property <code>target</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #target}.</p>","!type":"fn() -> Object"},"getTemplateId":{"!doc":"<p>Returns the (computed) value of the property <code>templateId</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #templateId}.</p>","!type":"fn() -> Object"},"initDelegate":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>delegate</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #delegate}.</p>","!type":"fn(value: Object) -> Object"},"initModel":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>model</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #model}.</p>","!type":"fn(value: Object) -> Object"},"initTarget":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>target</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #target}.</p>","!type":"fn(value: Object) -> Object"},"initTemplateId":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>templateId</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #templateId}.</p>","!type":"fn(value: Object) -> Object"},"resetDelegate":{"!doc":"<p>Resets the user value of the property <code>delegate</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #delegate}.</p>","!type":"fn()"},"resetModel":{"!doc":"<p>Resets the user value of the property <code>model</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #model}.</p>","!type":"fn()"},"resetTarget":{"!doc":"<p>Resets the user value of the property <code>target</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #target}.</p>","!type":"fn()"},"resetTemplateId":{"!doc":"<p>Resets the user value of the property <code>templateId</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #templateId}.</p>","!type":"fn()"},"setDelegate":{"!doc":"<p>Sets the user value of the property <code>delegate</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #delegate}.</p>","!type":"fn(value: Object) -> Object"},"setModel":{"!doc":"<p>Sets the user value of the property <code>model</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #model}.</p>","!type":"fn(value: Object) -> Object"},"setTarget":{"!doc":"<p>Sets the user value of the property <code>target</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #target}.</p>","!type":"fn(value: Object) -> Object"},"setTemplateId":{"!doc":"<p>Sets the user value of the property <code>templateId</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #templateId}.</p>","!type":"fn(value: Object) -> Object"},"update":{"!doc":"<p>This is the main method which will take the data from the model and\npush it to the target view. If you are using a plain Array as model,\nyou need to call that method every time you want to see the changed model\nin the view while using {@link qx.data.Array}s will do that\nautomatically for you.\nThis method also attaches to every created <span class=\"caps\">DOM</span> element the model object\nwhich was used to create it at <code>.$model</code>.</p>","!type":"fn()"}}}}},"Conversion":{"!doc":"<p>This class offers a set of default conversion methods and whole options\npacks for {@link qx.data.SingleValueBinding}. The binding offers a conversion\nitself if it can determinate which types should be used. In all other cases,\nyou can you this methods / options for the default conversion.</p>","toBoolean":{"!doc":"<p>Converts the given value to a boolean via <code>!!value</code>.</p>","!type":"fn(value: Object) -> bool"},"toNumber":{"!doc":"<p>Converts the given value to a number via <code>parseFloat</code>.</p>","!type":"fn(value: Object) -> number"},"toString":{"!doc":"<p>Converts the given value to a string via <code> + &#8221;&#8221;</code>.</p>","!type":"fn(value: Object) -> string"}},"IListData":{"!doc":"<p>This interface defines a data structure compatible with the data binding\ncontrollers.\nIt defines a minimum of functionality which the controller need to work.</p>","prototype":{"contains":{"!doc":"<p>Check if the given item is in the current data structure.</p>","!type":"fn(item: Object) -> bool"},"getItem":{"!doc":"<p>Returns the item at the given index</p>","!type":"fn(index: number) -> Object"},"getLength":{"!doc":"<p>Returns the current length of the data structure.</p>","!type":"fn() -> number"},"setItem":{"!doc":"<p>Sets the given item at the given position in the data structure. A\nchange event has to be fired.</p>","!type":"fn(index: number, item: Object)"},"splice":{"!doc":"<p>Method to remove and add new element to the data. For every remove or\nadd a change event should be fired.</p>","!type":"fn(startIndex: +Integer, amount: +Integer, varargs: Object) -> +qx.data.Array"},"toArray":{"!doc":"<p>Returns the list data as native array.</p>","!type":"fn() -> +Array"}}},"marshal":{"IMarshaler":{"!doc":"<p>Defines the methods needed by every marshaler which should work with the\nqooxdoo data stores.</p>","prototype":{"toClass":{"!doc":"<p>Creates for the given data the needed classes. The classes contain for\nevery key in the data a property. The classname is always the prefix\n<code>qx.data.model</code>. Two objects containing the same keys will not\ncreate two different classes.</p>","!type":"fn(data: Object, includeBubbleEvents: bool)"},"toModel":{"!doc":"<p>Creates for the given data the needed models. Be sure to have the classes\ncreated with {@link #toClass} before calling this method.</p>","!type":"fn(data: Object) -> +qx.core.Object"}}},"IMarshalerDelegate":{"!doc":"<p>Objects, which are used as delegates for a data binding marshaler may\nimplement any of the methods described in this interface. The delegate does\nnot need implement all of the methods of this interface. If a method is not\nimplemented the marshaler provides a default implementation.</p>\n\n<p>Note: This interface is meant to document the delegate but should not be\nlisted in the <code>implement</code> key of a class unless all methods are\nreally implemented.</p>","prototype":{"getArrayClass":{"!doc":"<p>Returns the array class which should be used by the marshaler. The passed\nparameters can be used to determine the array class. The return array class\nmust implement the {@link qx.data.IListData} interface.</p>","!type":"fn(parentProperty: string, depth: number) -> +Class"},"getModelClass":{"!doc":"<p>Determines the user defined class for the given properties string.\nThis class could contain additional methods but needs to have the\nproperties with the given names. Also every property needs to have a\nchange event.</p>\n\n<p>If this method is implemented, you have to add the superclass and mixins\nyourself to the returned class. This means that the methods\n{@link #getModelSuperClass} and {@link #getModelMixins} will not be\ncalled for the corresponding class.</p>","!type":"fn(properties: string, object: +Map, parentProperty: string, depth: number) -> +Class"},"getModelMixins":{"!doc":"<p>Returns the mixins which should be included to the class, created by the\nmarshaler and identified by the given properties string.</p>","!type":"fn(properties: string, parentProperty: string, depth: number) -> +Array"},"getModelSuperClass":{"!doc":"<p>Returns the class which the created model class uses as superclass.</p>","!type":"fn(properties: string, parentProperty: string, depth: number) -> +Class"},"getPropertyMapping":{"!doc":"<p>Gives the possibility to change the names given in the data to convert\nto something different.</p>","!type":"fn(property: string, properties: string) -> string"},"getValidationRule":{"!doc":"<p>Returns the validation rules which should be added to the created class\nfor the given property. This method will be called for every property.</p>","!type":"fn(properties: string, propertyName: string) -> fn()"},"ignore":{"!doc":"<p>Gives the possibility to ignore parts of the marshaled data and store the\noriginal data.</p>","!type":"fn(properties: string, parentProperty: string, depth: number) -> bool"}}},"Json":{"!proto":"qx.core.Object","!doc":"<p>This class is responsible for converting json data to class instances\nincluding the creation of the classes.</p>","!type":"fn()","createModel":{"!doc":"<p>Creates a qooxdoo object based on the given json data. This function\nis just a static wrapper. If you want to configure the creation\nprocess of the class, use {@link qx.data.marshal.Json} directly.</p>","!type":"fn(data: Object, includeBubbleEvents: bool) -> +qx.core.Object"},"prototype":{"__createInstance":{"!doc":"<p>Creates an instance for the given data hash.</p>","!type":"fn(hash: string, data: +Map, parentProperty: string, depth: number) -> +qx.core.Object"},"__disposeItem":{"!doc":"<p>Helper for disposing items of the created class.</p>","!type":"fn(item: Object)"},"__disposeProperties":{"!doc":"<p>Destructor for all created classes which disposes all stuff stored in\nthe properties.</p>","!type":"fn()"},"__ignore":{"!doc":"<p>Helper to decide if the delegate decides to ignore a data set.</p>","!type":"fn(hash: string, parentProperty: string, depth: number) -> bool"},"__jsonToHash":{"!doc":"<p>Converts a given object into a hash which will be used to identify the\nclasses under the namespace <code>qx.data.model</code>.</p>","!type":"fn(data: Object) -> string"},"__toClass":{"!doc":"<p>Implementation of {@link #toClass} used for recursion.</p>","!type":"fn(data: Object, includeBubbleEvents: bool, parentProperty: string, depth: number)"},"__toModel":{"!doc":"<p>Implementation of {@link #toModel} used for recursion.</p>","!type":"fn(data: Object, parentProperty: string, depth: number) -> +qx.core.Object"},"toClass":{"!doc":"<p>Creates for the given data the needed classes. The classes contain for\nevery key in the data a property. The classname is always the prefix\n<code>qx.data.model</code> and the hash of the data created by\n{@link #__jsonToHash}. Two objects containing the same keys will not\ncreate two different classes. The class creation process also supports\nthe functions provided by its delegate.</p>\n\n<p>Important, please keep in mind that only valid JavaScript identifiers\ncan be used as keys in the data map. For convenience &#8217;-&#8217; in keys will\nbe removed (a-b will be ab in the end).</p>","!type":"fn(data: Object, includeBubbleEvents: bool)"},"toModel":{"!doc":"<p>Creates for the given data the needed models. Be sure to have the classes\ncreated with {@link #toClass} before calling this method. The creation\nof the class itself is delegated to the {@link #__createInstance} method,\nwhich could use the {@link qx.data.store.IStoreDelegate} methods, if\ngiven.</p>","!type":"fn(data: Object) -> +qx.core.Object"}}},"MEventBubbling":{"!doc":"<p>Mixin used for the bubbling events. If you want to use this in your own model\nclasses, be sure that every property will call the\n{@link #_applyEventPropagation} function on every change.</p>","prototype":{"__changePropertyListener":{"!doc":"<p>Listener responsible for formating the name and firing the change event\nfor the changed property.</p>","!type":"fn(name: string, e: +qx.event.type.Data)"},"_applyEventPropagation":{"!doc":"<p>Apply function for every property created with the\n{@link qx.data.marshal.Json} marshaler. It fires and\n{@link #changeBubble} event on every change. It also adds the chaining\nlistener if possible which is necessary for the bubbling of the events.</p>","!type":"fn(value: Object, old: Object, name: string)"},"_registerEventChaining":{"!doc":"<p>Registers for the given parameters the changeBubble listener, if\npossible. It also removes the old listener, if an old item with\na changeBubble event is given.</p>","!type":"fn(value: Object, old: Object, name: string)"}}}},"MBinding":{"!doc":"<p>This mixin is forwarding the static methods of\n{@link qx.data.SingleValueBinding} to the instance including the mixin.\nThe source object will be <code>this</code>.</p>","prototype":{"bind":{"!doc":"<p>The bind method delegates the call to the\n{@link qx.data.SingleValueBinding#bind} function. As source, the current\nobject (this) will be used.</p>","!type":"fn(sourcePropertyChain: string, targetObject: +qx.core.Object, targetProperty: string, options: +Map) -> Object"},"getBindings":{"!doc":"<p>Returns an array which lists all bindings for the object.</p>","!type":"fn() -> +Array"},"removeAllBindings":{"!doc":"<p>Removes all bindings from the object.</p>","!type":"fn()"},"removeBinding":{"!doc":"<p>Removes the binding with the given id from the current object. The\nid hast to be the id returned by any of the bind functions.</p>","!type":"fn(id: Object)"}}},"SingleValueBinding":{"!doc":"<p>The data binding package is still under development so there will be changes\nto the <span class=\"caps\">API</span>. This Features is for testing purpose only.</p>","__bindEventToProperty":{"!doc":"<p>Internal helper method which is actually doing all bindings. That means\nthat an event listener will be added to the source object which listens\nto the given event and invokes an set on the target property on the\ntargetObject.\nThis method does not store the binding in the internal reference store\nso it should <span class=\"caps\">NOT</span> be used from outside this class. For an outside usage,\nuse {@link #bind}.</p>","!type":"fn(sourceObject: +qx.core.Object, sourceEvent: string, targetObject: +qx.core.Object, targetProperty: string, options: +Map, arrayIndex: string) -> Object"},"__chainListener":{"!doc":"<p>Event listener for the chaining of the properties.</p>","!type":"fn(context: +Map)"},"__checkForArrayInPropertyChain":{"!doc":"<p>Checks for an array element in the given property names and adapts the\narrays to fit the algorithm.</p>","!type":"fn(propertyNames: +Array) -> +Array"},"__convertValue":{"!doc":"<p>This method takes the given value, checks if the user has given a\nconverter and converts the value to its target type. If no converter is\ngiven by the user, the {@link #__defaultConversion} will try to convert\nthe value.</p>","!type":"fn(value: Object, targetObject: +qx.core.Object, targetPropertyChain: string, options: +Map, sourceObject: +qx.core.Object) -> Object"},"__defaultConversion":{"!doc":"<p>Tries to convert the data to the type given in the targetCheck argument.</p>","!type":"fn(data: Object, targetCheck: string) -> +Integer"},"__getEventForProperty":{"!doc":"<p>Helper method which tries to figure out if the given property on the\ngiven object does have a change event and if returns the name of it.</p>","!type":"fn(sourceObject: +qx.core.Object, sourceProperty: string) -> string"},"__getEventNameForProperty":{"!doc":"<p>Tries to return a fitting event name to the given source object and\nproperty name. First, it assumes that the propertyname is a real property\nand therefore it checks the property definition for the event. The second\npossibility is to check if there is an event with the given name. The\nthird and last possibility checked is if there is an event which is named\nchange + propertyname. If this three possibilities fail, an error will be\nthrown.</p>","!type":"fn(source: +qx.core.Object, propertyname: string) -> string"},"__getTargetFromChain":{"!doc":"<p>Helper-Function resolving the object on which the last property of the\nchain should be set.</p>","!type":"fn(targetObject: +qx.core.Object, targetPropertyChain: string) -> +qx.core.Object"},"__resetTargetValue":{"!doc":"<p>Resets the value of the given target after resolving the target property\nchain.</p>","!type":"fn(targetObject: +qx.core.Object, targetPropertyChain: string)"},"__setInitialValue":{"!doc":"<p>Set the given value to the target property. This method is used for\ninitially set the value.</p>","!type":"fn(value: Object, targetObject: +qx.core.Object, targetPropertyChain: string, options: +Map, sourceObject: +qx.core.Object)"},"__setTargetValue":{"!doc":"<p>Sets the given value to the given target after resolving the\ntarget property chain.</p>","!type":"fn(targetObject: +qx.core.Object, targetPropertyChain: string, value: Object)"},"__setUpTargetBinding":{"!doc":"<p>Internal helper for setting up the listening to the changes on the\ntarget side of the binding. Only works if the target property is a\nproperty chain</p>","!type":"fn(sourceObject: +qx.core.Object, sourcePropertyChain: string, targetObject: +qx.core.Object, targetPropertyChain: string, options: +Map) -> Object"},"__storeBinding":{"!doc":"<p>This method stores the given value as a binding in the internal structure\nof all bindings.</p>","!type":"fn(id: Object, sourceObject: +qx.core.Object, sourceEvent: string, targetObject: +qx.core.Object, targetProperty: string)"},"bind":{"!doc":"<p>The function is responsible for binding a source objects property to\na target objects property. Both properties have to have the usual qooxdoo\ngetter and setter. The source property also needs to fire change-events\non every change of its value.\nPlease keep in mind, that this binding is unidirectional. If you need\na binding in both directions, you have to use two of this bindings.</p>\n\n<p>It&#8217;s also possible to bind some kind of a hierarchy as a source. This\nmeans that you can separate the source properties with a dot and bind\nby that the object referenced to this property chain.\nExample with an object &#8216;a&#8217; which has object &#8216;b&#8217; stored in its &#8216;child&#8217;\nproperty. Object b has a string property named abc:</p>\n\n<pre>\nqx.data.SingleValueBinding.bind(a, \"child.abc\", textfield, \"value\");\n</pre>\n\n<p>In that case, if the property abc of b changes, the textfield will\nautomatically contain the new value. Also if the child of a changes, the\nnew value (abc of the new child) will be in the textfield.</p>\n\n<p>There is also a possibility of binding an array. Therefor the array\n{@link qx.data.IListData} is needed because this array has change events\nwhich the native does not. Imagine a qooxdoo object a which has a\nchildren property containing an array holding more of its own kind.\nEvery object has a name property as a string.</p>\n\n<pre>\nvar svb = qx.data.SingleValueBinding;\n// bind the first childs name of 'a' to a textfield\nsvb.bind(a, \"children[0].name\", textfield, \"value\");\n// bind the last childs name of 'a' to a textfield\nsvb.bind(a, \"children[last].name\", textfield2, \"value\");\n// also deeper bindinds are possible\nsvb.bind(a, \"children[0].children[0].name\", textfield3, \"value\");\n</pre>\n\n<p>As you can see in this example, the abc property of a&#8217;s b will be bound\nto the textfield. If now the value of b changed or even the a will get a\nnew b, the binding still shows the right value.</p>","!type":"fn(sourceObject: +qx.core.Object, sourcePropertyChain: string, targetObject: +qx.core.Object, targetPropertyChain: string, options?: +Map) -> Object"},"getAllBindings":{"!doc":"<p>Returns a map containing for every bound object an array of data binding\ninformation. The key of the map is the hashcode of the bound objects.\nEvery binding is represented by an array containing id, sourceObject,\nsourceEvent, targetObject and targetProperty.</p>","!type":"fn() -> +Map"},"getAllBindingsForObject":{"!doc":"<p>Returns an array which lists all bindings.</p>","!type":"fn(object: +qx.core.Object) -> +Array"},"removeAllBindings":{"!doc":"<p>Removes all binding in the whole application. After that not a single\nbinding is left.</p>","!type":"fn()"},"removeAllBindingsForObject":{"!doc":"<p>Removes all bindings for the given object.</p>","!type":"fn(object: +qx.core.Object)"},"removeBindingFromObject":{"!doc":"<p>Removes the binding with the given id from the given sourceObject. The\nid hast to be the id returned by any of the bind functions.</p>","!type":"fn(sourceObject: +qx.core.Object, id: Object)"},"resolvePropertyChain":{"!doc":"<p>Internal helper for getting the current set value at the property chain.</p>","!type":"fn(o: +qx.core.Object, propertyChain: string) -> Object"},"showAllBindingsInLog":{"!doc":"<p>Debug function which shows all bindings in the log console. To get only\none binding in the console use {@link #showBindingInLog}</p>","!type":"fn()"},"showBindingInLog":{"!doc":"<p>Debug function which shows some valuable information about the given\nbinding in console. For that it uses {@link qx.log.Logger}.</p>","!type":"fn(object: +qx.core.Object, id: Object)"},"updateTarget":{"!doc":"<p>Helper for updating the target. Gets the current set data from the source\nand set that on the target.</p>","!type":"fn(sourceObject: +qx.core.Object, sourcePropertyChain: string, targetObject: +qx.core.Object, targetPropertyChain: string, options: +Map)"}},"store":{"IStoreDelegate":{"!doc":"<p>Objects, which are used as delegates for a data binding store may\nimplement any of the methods described in this interface. The delegate does\nnot need implement all of the methods of this interface. If a method is not\nimplemented the store provides a default implementation.</p>\n\n<p>Note: This interface is meant to document the delegate but should not be\nlisted in the <code>implement</code> key of a class unless all methods are\nreally implemented.</p>","prototype":{"configureRequest":{"!doc":"<p>This method can change the settings on the used request by the store.</p>","!type":"fn(request: Object)"},"manipulateData":{"!doc":"<p>This method manipulates the data from the request and returns the\nmanipulated data.</p>","!type":"fn(data: Object) -> Object"}}},"Json":{"!proto":"qx.core.Object","!doc":"<p>The <span class=\"caps\">JSON</span> data store is responsible for fetching data from an url. The type\nof the data has to be json.</p>\n\n<p>The loaded data will be parsed and saved in qooxdoo objects. Every value\nof the loaded data will be stored in a qooxdoo property. The model classes\nfor the data will be created automatically.</p>\n\n<p>For the fetching itself it uses the {@link qx.io.request.Xhr} class and\nfor parsing the loaded javascript objects into qooxdoo objects, the\n{@link qx.data.marshal.Json} class will be used.</p>\n\n<p>Please note that if you</p>\n\n<ul>\n<li>upgrade from qooxdoo 1.4 or lower</li>\n<li>choose not to force the old transport</li>\n<li>use a delegate with qx.data.store.IStoreDelegate#configureRequest</li>\n</ul>\n\n<p>you probably need to change the implementation of your delegate to configure\nthe {@link qx.io.request.Xhr} request.</p>","!type":"fn()","prototype":{"_applyUrl":{"!doc":"<p>Applies changes of the property value of the property <code>url</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #url}.</p>","!type":"fn(value: string, old: string)"},"_createRequest":{"!doc":"<p>Creates and sends a <span class=\"caps\">GET</span> request with the given url.</p>\n\n<p>Listeners will be added to respond to the request&#8217;s &#8220;success&#8221;,\n&#8220;changePhase&#8221; and &#8220;fail&#8221; event.</p>","!type":"fn(url: string)"},"_getRequest":{"!doc":"<p>Get request</p>","!type":"fn() -> Object"},"_onChangePhase":{"!doc":"<p>Handler called when request phase changes.</p>\n\n<p>Sets the store&#8217;s state.</p>","!type":"fn(ev: +qx.event.type.Data)"},"_onFail":{"!doc":"<p>Handler called when not completing the request successfully.</p>","!type":"fn(ev: +qx.event.type.Event)"},"_onSuccess":{"!doc":"<p>Handler for the completion of the requests. It invokes the creation of\nthe needed classes and instances for the fetched data using\n{@link qx.data.marshal.Json}.</p>","!type":"fn(ev: +qx.event.type.Event)"},"_setRequest":{"!doc":"<p>Set request.</p>","!type":"fn(request: Object)"},"getModel":{"!doc":"<p>Returns the (computed) value of the property <code>model</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #model}.</p>","!type":"fn() -> Object"},"getState":{"!doc":"<p>Returns the (computed) value of the property <code>state</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #state}.</p>","!type":"fn() -> Object"},"getUrl":{"!doc":"<p>Returns the (computed) value of the property <code>url</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #url}.</p>","!type":"fn() -> Object"},"initModel":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>model</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #model}.</p>","!type":"fn(value: Object) -> Object"},"initState":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>state</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #state}.</p>","!type":"fn(value: Object) -> Object"},"initUrl":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>url</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #url}.</p>","!type":"fn(value: Object) -> Object"},"reload":{"!doc":"<p>Reloads the data with the url set in the {@link #url} property.</p>","!type":"fn()"},"resetModel":{"!doc":"<p>Resets the user value of the property <code>model</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #model}.</p>","!type":"fn()"},"resetState":{"!doc":"<p>Resets the user value of the property <code>state</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #state}.</p>","!type":"fn()"},"resetUrl":{"!doc":"<p>Resets the user value of the property <code>url</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #url}.</p>","!type":"fn()"},"setModel":{"!doc":"<p>Sets the user value of the property <code>model</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #model}.</p>","!type":"fn(value: Object) -> Object"},"setState":{"!doc":"<p>Sets the user value of the property <code>state</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #state}.</p>","!type":"fn(value: Object) -> Object"},"setUrl":{"!doc":"<p>Sets the user value of the property <code>url</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #url}.</p>","!type":"fn(value: Object) -> Object"}}},"Jsonp":{"!proto":"qx.data.store.Json","!doc":"<p>The <span class=\"caps\">JSONP</span> data store is a specialization of {@link qx.data.store.Json}. It\ndiffers in the type of transport used ({@link qx.io.request.Jsonp}). In\norder to fullfill requirements of the <span class=\"caps\">JSONP</span> service, the method\n{@link #setCallbackParam} can be used.</p>\n\n<p>Please note that the upgrade notices described in {@link qx.data.store.Json}\nalso apply to this class.</p>","!type":"fn()","prototype":{"_createRequest":{"!type":"fn(url: +undefined)"},"getCallbackName":{"!doc":"<p>Returns the (computed) value of the property <code>callbackName</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #callbackName}.</p>","!type":"fn() -> Object"},"getCallbackParam":{"!doc":"<p>Returns the (computed) value of the property <code>callbackParam</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #callbackParam}.</p>","!type":"fn() -> Object"},"initCallbackName":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>callbackName</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #callbackName}.</p>","!type":"fn(value: Object) -> Object"},"initCallbackParam":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>callbackParam</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #callbackParam}.</p>","!type":"fn(value: Object) -> Object"},"resetCallbackName":{"!doc":"<p>Resets the user value of the property <code>callbackName</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #callbackName}.</p>","!type":"fn()"},"resetCallbackParam":{"!doc":"<p>Resets the user value of the property <code>callbackParam</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #callbackParam}.</p>","!type":"fn()"},"setCallbackName":{"!doc":"<p>Sets the user value of the property <code>callbackName</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #callbackName}.</p>","!type":"fn(value: Object) -> Object"},"setCallbackParam":{"!doc":"<p>Sets the user value of the property <code>callbackParam</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #callbackParam}.</p>","!type":"fn(value: Object) -> Object"}}},"Offline":{"!proto":"qx.core.Object","!doc":"<p>This store is a read / write store for local or session storage.\nIt can be used like any other store by setting and manipulating the model\nproperty or the model itself. Please keep in mind that if you want to have\nthe update functionality, you have to use a model which supports the\n{@link qx.data.marshal.MEventBubbling#changeBubble} event.</p>","!type":"fn()","prototype":{"__storeModel":{"!doc":"<p>Internal helper for writing the set model to the browser storage.</p>","!type":"fn()"},"_applyModel":{"!doc":"<p>Applies changes of the property value of the property <code>model</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #model}.</p>","!type":"fn(value: Object, old: Object)"},"_initializeModel":{"!doc":"<p>Helper for reading the model from the browser storage.</p>","!type":"fn()"},"_setModel":{"!doc":"<p>Responsible for creating the model read from the brwoser storage.</p>","!type":"fn(data: Object)"},"getKey":{"!doc":"<p>Accessor for the unique key used to store the data.</p>","!type":"fn() -> string"},"getModel":{"!doc":"<p>Returns the (computed) value of the property <code>model</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #model}.</p>","!type":"fn() -> Object"},"initModel":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>model</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #model}.</p>","!type":"fn(value: Object) -> Object"},"resetModel":{"!doc":"<p>Resets the user value of the property <code>model</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #model}.</p>","!type":"fn()"},"setModel":{"!doc":"<p>Sets the user value of the property <code>model</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #model}.</p>","!type":"fn(value: Object) -> Object"}}},"Rest":{"!proto":"qx.core.Object","!doc":"<p>Handles response associated to a resource&#8217;s action. The model property is\npopulated with the marshaled response. Note the action is invoked on the\nresource, not the store.</p>","!type":"fn()","prototype":{"__addListeners":{"!doc":"<p>Listen to events fired by the resource.</p>","!type":"fn()"},"__configureRequest":{"!doc":"<p>Configure the resource&#8217;s request by processing the delegate.</p>","!type":"fn()"},"__onActionSuccess":{"!doc":"<p>Handle actionSuccess event.</p>\n\n<p>Updates model with marshaled response.</p>","!type":"fn(e: +qx.event.type.Rest)"},"getActionName":{"!doc":"<p>Returns the (computed) value of the property <code>actionName</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #actionName}.</p>","!type":"fn() -> Object"},"getModel":{"!doc":"<p>Returns the (computed) value of the property <code>model</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #model}.</p>","!type":"fn() -> Object"},"getResource":{"!doc":"<p>Returns the (computed) value of the property <code>resource</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #resource}.</p>","!type":"fn() -> Object"},"initActionName":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>actionName</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #actionName}.</p>","!type":"fn(value: Object) -> Object"},"initModel":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>model</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #model}.</p>","!type":"fn(value: Object) -> Object"},"initResource":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>resource</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #resource}.</p>","!type":"fn(value: Object) -> Object"},"resetActionName":{"!doc":"<p>Resets the user value of the property <code>actionName</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #actionName}.</p>","!type":"fn()"},"resetModel":{"!doc":"<p>Resets the user value of the property <code>model</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #model}.</p>","!type":"fn()"},"resetResource":{"!doc":"<p>Resets the user value of the property <code>resource</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #resource}.</p>","!type":"fn()"},"setActionName":{"!doc":"<p>Sets the user value of the property <code>actionName</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #actionName}.</p>","!type":"fn(value: Object) -> Object"},"setModel":{"!doc":"<p>Sets the user value of the property <code>model</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #model}.</p>","!type":"fn(value: Object) -> Object"},"setResource":{"!doc":"<p>Sets the user value of the property <code>resource</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #resource}.</p>","!type":"fn(value: Object) -> Object"}}},"Yql":{"!proto":"qx.data.store.Jsonp","!doc":"<p>This store uses the {@link qx.data.store.Jsonp} store to query Yahoo&#8217;s\n<span class=\"caps\">YQL</span> service. (<a href=\"http://developer.yahoo.com/yql/\">http://developer.yahoo.com/yql/</a>)</p>\n\n<p>If you want to test your queries, take a look at the <span class=\"caps\">YQL</span> console:\n<a href=\"http://developer.yahoo.com/yql/console/\">http://developer.yahoo.com/yql/console/</a></p>","!type":"fn()"}}},"dev":{"Debug":{"!doc":"<p>Useful debug capabilities</p>","debugObject":{"!doc":"<p>Recursively display an object (as a debug message)</p>","!type":"fn(obj: Object, initialMessage: string, maxLevel?: +Integer)"},"debugObjectToString":{"!doc":"<p>Recursively display an object (into a string)</p>","!type":"fn(obj: Object, initialMessage: string, maxLevel?: +Integer, bHtml?: bool) -> string"},"debugProperties":{"!doc":"<p>Returns a string representing the given model. The string will include\nall model objects to a given recursive depth.</p>","!type":"fn(model: +qx.core.Object, maxLevel?: number, html?: bool, indent?: number) -> string"},"getFunctionName":{"!doc":"<p>Get the name of a member/static function or constructor defined using the new style class definition.\nIf the function could not be found <code>null</code> is returned.</p>\n\n<p>This function uses a linear search, so don&#8217;t use it in performance critical\ncode.</p>","!type":"fn(func: fn(), functionType?: string) -> string"},"startDisposeProfiling":{"!doc":"<p>Starts a dispose profiling session. Use {@link #stopDisposeProfiling} to\nget the results</p>","!type":"fn()"},"stopDisposeProfiling":{"!doc":"<p>Returns a list of any (qx) objects that were created but not disposed since\n{@link #startDisposeProfiling} was called. Also returns a stack trace\nrecorded at the time the object was created.</p>","!type":"fn(checkFunction: fn()) -> +Map"}},"FakeServer":{"!proto":"Object","!doc":"<p>A wrapper around Sinon.JS&#8217;s FakeXMLHttpRequest and FakeServer features that\nallows quick and simple configuration of mock <span class=\"caps\">HTTP</span> backends for testing and\ndevelopment.\nAutomatically creates <span class=\"caps\">URL</span> filtering rules to ensure that only configured\nrequests are faked while others will be processed normally by the browser&#8217;s\n<span class=\"caps\">XHR</span> implementation.</p>\n\n<p>The following example shows how to configure mock responses for two different\nrequests:</p>\n\n<pre class=\"javascript\">\n  var responseData = [\n    {\n      method: \"GET\",\n      url: /\\/api\\/resource\\/\\d+/,\n      response : function(request) {\n        var status = 200;\n        var headers = { \"Content-Type\": \"application/json\" };\n        var responseData = {\n          description: \"Mock REST response for resource \" + request.url\n        };\n        var body = qx.lang.Json.stringify(responseData);\n        request.respond(status, headers, body);\n      }\n    },\n    {\n      method: \"GET\",\n      url: \"/users/{userId}\",\n      response: [\n        200,\n        { \"Content-Type\": \"application/json\" },\n        qx.lang.Json.stringify({userId: 'someUser'})\n      ]\n    }\n  ];\n\n  qx.dev.FakeServer.getInstance().configure(responseData);\n</pre>","!type":"fn()","getInstance":{"!doc":"<p>Helper method to handle singletons</p>","!type":"fn() -> Object"},"prototype":{"__getCombinedFilter":{"!doc":"<p>Returns a filter function that ensures only requests matching configured\nfake responses will be intercepted.</p>","!type":"fn() -> fn()"},"_getRegExp":{"!doc":"<p>Returns a RegExp using the given pattern. Curly brackets and anything\nbetween are replaced with wildcards (.*?)</p>","!type":"fn(pattern: string) -> +RegExp"},"addFilter":{"!doc":"<p>Adds a <span class=\"caps\">URL</span> filtering function to decide whether a request should be handled\nby the FakeServer or passed to the regular XMLHttp implementation.\nSee <a href=\"http://sinonjs.org/docs/#filtered-requests\">Sinon.JS: Filtered Requests</a>\nfor details.</p>","!type":"fn(filter: fn())"},"configure":{"!doc":"<p>Configures a set of fake <span class=\"caps\">HTTP</span> responses. Each response is defined as a map\nthat must provide the following keys:\n<ul>\n  <li><code>method</code> <span class=\"caps\">HTTP</span> method to respond to, e.g. <code><span class=\"caps\">PUT</span></code></li>\n  <li><code>url</code> <span class=\"caps\">URL</span> used to match requests to fake responses. Can be\n  a RegExp or a String. <span class=\"caps\">REST</span>-style parameter placeholders in curly braces\n  will be replaced with wildcards, e.g. the string &#8221;/resource/{resourceId}&#8221;\n  is interpreted as the RegExp <code>/\\/resource\\/\\{.*?\\}/</code>\n  <li><code>response</code> This can be either:\n    <ul>\n      <li>a string: This will be the response body, status code will be 200</li>\n      <li>an array containing the status code, a map of response headers and\n        the response text, e.g. <code>[200, { &#8220;Content-Type&#8221;: &#8220;text/html&#8221; }, &#8220;OK&#8221;]</code>\n      </li>\n      <li>a function: This will be called with a FakeXMLHttpRequest object as\n      the only argument. Its <code>respond</code> method must be called to send a response.\n      See <a href=\"http://sinonjs.org/docs/#respond\">Sinon.JS: Respond</a> for details.\n      </li>\n    </ul>\n  </li>\n</ul></p>","!type":"fn(responseData: +Map)"},"getFakeServer":{"!doc":"<p>Creates and configures a FakeServer if necessary and returns it.</p>","!type":"fn() -> Object"},"removeFilter":{"!doc":"<p>Remove a filter that was added with {@link #addFilter}</p>","!type":"fn(filter: fn())"},"removeResponse":{"!doc":"<p>Removes a response that was configured with {@link #configure}</p>","!type":"fn(method: string, url: string)"},"respondWith":{"!doc":"<p>Defines a fake <span class=\"caps\">XHR</span> response to a matching request.</p>","!type":"fn(method: string, urlRegExp: +RegExp, response: fn())"},"restore":{"!doc":"<p>Stops the FakeServer and removes all configured responses and/or filters.</p>","!type":"fn()"}}},"ObjectSummary":{"!doc":"<p>Statics around created qooxdoo instances.</p>","getInfo":{"!doc":"<p>Summary of allocated objects</p>","!type":"fn() -> string"},"getNewObjects":{"!doc":"<p>Allocated objects and lists all objects, which have been newly created\nsince the last call of this function.</p>","!type":"fn() -> string"}},"Profile":{"!doc":"<p>qooxdoo profiler.</p>\n\n<p>All functions of qooxdoo classes (constructors, members, statics) can be profiled\nusing this class.</p>\n\n<p>To enable profiling this class must be loaded <b>before</b> <code>qx.Class</code> is\nloaded. This can be achieved by making <code>qx.core.Aspect</code> and\n<code>qx.dev.Profile</code> a load time dependency of <code>qx.Class</code>.\nFurther more the variant <code>qx.aspects</code> must be set to <code>on</code>.</p>","__calibrate":{"!doc":"<p>Measure the overhead of calling a wrapped function vs. calling an\nunwrapped function.</p>","!type":"fn(count: +Integer) -> number"},"__calibrateHelper":{"!doc":"<p>Helper to measure overhead.</p>","!type":"fn()"},"getProfileData":{"!doc":"<p>Return the profiling data as <span class=\"caps\">JSON</span> data structure.</p>\n\n<p>Example:</p>\n\n<pre class=\"javascript\">\n{\n  \"qx.core.ObjectRegistry.toHashCode (static)\":{\n    *     \"totalTime\":3,\n    \"ownTime\":3,\n    \"callCount\":218,\n    \"subRoutineCalls\":0,\n    \"name\":\"qx.core.ObjectRegistry.toHashCode\",\n    \"type\":\"static\"\n  },\n  \"qx.core.Object.addListener (member)\":{\n    \"totalTime\":19,\n    \"ownTime\":12,\n    \"callCount\":59,\n    \"subRoutineCalls\":251,\n    \"name\":\"qx.core.Object.addListener\",\n    \"type\":\"member\"\n  },\n  \"qx.ui.table.cellrenderer.Default (constructor)\":{\n    \"totalTime\":2,\n    \"ownTime\":1,\n    \"callCount\":1,\n    \"subRoutineCalls\":4,\n    \"name\":\"qx.ui.table.cellrenderer.Default\",\n    \"type\":\"constructor\"\n  }\n}\n</pre>","!type":"fn() -> +Map"},"normalizeProfileData":{"!doc":"<p>Normalize profiling data by subtracting the overhead of wrapping from the\nfunction&#8217;s own time.</p>","!type":"fn()"},"profileAfter":{"!doc":"<p>This function will be called after each function call. (Stop timing)</p>","!type":"fn(fullName: string, fcn: fn(), type: string, args: +arguments, returnValue: Object)"},"profileBefore":{"!doc":"<p>This function will be called before each function call. (Start timing)</p>","!type":"fn(fullName: string, fcn: fn(), type: string, args: +arguments)"},"showResults":{"!doc":"<p>Show profiling results in a popup window. The results are sorted by the\nfunction&#8217;s own time.</p>","!type":"fn(maxLength?: +Integer)"},"start":{"!doc":"<p>Clear profiling data and start profiling.</p>","!type":"fn()"},"stop":{"!doc":"<p>Stop profiling.</p>","!type":"fn()"}},"StackTrace":{"!doc":"<p>Methods to get information about the JavaScript call stack.</p>","__fileNameToClassName":{"!doc":"<p>Converts the <span class=\"caps\">URL</span> of a JavaScript file to a class name using either a\nuser-defined ({@link #FILENAME_TO_CLASSNAME}) or default\n({@link #__fileNameToClassNameDefault}) converter</p>","!type":"fn(fileName: string) -> string"},"__fileNameToClassNameDefault":{"!doc":"<p>Converts the <span class=\"caps\">URL</span> of a JavaScript file to a class name if the file is\nnamed using the qooxdoo naming conventions.</p>","!type":"fn(fileName: string) -> string"},"__formatStackTrace":{"!doc":"<p>Runs the given stack trace array through the formatter function\n({@link #FORMAT_STACKTRACE}) if available and returns it. Otherwise, the\noriginal array is returned</p>","!type":"fn(trace: string) -> string"},"getStackTrace":{"!doc":"<p>Get a stack trace of the current position in the code.</p>\n\n<p>Browser compatibility:\n<ul>\n  <li>In new versions of Gecko, WebKit and Opera, the output of\n  {@link #getStackTraceFromError} and {@link #getStackTraceFromCaller} is\n  combined to generate the richest trace, including line numbers.</li>\n  <li>For Internet Explorer (and other engines that do not provide stack\n   traces), {@link #getStackTraceFromCaller} is used</li>\n</ul></p>","!type":"fn() -> string"},"getStackTraceFromCaller":{"!doc":"<p>Get a stack trace from the arguments special variable using the\n<code>caller</code> property.</p>\n\n<p>This methods returns class/mixin and function names of each step\nin the call stack.</p>\n\n<p>Recursion is not supported.</p>","!type":"fn(args: +arguments) -> string"},"getStackTraceFromError":{"!doc":"<p>Try to get a stack trace from an Error object. Mozilla sets the field\n<code>stack</code> for Error objects thrown using <code>throw new Error()</code>.\nFrom this field it is possible to get a stack trace from the position\nthe exception was thrown at.</p>\n\n<p>This will get the JavaScript file names and the line numbers of each call.\nThe file names are converted into qooxdoo class names if possible (customizable\nvia {@link #FILENAME_TO_CLASSNAME}).</p>\n\n<p>The stack trace can be custom formatted using {@link #FORMAT_STACKTRACE}.</p>\n\n<p>This works reliably in Gecko-based browsers. Later Opera versions and\nChrome also provide a useful stack trace. For Safari, only the class or\nfile name and line number where the error occurred are returned.\nIE 6/7/8/9 does not attach any stack information to error objects so an\nempty array is returned.</p>","!type":"fn(error: +Error) -> string"}},"Tokenizer":{"!proto":"qx.core.Object","!doc":"<p>Simple JavaScript tokenizer used to print syntax highlighted\nJavaScript code.</p>\n\n<p>Based on Public Domain code by Christopher Diggins\n<a href=\"http://www.cdiggins.com/tokenizer.html\">http://www.cdiggins.com/tokenizer.html</a></p>","javaScriptToHtml":{"!doc":"<p>Create a colored <span class=\"caps\">HTML</span> string for a string of JavaScript code.\nThe colored elements are placed in <code>span</code> elements\nwith class names corresponding to the token types. The returned code\nshould be placed into <code>pre</code> tags to preserve the\nindentation.</p>","!type":"fn(javaScriptText: string, forPreTag?: bool) -> string"},"tokenizeJavaScript":{"!doc":"<p>Tokenizes a string of JavaScript code.</p>","!type":"fn(javaScriptText: string) -> +Map"}},"unit":{"AbstractTestSuite":{"!proto":"qx.core.Object","!doc":"<p>A TestSuite is a collection of test functions, classes and other test suites,\nwhich should be run together.</p>","!type":"fn()","prototype":{"addFail":{"!doc":"<p>Add a test function to the suite, which fails.</p>","!type":"fn(functionName: string, message: string)"},"addTestFunction":{"!doc":"<p>Add a single function to test</p>","!type":"fn(name: string, fcn: fn())"},"addTestMethod":{"!doc":"<p>Add a method from a class as test to the suite</p>","!type":"fn(testCase: +qx.dev.unit.TestCase, functionName: string)"},"getTestMethods":{"!doc":"<p>Get a list of all test methods in the suite</p>","!type":"fn() -> fn()"},"run":{"!doc":"<p>Run all tests using the given test result</p>","!type":"fn(testResult: +TestResult)"}}},"AsyncWrapper":{"!proto":"qx.core.Object","!doc":"<p>This class stores the information needed to instruct a running test to wait.\n It is thrown as an exception to be caught by the method executing the test.</p>","!type":"fn()","prototype":{"getContext":{"!doc":"<p>Returns the (computed) value of the property <code>context</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #context}.</p>","!type":"fn() -> Object"},"getDeferredFunction":{"!doc":"<p>Returns the (computed) value of the property <code>deferredFunction</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #deferredFunction}.</p>","!type":"fn() -> Object"},"getDelay":{"!doc":"<p>Returns the (computed) value of the property <code>delay</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #delay}.</p>","!type":"fn() -> Object"},"initContext":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>context</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #context}.</p>","!type":"fn(value: Object) -> Object"},"initDeferredFunction":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>deferredFunction</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #deferredFunction}.</p>","!type":"fn(value: Object) -> Object"},"initDelay":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>delay</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #delay}.</p>","!type":"fn(value: Object) -> Object"},"resetContext":{"!doc":"<p>Resets the user value of the property <code>context</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #context}.</p>","!type":"fn()"},"resetDeferredFunction":{"!doc":"<p>Resets the user value of the property <code>deferredFunction</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #deferredFunction}.</p>","!type":"fn()"},"resetDelay":{"!doc":"<p>Resets the user value of the property <code>delay</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #delay}.</p>","!type":"fn()"},"setContext":{"!doc":"<p>Sets the user value of the property <code>context</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #context}.</p>","!type":"fn(value: Object) -> Object"},"setDeferredFunction":{"!doc":"<p>Sets the user value of the property <code>deferredFunction</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #deferredFunction}.</p>","!type":"fn(value: Object) -> Object"},"setDelay":{"!doc":"<p>Sets the user value of the property <code>delay</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #delay}.</p>","!type":"fn(value: Object) -> Object"}}},"JsUnitTestResult":{"!proto":"qx.dev.unit.TestResult","!doc":"<p>Test result class, which can export the results to JSUnit</p>","!type":"fn()","prototype":{"exportToJsUnit":{"!doc":"<p>Export the test functions to JSUnit</p>","!type":"fn()"},"run":{"!doc":"<p>Run the test</p>","!type":"fn(test: +TestFunction, testFunction: fn())"}}},"MeasurementResult":{"!proto":"Object","!doc":"<p>Performance test result object. Used to communicate measurements to the unit\ntesting framework.</p>","!type":"fn()","prototype":{"getData":{"!doc":"<p>Returns the stored data as a map.</p>","!type":"fn() -> +Map"},"toString":{"!doc":"<p>Returns a readable summary of this result</p>","!type":"fn() -> string"}}},"MMeasure":{"!doc":"<p>Measures JavaScript execution and rendering time for singular or repeated\noperations.</p>","prototype":{"log":{"!doc":"<p>Logs a single measurement result</p>","!type":"fn(msg: string, iterations: number, ownTime: number, renderTime: number)"},"measure":{"!doc":"<p>Executes a given callback function once and measures JavaScript execution\nand rendering time</p>","!type":"fn(msg: string, callback: fn(), finalize: fn(), displayIterations?: number, maxTime?: number)"},"measureIterations":{"!doc":"<p>Repeatedly runs code for a given amount of time and measures completed\niterations</p>","!type":"fn(msg: string, prepare: fn(), callback: fn(), finalize: fn(), time: number)"},"measureRepeated":{"!doc":"<p>Repeatedly runs code and measures execution and rendering times</p>","!type":"fn(msg: string, callback: fn(), finalize: fn(), iterations: number, displayIterations?: number)"}}},"MMock":{"!doc":"<p>Provides test spies, stubs and mocks as well as custom assertions.</p>\n\n<p>Here is a simple example:</p>\n\n<pre class=\"javascript\">\n\n// Test\nqx&#046;Class.define(\"qx.test.Klass\",\n{\n  extend : qx.dev.unit.TestCase,\n\n  include : qx.dev.unit.MMock,\n\n  members :\n  {\n    \"test: doSpecial on condition xyz\": function() {\n      // Set-Up\n      var obj = new qx.Klass();\n\n      // Wraps obj.doSpecial in a spy function and\n      // replaces the original method with this spy.\n      this.spy(obj, \"doSpecial\");\n\n      // Run code that is expected to fulfill condition\n      obj.onCondition(\"xyz\");\n\n      // Assert that spy was called\n      this.assertCalled(obj.doSpecial);\n    },\n\n    tearDown: function() {\n      // Restore all stubs, spies and overridden host objects.\n      //\n      // It is a good idea to always run this in the <code>tearDown()</code>\n      // method, especially when overwriting global or host objects.\n      this.getSandbox().restore();\n    }\n  }\n});\n\n// Implementation\nqx&#046;Class.define(\"qx.Klass\",\n{\n  extend : qx.core.Object,\n\n  members :\n  {\n    onCondition: function(condition) {\n\n      // Complex code determining mustDoSpecial\n      // by examining condition passed\n\n      if (mustDoSpecial) {\n        this.doSpecial();\n      }\n    },\n\n    doSpecial: function() {\n\n    }\n  }\n});\n\n</pre>\n\n<p>This mixin provides assertions such as assertCalled() that work\nwith spies and stubs. Besides offering a compact way to express expectations,\nthose assertions have the advantage that meaningful error messages can be\ngenerated.</p>\n\n<p>For full list of assertions see <a href=\"http://sinonjs.org/docs/#assertions\">http://sinonjs.org/docs/#assertions</a>.\nNote that sinon.assert.xyz() translates as assertXyz().</p>","!type":"fn()","prototype":{"__deepClone":{"!doc":"<p>Deep clone object by copying properties from prototype.</p>","!type":"fn(obj: Object) -> Object"},"__exposeAssertions":{"!doc":"<p>Expose Sinon.JS assertions. Provides methods such\nas assertCalled(), assertCalledWith().\n(<a href=\"http://sinonjs.org/docs/#assert-expose\">http://sinonjs.org/docs/#assert-expose</a>)\nDoes not override existing assertion methods.</p>","!type":"fn()"},"__getOwnProperties":{"!doc":"<p>Get the object&#8217;s own properties.</p>","!type":"fn(object: Object, targetClazz: Object) -> +Array"},"__getSinon":{"!doc":"<p>Get the Sinon.JS object.</p>","!type":"fn() -> Object"},"__stubProperty":{"!doc":"<p>Safely stub property.</p>","!type":"fn(object: Object, prop: string)"},"deepStub":{"!doc":"<p><span class=\"caps\">EXPERIMENTAL</span> &#8211; <span class=\"caps\">NOT</span> <span class=\"caps\">READY</span> <span class=\"caps\">FOR</span> <span class=\"caps\">PRODUCTION</span></p>\n\n<p>Returns a deep copied, <span class=\"caps\">API</span>-identical stubbed out clone of the given\nobject.</p>\n\n<p>In contrast to the shallow {@link #stub}, also stubs out properties that\nbelong to the prototype chain.</p>","!type":"fn(object: Object) -> Object"},"getRequests":{"!doc":"<p>Get requests made with faked <span class=\"caps\">XHR</span> or server.</p>\n\n<p>Each request can be queried for url, method, requestHeaders,\nstatus and more.</p>\n\n<p>See <a href=\"http://sinonjs.org/docs/#FakeXMLHttpRequest\">http://sinonjs.org/docs/#FakeXMLHttpRequest</a>.</p>","!type":"fn() -> +Array"},"getSandbox":{"!doc":"<p>Get sandbox.</p>\n\n<p>The sandbox holds all stubs and mocks. Run <code>this.getSandbox().restore()</code>\nto restore all mock objects.</p>","!type":"fn() -> Object"},"getServer":{"!doc":"<p>Get fake server created by {@link #useFakeServer}.</p>","!type":"fn() -> Object"},"injectStub":{"!doc":"<p><span class=\"caps\">EXPERIMENTAL</span> &#8211; <span class=\"caps\">NOT</span> <span class=\"caps\">READY</span> <span class=\"caps\">FOR</span> <span class=\"caps\">PRODUCTION</span></p>\n\n<p>Changes the given factory (e.g. a constructor) to return a stub. The\nmethod itself returns this stub.</p>\n\n<p>By default, the stub returned by the changed factory is the object built\nby the original factory, but deeply stubbed (see {@link #deepStub}).\nAlternatively, a custom stub may be given explicitly that is used instead.</p>","!type":"fn(object: Object, property: string, customStub?: Object) -> Object"},"mock":{"!doc":"<p>Mocks are slightly different from spies and stubs in that you mock an\nobject, and then set an expectation on one or more of its objects.</p>\n\n<ul>\n<li>var mock = mock(obj)<br />\n  Creates a mock for the provided object. Does not change the object, but<br />\n  returns a mock object to set expectations on the object&#8217;s methods.</li>\n</ul>\n\n<ul>\n<li>var expectation = mock.expects(&#8220;method&#8221;)<br />\n  Overrides obj.method with a mock function and returns an expectation<br />\n  object. Expectations implement both the spy and stub interface plus<br />\n  the methods described below.</li>\n</ul>\n\n<p>Set expectations with following methods. All methods return the expectation\nitself, meaning expectations can be chained.</p>\n\n<ul>\n<li>expectation.atLeast(number);</li>\n<li>expectation.atMost(number);</li>\n<li>expectation.never();</li>\n<li>expectation.once();</li>\n<li>expectation.twice();</li>\n<li>expectation.thrice();</li>\n<li>expectation.exactly(number);</li>\n<li>expectation.withArgs(arg1, arg2, ...);</li>\n<li>expectation.withExactArgs(arg1, arg2, ...);</li>\n<li>expectation.on(obj);</li>\n<li>expecation.verify();</li>\n</ul>\n\n<p>See <a href=\"http://sinonjs.org/docs/#mocks\">http://sinonjs.org/docs/#mocks</a>.</p>","!type":"fn(object: Object) -> fn()"},"revealMock":{"!doc":"<p>Changes the given factory (e.g. a constructor) to make a mock of the\nobject returned. The method itself returns this mock.</p>\n\n<p>By default, the object returned by the changed factory (that a mock is\nmade of) is a deep copied, <span class=\"caps\">API</span>-identical clone of the object built by the\noriginal factory. Alternatively, the object returned can be given\nexplicitly.</p>","!type":"fn(object: Object, property: string, customObject?: Object) -> Object"},"shallowStub":{"!doc":"<p><span class=\"caps\">EXPERIMENTAL</span> &#8211; <span class=\"caps\">NOT</span> <span class=\"caps\">READY</span> <span class=\"caps\">FOR</span> <span class=\"caps\">PRODUCTION</span></p>\n\n<p>Shallowly stub all methods (except excluded) that belong to classes found in inheritance\nchain up to (but including) the given class.</p>","!type":"fn(object: Object, targetClazz: Object, propsToExclude: +Array) -> Object"},"spy":{"!doc":"<p>Test spies allow introspection on how a function is used\nthroughout the system under test.</p>\n\n<ul>\n<li>spy()<br />\n  Creates an anonymous function that records arguments,<br />\n  this value, exceptions and return values for all calls.</li>\n</ul>\n\n<ul>\n<li>spy(func)<br />\n  Spies on the provided function</li>\n</ul>\n\n<ul>\n<li>spy(object, &#8220;method&#8221;)<br />\n  Creates a spy for object.method and replaces the original method<br />\n  with the spy. The spy acts exactly like the original method in all cases.<br />\n  The original method can be restored by calling object.method.restore().<br />\n  The returned spy is the function object which replaced the original method.<br />\n  spy === object.method.</li>\n</ul>\n\n<ul>\n<li>spy.withArgs(arg1[, arg2, ...])<br />\n  Creates a spy that only records calls when the received arguments matches those<br />\n  passed to <code>withArgs</code>.</li>\n</ul>\n\n<p>A spy has a rich interface to introspect how the wrapped function was used:</p>\n\n<ul>\n<li>spy.withArgs(arg1[, arg2, ...]);</li>\n<li>spy.callCount</li>\n<li>spy.called</li>\n<li>spy.calledOnce</li>\n<li>spy.calledTwice</li>\n<li>spy.calledThrice</li>\n<li>spy.firstCall</li>\n<li>spy.secondCall</li>\n<li>spy.thirdCall</li>\n<li>spy.lastCall</li>\n<li>spy.calledBefore(anotherSpy)</li>\n<li>spy.calledAfter(anotherSpy)</li>\n<li>spy.calledOn(obj)</li>\n<li>spy.alwaysCalledOn(obj)</li>\n<li>spy.calledWith(arg1, arg2, ...)</li>\n<li>spy.alwaysCalledWith(arg1, arg2, ...)</li>\n<li>spy.calledWithExactly(arg1, arg2, ...)</li>\n<li>spy.alwaysCalledWithExactly(arg1, arg2, ...)</li>\n<li>spy.calledWithMatch(arg1, arg2, ...);</li>\n<li>spy.alwaysCalledWithMatch(arg1, arg2, ...);</li>\n<li>spy.calledWithNew();</li>\n<li>spy.neverCalledWith(arg1, arg2, ...);</li>\n<li>spy.neverCalledWithMatch(arg1, arg2, ...);</li>\n<li>spy.threw()</li>\n<li>spy.threw(&#8220;TypeError&#8221;)</li>\n<li>spy.threw(obj)</li>\n<li>spy.alwaysThrew()</li>\n<li>spy.alwaysThrew(&#8220;TypeError&#8221;)</li>\n<li>spy.alwaysThrew(obj)</li>\n<li>spy.returned(obj)</li>\n<li>spy.alwaysReturned(obj)</li>\n<li>spy.getCall(n)</li>\n<li>spy.thisValues</li>\n<li>spy.args</li>\n<li>spy.exceptions</li>\n<li>spy.returnValues</li>\n<li>spy.reset()</li>\n<li>spy.printf(&#8220;format string&#8221;, [arg1, arg2, ...])</li>\n</ul>\n\n<p>See <a href=\"http://sinonjs.org/docs/#spies\">http://sinonjs.org/docs/#spies</a>.</p>\n\n<p>Note: Spies are transparently added to a sandbox. To restore\nthe original function for all spies run <code>this.getSandbox().restore()</code>\nin your <code>tearDown()</code> method.</p>","!type":"fn(function_or_object: fn(), method?: string) -> fn()"},"stub":{"!doc":"<p>Test stubs are functions (spies) with pre-programmed behavior.</p>\n\n<ul>\n<li>stub()<br />\n  Creates an anonymous stub function</li>\n</ul>\n\n<ul>\n<li>stub(object, &#8220;method&#8221;)<br />\n  Replaces object.method with a stub function. The original function<br />\n  can be restored by calling object.method.restore() (or stub.restore()).<br />\n  An exception is thrown if the property is not already a function,<br />\n  to help avoid typos when stubbing methods.</li>\n</ul>\n\n<ul>\n<li>stub(obj)<br />\n  Stubs all the object&#8217;s methods.</li>\n</ul>\n\n<ul>\n<li>stub.withArgs(arg1[, arg2, ...])<br />\n  Stubs the method only for the provided arguments. Can be used to create<br />\n  a stub that acts differently in response to different arguments.</li>\n</ul>\n\n<p>A stub has the interface of a spy in addition to methods that allow to define behaviour:</p>\n\n<ul>\n<li>stub.returns(obj)</li>\n<li>stub.throws()</li>\n<li>stub.throws(&#8220;TypeError&#8221;)</li>\n<li>stub.throws(obj)</li>\n<li>stub.callsArg(index)</li>\n<li>stub.callsArg(0)</li>\n<li>stub.callsArgWith(index, arg1, arg2, ...)</li>\n</ul>\n\n<p>See <a href=\"http://sinonjs.org/docs/#stubs\">http://sinonjs.org/docs/#stubs</a>.</p>\n\n<p>Note: Stubs are transparently added to a sandbox. To restore\nthe original function for all stubs run <code>this.getSandbox().restore()</code>\nin your <code>tearDown()</code> method.</p>","!type":"fn(object?: Object, method?: string) -> fn()"},"useFakeServer":{"!doc":"<p>As {@link #useFakeXMLHttpRequest}, but additionally provides a high-level\n<span class=\"caps\">API</span> to setup server responses. To setup responses, use the server\nreturned by {@link #getServer}.</p>\n\n<p>See <a href=\"http://sinonjs.org/docs/#server\">http://sinonjs.org/docs/#server</a>.</p>\n\n<p>Note: The fake server is transparently added to a sandbox. To restore\nthe original host method run <code>this.getSandbox().restore()</code>\nin your <code>tearDown()</code> method.</p>","!type":"fn() -> Object"},"useFakeXMLHttpRequest":{"!doc":"<p>Replace the native XMLHttpRequest object in browsers that support it with\na custom implementation which does not send actual requests.</p>\n\n<p>Note: The fake <span class=\"caps\">XHR</span> is transparently added to a sandbox. To restore\nthe original host method run <code>this.getSandbox().restore()</code>\nin your <code>tearDown()</code> method.</p>\n\n<p>See <a href=\"http://sinonjs.org/docs/#useFakeXMLHttpRequest\">http://sinonjs.org/docs/#useFakeXMLHttpRequest</a>.</p>","!type":"fn() -> Object"}}},"MRequirements":{"!doc":"<p>Common requirement checks for unit tests. Example:</p>\n\n<pre class=\"javascript\">\ntestBackend : function()\n{\n  this.require([\"http\", \"php\"]); // test will be skipped unless all conditions are met\n  // test code goes here\n}\n</pre>","prototype":{"hasChrome":{"!doc":"<p>Checks if the application is running in Google Chrome</p>","!type":"fn() -> bool"},"hasFirefox":{"!doc":"<p>Checks if the application is running in Firefox</p>","!type":"fn() -> bool"},"hasGecko":{"!doc":"<p>Checks if the application is running in a browser using the Gecko engine</p>","!type":"fn() -> bool"},"hasGuiApp":{"!doc":"<p>Checks if the application extends qx.application.Standalone</p>","!type":"fn() -> bool"},"hasHttp":{"!doc":"<p>Checks if the application has been loaded over <span class=\"caps\">HTTP</span>.</p>","!type":"fn() -> bool"},"hasIe":{"!doc":"<p>Checks if the application is running in Internet Explorer</p>","!type":"fn() -> bool"},"hasInlineApp":{"!doc":"<p>Checks if the application extends qx.application.Inline</p>","!type":"fn() -> bool"},"hasMshtml":{"!doc":"<p>Checks if the application is running in a browser using the <span class=\"caps\">MSHTML</span> engine</p>","!type":"fn() -> bool"},"hasNativeApp":{"!doc":"<p>Checks if the application extends qx.application.Native</p>","!type":"fn() -> bool"},"hasNoSelenium":{"!doc":"<p>Checks if the application is controlled by Selenium</p>","!type":"fn() -> bool"},"hasNoWin7":{"!doc":"<p>Checks if the application is running on Windows 7</p>","!type":"fn() -> bool"},"hasOpera":{"!doc":"<p>Checks if the application is running in a browser using the Opera engine</p>","!type":"fn() -> bool"},"hasPhp":{"!doc":"<p>Checks if the server supports <span class=\"caps\">PHP</span>.</p>","!type":"fn() -> bool"},"hasWebkit":{"!doc":"<p>Checks if the application is running in a browser using the Webkit engine</p>","!type":"fn() -> bool"}}},"MRequirementsBasic":{"!doc":"<p>Adds support for verification of infrastructure requirements to unit test\nclasses.</p>","prototype":{"require":{"!doc":"<p>Verifies a list of infrastructure requirements by checking for\ncorresponding &#8220;has&#8221; methods. If no such method was found,\n{@link qx.core.Environment} will be checked for a key matching the given\nfeature name. Note that asynchronous environment checks are not supported!</p>\n\n<p>See the manual for further details:\n<a href=\"http://manual.qooxdoo.org/current/pages/development/frame_apps_testrunner.html#defining-test-requirements\">Defining Test Requirements</a></p>","!type":"fn(featureList: string)"}}},"MTestLoader":{"!doc":"<p>This mixin contains the methods needed to implement a loader that will\ncreate a suite of unit tests from a given namespace and run it directly or\nprovide the necessary information to a more advanced runner application</p>","prototype":{"_getClassNameFromUrl":{"!doc":"<p>Parses the url parameters and tries to find the classes to test.\nThe pattern is like <code>index.html?testclass=qx.test</code></p>","!type":"fn() -> string"},"getSuite":{"!doc":"<p>Returns the (computed) value of the property <code>suite</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #suite}.</p>","!type":"fn() -> Object"},"getTestDescriptions":{"!doc":"<p>Get a list of test descriptions</p>","!type":"fn() -> string"},"initSuite":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>suite</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #suite}.</p>","!type":"fn(value: Object) -> Object"},"resetSuite":{"!doc":"<p>Resets the user value of the property <code>suite</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #suite}.</p>","!type":"fn()"},"runJsUnit":{"!doc":"<p>Run all tests and export the results to JSUnit</p>","!type":"fn()"},"runStandAlone":{"!doc":"<p>Run tests as standalone application</p>","!type":"fn()"},"runTests":{"!doc":"<p>Runs exactly one test from the test suite</p>","!type":"fn(testResult: +TestResult, className: string, methodName: string)"},"runTestsFromNamespace":{"!doc":"<p>Runs all tests inside of the given namespace</p>","!type":"fn(testResult: +TestResult, namespaceName: string)"},"setSuite":{"!doc":"<p>Sets the user value of the property <code>suite</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #suite}.</p>","!type":"fn(value: Object) -> Object"},"setTestNamespace":{"!doc":"<p>Sets the top level namespace of the test cases to test. All classes\nbelow this namespace extending {@link TestCase} will be tested.</p>","!type":"fn(namespace: Object)"}}},"RequirementError":{"!proto":"Error","!doc":"<p>This error is thrown by the unit test class if an infrastructure requirement\nis not met. The unit testing framework should skip the test and visually mark\nthe test as not having been executed.</p>","!type":"fn()","prototype":{"getRequirement":{"!doc":"<p>Returns the ID of the requirement that was not satisfied.</p>","!type":"fn() -> string"},"toString":{"!doc":"<p>Returns a string representation of the error.</p>","!type":"fn() -> string"}}},"Sinon":{"!doc":"<p>Exposes Sinon.JS to qooxdoo.</p>\n\n<p>This class exposes Sinon.JS (<a href=\"http://sinonjs.org/\">http://sinonjs.org/</a>) and is not to be used\ndirectly. Instead, you should include qx.dev.unit.MMock in your TestCase\nand use the wrappers provided.</p>","getSinon":{"!doc":"<p>Get the Sinon.JS object.</p>","!type":"fn() -> Object"}},"TestCase":{"!proto":"qx.core.Object","!doc":"<p>Base class for all unit tests.</p>","prototype":{"getTestFunc":{"!doc":"<p>Returns the (computed) value of the property <code>testFunc</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #testFunc}.</p>","!type":"fn() -> Object"},"getTestResult":{"!doc":"<p>Returns the (computed) value of the property <code>testResult</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #testResult}.</p>","!type":"fn() -> Object"},"initTestFunc":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>testFunc</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #testFunc}.</p>","!type":"fn(value: Object) -> Object"},"initTestResult":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>testResult</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #testResult}.</p>","!type":"fn(value: Object) -> Object"},"isDebugOn":{"!doc":"<p>Whether If debugging code is enabled. (i.e. the setting\n<code>qx.debug</code> has the value <code>on</code>.)</p>","!type":"fn() -> bool"},"resetTestFunc":{"!doc":"<p>Resets the user value of the property <code>testFunc</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #testFunc}.</p>","!type":"fn()"},"resetTestResult":{"!doc":"<p>Resets the user value of the property <code>testResult</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #testResult}.</p>","!type":"fn()"},"resume":{"!doc":"<p>Cancel a timeout started with <code>wait()</code> and run the given\nfunction. Used for asynchronous tests, e.g. in a listener&#8217;s callback\nfunction.</p>\n\n<p><strong>Important</strong></p>\n\n<p>The used <strong>deferredFunction</strong> is the last function which is executed before\nthe whole test case is disposed. But you are able to use a new\n<code>wait()</code> / <code>resume()</code> pair in the call sequence of the deferred function.</p>","!type":"fn(deferredFunction?: fn(), self?: Object)"},"resumeHandler":{"!doc":"<p>Cancel a timeout started with <code>wait()</code> and return a function,\nwhich calls {@link #resume}. This function is useful\nto wrap an event handler or callback function within the resume call sequence.\nIt provides the deferred function with all parameters from original caller.</p>\n\n<pre>\n obj.addListener(\"appear\", this.resumeHandler(function(e){\n   // do some nice\n }));\n\n this.wait();\n</pre>","!type":"fn(deferredFunction: fn(), self?: Object) -> fn()"},"setTestFunc":{"!doc":"<p>Sets the user value of the property <code>testFunc</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #testFunc}.</p>","!type":"fn(value: Object) -> Object"},"setTestResult":{"!doc":"<p>Sets the user value of the property <code>testResult</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #testResult}.</p>","!type":"fn(value: Object) -> Object"},"skip":{"!doc":"<p>Skip this test. Any code after a call to this method will not be executed.</p>","!type":"fn(message: string)"},"wait":{"!doc":"<p>Instruct the test to wait. Used for asynchronous tests.</p>","!type":"fn(delay?: +Integer, deferredFunction?: fn(), context?: Object)"}}},"TestClass":{"!proto":"qx.dev.unit.AbstractTestSuite","!doc":"<p>This class represents a test suite for an unit test class.</p>\n\n<p>To create your own unit tests, create a class that derives from this one, and\nadd member methods that start with &#8220;test*&#8221;. You can use assertion methods\ninherited from <strong>TestClass</strong> to ease the implementation process.</p>\n\n<p>A simple example:</p>\n\n<pre class=\"javascript\">\nqx. Class.define(\"myapp.test.MyUnitTest\"),\n{\n  extend  : qx.dev.unit.TestCase,\n\n  members :\n  {\n    testMe : function ()\n    {\n      // 'assertEquals' is from the parent\n      this.assertEquals(4, 3+1, \"failure message\");\n    }\n  }\n}\n</pre>","!type":"fn()","prototype":{"getName":{"!doc":"<p>Returns the (computed) value of the property <code>name</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #name}.</p>","!type":"fn() -> Object"},"initName":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>name</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #name}.</p>","!type":"fn(value: Object) -> Object"},"resetName":{"!doc":"<p>Resets the user value of the property <code>name</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #name}.</p>","!type":"fn()"},"setName":{"!doc":"<p>Sets the user value of the property <code>name</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #name}.</p>","!type":"fn(value: Object) -> Object"}}},"TestFunction":{"!proto":"qx.core.Object","!doc":"<p>Wrapper object for a method containing unit test code.</p>","!type":"fn()","prototype":{"getClassName":{"!doc":"<p>Returns the (computed) value of the property <code>className</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #className}.</p>","!type":"fn() -> Object"},"getFullName":{"!doc":"<p>Get the full name of the test.</p>","!type":"fn() -> string"},"getName":{"!doc":"<p>Returns the (computed) value of the property <code>name</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #name}.</p>","!type":"fn() -> Object"},"getTestClass":{"!doc":"<p>Returns the (computed) value of the property <code>testClass</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #testClass}.</p>","!type":"fn() -> Object"},"getTestFunction":{"!doc":"<p>Returns the (computed) value of the property <code>testFunction</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #testFunction}.</p>","!type":"fn() -> Object"},"initClassName":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>className</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #className}.</p>","!type":"fn(value: Object) -> Object"},"initName":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>name</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #name}.</p>","!type":"fn(value: Object) -> Object"},"initTestClass":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>testClass</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #testClass}.</p>","!type":"fn(value: Object) -> Object"},"initTestFunction":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>testFunction</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #testFunction}.</p>","!type":"fn(value: Object) -> Object"},"resetClassName":{"!doc":"<p>Resets the user value of the property <code>className</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #className}.</p>","!type":"fn()"},"resetName":{"!doc":"<p>Resets the user value of the property <code>name</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #name}.</p>","!type":"fn()"},"resetTestClass":{"!doc":"<p>Resets the user value of the property <code>testClass</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #testClass}.</p>","!type":"fn()"},"resetTestFunction":{"!doc":"<p>Resets the user value of the property <code>testFunction</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #testFunction}.</p>","!type":"fn()"},"run":{"!doc":"<p>Runs the test and logs the test result to a {@link TestResult} instance,</p>","!type":"fn(testResult: +TestResult)"},"setClassName":{"!doc":"<p>Sets the user value of the property <code>className</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #className}.</p>","!type":"fn(value: Object) -> Object"},"setName":{"!doc":"<p>Sets the user value of the property <code>name</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #name}.</p>","!type":"fn(value: Object) -> Object"},"setTestClass":{"!doc":"<p>Sets the user value of the property <code>testClass</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #testClass}.</p>","!type":"fn(value: Object) -> Object"},"setTestFunction":{"!doc":"<p>Sets the user value of the property <code>testFunction</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #testFunction}.</p>","!type":"fn(value: Object) -> Object"},"setUp":{"!doc":"<p>Call the test class&#8217; <code>setUp</code> method.</p>","!type":"fn()"},"tearDown":{"!doc":"<p>Call the test class&#8217; <code>tearDown</code> method.</p>","!type":"fn()"}}},"TestLoader":{"!proto":"qx.application.Standalone","!doc":"<p>The test loader is the base class of a native application, which can be used\nto run tests from a non-GUI application or from within JSUnit.</p>","prototype":{"main":{"!type":"fn()"}}},"TestLoaderBasic":{"!proto":"qx.core.Object","!doc":"<p>Test loader for server-side/&#8220;headless&#8221; environments</p>","!type":"fn()"},"TestLoaderInline":{"!proto":"qx.application.Inline","!doc":"<p>The test loader is the base class of a native application, which can be used\nto run tests from a non-GUI application or from within JSUnit.</p>","prototype":{"main":{"!type":"fn()"}}},"TestLoaderMobile":{"!proto":"qx.application.Mobile","!doc":"<p>The test loader is the base class of a native application, which can be used\nto run tests from a non-GUI application or from within JSUnit.</p>","prototype":{"main":{"!type":"fn()"}}},"TestLoaderNative":{"!proto":"qx.application.Native","!doc":"<p>The test loader is the base class of a native application, which can be used\nto run tests from a non-GUI application or from within JSUnit.</p>","prototype":{"main":{"!type":"fn()"}}},"TestResult":{"!proto":"qx.core.Object","!doc":"<p>The test result class runs the test functions and fires events depending on\nthe result of the test run.</p>","run":{"!doc":"<p>Run a test function using a given test result</p>","!type":"fn(testResult: +TestResult, test: +TestSuite, testFunction: Object)"},"prototype":{"__removeListeners":{"!doc":"<p>Removes any listeners left over after a test&#8217;s run.</p>","!type":"fn(testFunction: +qx.dev.unit.TestFunction)"},"__wrapAddListener":{"!doc":"<p>Wraps the <span class=\"caps\">AUT</span>&#8216;s qx.event.Registration.addListener function so that it\nstores references to all added listeners in an array attached to the\ncurrent test function. This is done so that any listeners left over after\ntest execution can be removed to make sure they don&#8217;t influence other\ntests.</p>","!type":"fn(testFunction: +qx.dev.unit.TestFunction)"},"_createError":{"!doc":"<p>Fire an error event</p>","!type":"fn(eventName: string, exceptions: +Error, test: +TestSuite)"},"run":{"!doc":"<p>Run the test</p>","!type":"fn(test: +TestSuite, testFunction: fn(), self?: Object, resume?: bool)"},"tearDown":{"!doc":"<p>Calls the generic tearDown method on the test class, then the specific\ntearDown for the test, if one is defined.</p>","!type":"fn(test: Object)"}}},"TestSuite":{"!proto":"qx.dev.unit.AbstractTestSuite","!doc":"<p>A TestSuite is a collection of test functions, classes and other test suites,\nwhich should be run together.</p>","!type":"fn()","prototype":{"add":{"!doc":"<p>Add a test class or namespace to the suite</p>","!type":"fn(testClassOrNamespace: Object)"},"addTestClass":{"!doc":"<p>Add a test class to the suite</p>","!type":"fn(clazz: +Class)"},"addTestNamespace":{"!doc":"<p>Add all tests from the given namespace to the suite</p>","!type":"fn(namespace: Object)"},"getTestClasses":{"!doc":"<p>Get a list of all test classes in the suite</p>","!type":"fn() -> +Class"}}}}},"dom":{"Element":{"!doc":"<p>Manages children structures of an element. Easy and convenient APIs\nto insert, remove and replace children.</p>","create":{"!doc":"<p>Creates a <span class=\"caps\">DOM</span> element.</p>","!type":"fn(name: string, attributes?: +Map, win?: +Window) -> +Element"},"empty":{"!doc":"<p>Removes all content from the given element</p>","!type":"fn(element: +Element) -> string"},"getHelperElement":{"!doc":"<p>Creates and returns a <span class=\"caps\">DOM</span> helper element.</p>","!type":"fn(win?: +Window) -> +Element"},"getParentElement":{"!doc":"<p>Returns the parent element of the given element.</p>","!type":"fn(element: +Element) -> +Element"},"hasChild":{"!doc":"<p>Whether the given <code>child</code> is a child of <code>parent</code></p>","!type":"fn(parent: +Element, child: +Node) -> bool"},"hasChildElements":{"!doc":"<p>Whether the given <code>element</code> has any child elements.</p>","!type":"fn(element: +Element) -> bool"},"hasChildren":{"!doc":"<p>Whether the given <code>element</code> has children.</p>","!type":"fn(element: +Element) -> bool"},"insertAfter":{"!doc":"<p>Inserts <code>node</code> after <code>ref</code> in the same parent.</p>","!type":"fn(node: +Node, ref: +Node) -> bool"},"insertAt":{"!doc":"<p>Inserts <code>node</code> at the given <code>index</code>\ninside <code>parent</code>.</p>","!type":"fn(node: +Node, parent: +Element, index: +Integer) -> bool"},"insertBefore":{"!doc":"<p>Inserts <code>node</code> before <code>ref</code> in the same parent.</p>","!type":"fn(node: +Node, ref: +Node) -> bool"},"insertBegin":{"!doc":"<p>Insert <code>node</code> into <code>parent</code> as first child.\nIndexes of other children will be incremented by one.</p>","!type":"fn(node: +Node, parent: +Element) -> bool"},"insertEnd":{"!doc":"<p>Insert <code>node</code> into <code>parent</code> as last child.</p>","!type":"fn(node: +Node, parent: +Element) -> bool"},"isInDom":{"!doc":"<p>Checks if the <code>element</code> is in the <span class=\"caps\">DOM</span>, but note that\nthe method is very expensive!</p>","!type":"fn(element: +Element, win: +Window) -> bool"},"remove":{"!doc":"<p>Removes the given <code>node</code> from its parent element.</p>","!type":"fn(node: +Node) -> bool"},"removeChild":{"!doc":"<p>Removes the given <code>node</code> from the <code>parent</code>.</p>","!type":"fn(node: +Node, parent: +Element) -> bool"},"removeChildAt":{"!doc":"<p>Removes the node at the given <code>index</code>\nfrom the <code>parent</code>.</p>","!type":"fn(index: +Integer, parent: +Element) -> bool"},"replaceAt":{"!doc":"<p>Replaces the node at <code>index</code> with <code>newNode</code> in\nthe given parent.</p>","!type":"fn(newNode: +Node, index: +Integer, parent: +Element) -> bool"},"replaceChild":{"!doc":"<p>Replaces <code>oldNode</code> with <code>newNode</code> in the current\nparent of <code>oldNode</code>.</p>","!type":"fn(newNode: +Node, oldNode: +Node) -> bool"}},"Hierarchy":{"!doc":"<p>Methods to operate on nodes and elements on a <span class=\"caps\">DOM</span> tree. This contains\nspecial getters to query for child nodes, siblings, etc. This class also\nsupports to operate on one element and reorganize the content with\nthe insertion of new <span class=\"caps\">HTML</span> or nodes.</p>","_recursivelyCollect":{"!doc":"<p>Recursively collects elements whose relationship is specified by\nproperty.  <code>property</code> has to be a property (a method won&#8217;t\ndo!) of element that points to a single <span class=\"caps\">DOM</span> node. Returns an array of\nelements.</p>","!type":"fn(element: +Element, property: string) -> +Array"},"cleanWhitespace":{"!doc":"<p>Removes all of element&#8217;s text nodes which contain only whitespace</p>","!type":"fn(element: +Element)"},"contains":{"!doc":"<p>Whether the first element contains the second one</p>\n\n<p>Uses native non-standard contains() in Internet Explorer,\nOpera and Webkit (supported since Safari 3.0 beta)</p>","!type":"fn(element: +Element, target: +Node) -> bool"},"getAncestors":{"!doc":"<p>Collects all of element&#8217;s ancestors and returns them as an array of\nelements.</p>","!type":"fn(element: +Element) -> +Array"},"getChildElements":{"!doc":"<p>Returns element&#8217;s children.</p>","!type":"fn(element: +Element) -> +Array"},"getCommonParent":{"!doc":"<p>Get the common parent element of two given elements. Returns\n<code>null</code> when no common element has been found.</p>\n\n<p>Uses native non-standard contains() in Opera and Internet Explorer</p>","!type":"fn(element1: +Element, element2: +Element) -> +Element"},"getDescendants":{"!doc":"<p>Collects all of element&#8217;s descendants (deep) and returns them as an array\nof elements.</p>","!type":"fn(element: +Element) -> +Array"},"getElementIndex":{"!doc":"<p>Returns the <span class=\"caps\">DOM</span> index of the given element (ignoring non-elements)</p>","!type":"fn(element: +Element) -> +Integer"},"getFirstDescendant":{"!doc":"<p>Returns the first child that is an element. This is opposed to firstChild <span class=\"caps\">DOM</span>\nproperty which will return any node (whitespace in most usual cases).</p>","!type":"fn(element: +Element) -> +Element"},"getLastDescendant":{"!doc":"<p>Returns the last child that is an element. This is opposed to lastChild <span class=\"caps\">DOM</span>\nproperty which will return any node (whitespace in most usual cases).</p>","!type":"fn(element: +Element) -> +Element"},"getNextElementSibling":{"!doc":"<p>Return the next element to the supplied element</p>\n\n<p>&#8220;nextSibling&#8221; is not good enough as it might return a text or comment element</p>","!type":"fn(element: +Element) -> +Element"},"getNextSiblings":{"!doc":"<p>Collects all of element&#8217;s next siblings and returns them as an array of\nelements.</p>","!type":"fn(element: +Element) -> +Array"},"getNodeIndex":{"!doc":"<p>Returns the <span class=\"caps\">DOM</span> index of the given node</p>","!type":"fn(node: +Node) -> +Integer"},"getPreviousElementSibling":{"!doc":"<p>Return the previous element to the supplied element</p>\n\n<p>&#8220;previousSibling&#8221; is not good enough as it might return a text or comment element</p>","!type":"fn(element: +Element) -> +Element"},"getPreviousSiblings":{"!doc":"<p>Collects all of element&#8217;s previous siblings and returns them as an array of elements.</p>","!type":"fn(element: +Element) -> +Array"},"getSiblings":{"!doc":"<p>Collects all of element&#8217;s siblings and returns them as an array of elements.</p>","!type":"fn(element: Object) -> +Array"},"isDescendantOf":{"!doc":"<p>Checks if <code>element</code> is a descendant of <code>ancestor</code>.</p>","!type":"fn(element: +Element, ancestor: +Element) -> bool"},"isEmpty":{"!doc":"<p>Whether the given element is empty.\nInspired by Base2 (Dean Edwards)</p>","!type":"fn(element: +Element) -> bool"},"isRendered":{"!doc":"<p>Whether the element is inserted into the document\nfor which it was created.</p>","!type":"fn(element: +Element) -> bool"}},"Node":{"!doc":"<p>Basic node creation and type detection</p>","getBodyElement":{"!doc":"<p>Returns the body element. (Visual root node)</p>\n\n<p>This normally only makes sense for <span class=\"caps\">HTML</span> documents. It returns\nthe content area of the <span class=\"caps\">HTML</span> document.</p>","!type":"fn(node: +Node) -> +Element"},"getDocument":{"!doc":"<p>Returns the owner document of the given node</p>","!type":"fn(node: +Node) -> +Document"},"getDocumentElement":{"!doc":"<p>Returns the document element. (Logical root node)</p>\n\n<p>This is a convenience attribute that allows direct access to the child\nnode that is the root element of the document. For <span class=\"caps\">HTML</span> documents,\nthis is the element with the tagName &#8220;HTML&#8221;.</p>","!type":"fn(node: +Node) -> +Element"},"getName":{"!doc":"<p>Get the node name as lower case string</p>","!type":"fn(node: +Node) -> string"},"getText":{"!doc":"<p>Returns the text content of an node where the node may be of node type\nNODE_ELEMENT, NODE_ATTRIBUTE, NODE_TEXT or NODE_CDATA</p>","!type":"fn(node: +Node) -> string"},"getWindow":{"!doc":"<p>Returns the DOM2 <code>defaultView</code> (window).</p>","!type":"fn(node: +Node) -> +Window"},"isBlockNode":{"!doc":"<p>Checks if the given node is a block node</p>","!type":"fn(node: +Node) -> bool"},"isDocument":{"!doc":"<p>Whether the given object is a <span class=\"caps\">DOM</span> document node</p>","!type":"fn(node: +Node) -> bool"},"isDocumentFragment":{"!doc":"<p>Whether the given object is a <span class=\"caps\">DOM</span> document fragment node</p>","!type":"fn(node: +Node) -> bool"},"isElement":{"!doc":"<p>Whether the given object is a <span class=\"caps\">DOM</span> element node</p>","!type":"fn(node: +Node) -> bool"},"isNode":{"!doc":"<p>Whether the given object is a <span class=\"caps\">DOM</span> node</p>","!type":"fn(node: +Node) -> bool"},"isNodeName":{"!doc":"<p>Whether the node has the given node name</p>","!type":"fn(node: +Node, nodeName: string) -> bool"},"isText":{"!doc":"<p>Whether the given object is a <span class=\"caps\">DOM</span> text node</p>","!type":"fn(node: +Node) -> bool"},"isWindow":{"!doc":"<p>Check whether the given object is a browser window object.</p>","!type":"fn(obj: Object) -> bool"}}},"event":{"AcceleratingTimer":{"!proto":"qx.core.Object","!doc":"<p>Timer, which accelerates after each interval. The initial delay and the\ninterval time can be set using the properties {@link #firstInterval}\nand {@link #interval}. The {@link #interval} events will be fired with\ndecreasing interval times while the timer is running, until the {@link #minimum}\nis reached. The {@link #decrease} property sets the amount of milliseconds\nwhich will decreased after every firing.</p>\n\n<p>This class is e.g. used in the {@link qx.ui.form.RepeatButton} and\n{@link qx.ui.form.HoverButton} widgets.</p>","!type":"fn()","prototype":{"_onInterval":{"!doc":"<p>Interval event handler</p>","!type":"fn()"},"getDecrease":{"!doc":"<p>Returns the (computed) value of the property <code>decrease</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #decrease}.</p>","!type":"fn() -> Object"},"getFirstInterval":{"!doc":"<p>Returns the (computed) value of the property <code>firstInterval</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #firstInterval}.</p>","!type":"fn() -> Object"},"getInterval":{"!doc":"<p>Returns the (computed) value of the property <code>interval</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #interval}.</p>","!type":"fn() -> Object"},"getMinimum":{"!doc":"<p>Returns the (computed) value of the property <code>minimum</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #minimum}.</p>","!type":"fn() -> Object"},"initDecrease":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>decrease</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #decrease}.</p>","!type":"fn(value: Object) -> Object"},"initFirstInterval":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>firstInterval</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #firstInterval}.</p>","!type":"fn(value: Object) -> Object"},"initInterval":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>interval</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #interval}.</p>","!type":"fn(value: Object) -> Object"},"initMinimum":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>minimum</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #minimum}.</p>","!type":"fn(value: Object) -> Object"},"resetDecrease":{"!doc":"<p>Resets the user value of the property <code>decrease</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #decrease}.</p>","!type":"fn()"},"resetFirstInterval":{"!doc":"<p>Resets the user value of the property <code>firstInterval</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #firstInterval}.</p>","!type":"fn()"},"resetInterval":{"!doc":"<p>Resets the user value of the property <code>interval</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #interval}.</p>","!type":"fn()"},"resetMinimum":{"!doc":"<p>Resets the user value of the property <code>minimum</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #minimum}.</p>","!type":"fn()"},"setDecrease":{"!doc":"<p>Sets the user value of the property <code>decrease</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #decrease}.</p>","!type":"fn(value: Object) -> Object"},"setFirstInterval":{"!doc":"<p>Sets the user value of the property <code>firstInterval</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #firstInterval}.</p>","!type":"fn(value: Object) -> Object"},"setInterval":{"!doc":"<p>Sets the user value of the property <code>interval</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #interval}.</p>","!type":"fn(value: Object) -> Object"},"setMinimum":{"!doc":"<p>Sets the user value of the property <code>minimum</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #minimum}.</p>","!type":"fn(value: Object) -> Object"},"start":{"!doc":"<p>Reset and start the timer.</p>","!type":"fn()"},"stop":{"!doc":"<p>Stop the timer</p>","!type":"fn()"}}},"dispatch":{"AbstractBubbling":{"!proto":"qx.core.Object","!doc":"<p>Event dispatcher for all bubbling events.</p>","!type":"fn()","prototype":{"_getParent":{"!doc":"<p>Returns the parent of the given target</p>","!type":"fn(target: Object) -> Object"},"canDispatchEvent":{"!type":"fn(target: +undefined, event: +undefined, type: +undefined)"},"dispatchEvent":{"!type":"fn(target: +undefined, event: +undefined, type: +undefined)"}}},"Direct":{"!proto":"qx.core.Object","!doc":"<p>Dispatches events directly on the event target (no bubbling nor capturing).</p>","!type":"fn()","prototype":{"canDispatchEvent":{"!type":"fn(target: +undefined, event: +undefined, type: +undefined)"},"dispatchEvent":{"!type":"fn(target: +undefined, event: +undefined, type: +undefined)"}}},"DomBubbling":{"!proto":"qx.event.dispatch.AbstractBubbling","!doc":"<p>Event dispatcher for all bubbling events on <span class=\"caps\">DOM</span> elements.</p>","prototype":{"_getParent":{"!type":"fn(target: +undefined)"},"canDispatchEvent":{"!type":"fn(target: +undefined, event: +undefined, type: +undefined)"}}},"MouseCapture":{"!proto":"qx.event.dispatch.AbstractBubbling","!doc":"<p>Implementation of the Internet Explorer specific event capturing mode for\nmouse events <a href=\"http://msdn2.microsoft.com/en-us/library/ms536742.aspx\">http://msdn2.microsoft.com/en-us/library/ms536742.aspx</a>.</p>\n\n<p>This class is used internally by {@link qx.event.Manager} to do mouse event\ncapturing.</p>","!type":"fn()","prototype":{"_getParent":{"!type":"fn(target: +undefined)"},"activateCapture":{"!doc":"<p>Set the given element as target for event</p>","!type":"fn(element: +Element, containerCapture?: bool)"},"canDispatchEvent":{"!type":"fn(target: +undefined, event: +undefined, type: +undefined)"},"dispatchEvent":{"!type":"fn(target: +undefined, event: +undefined, type: +undefined)"},"getCaptureElement":{"!doc":"<p>Get the element currently capturing events.</p>","!type":"fn() -> +Element"},"nativeReleaseCapture":{"!doc":"<p>If the browser supports native mouse capturing, removes mouse capture\nfrom the object in the current document.</p>","!type":"fn(element: +Element)"},"nativeSetCapture":{"!doc":"<p>If the browser supports native mouse capturing, sets the mouse capture to\nthe object that belongs to the current document.</p>","!type":"fn(element: +Element, containerCapture?: bool)"},"releaseCapture":{"!doc":"<p>Stop capturing of mouse events.</p>","!type":"fn()"}}}},"Emitter":{"!proto":"Object","!doc":"<p>Basic implementation for an event emitter. This supplies a basic and\nminimalistic event mechanism.</p>","prototype":{"__getStorage":{"!doc":"<p>Internal helper which will return the storage for the given name.</p>","!type":"fn(name: string) -> +Array"},"addListener":{"!doc":"<p>Alternative for {@link #on}.</p>","!type":"fn(name: string, listener: fn(), ctx?: Object) -> +Integer"},"addListenerOnce":{"!doc":"<p>Alternative for {@link #once}.</p>","!type":"fn(name: string, listener: fn(), ctx?: Object) -> +Integer"},"emit":{"!doc":"<p>Emits an event with the given name. The data will be passed\nto the listener.</p>","!type":"fn(name: string, data?: Object)"},"getListeners":{"!doc":"<p>Returns the internal attached listener.</p>","!type":"fn() -> +Map"},"off":{"!doc":"<p>Remove a listener from the event emitter. The given <code>name</code>\nwill define the type of event.</p>","!type":"fn(name: string, listener: fn(), ctx?: Object) -> +Integer"},"offById":{"!doc":"<p>Removes the listener identified by the given <code>id</code>. The id\nwill be return on attaching the listener and can be stored for removing.</p>","!type":"fn(id: +Integer) -> +Integer"},"on":{"!doc":"<p>Attach a listener to the event emitter. The given <code>name</code>\nwill define the type of event. Handing in a <code>&#8217;*&#8217;</code> will\nlisten to all events emitted by the event emitter.</p>","!type":"fn(name: string, listener: fn(), ctx?: Object) -> +Integer"},"once":{"!doc":"<p>Attach a listener to the event emitter which will be executed only once.\nThe given <code>name</code> will define the type of event. Handing in a\n<code>&#8217;*&#8217;</code> will listen to all events emitted by the event emitter.</p>","!type":"fn(name: string, listener: fn(), ctx?: Object) -> +Integer"},"removeListener":{"!doc":"<p>Alternative for {@link #off}.</p>","!type":"fn(name: string, listener: fn(), ctx?: Object)"},"removeListenerById":{"!doc":"<p>Alternative for {@link #offById}.</p>","!type":"fn(id: +Integer)"}}},"GlobalError":{"!doc":"<p>The GlobalError class stores a reference to a global error handler function.</p>\n\n<p>This function is called for each uncatched JavaScript exception. To enable\n global error handling the setting <code>qx.globalErrorHandling</code> must\n be enabled and an error handler must be registered.\n Further each JavaScript &#8220;entry point&#8221; must be wrapped with a call to\n {@link qx.event.GlobalError#observeMethod}.</p>","__isGlobaErrorHandlingEnabled":{"!doc":"<p>Little helper to check if the global error handling is enabled.</p>","!type":"fn() -> bool"},"__onErrorWindow":{"!doc":"<p>Catches all errors of the <code>window.onerror</code> handler\nand passes an {@link qx.core.WindowError} object to the error\nhandling.</p>","!type":"fn(msg: string, uri: string, lineNumber: +Integer)"},"handleError":{"!doc":"<p>Delegates every given exception to the registered error handler</p>","!type":"fn(ex: +qx.core.WindowError)"},"observeMethod":{"!doc":"<p>Wraps a method with error handling code. Only methods, which are called\ndirectly by the browser (e.g. event handler) should be wrapped.</p>","!type":"fn(method: fn()) -> fn()"},"setErrorHandler":{"!doc":"<p>Set the global fallback error handler</p>","!type":"fn(callback: fn(), context: Object)"}},"handler":{"Appear":{"!proto":"qx.core.Object","!doc":"<p>This class supports <code>appear</code> and <code>disappear</code> events\non <span class=\"caps\">DOM</span> level.</p>","!type":"fn()","refresh":{"!doc":"<p>Refreshes all appear handlers. Useful after massive <span class=\"caps\">DOM</span> manipulations e.g.\nthrough qx.html.Element.</p>","!type":"fn()"},"prototype":{"canHandleEvent":{"!type":"fn(target: +undefined, type: +undefined)"},"refresh":{"!doc":"<p>This method should be called by all <span class=\"caps\">DOM</span> tree modifying routines\nto check the registered nodes for changes.</p>","!type":"fn()"},"registerEvent":{"!type":"fn(target: +undefined, type: +undefined, capture: +undefined)"},"unregisterEvent":{"!type":"fn(target: +undefined, type: +undefined, capture: +undefined)"}}},"Application":{"!proto":"qx.core.Object","!doc":"<p>This handler provides events for qooxdoo application startup/shutdown logic.</p>","!type":"fn()","onScriptLoaded":{"!doc":"<p>Sends the currently running application the ready signal. Used\nexclusively by package loader system.</p>","!type":"fn()"},"prototype":{"__fireReady":{"!doc":"<p>Fires a global ready event.</p>","!type":"fn()"},"_initObserver":{"!doc":"<p>Initializes the native application event listeners.</p>","!type":"fn()"},"_onNativeLoad":{"!doc":"<p>Event listener for native load event</p>","!type":"fn()"},"_onNativeUnload":{"!doc":"<p>Event listener for native unload event</p>","!type":"fn()"},"_stopObserver":{"!doc":"<p>Disconnect the native application event listeners.</p>","!type":"fn()"},"canHandleEvent":{"!type":"fn(target: +undefined, type: +undefined)"},"isApplicationReady":{"!doc":"<p>Whether the application is ready.</p>","!type":"fn() -> bool"},"registerEvent":{"!type":"fn(target: +undefined, type: +undefined, capture: +undefined)"},"unregisterEvent":{"!type":"fn(target: +undefined, type: +undefined, capture: +undefined)"}}},"Capture":{"!proto":"qx.core.Object","!doc":"<p>This class provides capture event support at <span class=\"caps\">DOM</span> level.</p>","prototype":{"canHandleEvent":{"!type":"fn(target: +undefined, type: +undefined)"},"registerEvent":{"!type":"fn(target: +undefined, type: +undefined, capture: +undefined)"},"unregisterEvent":{"!type":"fn(target: +undefined, type: +undefined, capture: +undefined)"}}},"DragDrop":{"!proto":"qx.core.Object","!doc":"<p>Event handler, which supports drag events on <span class=\"caps\">DOM</span> elements.</p>","!type":"fn()","prototype":{"__detectAction":{"!doc":"<p>Detects the current action and stores it under the private\nfield <code>__currentAction</code>. Also fires the event\n<code>dragchange</code> on every modification.</p>","!type":"fn()"},"__findDraggable":{"!doc":"<p>Finds next draggable parent of the given element. Maybe the element itself as well.</p>\n\n<p>Looks for the attribute <code>qxDraggable</code> with the value <code>on</code>.</p>","!type":"fn(elem: +Element) -> +Element"},"__findDroppable":{"!doc":"<p>Finds next droppable parent of the given element. Maybe the element itself as well.</p>\n\n<p>Looks for the attribute <code>qxDroppable</code> with the value <code>on</code>.</p>","!type":"fn(elem: +Element) -> +Element"},"__fireEvent":{"!doc":"<p>Wrapper for {@link qx.event.Registration#fireEvent} for drag&amp;drop events\nneeded in this class.</p>","!type":"fn(type: string, target: Object, relatedTarget: Object, cancelable: bool, original: +qx.event.type.Pointer) -> bool"},"__rebuildStructures":{"!doc":"<p>Rebuilds the internal data storage used during a drag&amp;drop session</p>","!type":"fn()"},"_onKeyDown":{"!doc":"<p>Event listener for root&#8217;s <code>keydown</code> event</p>","!type":"fn(e: +qx.event.type.KeySequence)"},"_onKeyPress":{"!doc":"<p>Event listener for root&#8217;s <code>keypress</code> event</p>","!type":"fn(e: +qx.event.type.KeySequence)"},"_onKeyUp":{"!doc":"<p>Event listener for root&#8217;s <code>keyup</code> event</p>","!type":"fn(e: +qx.event.type.KeySequence)"},"_onLongtap":{"!doc":"<p>Handler for long tap which takes care of starting the drag &amp; drop session for\ntouch interactions.</p>","!type":"fn(e: +qx.event.type.Tap)"},"_onRoll":{"!doc":"<p>Roll listener to stop scrolling on touch devices.</p>","!type":"fn(e: +qx.event.type.Roll)"},"_onTrack":{"!doc":"<p>Event handler for the track event which starts the session for mouse interactions and\nis responsible for firing the drag, dragover and dragleave event.</p>","!type":"fn(e: +qx.event.type.Track)"},"_onTrackEnd":{"!doc":"<p>Handler for the trackend event which is responsible fore firing the drop event.</p>","!type":"fn(e: +qx.event.type.Track)"},"_onTrackStart":{"!doc":"<p>Event handler for the trackstart event which stores the initial targets.</p>","!type":"fn(e: +qx.event.type.Track)"},"_onWindowBlur":{"!doc":"<p>Event listener for window&#8217;s <code>blur</code> event</p>","!type":"fn(e: +qx.event.type.Event)"},"_start":{"!doc":"<p>Helper to start the drag &amp; drop session. It is responsible for firing the\ndragstart event and attaching the key listener.</p>","!type":"fn(e: +qx.event.type.Pointer)"},"addAction":{"!doc":"<p>Registers a supported action. One of <code>move</code>,\n<code>copy</code> or <code>alias</code>.</p>","!type":"fn(action: string)"},"addData":{"!doc":"<p>Adds data of the given type to the internal storage. The data\nis available until the <code>dragend</code> event is fired.</p>","!type":"fn(type: string, data: Object)"},"addType":{"!doc":"<p>Registers a supported type</p>","!type":"fn(type: string)"},"canHandleEvent":{"!type":"fn(target: +undefined, type: +undefined)"},"clearSession":{"!doc":"<p>Cleans up a drag&amp;drop session when <code>dragstart</code> was fired before.</p>","!type":"fn()"},"getCurrentAction":{"!doc":"<p>Returns the currently selected action (by user keyboard modifiers)</p>","!type":"fn() -> string"},"getCurrentType":{"!doc":"<p>Returns the type which was requested last.</p>","!type":"fn() -> string"},"getCursor":{"!doc":"<p>Returns the (computed) value of the property <code>cursor</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #cursor}.</p>","!type":"fn() -> Object"},"getData":{"!doc":"<p>Returns the data of the given type during the <code>drop</code> event\non the drop target. This method fires a <code>droprequest</code> at\nthe drag target which should be answered by calls to {@link #addData}.</p>","!type":"fn(type: string) -> Object"},"getDragTarget":{"!doc":"<p>Returns the widget which has been the target of the drag start.</p>","!type":"fn() -> +qx.ui.core.Widget"},"initCursor":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>cursor</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #cursor}.</p>","!type":"fn(value: Object) -> Object"},"isSessionActive":{"!doc":"<p>Returns if a drag session is currently active</p>","!type":"fn() -> bool"},"registerEvent":{"!type":"fn(target: +undefined, type: +undefined, capture: +undefined)"},"resetCursor":{"!doc":"<p>Resets the user value of the property <code>cursor</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #cursor}.</p>","!type":"fn()"},"setCursor":{"!doc":"<p>Sets the user value of the property <code>cursor</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #cursor}.</p>","!type":"fn(value: Object) -> Object"},"supportsAction":{"!doc":"<p>Whether the current drag target supports the given action</p>","!type":"fn(type: string) -> bool"},"supportsType":{"!doc":"<p>Whether the current drag target supports the given type</p>","!type":"fn(type: string) -> bool"},"unregisterEvent":{"!type":"fn(target: +undefined, type: +undefined, capture: +undefined)"}}},"Element":{"!proto":"qx.core.Object","!doc":"<p>This class supports typical <span class=\"caps\">DOM</span> element inline events like scroll,\nchange, select, ...</p>","!type":"fn()","prototype":{"_onNative":{"!doc":"<p>Default event handler.</p>","!type":"fn(nativeEvent: +Event, eventId: +Integer)"},"canHandleEvent":{"!type":"fn(target: +undefined, type: +undefined)"},"registerEvent":{"!type":"fn(target: +undefined, type: +undefined, capture: +undefined)"},"unregisterEvent":{"!type":"fn(target: +undefined, type: +undefined, capture: +undefined)"}}},"ElementResize":{"!proto":"qx.core.Object","!doc":"<p>This handler fires a <code>resize</code> event if the size of a <span class=\"caps\">DOM</span> element\nchanges.</p>","!type":"fn()","prototype":{"_onInterval":{"!doc":"<p>Checks elements for width and height changes and fires resize event\nif needed.</p>","!type":"fn(e: +qx.event.type.Data)"},"canHandleEvent":{"!type":"fn(target: +undefined, type: +undefined)"},"registerEvent":{"!type":"fn(target: +undefined, type: +undefined, capture: +undefined)"},"unregisterEvent":{"!type":"fn(target: +undefined, type: +undefined, capture: +undefined)"}}},"Focus":{"!proto":"qx.core.Object","!doc":"<p>This handler is used to normalize all focus/activation requirements\nand normalize all cross browser quirks in this area.</p>\n\n<p>Notes:</p>\n\n<ul>\n<li>Webkit and Opera (before 9.5) do not support tabIndex for all elements<br />\n(See also: <a href=\"https://bugs.webkit.org/show_bug.cgi?id=7138\">https://bugs.webkit.org/show_bug.cgi?id=7138</a>)</li>\n</ul>\n\n<ul>\n<li>TabIndex is normally 0, which means all naturally focusable elements are focusable.</li>\n<li>TabIndex > 0 means that the element is focusable and tabable</li>\n<li>TabIndex < 0 means that the element, even if naturally possible, is not focusable.</li>\n</ul>","!type":"fn()","prototype":{"__doWindowBlur":{"!doc":"<p>Helper for native event listeners to react on window blur</p>","!type":"fn()"},"__doWindowFocus":{"!doc":"<p>Helper for native event listeners to react on window focus</p>","!type":"fn()"},"__findActivatableElement":{"!doc":"<p>Returns the next activatable element. May be the element itself.\nWorks a bit different than the method {@link #__findFocusableElement}\nas it looks up for a parent which is has a keep focus flag. When\nthere is such a parent it returns null otherwise the original\nincoming element.</p>","!type":"fn(el: +Element) -> +Element"},"__findFocusableElement":{"!doc":"<p>Returns the next focusable parent element of an activated <span class=\"caps\">DOM</span> element.</p>","!type":"fn(el: +Element) -> +Element"},"__fireEvent":{"!doc":"<p>Shorthand to fire events from within this class.</p>","!type":"fn(target: +Element, related: +Element, type: string, bubbles: bool)"},"__fixFocus":{"!doc":"<p>Fix for bug #2602.</p>","!type":"fn(target: +Element) -> +Element"},"__isFocusable":{"!doc":"<p>Whether the given element is focusable. This is perfectly modeled to the\nbrowsers behavior and this way may differ in the various clients.</p>","!type":"fn(el: +Element) -> bool"},"__isSelectable":{"!doc":"<p>Whether the given el (or its content) should be selectable\nby the user.</p>","!type":"fn(node: +Element) -> bool"},"__onNativeBlur":{"!doc":"<p>Native event listener for <code>blur</code>.</p>","!type":"fn(domEvent: +Event)"},"__onNativeDragGesture":{"!doc":"<p>Native event listener for <code>draggesture</code> event\nsupported by gecko. Used to stop native drag and drop when\nselection is disabled.</p>","!type":"fn(domEvent: +Event)"},"__onNativeFocus":{"!doc":"<p>Native event listener for <code>focus</code>.</p>","!type":"fn(domEvent: +Event)"},"__onNativeFocusIn":{"!doc":"<p>Native event listener for <code>DOMFocusIn</code> or <code>focusin</code>\ndepending on the client&#8217;s engine.</p>","!type":"fn(domEvent: +Event)"},"__onNativeFocusOut":{"!doc":"<p>Native event listener for <code>DOMFocusOut</code> or <code>focusout</code>\ndepending on the client&#8217;s engine.</p>","!type":"fn(domEvent: +Event)"},"__onNativeMouseDown":{"!doc":"<p>Native event listener for <code>mousedown</code>.</p>","!type":"fn(domEvent: +Event)"},"__onNativeMouseUp":{"!doc":"<p>Native event listener for <code>mouseup</code>.</p>","!type":"fn(domEvent: +Event)"},"__onNativeSelectStart":{"!doc":"<p>Native event listener for <code>selectstart</code>.</p>","!type":"fn(domEvent: +Event)"},"_applyActive":{"!doc":"<p>Applies changes of the property value of the property <code>active</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #active}.</p>","!type":"fn(value: Object, old: Object)"},"_applyFocus":{"!doc":"<p>Applies changes of the property value of the property <code>focus</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #focus}.</p>","!type":"fn(value: Object, old: Object)"},"_initObserver":{"!doc":"<p>Initializes event listeners.</p>","!type":"fn()"},"_stopObserver":{"!doc":"<p>Disconnects event listeners.</p>","!type":"fn()"},"activate":{"!doc":"<p>Activates the given <span class=\"caps\">DOM</span> element</p>","!type":"fn(element: +Element)"},"blur":{"!doc":"<p>Blurs the given <span class=\"caps\">DOM</span> element</p>","!type":"fn(element: +Element)"},"canHandleEvent":{"!type":"fn(target: +undefined, type: +undefined)"},"deactivate":{"!doc":"<p>Deactivates the given <span class=\"caps\">DOM</span> element</p>","!type":"fn(element: +Element)"},"focus":{"!doc":"<p>Focuses the given <span class=\"caps\">DOM</span> element</p>","!type":"fn(element: +Element)"},"getActive":{"!doc":"<p>Returns the (computed) value of the property <code>active</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #active}.</p>","!type":"fn() -> Object"},"getFocus":{"!doc":"<p>Returns the (computed) value of the property <code>focus</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #focus}.</p>","!type":"fn() -> Object"},"initActive":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>active</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #active}.</p>","!type":"fn(value: Object) -> Object"},"initFocus":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>focus</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #focus}.</p>","!type":"fn(value: Object) -> Object"},"registerEvent":{"!type":"fn(target: +undefined, type: +undefined, capture: +undefined)"},"resetActive":{"!doc":"<p>Resets the user value of the property <code>active</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #active}.</p>","!type":"fn()"},"resetFocus":{"!doc":"<p>Resets the user value of the property <code>focus</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #focus}.</p>","!type":"fn()"},"setActive":{"!doc":"<p>Sets the user value of the property <code>active</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #active}.</p>","!type":"fn(value: Object) -> Object"},"setFocus":{"!doc":"<p>Sets the user value of the property <code>focus</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #focus}.</p>","!type":"fn(value: Object) -> Object"},"tryActivate":{"!doc":"<p>Tries to activate the given element. This checks whether\nthe activation is allowed first.</p>","!type":"fn(element: +Element)"},"unregisterEvent":{"!type":"fn(target: +undefined, type: +undefined, capture: +undefined)"}}},"Gesture":{"!proto":"qx.event.handler.GestureCore","!doc":"<p>Unified gesture event handler.</p>","!type":"fn()","prototype":{"__callBase":{"!doc":"<p>Call overriden method.</p>","!type":"fn(method: string, args: +Array)"},"_fireEvent":{"!doc":"<p>Fire a touch event with the given parameters</p>","!type":"fn(domEvent: +Event, type?: string, target?: +Element)"},"_hasIntermediaryHandler":{"!type":"fn(target: +undefined)"},"_initObserver":{"!type":"fn()"},"_stopObserver":{"!type":"fn()"},"canHandleEvent":{"!type":"fn(target: +undefined, type: +undefined)"},"checkAndFireGesture":{"!doc":"<p>Checks if a gesture was made and fires the gesture event.</p>","!type":"fn(pointerEvent: +qx.event.type.Pointer, type?: string, target?: +Element)"},"dispose":{"!doc":"<p>Dispose this object</p>","!type":"fn()"},"registerEvent":{"!type":"fn(target: +undefined, type: +undefined, capture: +undefined)"},"unregisterEvent":{"!type":"fn(target: +undefined, type: +undefined, capture: +undefined)"}}},"GestureCore":{"!proto":"Object","!doc":"<p>Listens for (native or synthetic) pointer events and fires events\nfor gestures like &#8220;tap&#8221; or &#8220;swipe&#8221;</p>","!type":"fn()","prototype":{"__fireLongTap":{"!doc":"<p>Fires the long tap event.</p>","!type":"fn(domEvent: +Event, target: +Element)"},"__firePinch":{"!doc":"<p>Fires a pinch event.</p>","!type":"fn(domEvent: +Event, target: +Element)"},"__fireRotate":{"!doc":"<p>Fires a rotate event.</p>","!type":"fn(domEvent: +Event, target: +Element)"},"__fireTrack":{"!doc":"<p>Fires a track event.</p>","!type":"fn(type: string, domEvent: +Event, target: +Element)"},"__getSwipeGesture":{"!doc":"<p>Returns the swipe gesture when the user performed a swipe.</p>","!type":"fn(domEvent: +Event, target: +Element) -> +Map"},"__handleRollImpulse":{"!doc":"<p>Method which will be called recursively to provide a momentum scrolling.</p>","!type":"fn(deltaX: number, deltaY: number, domEvent: +Event, target: +Element, time?: number)"},"__isBelowDoubleTapDistance":{"!doc":"<p>Checks if the distance between the x1/y1 and x2/y2 is\nbelow the TAP_MAX_DISTANCE and returns the result.</p>","!type":"fn(x1: number, y1: number, x2: number, y2: number, type: string) -> bool"},"__stopLongTapTimer":{"!doc":"<p>Stops the time for the long tap event.</p>","!type":"fn(gesture: +Map)"},"_calcAngle":{"!doc":"<p>Calculates the angle of the primary and secondary pointer.</p>","!type":"fn() -> number"},"_calcDistance":{"!doc":"<p>Calculates the scaling distance between two pointers.</p>","!type":"fn() -> number"},"_fireEvent":{"!doc":"<p>Fire a gesture event with the given parameters</p>","!type":"fn(domEvent: +Event, type: string, target?: +Element)"},"_fireRoll":{"!doc":"<p>Fires a roll event.</p>","!type":"fn(domEvent: +Event, type: string, target: +Element)"},"_getDeltaCoordinates":{"!doc":"<p>Calculates the delta coordinates in relation to the position on <code>pointerstart</code> event.</p>","!type":"fn(domEvent: +Event) -> +Map"},"_hasIntermediaryHandler":{"!doc":"<p>Checks if a <span class=\"caps\">DOM</span> element located between the target of a gesture\nevent and the element this handler is attached to has a gesture\nhandler of its own.</p>","!type":"fn(target: +Element) -> bool"},"_initObserver":{"!doc":"<p>Register pointer event listeners</p>","!type":"fn()"},"_isBelowTapMaxDistance":{"!doc":"<p>Checks if the distance between the x/y coordinates of <span class=\"caps\">DOM</span> event\nexceeds TAP_MAX_DISTANCE and returns the result.</p>","!type":"fn(domEvent: +Event) -> bool"},"_onDblClick":{"!doc":"<p>Fire &#8220;tap&#8221; and &#8220;dbltap&#8221; events after a native &#8220;dblclick&#8221;\nevent to fix IE 8&#8217;s broken mouse event sequence.</p>","!type":"fn(domEvent: +Event)"},"_stopObserver":{"!doc":"<p>Remove native pointer event listeners.</p>","!type":"fn()"},"checkAndFireGesture":{"!doc":"<p>Checks if a gesture was made and fires the gesture event.</p>","!type":"fn(domEvent: +Event, type?: string, target?: +Element)"},"dispose":{"!doc":"<p>Dispose the current instance</p>","!type":"fn()"},"gestureBegin":{"!doc":"<p>Helper method for gesture start.</p>","!type":"fn(domEvent: +Event, target: +Element)"},"gestureCancel":{"!doc":"<p>Cancels the gesture if running.</p>","!type":"fn(id: number)"},"gestureFinish":{"!doc":"<p>Helper method for gesture end.</p>","!type":"fn(domEvent: +Event, target: +Element)"},"gestureMove":{"!doc":"<p>Helper method for gesture move.</p>","!type":"fn(domEvent: +Event, target: +Element)"},"isBelowTapMaxDistance":{"!doc":"<p>Checks if the distance between the x/y coordinates of touchstart/mousedown and touchmove/mousemove event\nexceeds TAP_MAX_DISTANCE and returns the result.</p>","!type":"fn(event: +Event) -> bool"},"stopMomentum":{"!doc":"<p>Stops the momentum scrolling currently running.</p>","!type":"fn(id: +Integer)"}}},"Iframe":{"!proto":"qx.core.Object","!doc":"<p>This handler provides a &#8220;load&#8221; event for iframes</p>","onevent":{"!doc":"<p>Internal function called by iframes created using {@link qx.bom.Iframe}.</p>","!type":"fn(target: +Element)"},"prototype":{"canHandleEvent":{"!type":"fn(target: +undefined, type: +undefined)"},"registerEvent":{"!type":"fn(target: +undefined, type: +undefined, capture: +undefined)"},"unregisterEvent":{"!type":"fn(target: +undefined, type: +undefined, capture: +undefined)"}}},"Input":{"!proto":"qx.core.Object","!doc":"<p>This handler provides an &#8220;change&#8221; event for all form fields and an\n&#8220;input&#8221; event for form fields of type &#8220;text&#8221; and &#8220;textarea&#8221;.</p>\n\n<p>To let these events work it is needed to create the elements using\n{@link qx.bom.Input}</p>","!type":"fn()","prototype":{"_inputFix":{"!doc":"<p>Handler for fixing the different behavior when pressing the backspace or\ndelete key.</p>\n\n<p>The other browsers fire a &#8220;input&#8221; event if the user presses the backspace\nor delete key.\nIE fire the event only for other keys.</p>","!type":"fn(e: +Event, target: +Element)"},"_onChangeChecked":{"!doc":"<p>Internal function called by input elements created using {@link qx.bom.Input}.</p>","!type":"fn(e: +Event)"},"_onChangeValue":{"!doc":"<p>Internal function called by input elements created using {@link qx.bom.Input}.</p>","!type":"fn(e: +Event)"},"_onInput":{"!doc":"<p>Internal function called by input elements created using {@link qx.bom.Input}.</p>","!type":"fn(e: +Event)"},"_onKeyDown":{"!doc":"<p>Key event listener for opera which recognizes if the enter key has been\npressed.</p>","!type":"fn(e: +Event)"},"_onKeyPress":{"!doc":"<p>Handler for fixing the different behavior when pressing the enter key.</p>\n\n<p>FF and Safari fire a &#8220;change&#8221; event if the user presses the enter key.\nIE and Opera fire the event only if the focus is changed.</p>","!type":"fn(e: +Event, target: +Element)"},"_onKeyUp":{"!doc":"<p>Key event listener for opera which recognizes if the enter key has been\npressed.</p>","!type":"fn(e: +Event)"},"_onProperty":{"!doc":"<p>Internal function called by input elements created using {@link qx.bom.Input}.</p>","!type":"fn(e: +Event)"},"canHandleEvent":{"!type":"fn(target: +undefined, type: +undefined)"},"registerEvent":{"!type":"fn(target: +undefined, type: +undefined, capture: +undefined)"},"unregisterEvent":{"!type":"fn(target: +undefined, type: +undefined)"}}},"Keyboard":{"!proto":"qx.core.Object","!doc":"<p>This class provides unified key event handler for Internet Explorer,\nFirefox, Opera and Safari.</p>","!type":"fn()","prototype":{"__firefoxInputFix":{"!doc":"<p>some keys like &#8220;up&#8221;, &#8220;down&#8221;, &#8220;pageup&#8221;, &#8220;pagedown&#8221; do not bubble a\n&#8220;keypress&#8221; event in Firefox. To work around this bug we attach keypress\nlisteners directly to the input events.</p>\n\n<p><a href=\"https://bugzilla.mozilla.org/show_bug.cgi?id=467513\">https://bugzilla.mozilla.org/show_bug.cgi?id=467513</a></p>","!type":"fn(target: +Element, type: string, keyCode: +Integer)"},"__getEventTarget":{"!doc":"<p>Get the target element for key events</p>","!type":"fn() -> +Element"},"__onKeyPress":{"!doc":"<p>Low level key press handler</p>","!type":"fn(domEvent: +Event)"},"__onKeyUpDown":{"!doc":"<p>Low level handler for &#8220;keyup&#8221; and &#8220;keydown&#8221; events</p>","!type":"fn(domEvent: +Event)"},"_fireInputEvent":{"!doc":"<p>Fire a key input event with the given parameters</p>","!type":"fn(domEvent: +Event, charCode: +Integer)"},"_fireSequenceEvent":{"!doc":"<p>Fire a key up/down/press event with the given parameters</p>","!type":"fn(domEvent: +Event, type: string, keyIdentifier: string)"},"_idealKeyHandler":{"!doc":"<p>Key handler for an idealized browser.\nRuns after the browser specific key handlers have normalized the key events.</p>","!type":"fn(keyCode: string, charCode: string, eventType: string, domEvent: +Element)"},"_identifierToKeyCode":{"!doc":"<p>converts a key identifier back to a keycode</p>","!type":"fn(keyIdentifier: string) -> +Integer"},"_initKeyObserver":{"!doc":"<p>Initializes the native key event listeners.</p>","!type":"fn()"},"_stopKeyObserver":{"!doc":"<p>Stops the native key event listeners.</p>","!type":"fn()"},"canHandleEvent":{"!type":"fn(target: +undefined, type: +undefined)"},"registerEvent":{"!type":"fn(target: +undefined, type: +undefined, capture: +undefined)"},"unregisterEvent":{"!type":"fn(target: +undefined, type: +undefined, capture: +undefined)"}}},"Mouse":{"!proto":"qx.core.Object","!doc":"<p>This class provides an unified mouse event handler for Internet Explorer,\nFirefox, Opera and Safari</p>","!type":"fn()","prototype":{"__differentTargetClickFixPost":{"!doc":"<p>If the mouseup event happens on a different target than the corresponding\nmousedown event the internet explorer dispatches a click event on the\nfirst common ancestor of both targets. The presence of this click event\nis essential for the qooxdoo widget system. All other browsers don&#8217;t fire\nthe click event so it must be emulated.</p>","!type":"fn(domEvent: +Event, type: string, target: +Element)"},"__doubleClickFixPre":{"!doc":"<p>Normalizes the click sequence of double click event in the Internet\nExplorer. The normalized sequence is:</p>\n\n<p>1. mousedown\n 2. mouseup\n 3. click\n 4. mousedown  <- not fired by IE\n 5. mouseup\n 6. click  <- not fired by IE\n 7. dblclick</p>\n\n<p>Note: This fix is only applied, when the IE event model is used, otherwise\n the fix is ignored.</p>","!type":"fn(domEvent: +Event, type: string, target: +Element)"},"__fireEvent":{"!doc":"<p>Fire a mouse event with the given parameters</p>","!type":"fn(domEvent: +Event, type: string, target: +Element)"},"__rightClickFixPost":{"!doc":"<p>Normalizes the click sequence of right click events in Webkit and Opera.\nThe normalized sequence is:</p>\n\n<p>1. mousedown  <- not fired by Webkit\n 2. mouseup  <- not fired by Webkit\n 3. contextmenu <- not fired by Opera</p>","!type":"fn(domEvent: +Event, type: string, target: +Element)"},"_initButtonObserver":{"!doc":"<p>Initializes the native mouse button event listeners.</p>","!type":"fn()"},"_initMoveObserver":{"!doc":"<p>Initializes the native mouse move event listeners.</p>","!type":"fn()"},"_initWheelObserver":{"!doc":"<p>Initializes the native mouse wheel event listeners.</p>","!type":"fn()"},"_onButtonEvent":{"!doc":"<p>Global handler for all mouse button related events like &#8220;mouseup&#8221;,\n&#8220;mousedown&#8221;, &#8220;click&#8221;, &#8220;dblclick&#8221; and &#8220;contextmenu&#8221;.</p>","!type":"fn(domEvent: +Event)"},"_onMoveEvent":{"!doc":"<p>Global handler for all mouse move related events like &#8220;mousemove&#8221;,\n&#8220;mouseout&#8221; and &#8220;mouseover&#8221;.</p>","!type":"fn(domEvent: +Event)"},"_onWheelEvent":{"!doc":"<p>Global handler for the mouse wheel event.</p>","!type":"fn(domEvent: +Event)"},"_stopButtonObserver":{"!doc":"<p>Disconnects the native mouse button event listeners.</p>","!type":"fn()"},"_stopMoveObserver":{"!doc":"<p>Disconnects the native mouse move event listeners.</p>","!type":"fn()"},"_stopWheelObserver":{"!doc":"<p>Disconnects the native mouse wheel event listeners.</p>","!type":"fn()"},"canHandleEvent":{"!type":"fn(target: +undefined, type: +undefined)"},"preventNextClick":{"!doc":"<p>Helper to prevent the next click.</p>","!type":"fn()"}}},"Object":{"!proto":"qx.core.Object","!doc":"<p>This class provides qooxdoo object event support.</p>","prototype":{"canHandleEvent":{"!type":"fn(target: +undefined, type: +undefined)"},"registerEvent":{"!type":"fn(target: +undefined, type: +undefined, capture: +undefined)"},"unregisterEvent":{"!type":"fn(target: +undefined, type: +undefined, capture: +undefined)"}}},"Offline":{"!proto":"qx.core.Object","!doc":"<p>This class provides a handler for the online event.</p>","!type":"fn()","prototype":{"_initObserver":{"!doc":"<p>Connects the native online and offline event listeners.</p>","!type":"fn()"},"_onNative":{"!doc":"<p>Native handler function which fires a qooxdoo event.</p>","!type":"fn(domEvent: +Event)"},"_stopObserver":{"!doc":"<p>Disconnects the native online and offline event listeners.</p>","!type":"fn()"},"canHandleEvent":{"!type":"fn(target: +undefined, type: +undefined)"},"isOnline":{"!doc":"<p>Returns whether the current window thinks its online or not.</p>","!type":"fn() -> bool"},"registerEvent":{"!type":"fn(target: +undefined, type: +undefined, capture: +undefined)"},"unregisterEvent":{"!type":"fn(target: +undefined, type: +undefined, capture: +undefined)"}}},"Orientation":{"!proto":"qx.core.Object","!doc":"<p>This class provides a handler for the orientation event.</p>","!type":"fn()","prototype":{"_initObserver":{"!doc":"<p>Initializes the native orientation change event listeners.</p>","!type":"fn()"},"_onNative":{"!doc":"<p>Handler for the native orientation change event.</p>","!type":"fn(domEvent: +Event)"},"_onOrientationChange":{"!doc":"<p>Handler for the detection of an orientation change.</p>","!type":"fn(domEvent: +Event)"},"_stopObserver":{"!doc":"<p>Disconnects the native orientation change event listeners.</p>","!type":"fn()"},"canHandleEvent":{"!type":"fn(target: +undefined, type: +undefined)"},"registerEvent":{"!type":"fn(target: +undefined, type: +undefined, capture: +undefined)"},"unregisterEvent":{"!type":"fn(target: +undefined, type: +undefined, capture: +undefined)"}}},"OrientationCore":{"!proto":"Object","!doc":"<p>Listens for native orientation change events</p>","!type":"fn()","prototype":{"_initObserver":{"!doc":"<p>Initializes the native orientation change event listeners.</p>","!type":"fn()"},"_onNative":{"!doc":"<p>Handler for the native orientation change event.</p>","!type":"fn(domEvent: +Event)"},"_stopObserver":{"!doc":"<p>Disconnects the native orientation change event listeners.</p>","!type":"fn()"}}},"Pointer":{"!proto":"qx.event.handler.PointerCore","!doc":"<p>Unified pointer event handler.</p>","!type":"fn()","prototype":{"__callBase":{"!doc":"<p>Call overriden method.</p>","!type":"fn(method: string, args: +Array)"},"_fireEvent":{"!doc":"<p>Fire a pointer event with the given parameters</p>","!type":"fn(domEvent: +Event, type?: string, target?: +Element)"},"_initPointerObserver":{"!type":"fn()"},"_onPointerEvent":{"!type":"fn(domEvent: +undefined)"},"canHandleEvent":{"!type":"fn(target: +undefined, type: +undefined)"},"dispose":{"!doc":"<p>Dispose this object</p>","!type":"fn()"},"registerEvent":{"!type":"fn(target: +undefined, type: +undefined, capture: +undefined)"},"unregisterEvent":{"!type":"fn(target: +undefined, type: +undefined, capture: +undefined)"}}},"PointerCore":{"!proto":"Object","!doc":"<p>Low-level pointer event handler.</p>","!type":"fn()","prototype":{"_fireEvent":{"!doc":"<p>Fire a touch event with the given parameters</p>","!type":"fn(domEvent: +Event, type?: string, target?: +Element)"},"_initObserver":{"!doc":"<p>Register native event listeners</p>","!type":"fn(callback: fn(), useEmitter: bool)"},"_initPointerObserver":{"!doc":"<p>Adds listeners to native pointer events if supported</p>","!type":"fn()"},"_isSimulatedMouseEvent":{"!doc":"<p>Detects whether the given MouseEvent position is identical to the previously fired TouchEvent position.\nIf <code>true</code> the corresponding event can be identified as simulated.</p>","!type":"fn(x: +Integer, y: +Integer) -> bool"},"_onMouseEvent":{"!doc":"<p>Handler for touch events</p>","!type":"fn(domEvent: +Event)"},"_onPointerEvent":{"!doc":"<p>Handler for native pointer events</p>","!type":"fn(domEvent: +Event)"},"_onTouchEvent":{"!doc":"<p>Handler for touch events</p>","!type":"fn(domEvent: +Event)"},"_stopObserver":{"!doc":"<p>Removes native pointer event listeners.</p>","!type":"fn()"},"dispose":{"!doc":"<p>Dispose this object</p>","!type":"fn()"}}},"Touch":{"!proto":"qx.event.handler.TouchCore","!doc":"<p>This class provides a unified touch event handler.</p>","!type":"fn()","prototype":{"__callBase":{"!doc":"<p>Call overriden method.</p>","!type":"fn(method: string, args: +Array)"},"_fireEvent":{"!doc":"<p>Fire a touch event with the given parameters</p>","!type":"fn(domEvent: +Event, type?: string, target?: +Element, eventTypeClass?: +Class)"},"_onTouchEvent":{"!doc":"<p>Handler for the native touch events.</p>","!type":"fn(domEvent: +Event)"},"canHandleEvent":{"!type":"fn(target: +undefined, type: +undefined)"},"dispose":{"!doc":"<p>Dispose this object</p>","!type":"fn()"},"registerEvent":{"!type":"fn(target: +undefined, type: +undefined, capture: +undefined)"},"unregisterEvent":{"!type":"fn(target: +undefined, type: +undefined, capture: +undefined)"}}},"TouchCore":{"!proto":"Object","!doc":"<p>Listens for native touch events and fires composite events like &#8220;tap&#8221; and\n&#8220;swipe&#8221;</p>","!type":"fn()","prototype":{"__evaluateTarget":{"!doc":"<p>This method fixes &#8220;pointer-events:none&#8221; for Internet Explorer 10.\nChecks which elements are placed to position x/y and traverses the array\ntill one element has no &#8220;pointer-events:none&#8221; inside its style attribute.</p>","!type":"fn(domEvent: +Event) -> +Element"},"_calcSingleTouchDelta":{"!doc":"<p>Calculates the delta of one single touch position relative to its position when <code>touchstart/code> event occured.</p>","!type":"fn(touch: +Event) -> +Map"},"_calcTouchesDelta":{"!doc":"<p>Calculates the delta of the touch position relative to its position when <code>touchstart/code> event occured.</p>","!type":"fn(touches: +Array) -> +Array"},"_commonTouchEventHandler":{"!doc":"<p>Called by an event handler.</p>","!type":"fn(domEvent: +Event, type?: string)"},"_detectTouchesByPointer":{"!doc":"<p>Creates an array with all current used touches out of multiple serial pointer events.\nNeeded because pointerEvents do not provide a touch list.</p>","!type":"fn(domEvent: +Event, type?: string) -> +Array"},"_fireEvent":{"!doc":"<p>Fire a touch event with the given parameters</p>","!type":"fn(domEvent: +Event, type?: string, target?: +Element)"},"_getRotationAngle":{"!doc":"<p>Calculates the rotation between two touches.</p>","!type":"fn(touch0: +Event, touch1: +Event) -> number"},"_getScalingDistance":{"!doc":"<p>Calculates the scaling distance between two touches.</p>","!type":"fn(touch0: +Event, touch1: +Event) -> number"},"_getTarget":{"!doc":"<p>Return the target of the event.</p>","!type":"fn(domEvent: +Event) -> +Element"},"_initTouchObserver":{"!doc":"<p>Initializes the native touch event listeners.</p>","!type":"fn()"},"_mapPointerEvent":{"!doc":"<p>Maps a pointer event type to the corresponding touch event type.</p>","!type":"fn(type: string) -> string"},"_onTouchEvent":{"!doc":"<p>Handler for native touch events.</p>","!type":"fn(domEvent: +Event)"},"_stopTouchObserver":{"!doc":"<p>Disconnects the native touch event listeners.</p>","!type":"fn()"},"dispose":{"!doc":"<p>Dispose this object</p>","!type":"fn()"}}},"Transition":{"!proto":"qx.core.Object","!doc":"<p><span class=\"caps\">EXPERIMENTAL</span> &#8211; <span class=\"caps\">NOT</span> <span class=\"caps\">READY</span> <span class=\"caps\">FOR</span> <span class=\"caps\">PRODUCTION</span></p>\n\n<p>This class provides support for HTML5 transition and animation events.\nCurrently only WebKit and Firefox are supported.</p>","!type":"fn()","prototype":{"_onNative":{"!doc":"<p>Global handler for the transition event.</p>","!type":"fn(domEvent: +Event)"},"canHandleEvent":{"!type":"fn(target: +undefined, type: +undefined)"},"registerEvent":{"!doc":"<p>This method is called each time an event listener, for one of the\nsupported events, is added using {@link qx.event.Manager#addListener}.</p>","!type":"fn(target: Object, type: string, capture: bool)"},"unregisterEvent":{"!doc":"<p>This method is called each time an event listener, for one of the\nsupported events, is removed by using {@link qx.event.Manager#removeListener}\nand no other event listener is listening on this type.</p>","!type":"fn(target: Object, type: string, capture: bool)"}}},"UserAction":{"!proto":"qx.core.Object","!doc":"<p>This handler accepts the useraction event fired by the keyboard, mouse and\npointer handlers after an user triggered action has occurred.</p>","!type":"fn()","prototype":{"canHandleEvent":{"!type":"fn(target: +undefined, type: +undefined)"},"registerEvent":{"!type":"fn(target: +undefined, type: +undefined, capture: +undefined)"},"unregisterEvent":{"!type":"fn(target: +undefined, type: +undefined, capture: +undefined)"}}},"Window":{"!proto":"qx.core.Object","!doc":"<p>This handler provides event for the window object.</p>","!type":"fn()","prototype":{"_initWindowObserver":{"!doc":"<p>Initializes the native window event listeners.</p>","!type":"fn()"},"_onNative":{"!doc":"<p>Native listener for all supported events.</p>","!type":"fn(e: +Event)"},"_stopWindowObserver":{"!doc":"<p>Disconnect the native window event listeners.</p>","!type":"fn()"},"canHandleEvent":{"!type":"fn(target: +undefined, type: +undefined)"},"registerEvent":{"!type":"fn(target: +undefined, type: +undefined, capture: +undefined)"},"unregisterEvent":{"!type":"fn(target: +undefined, type: +undefined, capture: +undefined)"}}}},"Idle":{"!proto":"qx.core.Object","!doc":"<p>A generic singleton that fires an &#8220;interval&#8221; event all 100 miliseconds. It\ncan be used whenever one needs to run code periodically. The main purpose of\nthis class is reduce the number of timers.</p>","!type":"fn()","prototype":{"_applyTimeoutInterval":{"!doc":"<p>Applies changes of the property value of the property <code>timeoutInterval</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #timeoutInterval}.</p>","!type":"fn(value: number, old: number)"},"_onInterval":{"!doc":"<p>Fires an &#8220;interval&#8221; event</p>","!type":"fn()"},"getTimeoutInterval":{"!doc":"<p>Returns the (computed) value of the property <code>timeoutInterval</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #timeoutInterval}.</p>","!type":"fn() -> Object"},"initTimeoutInterval":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>timeoutInterval</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #timeoutInterval}.</p>","!type":"fn(value: Object) -> Object"},"resetTimeoutInterval":{"!doc":"<p>Resets the user value of the property <code>timeoutInterval</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #timeoutInterval}.</p>","!type":"fn()"},"setTimeoutInterval":{"!doc":"<p>Sets the user value of the property <code>timeoutInterval</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #timeoutInterval}.</p>","!type":"fn(value: Object) -> Object"}},"getInstance":{"!doc":"<p>Returns a singleton instance of this class. On the first call the class\nis instantiated by calling the constructor with no arguments. All following\ncalls will return this instance.</p>\n\n<p>This method has been added by setting the &#8220;type&#8221; key in the class definition\n({@link qx.Class#define}) to &#8220;singleton&#8221;.</p>","!type":"fn() -> +qx.event.Idle"}},"IEventDispatcher":{"!doc":"<p>All event dispatchers must implement this interface. Event dispatchers must\nregister themselves at the event Manager using\n{@link qx.event.Registration#addDispatcher}.</p>","prototype":{"canDispatchEvent":{"!doc":"<p>Whether the dispatcher is responsible for the this event.</p>","!type":"fn(target: +Element, event: +qx.event.type.Event, type: string) -> bool"},"dispatchEvent":{"!doc":"<p>This function dispatches the event to the event listeners.</p>","!type":"fn(target: +Element, event: +qx.event.type.Event, type: string)"}}},"IEventHandler":{"!doc":"<p>Event handler Interface.</p>\n\n<p>All custom event handler like mouse or keyboard event handler must implement\nthis interface.</p>","prototype":{"canHandleEvent":{"!doc":"<p>Whether the event handler can handle events of the given type. If the\nevent handler class has a static variable called <code>IGNORE_CAN_HANDLE</code>\nwith the value <code>true</code> this function is not called. Whether the\nhandler can handle the event is them only determined by the static variables\n<code>SUPPORTED_TYPES</code> and <code>TARGET_CHECK</code>.</p>","!type":"fn(target: Object, type: string) -> bool"},"registerEvent":{"!doc":"<p>This method is called each time an event listener, for one of the\nsupported events, is added using {@link qx.event.Manager#addListener}.</p>","!type":"fn(target: Object, type: string, capture: bool)"},"unregisterEvent":{"!doc":"<p>This method is called each time an event listener, for one of the\nsupported events, is removed by using {@link qx.event.Manager#removeListener}\nand no other event listener is listening on this type.</p>","!type":"fn(target: Object, type: string, capture: bool)"}}},"Manager":{"!proto":"Object","!doc":"<p>Wrapper for browser <span class=\"caps\">DOM</span> event handling for each browser window/frame.</p>","!type":"fn()","getNextUniqueId":{"!doc":"<p>Returns an unique ID which may be used in combination with a target and\na type to identify an event entry.</p>","!type":"fn() -> string"},"prototype":{"__registerAtHandler":{"!doc":"<p>This method is called each time an event listener for one of the\nsupported events is added using {qx.event.Manager#addListener}.</p>","!type":"fn(target: Object, type: string, capture: bool)"},"__unregisterAtHandler":{"!doc":"<p>This method is called each time the an event listener for one of the\nsupported events is removed by using {qx.event.Manager#removeListener}\nand no other event listener is listening on this type.</p>","!type":"fn(target: Object, type: string, capture: bool)"},"addListener":{"!doc":"<p>Add an event listener to any valid target. The event listener is passed an\ninstance of {@link qx.event.type.Event} containing all relevant information\nabout the event as parameter.</p>","!type":"fn(target: Object, type: string, listener: fn(), self?: Object, capture?: bool) -> string"},"deleteAllListeners":{"!doc":"<p>Internal helper for deleting the internal listener  data structure for\nthe given targetKey.</p>","!type":"fn(targetKey: string)"},"dispatchEvent":{"!doc":"<p>Dispatches an event object using the qooxdoo event handler system. The\nevent will only be visible in event listeners attached using\n{@link #addListener}. After dispatching the event object will be pooled\nfor later reuse or disposed.</p>","!type":"fn(target: Object, event: +qx.event.type.Event) -> bool"},"dispose":{"!doc":"<p>Dispose the event manager</p>","!type":"fn()"},"findHandler":{"!doc":"<p>Get the event handler class matching the given event target and type</p>","!type":"fn(target: Object, type: string) -> +qx.event.IEventHandler"},"getAllListeners":{"!doc":"<p>Returns all registered listeners.</p>","!type":"fn() -> +Map"},"getDispatcher":{"!doc":"<p>Returns an instance of the given dispatcher class for this manager(window).</p>","!type":"fn(clazz: +Class) -> Object"},"getHandler":{"!doc":"<p>Returns an instance of the given handler class for this manager(window).</p>","!type":"fn(clazz: +Class) -> Object"},"getListeners":{"!doc":"<p>Get a copy of all event listeners for the given combination\nof target, event type and phase.</p>\n\n<p>This method is especially useful and for event handlers to\nto query the listeners registered in the manager.</p>","!type":"fn(target: Object, type: string, capture?: bool) -> +Array"},"getWindow":{"!doc":"<p>Get the window instance the event manager is responsible for</p>","!type":"fn() -> +Window"},"getWindowId":{"!doc":"<p>Get the hashcode of the manager&#8217;s window</p>","!type":"fn() -> string"},"hasListener":{"!doc":"<p>Check whether there are one or more listeners for an event type\nregistered at the target.</p>","!type":"fn(target: Object, type: string, capture?: bool) -> bool"},"importListeners":{"!doc":"<p>Imports a list of event listeners at once. This only\nworks for newly created elements as it replaces\nall existing data structures.</p>\n\n<p>Works with a map of data. Each entry in this map should be a\nmap again with the keys <code>type</code>, <code>listener</code>,\n<code>self</code>, <code>capture</code> and an optional <code>unique</code>.</p>\n\n<p>The values are identical to the parameters of {@link #addListener}.\nFor details please have a look there.</p>","!type":"fn(target: Object, list: +Map)"},"removeAllListeners":{"!doc":"<p>Remove all event listeners, which are attached to the given event target.</p>","!type":"fn(target: Object) -> bool"},"removeListener":{"!doc":"<p>Remove an event listener from an event target.</p>","!type":"fn(target: Object, type: string, listener: fn(), self?: Object, capture?: bool) -> bool"},"removeListenerById":{"!doc":"<p>Removes an event listener from an event target by an ID returned by\n{@link #addListener}.</p>","!type":"fn(target: Object, id: string) -> bool"},"serializeListeners":{"!doc":"<p>Returns a serialized array of all events attached on the given target.</p>","!type":"fn(target: Object) -> +Map"},"toggleAttachedEvents":{"!doc":"<p>This method might be used to temporally remove all events\ndirectly attached to the given target. This do not work\nhave any effect on bubbling events normally.</p>\n\n<p>This is mainly thought for detaching events in IE, before\ncloning them. It also removes all leak scenarios\nwhen unloading a document and may be used here as well.</p>","!type":"fn(target: Object, enable: bool)"}}},"message":{"Bus":{"!proto":"qx.core.Object","!doc":"<p>A simple message bus singleton.\nThe message bus registers subscriptions and notifies subscribers when\na matching message is dispatched</p>","checkSubscription":{"!doc":"<p>checks if subscription is already present\nif you supply the callback function, match only the exact message monitor\notherwise match all monitors that have the given message</p>","!type":"fn(message: string, subscriber: fn(), context: Object) -> bool"},"dispatch":{"!doc":"<p>dispatch message and call subscribed functions</p>","!type":"fn(msg: +qx.event.message.Message) -> bool"},"dispatchByName":{"!doc":"<p>Dispatches a new message by supplying the name of the\nmessage and its data.</p>","!type":"fn(name: string, data: Object) -> bool"},"getInstance":{"!doc":"<p>Returns a singleton instance of this class. On the first call the class\nis instantiated by calling the constructor with no arguments. All following\ncalls will return this instance.</p>\n\n<p>This method has been added by setting the &#8220;type&#8221; key in the class definition\n({@link qx.Class#define}) to &#8220;singleton&#8221;.</p>","!type":"fn() -> +qx.event.message.Bus"},"getSubscriptions":{"!doc":"<p>gets the hash map of message subscriptions</p>","!type":"fn() -> +Map"},"subscribe":{"!doc":"<p>subscribes to a message</p>","!type":"fn(message: string, subscriber: fn(), context: Object) -> bool"},"unsubscribe":{"!doc":"<p>unsubscribe a listening method\nif you supply the callback function and execution context,\nremove only this exact subscription\notherwise remove all subscriptions</p>","!type":"fn(message: string, subscriber: fn(), context: Object) -> bool"},"!type":"fn()","prototype":{"__callSubscribers":{"!doc":"<p>Call subscribers with passed message.</p>","!type":"fn(subscribers: +Map, msg: +qx.event.message.Message)"},"checkSubscription":{"!doc":"<p>checks if subscription is already present\nif you supply the callback function, match only the exact message monitor\notherwise match all monitors that have the given message</p>","!type":"fn(message: string, subscriber: fn(), context: Object) -> bool"},"dispatch":{"!doc":"<p>dispatch message and call subscribed functions</p>","!type":"fn(msg: +qx.event.message.Message) -> bool"},"dispatchByName":{"!doc":"<p>Dispatches a new message by supplying the name of the\nmessage and its data.</p>","!type":"fn(name: string, data: Object) -> bool"},"getSubscriptions":{"!doc":"<p>gets the hash map of message subscriptions</p>","!type":"fn() -> +Map"},"subscribe":{"!doc":"<p>subscribes to a message</p>","!type":"fn(message: string, subscriber: fn(), context: Object) -> bool"},"unsubscribe":{"!doc":"<p>unsubscribe a listening method\nif you supply the callback function and execution context,\nremove only this exact subscription\notherwise remove all subscriptions</p>","!type":"fn(message: string, subscriber: fn(), context: Object) -> bool"}}},"Message":{"!proto":"qx.core.Object","!doc":"<p>A message to be dispatched on the message bus.</p>","!type":"fn()","prototype":{"getData":{"!doc":"<p>Returns the (computed) value of the property <code>data</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #data}.</p>","!type":"fn() -> Object"},"getName":{"!doc":"<p>Returns the (computed) value of the property <code>name</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #name}.</p>","!type":"fn() -> Object"},"getSender":{"!doc":"<p>Returns the (computed) value of the property <code>sender</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #sender}.</p>","!type":"fn() -> Object"},"initData":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>data</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #data}.</p>","!type":"fn(value: Object) -> Object"},"initName":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>name</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #name}.</p>","!type":"fn(value: Object) -> Object"},"initSender":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>sender</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #sender}.</p>","!type":"fn(value: Object) -> Object"},"resetData":{"!doc":"<p>Resets the user value of the property <code>data</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #data}.</p>","!type":"fn()"},"resetName":{"!doc":"<p>Resets the user value of the property <code>name</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #name}.</p>","!type":"fn()"},"resetSender":{"!doc":"<p>Resets the user value of the property <code>sender</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #sender}.</p>","!type":"fn()"},"setData":{"!doc":"<p>Sets the user value of the property <code>data</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #data}.</p>","!type":"fn(value: Object) -> Object"},"setName":{"!doc":"<p>Sets the user value of the property <code>name</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #name}.</p>","!type":"fn(value: Object) -> Object"},"setSender":{"!doc":"<p>Sets the user value of the property <code>sender</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #sender}.</p>","!type":"fn(value: Object) -> Object"}}}},"Messaging":{"!doc":"<p>Define messages to react on certain channels.</p>\n\n<p>The channel names will be used in the {@link #on} method to define handlers which will\nbe called on certain channels and routes. The {@link #emit} method can be used\nto execute a given route on a channel. {@link #onAny} defines a handler on any channel.</p>\n\n<p><strong>Example</strong></p>\n\n<p>Here is a little example of how to use the messaging.</p>\n\n<pre class=\"javascript\">\n  var m = new qx.event.Messaging();\n\n  m.on(\"get\", \"/address/{id}\", function(data) {\n    var id = data.params.id; // 1234\n    // do something with the id...\n  },this);\n\n  m.emit(\"get\", \"/address/1234\");\n</pre>","!type":"fn()","prototype":{"_addListener":{"!doc":"<p>Adds a listener for a certain channel.</p>","!type":"fn(channel: string, type: string, handler: fn(), scope?: Object) -> string"},"_emit":{"!doc":"<p>Executes a certain channel with a given path. Informs all\nroute handlers that match with the path.</p>","!type":"fn(channel: string, path: string, params: +Map, customData: Object)"},"_emitListeners":{"!doc":"<p>Executes all given listener for a certain channel. Checks all listeners if they match\nwith the given path and executes the stored handler of the matching route.</p>","!type":"fn(channel: string, path: string, listeners: +Map, params: +Map, customData: Object) -> bool"},"_emitRoute":{"!doc":"<p>Executes a certain listener. Checks if the listener matches the given path and\nexecutes the stored handler of the route.</p>","!type":"fn(channel: string, path: string, listener: +Map, params: +Map, customData: Object) -> bool"},"emit":{"!doc":"<p>Sends a message on the given channel and informs all matching route handlers.</p>","!type":"fn(channel: string, path: string, params: +Map, customData: Object)"},"has":{"!doc":"<p>Checks if a listener is registered for the given path in the given channel.</p>","!type":"fn(channel: string, path: string) -> bool"},"on":{"!doc":"<p>Adds a route handler for the given channel. The route is called\nif the {@link #emit} method finds a match.</p>","!type":"fn(channel: string, type: string, handler: fn(), scope?: Object) -> string"},"onAny":{"!doc":"<p>Adds a handler for the &#8220;any&#8221; channel. The &#8220;any&#8221; channel is called\nbefore all other channels.</p>","!type":"fn(type: string, handler: fn(), scope?: Object) -> string"},"remove":{"!doc":"<p>Removes a registered listener by the given id.</p>","!type":"fn(id: string)"}}},"Pool":{"!proto":"qx.util.ObjectPool","!doc":"<p>Central instance pool for event objects. All event objects dispatched by the\nevent loader are pooled using this class.</p>","!type":"fn()","getInstance":{"!doc":"<p>Returns a singleton instance of this class. On the first call the class\nis instantiated by calling the constructor with no arguments. All following\ncalls will return this instance.</p>\n\n<p>This method has been added by setting the &#8220;type&#8221; key in the class definition\n({@link qx.Class#define}) to &#8220;singleton&#8221;.</p>","!type":"fn() -> +qx.event.Pool"}},"Registration":{"!doc":"<p>Wrapper for browser generic event handling.</p>\n\n<p>Supported events differ from target to target. Generally the handlers\nin {@link qx.event.handler} defines the available features.</p>","addDispatcher":{"!doc":"<p>Register an event dispatcher.</p>","!type":"fn(dispatcher: +qx.event.IEventDispatcher, priority: +Integer)"},"addHandler":{"!doc":"<p>Register an event handler.</p>","!type":"fn(handler: +qx.event.IEventHandler)"},"addListener":{"!doc":"<p>Add an event listener to a <span class=\"caps\">DOM</span> target. The event listener is passed an\ninstance of {@link qx.event.type.Event} containing all relevant information\nabout the event as parameter.</p>","!type":"fn(target: Object, type: string, listener: fn(), self?: Object, capture: bool) -> Object"},"createEvent":{"!doc":"<p>Get an event instance of the given class, which can be dispatched using\nan event manager. The created events must be initialized using\n{@link qx.event.type.Event#init}.</p>","!type":"fn(type: string, clazz?: Object, args?: +Array) -> +qx.event.type.Event"},"deleteAllListeners":{"!doc":"<p>Internal helper for deleting the listeners map used during shutdown.</p>","!type":"fn(target: Object)"},"dispatchEvent":{"!doc":"<p>Dispatch an event object on the given target.</p>\n\n<p>It is normally better to use {@link #fireEvent} because it uses\nthe event pooling and is quite handy otherwise as well. After dispatching\nthe event object will be pooled for later reuse or disposed.</p>","!type":"fn(target: Object, event: +qx.event.type.Event) -> bool"},"fireEvent":{"!doc":"<p>Create an event object and dispatch it on the given target.</p>","!type":"fn(target: Object, type: string, clazz?: +Class, args?: +Array) -> bool"},"fireNonBubblingEvent":{"!doc":"<p>Create an event object and dispatch it on the given target.\nThe event dispatched with this method does never bubble! Use only if you\nare sure that bubbling is not required.</p>","!type":"fn(target: Object, type: string, clazz?: +Class, args?: +Array) -> bool"},"getDispatchers":{"!doc":"<p>Get a list of registered event dispatchers.</p>","!type":"fn() -> +qx.event.IEventDispatcher"},"getHandlers":{"!doc":"<p>Get a list of registered event handlers.</p>","!type":"fn() -> +qx.event.IEventHandler"},"getManager":{"!doc":"<p>Get an instance of the event manager, which can handle events for the\ngiven target.</p>","!type":"fn(target: Object) -> +qx.event.Manager"},"hasListener":{"!doc":"<p>Check whether there are one or more listeners for an event type\nregistered at the target.</p>","!type":"fn(target: Object, type: string, capture?: bool) -> bool"},"removeAllListeners":{"!doc":"<p>Remove all event listeners, which are attached to the given event target.</p>","!type":"fn(target: Object) -> bool"},"removeListener":{"!doc":"<p>Remove an event listener from an event target.</p>\n\n<p>Note: All registered event listeners will automatically at page unload\n  so it is not necessary to detach events in the destructor.</p>","!type":"fn(target: Object, type: string, listener: fn(), self?: Object, capture: bool) -> bool"},"removeListenerById":{"!doc":"<p>Removes an event listener from an event target by an id returned by\n{@link #addListener}</p>","!type":"fn(target: Object, id: Object) -> bool"},"removeManager":{"!doc":"<p>Removes a manager for a specific window from the list.</p>\n\n<p>Normally only used when the manager gets disposed through\nan unload event of the attached window.</p>","!type":"fn(mgr: +qx.event.Manager)"},"serializeListeners":{"!doc":"<p>Returns a serialized array of all events attached on the given target.</p>","!type":"fn(target: Object) -> +Map"}},"Timer":{"!proto":"qx.core.Object","!doc":"<p>Global timer support.</p>\n\n<p>This class can be used to periodically fire an event. This event can be\nused to simulate e.g. a background task. The static method\n{@link #once} is a special case. It will call a function deferred after a\ngiven timeout.</p>","!type":"fn()","once":{"!doc":"<p>Start a function after a given timeout.</p>","!type":"fn(func: fn(), obj: Object, timeout: number) -> +qx.event.Timer"},"prototype":{"_applyEnabled":{"!doc":"<p>Apply the enabled state of the timer.</p>","!type":"fn(value: Object, old: Object)"},"_applyInterval":{"!doc":"<p>Apply the interval of the timer.</p>","!type":"fn(value: Object, old: Object)"},"_oninterval":{"!doc":"<p>timer callback</p>","!type":"fn()"},"getEnabled":{"!doc":"<p>Returns the (computed) value of the property <code>enabled</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #enabled}.</p>","!type":"fn() -> Object"},"getInterval":{"!doc":"<p>Returns the (computed) value of the property <code>interval</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #interval}.</p>","!type":"fn() -> Object"},"initEnabled":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>enabled</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #enabled}.</p>","!type":"fn(value: Object) -> Object"},"initInterval":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>interval</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #interval}.</p>","!type":"fn(value: Object) -> Object"},"isEnabled":{"!doc":"<p>Check whether the (computed) value of the boolean property <code>enabled</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #enabled}.</p>","!type":"fn() -> bool"},"resetEnabled":{"!doc":"<p>Resets the user value of the property <code>enabled</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #enabled}.</p>","!type":"fn()"},"resetInterval":{"!doc":"<p>Resets the user value of the property <code>interval</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #interval}.</p>","!type":"fn()"},"restart":{"!doc":"<p>Restart the timer.\nThis makes it possible to change the interval of a running timer.</p>","!type":"fn()"},"restartWith":{"!doc":"<p>Restart the timer. with a given interval.</p>","!type":"fn(interval: +Integer)"},"setEnabled":{"!doc":"<p>Sets the user value of the property <code>enabled</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #enabled}.</p>","!type":"fn(value: Object) -> Object"},"setInterval":{"!doc":"<p>Sets the user value of the property <code>interval</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #interval}.</p>","!type":"fn(value: Object) -> Object"},"start":{"!doc":"<p>Start the timer</p>","!type":"fn()"},"startWith":{"!doc":"<p>Start the timer with a given interval</p>","!type":"fn(interval: +Integer)"},"stop":{"!doc":"<p>Stop the timer.</p>","!type":"fn()"},"toggleEnabled":{"!doc":"<p>Toggles the (computed) value of the boolean property <code>enabled</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #enabled}.</p>","!type":"fn() -> bool"}}},"type":{"Data":{"!proto":"qx.event.type.Event","!doc":"<p>Event object for data holding event or data changes.</p>","prototype":{"clone":{"!doc":"<p>Get a copy of this object</p>","!type":"fn(embryo?: +qx.event.type.Data) -> +qx.event.type.Data"},"getData":{"!doc":"<p>The new data of the event sending this data event.\nThe return data type is the same as the event data type.</p>","!type":"fn() -> Object"},"getOldData":{"!doc":"<p>The old data of the event sending this data event.\nThe return data type is the same as the event data type.</p>","!type":"fn() -> Object"},"init":{"!doc":"<p>Initializes an event object.</p>","!type":"fn(data: Object, old?: Object, cancelable?: bool) -> +qx.event.type.Data"}}},"dom":{"Custom":{"!proto":"Object","!doc":"<p>Cross-browser custom UI event</p>","!type":"fn()","prototype":{"_createEvent":{"!doc":"<p>Creates a custom event object</p>","!type":"fn() -> +Event"},"_initEvent":{"!doc":"<p>Initializes a custom event</p>","!type":"fn(domEvent: +Event, customProps: +Map)"}}},"Pointer":{"!proto":"qx.event.type.dom.Custom","!doc":"<p>Synthetic pointer event</p>","getDocumentLeft":{"!doc":"<p>Get the horizontal position at which the event occurred relative to the\nleft of the document. This property takes into account any scrolling of\nthe page.</p>","!type":"fn() -> number"},"getDocumentTop":{"!doc":"<p>Get the vertical position at which the event occurred relative to the\ntop of the document. This property takes into account any scrolling of\nthe page.</p>","!type":"fn() -> number"},"getPointerType":{"!doc":"<p>Returns the device type which the event triggered. This can be one\nof the following strings: <code>mouse</code>, <code>pen</code>\nor <code>touch</code>.</p>","!type":"fn() -> string"},"getScreenLeft":{"!doc":"<p>Get the horizontal coordinate at which the event occurred relative to\nthe origin of the screen coordinate system.</p>\n\n<p>Note: This value is usually not very useful unless you want to\nposition a native popup window at this coordinate.</p>","!type":"fn() -> number"},"getScreenTop":{"!doc":"<p>Get the vertical coordinate at which the event occurred relative to\nthe origin of the screen coordinate system.</p>\n\n<p>Note: This value is usually not very useful unless you want to\nposition a native popup window at this coordinate.</p>","!type":"fn() -> number"},"getViewportLeft":{"!doc":"<p>Get the horizontal coordinate at which the event occurred relative\nto the viewport.</p>","!type":"fn() -> number"},"getViewportTop":{"!doc":"<p>Get the vertical coordinate at which the event occurred relative\nto the viewport.</p>","!type":"fn() -> number"},"normalize":{"!doc":"<p>Manipulates the event object, adding methods if they&#8217;re not\nalready present</p>","!type":"fn(event: +Event)"},"!type":"fn()","prototype":{"_createEvent":{"!type":"fn()"},"_initEvent":{"!type":"fn(domEvent: +undefined, customProps: +undefined)"}}}},"Dom":{"!proto":"qx.event.type.Native","!doc":"<p>Common base class for all <span class=\"caps\">DOM</span> events.</p>","prototype":{"_cloneNativeEvent":{"!type":"fn(nativeEvent: +undefined, clone: +undefined)"},"getModifiers":{"!doc":"<p>Return in a bit map, which modifier keys are pressed. The constants\n{@link #SHIFT_MASK}, {@link #CTRL_MASK}, {@link #ALT_MASK} and\n{@link #META_MASK} define the bit positions of the corresponding keys.</p>","!type":"fn() -> +Integer"},"isAltPressed":{"!doc":"<p>Returns whether the alt key is pressed.</p>","!type":"fn() -> bool"},"isCtrlOrCommandPressed":{"!doc":"<p>Returns whether the ctrl key or (on the Mac) the command key is pressed.</p>","!type":"fn() -> bool"},"isCtrlPressed":{"!doc":"<p>Returns whether the ctrl key is pressed.</p>","!type":"fn() -> bool"},"isMetaPressed":{"!doc":"<p>Returns whether the meta key is pressed.</p>","!type":"fn() -> bool"},"isShiftPressed":{"!doc":"<p>Returns whether the shift key is pressed.</p>","!type":"fn() -> bool"}}},"Drag":{"!proto":"qx.event.type.Event","!doc":"<p>Event object class for drag events</p>","prototype":{"addAction":{"!doc":"<p>Used during <code>dragstart</code> listener to\ninform the manager about supported drop actions.</p>","!type":"fn(action: string)"},"addData":{"!doc":"<p>Adds data of the given type to the internal storage. The data\nis available until the <code>dragend</code> event is fired.</p>","!type":"fn(type: string, data: Object)"},"addType":{"!doc":"<p>Used during <code>dragstart</code> listener to\ninform the manager about supported data types.</p>","!type":"fn(type: string)"},"clone":{"!type":"fn(embryo: +undefined)"},"getCurrentAction":{"!doc":"<p>Returns the currently selected action. Depends on the\nsupported actions of the source target and the modification\nkeys pressed by the user.</p>\n\n<p>Used in the <code>droprequest</code> listener.</p>","!type":"fn() -> string"},"getCurrentType":{"!doc":"<p>Returns the type which was requested last, to be used\nin the <code>droprequest</code> listener.</p>","!type":"fn() -> string"},"getData":{"!doc":"<p>Returns the data of the given type. Used in the <code>drop</code> listener.</p>","!type":"fn(type: string) -> Object"},"getDocumentLeft":{"!doc":"<p>Get the horizontal position at which the event occurred relative to the\nleft of the document. This property takes into account any scrolling of\nthe page.</p>","!type":"fn() -> +Integer"},"getDocumentTop":{"!doc":"<p>Get the vertical position at which the event occurred relative to the\ntop of the document. This property takes into account any scrolling of\nthe page.</p>","!type":"fn() -> +Integer"},"getDragTarget":{"!doc":"<p>Returns the target which has been initially tapped on.</p>","!type":"fn() -> +qx.ui.core.Widget"},"getManager":{"!doc":"<p>Returns the drag&amp;drop event handler responsible for the target</p>","!type":"fn() -> +qx.event.handler.DragDrop"},"init":{"!doc":"<p>Initialize the fields of the event. The event must be initialized before\nit can be dispatched.</p>","!type":"fn(cancelable?: bool, originalEvent: +qx.event.type.Track) -> +qx.event.type.Event"},"stopSession":{"!doc":"<p>Stops the drag&amp;drop session and fires a <code>dragend</code> event.</p>","!type":"fn()"},"supportsAction":{"!doc":"<p>Whether the given action is supported by the drag\ntarget (source target).</p>\n\n<p>This is used in the event listeners for <code>dragover</code>\nor <code>dragdrop</code>.</p>","!type":"fn(action: string) -> bool"},"supportsType":{"!doc":"<p>Whether the given type is supported by the drag\ntarget (source target).</p>\n\n<p>This is used in the event listeners for <code>dragover</code>\nor <code>dragdrop</code>.</p>","!type":"fn(type: string) -> bool"}}},"Event":{"!proto":"qx.core.Object","!doc":"<p>Basic event object.</p>\n\n<p>Please note:\nEvent objects are only valid during the event dispatch. After the dispatch\nevent objects are pooled or disposed. If you want to safe a reference to an\nevent instance use the {@link #clone} method.</p>\n\n<p>The interface is modeled after the <span class=\"caps\">DOM</span> level 2 event interface:\n<a href=\"http://www.w3.org/TR/DOM-Level-2-Events/events.html#Events-interface\">http://www.w3.org/TR/DOM-Level-2-Events/events.html#Events-interface</a></p>","prototype":{"clone":{"!doc":"<p>Create a clone of the event object, which is not automatically disposed\nor pooled after an event dispatch.</p>","!type":"fn(embryo?: +qx.event.type.Event) -> +qx.event.type.Event"},"getBubbles":{"!doc":"<p>Check whether or not the event is a bubbling event. If the event can\nbubble the value is true, else the value is false.</p>","!type":"fn() -> bool"},"getCurrentTarget":{"!doc":"<p>Get the event target node whose event listeners are currently being\nprocessed. This is particularly useful during event capturing and\nbubbling.</p>","!type":"fn() -> +Element"},"getDefaultPrevented":{"!doc":"<p>Get whether the default action has been prevented</p>","!type":"fn() -> bool"},"getEventPhase":{"!doc":"<p>Used to indicate which phase of event flow is currently being evaluated.</p>","!type":"fn() -> +Integer"},"getOriginalTarget":{"!doc":"<p>Get the original event target. This is only configured\nfor events which are fired by another event (often when\nthe target should be reconfigured for another view) e.g.\nlow-level <span class=\"caps\">DOM</span> event to widget event.</p>","!type":"fn() -> +Element"},"getPropagationStopped":{"!doc":"<p>Get whether further event propagation has been stopped.</p>","!type":"fn() -> bool"},"getRelatedTarget":{"!doc":"<p>Get the related event target. This is only configured for\nevents which also had an influences on another element e.g.\nmouseover/mouseout, focus/blur, ...</p>","!type":"fn() -> +Element"},"getTarget":{"!doc":"<p>Returns the event target to which the event was originally\ndispatched.</p>","!type":"fn() -> +Element"},"getTimeStamp":{"!doc":"<p>The time (in milliseconds relative to the epoch) at which the event was created.</p>","!type":"fn() -> +Integer"},"getType":{"!doc":"<p>The name of the event</p>","!type":"fn() -> string"},"init":{"!doc":"<p>Initialize the fields of the event. The event must be initialized before\nit can be dispatched.</p>","!type":"fn(canBubble?: bool, cancelable?: bool) -> +qx.event.type.Event"},"isCancelable":{"!doc":"<p>Get whether the event is cancelable</p>","!type":"fn() -> bool"},"preventDefault":{"!doc":"<p>Prevent the default action of cancelable events, e.g. opening the context\nmenu, ...</p>","!type":"fn()"},"setBubbles":{"!doc":"<p>Set whether the event bubbles.</p>","!type":"fn(bubbles: bool)"},"setCancelable":{"!doc":"<p>Set whether the event is cancelable</p>","!type":"fn(cancelable: bool)"},"setCurrentTarget":{"!doc":"<p>Override current target.</p>","!type":"fn(currentTarget: +Element)"},"setEventPhase":{"!doc":"<p>Override the event phase</p>","!type":"fn(eventPhase: +Integer)"},"setOriginalTarget":{"!doc":"<p>Override original target.</p>","!type":"fn(originalTarget: +Element)"},"setRelatedTarget":{"!doc":"<p>Override related target.</p>","!type":"fn(relatedTarget: +Element)"},"setTarget":{"!doc":"<p>Override event target.</p>","!type":"fn(target: +Element)"},"setType":{"!doc":"<p>Override the event type</p>","!type":"fn(type: string)"},"stop":{"!doc":"<p>Stops event from all further processing. Execute this when the\ncurrent handler should have &#8220;exclusive rights&#8221; to the event\nand no further reaction by anyone else should happen.</p>","!type":"fn()"},"stopPropagation":{"!doc":"<p>This method is used to prevent further propagation of an event during event\nflow. If this method is called by any event listener the event will cease\npropagating through the tree. The event will complete dispatch to all listeners\non the current event target before event flow stops.</p>","!type":"fn()"}}},"Focus":{"!proto":"qx.event.type.Event","!doc":"<p>Common base class for all focus events.</p>","prototype":{"init":{"!doc":"<p>Initialize the fields of the event. The event must be initialized before\nit can be dispatched.</p>","!type":"fn(target: Object, relatedTarget: Object, canBubble?: bool) -> +qx.event.type.Event"}}},"GeoPosition":{"!proto":"qx.event.type.Event","!doc":"<p><span class=\"caps\">EXPERIMENTAL</span> &#8211; <span class=\"caps\">NOT</span> <span class=\"caps\">READY</span> <span class=\"caps\">FOR</span> <span class=\"caps\">PRODUCTION</span></p>\n\n<p>GeoPosition event used by GeoLocation class.</p>","!type":"fn()","prototype":{"getAccuracy":{"!doc":"<p>Returns the (computed) value of the property <code>accuracy</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #accuracy}.</p>","!type":"fn() -> Object"},"getAltitude":{"!doc":"<p>Returns the (computed) value of the property <code>altitude</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #altitude}.</p>","!type":"fn() -> Object"},"getAltitudeAccuracy":{"!doc":"<p>Returns the (computed) value of the property <code>altitudeAccuracy</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #altitudeAccuracy}.</p>","!type":"fn() -> Object"},"getHeading":{"!doc":"<p>Returns the (computed) value of the property <code>heading</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #heading}.</p>","!type":"fn() -> Object"},"getLatitude":{"!doc":"<p>Returns the (computed) value of the property <code>latitude</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #latitude}.</p>","!type":"fn() -> Object"},"getLongitude":{"!doc":"<p>Returns the (computed) value of the property <code>longitude</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #longitude}.</p>","!type":"fn() -> Object"},"getSpeed":{"!doc":"<p>Returns the (computed) value of the property <code>speed</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #speed}.</p>","!type":"fn() -> Object"},"getTimestamp":{"!doc":"<p>Returns the (computed) value of the property <code>timestamp</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #timestamp}.</p>","!type":"fn() -> Object"},"init":{"!doc":"<p>Initialize the fields of the event.</p>","!type":"fn(position: +Map)"},"initAccuracy":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>accuracy</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #accuracy}.</p>","!type":"fn(value: Object) -> Object"},"initAltitude":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>altitude</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #altitude}.</p>","!type":"fn(value: Object) -> Object"},"initAltitudeAccuracy":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>altitudeAccuracy</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #altitudeAccuracy}.</p>","!type":"fn(value: Object) -> Object"},"initHeading":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>heading</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #heading}.</p>","!type":"fn(value: Object) -> Object"},"initLatitude":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>latitude</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #latitude}.</p>","!type":"fn(value: Object) -> Object"},"initLongitude":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>longitude</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #longitude}.</p>","!type":"fn(value: Object) -> Object"},"initSpeed":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>speed</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #speed}.</p>","!type":"fn(value: Object) -> Object"},"initTimestamp":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>timestamp</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #timestamp}.</p>","!type":"fn(value: Object) -> Object"},"resetAccuracy":{"!doc":"<p>Resets the user value of the property <code>accuracy</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #accuracy}.</p>","!type":"fn()"},"resetAltitude":{"!doc":"<p>Resets the user value of the property <code>altitude</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #altitude}.</p>","!type":"fn()"},"resetAltitudeAccuracy":{"!doc":"<p>Resets the user value of the property <code>altitudeAccuracy</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #altitudeAccuracy}.</p>","!type":"fn()"},"resetHeading":{"!doc":"<p>Resets the user value of the property <code>heading</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #heading}.</p>","!type":"fn()"},"resetLatitude":{"!doc":"<p>Resets the user value of the property <code>latitude</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #latitude}.</p>","!type":"fn()"},"resetLongitude":{"!doc":"<p>Resets the user value of the property <code>longitude</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #longitude}.</p>","!type":"fn()"},"resetSpeed":{"!doc":"<p>Resets the user value of the property <code>speed</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #speed}.</p>","!type":"fn()"},"resetTimestamp":{"!doc":"<p>Resets the user value of the property <code>timestamp</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #timestamp}.</p>","!type":"fn()"},"setAccuracy":{"!doc":"<p>Sets the user value of the property <code>accuracy</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #accuracy}.</p>","!type":"fn(value: Object) -> Object"},"setAltitude":{"!doc":"<p>Sets the user value of the property <code>altitude</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #altitude}.</p>","!type":"fn(value: Object) -> Object"},"setAltitudeAccuracy":{"!doc":"<p>Sets the user value of the property <code>altitudeAccuracy</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #altitudeAccuracy}.</p>","!type":"fn(value: Object) -> Object"},"setHeading":{"!doc":"<p>Sets the user value of the property <code>heading</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #heading}.</p>","!type":"fn(value: Object) -> Object"},"setLatitude":{"!doc":"<p>Sets the user value of the property <code>latitude</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #latitude}.</p>","!type":"fn(value: Object) -> Object"},"setLongitude":{"!doc":"<p>Sets the user value of the property <code>longitude</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #longitude}.</p>","!type":"fn(value: Object) -> Object"},"setSpeed":{"!doc":"<p>Sets the user value of the property <code>speed</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #speed}.</p>","!type":"fn(value: Object) -> Object"},"setTimestamp":{"!doc":"<p>Sets the user value of the property <code>timestamp</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #timestamp}.</p>","!type":"fn(value: Object) -> Object"}}},"KeyInput":{"!proto":"qx.event.type.Dom","!doc":"<p>Keyboard input event object.</p>\n\n<p>the interface of this class is based on the <span class=\"caps\">DOM</span> Level 3 keyboard event\ninterface: <a href=\"http://www.w3.org/TR/DOM-Level-3-Events/#events-keyboardevents\">http://www.w3.org/TR/DOM-Level-3-Events/#events-keyboardevents</a></p>","prototype":{"clone":{"!type":"fn(embryo: +undefined)"},"getChar":{"!doc":"<p>Returns the pressed character</p>","!type":"fn() -> string"},"getCharCode":{"!doc":"<p>Unicode number of the pressed character.</p>","!type":"fn() -> +Integer"},"init":{"!doc":"<p>Initialize the fields of the event.</p>","!type":"fn(domEvent: +Event, target: Object, charCode: +Integer) -> +qx.event.type.KeyInput"}}},"KeySequence":{"!proto":"qx.event.type.Dom","!doc":"<p>Keyboard event object.</p>\n\n<p>the interface of this class is based on the <span class=\"caps\">DOM</span> Level 3 keyboard event\ninterface: <a href=\"http://www.w3.org/TR/DOM-Level-3-Events/#events-keyboardevents\">http://www.w3.org/TR/DOM-Level-3-Events/#events-keyboardevents</a></p>","prototype":{"clone":{"!type":"fn(embryo: +undefined)"},"getKeyCode":{"!doc":"<p>Returns the native keyCode and is best used on keydown/keyup events to\ncheck which physical key was pressed.\nDon&#8217;t use this on keypress events because it&#8217;s erroneous and\ninconsistent across browsers. But it can be used to detect which key is\nexactly pressed (e.g. for num pad keys).\nIn any regular case, you should use {@link #getKeyIdentifier} which\ntakes care of all cross browser stuff.</p>\n\n<p>The key codes are not character codes, they are just <span class=\"caps\">ASCII</span> codes to\nidentify the keyboard (or other input devices) keys.</p>","!type":"fn() -> number"},"getKeyIdentifier":{"!doc":"<p>Identifier of the pressed key. This property is modeled after the <em>KeyboardEvent.keyIdentifier</em> property\nof the W3C <span class=\"caps\">DOM</span> 3 event specification\n(<a href=\"http://www.w3.org/TR/2003/NOTE-DOM-Level-3-Events-20031107/events.html#Events-KeyboardEvent-keyIdentifier\">http://www.w3.org/TR/2003/NOTE-DOM-Level-3-Events-20031107/events.html#Events-KeyboardEvent-keyIdentifier</a>).</p>\n\n<p>Printable keys are represented by an unicode string, non-printable keys\nhave one of the following values:</p>\n\n<table>\n<tr><th>Backspace</th><td>The Backspace (Back) key.</td></tr>\n<tr><th>Tab</th><td>The Horizontal Tabulation (Tab) key.</td></tr>\n<tr><th>Space</th><td>The Space (Spacebar) key.</td></tr>\n<tr><th>Enter</th><td>The Enter key. Note: This key identifier is also used for the Return (Macintosh numpad) key.</td></tr>\n<tr><th>Shift</th><td>The Shift key.</td></tr>\n<tr><th>Control</th><td>The Control (Ctrl) key.</td></tr>\n<tr><th>Alt</th><td>The Alt (Menu) key.</td></tr>\n<tr><th>CapsLock</th><td>The CapsLock key</td></tr>\n<tr><th>Meta</th><td>The Meta key. (Apple Meta and Windows key)</td></tr>\n<tr><th>Escape</th><td>The Escape (Esc) key.</td></tr>\n<tr><th>Left</th><td>The Left Arrow key.</td></tr>\n<tr><th>Up</th><td>The Up Arrow key.</td></tr>\n<tr><th>Right</th><td>The Right Arrow key.</td></tr>\n<tr><th>Down</th><td>The Down Arrow key.</td></tr>\n<tr><th>PageUp</th><td>The Page Up key.</td></tr>\n<tr><th>PageDown</th><td>The Page Down (Next) key.</td></tr>\n<tr><th>End</th><td>The End key.</td></tr>\n<tr><th>Home</th><td>The Home key.</td></tr>\n<tr><th>Insert</th><td>The Insert (Ins) key. (Does not fire in Opera/Win)</td></tr>\n<tr><th>Delete</th><td>The Delete (Del) Key.</td></tr>\n<tr><th>F1</th><td>The F1 key.</td></tr>\n<tr><th>F2</th><td>The F2 key.</td></tr>\n<tr><th>F3</th><td>The F3 key.</td></tr>\n<tr><th>F4</th><td>The F4 key.</td></tr>\n<tr><th>F5</th><td>The F5 key.</td></tr>\n<tr><th>F6</th><td>The F6 key.</td></tr>\n<tr><th>F7</th><td>The F7 key.</td></tr>\n<tr><th>F8</th><td>The F8 key.</td></tr>\n<tr><th>F9</th><td>The F9 key.</td></tr>\n<tr><th>F10</th><td>The F10 key.</td></tr>\n<tr><th>F11</th><td>The F11 key.</td></tr>\n<tr><th>F12</th><td>The F12 key.</td></tr>\n<tr><th>NumLock</th><td>The Num Lock key.</td></tr>\n<tr><th>PrintScreen</th><td>The Print Screen (PrintScrn, SnapShot) key.</td></tr>\n<tr><th>Scroll</th><td>The scroll lock key</td></tr>\n<tr><th>Pause</th><td>The pause/break key</td></tr>\n<tr><th>Win</th><td>The Windows Logo key</td></tr>\n<tr><th>Apps</th><td>The Application key (Windows Context Menu)</td></tr>\n</table>","!type":"fn() -> string"},"init":{"!doc":"<p>Initialize the fields of the event.</p>","!type":"fn(domEvent: +Event, target: Object, identifier: string) -> +qx.event.type.KeySequence"},"isPrintable":{"!doc":"<p>Checks whether the pressed key is printable.</p>","!type":"fn() -> bool"}}},"Mouse":{"!proto":"qx.event.type.Dom","!doc":"<p>Mouse event object.</p>\n\n<p>the interface of this class is based on the <span class=\"caps\">DOM</span> Level 2 mouse event\ninterface: <a href=\"http://www.w3.org/TR/DOM-Level-2-Events/events.html#Events-eventgroupings-mouseevents\">http://www.w3.org/TR/DOM-Level-2-Events/events.html#Events-eventgroupings-mouseevents</a></p>","prototype":{"_cloneNativeEvent":{"!type":"fn(nativeEvent: +undefined, clone: +undefined)"},"getButton":{"!doc":"<p>During mouse events caused by the depression or release of a mouse button,\nthis method can be used to check which mouse button changed state.</p>\n\n<p>Only internet explorer can compute the button during mouse move events. For\nall other browsers the button only contains sensible data during\n&#8220;click&#8221; events like &#8220;click&#8221;, &#8220;dblclick&#8221;, &#8220;mousedown&#8221;, &#8220;mouseup&#8221; or &#8220;contextmenu&#8221;.</p>\n\n<p>But still, browsers act different on click:</p>\n\n<pre>\n<- = left mouse button\n-> = right mouse button\n^  = middle mouse button\n\nBrowser | click, dblclick | contextmenu\n---------------------------------------\nFirefox | <- ^ ->         | ->\nChrome  | <- ^            | ->\nSafari  | <- ^            | ->\nIE      | <- (^ is <-)    | ->\nOpera   | <-              | -> (twice)\n</pre>","!type":"fn() -> string"},"getDocumentLeft":{"!doc":"<p>Get the horizontal position at which the event occurred relative to the\nleft of the document. This property takes into account any scrolling of\nthe page.</p>","!type":"fn() -> +Integer"},"getDocumentTop":{"!doc":"<p>Get the vertical position at which the event occurred relative to the\ntop of the document. This property takes into account any scrolling of\nthe page.</p>","!type":"fn() -> +Integer"},"getRelatedTarget":{"!doc":"<p>Get a secondary event target related to an UI event. This attribute is\nused with the mouseover event to indicate the event target which the\npointing device exited and with the mouseout event to indicate the\nevent target which the pointing device entered.</p>","!type":"fn() -> +Element"},"getScreenLeft":{"!doc":"<p>Get the horizontal coordinate at which the event occurred relative to\nthe origin of the screen coordinate system.</p>\n\n<p>Note: This value is usually not very useful unless you want to\nposition a native popup window at this coordinate.</p>","!type":"fn() -> +Integer"},"getScreenTop":{"!doc":"<p>Get the vertical coordinate at which the event occurred relative to\nthe origin of the screen coordinate system.</p>\n\n<p>Note: This value is usually not very useful unless you want to\nposition a native popup window at this coordinate.</p>","!type":"fn() -> +Integer"},"getViewportLeft":{"!doc":"<p>Get the he horizontal coordinate at which the event occurred relative\nto the viewport.</p>","!type":"fn() -> +Integer"},"getViewportTop":{"!doc":"<p>Get the vertical coordinate at which the event occurred relative\nto the viewport.</p>","!type":"fn() -> +Integer"},"isLeftPressed":{"!doc":"<p>Whether the left button is pressed</p>","!type":"fn() -> bool"},"isMiddlePressed":{"!doc":"<p>Whether the middle button is pressed</p>","!type":"fn() -> bool"},"isRightPressed":{"!doc":"<p>Whether the right button is pressed</p>","!type":"fn() -> bool"},"stop":{"!type":"fn()"}}},"MouseWheel":{"!proto":"qx.event.type.Mouse","!doc":"<p>Mouse wheel event object.</p>","prototype":{"getWheelDelta":{"!doc":"<p>Get the amount the wheel has been scrolled</p>","!type":"fn(axis?: string) -> +Integer"},"stop":{"!type":"fn()"}}},"Native":{"!proto":"qx.event.type.Event","!doc":"<p>Common base class for all native events (DOM events, IO events, ...).</p>","prototype":{"_cloneNativeEvent":{"!doc":"<p>Clone the native browser event</p>","!type":"fn(nativeEvent: +Event, clone: Object) -> Object"},"clone":{"!type":"fn(embryo: +undefined)"},"getNativeEvent":{"!doc":"<p>Get the native browser event object of this event.</p>","!type":"fn() -> +Event"},"getReturnValue":{"!doc":"<p>Retrieves the event&#8217;s return value.</p>","!type":"fn() -> string"},"init":{"!doc":"<p>Initialize the fields of the event. The event must be initialized before\nit can be dispatched.</p>","!type":"fn(nativeEvent: +Event, target?: Object, relatedTarget?: Object, canBubble?: bool, cancelable?: bool) -> +qx.event.type.Event"},"preventDefault":{"!doc":"<p>Prevent browser default behavior, e.g. opening the context menu, ...</p>","!type":"fn()"},"setReturnValue":{"!doc":"<p>Sets the event&#8217;s return value. If the return value is set in a\nbeforeunload event, the user will be asked by the browser, whether\nhe really wants to leave the page. The return string will be displayed in\nthe message box.</p>","!type":"fn(returnValue?: string)"}}},"Orientation":{"!proto":"qx.event.type.Event","!doc":"<p>Orientation event object.</p>","prototype":{"clone":{"!doc":"<p>Get a copy of this object</p>","!type":"fn(embryo?: +qx.event.type.Orientation) -> +qx.event.type.Orientation"},"getOrientation":{"!doc":"<p>Returns the current orientation of the viewport in degree.</p>\n\n<p>All possible values and their meaning:</p>\n\n<ul>\n<li><code>0</code>: &#8220;Portrait&#8221;</li>\n<li><code>-90</code>: &#8220;Landscape (right, screen turned clockwise)&#8221;</li>\n<li><code>90</code>: &#8220;Landscape (left, screen turned counterclockwise)&#8221;</li>\n<li><code>180</code>: &#8220;Portrait (upside-down portrait)&#8221;</li>\n</ul>","!type":"fn() -> +Integer"},"init":{"!doc":"<p>Initialize the fields of the event. The event must be initialized before\nit can be dispatched.</p>","!type":"fn(orientation: string, mode: string) -> +qx.event.type.Orientation"},"isLandscape":{"!doc":"<p>Whether the viewport orientation is currently in landscape mode.</p>","!type":"fn() -> bool"},"isPortrait":{"!doc":"<p>Whether the viewport orientation is currently in portrait mode.</p>","!type":"fn() -> bool"}}},"Pinch":{"!proto":"qx.event.type.Pointer","!doc":"<p>Pinch is a multi pointer gesture fired when two finger moved towards\nor away from each other. It contains the scaling factor of the pinch.</p>","prototype":{"_cloneNativeEvent":{"!type":"fn(nativeEvent: +undefined, clone: +undefined)"},"getScale":{"!doc":"<p>Returns the calculated scale of this event.</p>","!type":"fn() -> +Float"}}},"Pointer":{"!proto":"qx.event.type.Mouse","!doc":"<p>Pointer event object.</p>\n\n<p>the interface of this class is based on the pointer event interface:\n<a href=\"http://www.w3.org/TR/pointerevents/\">http://www.w3.org/TR/pointerevents/</a></p>","prototype":{"_cloneNativeEvent":{"!type":"fn(nativeEvent: +undefined, clone: +undefined)"},"getDocumentLeft":{"!type":"fn()"},"getDocumentTop":{"!type":"fn()"},"getHeight":{"!doc":"<p>Returns the contact geometry in it&#8217;s height.</p>","!type":"fn() -> number"},"getOriginalTarget":{"!type":"fn()"},"getPointerId":{"!doc":"<p>Returns a unique identified for the pointer. This id is\nunique for all active pointers.</p>","!type":"fn() -> number"},"getPointerType":{"!doc":"<p>Returns the device type which the event triggered. This can be one\nof the following strings: <code>mouse</code>, <code>wheel</code>,\n<code>pen</code> or <code>touch</code>.</p>","!type":"fn() -> string"},"getPressure":{"!doc":"<p>Returns the pressure of the pointer in a rage from 0 to 1.</p>","!type":"fn() -> number"},"getTiltX":{"!doc":"<p>Returns the plane angle in degrees between the Y-Z plane and the\nplane containing e.g. the stylus and the Y axis.</p>","!type":"fn() -> number"},"getTiltY":{"!doc":"<p>Returns the plane angle in degrees between the X-Z plane and the\nplane containing e.g. the stylus and the X axis.</p>","!type":"fn() -> number"},"getWidth":{"!doc":"<p>Returns the contact geometry in it&#8217;s width.</p>","!type":"fn() -> number"},"isPrimary":{"!doc":"<p>Returns whether the pointer is the primary pointer.</p>","!type":"fn() -> bool"}}},"Rest":{"!proto":"qx.event.type.Data","!doc":"<p>Rest event object.</p>","prototype":{"clone":{"!doc":"<p>Get a copy of this object</p>","!type":"fn(embryo?: +qx.event.type.Data) -> +qx.event.type.Data"},"getAction":{"!doc":"<p>Returns the (computed) value of the property <code>action</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #action}.</p>","!type":"fn() -> Object"},"getId":{"!doc":"<p>Returns the (computed) value of the property <code>id</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #id}.</p>","!type":"fn() -> Object"},"getPhase":{"!doc":"<p>Returns the (computed) value of the property <code>phase</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #phase}.</p>","!type":"fn() -> Object"},"getRequest":{"!doc":"<p>Returns the (computed) value of the property <code>request</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #request}.</p>","!type":"fn() -> Object"},"init":{"!doc":"<p>Initializes an event object.</p>","!type":"fn(data: Object, old?: Object, cancelable?: bool, request: +qx.io.request.AbstractRequest, action: string, phase: string) -> +qx.event.type.Data"},"initAction":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>action</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #action}.</p>","!type":"fn(value: Object) -> Object"},"initId":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>id</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #id}.</p>","!type":"fn(value: Object) -> Object"},"initPhase":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>phase</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #phase}.</p>","!type":"fn(value: Object) -> Object"},"initRequest":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>request</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #request}.</p>","!type":"fn(value: Object) -> Object"},"resetAction":{"!doc":"<p>Resets the user value of the property <code>action</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #action}.</p>","!type":"fn()"},"resetId":{"!doc":"<p>Resets the user value of the property <code>id</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #id}.</p>","!type":"fn()"},"resetPhase":{"!doc":"<p>Resets the user value of the property <code>phase</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #phase}.</p>","!type":"fn()"},"resetRequest":{"!doc":"<p>Resets the user value of the property <code>request</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #request}.</p>","!type":"fn()"},"setAction":{"!doc":"<p>Sets the user value of the property <code>action</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #action}.</p>","!type":"fn(value: Object) -> Object"},"setId":{"!doc":"<p>Sets the user value of the property <code>id</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #id}.</p>","!type":"fn(value: Object) -> Object"},"setPhase":{"!doc":"<p>Sets the user value of the property <code>phase</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #phase}.</p>","!type":"fn(value: Object) -> Object"},"setRequest":{"!doc":"<p>Sets the user value of the property <code>request</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #request}.</p>","!type":"fn(value: Object) -> Object"}}},"Roll":{"!proto":"qx.event.type.Pointer","!doc":"<p>Roll event object.</p>","prototype":{"_cloneNativeEvent":{"!type":"fn(nativeEvent: +undefined, clone: +undefined)"},"getDelta":{"!doc":"<p>Returns a map with the calculated delta coordinates and axis,\nrelative to the last <code>roll</code> event.</p>","!type":"fn() -> +Map"},"getMomentum":{"!doc":"<p>Boolean flag to indicate if this event was triggered by a momentum.</p>","!type":"fn() -> bool"},"stop":{"!type":"fn()"},"stopMomentum":{"!doc":"<p>Stops the momentum events.</p>","!type":"fn()"}}},"Rotate":{"!proto":"qx.event.type.Pointer","!doc":"<p>Rotate is a multi pointer gesture fired when two finger moved around\na single point. It contains the angle of the rotation.</p>","prototype":{"_cloneNativeEvent":{"!type":"fn(nativeEvent: +undefined, clone: +undefined)"},"getAngle":{"!doc":"<p>Returns a number with the current calculated angle between the primary and secondary active pointers.</p>","!type":"fn() -> number"}}},"Swipe":{"!proto":"qx.event.type.Pointer","!doc":"<p>Swipe is a single pointer gesture fired when a pointer is moved in one direction.\nIt contains some additional data like the primary axis, the velocity and the distance.</p>","prototype":{"_cloneNativeEvent":{"!type":"fn(nativeEvent: +undefined, clone: +undefined)"},"getAxis":{"!doc":"<p>Returns whether the performed swipe was on the x or y axis.</p>","!type":"fn() -> string"},"getDirection":{"!doc":"<p>Returns the direction of the performed swipe in reference to the axis.\ny = up / down\nx = left / right</p>","!type":"fn() -> string"},"getDistance":{"!doc":"<p>Returns the distance of the performed swipe.</p>","!type":"fn() -> +Integer"},"getDuration":{"!doc":"<p>Returns the duration the performed swipe took.</p>","!type":"fn() -> +Integer"},"getStartTime":{"!doc":"<p>Returns the start time of the performed swipe.</p>","!type":"fn() -> +Integer"},"getVelocity":{"!doc":"<p>Returns the velocity of the performed swipe.</p>","!type":"fn() -> number"}}},"Tap":{"!proto":"qx.event.type.Pointer","!doc":"<p>Tap is a single pointer gesture fired when one pointer goes down and up on\nthe same location.</p>"},"Touch":{"!proto":"qx.event.type.Dom","!doc":"<p>Touch event object.</p>\n\n<p>For more information see:\n    <a href=\"https://developer.apple.com/library/safari/#documentation/UserExperience/Reference/TouchEventClassReference/TouchEvent/TouchEvent.html\">https://developer.apple.com/library/safari/#documentation/UserExperience/Reference/TouchEventClassReference/TouchEvent/TouchEvent.html</a></p>","prototype":{"__getEventSpecificTouch":{"!doc":"<p>Returns an event specific touch on the target element. This function is\nused as the &#8220;touchend&#8221; event only offers Touch objects in the\nchangedTouches array.</p>","!type":"fn(touchIndex?: +Integer) -> Object"},"__getEventSpecificTouches":{"!doc":"<p>Returns the event specific touches on the target element. This function\nis used as the &#8220;touchend&#8221; event only offers Touch objects in the\nchangedTouches array.</p>","!type":"fn() -> Object"},"_cloneNativeEvent":{"!type":"fn(nativeEvent: +undefined, clone: +undefined)"},"_isTouchEnd":{"!doc":"<p>Indicates if the event occurs during the &#8220;touchend&#8221; phase. Needed to\ndetermine the event specific touches. Override this method if you derive\nfrom this class and want to indicate that the specific event occurred\nduring the &#8220;touchend&#8221; phase.</p>","!type":"fn() -> bool"},"getAllTouches":{"!doc":"<p>Returns an array of native Touch objects representing all current\ntouches on the document.\nReturns an empty array for the &#8220;touchend&#8221; event.</p>","!type":"fn() -> Object"},"getChangedTargetTouches":{"!doc":"<p>Returns an array of native Touch objects representing all touches of\nthe target element that changed in this event.</p>\n\n<p>On the &#8220;touchstart&#8221; event the array contains all touches that were\nadded to the target element.\nOn the &#8220;touchmove&#8221; event the array contains all touches that were\nmoved on the target element.\nOn the &#8220;touchend&#8221; event the array contains all touches that used\nto be on the target element.</p>","!type":"fn() -> Object"},"getDelta":{"!doc":"<p>Returns an array with the calculated delta coordinates of all active touches,\nrelative to the position on <code>touchstart</code> event.</p>","!type":"fn() -> +Array"},"getDocumentLeft":{"!doc":"<p>Get the horizontal position at which the event occurred relative to the\nleft of the document. This property takes into account any scrolling of\nthe page.</p>","!type":"fn(touchIndex?: +Integer) -> +Integer"},"getDocumentTop":{"!doc":"<p>Get the vertical position at which the event occurred relative to the\ntop of the document. This property takes into account any scrolling of\nthe page.</p>","!type":"fn(touchIndex?: +Integer) -> +Integer"},"getIdentifier":{"!doc":"<p>Returns the unique identifier for a certain touch object.</p>","!type":"fn(touchIndex?: +Integer) -> +Integer"},"getRotation":{"!doc":"<p>Returns the delta of the rotation since the start of the event, in degrees.\nInitial value is 0.0\nClockwise > 0\nCounter-clockwise < 0.</p>","!type":"fn() -> +Float"},"getScale":{"!doc":"<p>Returns the distance between two fingers since the start of the event.\nThe distance is a multiplier of the initial distance.\nInitial value: 1.0.\nGestures:\n< 1.0, pinch close / zoom out.\n> 1.0, pinch open / to zoom in.</p>","!type":"fn() -> +Float"},"getScreenLeft":{"!doc":"<p>Get the horizontal coordinate at which the event occurred relative to\nthe origin of the screen coordinate system.</p>","!type":"fn(touchIndex?: +Integer) -> +Integer"},"getScreenTop":{"!doc":"<p>Get the vertical coordinate at which the event occurred relative to\nthe origin of the screen coordinate system.</p>","!type":"fn(touchIndex?: +Integer) -> +Integer"},"getTargetTouches":{"!doc":"<p>Returns an array of native Touch objects representing all touches\nassociated with the event target element.\nReturns an empty array for the &#8220;touchend&#8221; event.</p>","!type":"fn() -> Object"},"getViewportLeft":{"!doc":"<p>Get the the horizontal coordinate at which the event occurred relative\nto the viewport.</p>","!type":"fn(touchIndex?: +Integer) -> +Integer"},"getViewportTop":{"!doc":"<p>Get the vertical coordinate at which the event occurred relative\nto the viewport.</p>","!type":"fn(touchIndex?: +Integer) -> +Integer"},"isMultiTouch":{"!doc":"<p>Checks whether more than one touch is associated with the event target\nelement.</p>","!type":"fn() -> bool"},"stop":{"!type":"fn()"}}},"Track":{"!proto":"qx.event.type.Pointer","!doc":"<p>Track is a single pointer gesture and contains of a three vent types:\n<code>trackstart</code>, <code>track</code> and <code>trackend</code>. These\nevents will be fired when a pointer grabs an item and moves the pointer on it.</p>","prototype":{"_cloneNativeEvent":{"!type":"fn(nativeEvent: +undefined, clone: +undefined)"},"getDelta":{"!doc":"<p>Returns a map with the calculated delta coordinates and axis,\nrelative to the position on <code>trackstart</code> event.</p>","!type":"fn() -> +Map"}}}},"util":{"Keyboard":{"!doc":"<p>Utilities for working with character codes and key identifiers</p>","charCodeToIdentifier":{"!doc":"<p>converts a character code to the corresponding identifier</p>","!type":"fn(charCode: string) -> string"},"isIdentifiableKeyCode":{"!doc":"<p>Check whether the keycode can be reliably detected in keyup/keydown events</p>","!type":"fn(keyCode: string) -> bool"},"isNonPrintableKeyCode":{"!doc":"<p>Checks whether the keyCode represents a non printable key</p>","!type":"fn(keyCode: string) -> bool"},"isPrintableKeyIdentifier":{"!doc":"<p>Checks whether a given string is a printable keyIdentifier.</p>","!type":"fn(keyIdentifier: string) -> bool"},"isValidKeyIdentifier":{"!doc":"<p>Checks whether a given string is a valid keyIdentifier</p>","!type":"fn(keyIdentifier: string) -> bool"},"keyCodeToIdentifier":{"!doc":"<p>converts a keyboard code to the corresponding identifier</p>","!type":"fn(keyCode: +Integer) -> string"}}}},"html":{"Blocker":{"!proto":"qx.html.Element","!doc":"<p>The blocker element is used to block interaction with the application.</p>\n\n<p>It is usually transparent or semi-transparent and blocks all events from\nthe underlying elements.</p>","!type":"fn()","prototype":{"__refreshCursor":{"!doc":"<p>Refreshes the cursor by setting it to <code>null</code> and then to the\nold value.</p>","!type":"fn()"},"_stopPropagation":{"!doc":"<p>Stop the event propagation from the passed event.</p>","!type":"fn(e: +qx.event.type.Mouse)"}}},"Canvas":{"!proto":"qx.html.Element","!doc":"<p>Managed wrapper for the <span class=\"caps\">HTML</span> canvas tag.</p>","!type":"fn()","prototype":{"_createDomElement":{"!type":"fn()"},"getCanvas":{"!doc":"<p>Get the canvas element [<a href=\"http://www.whatwg.org/specs/web-apps/current-work/multipage/the-canvas-element.html#canvas\">W3C-HMTL5</a>]</p>","!type":"fn() -> +Element"},"getContext2d":{"!doc":"<p>Get the canvas&#8217; 2D rendering context\n[<a href=\"http://www.whatwg.org/specs/web-apps/current-work/multipage/the-canvas-element.html#canvasrenderingcontext2d\">W3C-HTML5</a>].\nAll drawing operations are performed on this context.</p>","!type":"fn() -> +CanvasRenderingContext2D"},"getHeight":{"!doc":"<p>Get the height attribute of the canvas element</p>","!type":"fn() -> +Integer"},"getWidth":{"!doc":"<p>Get the width attribute of the canvas element</p>","!type":"fn() -> +Integer"},"setHeight":{"!doc":"<p>Set the height attribute of the canvas element. This property controls the\nsize of the canvas coordinate space.</p>","!type":"fn(height: +Integer)"},"setWidth":{"!doc":"<p>Set the width attribute of the canvas element. This property controls the\nsize of the canvas coordinate space.</p>","!type":"fn(width: +Integer)"}}},"Element":{"!proto":"qx.core.Object","!doc":"<p>High-performance, high-level <span class=\"caps\">DOM</span> element creation and management.</p>\n\n<p>Includes support for <span class=\"caps\">HTML</span> and style attributes. Elements also have\ngot a powerful children and visibility management.</p>\n\n<p>Processes <span class=\"caps\">DOM</span> insertion and modification with advanced logic\nto reduce the real transactions.</p>\n\n<p>From the view of the parent you can use the following children management\nmethods:\n{@link #getChildren}, {@link #indexOf}, {@link #hasChild}, {@link #add},\n{@link #addAt}, {@link #remove}, {@link #removeAt}, {@link #removeAll}</p>\n\n<p>Each child itself also has got some powerful methods to control its\nposition:\n{@link #getParent}, {@link #free},\n{@link #insertInto}, {@link #insertBefore}, {@link #insertAfter},\n{@link #moveTo}, {@link #moveBefore}, {@link #moveAfter},</p>","!type":"fn()","__getCaptureElement":{"!doc":"<p>Get the mouse capture element</p>","!type":"fn() -> +Element"},"__getFocusHandler":{"!doc":"<p>Get the focus handler</p>","!type":"fn() -> +qx.event.handler.Focus"},"__willBecomeInvisible":{"!doc":"<p>Whether the given <span class=\"caps\">DOM</span> element will become invisible after the flush</p>","!type":"fn(domElement: +Element) -> bool"},"_scheduleFlush":{"!doc":"<p>Schedule a deferred element queue flush. If the widget subsystem is used\nthis method gets overwritten by {@link qx.ui.core.queue.Manager}.</p>","!type":"fn(job: string)"},"flush":{"!doc":"<p>Flush the global modified list</p>","!type":"fn()"},"prototype":{"__addChildHelper":{"!doc":"<p>Internal helper for all children addition needs</p>","!type":"fn(child: Object)"},"__flush":{"!doc":"<p>Syncs data of an HtmlElement object to the <span class=\"caps\">DOM</span>.</p>","!type":"fn()"},"__moveChildHelper":{"!doc":"<p>Internal helper for all children move needs</p>","!type":"fn(child: +qx.html.Element)"},"__onScroll":{"!doc":"<p>Handler for the scroll-event</p>","!type":"fn(e: +qx.event.type.Native)"},"__performAction":{"!doc":"<p>Takes the action to process as argument and queues this action if the\nunderlying <span class=\"caps\">DOM</span> element is not yet created.</p>","!type":"fn(action: string, args: +Array)"},"__removeChildHelper":{"!doc":"<p>Internal helper for all children removal needs</p>","!type":"fn(child: +qx.html.Element)"},"__willBeSeeable":{"!doc":"<p>Walk up the internal children hierarchy and\nlook if one of the children is marked as root.</p>\n\n<p>This method is quite performance hungry as it\nreally walks up recursively.</p>","!type":"fn() -> bool"},"_applyProperty":{"!doc":"<p>Applies a special property with the given value.</p>\n\n<p>This property apply routine can be easily overwritten and\nextended by sub classes to add new low level features which\nare not easily possible using styles and attributes.</p>","!type":"fn(name: string, value: Object) -> +qx.html.Element"},"_copyData":{"!doc":"<p>Copies data between the internal representation and the <span class=\"caps\">DOM</span>. This\nsimply copies all the data and only works well directly after\nelement creation. After this the data must be synced using {@link #_syncData}</p>","!type":"fn(fromMarkup: bool)"},"_createDomElement":{"!doc":"<p>Internal helper to generate the <span class=\"caps\">DOM</span> element</p>","!type":"fn() -> +Element"},"_getProperty":{"!doc":"<p>Get the value of the given misc.</p>","!type":"fn(key: string) -> Object"},"_insertChildren":{"!doc":"<p>Append all child nodes to the <span class=\"caps\">DOM</span>\nelement. This function is used when the element is initially\ncreated. After this initial apply {@link #_syncChildren} is used\ninstead.</p>","!type":"fn()"},"_removeProperty":{"!doc":"<p>Removes the given misc</p>","!type":"fn(key: string, direct?: bool) -> +qx.html.Element"},"_scheduleChildrenUpdate":{"!doc":"<p>Add the element to the global modification list.</p>","!type":"fn()"},"_setProperty":{"!doc":"<p>Set up the given property.</p>","!type":"fn(key: string, value: Object, direct?: bool) -> +qx.html.Element"},"_syncChildren":{"!doc":"<p>Syncronize internal children hierarchy to the <span class=\"caps\">DOM</span>. This is used\nfor further runtime updates after the element has been created\ninitially.</p>","!type":"fn()"},"_syncData":{"!doc":"<p>Syncronizes data between the internal representation and the <span class=\"caps\">DOM</span>. This\nis the counterpart of {@link #_copyData} and is used for further updates\nafter the element has been created.</p>","!type":"fn()"},"activate":{"!doc":"<p>Mark this element to get activated on the next flush of the queue</p>","!type":"fn()"},"add":{"!doc":"<p>Append all given children at the end of this element.</p>","!type":"fn(varargs: +qx.html.Element) -> +qx.html.Element"},"addAt":{"!doc":"<p>Inserts a new element into this element at the given position.</p>","!type":"fn(child: +qx.html.Element, index: +Integer) -> +qx.html.Element"},"addClass":{"!doc":"<p>Adds a css class to the element.</p>","!type":"fn(name: string)"},"addListener":{"!doc":"<p>Adds an event listener to the element.</p>","!type":"fn(type: string, listener: fn(), self?: Object, capture?: bool) -> Object"},"blur":{"!doc":"<p>Mark this element to get blurred on the next flush of the queue</p>","!type":"fn()"},"capture":{"!doc":"<p>Captures all mouse events to this element</p>","!type":"fn(containerCapture?: bool)"},"clearTextSelection":{"!doc":"<p>Clears the selection of the element.</p>\n\n<p>This method only works if the underlying <span class=\"caps\">DOM</span> element is already created.</p>","!type":"fn()"},"deactivate":{"!doc":"<p>Mark this element to get deactivated on the next flush of the queue</p>","!type":"fn()"},"disableScrolling":{"!doc":"<p>Disables browser-native scrolling</p>","!type":"fn()"},"enableScrolling":{"!doc":"<p>Re-enables browser-native scrolling</p>","!type":"fn()"},"exclude":{"!doc":"<p>Marks the element as excluded which means it will be removed\nfrom the <span class=\"caps\">DOM</span> and ignored for updates until it gets included again.</p>","!type":"fn() -> +qx.html.Element"},"fadeIn":{"!doc":"<p>Fades in the element.</p>","!type":"fn(duration: number) -> +qx.bom.element.AnimationHandle"},"fadeOut":{"!doc":"<p>Fades out the element.</p>","!type":"fn(duration: number) -> +qx.bom.element.AnimationHandle"},"focus":{"!doc":"<p>Focus this element.</p>\n\n<p>If the underlaying <span class=\"caps\">DOM</span> element is not yet created, the\nfocus is queued for processing after the element creation.</p>","!type":"fn()"},"free":{"!doc":"<p>Remove self from the current parent.</p>","!type":"fn() -> +qx.html.Element"},"getAllStyles":{"!doc":"<p>Returns a map of all styles. Do not modify the result map!</p>","!type":"fn() -> +Map"},"getAttribute":{"!doc":"<p>Get the value of the given attribute.</p>","!type":"fn(key: string) -> Object"},"getChild":{"!doc":"<p>Get a child element at the given index</p>","!type":"fn(index: +Integer) -> +qx.html.Element"},"getChildren":{"!doc":"<p>Returns a copy of the internal children structure.</p>\n\n<p>Please do not modify the array in place. If you need\nto work with the data in such a way make yourself\na copy of the data first.</p>","!type":"fn() -> +Array"},"getDomElement":{"!doc":"<p>Returns the <span class=\"caps\">DOM</span> element (if created). Please use this with caution.\nIt is better to make all changes to the object itself using the public\n<span class=\"caps\">API</span> rather than to the underlying <span class=\"caps\">DOM</span> element.</p>","!type":"fn() -> +Element"},"getListeners":{"!doc":"<p>Serializes and returns all event listeners attached to this element</p>","!type":"fn() -> +Map"},"getNodeName":{"!doc":"<p>Returns the nodeName of the <span class=\"caps\">DOM</span> element.</p>","!type":"fn() -> string"},"getParent":{"!doc":"<p>Returns the parent of this element.</p>","!type":"fn() -> +qx.html.Element"},"getScrollX":{"!doc":"<p>Get the horizontal scroll position.</p>","!type":"fn() -> +Integer"},"getScrollY":{"!doc":"<p>Get the vertical scroll position.</p>","!type":"fn() -> +Integer"},"getStyle":{"!doc":"<p>Get the value of the given style attribute.</p>","!type":"fn(key: string) -> Object"},"getTextSelection":{"!doc":"<p>Get the selection of the element.</p>\n\n<p>If the underlaying <span class=\"caps\">DOM</span> element is not yet created, this methods returns\na null value.</p>","!type":"fn() -> string"},"getTextSelectionEnd":{"!doc":"<p>Get the end of the selection of the element.</p>\n\n<p>If the underlaying <span class=\"caps\">DOM</span> element is not yet created, this methods returns\na null value.</p>","!type":"fn() -> +Integer"},"getTextSelectionLength":{"!doc":"<p>Get the length of selection of the element.</p>\n\n<p>If the underlaying <span class=\"caps\">DOM</span> element is not yet created, this methods returns\na null value.</p>","!type":"fn() -> +Integer"},"getTextSelectionStart":{"!doc":"<p>Get the start of the selection of the element.</p>\n\n<p>If the underlaying <span class=\"caps\">DOM</span> element is not yet created, this methods returns\na null value.</p>","!type":"fn() -> +Integer"},"hasChild":{"!doc":"<p>Whether the given element is a child of this element.</p>","!type":"fn(child: +qx.html.Element) -> bool"},"hasChildren":{"!doc":"<p>Returns whether the element has any child nodes</p>","!type":"fn() -> bool"},"hasListener":{"!doc":"<p>Check if there are one or more listeners for an event type.</p>","!type":"fn(type: string, capture?: bool) -> bool"},"hide":{"!doc":"<p>Marks the element as hidden which means it will kept in <span class=\"caps\">DOM</span> (if it\nis already there, but configured hidden using a <span class=\"caps\">CSS</span> style of display=none).</p>","!type":"fn() -> +qx.html.Element"},"include":{"!doc":"<p>Marks the element as included which means it will be moved into\nthe <span class=\"caps\">DOM</span> again and synced with the internal data representation.</p>","!type":"fn() -> +qx.html.Element"},"indexOf":{"!doc":"<p>Find the position of the given child</p>","!type":"fn(child: +qx.html.Element) -> +Integer"},"insertAfter":{"!doc":"<p>Insert self after the given (related) element</p>","!type":"fn(rel: +qx.html.Element) -> +qx.html.Element"},"insertBefore":{"!doc":"<p>Insert self before the given (related) element</p>","!type":"fn(rel: +qx.html.Element) -> +qx.html.Element"},"insertInto":{"!doc":"<p>Insert self into the given parent. Normally appends self to the end,\nbut optionally a position can be defined. With index <code>0</code> it\nwill be inserted at the begin.</p>","!type":"fn(parent: +qx.html.Element, index?: +Integer) -> +qx.html.Element"},"isFocusable":{"!doc":"<p>Whether the element is focusable (or will be when created)</p>","!type":"fn() -> bool"},"isIncluded":{"!doc":"<p>Whether the element is part of the <span class=\"caps\">DOM</span></p>","!type":"fn() -> bool"},"isNativelyFocusable":{"!doc":"<p>Whether the element is natively focusable (or will be when created)</p>\n\n<p>This ignores the configured tabIndex.</p>","!type":"fn() -> bool"},"isVisible":{"!doc":"<p>Whether the element is visible.</p>\n\n<p>Please note: This does not control the visibility or parent inclusion recursively.</p>","!type":"fn() -> bool"},"moveAfter":{"!doc":"<p>Move self after the given (related) child.</p>","!type":"fn(rel: +qx.html.Element) -> +qx.html.Element"},"moveBefore":{"!doc":"<p>Move self before the given (related) child.</p>","!type":"fn(rel: +qx.html.Element) -> +qx.html.Element"},"moveTo":{"!doc":"<p>Move self to the given index in the current parent.</p>","!type":"fn(index: +Integer) -> +qx.html.Element"},"releaseCapture":{"!doc":"<p>Releases this element from a previous {@link #capture} call</p>","!type":"fn()"},"remove":{"!doc":"<p>Removes all given children</p>","!type":"fn(childs: +qx.html.Element) -> +qx.html.Element"},"removeAll":{"!doc":"<p>Remove all children from this element.</p>","!type":"fn() -> +qx.html.Element"},"removeAt":{"!doc":"<p>Removes the child at the given index</p>","!type":"fn(index: +Integer) -> +qx.html.Element"},"removeAttribute":{"!doc":"<p>Removes the given attribute</p>","!type":"fn(key: string, direct?: bool) -> +qx.html.Element"},"removeClass":{"!doc":"<p>Removes a <span class=\"caps\">CSS</span> class from the current element.</p>","!type":"fn(name: string)"},"removeListener":{"!doc":"<p>Removes an event listener from the element.</p>","!type":"fn(type: string, listener: fn(), self: Object, capture?: bool) -> +qx.html.Element"},"removeListenerById":{"!doc":"<p>Removes an event listener from an event target by an id returned by\n{@link #addListener}</p>","!type":"fn(id: Object) -> +qx.html.Element"},"removeStyle":{"!doc":"<p>Removes the given style attribute</p>","!type":"fn(key: string, direct?: bool) -> +qx.html.Element"},"scrollChildIntoViewX":{"!doc":"<p>Scrolls the given child element into view. Only scrolls children.\nDo not influence elements on top of this element.</p>\n\n<p>If the element is currently invisible it gets scrolled automatically\nat the next time it is visible again (queued).</p>","!type":"fn(elem: +qx.html.Element, align?: string, direct?: bool)"},"scrollChildIntoViewY":{"!doc":"<p>Scrolls the given child element into view. Only scrolls children.\nDo not influence elements on top of this element.</p>\n\n<p>If the element is currently invisible it gets scrolled automatically\nat the next time it is visible again (queued).</p>","!type":"fn(elem: +qx.html.Element, align?: string, direct?: bool)"},"scrollToX":{"!doc":"<p>Scrolls the element to the given left position.</p>","!type":"fn(x: +Integer, lazy?: bool)"},"scrollToY":{"!doc":"<p>Scrolls the element to the given top position.</p>","!type":"fn(y: +Integer, lazy?: bool)"},"setAttribute":{"!doc":"<p>Set up the given attribute</p>","!type":"fn(key: string, value: Object, direct?: bool) -> +qx.html.Element"},"setAttributes":{"!doc":"<p>Convenience method to modify a set of attributes at once.</p>","!type":"fn(map: +Map, direct?: bool) -> +qx.html.Element"},"setNodeName":{"!doc":"<p>Sets the nodeName of the <span class=\"caps\">DOM</span> element.</p>","!type":"fn(name: string)"},"setRoot":{"!doc":"<p>Sets the element&#8217;s root flag, which indicates\nwhether the element should be a root element or not.</p>","!type":"fn(root: bool)"},"setSelectable":{"!doc":"<p>Set whether the element is selectable. It uses the qooxdoo attribute\nqxSelectable with the values &#8216;on&#8217; or &#8216;off&#8217;.\nIn webkit, a special css property will be used (-webkit-user-select).</p>","!type":"fn(value: bool)"},"setStyle":{"!doc":"<p>Set up the given style attribute</p>","!type":"fn(key: string, value: Object, direct?: bool) -> +qx.html.Element"},"setStyles":{"!doc":"<p>Convenience method to modify a set of styles at once.</p>","!type":"fn(map: +Map, direct?: bool) -> +qx.html.Element"},"setTextSelection":{"!doc":"<p>Set the selection of the element with the given start and end value.\nIf no end value is passed the selection will extend to the end.</p>\n\n<p>This method only works if the underlying <span class=\"caps\">DOM</span> element is already created.</p>","!type":"fn(start: +Integer, end: +Integer)"},"show":{"!doc":"<p>Marks the element as visible which means that a previously applied\n<span class=\"caps\">CSS</span> style of display=none gets removed and the element will inserted\ninto the <span class=\"caps\">DOM</span>, when this had not already happened before.</p>","!type":"fn() -> +qx.html.Element"},"useElement":{"!doc":"<p>Uses an existing element instead of creating one. This may be interesting\nwhen the <span class=\"caps\">DOM</span> element is directly needed to add content etc.</p>","!type":"fn(elem: +Element)"},"useMarkup":{"!doc":"<p>Uses existing markup for this element. This is mainly used\nto insert pre-built markup blocks into the element hierarchy.</p>","!type":"fn(html: string) -> +Element"}}},"Flash":{"!proto":"qx.html.Element","!doc":"<p>Managed wrapper for the <span class=\"caps\">HTML</span> Flash tag.</p>","!type":"fn()","prototype":{"_createDomElement":{"!type":"fn()"},"createFlash":{"!doc":"<p>Creates the <span class=\"caps\">DOM</span> Flash movie with all needed attributes and\n<code>FlashVars</code>.</p>","!type":"fn()"},"getAttributes":{"!doc":"<p>Returns the attributes for the Flash <span class=\"caps\">DOM</span> element.</p>","!type":"fn() -> +Map"},"getFlashElement":{"!doc":"<p>Return the created <span class=\"caps\">DOM</span> Flash movie.</p>","!type":"fn() -> +Element"},"getParams":{"!doc":"<p>Returns the params for the Flash <span class=\"caps\">DOM</span> element.</p>","!type":"fn() -> +Map"},"getVariables":{"!doc":"<p>Returns the <code>FlashVars</code> for the Flash movie.</p>","!type":"fn() -> +Map"},"setAttribute":{"!doc":"<p>Set an attribute for the Flash <span class=\"caps\">DOM</span> element.</p>","!type":"fn(key: string, value: string)"},"setId":{"!doc":"<p>Set the <span class=\"caps\">URL</span> from the Flash movie to display.</p>","!type":"fn(value: string)"},"setParam":{"!doc":"<p>Set the param for the Flash <span class=\"caps\">DOM</span> element, also called attribute.</p>","!type":"fn(key: string, value: string)"},"setSource":{"!doc":"<p>Set the <span class=\"caps\">URL</span> from the Flash movie to display.</p>","!type":"fn(value: string)"},"setVariables":{"!doc":"<p>Set the <code>FlashVars</code> to pass variables to the Flash movie.</p>","!type":"fn(value: +Map)"}}},"Iframe":{"!proto":"qx.html.Element","!doc":"<p>A cross browser iframe instance.</p>","!type":"fn()","prototype":{"__onNavigate":{"!doc":"<p>Handle user navigation. Sync actual <span class=\"caps\">URL</span> of iframe with source property.</p>","!type":"fn(e: +qx.event.type.Data)"},"_applyProperty":{"!type":"fn(name: +undefined, value: +undefined)"},"_createDomElement":{"!type":"fn()"},"getBody":{"!doc":"<p>Get the <span class=\"caps\">HTML</span> body element of the iframe.</p>","!type":"fn() -> +Element"},"getDocument":{"!doc":"<p>Get the <span class=\"caps\">DOM</span> document object of an iframe.</p>","!type":"fn() -> +Document"},"getName":{"!doc":"<p>Get the current name.</p>","!type":"fn() -> string"},"getSource":{"!doc":"<p>Get the current source.</p>","!type":"fn() -> string"},"getWindow":{"!doc":"<p>Get the <span class=\"caps\">DOM</span> window object of an iframe.</p>","!type":"fn() -> +Window"},"reload":{"!doc":"<p>Reloads iframe</p>","!type":"fn()"},"setName":{"!doc":"<p>Sets iframe&#8217;s name attribute to given value</p>","!type":"fn(name: string) -> +qx.html.Iframe"},"setSource":{"!doc":"<p>Sets iframe&#8217;s source attribute to given value</p>","!type":"fn(source: string) -> +qx.html.Iframe"}}},"Image":{"!proto":"qx.html.Element","!doc":"<p>This is a simple image class using the low level image features of\nqooxdoo and wraps it for the qx.html layer.</p>","prototype":{"_applyProperty":{"!type":"fn(name: +undefined, value: +undefined)"},"_copyData":{"!type":"fn(fromMarkup: +undefined)"},"_createDomElement":{"!type":"fn()"},"_removeProperty":{"!type":"fn(key: +undefined, direct: +undefined)"},"getScale":{"!doc":"<p>Returns whether the image is scaled or not.</p>","!type":"fn() -> bool"},"getSource":{"!doc":"<p>Returns the image source.</p>","!type":"fn() -> string"},"resetSource":{"!doc":"<p>Resets the current source to null which means that no image\nis shown anymore.</p>","!type":"fn() -> +qx.html.Image"},"setPadding":{"!doc":"<p>Maps padding to background-position if the widget is rendered as a\nbackground image</p>","!type":"fn(paddingLeft: +Integer, paddingTop: +Integer)"},"setScale":{"!doc":"<p>Whether the image should be scaled or not.</p>","!type":"fn(value: bool) -> +qx.html.Label"},"setSource":{"!doc":"<p>Configures the image source</p>","!type":"fn(value: bool) -> +qx.html.Label"}}},"Input":{"!proto":"qx.html.Element","!doc":"<p>A Input wrap any valid <span class=\"caps\">HTML</span> input element and make it accessible\nthrough the normalized qooxdoo element interface.</p>","!type":"fn()","prototype":{"_applyProperty":{"!type":"fn(name: +undefined, value: +undefined)"},"_createDomElement":{"!type":"fn()"},"getValue":{"!doc":"<p>Get the current value.</p>","!type":"fn() -> string"},"getWrap":{"!doc":"<p>Gets the text wrap behavior of a text area element.</p>\n\n<p>This property uses the style property &#8220;wrap&#8221; (IE) respectively &#8220;whiteSpace&#8221;</p>","!type":"fn() -> bool"},"setEnabled":{"!doc":"<p>Set the input element enabled / disabled.\nWebkit needs a special treatment because the set color of the input\nfield changes automatically. Therefore, we use\n<code>-webkit-user-modify: read-only</code> and\n<code>-webkit-user-select: none</code>\nfor disabling the fields in webkit. All other browsers use the disabled\nattribute.</p>","!type":"fn(value: bool)"},"setValue":{"!doc":"<p>Sets the value of the input element.</p>","!type":"fn(value: Object) -> +qx.html.Input"},"setWrap":{"!doc":"<p>Sets the text wrap behavior of a text area element.</p>\n\n<p>This property uses the style property &#8220;wrap&#8221; (IE) respectively &#8220;whiteSpace&#8221;</p>","!type":"fn(wrap: bool, direct?: bool) -> +qx.html.Input"}}},"Label":{"!proto":"qx.html.Element","!doc":"<p>A cross browser label instance with support for rich <span class=\"caps\">HTML</span> and text labels.</p>\n\n<p>Text labels supports ellipsis to reduce the text width.</p>\n\n<p>The mode can be changed through the method {@link #setRich}\nwhich accepts a boolean value. The default mode is &#8220;text&#8221; which is\na good choice because it has a better performance.</p>","prototype":{"_applyProperty":{"!type":"fn(name: +undefined, value: +undefined)"},"_copyData":{"!type":"fn(fromMarkup: +undefined)"},"_createDomElement":{"!type":"fn()"},"getValue":{"!doc":"<p>Get the current content.</p>","!type":"fn() -> string"},"setRich":{"!doc":"<p>Toggles between rich <span class=\"caps\">HTML</span> mode and pure text mode.</p>","!type":"fn(value: bool) -> +qx.html.Label"},"setValue":{"!doc":"<p>Sets the <span class=\"caps\">HTML</span>/text content depending on the content mode.</p>","!type":"fn(value: string) -> +qx.html.Label"}}},"Root":{"!proto":"qx.html.Element","!doc":"<p>This is the root element for a set of {@link qx.html.Element}s.</p>\n\n<p>To make other elements visible these elements must be inserted\ninto an root element at any level.</p>\n\n<p>A root element uses an existing <span class=\"caps\">DOM</span> element where is assumed that\nthis element is always visible. In the easiest case, the root element\nis identical to the document&#8217;s body.</p>","!type":"fn()","prototype":{"useElement":{"!doc":"<p>Sets the element to an already existing node. It will be\nassumed that this <span class=\"caps\">DOM</span> element is already visible e.g.\nlike a normal displayed element in the document&#8217;s body.</p>","!type":"fn(elem: +Element)"}}}},"Interface":{"!doc":"<p>This class is used to define interfaces (similar to Java interfaces).</p>\n\n<p>See the description of the {@link #define} method how an interface is\ndefined.</p>","__checkEvents":{"!doc":"<p>Assert events</p>","!type":"fn(clazz: +Class, iface: +Interface, shouldThrow: bool) -> bool"},"__checkMembers":{"!doc":"<p>Assert members</p>","!type":"fn(object: +qx.core.Object, clazz: +Class, iface: +Interface, wrap?: bool, shouldThrow: bool) -> bool"},"__checkProperties":{"!doc":"<p>Assert properties</p>","!type":"fn(clazz: +Class, iface: +Interface, shouldThrow: bool) -> bool"},"__isPropertyMethod":{"!doc":"<p>Internal helper to detect if the method will be generated by the\nproperty system.</p>","!type":"fn(clazz: +Class, methodName: string) -> bool"},"__validateConfig":{"!doc":"<p>Validates incoming configuration and checks keys and values</p>","!type":"fn(name: string, config: +Map)"},"__wrapInterfaceMember":{"!doc":"<p>Wrap a method with a precondition check.</p>","!type":"fn(iface: string, origFunction: fn(), functionName: string, preCondition: fn()) -> fn()"},"assert":{"!doc":"<p>Checks if an interface is implemented by a class</p>","!type":"fn(clazz: +Class, iface: +Interface, wrap?: bool)"},"assertObject":{"!doc":"<p>Asserts that the given object implements all the methods defined in the\ninterface. This method throws an exception if the object does not\nimplement the interface.</p>","!type":"fn(object: +qx.core.Object, iface: +Interface)"},"classImplements":{"!doc":"<p>Tests whether an interface is implemented by a class, without throwing an\nexception when it doesn&#8217;t.</p>","!type":"fn(clazz: +Class, iface: +Interface) -> bool"},"define":{"!doc":"<p>Define a new interface. Interface definitions look much like class definitions.</p>\n\n<p>The main difference is that the bodies of functions defined in <code>members</code>\nand <code>statics</code> are called before the original function with the\nsame arguments. This can be used to check the passed arguments. If the\nchecks fail, an exception should be thrown. It is convenient to use the\nmethod defined in {@link qx.core.MAssert} to check the arguments.</p>\n\n<p>In the <code>build</code> version the checks are omitted.</p>\n\n<p>For properties only the names are required so the value of the properties\ncan be empty maps.</p>\n\n<p>Example:</p>\n\n<pre class=\"javascript\">\nqx.Interface.define(\"name\",\n{\n  extend: [SuperInterfaces],\n\n  statics:\n  {\n    PI : 3.14\n  },\n\n  properties: {\"color\": {}, \"name\": {} },\n\n  members:\n  {\n    meth1: function() {},\n    meth2: function(a, b) { this.assertArgumentsCount(arguments, 2, 2); },\n    meth3: function(c) { this.assertInterface(c.constructor, qx.some.Interface); }\n  },\n\n  events :\n  {\n    keydown : \"qx.event.type.KeySequence\"\n  }\n});\n</pre>","!type":"fn(name: string, config?: +Map) -> +qx.Interface"},"flatten":{"!doc":"<p>Generates a list of all interfaces including their super interfaces\n(resolved recursively)</p>","!type":"fn(ifaces?: +Interface) -> +Array"},"genericToString":{"!doc":"<p>This method will be attached to all interface to return\na nice identifier for them.</p>","!type":"fn() -> string"},"getByName":{"!doc":"<p>Returns an interface by name</p>","!type":"fn(name: string) -> +Class"},"getTotalNumber":{"!doc":"<p>Determine the number of interfaces which are defined</p>","!type":"fn() -> number"},"isDefined":{"!doc":"<p>Determine if interface exists</p>","!type":"fn(name: string) -> bool"},"objectImplements":{"!doc":"<p>Asserts that the given object implements all the methods defined in the\ninterface.</p>","!type":"fn(object: +qx.core.Object, iface: +Interface) -> bool"}},"io":{"ImageLoader":{"!doc":"<p>The ImageLoader can preload and manage loaded image resources. It easily\nhandles multiple requests and supports callbacks for successful and failed\nrequests.</p>\n\n<p>After loading of an image the dimension of the image is stored as long\nas the application is running. This is quite useful for in-memory layouting.</p>\n\n<p>Use {@link #load} to preload your own images.</p>","__getHeight":{"!doc":"<p>Returns the natural height of the given image element.</p>","!type":"fn(element: +Element) -> +Integer"},"__getWidth":{"!doc":"<p>Returns the natural width of the given image element.</p>","!type":"fn(element: +Element) -> +Integer"},"__onload":{"!doc":"<p>Internal event listener for all load/error events.</p>","!type":"fn(event: +Event, element: +Element, source: string)"},"abort":{"!doc":"<p>Abort the loading for the given url.</p>","!type":"fn(source: string)"},"dispose":{"!doc":"<p>Dispose stored images.</p>","!type":"fn()"},"getFormat":{"!doc":"<p>Returns the format of a previously loaded image</p>","!type":"fn(source: string) -> string"},"getHeight":{"!doc":"<p>Returns the image height</p>","!type":"fn(source: string) -> +Integer"},"getSize":{"!doc":"<p>Returns the size of a previously loaded image</p>","!type":"fn(source: string) -> +Map"},"getWidth":{"!doc":"<p>Returns the image width</p>","!type":"fn(source: string) -> +Integer"},"isFailed":{"!doc":"<p>Whether the given image has previously been requested using the\n{@link #load} method but failed.</p>","!type":"fn(source: string) -> bool"},"isLoaded":{"!doc":"<p>Whether the given image has previously been loaded using the\n{@link #load} method.</p>","!type":"fn(source: string) -> bool"},"isLoading":{"!doc":"<p>Whether the given image is currently loading.</p>","!type":"fn(source: string) -> bool"},"load":{"!doc":"<p>Loads the given image. Supports a callback which is\nexecuted when the image is loaded.</p>\n\n<p>This method works asychronous.</p>","!type":"fn(source: string, callback: fn(), context: Object)"}},"part":{"ClosurePart":{"!proto":"qx.io.part.Part","!doc":"<p>Wrapper for a part as defined in the config file. This class knows about all\npackages the part depends on and provides functionality to load the part.</p>","!type":"fn()","prototype":{"__executePackages":{"!doc":"<p>Executes the packages in their correct order and marks the part as\ncomplete after execution.</p>","!type":"fn()"},"_onPackageLoad":{"!doc":"<p>Handler for every package load. It checks for errors and decreases the\npackages to load. If all packages has been loaded, it invokes the\nexecution.</p>","!type":"fn(pkg: +qx.io.part.Package)"},"load":{"!doc":"<p>Loads the closure part including all its packages. The loading will\nbe done parallel. After all packages are available, the closures are\nexecuted in the correct order.</p>","!type":"fn(callback: fn(), self?: Object)"},"preload":{"!type":"fn(callback: +undefined, self: +undefined)"}}},"Package":{"!doc":"<p>The Package wraps a list of related script URLs, which are required by one\nor more parts.</p>","!type":"fn()","prototype":{"__importPackageData":{"!doc":"<p>Import the data of a package. The function is defined in the loader\nscript.</p>","!type":"fn(packageData: +Map)"},"__loadScriptList":{"!doc":"<p>Loads a list of scripts in the correct order.</p>","!type":"fn(urlList: string, callback: fn(), errBack: fn(), self?: Object)"},"execute":{"!doc":"<p>Executes the stored closure. This is only relevant if a\n{@link qx.io.part.ClosurePart} is used.</p>","!type":"fn()"},"getId":{"!doc":"<p>Get the package ID.</p>","!type":"fn() -> string"},"getReadyState":{"!doc":"<p>Get the ready state of the package. The value is one of\n<ul>\n<li>\n  <b>initialized</b>: The package is initialized. The {@link #load}\n  method has not yet been called\n</li>\n<li><b>loading</b>: The package is still loading.</li>\n<li><b>complete</b>: The package has been loaded successfully</li>\n<li><b>cached</b>: The package is loaded but is not executed\n  (for closure parts)</li>\n</li></p>","!type":"fn() -> string"},"getUrls":{"!doc":"<p>Returns the urlsstored stored in the package.</p>","!type":"fn() -> string"},"load":{"!doc":"<p>Load the part&#8217;s script URLs in the correct order.</p>","!type":"fn(notifyPackageResult: fn(), self?: Object)"},"loadClosure":{"!doc":"<p>Load method if the package loads a closure. This is only relevant if a\n{@link qx.io.part.ClosurePart} is used.</p>","!type":"fn(notifyPackageResult: fn(), self?: Object)"},"saveClosure":{"!doc":"<p>Method for storing the closure for this package. This is only relevant\nif a {@link qx.io.part.ClosurePart} is used.</p>","!type":"fn(closure: fn())"}}},"Part":{"!doc":"<p>Wrapper for a part as defined in the config file. This class knows about all\npackages the part depends on and provides functionality to load the part.</p>","!type":"fn()","prototype":{"_appendPartListener":{"!doc":"<p>Helper for appending a listener for this part.</p>","!type":"fn(callback: fn(), self?: Object, part: +qx.io.part.Part)"},"_checkCompleteLoading":{"!doc":"<p>Helper for checking if the part is loaded completely.</p>","!type":"fn(callback: fn(), self: Object) -> bool"},"_markAsCompleted":{"!doc":"<p>Helper for marking the part as complete.</p>","!type":"fn(readyState: string)"},"_signalStartup":{"!doc":"<p>Method used to start up the application in case not all parts\nnecessary to initialize the application are in the boot part. [BUG #3793]</p>","!type":"fn()"},"getName":{"!doc":"<p>The part name as defined in the config file</p>","!type":"fn() -> string"},"getPackages":{"!doc":"<p>Internal helper for testing purposes.</p>","!type":"fn() -> +qx.io.part.Package"},"getReadyState":{"!doc":"<p>Get the ready state of the part. The value is one of\n<ul>\n<li>\n  <b>initialized</b>: The part is initialized. The {@link #load}\n  method has not yet been called\n</li>\n<li><b>loading</b>: The part is still loading.</li>\n<li><b>complete</b>: The part has been loaded successfully</li>\n</li></p>","!type":"fn() -> string"},"load":{"!doc":"<p>Loads the part asynchronously. The callback is called after the part and\nits dependencies are fully loaded. If the part is already loaded the\ncallback is called immediately.</p>","!type":"fn(callback: fn(), self?: Object)"},"preload":{"!doc":"<p>Method for preloading this part.\nEmpty implementation! Regular parts can not be preloaded.</p>","!type":"fn(callback: fn(), self?: Object)"}}}},"PartLoader":{"!proto":"qx.core.Object","!doc":"<p>The part loader knows about all generated packages and parts.</p>\n\n<p>It contains functionality to load parts and to retrieve part instances.</p>","!type":"fn()","getInstance":{"!doc":"<p>Returns a singleton instance of this class. On the first call the class\nis instantiated by calling the constructor with no arguments. All following\ncalls will return this instance.</p>\n\n<p>This method has been added by setting the &#8220;type&#8221; key in the class definition\n({@link qx.Class#define}) to &#8220;singleton&#8221;.</p>","!type":"fn() -> +qx.io.PartLoader"},"require":{"!doc":"<p>Loads one or more parts asynchronously. The callback is called after all\nparts and their dependencies are fully loaded. If the parts are already\nloaded the callback is called immediately.</p>","!type":"fn(partNames: string, callback: fn(), self?: Object)"},"prototype":{"getPart":{"!doc":"<p>Get the part instance of the part with the given name.</p>","!type":"fn(name: string) -> +qx.io.part.Part"},"getParts":{"!doc":"<p>Returns a map of all known parts.</p>","!type":"fn() -> +Map"},"hasPart":{"!doc":"<p>Checks if a part with the given name is available.</p>","!type":"fn(name: string) -> bool"},"require":{"!doc":"<p>Loads one or more parts asynchronously. The callback is called after all\nparts and their dependencies are fully loaded. If the parts are already\nloaded the callback is called immediately.</p>","!type":"fn(partNames: string, callback: fn(), self?: Object)"}}},"remote":{"Exchange":{"!proto":"qx.core.Object","!doc":"<p>Transport layer to control which transport class (XmlHttp, Iframe or Script)\ncan be used.</p>","!type":"fn()","canHandle":{"!doc":"<p>Checks which supported transport class can handle the request with the\ngiven content type.</p>","!type":"fn(vImpl: Object, vNeeds: +Map, vResponseType: string) -> bool"},"initTypes":{"!doc":"<p>Initializes the available type of transport classes and\nchecks for the supported ones.</p>","!type":"fn()"},"registerType":{"!doc":"<p>Registers a transport type.\nAt the moment one out of XmlHttp, Iframe or Script.</p>","!type":"fn(vClass: Object, vId: string)"},"statusCodeToString":{"!doc":"<p>Status code to string conversion</p>","!type":"fn(vStatusCode: +Integer) -> string"},"wasSuccessful":{"!doc":"<p>Called from the transport class when a request was completed.</p>","!type":"fn(vStatusCode: +Integer, vReadyState: string, vIsLocal: bool) -> bool"},"prototype":{"__disableRequestTimeout":{"!doc":"<p>Disables the timer of the request to prevent that the timer is expiring\neven if the user handler (e.g. &#8220;completed&#8221;) was already called.</p>","!type":"fn()"},"_applyImplementation":{"!doc":"<p>Apply method for the implementation property.</p>","!type":"fn(value: Object, old: Object)"},"_applyState":{"!doc":"<p>Apply method for the state property.</p>","!type":"fn(value: Object, old: Object)"},"_onabort":{"!doc":"<p>Event listener for &#8220;abort&#8221; event.</p>","!type":"fn(e: +qx.event.type.Event)"},"_oncompleted":{"!doc":"<p>Event listener for &#8220;completed&#8221; event.</p>","!type":"fn(e: +qx.event.type.Event)"},"_onfailed":{"!doc":"<p>Event listener for &#8220;failed&#8221; event.</p>","!type":"fn(e: +qx.event.type.Event)"},"_onreceiving":{"!doc":"<p>Event listener for &#8220;receiving&#8221; event.</p>","!type":"fn(e: +qx.event.type.Event)"},"_onsending":{"!doc":"<p>Event listener for &#8220;sending&#8221; event.</p>","!type":"fn(e: +qx.event.type.Event)"},"_ontimeout":{"!doc":"<p>Event listener for &#8220;timeout&#8221; event.</p>","!type":"fn(e: +qx.event.type.Event)"},"abort":{"!doc":"<p>Force the transport into the aborted (&#8220;aborted&#8221;)\n state.</p>","!type":"fn()"},"getImplementation":{"!doc":"<p>Returns the (computed) value of the property <code>implementation</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #implementation}.</p>","!type":"fn() -> Object"},"getRequest":{"!doc":"<p>Returns the (computed) value of the property <code>request</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #request}.</p>","!type":"fn() -> Object"},"getState":{"!doc":"<p>Returns the (computed) value of the property <code>state</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #state}.</p>","!type":"fn() -> Object"},"initImplementation":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>implementation</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #implementation}.</p>","!type":"fn(value: Object) -> Object"},"initRequest":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>request</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #request}.</p>","!type":"fn(value: Object) -> Object"},"initState":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>state</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #state}.</p>","!type":"fn(value: Object) -> Object"},"resetImplementation":{"!doc":"<p>Resets the user value of the property <code>implementation</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #implementation}.</p>","!type":"fn()"},"resetRequest":{"!doc":"<p>Resets the user value of the property <code>request</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #request}.</p>","!type":"fn()"},"resetState":{"!doc":"<p>Resets the user value of the property <code>state</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #state}.</p>","!type":"fn()"},"send":{"!doc":"<p>Sends the request.</p>","!type":"fn() -> Object"},"setImplementation":{"!doc":"<p>Sets the user value of the property <code>implementation</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #implementation}.</p>","!type":"fn(value: Object) -> Object"},"setRequest":{"!doc":"<p>Sets the user value of the property <code>request</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #request}.</p>","!type":"fn(value: Object) -> Object"},"setState":{"!doc":"<p>Sets the user value of the property <code>state</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #state}.</p>","!type":"fn(value: Object) -> Object"},"timeout":{"!doc":"<p>Force the transport into the timeout state.</p>","!type":"fn()"}}},"Request":{"!proto":"qx.core.Object","!doc":"<p>This class is used to send <span class=\"caps\">HTTP</span> requests to the server.</p>\n\n<p>Note: This class will be deprecated in a future release. Instead,\nplease use classes found in {@link qx.io.request}.</p>","!type":"fn()","methodAllowsRequestBody":{"!doc":"<p>Returns true if the given <span class=\"caps\">HTTP</span> method allows a request body being transferred to the server.\nThis is currently <span class=\"caps\">POST</span> and <span class=\"caps\">PUT</span>. Other methods require their data being encoded into\nthe <span class=\"caps\">URL</span></p>","!type":"fn(httpMethod: string) -> bool"},"prototype":{"_applyMethod":{"!doc":"<p>Applies changes of the property value of the property <code>method</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #method}.</p>","!type":"fn(value: Object, old: Object)"},"_applyProhibitCaching":{"!doc":"<p>Applies changes of the property value of the property <code>prohibitCaching</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #prohibitCaching}.</p>","!type":"fn(value: Object, old: Object)"},"_applyResponseType":{"!doc":"<p>Applies changes of the property value of the property <code>responseType</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #responseType}.</p>","!type":"fn(value: Object, old: Object)"},"_applyState":{"!doc":"<p>Applies changes of the property value of the property <code>state</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #state}.</p>","!type":"fn(value: Object, old: Object)"},"_onaborted":{"!doc":"<p>Event handler called when the request enters the aborted state.</p>","!type":"fn(e: +qx.event.type.Event)"},"_oncompleted":{"!doc":"<p>Event handler called when the request enters the completed state.</p>","!type":"fn(e: +qx.event.type.Event)"},"_onfailed":{"!doc":"<p>Event handler called when the request enters the failed state.</p>","!type":"fn(e: +qx.event.type.Event)"},"_onqueued":{"!doc":"<p>Event handler called when the request enters the queued state.</p>","!type":"fn(e: +qx.event.type.Event)"},"_onreceiving":{"!doc":"<p>Event handler called when the request enters the receiving state.</p>","!type":"fn(e: +qx.event.type.Event)"},"_onsending":{"!doc":"<p>Event handler called when the request enters the sending state.</p>","!type":"fn(e: +qx.event.type.Event)"},"_ontimeout":{"!doc":"<p>Event handler called when the request enters the timeout state.</p>","!type":"fn(e: +qx.event.type.Event)"},"abort":{"!doc":"<p>Abort sending this request.</p>\n\n<p>The request is removed from the singleton class qx.io.remote.RequestQueue&#8217;s\nlist of pending events. If the request haven&#8217;t been scheduled this\nmethod is a noop.</p>","!type":"fn()"},"getAsynchronous":{"!doc":"<p>Returns the (computed) value of the property <code>asynchronous</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #asynchronous}.</p>","!type":"fn() -> Object"},"getCrossDomain":{"!doc":"<p>Returns the (computed) value of the property <code>crossDomain</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #crossDomain}.</p>","!type":"fn() -> Object"},"getData":{"!doc":"<p>Returns the (computed) value of the property <code>data</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #data}.</p>","!type":"fn() -> Object"},"getFileUpload":{"!doc":"<p>Returns the (computed) value of the property <code>fileUpload</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #fileUpload}.</p>","!type":"fn() -> Object"},"getFormField":{"!doc":"<p>Get a form field in the <span class=\"caps\">POST</span> request.</p>","!type":"fn(vId: string) -> string"},"getFormFields":{"!doc":"<p>Returns the object containg all form fields for the <span class=\"caps\">POST</span> request.</p>","!type":"fn() -> Object"},"getMethod":{"!doc":"<p>Returns the (computed) value of the property <code>method</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #method}.</p>","!type":"fn() -> Object"},"getParameter":{"!doc":"<p>Get a parameter in the request.</p>","!type":"fn(vId: string, bFromData: bool) -> Object"},"getParameters":{"!doc":"<p>Returns the object containg all parameters for the request.</p>","!type":"fn(bFromData: bool) -> Object"},"getParseJson":{"!doc":"<p>Returns the (computed) value of the property <code>parseJson</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #parseJson}.</p>","!type":"fn() -> Object"},"getPassword":{"!doc":"<p>Returns the (computed) value of the property <code>password</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #password}.</p>","!type":"fn() -> Object"},"getProhibitCaching":{"!doc":"<p>Returns the (computed) value of the property <code>prohibitCaching</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #prohibitCaching}.</p>","!type":"fn() -> Object"},"getRequestHeader":{"!doc":"<p>Retrieve the value of a header which was previously set</p>","!type":"fn(vId: string) -> string"},"getRequestHeaders":{"!doc":"<p>Return the object containing all of the headers which have been added.</p>","!type":"fn() -> Object"},"getResponseType":{"!doc":"<p>Returns the (computed) value of the property <code>responseType</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #responseType}.</p>","!type":"fn() -> Object"},"getSequenceNumber":{"!doc":"<p>Obtain the sequence (id) number used for this request</p>","!type":"fn() -> +Integer"},"getState":{"!doc":"<p>Returns the (computed) value of the property <code>state</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #state}.</p>","!type":"fn() -> Object"},"getTimeout":{"!doc":"<p>Returns the (computed) value of the property <code>timeout</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #timeout}.</p>","!type":"fn() -> Object"},"getTransport":{"!doc":"<p>Returns the (computed) value of the property <code>transport</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #transport}.</p>","!type":"fn() -> Object"},"getUrl":{"!doc":"<p>Returns the (computed) value of the property <code>url</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #url}.</p>","!type":"fn() -> Object"},"getUseBasicHttpAuth":{"!doc":"<p>Returns the (computed) value of the property <code>useBasicHttpAuth</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #useBasicHttpAuth}.</p>","!type":"fn() -> Object"},"getUsername":{"!doc":"<p>Returns the (computed) value of the property <code>username</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #username}.</p>","!type":"fn() -> Object"},"initAsynchronous":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>asynchronous</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #asynchronous}.</p>","!type":"fn(value: Object) -> Object"},"initCrossDomain":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>crossDomain</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #crossDomain}.</p>","!type":"fn(value: Object) -> Object"},"initData":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>data</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #data}.</p>","!type":"fn(value: Object) -> Object"},"initFileUpload":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>fileUpload</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #fileUpload}.</p>","!type":"fn(value: Object) -> Object"},"initMethod":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>method</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #method}.</p>","!type":"fn(value: Object) -> Object"},"initParseJson":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>parseJson</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #parseJson}.</p>","!type":"fn(value: Object) -> Object"},"initPassword":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>password</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #password}.</p>","!type":"fn(value: Object) -> Object"},"initProhibitCaching":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>prohibitCaching</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #prohibitCaching}.</p>","!type":"fn(value: Object) -> Object"},"initResponseType":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>responseType</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #responseType}.</p>","!type":"fn(value: Object) -> Object"},"initState":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>state</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #state}.</p>","!type":"fn(value: Object) -> Object"},"initTimeout":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>timeout</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #timeout}.</p>","!type":"fn(value: Object) -> Object"},"initTransport":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>transport</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #transport}.</p>","!type":"fn(value: Object) -> Object"},"initUrl":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>url</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #url}.</p>","!type":"fn(value: Object) -> Object"},"initUseBasicHttpAuth":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>useBasicHttpAuth</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #useBasicHttpAuth}.</p>","!type":"fn(value: Object) -> Object"},"initUsername":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>username</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #username}.</p>","!type":"fn(value: Object) -> Object"},"isAborted":{"!doc":"<p>Determine if this request is in the aborted state.</p>","!type":"fn() -> bool"},"isAsynchronous":{"!doc":"<p>Check whether the (computed) value of the boolean property <code>asynchronous</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #asynchronous}.</p>","!type":"fn() -> bool"},"isCompleted":{"!doc":"<p>Determine if this request is in the completed state.</p>","!type":"fn() -> bool"},"isConfigured":{"!doc":"<p>Determine if this request is in the configured state.</p>","!type":"fn() -> bool"},"isCrossDomain":{"!doc":"<p>Check whether the (computed) value of the boolean property <code>crossDomain</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #crossDomain}.</p>","!type":"fn() -> bool"},"isFailed":{"!doc":"<p>Determine if this request is in the failed state.</p>","!type":"fn() -> bool"},"isFileUpload":{"!doc":"<p>Check whether the (computed) value of the boolean property <code>fileUpload</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #fileUpload}.</p>","!type":"fn() -> bool"},"isParseJson":{"!doc":"<p>Check whether the (computed) value of the boolean property <code>parseJson</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #parseJson}.</p>","!type":"fn() -> bool"},"isQueued":{"!doc":"<p>Determine if this request is in the queued state.</p>","!type":"fn() -> bool"},"isReceiving":{"!doc":"<p>Determine if this request is in the receiving state.</p>","!type":"fn() -> bool"},"isSending":{"!doc":"<p>Determine if this request is in the sending state.</p>","!type":"fn() -> bool"},"isTimeout":{"!doc":"<p>Determine if this request is in the timeout state.</p>","!type":"fn() -> bool"},"isUseBasicHttpAuth":{"!doc":"<p>Check whether the (computed) value of the boolean property <code>useBasicHttpAuth</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #useBasicHttpAuth}.</p>","!type":"fn() -> bool"},"removeFormField":{"!doc":"<p>Remove a form field from the <span class=\"caps\">POST</span> request.</p>","!type":"fn(vId: string)"},"removeParameter":{"!doc":"<p>Remove a parameter from the request.</p>","!type":"fn(vId: string, bFromData: bool)"},"removeRequestHeader":{"!doc":"<p>Remove a previously-added request header</p>","!type":"fn(vId: string)"},"reset":{"!doc":"<p>Abort sending this request if it has not already been aborted.</p>","!type":"fn()"},"resetAsynchronous":{"!doc":"<p>Resets the user value of the property <code>asynchronous</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #asynchronous}.</p>","!type":"fn()"},"resetCrossDomain":{"!doc":"<p>Resets the user value of the property <code>crossDomain</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #crossDomain}.</p>","!type":"fn()"},"resetData":{"!doc":"<p>Resets the user value of the property <code>data</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #data}.</p>","!type":"fn()"},"resetFileUpload":{"!doc":"<p>Resets the user value of the property <code>fileUpload</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #fileUpload}.</p>","!type":"fn()"},"resetMethod":{"!doc":"<p>Resets the user value of the property <code>method</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #method}.</p>","!type":"fn()"},"resetParseJson":{"!doc":"<p>Resets the user value of the property <code>parseJson</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #parseJson}.</p>","!type":"fn()"},"resetPassword":{"!doc":"<p>Resets the user value of the property <code>password</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #password}.</p>","!type":"fn()"},"resetProhibitCaching":{"!doc":"<p>Resets the user value of the property <code>prohibitCaching</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #prohibitCaching}.</p>","!type":"fn()"},"resetResponseType":{"!doc":"<p>Resets the user value of the property <code>responseType</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #responseType}.</p>","!type":"fn()"},"resetState":{"!doc":"<p>Resets the user value of the property <code>state</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #state}.</p>","!type":"fn()"},"resetTimeout":{"!doc":"<p>Resets the user value of the property <code>timeout</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #timeout}.</p>","!type":"fn()"},"resetTransport":{"!doc":"<p>Resets the user value of the property <code>transport</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #transport}.</p>","!type":"fn()"},"resetUrl":{"!doc":"<p>Resets the user value of the property <code>url</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #url}.</p>","!type":"fn()"},"resetUseBasicHttpAuth":{"!doc":"<p>Resets the user value of the property <code>useBasicHttpAuth</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #useBasicHttpAuth}.</p>","!type":"fn()"},"resetUsername":{"!doc":"<p>Resets the user value of the property <code>username</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #username}.</p>","!type":"fn()"},"send":{"!doc":"<p>Schedule this request for transport to server.</p>\n\n<p>The request is added to the singleton class qx.io.remote.RequestQueue&#8217;s\nlist of pending requests.</p>","!type":"fn()"},"setAsynchronous":{"!doc":"<p>Sets the user value of the property <code>asynchronous</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #asynchronous}.</p>","!type":"fn(value: Object) -> Object"},"setCrossDomain":{"!doc":"<p>Sets the user value of the property <code>crossDomain</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #crossDomain}.</p>","!type":"fn(value: Object) -> Object"},"setData":{"!doc":"<p>Sets the user value of the property <code>data</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #data}.</p>","!type":"fn(value: Object) -> Object"},"setFileUpload":{"!doc":"<p>Sets the user value of the property <code>fileUpload</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #fileUpload}.</p>","!type":"fn(value: Object) -> Object"},"setFormField":{"!doc":"<p>Add a form field to the <span class=\"caps\">POST</span> request.</p>\n\n<p><span class=\"caps\">NOTE</span>: Adding any programatic form fields using this method will switch the\n      Transport implementation to IframeTransport.</p>\n\n<p><span class=\"caps\">NOTE</span>: Use of these programatic form fields disallow use of synchronous\n      requests and cross-domain requests.  Be sure that you do not need\n      those features when setting these programatic form fields.</p>","!type":"fn(vId: string, vValue: string)"},"setMethod":{"!doc":"<p>Sets the user value of the property <code>method</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #method}.</p>","!type":"fn(value: Object) -> Object"},"setParameter":{"!doc":"<p>Add a parameter to the request.</p>","!type":"fn(vId: string, vValue: Object, bAsData: bool)"},"setParseJson":{"!doc":"<p>Sets the user value of the property <code>parseJson</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #parseJson}.</p>","!type":"fn(value: Object) -> Object"},"setPassword":{"!doc":"<p>Sets the user value of the property <code>password</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #password}.</p>","!type":"fn(value: Object) -> Object"},"setProhibitCaching":{"!doc":"<p>Sets the user value of the property <code>prohibitCaching</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #prohibitCaching}.</p>","!type":"fn(value: Object) -> Object"},"setRequestHeader":{"!doc":"<p>Add a request header to the request.</p>\n\n<p>Example: request.setRequestHeader(&#8220;Content-Type&#8221;, &#8220;text/html&#8221;)</p>\n\n<p>Please note: Some browsers, such as Safari 3 and 4, will capitalize\nheader field names. This is in accordance with <span class=\"caps\">RFC</span> 2616<sup class=\"footnote\"><a href=\"#fn1\">1</a></sup>, which states\nthat <span class=\"caps\">HTTP</span> 1.1 header names are case-insensitive, so your server backend\nshould be case-agnostic when dealing with request headers.</p>\n\n<p>[1]<a href=\"http://www.w3.org/Protocols/rfc2616/rfc2616-sec4.html#sec4.2\"><span class=\"caps\">RFC</span> 2616: <span class=\"caps\">HTTP</span> Message Headers</a></p>","!type":"fn(vId: string, vValue: string)"},"setResponseType":{"!doc":"<p>Sets the user value of the property <code>responseType</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #responseType}.</p>","!type":"fn(value: Object) -> Object"},"setState":{"!doc":"<p>Sets the user value of the property <code>state</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #state}.</p>","!type":"fn(value: Object) -> Object"},"setTimeout":{"!doc":"<p>Sets the user value of the property <code>timeout</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #timeout}.</p>","!type":"fn(value: Object) -> Object"},"setTransport":{"!doc":"<p>Sets the user value of the property <code>transport</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #transport}.</p>","!type":"fn(value: Object) -> Object"},"setUrl":{"!doc":"<p>Sets the user value of the property <code>url</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #url}.</p>","!type":"fn(value: Object) -> Object"},"setUseBasicHttpAuth":{"!doc":"<p>Sets the user value of the property <code>useBasicHttpAuth</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #useBasicHttpAuth}.</p>","!type":"fn(value: Object) -> Object"},"setUsername":{"!doc":"<p>Sets the user value of the property <code>username</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #username}.</p>","!type":"fn(value: Object) -> Object"},"toggleAsynchronous":{"!doc":"<p>Toggles the (computed) value of the boolean property <code>asynchronous</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #asynchronous}.</p>","!type":"fn() -> bool"},"toggleCrossDomain":{"!doc":"<p>Toggles the (computed) value of the boolean property <code>crossDomain</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #crossDomain}.</p>","!type":"fn() -> bool"},"toggleFileUpload":{"!doc":"<p>Toggles the (computed) value of the boolean property <code>fileUpload</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #fileUpload}.</p>","!type":"fn() -> bool"},"toggleParseJson":{"!doc":"<p>Toggles the (computed) value of the boolean property <code>parseJson</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #parseJson}.</p>","!type":"fn() -> bool"},"toggleUseBasicHttpAuth":{"!doc":"<p>Toggles the (computed) value of the boolean property <code>useBasicHttpAuth</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #useBasicHttpAuth}.</p>","!type":"fn() -> bool"}}},"RequestQueue":{"!proto":"qx.core.Object","!doc":"<p>Handles scheduling of requests to be sent to a server.</p>\n\n<p>This class is a singleton and is used by qx.io.remote.Request to schedule its\nrequests. It should not be used directly.</p>","!type":"fn()","prototype":{"_applyEnabled":{"!doc":"<p>Applies changes of the property value of the property <code>enabled</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #enabled}.</p>","!type":"fn(value: bool, old: bool)"},"_check":{"!doc":"<p>Checks the queue if any request is left to send and uses the transport\nlayer to send the open requests.\nThis method calls itself until every request in the queue is send.</p>","!type":"fn()"},"_debug":{"!doc":"<p>Generates debug output</p>","!type":"fn()"},"_oncompleted":{"!doc":"<p>Listens for the &#8220;completed&#8221; event of the transport object and decreases\nthe counter for active requests.</p>","!type":"fn(e: +qx.event.type.Event)"},"_oninterval":{"!doc":"<p>Listens for the &#8220;interval&#8221; event of the transport object and checks\nif the active requests are timed out.</p>","!type":"fn(e: +qx.event.type.Event)"},"_onreceiving":{"!doc":"<p>Listens for the &#8220;receiving&#8221; event of the transport object and delegate\nthe event to the current request object.</p>","!type":"fn(e: +qx.event.type.Event)"},"_onsending":{"!doc":"<p>Listens for the &#8220;sending&#8221; event of the transport object and increases\nthe counter for active requests.</p>","!type":"fn(e: +qx.event.type.Event)"},"_remove":{"!doc":"<p>Removes a transport object from the active queue and disposes the\ntransport object in order stop the request.</p>","!type":"fn(vTransport: +qx.io.remote.Exchange)"},"abort":{"!doc":"<p>Remove the request from the pending requests queue.</p>\n\n<p>The underlying transport of the request is forced into the aborted\n state (&#8220;aborted&#8221;) and listeners of the &#8220;aborted&#8221;\n signal are notified about the event. If the request isn&#8217;t in the\n pending requests queue, this method is a noop.</p>","!type":"fn(vRequest: Object)"},"add":{"!doc":"<p>Add the request to the pending requests queue.</p>","!type":"fn(vRequest: Object)"},"getActiveQueue":{"!doc":"<p>Get a list of active queued requests, each one wrapped in an instance of\n{@link qx.io.remote.Exchange}</p>","!type":"fn() -> +Exchange"},"getDefaultTimeout":{"!doc":"<p>Returns the (computed) value of the property <code>defaultTimeout</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #defaultTimeout}.</p>","!type":"fn() -> Object"},"getEnabled":{"!doc":"<p>Returns the (computed) value of the property <code>enabled</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #enabled}.</p>","!type":"fn() -> Object"},"getMaxConcurrentRequests":{"!doc":"<p>Returns the (computed) value of the property <code>maxConcurrentRequests</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #maxConcurrentRequests}.</p>","!type":"fn() -> Object"},"getMaxTotalRequests":{"!doc":"<p>Returns the (computed) value of the property <code>maxTotalRequests</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #maxTotalRequests}.</p>","!type":"fn() -> Object"},"getRequestQueue":{"!doc":"<p>Get a list of queued requests</p>","!type":"fn() -> +Request"},"initDefaultTimeout":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>defaultTimeout</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #defaultTimeout}.</p>","!type":"fn(value: Object) -> Object"},"initEnabled":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>enabled</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #enabled}.</p>","!type":"fn(value: Object) -> Object"},"initMaxConcurrentRequests":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>maxConcurrentRequests</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #maxConcurrentRequests}.</p>","!type":"fn(value: Object) -> Object"},"initMaxTotalRequests":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>maxTotalRequests</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #maxTotalRequests}.</p>","!type":"fn(value: Object) -> Object"},"isEnabled":{"!doc":"<p>Check whether the (computed) value of the boolean property <code>enabled</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #enabled}.</p>","!type":"fn() -> bool"},"resetDefaultTimeout":{"!doc":"<p>Resets the user value of the property <code>defaultTimeout</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #defaultTimeout}.</p>","!type":"fn()"},"resetEnabled":{"!doc":"<p>Resets the user value of the property <code>enabled</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #enabled}.</p>","!type":"fn()"},"resetMaxConcurrentRequests":{"!doc":"<p>Resets the user value of the property <code>maxConcurrentRequests</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #maxConcurrentRequests}.</p>","!type":"fn()"},"resetMaxTotalRequests":{"!doc":"<p>Resets the user value of the property <code>maxTotalRequests</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #maxTotalRequests}.</p>","!type":"fn()"},"setDefaultTimeout":{"!doc":"<p>Sets the user value of the property <code>defaultTimeout</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #defaultTimeout}.</p>","!type":"fn(value: Object) -> Object"},"setEnabled":{"!doc":"<p>Sets the user value of the property <code>enabled</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #enabled}.</p>","!type":"fn(value: Object) -> Object"},"setMaxConcurrentRequests":{"!doc":"<p>Sets the user value of the property <code>maxConcurrentRequests</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #maxConcurrentRequests}.</p>","!type":"fn(value: Object) -> Object"},"setMaxTotalRequests":{"!doc":"<p>Sets the user value of the property <code>maxTotalRequests</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #maxTotalRequests}.</p>","!type":"fn(value: Object) -> Object"},"toggleEnabled":{"!doc":"<p>Toggles the (computed) value of the boolean property <code>enabled</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #enabled}.</p>","!type":"fn() -> bool"}},"getInstance":{"!doc":"<p>Returns a singleton instance of this class. On the first call the class\nis instantiated by calling the constructor with no arguments. All following\ncalls will return this instance.</p>\n\n<p>This method has been added by setting the &#8220;type&#8221; key in the class definition\n({@link qx.Class#define}) to &#8220;singleton&#8221;.</p>","!type":"fn() -> +qx.io.remote.RequestQueue"}},"Response":{"!proto":"qx.event.type.Event","!doc":"<p>This class is used to work with the result of a <span class=\"caps\">HTTP</span> request.</p>","prototype":{"_applyResponseHeaders":{"!doc":"<p>Keep lower-cased shadow of response headers for later\ncase-insensitive matching.</p>","!type":"fn(value: Object, old: Object)"},"clone":{"!type":"fn(embryo: +undefined)"},"getContent":{"!doc":"<p>Returns the (computed) value of the property <code>content</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #content}.</p>","!type":"fn() -> Object"},"getResponseHeader":{"!doc":"<p>Returns a specific response header</p>","!type":"fn(vHeader: string) -> Object"},"getResponseHeaders":{"!doc":"<p>Returns the (computed) value of the property <code>responseHeaders</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #responseHeaders}.</p>","!type":"fn() -> Object"},"getState":{"!doc":"<p>Returns the (computed) value of the property <code>state</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #state}.</p>","!type":"fn() -> Object"},"getStatusCode":{"!doc":"<p>Returns the (computed) value of the property <code>statusCode</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #statusCode}.</p>","!type":"fn() -> Object"},"initContent":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>content</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #content}.</p>","!type":"fn(value: Object) -> Object"},"initResponseHeaders":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>responseHeaders</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #responseHeaders}.</p>","!type":"fn(value: Object) -> Object"},"initState":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>state</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #state}.</p>","!type":"fn(value: Object) -> Object"},"initStatusCode":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>statusCode</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #statusCode}.</p>","!type":"fn(value: Object) -> Object"},"resetContent":{"!doc":"<p>Resets the user value of the property <code>content</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #content}.</p>","!type":"fn()"},"resetResponseHeaders":{"!doc":"<p>Resets the user value of the property <code>responseHeaders</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #responseHeaders}.</p>","!type":"fn()"},"resetState":{"!doc":"<p>Resets the user value of the property <code>state</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #state}.</p>","!type":"fn()"},"resetStatusCode":{"!doc":"<p>Resets the user value of the property <code>statusCode</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #statusCode}.</p>","!type":"fn()"},"setContent":{"!doc":"<p>Sets the user value of the property <code>content</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #content}.</p>","!type":"fn(value: Object) -> Object"},"setResponseHeaders":{"!doc":"<p>Sets the user value of the property <code>responseHeaders</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #responseHeaders}.</p>","!type":"fn(value: Object) -> Object"},"setState":{"!doc":"<p>Sets the user value of the property <code>state</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #state}.</p>","!type":"fn(value: Object) -> Object"},"setStatusCode":{"!doc":"<p>Sets the user value of the property <code>statusCode</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #statusCode}.</p>","!type":"fn(value: Object) -> Object"}}},"Rpc":{"!proto":"qx.core.Object","!doc":"<p>Provides a Remote Procedure Call (RPC) implementation.</p>\n\n<p>Each instance of this class represents a &#8220;Service&#8221;. These services can\ncorrespond to various concepts on the server side (depending on the\nprogramming language/environment being used), but usually, a service means\na class on the server.</p>\n\n<p>In case multiple instances of the same service are needed, they can be\ndistinguished by ids. If such an id is specified, the server routes all\ncalls to a service that have the same id to the same server-side instance.</p>\n\n<p>When calling a server-side method, the parameters and return values are\nconverted automatically. Supported types are int (and Integer), double\n(and Double), String, Date, Map, and JavaBeans. Beans must have a default\nconstructor on the server side and are represented by simple JavaScript\nobjects on the client side (used as associative arrays with keys matching\nthe server-side properties). Beans can also be nested, but be careful not to\ncreate circular references! There are no checks to detect these (which would\nbe expensive), so you as the user are responsible for avoiding them.</p>\n\n<p>A simple example:</p>\n\n<pre class=\"javascript\">\n  function callRpcServer ()\n  {\n    var rpc = new qx.io.remote.Rpc();\n    rpc.setTimeout(10000);\n    rpc.setUrl(\"http://127.0.0.1:8007\");\n    rpc.setServiceName(\"qooxdoo.admin\");\n\n    // call a remote procedure -- takes no arguments, returns a string\n    var that = this;\n    this.RpcRunning = rpc.callAsync(\n      function(result, ex, id)\n      {\n        that.RpcRunning = null;\n        if (ex == null) {\n            alert(result);\n        } else {\n            alert(\"Async(\" + id + \") exception: \" + ex);\n        }\n      },\n      \"fss.getBaseDir\");\n  }\n</pre>\n\n<p><i>fss.getBaseDir</i> is the remote procedure in this case, potential arguments\nwould be listed after the procedure name.</p>\n\n<p>Passing data from the client (qooxdoo) side is demonstrated in the\nqooxdoo-contrib project RpcExample. There are three ways to issue a remote\nprocedure call: synchronously (qx.io.remote.Rpc.callSync&#8212;dangerous\nbecause it blocks the whole browser, not just your application, so is\nhighly discouraged); async with results via a callback function\n(qx.io.remote.Rpc.callAsync) and async with results via an event listener\n(qx.io.remote.Rpc.callAsyncListeners).</p>\n\n<p>You may also find the server writer&#8217;s guide helpful:\n  <a href=\"http://manual.qooxdoo.org/4.1/pages/communication/rpc_server_writer_guide.html\">http://manual.qooxdoo.org/4.1/pages/communication/rpc_server_writer_guide.html</a></p>","!type":"fn()","makeServerURL":{"!doc":"<p>Creates an <span class=\"caps\">URL</span> for talking to a local service. A local service is one that\nlives in the same application as the page calling the service. For backends\nthat don&#8217;t support this auto-generation, this method returns null.</p>","!type":"fn(instanceId?: string) -> string"},"prototype":{"_callInternal":{"!doc":"<p>Internal <span class=\"caps\">RPC</span> call method</p>","!type":"fn(args: +Array, callType: +Integer, refreshSession: bool) -> Object"},"_isConvertDates":{"!doc":"<p>Whether to convert date objects to pseudo literals and\nparse with eval.</p>\n\n<p>Controlled by {@link #CONVERT_DATES}.</p>","!type":"fn() -> bool"},"_isResponseJson":{"!doc":"<p>Whether to expect and verify a <span class=\"caps\">JSON</span> response.</p>\n\n<p>Controlled by {@link #RESPONSE_JSON}.</p>","!type":"fn() -> bool"},"abort":{"!doc":"<p>Aborts an asynchronous server call. Consequently, the callback function\nprovided to <code>callAsync</code> or <code>callAsyncListeners</code>\nwill be called with an exception.</p>","!type":"fn(opaqueCallRef: Object)"},"callAsync":{"!doc":"<p>Makes an asynchronous server call. The method arguments (if any) follow\nafter the method name (as normal JavaScript arguments, separated by\ncommas, not as an array).</p>\n\n<p>When an answer from the server arrives, the <code>handler</code>\nfunction is called with the result of the call as the first, an\nexception as the second parameter, and the id (aka sequence number) of\nthe invoking request as the third parameter. If the call was\nsuccessful, the second parameter is <code>null</code>. If there was a\nproblem, the second parameter contains an exception, and the first one\nis <code>null</code>.</p>\n\n<p>The return value of this method is a call reference that you can store\nif you want to abort the request later on. This value should be treated\nas opaque and can change completely in the future! The only thing you\ncan rely on is that the <code>abort</code> method will accept this\nreference and that you can retrieve the sequence number of the request\nby invoking the getSequenceNumber() method (see below).</p>\n\n<p>If a specific method is being called, asynchronously, a number of times\nin succession, the getSequenceNumber() method may be used to\ndisambiguate which request a response corresponds to.  The sequence\nnumber value is a value which increments with each request.)</p>","!type":"fn(handler: fn(), methodName: string) -> Object"},"callAsyncListeners":{"!doc":"<p>Makes an asynchronous server call and dispatches an event upon completion\nor failure. The method arguments (if any) follow after the method name\n(as normal JavaScript arguments, separated by commas, not as an array).</p>\n\n<p>When an answer from the server arrives (or fails to arrive on time), if\nan exception occurred, a &#8220;failed&#8221;, &#8220;timeout&#8221; or &#8220;aborted&#8221; event, as\nappropriate, is dispatched to any waiting event listeners.  If no\nexception occurred, a &#8220;completed&#8221; event is dispatched.</p>\n\n<p>When a &#8220;failed&#8221;, &#8220;timeout&#8221; or &#8220;aborted&#8221; event is dispatched, the event\ndata contains an object with the properties &#8216;origin&#8217;, &#8216;code&#8217;, &#8216;message&#8217;\nand &#8216;id&#8217;.  The object has a toString() function which may be called to\nconvert the exception to a string.</p>\n\n<p>When a &#8220;completed&#8221; event is dispatched, the event data contains a\nmap with the <span class=\"caps\">JSON</span>-RPC sequence number and result:</p>\n\n<p>{\n  id: rpc_id,\n  result: json-rpc result\n}</p>\n\n<p>The return value of this method is a call reference that you can store\nif you want to abort the request later on. This value should be treated\nas opaque and can change completely in the future! The only thing you\ncan rely on is that the <code>abort</code> method will accept this\nreference and that you can retrieve the sequence number of the request\nby invoking the getSequenceNumber() method (see below).</p>\n\n<p>If a specific method is being called, asynchronously, a number of times\nin succession, the getSequenceNumber() method may be used to\ndisambiguate which request a response corresponds to.  The sequence\nnumber value is a value which increments with each request.)</p>","!type":"fn(coalesce: bool, methodName: string) -> Object"},"callSync":{"!doc":"<p>Makes a synchronous server call. The method arguments (if any) follow\nafter the method name (as normal JavaScript arguments, separated by\ncommas, not as an array).</p>\n\n<p>If a problem occurs when making the call, an exception is thrown.</p>\n\n<p><span class=\"caps\">WARNING</span>.  With some browsers, the synchronous interface\ncauses the browser to hang while awaiting a response!  If the server\ndecides to pause for a minute or two, your browser may do nothing\n(including refreshing following window changes) until the response is\nreceived.  Instead, use the asynchronous interface.</p>\n\n<p><span class=\"caps\">YOU</span> <span class=\"caps\">HAVE</span> <span class=\"caps\">BEEN</span> <span class=\"caps\">WARNED</span>.</p>","!type":"fn(methodName: string) -> Object"},"createRequest":{"!doc":"<p>Factory method to create a request object. By default, a <span class=\"caps\">POST</span> request\nwill be made, and the expected response type will be\n&#8220;application/json&#8221;. Classes extending this one may override this method\nto obtain a Request object with different parameters.</p>","!type":"fn() -> +qx.io.remote.Request"},"createRpcData":{"!doc":"<p>Factory method to create the object containing the remote procedure\ncall data. By default, a qooxdoo-style <span class=\"caps\">RPC</span> request is built, which\ncontains the following members: &#8220;service&#8221;, &#8220;method&#8221;, &#8220;id&#8221;, and\n&#8220;params&#8221;. If a different style of <span class=\"caps\">RPC</span> request is desired, a class\nextending this one may override this method.</p>","!type":"fn(id: +Integer, method: string, parameters: +Array, serverData: Object) -> Object"},"fixUrl":{"!doc":"<p>Helper method to rewrite a <span class=\"caps\">URL</span> with a stale session id (so that it includes\nthe correct session id afterwards).</p>","!type":"fn(url: string) -> string"},"getCrossDomain":{"!doc":"<p>Returns the (computed) value of the property <code>crossDomain</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #crossDomain}.</p>","!type":"fn() -> Object"},"getPassword":{"!doc":"<p>Returns the (computed) value of the property <code>password</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #password}.</p>","!type":"fn() -> Object"},"getProtocol":{"!doc":"<p>Returns the (computed) value of the property <code>protocol</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #protocol}.</p>","!type":"fn() -> Object"},"getServerData":{"!doc":"<p>Returns the (computed) value of the property <code>serverData</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #serverData}.</p>","!type":"fn() -> Object"},"getServiceName":{"!doc":"<p>Returns the (computed) value of the property <code>serviceName</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #serviceName}.</p>","!type":"fn() -> Object"},"getTimeout":{"!doc":"<p>Returns the (computed) value of the property <code>timeout</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #timeout}.</p>","!type":"fn() -> Object"},"getUrl":{"!doc":"<p>Returns the (computed) value of the property <code>url</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #url}.</p>","!type":"fn() -> Object"},"getUseBasicHttpAuth":{"!doc":"<p>Returns the (computed) value of the property <code>useBasicHttpAuth</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #useBasicHttpAuth}.</p>","!type":"fn() -> Object"},"getUsername":{"!doc":"<p>Returns the (computed) value of the property <code>username</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #username}.</p>","!type":"fn() -> Object"},"initCrossDomain":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>crossDomain</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #crossDomain}.</p>","!type":"fn(value: Object) -> Object"},"initPassword":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>password</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #password}.</p>","!type":"fn(value: Object) -> Object"},"initProtocol":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>protocol</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #protocol}.</p>","!type":"fn(value: Object) -> Object"},"initServerData":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>serverData</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #serverData}.</p>","!type":"fn(value: Object) -> Object"},"initServiceName":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>serviceName</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #serviceName}.</p>","!type":"fn(value: Object) -> Object"},"initTimeout":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>timeout</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #timeout}.</p>","!type":"fn(value: Object) -> Object"},"initUrl":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>url</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #url}.</p>","!type":"fn(value: Object) -> Object"},"initUseBasicHttpAuth":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>useBasicHttpAuth</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #useBasicHttpAuth}.</p>","!type":"fn(value: Object) -> Object"},"initUsername":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>username</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #username}.</p>","!type":"fn(value: Object) -> Object"},"isCrossDomain":{"!doc":"<p>Check whether the (computed) value of the boolean property <code>crossDomain</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #crossDomain}.</p>","!type":"fn() -> bool"},"isUseBasicHttpAuth":{"!doc":"<p>Check whether the (computed) value of the boolean property <code>useBasicHttpAuth</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #useBasicHttpAuth}.</p>","!type":"fn() -> bool"},"refreshSession":{"!doc":"<p>Refreshes a server session by retrieving the session id again from the\nserver.</p>\n\n<p>The specified handler function is called when the refresh is\ncomplete. The first parameter can be <code>true</code> (indicating that\na refresh either wasn&#8217;t necessary at this time or it was successful) or\n<code>false</code> (indicating that a refresh would have been necessary\nbut can&#8217;t be performed because the server backend doesn&#8217;t support\nit). If there is a non-null second parameter, it&#8217;s an exception\nindicating that there was an error when refreshing the session.</p>","!type":"fn(handler: fn())"},"resetCrossDomain":{"!doc":"<p>Resets the user value of the property <code>crossDomain</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #crossDomain}.</p>","!type":"fn()"},"resetPassword":{"!doc":"<p>Resets the user value of the property <code>password</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #password}.</p>","!type":"fn()"},"resetProtocol":{"!doc":"<p>Resets the user value of the property <code>protocol</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #protocol}.</p>","!type":"fn()"},"resetServerData":{"!doc":"<p>Resets the user value of the property <code>serverData</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #serverData}.</p>","!type":"fn()"},"resetServiceName":{"!doc":"<p>Resets the user value of the property <code>serviceName</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #serviceName}.</p>","!type":"fn()"},"resetTimeout":{"!doc":"<p>Resets the user value of the property <code>timeout</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #timeout}.</p>","!type":"fn()"},"resetUrl":{"!doc":"<p>Resets the user value of the property <code>url</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #url}.</p>","!type":"fn()"},"resetUseBasicHttpAuth":{"!doc":"<p>Resets the user value of the property <code>useBasicHttpAuth</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #useBasicHttpAuth}.</p>","!type":"fn()"},"resetUsername":{"!doc":"<p>Resets the user value of the property <code>username</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #username}.</p>","!type":"fn()"},"setCrossDomain":{"!doc":"<p>Sets the user value of the property <code>crossDomain</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #crossDomain}.</p>","!type":"fn(value: Object) -> Object"},"setPassword":{"!doc":"<p>Sets the user value of the property <code>password</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #password}.</p>","!type":"fn(value: Object) -> Object"},"setProtocol":{"!doc":"<p>Sets the user value of the property <code>protocol</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #protocol}.</p>","!type":"fn(value: Object) -> Object"},"setServerData":{"!doc":"<p>Sets the user value of the property <code>serverData</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #serverData}.</p>","!type":"fn(value: Object) -> Object"},"setServiceName":{"!doc":"<p>Sets the user value of the property <code>serviceName</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #serviceName}.</p>","!type":"fn(value: Object) -> Object"},"setTimeout":{"!doc":"<p>Sets the user value of the property <code>timeout</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #timeout}.</p>","!type":"fn(value: Object) -> Object"},"setUrl":{"!doc":"<p>Sets the user value of the property <code>url</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #url}.</p>","!type":"fn(value: Object) -> Object"},"setUseBasicHttpAuth":{"!doc":"<p>Sets the user value of the property <code>useBasicHttpAuth</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #useBasicHttpAuth}.</p>","!type":"fn(value: Object) -> Object"},"setUsername":{"!doc":"<p>Sets the user value of the property <code>username</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #username}.</p>","!type":"fn(value: Object) -> Object"},"toggleCrossDomain":{"!doc":"<p>Toggles the (computed) value of the boolean property <code>crossDomain</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #crossDomain}.</p>","!type":"fn() -> bool"},"toggleUseBasicHttpAuth":{"!doc":"<p>Toggles the (computed) value of the boolean property <code>useBasicHttpAuth</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #useBasicHttpAuth}.</p>","!type":"fn() -> bool"}}},"RpcError":{"!doc":"<p>The well-defined error codes for <span class=\"caps\">JSON</span>-RPC.</p>"},"transport":{"Abstract":{"!proto":"qx.core.Object","!doc":"<p>Abstract for all transport implementations</p>","!type":"fn()","prototype":{"_applyState":{"!doc":"<p>Apply method for &#8220;state&#8221; property. For each state value a corresponding\nevent is fired to inform the listeners.</p>","!type":"fn(value: Object, old: Object)"},"abort":{"!doc":"<p>Force the transport into the aborted state (&#8220;aborted&#8221;).</p>\n\n<p>Listeners of the &#8220;aborted&#8221; signal are notified about the event.</p>","!type":"fn()"},"failed":{"!doc":"<p>Force the transport into the failed state (&#8220;failed&#8221;).</p>\n\n<p>Listeners of the &#8220;failed&#8221; signal are notified about the event.</p>","!type":"fn()"},"getAsynchronous":{"!doc":"<p>Returns the (computed) value of the property <code>asynchronous</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #asynchronous}.</p>","!type":"fn() -> Object"},"getData":{"!doc":"<p>Returns the (computed) value of the property <code>data</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #data}.</p>","!type":"fn() -> Object"},"getFetchedLength":{"!doc":"<p>Returns the length of the content as fetched thus far.</p>\n\n<p>This method is virtual and concrete subclasses are supposed to\nimplement it.</p>","!type":"fn() -> +Integer"},"getFormFields":{"!doc":"<p>Returns the (computed) value of the property <code>formFields</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #formFields}.</p>","!type":"fn() -> Object"},"getMethod":{"!doc":"<p>Returns the (computed) value of the property <code>method</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #method}.</p>","!type":"fn() -> Object"},"getParameters":{"!doc":"<p>Returns the (computed) value of the property <code>parameters</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #parameters}.</p>","!type":"fn() -> Object"},"getPassword":{"!doc":"<p>Returns the (computed) value of the property <code>password</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #password}.</p>","!type":"fn() -> Object"},"getRequestHeaders":{"!doc":"<p>Returns the (computed) value of the property <code>requestHeaders</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #requestHeaders}.</p>","!type":"fn() -> Object"},"getResponseHeader":{"!doc":"<p>Returns the request header of the request.</p>\n\n<p>This method is virtual and concrete subclasses are supposed to\nimplement it.</p>","!type":"fn(vLabel: string) -> Object"},"getResponseHeaders":{"!doc":"<p>Provides an hash of all response headers.</p>\n\n<p>This method is virtual and concrete subclasses are supposed to\nimplement it.</p>","!type":"fn() -> Object"},"getResponseText":{"!doc":"<p>Provides the response text from the request when available and null otherwise.\nBy passing true as the &#8220;partial&#8221; parameter of this method, incomplete data will\nbe made available to the caller.</p>\n\n<p>This method is virtual and concrete subclasses are supposed to\nimplement it.</p>","!type":"fn() -> string"},"getResponseType":{"!doc":"<p>Returns the (computed) value of the property <code>responseType</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #responseType}.</p>","!type":"fn() -> Object"},"getResponseXml":{"!doc":"<p>Provides the <span class=\"caps\">XML</span> provided by the response if any and null otherwise.\nBy passing true as the &#8220;partial&#8221; parameter of this method, incomplete data will\nbe made available to the caller.</p>\n\n<p>This method is virtual and concrete subclasses are supposed to\nimplement it.</p>","!type":"fn() -> Object"},"getState":{"!doc":"<p>Returns the (computed) value of the property <code>state</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #state}.</p>","!type":"fn() -> Object"},"getStatusCode":{"!doc":"<p>Returns the current status code of the request if available or -1 if not.</p>\n\n<p>This method is virtual and concrete subclasses are supposed to\nimplement it.</p>","!type":"fn() -> +Integer"},"getStatusText":{"!doc":"<p>Provides the status text for the current request if available and null otherwise.</p>\n\n<p>This method is virtual and concrete subclasses are supposed to\nimplement it.</p>","!type":"fn() -> string"},"getUrl":{"!doc":"<p>Returns the (computed) value of the property <code>url</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #url}.</p>","!type":"fn() -> Object"},"getUseBasicHttpAuth":{"!doc":"<p>Returns the (computed) value of the property <code>useBasicHttpAuth</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #useBasicHttpAuth}.</p>","!type":"fn() -> Object"},"getUsername":{"!doc":"<p>Returns the (computed) value of the property <code>username</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #username}.</p>","!type":"fn() -> Object"},"initAsynchronous":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>asynchronous</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #asynchronous}.</p>","!type":"fn(value: Object) -> Object"},"initData":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>data</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #data}.</p>","!type":"fn(value: Object) -> Object"},"initFormFields":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>formFields</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #formFields}.</p>","!type":"fn(value: Object) -> Object"},"initMethod":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>method</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #method}.</p>","!type":"fn(value: Object) -> Object"},"initParameters":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>parameters</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #parameters}.</p>","!type":"fn(value: Object) -> Object"},"initPassword":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>password</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #password}.</p>","!type":"fn(value: Object) -> Object"},"initRequestHeaders":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>requestHeaders</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #requestHeaders}.</p>","!type":"fn(value: Object) -> Object"},"initResponseType":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>responseType</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #responseType}.</p>","!type":"fn(value: Object) -> Object"},"initState":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>state</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #state}.</p>","!type":"fn(value: Object) -> Object"},"initUrl":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>url</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #url}.</p>","!type":"fn(value: Object) -> Object"},"initUseBasicHttpAuth":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>useBasicHttpAuth</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #useBasicHttpAuth}.</p>","!type":"fn(value: Object) -> Object"},"initUsername":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>username</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #username}.</p>","!type":"fn(value: Object) -> Object"},"isAsynchronous":{"!doc":"<p>Check whether the (computed) value of the boolean property <code>asynchronous</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #asynchronous}.</p>","!type":"fn() -> bool"},"isUseBasicHttpAuth":{"!doc":"<p>Check whether the (computed) value of the boolean property <code>useBasicHttpAuth</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #useBasicHttpAuth}.</p>","!type":"fn() -> bool"},"resetAsynchronous":{"!doc":"<p>Resets the user value of the property <code>asynchronous</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #asynchronous}.</p>","!type":"fn()"},"resetData":{"!doc":"<p>Resets the user value of the property <code>data</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #data}.</p>","!type":"fn()"},"resetFormFields":{"!doc":"<p>Resets the user value of the property <code>formFields</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #formFields}.</p>","!type":"fn()"},"resetMethod":{"!doc":"<p>Resets the user value of the property <code>method</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #method}.</p>","!type":"fn()"},"resetParameters":{"!doc":"<p>Resets the user value of the property <code>parameters</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #parameters}.</p>","!type":"fn()"},"resetPassword":{"!doc":"<p>Resets the user value of the property <code>password</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #password}.</p>","!type":"fn()"},"resetRequestHeaders":{"!doc":"<p>Resets the user value of the property <code>requestHeaders</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #requestHeaders}.</p>","!type":"fn()"},"resetResponseType":{"!doc":"<p>Resets the user value of the property <code>responseType</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #responseType}.</p>","!type":"fn()"},"resetState":{"!doc":"<p>Resets the user value of the property <code>state</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #state}.</p>","!type":"fn()"},"resetUrl":{"!doc":"<p>Resets the user value of the property <code>url</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #url}.</p>","!type":"fn()"},"resetUseBasicHttpAuth":{"!doc":"<p>Resets the user value of the property <code>useBasicHttpAuth</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #useBasicHttpAuth}.</p>","!type":"fn()"},"resetUsername":{"!doc":"<p>Resets the user value of the property <code>username</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #username}.</p>","!type":"fn()"},"send":{"!doc":"<p>Sending a request.</p>\n\n<p>This method is virtual and concrete subclasses are supposed to\nimplement it.</p>","!type":"fn()"},"setAsynchronous":{"!doc":"<p>Sets the user value of the property <code>asynchronous</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #asynchronous}.</p>","!type":"fn(value: Object) -> Object"},"setData":{"!doc":"<p>Sets the user value of the property <code>data</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #data}.</p>","!type":"fn(value: Object) -> Object"},"setFormFields":{"!doc":"<p>Sets the user value of the property <code>formFields</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #formFields}.</p>","!type":"fn(value: Object) -> Object"},"setMethod":{"!doc":"<p>Sets the user value of the property <code>method</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #method}.</p>","!type":"fn(value: Object) -> Object"},"setParameters":{"!doc":"<p>Sets the user value of the property <code>parameters</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #parameters}.</p>","!type":"fn(value: Object) -> Object"},"setPassword":{"!doc":"<p>Sets the user value of the property <code>password</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #password}.</p>","!type":"fn(value: Object) -> Object"},"setRequestHeader":{"!doc":"<p>Add a request header to this transports qx.io.remote.Request.</p>\n\n<p>This method is virtual and concrete subclasses are supposed to\nimplement it.</p>","!type":"fn(vLabel: string, vValue: Object)"},"setRequestHeaders":{"!doc":"<p>Sets the user value of the property <code>requestHeaders</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #requestHeaders}.</p>","!type":"fn(value: Object) -> Object"},"setResponseType":{"!doc":"<p>Sets the user value of the property <code>responseType</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #responseType}.</p>","!type":"fn(value: Object) -> Object"},"setState":{"!doc":"<p>Sets the user value of the property <code>state</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #state}.</p>","!type":"fn(value: Object) -> Object"},"setUrl":{"!doc":"<p>Sets the user value of the property <code>url</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #url}.</p>","!type":"fn(value: Object) -> Object"},"setUseBasicHttpAuth":{"!doc":"<p>Sets the user value of the property <code>useBasicHttpAuth</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #useBasicHttpAuth}.</p>","!type":"fn(value: Object) -> Object"},"setUsername":{"!doc":"<p>Sets the user value of the property <code>username</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #username}.</p>","!type":"fn(value: Object) -> Object"},"timeout":{"!doc":"<p>Force the transport into the timeout state (&#8220;timeout&#8221;).</p>\n\n<p>Listeners of the &#8220;timeout&#8221; signal are notified about the event.</p>","!type":"fn()"},"toggleAsynchronous":{"!doc":"<p>Toggles the (computed) value of the boolean property <code>asynchronous</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #asynchronous}.</p>","!type":"fn() -> bool"},"toggleUseBasicHttpAuth":{"!doc":"<p>Toggles the (computed) value of the boolean property <code>useBasicHttpAuth</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #useBasicHttpAuth}.</p>","!type":"fn() -> bool"}}},"Iframe":{"!proto":"qx.io.remote.transport.Abstract","!doc":"<p>Transports requests to a server using an <span class=\"caps\">IFRAME</span>.</p>\n\n<p>This class should not be used directly by client programmers.</p>","!type":"fn()","isSupported":{"!doc":"<p>Returns always true, because iframe transport is supported by all browsers.</p>","!type":"fn() -> bool"},"prototype":{"_onload":{"!doc":"<p>Converting complete state to numeric value and update state property</p>","!type":"fn(e: +qx.event.type.Event)"},"_onreadystatechange":{"!doc":"<p>Converting named readyState to numeric value and update state property</p>","!type":"fn(e: +qx.event.type.Event)"},"_switchReadyState":{"!doc":"<p>Switches the readystate by setting the internal state.</p>","!type":"fn(vReadyState: string)"},"getFetchedLength":{"!doc":"<p>Returns the length of the content as fetched thus far.\nThis method needs implementation (returns always 0).</p>","!type":"fn() -> +Integer"},"getIframeBody":{"!doc":"<p>Returns the body node of the used iframe.</p>","!type":"fn() -> Object"},"getIframeDocument":{"!doc":"<p>Returns the document node of the used iframe.</p>","!type":"fn() -> Object"},"getIframeHtmlContent":{"!doc":"<p>Returns the iframe content as <span class=\"caps\">HTML</span>.</p>","!type":"fn() -> string"},"getIframeTextContent":{"!doc":"<p>Returns the iframe content (innerHTML) as text.</p>","!type":"fn() -> string"},"getIframeWindow":{"!doc":"<p>Returns the <span class=\"caps\">DOM</span> window object of the used iframe.</p>","!type":"fn() -> Object"},"getResponseContent":{"!doc":"<p>Returns the content of the response</p>","!type":"fn() -> +null"},"getResponseHeader":{"!doc":"<p>Returns the value of the given response header.</p>\n\n<p>This method is not implemented at the moment and returns always &#8220;null&#8221;.</p>","!type":"fn(vLabel: string) -> +null"},"getResponseHeaders":{"!doc":"<p>Provides an hash of all response headers.</p>\n\n<p>This method is not implemented at the moment and returns an empty map.</p>","!type":"fn() -> +Map"},"getStatusCode":{"!doc":"<p>Returns the current status code of the request if available or -1 if not.\nThis method needs implementation (returns always 200).</p>","!type":"fn() -> +Integer"},"getStatusText":{"!doc":"<p>Provides the status text for the current request if available and null otherwise.\nThis method needs implementation (returns always an empty string)</p>","!type":"fn() -> string"},"send":{"!doc":"<p>Sends a request with the use of a form.</p>","!type":"fn()"},"setRequestHeader":{"!doc":"<p>Sets a request header with the given value.</p>\n\n<p>This method is not implemented at the moment.</p>","!type":"fn(vLabel: string, vValue: Object)"}}},"Script":{"!proto":"qx.io.remote.transport.Abstract","!doc":"<p>Transports requests to a server using dynamic script tags.</p>\n\n<p>This class should not be used directly by client programmers.</p>","!type":"fn()","_requestFinished":{"!doc":"<p>This method can be called by the script loaded by the ScriptTransport\nclass.</p>","!type":"fn(id: string, content: string)"},"isSupported":{"!doc":"<p>Returns always true, because script transport is supported by all browsers.</p>","!type":"fn() -> bool"},"prototype":{"_switchReadyState":{"!doc":"<p>Switches the readystate by setting the internal state.</p>","!type":"fn(vReadyState: string)"},"getFetchedLength":{"!doc":"<p>Returns the length of the content as fetched thus far.\nThis method needs implementation (returns always 0).</p>","!type":"fn() -> +Integer"},"getResponseContent":{"!doc":"<p>Returns the content of the response.</p>","!type":"fn() -> +null"},"getResponseHeader":{"!doc":"<p>Returns the value of the given response header.</p>\n\n<p>This method is not implemented at the moment and returns always &#8220;null&#8221;.</p>","!type":"fn(vLabel: string) -> +null"},"getResponseHeaders":{"!doc":"<p>Provides an hash of all response headers.</p>\n\n<p>This method is not implemented at the moment and returns an empty map.</p>","!type":"fn() -> +Map"},"getStatusCode":{"!doc":"<p>Returns the current status code of the request if available or -1 if not.\nThis method needs implementation (returns always 200).</p>","!type":"fn() -> +Integer"},"getStatusText":{"!doc":"<p>Provides the status text for the current request if available and null otherwise.\nThis method needs implementation (returns always an empty string)</p>","!type":"fn() -> string"},"send":{"!doc":"<p>Sends the request using &#8220;script&#8221; elements</p>","!type":"fn()"},"setRequestHeader":{"!doc":"<p>Sets a request header with the given value.</p>\n\n<p>This method is not implemented at the moment.</p>","!type":"fn(vLabel: string, vValue: Object)"}}},"XmlHttp":{"!proto":"qx.io.remote.transport.Abstract","!doc":"<p>Transports requests to a server using the native XmlHttpRequest object.</p>\n\n<p>This class should not be used directly by client programmers.</p>","createRequestObject":{"!doc":"<p>Return a new XMLHttpRequest object suitable for the client browser.</p>","!type":"fn() -> Object"},"isSupported":{"!doc":"<p>Whether the transport type is supported by the client.</p>","!type":"fn() -> bool"},"prototype":{"_applyState":{"!doc":"<p>Apply method for the &#8220;state&#8221; property.\nFires an event for each state value to inform the listeners.</p>","!type":"fn(value: Object, old: Object)"},"_onreadystatechange":{"!doc":"<p>Listener method for change of the &#8220;readystate&#8221;.\nSets the internal state and informs the transport layer.</p>","!type":"fn(e: +Event)"},"failedLocally":{"!doc":"<p>Force the transport into the failed state (&#8220;failed&#8221;).</p>\n\n<p>This method should be used only if the requests <span class=\"caps\">URI</span> was local\naccess. I.e. it started with &#8220;file://&#8221;.</p>","!type":"fn()"},"getFetchedLength":{"!doc":"<p>Returns the length of the content as fetched thus far</p>","!type":"fn() -> +Integer"},"getParseJson":{"!doc":"<p>Returns the (computed) value of the property <code>parseJson</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #parseJson}.</p>","!type":"fn() -> Object"},"getReadyState":{"!doc":"<p>Get the ready state of this transports request.</p>\n\n<p>For qx.io.remote.transport.XmlHttp, ready state is a number between 1 to 4.</p>","!type":"fn() -> +Integer"},"getRequest":{"!doc":"<p>Returns the native request object</p>","!type":"fn() -> Object"},"getResponseContent":{"!doc":"<p>Returns the content of the response</p>","!type":"fn() -> +null"},"getResponseHeader":{"!doc":"<p>Returns a specific header provided by the server upon sending a request,\nwith header name determined by the argument headerName.</p>\n\n<p>Only available at readyState 3 and 4 universally and in readyState 2\nin Gecko.</p>\n\n<p>Please note: Some servers/proxies (such as Selenium RC) will capitalize\nresponse header names. This is in accordance with <span class=\"caps\">RFC</span> 2616<sup class=\"footnote\"><a href=\"#fn1\">1</a></sup>, which\nstates that <span class=\"caps\">HTTP</span> 1.1 header names are case-insensitive, so your\napplication should be case-agnostic when dealing with response headers.</p>\n\n<p>[1]<a href=\"http://www.w3.org/Protocols/rfc2616/rfc2616-sec4.html#sec4.2\"><span class=\"caps\">RFC</span> 2616: <span class=\"caps\">HTTP</span> Message Headers</a></p>","!type":"fn(vLabel: string) -> string"},"getResponseHeaders":{"!doc":"<p>Provides a hash of all response headers.</p>","!type":"fn() -> Object"},"getResponseText":{"!doc":"<p>Provides the response text from the request when available and null\notherwise.  By passing true as the &#8220;partial&#8221; parameter of this method,\nincomplete data will be made available to the caller.</p>","!type":"fn() -> string"},"getResponseXml":{"!doc":"<p>Provides the <span class=\"caps\">XML</span> provided by the response if any and null otherwise.  By\npassing true as the &#8220;partial&#8221; parameter of this method, incomplete data will\nbe made available to the caller.</p>","!type":"fn() -> string"},"getStatusCode":{"!doc":"<p>Returns the current status code of the request if available or -1 if not.</p>","!type":"fn() -> +Integer"},"getStatusText":{"!doc":"<p>Provides the status text for the current request if available and null\notherwise.</p>","!type":"fn() -> string"},"getStringResponseHeaders":{"!doc":"<p>Returns all response headers of the request.</p>","!type":"fn() -> Object"},"initParseJson":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>parseJson</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #parseJson}.</p>","!type":"fn(value: Object) -> Object"},"isParseJson":{"!doc":"<p>Check whether the (computed) value of the boolean property <code>parseJson</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #parseJson}.</p>","!type":"fn() -> bool"},"resetParseJson":{"!doc":"<p>Resets the user value of the property <code>parseJson</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #parseJson}.</p>","!type":"fn()"},"send":{"!doc":"<p>Implementation for sending the request</p>","!type":"fn()"},"setParseJson":{"!doc":"<p>Sets the user value of the property <code>parseJson</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #parseJson}.</p>","!type":"fn(value: Object) -> Object"},"setRequestHeader":{"!doc":"<p>Set a request header to this transports request.</p>","!type":"fn(vLabel: string, vValue: Object)"},"toggleParseJson":{"!doc":"<p>Toggles the (computed) value of the boolean property <code>parseJson</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #parseJson}.</p>","!type":"fn() -> bool"}}}}},"request":{"AbstractRequest":{"!proto":"qx.core.Object","!doc":"<p>AbstractRequest serves as a base class for {@link qx.io.request.Xhr}\nand {@link qx.io.request.Jsonp}. It contains methods to conveniently\ncommunicate with transports found in {@link qx.bom.request}.</p>\n\n<p>The general procedure to derive a new request is to choose a\ntransport (override {@link #_createTransport}) and link\nthe transport&#8217;s response (override {@link #_getParsedResponse}).\nThe transport must implement {@link qx.bom.request.IRequest}.</p>\n\n<p>To adjust the behavior of {@link #send} override\n{@link #_getConfiguredUrl} and {@link #_getConfiguredRequestHeaders}.</p>","!type":"fn()","prototype":{"__getAuthRequestHeaders":{"!doc":"<p>Retrieve authentication headers from auth delegate.</p>","!type":"fn() -> +Map"},"__onReadyStateDone":{"!doc":"<p>Called internally when readyState is <span class=\"caps\">DONE</span>.</p>","!type":"fn()"},"_createTransport":{"!doc":"<p>Create and return transport.</p>\n\n<p>This method <span class=\"caps\">MUST</span> be overridden, unless the constructor is overridden as\nwell. It is called by the constructor and should return the transport that\nis to be interfaced.</p>","!type":"fn() -> +qx.bom.request"},"_fireStatefulEvent":{"!doc":"<p>Fire stateful event.</p>\n\n<p>Fires event and sets phase to name of event.</p>","!type":"fn(evt: string)"},"_getAllRequestHeaders":{"!doc":"<p>Get all request headers.</p>","!type":"fn() -> +Map"},"_getConfiguredRequestHeaders":{"!doc":"<p>Get configuration related request headers.</p>\n\n<p>This method <span class=\"caps\">MAY</span> be overridden to add request headers for features limited\nto a certain transport.</p>","!type":"fn() -> +Map"},"_getConfiguredUrl":{"!doc":"<p>Get configured <span class=\"caps\">URL</span>.</p>\n\n<p>A configured <span class=\"caps\">URL</span> typically includes a query string that\nencapsulates transport specific settings such as request\ndata or no-cache settings.</p>\n\n<p>This method <span class=\"caps\">MAY</span> be overridden. It is called in {@link #send}\nbefore the request is initialized.</p>","!type":"fn() -> string"},"_getMethod":{"!doc":"<p>Get method.</p>\n\n<p>This method <span class=\"caps\">MAY</span> be overridden. It is called in {@link #send}\nbefore the request is initialized.</p>","!type":"fn() -> string"},"_getParsedResponse":{"!doc":"<p>Get parsed response.</p>\n\n<p>Is called in the {@link #_onReadyStateChange} event handler\nto parse and store the transport&#8217;s response.</p>\n\n<p>This method <span class=\"caps\">MUST</span> be overridden.</p>","!type":"fn() -> string"},"_isAsync":{"!doc":"<p>Whether async.</p>\n\n<p>This method <span class=\"caps\">MAY</span> be overridden. It is called in {@link #send}\nbefore the request is initialized.</p>","!type":"fn() -> bool"},"_onAbort":{"!doc":"<p>Handle &#8220;abort&#8221; event.</p>","!type":"fn()"},"_onError":{"!doc":"<p>Handle &#8220;error&#8221; event.</p>","!type":"fn()"},"_onLoad":{"!doc":"<p>Handle &#8220;load&#8221; event.</p>","!type":"fn()"},"_onLoadEnd":{"!doc":"<p>Handle &#8220;loadEnd&#8221; event.</p>","!type":"fn()"},"_onReadyStateChange":{"!doc":"<p>Handle &#8220;readyStateChange&#8221; event.</p>","!type":"fn()"},"_onTimeout":{"!doc":"<p>Handle &#8220;timeout&#8221; event.</p>","!type":"fn()"},"_serializeData":{"!doc":"<p>Serialize data.</p>","!type":"fn(data: string) -> string"},"_setPhase":{"!doc":"<p>Set phase.</p>","!type":"fn(phase: string)"},"_setRequestHeaders":{"!doc":"<p>Apply configured request headers to transport.</p>\n\n<p>This method <span class=\"caps\">MAY</span> be overridden to customize application of request headers\nto transport.</p>","!type":"fn()"},"_setResponse":{"!doc":"<p>Set response.</p>","!type":"fn(response: string)"},"abort":{"!doc":"<p>Abort request.</p>","!type":"fn()"},"getAllResponseHeaders":{"!doc":"<p>Get all response headers from response.</p>","!type":"fn() -> string"},"getAuthentication":{"!doc":"<p>Returns the (computed) value of the property <code>authentication</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #authentication}.</p>","!type":"fn() -> Object"},"getPhase":{"!doc":"<p>Get current phase.</p>\n\n<p>A more elaborate version of {@link #getReadyState}, this method indicates\nthe current phase of the request. Maps to stateful (i.e. deterministic)\nevents (success, abort, timeout, statusError) and intermediate\nreadyStates (unsent, configured, loading, load).</p>\n\n<p>When the requests is successful, it progresses the states:</p>\n\n<p>&#8216;unsent&#8217;, &#8216;opened&#8217;, &#8216;sent&#8217;, &#8216;loading&#8217;, &#8216;load&#8217;, &#8216;success&#8217;</p>\n\n<p>In case of failure, the final state is one of:</p>\n\n<p>&#8216;abort&#8217;, &#8216;timeout&#8217;, &#8216;statusError&#8217;</p>\n\n<p>For each change of the phase, a {@link #changePhase} data event is fired.</p>","!type":"fn() -> string"},"getReadyState":{"!doc":"<p>Get current ready state.</p>\n\n<p>States can be:\n<span class=\"caps\">UNSENT</span>:           0,\n<span class=\"caps\">OPENED</span>:           1,\nHEADERS_RECEIVED: 2,\n<span class=\"caps\">LOADING</span>:          3,\n<span class=\"caps\">DONE</span>:             4</p>","!type":"fn() -> number"},"getRequestData":{"!doc":"<p>Returns the (computed) value of the property <code>requestData</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #requestData}.</p>","!type":"fn() -> Object"},"getRequestHeader":{"!doc":"<p>Get a request header.</p>","!type":"fn(key: string) -> string"},"getResponse":{"!doc":"<p>Get parsed response.</p>","!type":"fn() -> string"},"getResponseContentType":{"!doc":"<p>Get the content type response header from response.</p>","!type":"fn() -> string"},"getResponseHeader":{"!doc":"<p>Get a single response header from response.</p>","!type":"fn(key: string) -> string"},"getResponseText":{"!doc":"<p>Get raw (unprocessed) response.</p>","!type":"fn() -> string"},"getStatus":{"!doc":"<p>Get status code.</p>","!type":"fn() -> number"},"getStatusText":{"!doc":"<p>Get status text.</p>","!type":"fn() -> string"},"getTimeout":{"!doc":"<p>Returns the (computed) value of the property <code>timeout</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #timeout}.</p>","!type":"fn() -> Object"},"getTransport":{"!doc":"<p>Get low-level transport.</p>\n\n<p>Note: To be used with caution!</p>\n\n<p>This method can be used to query the transport directly,\nbut should be used with caution. Especially, it\nis not advisable to call any destructive methods\nsuch as <code>open</code> or <code>send</code>.</p>","!type":"fn() -> Object"},"getUrl":{"!doc":"<p>Returns the (computed) value of the property <code>url</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #url}.</p>","!type":"fn() -> Object"},"initAuthentication":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>authentication</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #authentication}.</p>","!type":"fn(value: Object) -> Object"},"initRequestData":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>requestData</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #requestData}.</p>","!type":"fn(value: Object) -> Object"},"initTimeout":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>timeout</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #timeout}.</p>","!type":"fn(value: Object) -> Object"},"initUrl":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>url</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #url}.</p>","!type":"fn(value: Object) -> Object"},"isDone":{"!doc":"<p>Whether request completed (is done).</p>","!type":"fn()"},"overrideResponseContentType":{"!doc":"<p>Override the content type response header from response.</p>","!type":"fn(contentType: string)"},"removeRequestHeader":{"!doc":"<p>Remove a request header.</p>\n\n<p>Note: Removing request headers has no effect after the request was send.</p>","!type":"fn(key: string)"},"resetAuthentication":{"!doc":"<p>Resets the user value of the property <code>authentication</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #authentication}.</p>","!type":"fn()"},"resetRequestData":{"!doc":"<p>Resets the user value of the property <code>requestData</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #requestData}.</p>","!type":"fn()"},"resetTimeout":{"!doc":"<p>Resets the user value of the property <code>timeout</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #timeout}.</p>","!type":"fn()"},"resetUrl":{"!doc":"<p>Resets the user value of the property <code>url</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #url}.</p>","!type":"fn()"},"send":{"!doc":"<p>Send request.</p>","!type":"fn()"},"setAuthentication":{"!doc":"<p>Sets the user value of the property <code>authentication</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #authentication}.</p>","!type":"fn(value: Object) -> Object"},"setRequestData":{"!doc":"<p>Sets the user value of the property <code>requestData</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #requestData}.</p>","!type":"fn(value: Object) -> Object"},"setRequestHeader":{"!doc":"<p>Set a request header.</p>\n\n<p>Note: Setting request headers has no effect after the request was send.</p>","!type":"fn(key: string, value: string)"},"setTimeout":{"!doc":"<p>Sets the user value of the property <code>timeout</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #timeout}.</p>","!type":"fn(value: Object) -> Object"},"setUrl":{"!doc":"<p>Sets the user value of the property <code>url</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #url}.</p>","!type":"fn(value: Object) -> Object"}}},"authentication":{"Basic":{"!proto":"qx.core.Object","!doc":"<p>Basic authentication.</p>","!type":"fn()","prototype":{"getAuthHeaders":{"!doc":"<p>Headers to include for basic authentication.</p>","!type":"fn() -> +Map"}}},"IAuthentication":{"!doc":"<p>Interface of an authentication delegate.</p>","prototype":{"getAuthHeaders":{"!doc":"<p>Headers to include in request for authentication purposes.</p>","!type":"fn() -> +Map"}}}},"Jsonp":{"!proto":"qx.io.request.AbstractRequest","!doc":"<p>Query <span class=\"caps\">JSONP</span> services using the script element. Requests may be cross-origin.</p>\n\n<p>Configuration of the request is done with properties. Events are fired for\nvarious states in the life cycle of a request, such as &#8220;success&#8221;. Request\ndata is transparently processed.</p>\n\n<p>For an introduction to <span class=\"caps\">JSONP</span>, please refer to\n<a href=\"http://ajaxian.com/archives/jsonp-json-with-padding\">Ajaxian.com</a>.</p>\n\n<p>Here is how to request a <span class=\"caps\">JSON</span> file from a <span class=\"caps\">REST</span> service and listen to\nthe &#8220;success&#8221; event:</p>\n\n<pre class=\"javascript\">\nvar req = new qx.io.request.Jsonp();\nreq.setUrl(\"http://feeds.delicious.com/v2/json/popular\");\n\n// Some services have a fixed callback name\n// req.setCallbackName(\"callback\");\n\nreq.addListener(\"success\", function(e) {\n  var req = e.getTarget();\n\n  // HTTP status code indicating success, e.g. 200\n  req.getStatus();\n\n  // \"success\"\n  req.getPhase();\n\n  // JSON response\n  req.getResponse();\n}, this);\n\n// Send request\nreq.send();\n</pre>\n\n<p>Some noteable features:</p>\n\n<ul>\n<li>Abstraction of low-level request</li>\n<li>Convenient setup using properties</li>\n<li>Fine-grained events</li>\n<li>Symbolic phases</li>\n<li>Transparent processing of request data</li>\n<li>Stream-lined authentication</li>\n<li>Flexible callback handling</li>\n<li>Cross-origin requests</li>\n</ul>\n\n<p>In order to debug requests, set the environment flag\n<code>qx.debug.io</code>.</p>\n\n<p>Internally uses {@link qx.bom.request.Jsonp}.</p>","prototype":{"_createTransport":{"!doc":"<p>Create <span class=\"caps\">JSONP</span> transport.</p>","!type":"fn() -> +qx.bom.request.Jsonp"},"_getConfiguredUrl":{"!doc":"<p>Get configured <span class=\"caps\">URL</span>.</p>\n\n<p>Append request data to <span class=\"caps\">URL</span>. Also append random string\nto <span class=\"caps\">URL</span> if required by value of {@link #cache}.</p>","!type":"fn() -> string"},"_getParsedResponse":{"!doc":"<p>Return the transport&#8217;s responseJson property.</p>\n\n<p>See {@link qx.bom.request.Jsonp}.</p>","!type":"fn() -> Object"},"getCache":{"!doc":"<p>Returns the (computed) value of the property <code>cache</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #cache}.</p>","!type":"fn() -> Object"},"initCache":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>cache</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #cache}.</p>","!type":"fn(value: Object) -> Object"},"isCache":{"!doc":"<p>Check whether the (computed) value of the boolean property <code>cache</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #cache}.</p>","!type":"fn() -> bool"},"resetCache":{"!doc":"<p>Resets the user value of the property <code>cache</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #cache}.</p>","!type":"fn()"},"setCache":{"!doc":"<p>Sets the user value of the property <code>cache</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #cache}.</p>","!type":"fn(value: Object) -> Object"},"setCallbackName":{"!doc":"<p>Set callback name.</p>\n\n<p>See {@link qx.bom.request.Jsonp#setCallbackName}.</p>","!type":"fn(name: string)"},"setCallbackParam":{"!doc":"<p>Set callback parameter.</p>\n\n<p>See {@link qx.bom.request.Jsonp#setCallbackParam}.</p>","!type":"fn(param: string)"},"toggleCache":{"!doc":"<p>Toggles the (computed) value of the boolean property <code>cache</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #cache}.</p>","!type":"fn() -> bool"}}},"Xhr":{"!proto":"qx.io.request.AbstractRequest","!doc":"<p>Send <span class=\"caps\">HTTP</span> requests and handle responses using the <span class=\"caps\">HTTP</span> client <span class=\"caps\">API</span>.</p>\n\n<p>Configuration of the request is done with properties. Events are fired for\nvarious states in the life cycle of a request, such as &#8220;success&#8221;. Request\ndata is transparently processed.</p>\n\n<p>Here is how to request a <span class=\"caps\">JSON</span> file and listen to the &#8220;success&#8221; event:</p>\n\n<pre class=\"javascript\">\nvar req = new qx.io.request.Xhr(\"/some/path/file.json\");\n\nreq.addListener(\"success\", function(e) {\n  var req = e.getTarget();\n\n  // Response parsed according to the server's\n  // response content type, e.g. JSON\n  req.getResponse();\n}, this);\n\n// Send request\nreq.send();\n</pre>\n\n<p>Some noteable features:</p>\n\n<ul>\n<li>Abstraction of low-level request</li>\n<li>Convenient setup using properties</li>\n<li>Fine-grained events</li>\n<li>Symbolic phases</li>\n<li>Transparent processing of request data</li>\n<li>Stream-lined authentication</li>\n<li>Automagic parsing of response based on content type</li>\n</ul>\n\n<p>Cross-origin requests are supported, but require browser support\n(see <a href=\"http://caniuse.com/#search=CORS\">caniuse.com</a>) and backend configuration\n(see <a href=\"https://developer.mozilla.org/en-US/docs/docs/HTTP/Access_control_CORS><span class=\"><span class=\"caps\">MDN</span></a>).\nNote that IE&#8217;s <code>XDomainRequest</code> is not currently supported.\nFor a cross-browser alternative, consider {@link qx.io.request.Jsonp}.</p>\n\n<p>In order to debug requests, set the environment flag\n<code>qx.debug.io</code>.</p>\n\n<p>Internally uses {@link qx.bom.request.Xhr}.</p>","!type":"fn()","prototype":{"_createResponseParser":{"!doc":"<p>Create response parser.</p>","!type":"fn() -> +qx.util.ResponseParser"},"_createTransport":{"!doc":"<p>Create <span class=\"caps\">XHR</span> transport.</p>","!type":"fn() -> +qx.bom.request.Xhr"},"_getConfiguredRequestHeaders":{"!type":"fn()"},"_getConfiguredUrl":{"!doc":"<p>Get configured <span class=\"caps\">URL</span>.</p>\n\n<p>Append request data to <span class=\"caps\">URL</span> if <span class=\"caps\">HTTP</span> method is <span class=\"caps\">GET</span>. Append random\nstring to <span class=\"caps\">URL</span> if required by value of {@link #cache}.</p>","!type":"fn() -> string"},"_getMethod":{"!type":"fn()"},"_getParsedResponse":{"!doc":"<p>Returns response parsed with parser determined by content type.</p>","!type":"fn() -> string"},"_isAsync":{"!type":"fn()"},"getAccept":{"!doc":"<p>Returns the (computed) value of the property <code>accept</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #accept}.</p>","!type":"fn() -> Object"},"getAsync":{"!doc":"<p>Returns the (computed) value of the property <code>async</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #async}.</p>","!type":"fn() -> Object"},"getCache":{"!doc":"<p>Returns the (computed) value of the property <code>cache</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #cache}.</p>","!type":"fn() -> Object"},"getMethod":{"!doc":"<p>Returns the (computed) value of the property <code>method</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #method}.</p>","!type":"fn() -> Object"},"initAccept":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>accept</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #accept}.</p>","!type":"fn(value: Object) -> Object"},"initAsync":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>async</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #async}.</p>","!type":"fn(value: Object) -> Object"},"initCache":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>cache</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #cache}.</p>","!type":"fn(value: Object) -> Object"},"initMethod":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>method</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #method}.</p>","!type":"fn(value: Object) -> Object"},"isAsync":{"!doc":"<p>Check whether the (computed) value of the boolean property <code>async</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #async}.</p>","!type":"fn() -> bool"},"resetAccept":{"!doc":"<p>Resets the user value of the property <code>accept</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #accept}.</p>","!type":"fn()"},"resetAsync":{"!doc":"<p>Resets the user value of the property <code>async</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #async}.</p>","!type":"fn()"},"resetCache":{"!doc":"<p>Resets the user value of the property <code>cache</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #cache}.</p>","!type":"fn()"},"resetMethod":{"!doc":"<p>Resets the user value of the property <code>method</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #method}.</p>","!type":"fn()"},"setAccept":{"!doc":"<p>Sets the user value of the property <code>accept</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #accept}.</p>","!type":"fn(value: Object) -> Object"},"setAsync":{"!doc":"<p>Sets the user value of the property <code>async</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #async}.</p>","!type":"fn(value: Object) -> Object"},"setCache":{"!doc":"<p>Sets the user value of the property <code>cache</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #cache}.</p>","!type":"fn(value: Object) -> Object"},"setMethod":{"!doc":"<p>Sets the user value of the property <code>method</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #method}.</p>","!type":"fn(value: Object) -> Object"},"setParser":{"!doc":"<p>Set parser used to parse response once request has\ncompleted successfully.</p>","!type":"fn(parser: string) -> fn()"},"toggleAsync":{"!doc":"<p>Toggles the (computed) value of the boolean property <code>async</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #async}.</p>","!type":"fn() -> bool"}}}},"rest":{"Resource":{"!proto":"qx.core.Object","!doc":"<p>Client-side wrapper of a <span class=\"caps\">REST</span> resource.</p>\n\n<p>Each instance represents a resource in terms of <span class=\"caps\">REST</span>. A number of actions\n(usually <span class=\"caps\">HTTP</span> methods) unique to the resource can be defined and invoked.\nA resource with its actions is configured declaratively by passing a resource\ndescription to the constructor, or programatically using {@link #map}.</p>\n\n<p>Each action is associated to a route. A route is a combination of method,\n<span class=\"caps\">URL</span> pattern and optional parameter constraints.</p>\n\n<p>An action is invoked by calling a method with the same name. When a <span class=\"caps\">URL</span>\npattern of a route contains positional parameters, those parameters must be\npassed when invoking the associated action. Also, constraints defined in the\nroute must be satisfied.</p>\n\n<p>When an action is invoked, a request is configured according to the associated\nroute, is passed the <span class=\"caps\">URL</span> parameters, request body data, and finally send.\nWhat kind of request is send can be configured by overwriting {@link #_getRequest}.</p>\n\n<p>No contraints on the action&#8217;s name or the scope of the URLs are imposed. However,\nif you want to follow RESTful design patterns it is recommended to name actions\nthe same as the <span class=\"caps\">HTTP</span> action.</p>\n\n<pre class=\"javascript\">\nvar description = {\n \"get\": { method: \"GET\", url: \"/photo/{id}\" },\n \"put\": { method: \"PUT\", url: \"/photo/{id}\"},\n \"post\": { method: \"POST\", url: \"/photos/\"}\n};\nvar photo = new qx.io.rest.Resource(description);\n// Can also be written: photo.invoke(\"get\", {id: 1});\nphoto.get({id: 1});\n\n// Additionally sets request data (provide it as string or set the content type)\n// In a RESTful environment this creates a new resource with the given 'id'\nphoto.configureRequest(function(req) {\n req.setRequestHeader(\"Content-Type\", \"application/json\");\n});\nphoto.put({id: 1}, {title: \"Monkey\"});\n\n// Additionally sets request data (provide it as string or set the content type)\n// In a RESTful environment this adds a new resource to the resource collection 'photos'\nphoto.configureRequest(function(req) {\n req.setRequestHeader(\"Content-Type\", \"application/json\");\n});\nphoto.post(null, {title: \"Monkey\"});\n</pre>\n\n<p>To check for existence of <span class=\"caps\">URL</span> parameters or constrain them to a certain format, you\ncan add a <code>check</code> property to the description. See {@link #map} for details.</p>\n\n<pre class=\"javascript\">\nvar description = {\n \"get\": { method: \"GET\", url: \"/photo/{id}\", check: { id: /\\d+/ } }\n};\nvar photo = new qx.io.rest.Resource(description);\n// photo.get({id: \"FAIL\"});\n// -- Error: \"Parameter 'id' is invalid\"\n</pre>\n\n<p>If your description happens to use the same action more than once, consider\ndefining another resource.</p>\n\n<pre class=\"javascript\">\nvar description = {\n \"get\": { method: \"GET\", url: \"/photos\"},\n};\n// Distinguish \"photo\" (singular) and \"photos\" (plural) resource\nvar photos = new qx.io.rest.Resource(description);\nphotos.get();\n</pre>\n\n<p>Basically, all routes of a resource should point to the same <span class=\"caps\">URL</span> (resource in\nterms of <span class=\"caps\">HTTP</span>). One acceptable exception of this constraint are resources where\nrequired parameters are part of the <span class=\"caps\">URL</span> (<code>/photos/1/</code>) or filter\nresources. For instance:</p>\n\n<pre class=\"javascript\">\nvar description = {\n \"get\": { method: \"GET\", url: \"/photos/{tag}\" }\n};\nvar photos = new qx.io.rest.Resource(description);\nphotos.get();\nphotos.get({tag: \"wildlife\"})\n</pre>\n\n<p>Strictly speaking, the <code>photos</code> instance represents two distinct resources\nand could therefore just as well mapped to two distinct resources (for instance,\nnamed photos and photosTagged). What style to choose depends on the kind of data\nreturned. For instance, it seems sensible to stick with one resource if the filter\nonly limits the result set (i.e. the invidual results have the same properties).</p>\n\n<p>In order to respond to successful (or erroneous) invocations of actions,\neither listen to the generic &#8220;success&#8221; or &#8220;error&#8221; event and get the action\nfrom the event data, or listen to action specific events defined at runtime.\nAction specific events follow the pattern &#8221;&lt;action&gt;Success&#8221; and\n&#8221;&lt;action&gt;Error&#8221;, e.g. &#8220;indexSuccess&#8221;.</p>","!type":"fn()","placeholdersFromUrl":{"!doc":"<p>Get placeholders from <span class=\"caps\">URL</span>.</p>","!type":"fn(url: string) -> +Array"},"prototype":{"__addAction":{"!doc":"<p>Map actions to members.</p>","!type":"fn(action: string, method: string, url: string, check?: +Map)"},"__declareEvent":{"!doc":"<p>Declare event at runtime.</p>","!type":"fn(type: string)"},"__mapFromDescription":{"!doc":"<p>Map actions from description.</p>\n\n<p>Allows to decoratively define routes.</p>","!type":"fn(description: +Map)"},"_getRequest":{"!doc":"<p>Get request.</p>\n\n<p>May be overriden to change type of request.</p>","!type":"fn() -> +qx.io.request.Xhr"},"_getRequestConfig":{"!doc":"<p>Get request configuration for action and parameters.</p>\n\n<p>This is were placeholders are replaced with parameters.</p>","!type":"fn(action: string, params: +Map) -> +Map"},"_getResource":{"!doc":"<p>Get resource.</p>\n\n<p>May be overriden to change type of resource.</p>","!type":"fn(description?: +Map) -> +qx.bom.rest.Resource"},"_getThrottleCount":{"!doc":"<p>Override to adjust the throttle count.</p>","!type":"fn() -> +Integer"},"_getThrottleLimit":{"!doc":"<p>Override to adjust the throttle limit.</p>","!type":"fn() -> +Integer"},"_tailorResource":{"!doc":"<p>Tailors (apply dependency injection) the given resource to fit our needs.</p>","!type":"fn(resource: +qx.bom.rest.Resource) -> +qx.bom.rest.Resource"},"abort":{"!doc":"<p>Abort action.</p>\n\n<p>Example:</p>\n\n<pre class=\"javascript\">\n  // Abort all invocations of action\n  res.get({id: 1});\n  res.get({id: 2});\n  res.abort(\"get\");\n\n  // Abort specific invocation of action (by id)\n  var actionId = res.get({id: 1});\n  res.abort(actionId);\n</pre>","!type":"fn(varargs: string)"},"configureRequest":{"!doc":"<p>Configure request.</p>","!type":"fn(callback: fn())"},"invoke":{"!doc":"<p>Invoke action with parameters.</p>\n\n<p>Internally called by actions dynamically created.</p>\n\n<p>May be overriden to customize action and parameter handling.</p>","!type":"fn(action: string, params: +Map, data: +Map) -> number"},"longPoll":{"!doc":"<p>Long-poll action.</p>\n\n<p>Use Ajax long-polling to continously fetch a resource as soon as the\nserver signals new data. The server determines when new data is available,\nwhile the client keeps open a request. Requires configuration on the\nserver side. Basically, the server must not close a connection until\nnew data is available. For a high level introduction to long-polling,\nrefer to <a href=\"http://en.wikipedia.org/wiki/Comet_(programming)#Ajax_with_long_polling\">\nAjax with long polling</a>.</p>\n\n<p>Uses {@link #refresh} internally. Make sure you understand the\nimplications of IE&#8217;s tendency to cache overly agressive.</p>\n\n<p>Note no interval is given on the client side.</p>","!type":"fn(action: string) -> string"},"map":{"!doc":"<p>Map action to combination of method and <span class=\"caps\">URL</span> pattern.</p>\n\n<pre class=\"javascript\">\n  res.map(\"get\", \"GET\", \"/photos/{id}\", {id: /\\d+/});\n\n  // GET /photos/123\n  res.get({id: \"123\"});\n</pre>","!type":"fn(action: string, method: string, url: string, check?: +Map)"},"poll":{"!doc":"<p>Periodically invoke action.</p>\n\n<p>Replays parameters given when action was invoked originally. When the\naction was not yet invoked and requires parameters, parameters must be\ngiven.</p>\n\n<p>Please note that IE tends to cache overly agressive. One work-around is\nto disable caching on the client side by configuring the request with\n<code>setCache(false)</code>. If you control the server, a better\nwork-around is to include appropriate headers to explicitly control\ncaching. This way you still avoid requests that can be correctly answered\nfrom cache (e.g. when nothing has changed since the last poll). Please\nrefer to <a href=\"http://www.mnot.net/javascript/xmlhttprequest/cache.html\">\nXMLHttpRequest Caching Test</a> for available options.</p>","!type":"fn(action: string, interval: number, params?: +Map, immediately?: bool) -> +qx.event.Timer"},"refresh":{"!doc":"<p>Resend request associated to action.</p>\n\n<p>Replays parameters given when action was invoked originally.</p>","!type":"fn(action: string)"},"setBaseUrl":{"!doc":"<p>Set base <span class=\"caps\">URL</span>.</p>\n\n<p>The base <span class=\"caps\">URL</span> is prepended to the URLs given in the description.\nChanges affect all future invocations.</p>","!type":"fn(baseUrl: string)"}}}}},"lang":{"Array":{"!doc":"<p>Static helper functions for arrays with a lot of often used convenience\nmethods like <code>remove</code> or <code>contains</code>.</p>\n\n<p>The native JavaScript Array is not modified by this class. However,\nthere are modifications to the native Array in {@link qx.lang.normalize.Array} for\nbrowsers that do not support certain JavaScript features natively .</p>","append":{"!doc":"<p>Append the elements of an array to the array</p>","!type":"fn(arr1: +Array, arr2: +Array) -> +Array"},"cast":{"!doc":"<p>Converts an array like object to any other array like\nobject.</p>\n\n<p>Attention: The returned array may be same\ninstance as the incoming one if the constructor is identical!</p>","!type":"fn(object: Object, constructor: fn(), offset?: +Integer) -> +Array"},"clone":{"!doc":"<p>Return a copy of the given array</p>","!type":"fn(arr: +Array) -> +Array"},"contains":{"!doc":"<p>Whether the array contains the given element</p>","!type":"fn(arr: +Array, obj: Object) -> bool"},"equals":{"!doc":"<p>Check whether the two arrays have the same content. Checks only the\nequality of the arrays&#8217; content.</p>","!type":"fn(arr1: +Array, arr2: +Array) -> bool"},"exclude":{"!doc":"<p>Modifies the first array as it removes all elements\nwhich are listed in the second array as well.</p>","!type":"fn(arr1: +Array, arr2: +Array) -> +Array"},"fromArguments":{"!doc":"<p>Convert an arguments object into an array.</p>","!type":"fn(args: +arguments, offset?: +Integer) -> +Array"},"fromCollection":{"!doc":"<p>Convert a (node) collection into an array</p>","!type":"fn(coll: Object) -> +Array"},"fromShortHand":{"!doc":"<p>Expand shorthand definition to a four element list.\nThis is an utility function for padding/margin and all other shorthand handling.</p>","!type":"fn(input: +Array) -> +Array"},"insertAfter":{"!doc":"<p>Insert an element into the array after a given second element.</p>","!type":"fn(arr: +Array, obj: Object, obj2: Object) -> +Array"},"insertAt":{"!doc":"<p>Insert an element at a given position into the array</p>","!type":"fn(arr: +Array, obj: Object, i: +Integer) -> +Array"},"insertBefore":{"!doc":"<p>Insert an element into the array before a given second element.</p>","!type":"fn(arr: +Array, obj: Object, obj2: Object) -> +Array"},"max":{"!doc":"<p>Returns the highest value in the given array. Supports\nnumeric values only.</p>","!type":"fn(arr: number) -> number"},"min":{"!doc":"<p>Returns the lowest value in the given array. Supports\nnumeric values only.</p>","!type":"fn(arr: number) -> number"},"remove":{"!doc":"<p>Remove an element from the array.</p>","!type":"fn(arr: +Array, obj: Object) -> Object"},"removeAll":{"!doc":"<p>Remove all elements from the array</p>","!type":"fn(arr: +Array) -> +Array"},"removeAt":{"!doc":"<p>Remove an element from the array at the given index</p>","!type":"fn(arr: +Array, i: +Integer) -> Object"},"sum":{"!doc":"<p>Returns the sum of all values in the given array. Supports\nnumeric values only.</p>","!type":"fn(arr: number) -> number"},"unique":{"!doc":"<p>Recreates an array which is free of all duplicate elements from the original.</p>\n\n<p>This method does not modify the original array!</p>\n\n<p>Keep in mind that this methods deletes undefined indexes.</p>","!type":"fn(arr: +Array) -> +Array"}},"Function":{"!doc":"<p>Collection of helper methods operating on functions.</p>","attempt":{"!doc":"<p>Tries to execute the function.</p>\n\n<p><strong>Syntax</strong></p>\n\n<pre class=\"javascript\">var result = qx.lang.Function.attempt(myFunction, [self, [varargs...]]);</pre>\n\n<p><strong>Example</strong></p>\n\n<pre class=\"javascript\">\nvar myObject = {\n  'cow': 'moo!'\n};\n\nvar myFunction = function()\n{\n  for(var i = 0; i < arguments.length; i++) {\n    if(!this[arguments[i]]) throw('doh!');\n  }\n};\n\nvar result = qx.lang.Function.attempt(myFunction, myObject, 'pig', 'cow'); // false\n</pre>","!type":"fn(func: fn(), self?: Object, varargs?: +arguments) -> bool"},"bind":{"!doc":"<p>Returns a function whose &#8220;this&#8221; is altered.</p>\n\n<p><strong>Native way</strong></p>\n\n<p>This is also a feature of JavaScript 1.8.5 and will be supplied\nby modern browsers. Including {@link qx.lang.normalize.Function}\nwill supply a cross browser normalization of the native\nimplementation. We like to encourage you to use the native function!</p>\n\n<p><strong>Syntax</strong></p>\n\n<pre class=\"javascript\">qx.lang.Function.bind(myFunction, [self, [varargs...]]);</pre>\n\n<p><strong>Example</strong></p>\n\n<pre class=\"javascript\">\nfunction myFunction()\n{\n  this.setStyle('color', 'red');\n  // note that 'this' here refers to myFunction, not an element\n  // we'll need to bind this function to the element we want to alter\n};\n\nvar myBoundFunction = qx.lang.Function.bind(myFunction, myElement);\nmyBoundFunction(); // this will make the element myElement red.\n</pre>\n\n<p>If you find yourself using this static method a lot, you may be\ninterested in the bindTo() method in the mixin qx.core.MBindTo.</p>","!type":"fn(func: fn(), self?: Object, varargs?: +arguments) -> fn()"},"create":{"!doc":"<p>Base function for creating functional closures which is used by most other methods here.</p>\n\n<p><strong>Syntax</strong></p>\n\n<pre class=\"javascript\">var createdFunction = qx.lang.Function.create(myFunction, [options]);</pre>","!type":"fn(func: fn(), options?: +Map) -> fn()"},"curry":{"!doc":"<p>Returns a function whose arguments are pre-configured.</p>\n\n<p><strong>Syntax</strong></p>\n\n<pre class=\"javascript\">qx.lang.Function.curry(myFunction, [varargs...]);</pre>\n\n<p><strong>Example</strong></p>\n\n<pre class=\"javascript\">\nfunction myFunction(elem) {\n  elem.setStyle('color', 'red');\n};\n\nvar myBoundFunction = qx.lang.Function.curry(myFunction, myElement);\nmyBoundFunction(); // this will make the element myElement red.\n</pre>","!type":"fn(func: fn(), varargs: +arguments) -> Object"},"delay":{"!doc":"<p>Delays the execution of a function by a specified duration.</p>\n\n<p><strong>Syntax</strong></p>\n\n<pre class=\"javascript\">var timeoutID = qx.lang.Function.delay(myFunction, [delay, [self, [varargs...]]]);</pre>\n\n<p><strong>Example</strong></p>\n\n<pre class=\"javascript\">\nvar myFunction = function(){ alert('moo! Element id is: ' + this.id); };\n//wait 50 milliseconds, then call myFunction and bind myElement to it\nqx.lang.Function.delay(myFunction, 50, myElement); // alerts: 'moo! Element id is: ... '\n\n// An anonymous function, example\nqx.lang.Function.delay(function(){ alert('one second later...'); }, 1000); //wait a second and alert\n</pre>","!type":"fn(func: fn(), delay: +Integer, self?: Object, varargs?: +arguments) -> +Integer"},"getCaller":{"!doc":"<p>Extract the caller of a function from the arguments variable.\nThis will not work in Opera < 9.6.</p>","!type":"fn(args: +arguments) -> fn()"},"getName":{"!doc":"<p>Try to get a sensible textual description of a function object.\nThis may be the class/mixin and method name of a function\nor at least the signature of the function.</p>","!type":"fn(fcn: fn()) -> string"},"globalEval":{"!doc":"<p>Evaluates JavaScript code globally</p>","!type":"fn(data: string) -> Object"},"listener":{"!doc":"<p>Returns a function which could be used as a listener for a native event callback.</p>\n\n<p><strong>Syntax</strong></p>\n\n<pre class=\"javascript\">qx.lang.Function.listener(myFunction, [self, [varargs...]]);</pre>","!type":"fn(func: fn(), self?: Object, varargs?: +arguments) -> Object"},"periodical":{"!doc":"<p>Executes a function in the specified intervals of time</p>\n\n<p><strong>Syntax</strong></p>\n\n<pre class=\"javascript\">var intervalID = qx.lang.Function.periodical(myFunction, [period, [self, [varargs...]]]);</pre>\n\n<p><strong>Example</strong></p>\n\n<pre class=\"javascript\">\nvar Site = { counter: 0 };\nvar addCount = function(){ this.counter++; };\nqx.lang.Function.periodical(addCount, 1000, Site); // will add the number of seconds at the Site\n</pre>","!type":"fn(func: fn(), interval: +Integer, self?: Object, varargs?: +arguments) -> +Integer"}},"Json":{"!doc":"<p>Exposes (potentially polyfilled or patched) window.JSON to qooxdoo\n(enabled by <a href=\"https://github.com/bestiejs/json3\"><span class=\"caps\">JSON</span> 3</a>).</p>","parse":{"!doc":"<p>This method parses a <span class=\"caps\">JSON</span> text to produce an object or array.\nIt can throw a SyntaxError exception.</p>\n\n<p>The optional reviver parameter is a function that can filter and\ntransform the results. It receives each of the keys and values,\nand its return value is used instead of the original value.\nIf it returns what it received, then the structure is not modified.\nIf it returns undefined then the member is deleted.</p>\n\n<p>Example:</p>\n\n<pre class=\"javascript\">\n// Parse the text. Values that look like ISO date strings will\n// be converted to Date objects.\n\nmyData = JSON.parse(text, function (key, value)\n{\n  if (typeof value === 'string')\n  {\n    var a = /^(\\d{4})-(\\d{2})-(\\d{2})T(\\d{2}):(\\d{2}):(\\d{2}(?:\\.\\d*)?)Z$/.exec(value);\n    if (a) {\n      return new Date(Date.UTC(+a[1], +a[2] - 1, +a[3], +a[4], +a[5], +a[6]));\n    }\n  }\n  return value;\n});\n\nmyData = JSON.parse('[\"Date(09/09/2001)\"]', function (key, value) {\n    var d;\n    if (typeof value === 'string' &&\n            value.slice(0, 5) === 'Date(' &&\n            value.slice(-1) === ')') {\n        d = new Date(value.slice(5, -1));\n        if (d) {\n            return d;\n        }\n    }\n    return value;\n});\n</pre>","!type":"fn(text: string, reviver?: fn()) -> Object"},"stringify":{"!doc":"<p>This method produces a <span class=\"caps\">JSON</span> text from a JavaScript value.</p>\n\n<p>When an object value is found, if the object contains a toJSON\nmethod, its toJSON method will be called and the result will be\nstringified. A toJSON method does not serialize: it returns the\nvalue represented by the name/value pair that should be serialized,\nor undefined if nothing should be serialized. The toJSON method\nwill be passed the key associated with the value, and this will be\nbound to the object holding the key.</p>\n\n<p>For example, this would serialize Dates as <span class=\"caps\">ISO</span> strings.</p>\n\n<pre class=\"javascript\">\n    Date.prototype.toJSON = function (key) {\n        function f(n) {\n            // Format integers to have at least two digits.\n            return n < 10 ? '0' + n : n;\n        }\n\n        return this.getUTCFullYear()   + '-' +\n             f(this.getUTCMonth() + 1) + '-' +\n             f(this.getUTCDate())      + 'T' +\n             f(this.getUTCHours())     + ':' +\n             f(this.getUTCMinutes())   + ':' +\n             f(this.getUTCSeconds())   + 'Z';\n    };\n</pre>\n\n<p>You can provide an optional replacer method. It will be passed the\nkey and value of each member, with this bound to the containing\nobject. The value that is returned from your method will be\nserialized. If your method returns undefined, then the member will\nbe excluded from the serialization.</p>\n\n<p>If the replacer parameter is an array of strings, then it will be\nused to select the members to be serialized. It filters the results\nsuch that only members with keys listed in the replacer array are\nstringified.</p>\n\n<p>Values that do not have <span class=\"caps\">JSON</span> representations, such as undefined or\nfunctions, will not be serialized. Such values in objects will be\ndropped; in arrays they will be replaced with null. You can use\na replacer function to replace those with <span class=\"caps\">JSON</span> values.\n<span class=\"caps\">JSON</span>.stringify(undefined) returns undefined.</p>\n\n<p>The optional space parameter produces a stringification of the\nvalue that is filled with line breaks and indentation to make it\neasier to read.</p>\n\n<p>If the space parameter is a non-empty string, then that string will\nbe used for indentation. If the space parameter is a number, then\nthe indentation will be that many spaces.</p>\n\n<p>Example:</p>\n\n<pre class=\"javascript\">\ntext = JSON.stringify(['e', {pluribus: 'unum'}]);\n// text is '[\"e\",{\"pluribus\":\"unum\"}]'\n\ntext = JSON.stringify(['e', {pluribus: 'unum'}], null, '\\t');\n// text is '[\\n\\t\"e\",\\n\\t{\\n\\t\\t\"pluribus\": \"unum\"\\n\\t}\\n]'\n\ntext = JSON.stringify([new Date()], function (key, value) {\n    return this[key] instanceof Date ?\n        'Date(' + this[key] + ')' : value;\n});\n// text is '[\"Date(---current time---)\"]'\n</pre>","!type":"fn(value: Object, replacer?: fn(), space?: string) -> string"}},"normalize":{"Array":{"!doc":"<p>This class is responsible for the normalization of the native &#8216;Array&#8217; object.\nIt checks if these methods are available and, if not, appends them to\nensure compatibility in all browsers.\nFor usage samples, check out the attached links.</p>\n\n<p><span class=\"caps\">MDN</span> documentation &copy; Mozilla Contributors.</p>","every":{"!doc":"<p>The <code>every()</code> method tests whether all elements\nin the array pass the test implemented by the provided function.</p>\n\n<a href=\"https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/every\">MDN documentation</a> |\n<a href=\"http://es5.github.com/#x15.4.4.16\">Annotated ES5 Spec</a>","!type":"fn(callback: fn(), obj?: Object) -> +Array"},"filter":{"!doc":"<p>The <code>filter()</code> method creates a new array with\nall elements that pass the test implemented by the provided\nfunction.</p>\n\n<a href=\"https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/filter\">MDN documentation</a> |\n<a href=\"http://es5.github.com/#x15.4.4.20\">Annotated ES5 Spec</a>","!type":"fn(callback: fn(), obj?: Object) -> +Array"},"forEach":{"!doc":"<p>The <code>forEach()</code> method executes a provided function\nonce per array element. You can not break the loop with this function.\nIf you want to do so, use {@link #some} or {@link #every}.</p>\n\n<a href=\"https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/forEach\">MDN documentation</a> |\n<a href=\"http://es5.github.com/#x15.4.4.18\">Annotated ES5 Spec</a>","!type":"fn(callback: fn(), obj?: Object)"},"indexOf":{"!doc":"<p>The <code>indexOf()</code> method returns the first index at which a given\nelement can be found in the array, or -1 if it is not present.</p>\n\n<a href=\"https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/indexOf\">MDN documentation</a> |\n<a href=\"http://es5.github.com/#x15.4.4.14\">Annotated ES5 Spec</a>","!type":"fn(searchElement: Object, fromIndex?: +Integer) -> +Integer"},"lastIndexOf":{"!doc":"<p>The <code>lastIndexOf()</code> method returns the last index\nat which a given element can be found in the array, or -1 if\nit is not present. The array is searched backwards, starting at\n<code>fromIndex</code>.</p>\n\n<a href=\"https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/lastIndexOf\">MDN documentation</a> |\n<a href=\"http://es5.github.com/#x15.4.4.15\">Annotated ES5 Spec</a>","!type":"fn(searchElement: Object, fromIndex?: +Integer) -> +Integer"},"map":{"!doc":"<p>The <code>map()</code> method creates a new array with\nthe results of calling a provided function on every\nelement in this array.</p>\n\n<a href=\"https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/map\">MDN documentation</a> |\n<a href=\"http://es5.github.com/#x15.4.4.19\">Annotated ES5 Spec</a>","!type":"fn(callback: fn(), obj?: Object) -> +Array"},"reduce":{"!doc":"<p>The <code>reduce()</code> method applies a function against\nan accumulator and each value of the array (from left-to-right)\nhas to reduce it to a single value.</p>\n\n<a href=\"https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/reduce\">MDN documentation</a> |\n<a href=\"http://es5.github.com/#x15.4.4.21\">Annotated ES5 Spec</a>","!type":"fn(callback: fn(), init?: Object) -> Object"},"reduceRight":{"!doc":"<p>The reduceRight() method applies a function against an\naccumulator and each value of the array (from right-to-left)\nas to reduce it to a single value.</p>\n\n<a href=\"https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/reduceRight\">MDN documentation</a> |\n<a href=\"http://es5.github.com/#x15.4.4.22\">Annotated ES5 Spec</a>","!type":"fn(callback: fn(), init?: Object) -> Object"},"some":{"!doc":"<p>The <code>some()</code> method tests whether some\nelement in the array passes the test implemented by\nthe provided function.</p>\n\n<a href=\"https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/some\">MDN documentation</a> |\n<a href=\"http://es5.github.com/#x15.4.4.17\">Annotated ES5 Spec</a>","!type":"fn(callback: fn(), obj?: Object) -> +Array"}},"Date":{"!doc":"<p>This class is responsible for the normalization of the native &#8216;Date&#8217; object.\nIt checks if these methods are available and, if not, appends them to\nensure compatibility in all browsers.\nFor usage samples, check out the attached links.</p>","now":{"!doc":"<p>Returns the time elapsed since January 1, 1970 in milliseconds.</p>\n\n<a href=\"https://developer.mozilla.org/en-US/docs/JavaScript/Reference/Global_Objects/Date/now\">MDN documentation</a> |\n<a href=\"http://es5.github.com/#x15.9.4.4\">Annotated ES5 Spec</a>","!type":"fn() -> +Integer"}},"Error":{"!doc":"<p>This class is responsible for the normalization of the native &#8216;Error&#8217; object.\nIt contains a simple bugfix for toString which might not print out the proper\nerror message.</p>","toString":{"!doc":"<p>Returns a string representation of the Error object.</p>\n\n<a href=\"https://developer.mozilla.org/en-US/docs/JavaScript/Reference/Global_Objects/Error/toString\">MDN documentation</a> |\n<a href=\"http://es5.github.com/#x15.11.4.4\">Annotated ES5 Spec</a>","!type":"fn() -> string"}},"Function":{"!doc":"<p>This class is responsible for the normalization of the native &#8216;Function&#8217; object.\nIt checks if these methods are available and, if not, appends them to\nensure compatibility in all browsers.\nFor usage samples, check out the attached links.</p>","bind":{"!doc":"<a href=\"https://developer.mozilla.org/en-US/docs/JavaScript/Reference/Global_Objects/Function/bind\">MDN documentation</a> |\n<a href=\"http://es5.github.com/#x15.3.4.5\">Annotated ES5 Spec</a>\n\n<p>Example for the <code>bind</code> method:</p>\n\n<pre class=\"javascript\">\n// sample code, assumes the used variables are already defined\n\n// the listener method demonstrates how to pass dynamic values\n// to a method using 'bind'\nvar changeValueListener = function(value, event) {\n  // value is passed by the 'bind' method: its value is 'myArray[i]'\n  // second argument is passed by the 'on' method: its value is a event object\n  // 'this' is pointing to 'myComponent', since the first argument of 'bind' defines the context of the function call\n};\nvar myArray = [ 0, 2, 4, 6 ];\nfor (var i=0, j=myArray.length; i&lt;j; i++) {\n  myComponent.on(\"changeValue\", changeValueListener.bind(myComponent, myArray[i]));\n}\n</pre>","!type":"fn(that?: Object) -> fn()"}},"Object":{"!doc":"<p>This class is responsible for the normalization of the native Object.\nIt checks if these methods are available and, if not, appends them to\nensure compatibility in all browsers.\nFor usage samples, check out the attached links.</p>","keys":{"!doc":"<p>Get the keys of a map as array as returned by a &#8220;for&#8230; in&#8221; statement.</p>\n\n<a href=\"https://developer.mozilla.org/en-US/docs/JavaScript/Reference/Global_Objects/Object/keys\">MDN documentation</a> |\n<a href=\"http://es5.github.com/#x15.2.3.14\">Annotated ES5 Spec</a>","!type":"fn(map: Object) -> +Array"}},"String":{"!doc":"<p>This class is responsible for the normalization of the native &#8216;String&#8217; object.\nIt checks if these methods are available and, if not, appends them to\nensure compatibility in all browsers.\nFor usage samples, check out the attached links.</p>","trim":{"!doc":"<p>Removes whitespace from both ends of the string.</p>\n\n<a href=\"https://developer.mozilla.org/en-US/docs/JavaScript/Reference/Global_Objects/String/Trim\">MDN documentation</a> |\n<a href=\"http://es5.github.com/#x15.5.4.20\">Annotated ES5 Spec</a>","!type":"fn() -> string"}}},"Number":{"!doc":"<p>Helper functions for numbers.</p>\n\n<p>The native JavaScript Number is not modified by this class.</p>","isBetweenRange":{"!doc":"<p>Check whether the number is between a given range</p>","!type":"fn(nr: number, vmin: +Integer, vmax: +Integer) -> bool"},"isInRange":{"!doc":"<p>Check whether the number is in a given range</p>","!type":"fn(nr: number, vmin: +Integer, vmax: +Integer) -> bool"},"limit":{"!doc":"<p>Limit the number to a given range</p>\n\n<ul>\n<li>If the number is greater than the upper bound, the upper bound is returned</li>\n<li>If the number is smaller than the lower bound, the lower bound is returned</li>\n<li>If the number is in the range, the number is returned</li>\n</ul>","!type":"fn(nr: number, vmin: +Integer, vmax: +Integer) -> +Integer"}},"Object":{"!doc":"<p>Helper functions to handle Object as a Hash map.</p>","__equals":{"!doc":"<p>Internal recursive comparison function for equals</p>","!type":"fn(object1: Object, object2: Object, aStack: Object, bStack: Object) -> bool"},"clone":{"!doc":"<p>Return a copy of an Object</p>","!type":"fn(source: Object, deep: bool) -> Object"},"contains":{"!doc":"<p>Whether the map contains the given value.</p>","!type":"fn(map: Object, value: Object) -> bool"},"empty":{"!doc":"<p>Clears the map from all values</p>","!type":"fn(map: Object)"},"equals":{"!doc":"<p>Perform a deep comparison to check if two objects are equal</p>","!type":"fn(object1: Object, object2: Object) -> bool"},"fromArray":{"!doc":"<p>Convert an array into a map.</p>\n\n<p>All elements of the array become keys of the returned map by\ncalling <code>toString</code> on the array elements. The values of the\nmap are set to <code>true</code></p>","!type":"fn(array: +Array) -> +Map"},"getKeyFromValue":{"!doc":"<p>Get the key of the given value from a map.\nIf the map has more than one key matching the value, the first match is returned.\nIf the map does not contain the value, <code>null</code> is returned.</p>","!type":"fn(map: Object, value: Object) -> string"},"getLength":{"!doc":"<p>Get the number of objects in the map</p>","!type":"fn(map: Object) -> +Integer"},"getValues":{"!doc":"<p>Get the values of a map as array</p>","!type":"fn(map: Object) -> +Array"},"invert":{"!doc":"<p>Inverts a map by exchanging the keys with the values.</p>\n\n<p>If the map has the same values for different keys, information will get lost.\nThe values will be converted to strings using the toString methods.</p>","!type":"fn(map: Object) -> Object"},"isEmpty":{"!doc":"<p>Check if the hash has any keys</p>","!type":"fn(map: Object) -> bool"},"mergeWith":{"!doc":"<p>Inserts all keys of the source object into the\ntarget objects. Attention: The target map gets modified.</p>","!type":"fn(target: Object, source: Object, overwrite?: bool) -> Object"}},"String":{"!doc":"<p>String helper functions</p>\n\n<p>The native JavaScript String is not modified by this class. However,\nthere are modifications to the native String in {@link qx.lang.normalize.String} for\nbrowsers that do not support certain features.</p>","camelCase":{"!doc":"<p>Converts a hyphenated string (separated by &#8217;-&#8217;) to camel case.</p>\n\n<p>Example:</p>\n\n<pre class=\"javascript\">qx.lang.String.camelCase(\"I-like-cookies\"); //returns \"ILikeCookies\"</pre>","!type":"fn(str: string) -> string"},"capitalize":{"!doc":"<p>Converts a string to camel case.</p>\n\n<p>Example:</p>\n\n<pre class=\"javascript\">qx.lang.String.camelCase(\"i like cookies\"); //returns \"I Like Cookies\"</pre>","!type":"fn(str: string) -> string"},"clean":{"!doc":"<p>Removes all extraneous whitespace from a string and trims it</p>\n\n<p>Example:</p>\n\n<code>\nqx.lang.String.clean(\" i      like     cookies      \\n\\n\");\n</code>\n\n<p>Returns &#8220;i like cookies&#8221;</p>","!type":"fn(str: string) -> string"},"contains":{"!doc":"<p>Check whether the string contains a given substring</p>","!type":"fn(str: string, substring: string) -> bool"},"endsWith":{"!doc":"<p>Check whether the string ends with the given substring</p>","!type":"fn(fullstr: string, substr: string) -> bool"},"escapeRegexpChars":{"!doc":"<p>Escapes all chars that have a special meaning in regular expressions</p>","!type":"fn(str: string) -> string"},"firstLow":{"!doc":"<p>Convert the first character of the string to lower case.</p>","!type":"fn(str: string) -> string"},"firstUp":{"!doc":"<p>Convert the first character of the string to upper case.</p>","!type":"fn(str: string) -> string"},"format":{"!doc":"<p>Print a list of arguments using a format string\nIn the format string occurrences of %n are replaced by the n&#8217;th element of the args list.\nExample:</p>\n\n<pre class=\"javascript\">qx.lang.String.format(\"Hello %1, my name is %2\", [\"Egon\", \"Franz\"]) == \"Hello Egon, my name is Franz\"</pre>","!type":"fn(pattern: string, args: +Array) -> string"},"hyphenate":{"!doc":"<p>Converts a camelcased string to a hyphenated (separated by &#8217;-&#8217;) string.</p>\n\n<p>Example:</p>\n\n<pre class=\"javascript\">qx.lang.String.hyphenate(\"weLikeCookies\"); //returns \"we-like-cookies\"</pre>","!type":"fn(str: string) -> string"},"pad":{"!doc":"<p>Pad a string up to a given length. Padding characters are added to the left of the string.</p>","!type":"fn(str: string, length: +Integer, ch: string) -> string"},"quote":{"!doc":"<p>Quotes the given string.</p>","!type":"fn(str: string) -> string"},"repeat":{"!doc":"<p>Returns a string, which repeats a string &#8216;length&#8217; times</p>","!type":"fn(str: string, times: +Integer) -> string"},"startsWith":{"!doc":"<p>Check whether the string starts with the given substring</p>","!type":"fn(fullstr: string, substr: string) -> bool"},"stripScripts":{"!doc":"<p>Strips </p>","!type":"fn(str: string, exec?: bool) -> string"},"stripTags":{"!doc":"<p>Remove <span class=\"caps\">HTML</span>/XML tags from a string\nExample:</p>\n\n<pre class=\"javascript\">qx.lang.String.stripTags(\"&lt;h1>Hello&lt;/h1>\") == \"Hello\"</pre>","!type":"fn(str: string) -> string"},"toArray":{"!doc":"<p>Converts a string to an array of characters.</p>\n\n<pre>\"hello\" => [ \"h\", \"e\", \"l\", \"l\", \"o\" ];</pre>","!type":"fn(str: string) -> +Array"},"trimLeft":{"!doc":"<p>removes white space from the left side of a string</p>","!type":"fn(str: string) -> string"},"trimRight":{"!doc":"<p>removes white space from the right side of a string</p>","!type":"fn(str: string) -> string"}},"Type":{"!doc":"<p>Utility class with type check for all native JavaScript data types.</p>","getClass":{"!doc":"<p>Get the internal class of the value. See\n<a href=\"http://perfectionkills.com/instanceof-considered-harmful-or-how-to-write-a-robust-isarray/\">http://perfectionkills.com/instanceof-considered-harmful-or-how-to-write-a-robust-isarray/</a>\nfor details.</p>","!type":"fn(value: Object) -> string"},"isArray":{"!doc":"<p>Whether the value is an array.</p>","!type":"fn(value: Object) -> bool"},"isBoolean":{"!doc":"<p>Whether the value is a boolean.</p>","!type":"fn(value: Object) -> bool"},"isDate":{"!doc":"<p>Whether the value is a date.</p>","!type":"fn(value: Object) -> bool"},"isError":{"!doc":"<p>Whether the value is a Error.</p>","!type":"fn(value: Object) -> bool"},"isFunction":{"!doc":"<p>Whether the value is a function.</p>","!type":"fn(value: Object) -> bool"},"isNumber":{"!doc":"<p>Whether the value is a number.</p>","!type":"fn(value: Object) -> bool"},"isObject":{"!doc":"<p>Whether the value is an object. Note that built-in types like Window are\nnot reported to be objects.</p>","!type":"fn(value: Object) -> bool"},"isRegExp":{"!doc":"<p>Whether the value is a regular expression.</p>","!type":"fn(value: Object) -> bool"},"isString":{"!doc":"<p>Whether the value is a string.</p>","!type":"fn(value: Object) -> bool"}}},"locale":{"Date":{"!doc":"<p>Static class that provides localized date information (like names of week\ndays, AM/PM markers, start of week, etc.).</p>","__localizeWithFallback":{"!doc":"<p>Provide localisation (CLDR) data with fallback between &#8220;format&#8221; and &#8220;stand-alone&#8221; contexts.\nIt is used in {@link #getDayName} and {@link #getMonthName} methods.</p>","!type":"fn(context: string, fallbackContext: string, key: string, locale: string) -> string"},"_getTerritory":{"!doc":"<p>Extract the territory part from a locale</p>","!type":"fn(locale: string) -> string"},"getAmMarker":{"!doc":"<p>Get AM marker for time definitions</p>","!type":"fn(locale: string) -> string"},"getDateFormat":{"!doc":"<p>Return localized date format string to be used with {@link qx.util.format.DateFormat}.</p>","!type":"fn(size: string, locale?: string) -> string"},"getDateTimeFormat":{"!doc":"<p>Try to localize a date/time format string. For format string possibillities see\n<a href=\"http://cldr.unicode.org/translation/date-time\">Date/Time Symbol reference</a>\nat <span class=\"caps\">CLDR</span> &#8211; Unicode Common Locale Data Repository.</p>\n\n<p>If no localization is available take the fallback format string.</p>","!type":"fn(canonical: string, fallback: string, locale: string) -> string"},"getDayName":{"!doc":"<p>Return localized name of a week day name</p>","!type":"fn(length: string, day: +Integer, locale: string, context: string, withFallback?: bool) -> string"},"getDayNames":{"!doc":"<p>Return localized names of day names</p>","!type":"fn(length: string, locale: string, context: string, withFallback?: bool) -> string"},"getMonthName":{"!doc":"<p>Return localized name of a month</p>","!type":"fn(length: string, month: +Integer, locale: string, context: string, withFallback?: bool) -> string"},"getMonthNames":{"!doc":"<p>Return localized names of month names</p>","!type":"fn(length: string, locale: string, context: string, withFallback?: bool) -> string"},"getPmMarker":{"!doc":"<p>Get PM marker for time definitions</p>","!type":"fn(locale: string) -> string"},"getTimeFormat":{"!doc":"<p>Return localized time format string to be used with {@link qx.util.format.DateFormat}.</p>","!type":"fn(size: string, locale: string) -> string"},"getWeekendEnd":{"!doc":"<p>Return the day the weekend ends with</p>\n\n<p>Reference: Common Locale Data Repository (cldr) supplementalData.xml</p>","!type":"fn(locale: string) -> +Integer"},"getWeekendStart":{"!doc":"<p>Return the day the weekend starts with</p>\n\n<p>Reference: Common Locale Data Repository (cldr) supplementalData.xml</p>","!type":"fn(locale: string) -> +Integer"},"getWeekStart":{"!doc":"<p>Return the day the week starts with</p>\n\n<p>Reference: Common Locale Data Repository (cldr) supplementalData.xml</p>","!type":"fn(locale: string) -> +Integer"},"isWeekend":{"!doc":"<p>Returns whether a certain day of week belongs to the week end.</p>","!type":"fn(day: +Integer, locale: string) -> bool"}},"Key":{"!doc":"<p>Static class, which contains functionality to localize the names of keyboard keys.</p>","getKeyName":{"!doc":"<p>Return localized name of a key identifier\n{@link qx.event.type.KeySequence}</p>","!type":"fn(size: string, keyIdentifier: string, locale: string) -> string"}},"LocalizedString":{"!proto":"qx.type.BaseString","!doc":"<p>This class contains the translation of a message and all information\nto translate it again into a different language.</p>","!type":"fn()","prototype":{"getMessageId":{"!doc":"<p>Returns the messageId.</p>","!type":"fn() -> string"},"translate":{"!doc":"<p>Get a translation of the string using the current locale.</p>","!type":"fn() -> +LocalizedString"}}},"Manager":{"!proto":"qx.core.Object","!doc":"<p>The qx.locale.Manager provides static translation methods (like tr()) and\ngeneral locale information.</p>","!type":"fn()","getInstance":{"!doc":"<p>Returns a singleton instance of this class. On the first call the class\nis instantiated by calling the constructor with no arguments. All following\ncalls will return this instance.</p>\n\n<p>This method has been added by setting the &#8220;type&#8221; key in the class definition\n({@link qx.Class#define}) to &#8220;singleton&#8221;.</p>","!type":"fn() -> +qx.locale.Manager"},"marktr":{"!doc":"<p>Mark the message for translation but return the original message.</p>","!type":"fn(messageId: string) -> string"},"tr":{"!doc":"<p>Translate a message</p>","!type":"fn(messageId: string, varargs: Object) -> string"},"trc":{"!doc":"<p>Translate a message with translation hint (from developer addressed to translator).</p>","!type":"fn(hint: string, messageId: string, varargs: Object) -> string"},"trn":{"!doc":"<p>Translate a plural message</p>\n\n<p>Depending on the third argument the plural or the singular form is chosen.</p>","!type":"fn(singularMessageId: string, pluralMessageId: string, count: +Integer, varargs: Object) -> string"},"trnc":{"!doc":"<p>Translate a plural message with translation hint (from developer addressed to translator).</p>\n\n<p>Depending on the third argument the plural or the singular form is chosen.</p>","!type":"fn(hint: string, singularMessageId: string, pluralMessageId: string, count: +Integer, varargs: Object) -> string"},"prototype":{"__extractLanguage":{"!doc":"<p>Extract the language part from a locale.</p>","!type":"fn(locale: string) -> string"},"__lookupAndExpand":{"!doc":"<p>Look up an I18N key in a catalog and expand format strings.</p>\n\n<p>Implements the lookup chain locale (e.g. en_US) -> language (e.g. en) ->\ndefault locale (e.g. C). Localizes the arguments if possible and splices\nthem into the message. If qx.dynlocale is on, returns a {@link\nLocalizedString}.</p>","!type":"fn(catalog: +Map, messageId: string, args: Object, locale?: string) -> string"},"_applyLocale":{"!doc":"<p>Applies changes of the property value of the property <code>locale</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #locale}.</p>","!type":"fn(value: string, old: string)"},"addLocale":{"!doc":"<p>Add a localization to the localization manager.</p>\n\n<p>If <code>localeCode</code> already exists, its map will be updated with\n<code>localeMap</code> (new keys will be added, existing keys will be overwritten).</p>","!type":"fn(localeCode: string, localeMap: +Map)"},"addTranslation":{"!doc":"<p>Add a translation to the translation manager.</p>\n\n<p>If <code>languageCode</code> already exists, its map will be updated with\n<code>translationMap</code> (new keys will be added, existing keys will be\noverwritten).</p>","!type":"fn(languageCode: string, translationMap: +Map)"},"getAvailableLocales":{"!doc":"<p>Return the available application locales</p>\n\n<p>This corresponds to the <span class=\"caps\">LOCALES</span> setting in config.json. Without argument,\nit only returns the currently loaded locales, with an argument of true\nall locales that went into the build. This is particularly interesting if\nlocales were generated as dedicated I18N parts, and have to be loaded\nexplicitly before being available.</p>","!type":"fn(includeNonloaded?: bool) -> string"},"getLanguage":{"!doc":"<p>Get the language code of the current locale</p>\n\n<p>This is the first part of a locale definition. The language for &#8220;de_DE&#8221; would be &#8220;de&#8221;</p>","!type":"fn() -> string"},"getLocale":{"!doc":"<p>Returns the (computed) value of the property <code>locale</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #locale}.</p>","!type":"fn() -> Object"},"getTerritory":{"!doc":"<p>Get the territory code of the current locale</p>\n\n<p>This is the second part of a locale definition. The territory for &#8220;de_DE&#8221; would be &#8220;DE&#8221;</p>","!type":"fn() -> string"},"initLocale":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>locale</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #locale}.</p>","!type":"fn(value: Object) -> Object"},"localize":{"!doc":"<p>Provide localisation (CLDR) data.</p>\n\n<p>Implements the lookup chain locale (e.g. en_US) -> language (e.g. en) ->\ndefault locale (e.g. C). Localizes the arguments if possible and splices\nthem into the message. If qx.dynlocale is on, returns a {@link\nLocalizedString}.</p>","!type":"fn(messageId: string, args: Object, locale?: string) -> string"},"resetLocale":{"!doc":"<p>Resets the user value of the property <code>locale</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #locale}.</p>","!type":"fn()"},"setLocale":{"!doc":"<p>Sets the user value of the property <code>locale</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #locale}.</p>","!type":"fn(value: Object) -> Object"},"translate":{"!doc":"<p>Translate a message using the current locale and apply format string to the arguments.</p>\n\n<p>Implements the lookup chain locale (e.g. en_US) -> language (e.g. en) ->\ndefault locale (e.g. C). Localizes the arguments if possible and splices\nthem into the message. If qx.dynlocale is on, returns a {@link\nLocalizedString}.</p>","!type":"fn(messageId: string, args: Object, locale?: string) -> string"}}},"MTranslation":{"!doc":"<p>This mixin contains the methods needed to use the translation features\nof qooxdoo.</p>","prototype":{"marktr":{"!doc":"<p>Mark the message for translation but return the original message.</p>","!type":"fn(messageId: string) -> string"},"tr":{"!doc":"<p>Translate a message\nMark the message for translation.</p>","!type":"fn(messageId: string, varargs: Object) -> string"},"trc":{"!doc":"<p>Translate a message with translation hint\nMark the messages for translation.</p>","!type":"fn(hint: string, messageId: string, varargs: Object) -> string"},"trn":{"!doc":"<p>Translate a plural message\nMark the messages for translation.</p>\n\n<p>Depending on the third argument the plural or the singular form is chosen.</p>","!type":"fn(singularMessageId: string, pluralMessageId: string, count: +Integer, varargs: Object) -> string"},"trnc":{"!doc":"<p>Translate a plural message with translation hint\nMark the messages for translation.</p>\n\n<p>Depending on the third argument the plural or the singular form is chosen.</p>","!type":"fn(hint: string, singularMessageId: string, pluralMessageId: string, count: +Integer, varargs: Object) -> string"}}},"Number":{"!doc":"<p>Provides information about locale-dependent number formatting (like the decimal\nseparator).</p>","getDecimalSeparator":{"!doc":"<p>Get decimal separator for number formatting</p>","!type":"fn(locale: string) -> string"},"getGroupSeparator":{"!doc":"<p>Get thousand grouping separator for number formatting</p>","!type":"fn(locale: string) -> string"},"getPercentFormat":{"!doc":"<p>Get percent format string</p>","!type":"fn(locale: string) -> string"}},"String":{"!doc":"<p>Provides information about locale-dependent string formatting (like quotation\nsigns).</p>","getAlternateQuotationEnd":{"!doc":"<p>Get quotation alternative end sign</p>","!type":"fn(locale: string) -> string"},"getAlternateQuotationStart":{"!doc":"<p>Get quotation alternative start sign</p>","!type":"fn(locale: string) -> string"},"getQuotationEnd":{"!doc":"<p>Get quotation end sign</p>","!type":"fn(locale: string) -> string"},"getQuotationStart":{"!doc":"<p>Get quotation start sign</p>","!type":"fn(locale: string) -> string"}}},"log":{"appender":{"Console":{"!doc":"<p>Feature-rich console appender for the qooxdoo logging system.</p>\n\n<p>Creates a small inline element which is placed in the top-right corner\nof the window. Prints all messages with a nice color highlighting.</p>\n\n<ul>\n<li>Allows user command inputs.</li>\n<li>Command history enabled by default (Keyboard up/down arrows).</li>\n<li>Lazy creation on first open.</li>\n<li>Clearing the console using a button.</li>\n<li>Display of offset (time after loading) of each message</li>\n<li>Supports keyboard shortcuts F7 or Ctrl+D to toggle the visibility</li>\n</ul>","__onKeyPress":{"!doc":"<p>Event handler for keydown listener</p>","!type":"fn(e: +Event)"},"__onResize":{"!doc":"<p>Event handler for resize listener</p>","!type":"fn(e: +Event)"},"__scrollDown":{"!doc":"<p>Automatically scroll down to the last line</p>","!type":"fn()"},"clear":{"!doc":"<p>Clears the current console output.</p>","!type":"fn()"},"dispose":{"!doc":"<p>Used by the object registry to dispose this instance e.g. remove listeners etc.</p>","!type":"fn()"},"execute":{"!doc":"<p>Executes the currently given command</p>","!type":"fn()"},"init":{"!doc":"<p>Initializes the console, building <span class=\"caps\">HTML</span> and pushing last\nlog messages to the output window.</p>","!type":"fn()"},"process":{"!doc":"<p>Processes a single log entry</p>","!type":"fn(entry: +Map)"},"show":{"!doc":"<p>Shows the console.</p>","!type":"fn()"},"toggle":{"!doc":"<p>Toggles the visibility of the console between visible and hidden.</p>","!type":"fn()"}},"Element":{"!proto":"qx.core.Object","!doc":"<p>This appender is used to log to an existing <span class=\"caps\">DOM</span> element</p>","!type":"fn()","prototype":{"clear":{"!doc":"<p>Clears the current output.</p>","!type":"fn()"},"process":{"!doc":"<p>Processes a single log entry</p>","!type":"fn(entry: +Map)"},"setElement":{"!doc":"<p>Configures the <span class=\"caps\">DOM</span> element to use.</p>","!type":"fn(element: +Element)"}}},"Native":{"!doc":"<p>Processes the incoming log entry and displays it by means of the native\nlogging capabilities of the client.</p>\n\n<p>Supported browsers:\n* Firefox <4 using FireBug (if available).\n* Firefox >=4 using the Web Console.\n* WebKit browsers using the Web Inspector/Developer Tools.\n* Internet Explorer 8+ using the F12 Developer Tools.\n* Opera >=10.60 using either the Error Console or Dragonfly</p>\n\n<p>Currently unsupported browsers:\n* Opera <10.60</p>","process":{"!doc":"<p>Processes a single log entry</p>","!type":"fn(entry: +Map)"}},"NodeConsole":{"!doc":"<p>Log appender for qooxdoo applications running in Node.js. Writes log\nmessages to <span class=\"caps\">STDOUT</span>/STDERR.</p>","debug":{"!doc":"<p>Logs a debug message</p>","!type":"fn(logMessage: string)"},"error":{"!doc":"<p>Logs an error message</p>","!type":"fn(logMessage: string)"},"info":{"!doc":"<p>Logs an info message</p>","!type":"fn(logMessage: string)"},"log":{"!doc":"<p>Writes a message to the shell. Errors will be sent to <span class=\"caps\">STDERR</span>, everything\nelse goes to <span class=\"caps\">STDOUT</span></p>","!type":"fn(logMessage: string, level: string)"},"process":{"!doc":"<p>Process a log entry object from qooxdoo&#8217;s logging system.</p>","!type":"fn(entry: +Map)"},"warn":{"!doc":"<p>Logs a warning message</p>","!type":"fn(logMessage: string)"}},"PhoneGap":{"!doc":"<p>Processes the incoming log entry and displays it using the PhoneGap\nlogging capabilities.</p>","process":{"!doc":"<p>Processes a single log entry</p>","!type":"fn(entry: +Map)"}},"RhinoConsole":{"!doc":"<p>Log appender for qooxdoo applications running in Mozilla Rhino. Writes log\nmessages to <span class=\"caps\">STDOUT</span>/STDERR.</p>","debug":{"!doc":"<p>Logs a debug message</p>","!type":"fn(logMessage: string)"},"error":{"!doc":"<p>Logs an error message</p>","!type":"fn(logMessage: string)"},"info":{"!doc":"<p>Logs an info message</p>","!type":"fn(logMessage: string)"},"log":{"!doc":"<p>Writes a message to the shell. Errors will be sent to <span class=\"caps\">STDERR</span>, everything\nelse goes to <span class=\"caps\">STDOUT</span></p>","!type":"fn(logMessage: string, level: string)"},"process":{"!doc":"<p>Process a log entry object from qooxdoo&#8217;s logging system.</p>","!type":"fn(entry: +Map)"},"warn":{"!doc":"<p>Logs a warning message</p>","!type":"fn(logMessage: string)"}},"RhinoFile":{"!doc":"<p>Log appender for qooxdoo applications running in Mozilla Rhino. Writes log\nmessages to a text file.</p>","create":{"!doc":"<p>Creates a new log file using the value of {@link #FILENAME} as the\nfile path/name.</p>","!type":"fn()"},"debug":{"!doc":"<p>Logs a debug message</p>","!type":"fn(logMessage: string)"},"error":{"!doc":"<p>Logs an error message</p>","!type":"fn(logMessage: string)"},"info":{"!doc":"<p>Logs an info message</p>","!type":"fn(logMessage: string)"},"log":{"!doc":"<p>Writes a message to the file.</p>","!type":"fn(logMessage: string, level: string)"},"process":{"!doc":"<p>Process a log entry object from qooxdoo&#8217;s logging system.</p>","!type":"fn(entry: +Map)"},"warn":{"!doc":"<p>Logs a warning message</p>","!type":"fn(logMessage: string)"}},"RingBuffer":{"!proto":"qx.util.RingBuffer","!doc":"<p>An appender that writes all messages to a memory container. The messages\ncan be retrieved later, f. i. when an error dialog pops up and the question\narises what actions have caused the error.</p>\n\n<p>A mark feature also exists which can be used to remember a point in time.\nWhen retrieving log events, it is possible to get only those events\nafter the marked time. This is useful if data from the buffer is extracted\nand f. i. sent to a logging system. Whenever this happens, a mark() call\ncan be used so that the next extraction will only get new data.</p>","!type":"fn()","prototype":{"clearHistory":{"!doc":"<p>Clears the log history</p>","!type":"fn()"},"getAllLogEvents":{"!doc":"<p>Returns all stored log events</p>","!type":"fn() -> +Array"},"getMaxMessages":{"!doc":"<p>Get the maximum number of messages to hold</p>","!type":"fn() -> +Integer"},"process":{"!doc":"<p>Processes a single log entry</p>","!type":"fn(entry: +Map)"},"retrieveLogEvents":{"!doc":"<p>Returns log events which have been logged previously.</p>","!type":"fn(count: +Integer, startingFromMark?: bool) -> +Array"},"setMaxMessages":{"!doc":"<p>Set the maximum number of messages to hold. If null the number of\nmessages is not limited.</p>\n\n<p>Warning: Changing this property will clear the events logged so far.</p>","!type":"fn(maxMessages: +Integer)"}}},"Util":{"!doc":"<p>Contains some common methods available to all log appenders.</p>","__escapeHTMLReplace":{"!doc":"<p>Internal replacement helper for <span class=\"caps\">HTML</span> escape.</p>","!type":"fn(ch: string) -> string"},"escapeHTML":{"!doc":"<p>Escapes the <span class=\"caps\">HTML</span> in the given value</p>","!type":"fn(value: string) -> string"},"formatOffset":{"!doc":"<p>Formats a numeric time offset to 6 characters.</p>","!type":"fn(offset: +Integer, length?: +Integer) -> string"},"toHtml":{"!doc":"<p>Converts a single log entry to <span class=\"caps\">HTML</span></p>","!type":"fn(entry: +Map)"},"toText":{"!doc":"<p>Converts a single log entry to plain text</p>","!type":"fn(entry: +Map) -> string"},"toTextArray":{"!doc":"<p>Converts a single log entry to an array of plain text</p>","!type":"fn(entry: +Map) -> +Array"}}},"Logger":{"!doc":"<p>Main qooxdoo logging class.</p>\n\n<p>Used as central logging feature by qx.core.Object.</p>\n\n<p>Extremely modular and lightweight to support logging at bootstrap and\nat shutdown as well.</p>\n\n<ul>\n<li>Supports dynamic appenders to push the output to the user</li>\n<li>Supports buffering of the last 50 messages (configurable)</li>\n<li>Supports different debug levels (&#8220;debug&#8221;, &#8220;info&#8221;, &#8220;warn&#8221; or &#8220;error&#8221;)</li>\n<li>Simple data serialization for incoming messages</li>\n</ul>","__detect":{"!doc":"<p>Detects the type of the variable given.</p>","!type":"fn(value: Object) -> string"},"__log":{"!doc":"<p>Internal logging main routine.</p>","!type":"fn(level: string, args: +Array)"},"__serialize":{"!doc":"<p>Serializes the incoming value. If it is a singular value, the result is\na simple string. For an array or a map the result can also be a\nserialized string of a limited number of individual items.</p>","!type":"fn(value: Object, deep?: bool) -> +Map"},"clear":{"!doc":"<p>Deletes the current buffer. Does not influence message handling of the\nconnected appenders.</p>","!type":"fn()"},"debug":{"!doc":"<p>Sending a message at level &#8220;debug&#8221; to the logger.</p>","!type":"fn(object: Object, message: Object)"},"deprecatedClassWarning":{"!doc":"<p>Prints a class deprecation warning and a stack trace if the setting\n<code>qx.debug</code> is set to <code>true</code>.</p>","!type":"fn(clazz: +Class, msg?: string)"},"deprecatedConstantWarning":{"!doc":"<p>Prints a constant deprecation warning and a stacktrace if the setting\n<code>qx.debug</code> is set to <code>true</code> <span class=\"caps\">AND</span> the browser supports\n<i>defineGetter</i>!</p>","!type":"fn(clazz: +Class, constant: string, msg: string)"},"deprecatedEventWarning":{"!doc":"<p>Prints an event deprecation warning and a stack trace if the setting\n<code>qx.debug</code> is set to <code>true</code>.</p>","!type":"fn(clazz: +Class, event: string, msg?: string)"},"deprecatedMethodWarning":{"!doc":"<p>Prints a method deprecation warning and a stack trace if the setting\n<code>qx.debug</code> is set to <code>true</code>.</p>","!type":"fn(fcn: fn(), msg?: string)"},"deprecatedMixinWarning":{"!doc":"<p>Prints a mixin deprecation warning and a stack trace if the setting\n<code>qx.debug</code> is set to <code>true</code>.</p>","!type":"fn(clazz: +Class, msg?: string)"},"deprecateMethodOverriding":{"!doc":"<p>Prints a deprecation waring and a stacktrace when a subclass overrides\nthe passed method name. The deprecation is only printed if the setting\n<code>qx.debug</code> is set to <code>true</code>.</p>","!type":"fn(object: +qx.core.Object, baseclass: +Class, methodName: string, msg?: string)"},"error":{"!doc":"<p>Sending a message at level &#8220;error&#8221; to the logger.</p>","!type":"fn(object: Object, message: Object)"},"getLevel":{"!doc":"<p>Returns the currently configured minimum log level required for new\nmessages.</p>","!type":"fn() -> +Integer"},"getTreshold":{"!doc":"<p>Returns the currently configured number of messages to be kept in the\nbuffer.</p>","!type":"fn() -> +Integer"},"info":{"!doc":"<p>Sending a message at level &#8220;info&#8221; to the logger.</p>","!type":"fn(object: Object, message: Object)"},"register":{"!doc":"<p>Registers the given appender and inserts the last cached messages.</p>","!type":"fn(appender: +Class)"},"setLevel":{"!doc":"<p>Configures the minimum log level required for new messages.</p>","!type":"fn(value: string)"},"setTreshold":{"!doc":"<p>Configures the number of messages to be kept in the buffer.</p>","!type":"fn(value: +Integer)"},"trace":{"!doc":"<p>Prints the current stack trace at level &#8220;info&#8221;</p>","!type":"fn(object?: Object)"},"unregister":{"!doc":"<p>Unregisters the given appender</p>","!type":"fn(appender: +Class)"},"warn":{"!doc":"<p>Sending a message at level &#8220;warn&#8221; to the logger.</p>","!type":"fn(object: Object, message: Object)"}}},"Mixin":{"!doc":"<p>This class is used to define mixins (similar to mixins in Ruby).</p>\n\n<p>Mixins are collections of code and variables, which can be merged into\nother classes. They are similar to classes but don&#8217;t support inheritance.</p>\n\n<p>See the description of the {@link #define} method how a mixin is defined.</p>","__validateConfig":{"!doc":"<p>Validates incoming configuration and checks keys and values</p>","!type":"fn(name: string, config: +Map)"},"checkCompatibility":{"!doc":"<p>Check compatibility between mixins (including their includes)</p>","!type":"fn(mixins: +Mixin) -> bool"},"define":{"!doc":"<p>Define a new mixin.</p>\n\n<p>Example:</p>\n\n<pre class=\"javascript\">\nqx.Mixin.define(\"name\",\n{\n  include: [SuperMixins],\n\n  properties: {\n    tabIndex: {type: \"number\", init: -1}\n  },\n\n  members:\n  {\n    prop1: \"foo\",\n    meth1: function() {},\n    meth2: function() {}\n  }\n});\n</pre>","!type":"fn(name: string, config?: +Map) -> +qx.Mixin"},"flatten":{"!doc":"<p>Generates a list of all mixins given plus all the\nmixins these includes plus&#8230; (deep)</p>","!type":"fn(mixins?: +Mixin) -> +Array"},"genericToString":{"!doc":"<p>This method will be attached to all mixins to return\na nice identifier for them.</p>","!type":"fn() -> string"},"getByName":{"!doc":"<p>Returns a mixin by name</p>","!type":"fn(name: string) -> +Class"},"getTotalNumber":{"!doc":"<p>Determine the number of mixins which are defined</p>","!type":"fn() -> number"},"isCompatible":{"!doc":"<p>Checks if a class is compatible to the given mixin (no conflicts)</p>","!type":"fn(mixin: +Mixin, clazz: +Class) -> bool"},"isDefined":{"!doc":"<p>Determine if mixin exists</p>","!type":"fn(name: string) -> bool"}},"module":{"Animation":{"!doc":"<p>Cross browser animation layer. It uses feature detection to check if <span class=\"caps\">CSS</span>\nanimations are available and ready to use. If not, a JavaScript-based\nfallback will be used.</p>","_animate":{"!doc":"<p>Animation execute either regular or reversed direction.</p>","!type":"fn(desc: +Map, duration?: number, reverse: bool)"},"animate":{"!doc":"<p>Starts the animation with the given description.\nThe description should be a map, which could look like this:</p>\n\n<pre class=\"javascript\">\n{\n  \"duration\": 1000,\n  \"keep\": 100,\n  \"keyFrames\": {\n    0 : {\"opacity\": 1, \"scale\": 1},\n    100 : {\"opacity\": 0, \"scale\": 0}\n  },\n  \"origin\": \"50% 50%\",\n  \"repeat\": 1,\n  \"timing\": \"ease-out\",\n  \"alternate\": false,\n  \"delay\": 2000\n}\n</pre>\n\n<p><strong>duration</strong> is the time in milliseconds one animation cycle should take.</p>\n\n<p><strong>keep</strong> is the key frame to apply at the end of the animation. (optional)</p>\n\n<p><strong>keyFrames</strong> is a map of separate frames. Each frame is defined by a\n  number which is the percentage value of time in the animation. The value\n  is a map itself which holds css properties or transforms\n  (Transforms only for <span class=\"caps\">CSS</span> Animations).</p>\n\n<p><strong>origin</strong> maps to the <a href=\"https://developer.mozilla.org/en-US/docs/Web/CSS/transform-origin\">transform origin</a>\n(Only for <span class=\"caps\">CSS</span> animations).</p>\n\n<p><strong>repeat</strong> is the amount of time the animation should be run in\n  sequence. You can also use &#8220;infinite&#8221;.</p>\n\n<p><strong>timing</strong> takes one of these predefined values:\n  <code>ease</code> | <code>linear</code> | <code>ease-in</code>\n  | <code>ease-out</code> | <code>ease-in-out</code> |\n  <code>cubic-bezier(&lt;number&gt;, &lt;number&gt;, &lt;number&gt;, &lt;number&gt;)</code>\n  (cubic-bezier only available for <span class=\"caps\">CSS</span> animations)</p>\n\n<p><strong>alternate</strong> defines if every other animation should be run in reverse order.</p>\n\n<p><strong>delay</strong> is the time in milliseconds the animation should wait before start.</p>","!type":"fn(desc: +Map, duration?: number) -> +qxWeb"},"animateReverse":{"!doc":"<p>Starts an animation in reversed order. For further details, take a look at\nthe {@link #animate} method.</p>","!type":"fn(desc: +Map, duration?: number) -> +qxWeb"},"fadeIn":{"!doc":"<p>Fades in all elements in the collection.</p>","!type":"fn(duration?: number) -> +qxWeb"},"fadeOut":{"!doc":"<p>Fades out all elements in the collection.</p>","!type":"fn(duration?: number) -> +qxWeb"},"getAnimationHandles":{"!doc":"<p>Returns the stored animation handles. The handles are only\navailable while an animation is running.</p>","!type":"fn() -> +Array"},"isEnded":{"!doc":"<p>Returns whether an animation has ended or not.</p>","!type":"fn() -> bool"},"isPlaying":{"!doc":"<p>Returns whether an animation is running or not.</p>","!type":"fn() -> bool"},"pause":{"!doc":"<p>Manipulates the play state of the animation.\nThis can be used to pause an animation when running.</p>","!type":"fn() -> +qxWeb"},"play":{"!doc":"<p>Manipulates the play state of the animation.\nThis can be used to continue an animation when paused.</p>","!type":"fn() -> +qxWeb"},"stop":{"!doc":"<p>Stops a running animation.</p>","!type":"fn() -> +qxWeb"}},"Attribute":{"!doc":"<p>Attribute/Property handling for <span class=\"caps\">DOM</span> elements.</p>","getAttribute":{"!doc":"<p>Returns the value of the given attribute for the first item in the\ncollection.</p>","!type":"fn(name: string) -> Object"},"getAttributes":{"!doc":"<p>Returns the values of multiple attributes for the first item in the collection</p>","!type":"fn(names: string) -> +Map"},"getHtml":{"!doc":"<p>Returns the <span class=\"caps\">HTML</span> content of the first item in the collection</p>","!type":"fn() -> string"},"getProperties":{"!doc":"<p>Returns the values of multiple properties for the first item in the collection</p>","!type":"fn(names: string) -> +Map"},"getProperty":{"!doc":"<p>Returns the value of the given property for the first item in the\ncollection</p>","!type":"fn(name: string) -> Object"},"getValue":{"!doc":"<p>Returns the currently configured value for the first item in the collection.\nWorks with simple input fields as well as with select boxes or option\nelements. Returns an array for select boxes with multi selection. In all\nother cases, a string is returned.</p>","!type":"fn() -> string"},"removeAttribute":{"!doc":"<p>Removes the given attribute from all elements in the collection</p>","!type":"fn(name: string) -> +qxWeb"},"removeAttributes":{"!doc":"<p>Removes multiple attributes from each item in the collection.</p>","!type":"fn(attributes: string) -> +qxWeb"},"setAttribute":{"!doc":"<p>Sets an <span class=\"caps\">HTML</span> attribute on each item in the collection</p>","!type":"fn(name: string, value: Object) -> +qxWeb"},"setAttributes":{"!doc":"<p>Sets multiple attributes for each item in the collection.</p>","!type":"fn(attributes: +Map) -> +qxWeb"},"setHtml":{"!doc":"<p>Sets the <span class=\"caps\">HTML</span> content of each item in the collection</p>","!type":"fn(html: string) -> +qxWeb"},"setProperties":{"!doc":"<p>Sets multiple properties for each item in the collection.</p>","!type":"fn(properties: +Map) -> +qxWeb"},"setProperty":{"!doc":"<p>Sets a property on each item in the collection</p>","!type":"fn(name: string, value: Object) -> +qxWeb"},"setValue":{"!doc":"<p>Applies the given value to each element in the collection.\nNormally the value is given as a string/number value and applied to the\nfield content (textfield, textarea) or used to detect whether the field\nis checked (checkbox, radiobutton).\nSupports array values for selectboxes (multiple selection) and checkboxes\nor radiobuttons (for convenience).\nPlease note: To modify the value attribute of a checkbox or radiobutton\nuse @link{#set} instead.</p>","!type":"fn(value: string) -> +qxWeb"}},"Blocker":{"!doc":"<p>Provides a way to block elements so they will no longer receive (native)\nevents by overlaying them with a <span class=\"caps\">DIV</span> element.</p>\n\n<p>The blocker can also be applied to the entire document, e.g.:</p>\n\n<pre class=\"javascript\">\nq(document).block();\n</pre>","__attachBlocker":{"!doc":"<p>Attaches a blocker div to the given element.</p>","!type":"fn(item: +Element, color: string, opacity: number, zIndex: number)"},"__detachBlocker":{"!doc":"<p>Removes the given item&#8217;s blocker element(s) from the <span class=\"caps\">DOM</span></p>","!type":"fn(item: +Element, index: number)"},"__getBlocker":{"!doc":"<p>Returns the blocker elements as collection</p>","!type":"fn(collection: +qxWeb) -> +qxWeb"},"__styleBlocker":{"!doc":"<p>Styles the blocker element(s)</p>","!type":"fn(item: +Element, color: string, opacity: number, zIndex: number, isDocument: bool)"},"block":{"!doc":"<p>Adds an overlay to all items in the collection that intercepts mouse\nevents.</p>","!type":"fn(color?: string, opacity?: number, zIndex?: number) -> +qxWeb"},"getBlocker":{"!doc":"<p>Returns all blocker elements as collection.</p>\n\n<strong>Note:</strong> This will only return elements if\nthe <code>block</code> method was called at least once,\nsince the blocker elements are created on-demand.","!type":"fn() -> +qxWeb"},"unblock":{"!doc":"<p>Removes the blockers from all items in the collection</p>","!type":"fn() -> +qxWeb"}},"Cookie":{"!doc":"<p>Cookie handling module</p>","del":{"!doc":"<p>Deletes the string value of a cookie.</p>","!type":"fn(key: string, path?: string, domain?: string)"},"get":{"!doc":"<p>Returns the string value of a cookie.</p>","!type":"fn(key: string) -> string"},"set":{"!doc":"<p>Sets the string value of a cookie.</p>","!type":"fn(key: string, value: string, expires?: number, path?: string, domain?: string, secure?: bool)"}},"Core":{"!doc":"<p>Placeholder class which simply defines and includes the core of qxWeb.\nThe core modules are:</p>\n\n<ul>\n<li>{@link qx.module.Attribute}</li>\n<li>{@link qx.module.Css}</li>\n<li>{@link qx.module.Environment}</li>\n<li>{@link qx.module.Event}</li>\n<li>{@link qx.module.Manipulating}</li>\n<li>{@link qx.module.Polyfill}</li>\n<li>{@link qx.module.Traversing}</li>\n</ul>"},"Css":{"!doc":"<p><span class=\"caps\">CSS</span>/Style property manipulation module</p>","__getDisplayDefault":{"!doc":"<p>Attempts tp determine the default &#8220;display&#8221; style value for\nelements with the given tag name.</p>","!type":"fn(tagName: string, doc?: +Document) -> string"},"__swap":{"!doc":"<p>Swaps the given styles of the element and execute the callback\nbefore the original values are restored.</p>\n\n<p>Finally returns the return value of the callback.</p>","!type":"fn(element: +Element, styles: +Map, callback: fn(), context: Object) -> Object"},"addClass":{"!doc":"<p>Adds a class name to each element in the collection</p>","!type":"fn(name: string) -> +qxWeb"},"addClasses":{"!doc":"<p>Adds multiple class names to each element in the collection</p>","!type":"fn(names: string) -> +qxWeb"},"getClass":{"!doc":"<p>Returns the class name of the first element in the collection</p>","!type":"fn() -> string"},"getContentHeight":{"!doc":"<p>Returns the content height of the first element in the collection.\nThis is the maximum height the element can use, excluding borders,\nmargins, padding or scroll bars.</p>","!type":"fn(force?: bool) -> number"},"getContentWidth":{"!doc":"<p>Returns the content width of the first element in the collection.\nThis is the maximum width the element can use, excluding borders,\nmargins, padding or scroll bars.</p>","!type":"fn(force?: bool) -> number"},"getHeight":{"!doc":"<p>Returns the rendered height of the first element in the collection.</p>","!type":"fn(force?: bool) -> number"},"getOffset":{"!doc":"<p>Returns the computed location of the given element in the context of the\ndocument dimensions.</p>\n\n<p>Supported modes:</p>\n\n<ul>\n<li><code>margin</code>: Calculate from the margin box of the element (bigger than the visual appearance: including margins of given element)</li>\n<li><code>box</code>: Calculates the offset box of the element (default, uses the same size as visible)</li>\n<li><code>border</code>: Calculate the border box (useful to align to border edges of two elements).</li>\n<li><code>scroll</code>: Calculate the scroll box (relevant for absolute positioned content).</li>\n<li><code>padding</code>: Calculate the padding box (relevant for static/relative positioned content).</li>\n</ul>","!type":"fn(mode?: string) -> +Map"},"getPosition":{"!doc":"<p>Returns the distance between the first element in the collection and its\noffset parent</p>","!type":"fn() -> +Map"},"getStyle":{"!doc":"<p>Returns the value of the given style property for the first item in the\ncollection.</p>","!type":"fn(name: string) -> Object"},"getStyles":{"!doc":"<p>Returns the values of multiple style properties for each item in the\ncollection</p>","!type":"fn(names: string) -> +Map"},"getWidth":{"!doc":"<p>Returns the rendered width of the first element in the collection</p>","!type":"fn(force?: bool) -> number"},"hasClass":{"!doc":"<p>Checks if the first element in the collection has the given class name</p>","!type":"fn(name: string) -> bool"},"hide":{"!doc":"<p>Hides all elements in the collection by setting their &#8220;display&#8221;\nstyle to &#8220;none&#8221;. The previous value is stored so it can be re-applied\nwhen {@link #show} is called.</p>","!type":"fn() -> +qxWeb"},"includeStylesheet":{"!doc":"<p>Includes a Stylesheet file</p>","!type":"fn(uri: string, doc?: +Document)"},"removeClass":{"!doc":"<p>Removes a class name from each element in the collection</p>","!type":"fn(name: string) -> +qxWeb"},"removeClasses":{"!doc":"<p>Removes multiple class names from each element in the collection.\nUse {@link qx.module.Attribute#removeAttribute} to remove all classes.</p>","!type":"fn(names: string) -> +qxWeb"},"replaceClass":{"!doc":"<p>Replaces a class name on each element in the collection</p>","!type":"fn(oldName: string, newName: string) -> +qxWeb"},"setStyle":{"!doc":"<p>Modifies the given style property on all elements in the collection.</p>","!type":"fn(name: string, value: Object) -> +qxWeb"},"setStyles":{"!doc":"<p>Sets multiple style properties for each item in the collection.</p>","!type":"fn(styles: +Map) -> +qxWeb"},"show":{"!doc":"<p>Shows any elements with &#8220;display: none&#8221; in the collection. If an element\nwas hidden by using the {@link #hide} method, its previous\n&#8220;display&#8221; style value will be re-applied. Otherwise, the\ndefault &#8220;display&#8221; value for the element type will be applied.</p>","!type":"fn() -> +qxWeb"},"toggleClass":{"!doc":"<p>Toggles the given class name on each item in the collection</p>","!type":"fn(name: string) -> +qxWeb"},"toggleClasses":{"!doc":"<p>Toggles the given list of class names on each item in the collection</p>","!type":"fn(names: string) -> +qxWeb"}},"Dataset":{"!doc":"<p>Module for handling of HTML5 data-* attributes</p>","getAllData":{"!doc":"<p>Returns a map containing all the <span class=\"caps\">HTML</span> &#8220;data-*&#8221; attributes of the specified element</p>","!type":"fn() -> +Map"},"getData":{"!doc":"<p>Returns the value of the given <span class=\"caps\">HTML</span> &#8220;data-*&#8221; attribute for the first item in the collection</p>","!type":"fn(name: string) -> Object"},"removeData":{"!doc":"<p>Remove an <span class=\"caps\">HTML</span> &#8220;data-*&#8221; attribute from the given <span class=\"caps\">DOM</span> element</p>","!type":"fn(name: string) -> +qxWeb"},"setData":{"!doc":"<p>Sets an <span class=\"caps\">HTML</span> &#8220;data-*&#8221; attribute on each item in the collection</p>","!type":"fn(name: string, value: Object) -> +qxWeb"}},"dev":{"FakeServer":{"!doc":"<p>A wrapper around Sinon.JS&#8217;s FakeXMLHttpRequest and FakeServer features that\nallows quick and simple configuration of mock <span class=\"caps\">HTTP</span> backends for testing and\ndevelopment.\nAutomatically creates <span class=\"caps\">URL</span> filtering rules to ensure that only configured\nrequests are faked while others will be processed normally by the browser&#8217;s\n<span class=\"caps\">XHR</span> implementation.</p>\n\n<p>The following example shows how to configure mock responses for two different\nrequests:</p>\n\n<pre class=\"javascript\">\n  var responseData = [\n    {\n      method: \"GET\",\n      url: /\\/api\\/resource\\/\\d+/,\n      response : function(request) {\n        var status = 200;\n        var headers = { \"Content-Type\": \"application/json\" };\n        var responseData = {\n          description: \"Mock REST response for resource \" + request.url\n        };\n        var body = JSON.stringify(responseData);\n        request.respond(status, headers, body);\n      }\n    },\n    {\n      method: \"GET\",\n      url: \"/users/{userId}\",\n      response: [\n        200,\n        { \"Content-Type\": \"application/json\" },\n        JSON.stringify({userId: 'someUser'})\n      ]\n    }\n  ];\n\n  q.dev.fakeServer.configure(responseData);\n</pre>","addFilter":{"!doc":"<p>Adds a <span class=\"caps\">URL</span> filtering function to decide whether a request should be handled\nby the FakeServer or passed to the regular XMLHttp implementation.\nSee <a href=\"http://sinonjs.org/docs/#filtered-requests\">Sinon.JS: Filtered Requests</a>\nfor details.</p>","!type":"fn(filter: fn())"},"configure":{"!doc":"<p>Configures a set of fake <span class=\"caps\">HTTP</span> responses. Each response is defined as a map\nthat must provide the following keys:\n<ul>\n  <li><code>method</code> <span class=\"caps\">HTTP</span> method to respond to, e.g. <code><span class=\"caps\">PUT</span></code></li>\n  <li><code>url</code> <span class=\"caps\">URL</span> used to match requests to fake responses. Can be\n  a RegExp or a String. <span class=\"caps\">REST</span>-style parameter placeholders in curly braces\n  will be replaced with wildcards, e.g. the string &#8221;/resource/{resourceId}&#8221;\n  is interpreted as the RegExp <code>/\\/resource\\/\\{.*?\\}/</code>\n  <li><code>response</code> This can be either:\n    <ul>\n      <li>a string: This will be the response body, status code will be 200</li>\n      <li>an array containing the status code, a map of response headers and\n        the response text, e.g. <code>[200, { &#8220;Content-Type&#8221;: &#8220;text/html&#8221; }, &#8220;OK&#8221;]</code>\n      </li>\n      <li>a function: This will be called with a FakeXMLHttpRequest object as\n      the only argument. Its <code>respond</code> method must be called to send a response.\n      See <a href=\"http://sinonjs.org/docs/#respond\">Sinon.JS: Respond</a> for details.\n      </li>\n    </ul>\n  </li>\n</ul></p>","!type":"fn(responseData: +Map)"},"getFakeServer":{"!doc":"<p>Creates and configures a FakeServer if necessary and returns it.</p>","!type":"fn() -> Object"},"removeFilter":{"!doc":"<p>Remove a filter that was added with {@link #addFilter}</p>","!type":"fn(filter: fn())"},"removeResponse":{"!doc":"<p>Removes a response that was configured with {@link #configure}</p>","!type":"fn(method: string, url: string)"},"respondWith":{"!doc":"<p>Defines a fake <span class=\"caps\">XHR</span> response to a matching request.</p>","!type":"fn(method: string, urlRegExp: +RegExp, response: fn())"},"restore":{"!doc":"<p>Stops the FakeServer and removes all configured responses and/or filters.</p>","!type":"fn()"}}},"Environment":{"!doc":"<p>Module for querying information about the environment / runtime.\nIt adds a static key <code>env</code> to qxWeb and offers the given methods.</p>\n\n<pre class=\"javascript\">\nq.env.get(\"engine.name\"); // return \"webkit\" e.g.\n</pre>\n\n<p>The following values are predefined:</p>\n\n<ul>\n<li><code>browser.name</code> : The name of the browser</li>\n<li><code>browser.version</code> : The version of the browser</li>\n<li><code>browser.quirksmode</code>  : <code>true</code> if the browser is in quirksmode</li>\n<li><code>browser.documentmode</code> : The document mode of the browser</li>\n</ul>\n\n<ul>\n<li><code>device.name</code> : The name of the device e.g. <code>iPad</code>.</li>\n<li><code>device.type</code> : Either <code>desktop</code>, <code>tablet</code> or <code>mobile</code>.</li>\n</ul>\n\n<ul>\n<li><code>engine.name</code> : The name of the browser engine</li>\n<li><code>engine.version</code> : The version of the browser engine</li>\n</ul>\n\n<ul>\n<li><code>event.touch</code> : Checks if touch events are supported</li>\n<li><code>event.mspointer</code> : Checks if MSPointer events are available</li>\n</ul>","add":{"!doc":"<p>Adds a new environment setting which can be queried via {@link #get}.</p>","!type":"fn(key: string, value: Object) -> +qxWeb"},"get":{"!doc":"<p>Get the value stored for the given key.</p>","!type":"fn(key: string) -> Object"}},"event":{"GestureHandler":{"!doc":"<p>Creates a gesture handler that fires high-level events such as &#8220;swipe&#8221;\nbased on low-level event sequences on the given element</p>","register":{"!doc":"<p>Creates a gesture handler for the given element when a gesture event listener\nis attached to it</p>","!type":"fn(element: +Element, type: string)"},"unregister":{"!doc":"<p>Removes the gesture event handler from the element if there are no more\ngesture event listeners attached to it</p>","!type":"fn(element: +Element)"}},"Keyboard":{"!doc":"<p>Normalization for native keyboard events.</p>\n\n<p><span class=\"caps\">NOTE</span>: Some browsers won&#8217;t fire the <code>keypress</code> event for all keys.\nIt&#8217;s generally better to listen for <code>keyup</code> or <code>keydown</code>\ninstead.</p>","_inputFix":{"!doc":"<p>IE9 fix: Emits an &#8220;input&#8221; event if a text input element&#8217;s value was changed\nusing the Backspace key</p>","!type":"fn(ev: +Event)"},"getKeyIdentifier":{"!doc":"<p>Identifier of the pressed key. This property is modeled after the <em>KeyboardEvent.keyIdentifier</em> property\nof the W3C <span class=\"caps\">DOM</span> 3 event specification\n(<a href=\"http://www.w3.org/TR/2003/NOTE-DOM-Level-3-Events-20031107/events.html#Events-KeyboardEvent-keyIdentifier\">http://www.w3.org/TR/2003/NOTE-DOM-Level-3-Events-20031107/events.html#Events-KeyboardEvent-keyIdentifier</a>).</p>\n\n<p>Printable keys are represented by an unicode string, non-printable keys\nhave one of the following values:</p>\n\n<table>\n<tr><th>Backspace</th><td>The Backspace (Back) key.</td></tr>\n<tr><th>Tab</th><td>The Horizontal Tabulation (Tab) key.</td></tr>\n<tr><th>Space</th><td>The Space (Spacebar) key.</td></tr>\n<tr><th>Enter</th><td>The Enter key. Note: This key identifier is also used for the Return (Macintosh numpad) key.</td></tr>\n<tr><th>Shift</th><td>The Shift key.</td></tr>\n<tr><th>Control</th><td>The Control (Ctrl) key.</td></tr>\n<tr><th>Alt</th><td>The Alt (Menu) key.</td></tr>\n<tr><th>CapsLock</th><td>The CapsLock key</td></tr>\n<tr><th>Meta</th><td>The Meta key. (Apple Meta and Windows key)</td></tr>\n<tr><th>Escape</th><td>The Escape (Esc) key.</td></tr>\n<tr><th>Left</th><td>The Left Arrow key.</td></tr>\n<tr><th>Up</th><td>The Up Arrow key.</td></tr>\n<tr><th>Right</th><td>The Right Arrow key.</td></tr>\n<tr><th>Down</th><td>The Down Arrow key.</td></tr>\n<tr><th>PageUp</th><td>The Page Up key.</td></tr>\n<tr><th>PageDown</th><td>The Page Down (Next) key.</td></tr>\n<tr><th>End</th><td>The End key.</td></tr>\n<tr><th>Home</th><td>The Home key.</td></tr>\n<tr><th>Insert</th><td>The Insert (Ins) key. (Does not fire in Opera/Win)</td></tr>\n<tr><th>Delete</th><td>The Delete (Del) Key.</td></tr>\n<tr><th>F1</th><td>The F1 key.</td></tr>\n<tr><th>F2</th><td>The F2 key.</td></tr>\n<tr><th>F3</th><td>The F3 key.</td></tr>\n<tr><th>F4</th><td>The F4 key.</td></tr>\n<tr><th>F5</th><td>The F5 key.</td></tr>\n<tr><th>F6</th><td>The F6 key.</td></tr>\n<tr><th>F7</th><td>The F7 key.</td></tr>\n<tr><th>F8</th><td>The F8 key.</td></tr>\n<tr><th>F9</th><td>The F9 key.</td></tr>\n<tr><th>F10</th><td>The F10 key.</td></tr>\n<tr><th>F11</th><td>The F11 key.</td></tr>\n<tr><th>F12</th><td>The F12 key.</td></tr>\n<tr><th>NumLock</th><td>The Num Lock key.</td></tr>\n<tr><th>PrintScreen</th><td>The Print Screen (PrintScrn, SnapShot) key.</td></tr>\n<tr><th>Scroll</th><td>The scroll lock key</td></tr>\n<tr><th>Pause</th><td>The pause/break key</td></tr>\n<tr><th>Win</th><td>The Windows Logo key</td></tr>\n<tr><th>Apps</th><td>The Application key (Windows Context Menu)</td></tr>\n</table>","!type":"fn() -> string"},"normalize":{"!doc":"<p>Manipulates the native event object, adding methods if they&#8217;re not\nalready present</p>","!type":"fn(event: +Event, element: +Element) -> +Event"},"registerInputFix":{"!doc":"<p>IE9 will not fire an &#8220;input&#8221; event on text input elements if the user changes\nthe field&#8217;s value by pressing the Backspace key. We fix this by listening\nfor the &#8220;keyup&#8221; event and emitting the missing event if necessary</p>","!type":"fn(element: +Element)"},"unregisterInputFix":{"!doc":"<p>Removes the IE9 input event fix</p>","!type":"fn(element: +Element)"}},"Mouse":{"!doc":"<p>Normalization for native mouse events. For cross-device applications that\nsupport both mouse and touchscreen interaction, consider using\n<a href=\"#Pointer\">Pointer</a> and/or Gesture events (e.g. <a href=\"Tap\"></a>).</p>","getButton":{"!doc":"<p>Returns the identifier of the mouse button that change state when the\nevent was triggered</p>","!type":"fn() -> string"},"getDocumentLeft":{"!doc":"<p>Get the horizontal position at which the event occurred relative to the\nleft of the document. This property takes into account any scrolling of\nthe page.</p>","!type":"fn() -> number"},"getDocumentTop":{"!doc":"<p>Get the vertical position at which the event occurred relative to the\ntop of the document. This property takes into account any scrolling of\nthe page.</p>","!type":"fn() -> number"},"getScreenLeft":{"!doc":"<p>Get the horizontal coordinate at which the event occurred relative to\nthe origin of the screen coordinate system.</p>\n\n<p>Note: This value is usually not very useful unless you want to\nposition a native popup window at this coordinate.</p>","!type":"fn() -> number"},"getScreenTop":{"!doc":"<p>Get the vertical coordinate at which the event occurred relative to\nthe origin of the screen coordinate system.</p>\n\n<p>Note: This value is usually not very useful unless you want to\nposition a native popup window at this coordinate.</p>","!type":"fn() -> number"},"getViewportLeft":{"!doc":"<p>Get the horizontal coordinate at which the event occurred relative\nto the viewport.</p>","!type":"fn() -> number"},"getViewportTop":{"!doc":"<p>Get the vertical coordinate at which the event occurred relative\nto the viewport.</p>","!type":"fn() -> number"},"normalize":{"!doc":"<p>Manipulates the native event object, adding methods if they&#8217;re not\nalready present</p>","!type":"fn(event: +Event, element: +Element) -> +Event"}},"Native":{"!doc":"<p>Common normalizations for native events</p>","getCurrentTarget":{"!doc":"<p>Computes the current target from the native <span class=\"caps\">DOM</span> event. Emulates the current target\nfor all browsers without native support (like older IEs).</p>\n\n<p>Example:</p>\n\n<pre class=\"javascript\">\n  var collection = q(\"div.inline\");\n  collection.on(\"mouseout\", function(e) {\n    var current = e.getCurrentTarget();\n  });\n</pre>","!type":"fn() -> +Element"},"getRelatedTarget":{"!doc":"<p>Computes the related target from the native <span class=\"caps\">DOM</span> event</p>\n\n<p>Example:</p>\n\n<pre class=\"javascript\">\n  var collection = q(\"div.inline\");\n  collection.on(\"mouseout\", function(e) {\n    // when using 'mouseout' events the 'relatedTarget' is pointing to the DOM element\n    //  the device exited to.\n    // Useful for scenarios you only interested if e.g. the user moved away from a\n    // section at the website\n    var exitTarget = e.getRelatedTarget();\n  });\n\n  collection.on(\"mouseover\", function(e){\n     // when using 'mouseover' events the 'relatedTarget' is pointing to the DOM element\n     // the device entered from.\n     var earlierElement = e.getRelatedTarget();\n  });\n</pre>","!type":"fn() -> +Element"},"getTarget":{"!doc":"<p>Returns the target of the event.\nExample:</p>\n\n<pre class=\"javascript\">\n  var collection = q(\"div.inline\");\n  collection.on(\"click\", function(e) {\n    var clickedElement = e.getTarget();\n  });\n</pre>","!type":"fn() -> Object"},"getType":{"!doc":"<p>Returns the event&#8217;s type</p>","!type":"fn() -> string"},"normalize":{"!doc":"<p>Manipulates the native event object, adding methods if they&#8217;re not\nalready present</p>","!type":"fn(event: +Event, element: +Element) -> +Event"},"preventDefault":{"!doc":"<p>Prevent the native default behavior of the event.</p>","!type":"fn()"},"stopPropagation":{"!doc":"<p>Stops the event&#8217;s propagation to the element&#8217;s parent</p>","!type":"fn()"}},"Orientation":{"!doc":"<p>Normalization for orientationchange events\nExample:</p>\n\n<pre class=\"javascript\">\n  q(window).on(\"orientationchange\", function(ev) {\n    ev.getOrientation();\n    ev.isLandscape();\n  });\n</pre>","getOrientation":{"!doc":"<p>Returns the current orientation of the viewport in degrees.</p>\n\n<p>All possible values and their meaning:</p>\n\n<ul>\n<li><code>0</code>: &#8220;Portrait&#8221;</li>\n<li><code>-90</code>: &#8220;Landscape (right, screen turned clockwise)&#8221;</li>\n<li><code>90</code>: &#8220;Landscape (left, screen turned counterclockwise)&#8221;</li>\n<li><code>180</code>: &#8220;Portrait (upside-down portrait)&#8221;</li>\n</ul>","!type":"fn() -> number"},"isLandscape":{"!doc":"<p>Whether the viewport orientation is currently in landscape mode.</p>","!type":"fn() -> bool"},"isPortrait":{"!doc":"<p>Whether the viewport orientation is currently in portrait mode.</p>","!type":"fn() -> bool"},"normalize":{"!doc":"<p>Manipulates the native event object, adding methods if they&#8217;re not\nalready present</p>","!type":"fn(event: +Event, element: +Element, type: string) -> +Event"}},"OrientationHandler":{"!doc":"<p>Orientation handler which is responsible for registering and unregistering a\n{@link qx.event.handler.OrientationCore} handler for each given element.</p>","register":{"!doc":"<p>Creates an orientation handler for the given window when an\norientationchange event listener is attached to it</p>","!type":"fn(element: +Window)"},"unregister":{"!doc":"<p>Removes the orientation event handler from the element if there are no more\norientationchange event listeners attached to it</p>","!type":"fn(element: +Element)"}},"Pinch":{"!doc":"<p>Normalization for the pinch gesture.</p>","getScale":{"!doc":"<p>Returns the calculated scale of this event.</p>","!type":"fn() -> +Float"},"normalize":{"!doc":"<p>Manipulates the native event object, adding methods if they&#8217;re not\nalready present</p>","!type":"fn(event: +Event, element: +Element) -> +Event"}},"Pointer":{"!doc":"<p>Normalization for pointer events. Pointer events are hardware-agnostic and\nwill be fired regardless of which input type of input device is used (e.g. mouse or touchscreen).</p>","getDocumentLeft":{"!doc":"<p>Get the horizontal position at which the event occurred relative to the\nleft of the document. This property takes into account any scrolling of\nthe page.</p>","!type":"fn() -> number"},"getDocumentTop":{"!doc":"<p>Get the vertical position at which the event occurred relative to the\ntop of the document. This property takes into account any scrolling of\nthe page.</p>","!type":"fn() -> number"},"getPointerType":{"!doc":"<p>Returns the device type which the event triggered. This can be one\nof the following strings: <code>mouse</code>, <code>pen</code>\nor <code>touch</code>.</p>","!type":"fn() -> string"},"getScreenLeft":{"!doc":"<p>Get the horizontal coordinate at which the event occurred relative to\nthe origin of the screen coordinate system.</p>\n\n<p>Note: This value is usually not very useful unless you want to\nposition a native popup window at this coordinate.</p>","!type":"fn() -> number"},"getScreenTop":{"!doc":"<p>Get the vertical coordinate at which the event occurred relative to\nthe origin of the screen coordinate system.</p>\n\n<p>Note: This value is usually not very useful unless you want to\nposition a native popup window at this coordinate.</p>","!type":"fn() -> number"},"getViewportLeft":{"!doc":"<p>Get the horizontal coordinate at which the event occurred relative\nto the viewport.</p>","!type":"fn() -> number"},"getViewportTop":{"!doc":"<p>Get the vertical coordinate at which the event occurred relative\nto the viewport.</p>","!type":"fn() -> number"},"normalize":{"!doc":"<p>Manipulates the native event object, adding methods if they&#8217;re not\nalready present</p>","!type":"fn(event: +Event, element: +Element) -> +Event"}},"PointerHandler":{"register":{"!doc":"<p>Creates a pointer handler for the given element when a pointer event listener\nis attached to it</p>","!type":"fn(element: +Element, type: string)"},"unregister":{"!doc":"<p>Removes the pointer event handler from the element if there are no more\npointer event listeners attached to it</p>","!type":"fn(element: +Element)"}},"Rotate":{"!doc":"<p>Normalization for the rotate gesture.</p>","getAngle":{"!doc":"<p>Returns a number with the current calculated angle between the primary and secondary active pointers.</p>","!type":"fn() -> number"},"normalize":{"!doc":"<p>Manipulates the native event object, adding methods if they&#8217;re not\nalready present</p>","!type":"fn(event: +Event, element: +Element) -> +Event"}},"Swipe":{"!doc":"<p>Normalization for the swipe gesture. This gesture is based on <a href=\"#Pointer\">Pointer events</a>\nmeaning that it&#8217;s available on all devices, no matter which input device type is used (e.g. mouse or\ntouchscreen).</p>","getAxis":{"!doc":"<p>Returns whether the performed swipe was on the x or y axis.</p>","!type":"fn() -> string"},"getDirection":{"!doc":"<p>Returns the direction of the performed swipe in reference to the axis.\ny = up / down\nx = left / right</p>","!type":"fn() -> string"},"getDistance":{"!doc":"<p>Returns the distance of the performed swipe.</p>","!type":"fn() -> +Integer"},"getDuration":{"!doc":"<p>Returns the duration the performed swipe took.</p>","!type":"fn() -> +Integer"},"getStartTime":{"!doc":"<p>Returns the start time of the performed swipe.</p>","!type":"fn() -> +Integer"},"getVelocity":{"!doc":"<p>Returns the velocity of the performed swipe.</p>","!type":"fn() -> number"},"normalize":{"!doc":"<p>Manipulates the native event object, adding methods if they&#8217;re not\nalready present</p>","!type":"fn(event: +Event, element: +Element) -> +Event"}},"Tap":{"!doc":"<p>Normalization for tap gesture events. These gestures are based on <a href=\"#Pointer\">Pointer events</a>,\nmeaning that they are available on all devices, no matter which input device type is used (e.g. mouse or\ntouchscreen).</p>","getDocumentLeft":{"!doc":"<p>Get the horizontal position at which the event occurred relative to the\nleft of the document. This property takes into account any scrolling of\nthe page.</p>","!type":"fn() -> number"},"getDocumentTop":{"!doc":"<p>Get the vertical position at which the event occurred relative to the\ntop of the document. This property takes into account any scrolling of\nthe page.</p>","!type":"fn() -> number"},"getScreenLeft":{"!doc":"<p>Get the horizontal coordinate at which the event occurred relative to\nthe origin of the screen coordinate system.</p>\n\n<p>Note: This value is usually not very useful unless you want to\nposition a native popup window at this coordinate.</p>","!type":"fn() -> number"},"getScreenTop":{"!doc":"<p>Get the vertical coordinate at which the event occurred relative to\nthe origin of the screen coordinate system.</p>\n\n<p>Note: This value is usually not very useful unless you want to\nposition a native popup window at this coordinate.</p>","!type":"fn() -> number"},"getViewportLeft":{"!doc":"<p>Get the horizontal coordinate at which the event occurred relative\nto the viewport.</p>","!type":"fn() -> number"},"getViewportTop":{"!doc":"<p>Get the vertical coordinate at which the event occurred relative\nto the viewport.</p>","!type":"fn() -> number"},"normalize":{"!doc":"<p>Manipulates the native event object, adding methods if they&#8217;re not\nalready present</p>","!type":"fn(event: +Event, element: +Element) -> +Event"}},"Touch":{"!doc":"<p>Normalization for touch events. For cross-device applications that\nsupport both mouse and touchscreen interaction, consider using\n<a href=\"#Pointer\">Pointer</a> and/or Gesture events (e.g. <a href=\"Tap\"></a>).</p>","normalize":{"!doc":"<p>Manipulates the native event object, adding methods if they&#8217;re not\nalready present</p>","!type":"fn(event: +Event, element: +Element, type: string) -> +Event"}},"TouchHandler":{"!doc":"<p>Creates a touch event handler that fires high-level events such as &#8220;swipe&#8221;\nbased on low-level event sequences on the given element</p>","register":{"!doc":"<p>Creates a touch handler for the given element when a touch event listener\nis attached to it</p>","!type":"fn(element: +Element)"},"unregister":{"!doc":"<p>Removes the touch event handler from the element if there are no more\ntouch event listeners attached to it</p>","!type":"fn(element: +Element)"}},"Track":{"!doc":"<p>Normalization for the track gesture. This gesture is based on <a href=\"#Pointer\">Pointer events</a>,\nmeaning that it&#8217;s available on all devices, no matter which input device type is used (e.g. mouse or\ntouchscreen).</p>","getDelta":{"!doc":"<p>Returns a map with the calculated delta coordinates and axis,\nrelative to the position on <code>trackstart</code> event.</p>","!type":"fn() -> +Map"},"normalize":{"!doc":"<p>Manipulates the native event object, adding methods if they&#8217;re not\nalready present</p>","!type":"fn(event: +Event, element: +Element) -> +Event"}}},"Event":{"!doc":"<p>Support for native and custom events.</p>","$getHookRegistry":{"!doc":"<p>Returns all registered event hooks</p>","!type":"fn() -> +Map"},"$getRegistry":{"!doc":"<p>Returns all registered event normalizers</p>","!type":"fn() -> +Map"},"$registerEventHook":{"!doc":"<p>Registers an event hook for the given event types.</p>","!type":"fn(types: string, registerHook: fn(), unregisterHook?: fn())"},"$registerNormalization":{"!doc":"<p>Registers a normalization function for the given event types. Listener\ncallbacks for these types will be called with the return value of the\nnormalization function instead of the regular event object.</p>\n\n<p>The normalizer will be called with two arguments: The original event\nobject and the element on which the event was triggered</p>","!type":"fn(types: string, normalizer: fn())"},"$unregisterEventHook":{"!doc":"<p>Unregisters a hook from the given event types.</p>","!type":"fn(types: string, registerHook: fn(), unregisterHook?: fn())"},"$unregisterNormalization":{"!doc":"<p>Unregisters a normalization function from the given event types.</p>","!type":"fn(types: string, normalizer: fn())"},"allOff":{"!doc":"<p>Removes all event listeners (or all listeners for a given type) from the\ncollection.</p>","!type":"fn(type?: string) -> +qxWeb"},"copyEventsTo":{"!doc":"<p>Copies any event listeners that are attached to the elements in the\ncollection to the provided target element</p>","!type":"fn(target: +Element)"},"emit":{"!doc":"<p>Fire an event of the given type.</p>","!type":"fn(type: string, data?: Object) -> +qxWeb"},"hasListener":{"!doc":"<p>Checks if one or more listeners for the given event type are attached to\nthe first element in the collection</p>","!type":"fn(type: string, listener?: fn(), context?: Object) -> bool"},"hover":{"!doc":"<p>Bind one or two callbacks to the collection.\nIf only the first callback is defined the collection\ndoes react on &#8216;pointerover&#8217; only.</p>","!type":"fn(callbackIn: fn(), callbackOut?: fn()) -> +qxWeb"},"off":{"!doc":"<p>Unregisters event listeners for the given type from each element in the\ncollection.</p>","!type":"fn(type: string, listener: fn(), context?: Object, useCapture?: bool) -> +qxWeb"},"on":{"!doc":"<p>Registers a listener for the given event type on each item in the\ncollection. This can be either native or custom events.</p>","!type":"fn(type: string, listener: fn(), context?: Object, useCapture?: bool) -> +qxWeb"},"once":{"!doc":"<p>Attaches a listener for the given event that will be executed only once.</p>","!type":"fn(type: string, listener: fn(), context?: Object) -> +qxWeb"},"ready":{"!doc":"<p>Executes the given function once the document is ready.</p>","!type":"fn(callback: fn())"}},"Io":{"!doc":"<p>This module provides basic IO functionality. It contains three ways to load\ndata:</p>\n\n<ul>\n<li>XMLHttpRequest</li>\n<li>Script tag</li>\n<li>Script tag using <span class=\"caps\">JSONP</span></li>\n</ul>","jsonp":{"!doc":"<p>Returns a predefined script tag wrapper which can be used to load data\nfrom cross-domain origins via <span class=\"caps\">JSONP</span>.</p>","!type":"fn(url: string, settings?: +Map) -> +qx.bom.request.Jsonp"},"script":{"!doc":"<p>Returns a predefined script tag wrapper which can be used to load data\nfrom cross-domain origins.</p>","!type":"fn(url: string) -> +qx.bom.request.Script"},"xhr":{"!doc":"<p>Returns a configured XMLHttpRequest object. Using the send method will\nfinally send the request.</p>","!type":"fn(url: string, settings?: +Map) -> +qx.bom.request.Xhr"}},"Manipulating":{"!doc":"<p><span class=\"caps\">DOM</span> manipulation module</p>","__animateScroll":{"!doc":"<p>Performs animated scrolling</p>","!type":"fn(property: string, value: number, duration: number) -> +q"},"__getCollectionFromArgument":{"!doc":"<p>Creates a new collection from the given argument</p>","!type":"fn(arg: Object) -> +qxWeb"},"__getElementArray":{"!doc":"<p>Returns an array from a selector expression or a single element</p>","!type":"fn(arg: string) -> +Element"},"__getInnermostElement":{"!doc":"<p>Returns the innermost element of a <span class=\"caps\">DOM</span> tree as determined by a simple\ndepth-first search.</p>","!type":"fn(element: +Element) -> +Element"},"after":{"!doc":"<p>Inserts content after each element in the collection. This can either\nbe an <span class=\"caps\">HTML</span> string, an array of <span class=\"caps\">HTML</span> strings, a single <span class=\"caps\">DOM</span> element or an\narray of elements.</p>","!type":"fn(content: string) -> +qxWeb"},"append":{"!doc":"<p>Appends content to each element in the current set. Accepts an <span class=\"caps\">HTML</span> string,\na single <span class=\"caps\">DOM</span> element or an array of elements</p>","!type":"fn(html: string) -> +qxWeb"},"appendTo":{"!doc":"<p>Appends all items in the collection to the specified parents. If multiple\nparents are given, the items will be moved to the first parent, while\nclones of the items will be appended to subsequent parents.</p>","!type":"fn(parent: string) -> +qxWeb"},"before":{"!doc":"<p>Inserts content before each element in the collection. This can either\nbe an <span class=\"caps\">HTML</span> string, an array of <span class=\"caps\">HTML</span> strings, a single <span class=\"caps\">DOM</span> element or an\narray of elements.</p>","!type":"fn(content: string) -> +qxWeb"},"blur":{"!doc":"<p>Blurs each element in the collection</p>","!type":"fn() -> +qxWeb"},"clone":{"!doc":"<p>Clones the items in the current collection and returns them in a new set.\nEvent listeners can also be cloned.</p>","!type":"fn(events: bool) -> +qxWeb"},"create":{"!doc":"<p>Creates a new collection from the given argument. This can either be an\n<span class=\"caps\">HTML</span> string, a single <span class=\"caps\">DOM</span> element or an array of elements</p>\n\n<p>When no <code>context</code> is given the global document is used to\ncreate new <span class=\"caps\">DOM</span> elements.</p>\n\n<strong>Note:</strong> When a complex HTML string is provided the <code>innerHTML</code>\nmechanism of the browser is used. Some browsers do filter out elements like <code>&lt;html&gt;</code>,\n<code>&lt;head&gt;</code> or <code>&lt;body&gt;</code>. The better approach is to create\na single element and the appending the child nodes like in the example below.","!type":"fn(html: string, context?: +Document) -> +qxWeb"},"empty":{"!doc":"<p>Removes all content from the elements in the collection</p>","!type":"fn() -> +qxWeb"},"focus":{"!doc":"<p>Focuses the first element in the collection</p>","!type":"fn() -> +qxWeb"},"getScrollLeft":{"!doc":"<p>Returns the left scroll position of the first element in the collection.</p>","!type":"fn() -> number"},"getScrollTop":{"!doc":"<p>Returns the top scroll position of the first element in the collection.</p>","!type":"fn() -> number"},"insertAfter":{"!doc":"<p>Inserts the current collection after each target item. The collection\nitems are moved after the first target. For subsequent targets,\nclones of the collection items are created and inserted.</p>","!type":"fn(target: string) -> +qxWeb"},"insertBefore":{"!doc":"<p>Inserts the current collection before each target item. The collection\nitems are moved before the first target. For subsequent targets,\nclones of the collection items are created and inserted.</p>","!type":"fn(target: string) -> +qxWeb"},"remove":{"!doc":"<p>Removes each element in the current collection from the <span class=\"caps\">DOM</span></p>","!type":"fn() -> +qxWeb"},"setScrollLeft":{"!doc":"<p>Scrolls the elements of the collection to the given coordinate.</p>","!type":"fn(value: number, duration?: number) -> +qxWeb"},"setScrollTop":{"!doc":"<p>Scrolls the elements of the collection to the given coordinate.</p>","!type":"fn(value: number, duration?: number) -> +qxWeb"},"wrap":{"!doc":"<p>Wraps each element in the collection in a copy of an <span class=\"caps\">HTML</span> structure.\nElements will be appended to the deepest nested element in the structure\nas determined by a depth-first search.</p>","!type":"fn(wrapper: string) -> +qxWeb"}},"MatchMedia":{"!doc":"<p>Module for mediaqueries evaluation. The module is a wrapper for media.match.js,\nthat implements a polyfill for window.matchMedia when it&#8217;s not supported natively.</p>","__applyClass":{"!doc":"<p>Adds or removes a class depending on matching a given media query</p>","!type":"fn(query: +undefined, className: +undefined)"},"addSizeClasses":{"!doc":"<p>Adds pre-defined media queries</p>","!type":"fn()"},"matchMedia":{"!doc":"<p>Evaluates the specified mediaquery list</p>","!type":"fn(query: string, ctxWindow?: Object) -> +qx.bom.MediaQuery"},"mediaQueryToClass":{"!doc":"<p>Maps a class to a html element  media query</p>","!type":"fn(queryString: +undefined, className: +undefined, contextWindow: +undefined)"}},"Messaging":{"!doc":"<p>Define messages to react on certain channels.</p>\n\n<p>The channel names will be used in the q.messaging.on method to define handlers which will\nbe called on certain channels and routes. The q.messaging.emit method can be used\nto execute a given route on a channel. q.messaging.onAny defines a handler on any channel.</p>","emit":{"!doc":"<p>Sends a message on the given channel and informs all matching route handlers.</p>","!type":"fn(channel: string, path: string, params: +Map, customData: Object)"},"on":{"!doc":"<p>Adds a route handler for the given channel. The route is called\nif the {@link #emit} method finds a match.</p>","!type":"fn(channel: string, type: string, handler: fn(), scope?: Object) -> string"},"onAny":{"!doc":"<p>Adds a handler for the &#8220;any&#8221; channel. The &#8220;any&#8221; channel is called\nbefore all other channels.</p>","!type":"fn(type: string, handler: fn(), scope?: Object) -> string"},"remove":{"!doc":"<p>Removes a registered listener by the given id.</p>","!type":"fn(id: string)"}},"Placeholder":{"!doc":"<p>The module supplies a fallback implementation for placeholders, which is\nused on input and textarea elements. If the browser supports native placeholders\nthe <span class=\"caps\">API</span> silently ignores all calls. If not, an element will be created for every\ngiven input element and acts as placeholder. Most modern browsers support\nplaceholders which makes the fallback only relevant for IE < 10 and FF < 4.</p>\n\n<ul>\n<li><a href=\"http://dev.w3.org/html5/spec/single-page.html#the-placeholder-attribute\"><span class=\"caps\">HTML</span> Spec</a></li>\n</ul>\n\n<ul>\n<li><a href=\"http://caniuse.com/#feat=input-placeholder\">Browser Support</a></li>\n</ul>","__createPlaceholderElement":{"!doc":"<p>Creates a placeholder element based on the given input element.</p>","!type":"fn(item: +qxWeb) -> +qxWeb"},"__syncStyles":{"!doc":"<p>Internal helper method to update the styles for a given input element.</p>","!type":"fn(item: +qxWeb)"},"update":{"!doc":"<p>Queries for all input and textarea elements on the page and updates\ntheir placeholder.</p>","!type":"fn()"},"updatePlaceholder":{"!doc":"<p>Updates the placeholders for input&#8217;s and textarea&#8217;s in the collection.\nThis includes positioning, styles and <span class=\"caps\">DOM</span> positioning.\nIn case the browser supports native placeholders, this methods simply\ndoes nothing.</p>","!type":"fn() -> +qxWeb"}},"Placement":{"!doc":"<p>The Placement module provides a convenient way to align two elements relative\nto each other using various pre-defined algorithms.</p>","_computePlacement":{"!doc":"<p>Returns the computed coordinates for the element to be placed</p>","!type":"fn(axes: +Map, size: +Map, area: +Map, target: +Map, offsets: +Map, position: +Map) -> +Map"},"_getAxis":{"!doc":"<p>Returns the appropriate axis implementation for the given placement\nmode</p>","!type":"fn(mode: string) -> Object"},"_getPositionX":{"!doc":"<p>Returns the X axis positioning type for the given edge and alignment\nvalues</p>","!type":"fn(edge: string, align: string) -> string"},"_getPositionY":{"!doc":"<p>Returns the Y axis positioning type for the given edge and alignment\nvalues</p>","!type":"fn(edge: string, align: string) -> string"},"placeTo":{"!doc":"<p>Moves the first element in the collection, aligning it with the given\ntarget.</p>\n\n<div>\n<strong>NOTE:</strong> The <code>placeTo</code> method also works for hidden\nelements. However, the visibility / display styles are only manipulated during\nthe placement operation. As a result a previously hidden element <strong>stays hidden</strong>\n</div>\n\n<div>\n<strong>NOTE:</strong> If the target is changing its position due e.g. a DOM manipulation the\nplaced element <strong>is not</strong> updated automatically. You have to call <code>placeTo</code>\nagain to place the element to the target. The element is <strong>always</strong> positioned by using\n<code>position:absolute</code> independently on the chosen <code>position</code> and <code>mode</code>.\n</div>","!type":"fn(target: +Element, position: string, offsets?: +Map, modeX?: string, modeY?: string) -> +qxWeb"}},"Polyfill":{"!doc":"<p>Adds JavaScript features that may not be supported by all clients.</p>"},"Rest":{"!doc":"<p>This modules eases the communication with a RESTful web service by providing\na client-side wrapper of a <span class=\"caps\">REST</span> resource.</p>\n\n<p>See {@link qx.bom.rest.Resource}.</p>","resource":{"!type":"fn(description?: +Map) -> +qx.bom.rest.Resource"}},"Storage":{"!doc":"<p>This module offers a cross browser storage implementation. The <span class=\"caps\">API</span> is aligned\nwith the <span class=\"caps\">API</span> of the <span class=\"caps\">HTML</span> web storage (<a href=\"http://www.w3.org/TR/webstorage/\">http://www.w3.org/TR/webstorage/</a>) which is\nalso the preferred implementation used. As fallback for IE < 8, we use user data.\nIf both techniques are unsupported, we supply a in memory storage, which is\nof course, not persistent.</p>","clearLocal":{"!doc":"<p>Deletes every stored item in the storage.</p>","!type":"fn()"},"clearSession":{"!doc":"<p>Deletes every stored item in the storage.</p>","!type":"fn()"},"forEachLocal":{"!doc":"<p>Helper to access every stored item.</p>","!type":"fn(callback: fn(), scope: Object)"},"forEachSession":{"!doc":"<p>Helper to access every stored item.</p>","!type":"fn(callback: fn(), scope: Object)"},"getLocalItem":{"!doc":"<p>Returns the stored item.</p>","!type":"fn(key: string) -> Object"},"getLocalKey":{"!doc":"<p>Returns the named key at the given index.</p>","!type":"fn(index: number) -> string"},"getLocalLength":{"!doc":"<p>Returns the amount of key-value pairs stored.</p>","!type":"fn() -> number"},"getSessionItem":{"!doc":"<p>Returns the stored item.</p>","!type":"fn(key: string) -> Object"},"getSessionKey":{"!doc":"<p>Returns the named key at the given index.</p>","!type":"fn(index: number) -> string"},"getSessionLength":{"!doc":"<p>Returns the amount of key-value pairs stored.</p>","!type":"fn() -> number"},"removeLocalItem":{"!doc":"<p>Removes an item form the storage.</p>","!type":"fn(key: string)"},"removeSessionItem":{"!doc":"<p>Removes an item form the storage.</p>","!type":"fn(key: string)"},"setLocalItem":{"!doc":"<p>Store an item in the storage.</p>","!type":"fn(key: string, value: Object)"},"setSessionItem":{"!doc":"<p>Store an item in the storage.</p>","!type":"fn(key: string, value: Object)"}},"Template":{"!doc":"<p><span class=\"caps\">HTML</span> templating module. This is a wrapper for mustache.js which is a\n&#8220;framework-agnostic way to render logic-free views&#8221;.</p>\n\n<p>Here is a basic example how to use it:</p>\n\n<pre class=\"javascript\">\nvar template = \"Hi, my name is {{name}}!\";\nvar view = {name: \"qooxdoo\"};\nq.template.render(template, view);\n  // return \"Hi, my name is qooxdoo!\"\n</pre>\n\n<p>For further details, please visit the mustache.js documentation here:\n  <a href=\"https://github.com/janl/mustache.js/blob/master/README.md\">https://github.com/janl/mustache.js/blob/master/README.md</a></p>","__wrap":{"!doc":"<p>If the given node is a <span class=\"caps\">DOM</span> text node, wrap it in a span element and return\nthe wrapper.</p>","!type":"fn(el: +Node) -> +Element"},"get":{"!doc":"<p>Helper method which provides direct access to templates stored as <span class=\"caps\">HTML</span> in\nthe <span class=\"caps\">DOM</span>. The <span class=\"caps\">DOM</span> node with the given ID will be treated as a template,\nparsed and a new <span class=\"caps\">DOM</span> element will be returned containing the parsed data.\nKeep in mind that templates can only have one root element.\nAdditionally, you should not put the template into a regular, hidden\n<span class=\"caps\">DOM</span> element because the template may not be valid <span class=\"caps\">HTML</span> due to the containing\nmustache tags. We suggest to put it into a script tag with the type\n<code>text/template</code>.</p>","!type":"fn(id: string, view: Object, partials: Object) -> +qxWeb"},"render":{"!doc":"<p>Original and only template method of mustache.js. For further\ndocumentation, please visit <a href=\"https://github.com/janl/mustache.js\">mustache.js</a>.</p>","!type":"fn(template: string, view: Object, partials: Object) -> string"},"renderToNode":{"!doc":"<p>Combines {@link #render} and {@link #get}. Input is equal to {@link #render}\nand output is equal to {@link #get}. The advantage over {@link #get}\nis that you don&#8217;t need a <span class=\"caps\">HTML</span> template but can use a template\nstring and still get a collection. Keep in mind that templates\ncan only have one root element.</p>","!type":"fn(template: string, view: Object, partials: Object) -> +qxWeb"}},"TextSelection":{"!doc":"<p>Text selection manipulation module</p>","__getTextNode":{"!doc":"<p>Returns the first text child node of the given element</p>","!type":"fn(el: +Element) -> +Node"},"__isInput":{"!doc":"<p>Checks if the given <span class=\"caps\">DOM</span> node is a text input field or textarea</p>","!type":"fn(el: +Element) -> bool"},"clearTextSelection":{"!doc":"<p>Clears the text selection of all elements.</p>","!type":"fn() -> +qxWeb"},"getTextSelection":{"!doc":"<p>Get the text selection of the first element.</p>","!type":"fn() -> string"},"getTextSelectionEnd":{"!doc":"<p>Get the end of the text selection of the first element.</p>","!type":"fn() -> +Integer"},"getTextSelectionLength":{"!doc":"<p>Get the length of the text selection of the first element.</p>","!type":"fn() -> +Integer"},"getTextSelectionStart":{"!doc":"<p>Get the start of the text selection of the first element.</p>","!type":"fn() -> +Integer"},"setTextSelection":{"!doc":"<p>Set the text selection of the first element in the collection\nwith the given start and end value.\nIf no end value is passed the selection will extend to the end.</p>","!type":"fn(start: +Integer, end: +Integer) -> +qxWeb"}},"Transform":{"!doc":"<p>This class is responsible for applying CSS3 transforms to the collection.\nThe implementation is mostly a cross browser wrapper for applying the\ntransforms.\nThe <span class=\"caps\">API</span> is keep to the spec as close as possible.</p>\n\n<p><a href=\"http://www.w3.org/TR/css3-3d-transforms/\">http://www.w3.org/TR/css3-3d-transforms/</a></p>","getTransformBackfaceVisibility":{"!doc":"<p>Returns the backface-visibility property of the first element.</p>\n\n<p>Spec: <a href=\"http://www.w3.org/TR/css3-3d-transforms/#backface-visibility-property\">http://www.w3.org/TR/css3-3d-transforms/#backface-visibility-property</a></p>","!type":"fn() -> bool"},"getTransformOrigin":{"!doc":"<p>Returns the transform-origin property of the first element.</p>\n\n<p>Spec: <a href=\"http://www.w3.org/TR/css3-3d-transforms/#transform-origin-property\">http://www.w3.org/TR/css3-3d-transforms/#transform-origin-property</a></p>","!type":"fn() -> string"},"getTransformPerspective":{"!doc":"<p>Returns the perspective property of the first element.</p>\n\n<p>Spec: <a href=\"http://www.w3.org/TR/css3-3d-transforms/#perspective-property\">http://www.w3.org/TR/css3-3d-transforms/#perspective-property</a></p>","!type":"fn() -> string"},"getTransformPerspectiveOrigin":{"!doc":"<p>Returns the perspective-origin property of the first element.</p>\n\n<p>Spec: <a href=\"http://www.w3.org/TR/css3-3d-transforms/#perspective-origin-property\">http://www.w3.org/TR/css3-3d-transforms/#perspective-origin-property</a></p>","!type":"fn() -> string"},"getTransformStyle":{"!doc":"<p>Returns the transform-style property of the first element.</p>\n\n<p>Spec: <a href=\"http://www.w3.org/TR/css3-3d-transforms/#transform-style-property\">http://www.w3.org/TR/css3-3d-transforms/#transform-style-property</a></p>","!type":"fn() -> string"},"rotate":{"!doc":"<p>Rotates by the given value. For further details, take\na look at the {@link #transform} method.</p>","!type":"fn(value: string) -> +qxWeb"},"scale":{"!doc":"<p>Scales by the given value. For further details, take\na look at the {@link #transform} method.</p>","!type":"fn(value: number) -> +qxWeb"},"setTransformBackfaceVisibility":{"!doc":"<p>Sets the backface-visibility property.</p>\n\n<p>Spec: <a href=\"http://www.w3.org/TR/css3-3d-transforms/#backface-visibility-property\">http://www.w3.org/TR/css3-3d-transforms/#backface-visibility-property</a></p>","!type":"fn(value: bool) -> +qxWeb"},"setTransformOrigin":{"!doc":"<p>Sets the transform-origin property.</p>\n\n<p>Spec: <a href=\"http://www.w3.org/TR/css3-3d-transforms/#transform-origin-property\">http://www.w3.org/TR/css3-3d-transforms/#transform-origin-property</a></p>","!type":"fn(value: string) -> +qxWeb"},"setTransformPerspective":{"!doc":"<p>Sets the perspective property.</p>\n\n<p>Spec: <a href=\"http://www.w3.org/TR/css3-3d-transforms/#perspective-property\">http://www.w3.org/TR/css3-3d-transforms/#perspective-property</a></p>","!type":"fn(value: number) -> +qxWeb"},"setTransformPerspectiveOrigin":{"!doc":"<p>Sets the perspective-origin property.</p>\n\n<p>Spec: <a href=\"http://www.w3.org/TR/css3-3d-transforms/#perspective-origin-property\">http://www.w3.org/TR/css3-3d-transforms/#perspective-origin-property</a></p>","!type":"fn(value: string) -> +qxWeb"},"setTransformStyle":{"!doc":"<p>Sets the transform-style property.</p>\n\n<p>Spec: <a href=\"http://www.w3.org/TR/css3-3d-transforms/#transform-style-property\">http://www.w3.org/TR/css3-3d-transforms/#transform-style-property</a></p>","!type":"fn(value: string) -> +qxWeb"},"skew":{"!doc":"<p>Skews by the given value. For further details, take\na look at the {@link #transform} method.</p>","!type":"fn(value: string) -> +qxWeb"},"transform":{"!doc":"<p>Method to apply multiple transforms at once to the given element. It\ntakes a map containing the transforms you want to apply plus the values\ne.g.<code>{scale: 2, rotate: &#8220;5deg&#8221;}</code>.\nThe values can be either singular, which means a single value will\nbe added to the <span class=\"caps\">CSS</span>. If you give an array, the values will be split up\nand each array entry will be used for the X, Y or Z dimension in that\norder e.g. <code>{scale: [2, 0.5]}</code> will result in a element\ndouble the size in X direction and half the size in Y direction.\nMake sure your browser supports all transformations you apply.</p>","!type":"fn(transforms: +Map) -> +qxWeb"},"translate":{"!doc":"<p>Translates by the given value. For further details, take\na look at the {@link #transform} method.</p>","!type":"fn(value: string) -> +qxWeb"}},"Traversing":{"!doc":"<p><span class=\"caps\">DOM</span> traversal module</p>","__getAncestors":{"!doc":"<p>Internal helper for getAncestors and getAncestorsUntil</p>","!type":"fn(selector: string, filter?: string) -> +qxWeb"},"__getAttributes":{"!doc":"<p>Returns a map containing the given <span class=\"caps\">DOM</span> node&#8217;s attribute names\nand values</p>","!type":"fn(node: +Node) -> +Map"},"__getElementFromArgument":{"!doc":"<p>Helper which returns the element from the given argument. If it&#8217;s a collection,\nit returns it&#8217;s first child. If it&#8217;s a string, it tries to use the string\nas selector and returns the first child of the new collection.</p>","!type":"fn(arg: +Node) -> +Node"},"__getNodeFromArgument":{"!doc":"<p>Helper that attempts to convert the given argument into a <span class=\"caps\">DOM</span> node</p>","!type":"fn(arg: Object) -> +Node"},"__hierarchyHelper":{"!doc":"<p>Helper function that iterates over a set of items and applies the given\nqx.dom.Hierarchy method to each entry, storing the results in a new Array.\nDuplicates are removed and the items are filtered if a selector is\nprovided.</p>","!type":"fn(collection: +Array, method: string, selector?: string) -> +Array"},"add":{"!doc":"<p>Adds an element to the collection</p>","!type":"fn(el: +Element) -> +qxWeb"},"contains":{"!doc":"<p>Returns a new collection containing only those nodes that\ncontain the given element. Also accepts a qxWeb\ncollection or an Array of elements. In those cases, the first element\nin the list is used.</p>","!type":"fn(element: +Element) -> +qxWeb"},"eq":{"!doc":"<p>Reduce the set of matched elements to a single element.</p>","!type":"fn(index: number) -> +qxWeb"},"equalNodes":{"!doc":"<p>Determines if two <span class=\"caps\">DOM</span> nodes are equal as defined in the\n<a href=\"http://www.w3.org/TR/DOM-Level-3-Core/core.html#Node3-isEqualNode\"><span class=\"caps\">DOM</span> Level 3 isEqualNode spec</a>.\nAlso works in legacy browsers without native <em>isEqualNode</em> support.</p>","!type":"fn(node1: string, node2: string) -> bool"},"find":{"!doc":"<p>Searches the child elements of each item in the collection and returns\na new collection containing the children that match the provided selector</p>","!type":"fn(selector: string) -> +qxWeb"},"forEach":{"!doc":"<p>Executes the provided callback function once for each item in the\ncollection.</p>","!type":"fn(fn: fn(), ctx: Object) -> +qxWeb"},"getAncestors":{"!doc":"<p>Gets a set of elements containing all ancestors of each element in the\ncollection.\nThis set can be filtered with an optional expression that will cause only\nelements matching the selector to be collected.</p>","!type":"fn(filter?: string) -> +qxWeb"},"getAncestorsUntil":{"!doc":"<p>Gets a set of elements containing all ancestors of each element in the\ncollection, up to (but not including) the element matched by the provided\nselector.\nThis set can be filtered with an optional expression that will cause only\nelements matching the selector to be collected.</p>","!type":"fn(selector: string, filter?: string) -> +qxWeb"},"getChildren":{"!doc":"<p>Gets a set of elements containing all of the unique immediate children of\neach of the matched set of elements.\nThis set can be filtered with an optional expression that will cause only\nelements matching the selector to be collected.</p>","!type":"fn(selector?: string) -> +qxWeb"},"getClosest":{"!doc":"<p>Gets a set containing the closest matching ancestor for each item in\nthe collection.\nIf the item itself matches, it is added to the new set. Otherwise, the\nitem&#8217;s parent chain will be traversed until a match is found.</p>","!type":"fn(selector: string) -> +qxWeb"},"getContents":{"!doc":"<p>Gets a new set of elements containing the child nodes of each item in the\ncurrent set.</p>","!type":"fn() -> +qxWeb"},"getDocument":{"!doc":"<p>Returns the owner document of the given node</p>","!type":"fn(selector: +Node) -> +Document"},"getFirst":{"!doc":"<p>Reduces the collection to the first element.</p>","!type":"fn() -> +qxWeb"},"getLast":{"!doc":"<p>Reduces the collection to the last element.</p>","!type":"fn() -> +qxWeb"},"getNext":{"!doc":"<p>Gets a collection containing the next sibling element of each item in\nthe current set.\nThis set can be filtered with an optional expression that will cause only\nelements matching the selector to be collected.</p>","!type":"fn(selector?: string) -> +qxWeb"},"getNextAll":{"!doc":"<p>Gets a collection containing all following sibling elements of each\nitem in the current set.\nThis set can be filtered with an optional expression that will cause only\nelements matching the selector to be collected.</p>","!type":"fn(selector?: string) -> +qxWeb"},"getNextUntil":{"!doc":"<p>Gets a collection containing the following sibling elements of each\nitem in the current set up to but not including any element that matches\nthe given selector.</p>","!type":"fn(selector?: string) -> +qxWeb"},"getNodeName":{"!doc":"<p>Get the <span class=\"caps\">DOM</span> node&#8217;s name as a lowercase string</p>","!type":"fn(selector: +Node) -> string"},"getNodeText":{"!doc":"<p>Returns the text content of a node where the node type may be one of\nNODE_ELEMENT, NODE_ATTRIBUTE, NODE_TEXT, NODE_CDATA</p>","!type":"fn(selector: +Node) -> string"},"getOffsetParent":{"!doc":"<p>Gets a new collection containing the offset parent of each item in the\ncurrent set.</p>","!type":"fn() -> +qxWeb"},"getParents":{"!doc":"<p>Gets a set of elements containing the parent of each element in the\ncollection.\nThis set can be filtered with an optional expression that will cause only\nelements matching the selector to be collected.</p>","!type":"fn(selector?: string) -> +qxWeb"},"getPrev":{"!doc":"<p>Gets a collection containing the previous sibling element of each item in\nthe current set.\nThis set can be filtered with an optional expression that will cause only\nelements matching the selector to be collected.</p>","!type":"fn(selector?: string) -> +qxWeb"},"getPrevAll":{"!doc":"<p>Gets a collection containing all preceding sibling elements of each\nitem in the current set.\nThis set can be filtered with an optional expression that will cause only\nelements matching the selector to be collected.</p>","!type":"fn(selector?: string) -> +qxWeb"},"getPrevUntil":{"!doc":"<p>Gets a collection containing the preceding sibling elements of each\nitem in the current set up to but not including any element that matches\nthe given selector.</p>","!type":"fn(selector?: string) -> +qxWeb"},"getSiblings":{"!doc":"<p>Gets a collection containing all sibling elements of the items in the\ncurrent set.\nThis set can be filtered with an optional expression that will cause only\nelements matching the selector to be collected.</p>","!type":"fn(selector?: string) -> +qxWeb"},"getWindow":{"!doc":"<p>Returns the DOM2 <code>defaultView</code> (window) for the given node.</p>","!type":"fn(selector: +Node) -> +Window"},"has":{"!doc":"<p>Gets a collection containing only the elements that have descendants\nmatching the given selector</p>","!type":"fn(selector: string) -> +qxWeb"},"is":{"!doc":"<p>Checks if at least one element in the collection passes the provided\nfilter. This can be either a selector expression or a filter\nfunction</p>","!type":"fn(selector: string) -> bool"},"isBlockNode":{"!doc":"<p>Checks if the given node is a block node</p>","!type":"fn(selector: +Node) -> bool"},"isChildOf":{"!doc":"<p>Checks if any element of the current collection is child of any element of a given\nparent collection.</p>","!type":"fn(parent: +qxWeb) -> bool"},"isDocument":{"!doc":"<p>Checks if the given object is a <span class=\"caps\">DOM</span> document object</p>","!type":"fn(node: Object) -> bool"},"isDocumentFragment":{"!doc":"<p>Checks if the given object is a <span class=\"caps\">DOM</span> document fragment object</p>","!type":"fn(node: Object) -> bool"},"isElement":{"!doc":"<p>Checks if the given object is a <span class=\"caps\">DOM</span> element</p>","!type":"fn(selector: Object) -> bool"},"isNode":{"!doc":"<p>Checks if the given object is a <span class=\"caps\">DOM</span> node</p>","!type":"fn(selector: +Node) -> bool"},"isNodeName":{"!doc":"<p>Whether the node has the given node name</p>","!type":"fn(selector: +Node, nodeName: string) -> bool"},"isRendered":{"!doc":"<p>Whether the first element in the collection is inserted into\nthe document for which it was created.</p>","!type":"fn() -> bool"},"isTextNode":{"!doc":"<p>Checks whether the given object is a <span class=\"caps\">DOM</span> text node</p>","!type":"fn(obj: Object) -> bool"},"isWindow":{"!doc":"<p>Check whether the given object is a browser window object.</p>","!type":"fn(obj: Object) -> bool"},"not":{"!doc":"<p>Remove elements from the collection that do not pass the given filter.\nThis can be either a selector expression or a filter function</p>","!type":"fn(selector: string) -> +qxWeb"}},"util":{"Array":{"!doc":"<p>Utility module to give some support to work with arrays.</p>","cast":{"!doc":"<p>Converts an array like object to any other array like\nobject.</p>\n\n<p>Attention: The returned array may be same\ninstance as the incoming one if the constructor is identical!</p>","!type":"fn(object: Object, constructor: fn(), offset?: number) -> +Array"},"equals":{"!doc":"<p>Check whether the two arrays have the same content. Checks only the\nequality of the arrays&#8217; content.</p>","!type":"fn(arr1: +Array, arr2: +Array) -> bool"},"exclude":{"!doc":"<p>Modifies the first array as it removes all elements\nwhich are listed in the second array as well.</p>","!type":"fn(arr1: +Array, arr2: +Array) -> +Array"},"fromArguments":{"!doc":"<p>Convert an arguments object into an array.</p>","!type":"fn(args: +arguments, offset?: number) -> +Array"},"insertAfter":{"!doc":"<p>Insert an element into the array after a given second element.</p>","!type":"fn(arr: +Array, obj: Object, obj2: Object) -> +Array"},"insertBefore":{"!doc":"<p>Insert an element into the array before a given second element.</p>","!type":"fn(arr: +Array, obj: Object, obj2: Object) -> +Array"},"max":{"!doc":"<p>Returns the highest value in the given array. Supports\nnumeric values only.</p>","!type":"fn(arr: +Array) -> number"},"min":{"!doc":"<p>Returns the lowest value in the given array. Supports\nnumeric values only.</p>","!type":"fn(arr: +Array) -> number"},"remove":{"!doc":"<p>Remove an element from the array.</p>","!type":"fn(arr: +Array, obj: Object) -> Object"},"removeAll":{"!doc":"<p>Remove all elements from the array</p>","!type":"fn(arr: +Array) -> +Array"},"unique":{"!doc":"<p>Recreates an array which is free of all duplicate elements from the original.\nThis method do not modifies the original array!\nKeep in mind that this methods deletes undefined indexes.</p>","!type":"fn(arr: +Array) -> +Array"}},"Function":{"!doc":"<p>Utility module to give some support to work with functions.</p>","debounce":{"!doc":"<p>Returns a debounced version of the given callback. The execution of the callback\nis delayed by the given delay and after no events were triggered anymore.\nThis mechanism is very useful for event handling: only after a specified delay\nthe event should be handled (e.g. at keyboard input by the user) to prevent flooding\nthe handler with a large amounts of events.</p>","!type":"fn(callback: fn(), delay: number, immediate: bool) -> fn()"},"throttle":{"!doc":"<p>Returns a throttled version of the given callback. The execution of the callback\nis throttled which means it is only executed in the given interval.\nThis mechanism is very useful for event handling: only in specified intervals\nthe event should be handled (e.g. at resize of the browser window) to prevent flooding\nthe handler with a large amounts of events.\nAs default the <code>leading</code> and <code>trailing</code> calls are executed.</p>","!type":"fn(callback: fn(), interval: number, options: +Map) -> fn()"}},"Object":{"!doc":"<p>Helper functions to handle an Object as a Hash map.</p>","clone":{"!doc":"<p>Return a copy of an Object</p>","!type":"fn(source: Object, deep: bool) -> Object"},"contains":{"!doc":"<p>Whether the map contains the given value.</p>","!type":"fn(map: Object, value: Object) -> bool"},"getValues":{"!doc":"<p>Get the values of a map as array</p>","!type":"fn(map: Object) -> +Array"},"invert":{"!doc":"<p>Inverts a map by exchanging the keys with the values.</p>","!type":"fn(map: Object) -> Object"}},"String":{"!doc":"<p>Utility module to give some support to work with strings.</p>\n\n<p><strong>Info:</strong> The</p>\n\n<pre class=\"javascript\">trim</pre>\n\n<p>method is available as <a href=\"#String\">Polyfill</a>.</p>","camelCase":{"!doc":"<p>Converts a hyphenated string (separated by &#8217;-&#8217;) to camel case.</p>\n\n<p>Example:</p>\n\n<pre class=\"javascript\">q.string.camelCase(\"I-like-cookies\"); //returns \"ILikeCookies\"</pre>","!type":"fn(str: string) -> string"},"endsWith":{"!doc":"<p>Check whether the string ends with the given substring.</p>","!type":"fn(fullstr: string, substr: string) -> bool"},"escapeHtml":{"!doc":"<p>Escapes the characters in a <code>String</code> using <span class=\"caps\">HTML</span> entities.</p>\n\n<p>For example: <tt>&#8220;bread&#8221; &amp; &#8220;butter&#8221;</tt> => <tt>&amp;quot;bread&amp;quot; &amp;amp; &amp;quot;butter&amp;quot;</tt>.\nSupports all known <span class=\"caps\">HTML</span> 4.0 entities, including funky accents.</p>","!type":"fn(str: string) -> string"},"escapeRegexpChars":{"!doc":"<p>Escapes all chars that have a special meaning in regular expressions.</p>","!type":"fn(str: string) -> string"},"firstLow":{"!doc":"<p>Convert the first character of the string to lower case.</p>","!type":"fn(str: string) -> string"},"firstUp":{"!doc":"<p>Convert the first character of the string to upper case.</p>","!type":"fn(str: string) -> string"},"hyphenate":{"!doc":"<p>Converts a camelcased string to a hyphenated (separated by &#8217;-&#8217;) string.</p>\n\n<p>Example:</p>\n\n<pre class=\"javascript\">q.string.hyphenate(\"weLikeCookies\"); //returns \"we-like-cookies\"</pre>","!type":"fn(str: string) -> string"},"startsWith":{"!doc":"<p>Check whether the string starts with the given substring.</p>","!type":"fn(fullstr: string, substr: string) -> bool"}},"Type":{"!doc":"<p>Utility for checking the type of a variable.\nIt adds a <code>type</code> key static to q and offers the given method.</p>\n\n<pre class=\"javascript\">\nq.type.get(\"abc\"); // return \"String\" e.g.\n</pre>","get":{"!doc":"<p>Get the internal class of the value. The following classes are possible:</p>\n\n<pre>\n<code>\"String\"</code>,\n<code>\"Array\"</code>,\n<code>\"Object\"</code>,\n<code>\"RegExp\"</code>,\n<code>\"Number\"</code>,\n<code>\"Boolean\"</code>,\n<code>\"Date\"</code>,\n<code>\"Function\"</code>,\n<code>\"Error\"</code>\n</pre>","!type":"fn(value: Object) -> string"}}}},"Part":{"!doc":"<p>The part loader knows about all generated packages and parts.</p>\n\n<p>It contains functionality to load parts.</p>","!type":"fn()","$$notifyLoad":{"!doc":"<p>Loaded closure packages have to call this method to indicate\nsuccessful loading and to get their closure stored.</p>","!type":"fn(id: string, closure: fn())"},"getInstance":{"!doc":"<p>Get the default part loader instance</p>","!type":"fn() -> +qx.Part"},"preload":{"!doc":"<p>Preloads one or more closure parts but does not execute them. This means\nthe closure (the whole code of the part) is already loaded but not\nexecuted so you can&#8217;t use the classes in the the part after a preload.\nIf you want to execute them, just use the regular {@link #require}\nfunction.</p>","!type":"fn(partNames: string)"},"require":{"!doc":"<p>Loads one or more parts asynchronously. The callback is called after all\nparts and their dependencies are fully loaded. If the parts are already\nloaded the callback is called immediately.</p>","!type":"fn(partNames: string, callback: fn(), self?: Object)"},"prototype":{"__decodeUris":{"!doc":"<p>Decodes a list of source URIs. The function is defined in the loader\nscript.</p>","!type":"fn(compressedUris: string) -> string"},"__getUris":{"!doc":"<p>Get the <span class=\"caps\">URI</span> lists of all packages</p>","!type":"fn() -> string"},"addPackageListener":{"!doc":"<p>Register callback, which is called after the given package has been loaded\nor fails with an error. After the call the listener is removed.</p>","!type":"fn(pkg: Object, callback: Object)"},"addPartListener":{"!doc":"<p>Register callback, which is called after the given part has been loaded\nor fails with an error. After the call the listener is removed.</p>","!type":"fn(part: Object, callback: Object)"},"addToPackage":{"!doc":"<p>This method is only for testing purposes! Don&#8217;t use it!</p>","!type":"fn(pkg: +qx.io.part.Package)"},"getParts":{"!doc":"<p>Internal method for testing purposes which returns the internal parts\nstore.</p>","!type":"fn() -> +Array"},"notifyPackageResult":{"!doc":"<p>This method is called after a packages has been loaded or failed to load.\nIt calls all listeners for this package.</p>","!type":"fn(pkg: Object)"},"notifyPartResult":{"!doc":"<p>This method is called after a part has been loaded or failed to load.\nIt calls all listeners for this part.</p>","!type":"fn(part: Object)"},"preload":{"!doc":"<p>Preloader for the given part.</p>","!type":"fn(partNames: string, callback: fn(), self?: Object)"},"require":{"!doc":"<p>Loads one or more parts asynchronously. The callback is called after all\nparts and their dependencies are fully loaded. If the parts are already\nloaded the callback is called immediately.</p>","!type":"fn(partNames: string, callback: fn(), self?: Object)"},"saveClosure":{"!doc":"<p>Internal helper method to save the closure and notify that the load.</p>","!type":"fn(id: string, closure: fn())"}}},"theme":{"classic":{"Appearance":{"!doc":"<p>The classic qooxdoo appearance theme.</p>"},"Color":{"!doc":"<p>Windows classic color theme</p>"},"Decoration":{"!doc":"<p>The classic qooxdoo decoration theme.</p>"},"Font":{"!doc":"<p>The classic qooxdoo font theme.</p>"}},"Classic":{"!doc":"<p>Classic Windows Theme</p>"},"icon":{"Oxygen":{"!doc":"<p><span class=\"caps\">KDE</span> Oxygen icons</p>"},"Tango":{"!doc":"<p>Tango icons</p>"}},"indigo":{"Appearance":{"!doc":"<p>The simple qooxdoo appearance theme.</p>"},"Color":{"!doc":"<p>Indigo color theme</p>"},"Decoration":{"!doc":"<p>The indigo qooxdoo decoration theme.</p>"},"Font":{"!doc":"<p>The simple qooxdoo font theme.</p>"}},"Indigo":{"!doc":"<p>Simple Theme</p>"},"manager":{"Appearance":{"!proto":"qx.core.Object","!doc":"<p>Manager for appearance themes</p>","!type":"fn()","prototype":{"__resolveId":{"!doc":"<p>Returns the appearance entry ID to use\nwhen all aliases etc. are processed.</p>","!type":"fn(id: string, theme: +Theme, defaultId: string, chain: +Array) -> string"},"_applyTheme":{"!doc":"<p>Applies changes of the property value of the property <code>theme</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #theme}.</p>","!type":"fn(value: +Theme, old: +Theme)"},"getTheme":{"!doc":"<p>Returns the (computed) value of the property <code>theme</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #theme}.</p>","!type":"fn() -> Object"},"initTheme":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>theme</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #theme}.</p>","!type":"fn(value: Object) -> Object"},"resetTheme":{"!doc":"<p>Resets the user value of the property <code>theme</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #theme}.</p>","!type":"fn()"},"setTheme":{"!doc":"<p>Sets the user value of the property <code>theme</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #theme}.</p>","!type":"fn(value: Object) -> Object"},"styleFrom":{"!doc":"<p>Get the result of the &#8220;state&#8221; function for a given id and states</p>","!type":"fn(id: string, states: +Map, theme?: +Theme, defaultId: string) -> +Map"}},"getInstance":{"!doc":"<p>Returns a singleton instance of this class. On the first call the class\nis instantiated by calling the constructor with no arguments. All following\ncalls will return this instance.</p>\n\n<p>This method has been added by setting the &#8220;type&#8221; key in the class definition\n({@link qx.Class#define}) to &#8220;singleton&#8221;.</p>","!type":"fn() -> +qx.theme.manager.Appearance"}},"Color":{"!proto":"qx.util.ValueManager","!doc":"<p>Manager for color themes</p>","prototype":{"__parseColor":{"!doc":"<p>Helper to take a color stored in the theme and returns the string color value.\nIn most of the times that means it just returns the string stored in the theme.\nIt additionally checks if its a valid color at all.</p>","!type":"fn(colors: +Map, name: string) -> string"},"_applyTheme":{"!doc":"<p>Applies changes of the property value of the property <code>theme</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #theme}.</p>","!type":"fn(value: +Theme, old: +Theme)"},"getTheme":{"!doc":"<p>Returns the (computed) value of the property <code>theme</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #theme}.</p>","!type":"fn() -> Object"},"initTheme":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>theme</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #theme}.</p>","!type":"fn(value: Object) -> Object"},"isDynamic":{"!doc":"<p>Whether a value is interpreted dynamically</p>","!type":"fn(value: string) -> bool"},"resetTheme":{"!doc":"<p>Resets the user value of the property <code>theme</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #theme}.</p>","!type":"fn()"},"resolve":{"!doc":"<p>Returns the dynamically interpreted result for the incoming value,\n(if available), otherwise returns the original value</p>","!type":"fn(value: string) -> Object"},"setTheme":{"!doc":"<p>Sets the user value of the property <code>theme</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #theme}.</p>","!type":"fn(value: Object) -> Object"}},"getInstance":{"!doc":"<p>Returns a singleton instance of this class. On the first call the class\nis instantiated by calling the constructor with no arguments. All following\ncalls will return this instance.</p>\n\n<p>This method has been added by setting the &#8220;type&#8221; key in the class definition\n({@link qx.Class#define}) to &#8220;singleton&#8221;.</p>","!type":"fn() -> +qx.theme.manager.Color"}},"Decoration":{"!proto":"qx.core.Object","!doc":"<p>Manager for decoration themes</p>","!type":"fn()","prototype":{"_applyTheme":{"!doc":"<p>Applies changes of the property value of the property <code>theme</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #theme}.</p>","!type":"fn(value: +Theme, old: +Theme)"},"addCssClass":{"!doc":"<p>Adds a css class to the global stylesheet for the given decorator.\nThis includes resolving the decorator if it&#8217;s a string.</p>","!type":"fn(value: string) -> string"},"getCssClassName":{"!doc":"<p>Returns the name which will be / is used as css class name.</p>","!type":"fn(value: string) -> string"},"getTheme":{"!doc":"<p>Returns the (computed) value of the property <code>theme</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #theme}.</p>","!type":"fn() -> Object"},"initTheme":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>theme</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #theme}.</p>","!type":"fn(value: Object) -> Object"},"isCached":{"!doc":"<p>Whether the given decorator is cached</p>","!type":"fn(decorator: string) -> bool"},"isDynamic":{"!doc":"<p>Whether a value is interpreted dynamically</p>","!type":"fn(value: string) -> bool"},"isValidPropertyValue":{"!doc":"<p>Whether the given value is valid for being used in a property\nwith the &#8216;check&#8217; configured to &#8216;Decorator&#8217;.</p>","!type":"fn(value: Object) -> bool"},"resetTheme":{"!doc":"<p>Resets the user value of the property <code>theme</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #theme}.</p>","!type":"fn()"},"resolve":{"!doc":"<p>Returns the dynamically interpreted result for the incoming value</p>","!type":"fn(value: string) -> Object"},"setTheme":{"!doc":"<p>Sets the user value of the property <code>theme</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #theme}.</p>","!type":"fn(value: Object) -> Object"}},"getInstance":{"!doc":"<p>Returns a singleton instance of this class. On the first call the class\nis instantiated by calling the constructor with no arguments. All following\ncalls will return this instance.</p>\n\n<p>This method has been added by setting the &#8220;type&#8221; key in the class definition\n({@link qx.Class#define}) to &#8220;singleton&#8221;.</p>","!type":"fn() -> +qx.theme.manager.Decoration"}},"Font":{"!proto":"qx.util.ValueManager","!doc":"<p>Manager for font themes</p>","prototype":{"__getFontClass":{"!doc":"<p>Decides which Font class should be used based on the theme configuration</p>","!type":"fn(config: +Map) -> +Class"},"__resolveInclude":{"!doc":"<p>Checks for includes and resolves them recursively</p>","!type":"fn(fonts: +Map, fontName: string)"},"_applyTheme":{"!doc":"<p>Applies changes of the property value of the property <code>theme</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #theme}.</p>","!type":"fn(value: +Theme, old: +Theme)"},"getTheme":{"!doc":"<p>Returns the (computed) value of the property <code>theme</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #theme}.</p>","!type":"fn() -> Object"},"initTheme":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>theme</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #theme}.</p>","!type":"fn(value: Object) -> Object"},"isDynamic":{"!doc":"<p>Whether a value is interpreted dynamically</p>","!type":"fn(value: string) -> bool"},"resetTheme":{"!doc":"<p>Resets the user value of the property <code>theme</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #theme}.</p>","!type":"fn()"},"resolve":{"!doc":"<p>Returns the dynamically interpreted result for the incoming value,\n(if available), otherwise returns the original value</p>","!type":"fn(value: string) -> Object"},"resolveDynamic":{"!doc":"<p>Returns the dynamically interpreted result for the incoming value</p>","!type":"fn(value: string) -> Object"},"setTheme":{"!doc":"<p>Sets the user value of the property <code>theme</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #theme}.</p>","!type":"fn(value: Object) -> Object"}},"getInstance":{"!doc":"<p>Returns a singleton instance of this class. On the first call the class\nis instantiated by calling the constructor with no arguments. All following\ncalls will return this instance.</p>\n\n<p>This method has been added by setting the &#8220;type&#8221; key in the class definition\n({@link qx.Class#define}) to &#8220;singleton&#8221;.</p>","!type":"fn() -> +qx.theme.manager.Font"}},"Icon":{"!proto":"qx.core.Object","!doc":"<p>Manager for icon themes</p>","prototype":{"_applyTheme":{"!doc":"<p>Applies changes of the property value of the property <code>theme</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #theme}.</p>","!type":"fn(value: +Theme, old: +Theme)"},"getTheme":{"!doc":"<p>Returns the (computed) value of the property <code>theme</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #theme}.</p>","!type":"fn() -> Object"},"initTheme":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>theme</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #theme}.</p>","!type":"fn(value: Object) -> Object"},"resetTheme":{"!doc":"<p>Resets the user value of the property <code>theme</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #theme}.</p>","!type":"fn()"},"setTheme":{"!doc":"<p>Sets the user value of the property <code>theme</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #theme}.</p>","!type":"fn(value: Object) -> Object"}},"getInstance":{"!doc":"<p>Returns a singleton instance of this class. On the first call the class\nis instantiated by calling the constructor with no arguments. All following\ncalls will return this instance.</p>\n\n<p>This method has been added by setting the &#8220;type&#8221; key in the class definition\n({@link qx.Class#define}) to &#8220;singleton&#8221;.</p>","!type":"fn() -> +qx.theme.manager.Icon"}},"Meta":{"!proto":"qx.core.Object","!doc":"<p>Manager for meta themes</p>","prototype":{"_applyTheme":{"!doc":"<p>Applies changes of the property value of the property <code>theme</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #theme}.</p>","!type":"fn(value: +Theme, old: +Theme)"},"getTheme":{"!doc":"<p>Returns the (computed) value of the property <code>theme</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #theme}.</p>","!type":"fn() -> Object"},"initialize":{"!doc":"<p>Initialize the themes which were selected using the settings. Should only\nbe called from qooxdoo based application.</p>","!type":"fn()"},"initTheme":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>theme</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #theme}.</p>","!type":"fn(value: Object) -> Object"},"resetTheme":{"!doc":"<p>Resets the user value of the property <code>theme</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #theme}.</p>","!type":"fn()"},"setTheme":{"!doc":"<p>Sets the user value of the property <code>theme</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #theme}.</p>","!type":"fn(value: Object) -> Object"}},"getInstance":{"!doc":"<p>Returns a singleton instance of this class. On the first call the class\nis instantiated by calling the constructor with no arguments. All following\ncalls will return this instance.</p>\n\n<p>This method has been added by setting the &#8220;type&#8221; key in the class definition\n({@link qx.Class#define}) to &#8220;singleton&#8221;.</p>","!type":"fn() -> +qx.theme.manager.Meta"}}},"modern":{"Appearance":{"!doc":"<p>The modern appearance theme.</p>"},"Color":{"!doc":"<p>Modern color theme</p>"},"Decoration":{"!doc":"<p>The modern decoration theme.</p>"},"Font":{"!doc":"<p>The modern font theme.</p>"}},"Modern":{"!doc":"<p>Contemporary Theme</p>"},"simple":{"Appearance":{"!doc":"<p>The simple qooxdoo appearance theme.</p>"},"Color":{"!doc":"<p>Simple color theme</p>"},"Decoration":{"!doc":"<p>The simple qooxdoo decoration theme.</p>"},"Font":{"!doc":"<p>The simple qooxdoo font theme.</p>"},"Image":{"!proto":"qx.core.Object","!doc":"<p>Mapping class for all images used in the simple theme.</p>"}},"Simple":{"!doc":"<p>Simple Theme</p>"}},"Theme":{"!doc":"<p>Theme classes contain styling information for certain aspects of the\ngraphical user interface.</p>\n\n<p>Supported themes are: colors, decorations, fonts, icons, appearances.\nThe additional meta theme allows for grouping of the individual\nthemes.</p>\n\n<p>For more details, take a look at the\n<a href=\"http://manual.qooxdoo.org/4.1/pages/desktop/ui_theming.html\" target=\"_blank\">\ndocumentation of the theme system in the qooxdoo manual.</a></p>","__checkForInvalidTheme":{"!doc":"<p>Helper method to check for an invalid theme</p>","!type":"fn(mixinTheme?: +qx.Theme)"},"__convert":{"!doc":"<p>Convert existing entry to a prototype based inheritance function</p>","!type":"fn(theme: +Theme, config: +Map)"},"__extractType":{"!doc":"<p>Extract the inheritable key (could be only one)</p>","!type":"fn(config: +Map) -> string"},"__initializeAliases":{"!doc":"<p>Initialize alias inheritance</p>","!type":"fn(theme: +Map, config: +Map)"},"__normalizeArray":{"!doc":"<p>Normalize an object to an array</p>","!type":"fn(objectOrArray: Object) -> +Array"},"__validateConfig":{"!doc":"<p>Validates incoming configuration and checks keys and values</p>","!type":"fn(name: string, config: +Map)"},"define":{"!doc":"<p>Theme config</p>\n\n<p>Example:</p>\n\n<pre class=\"javascript\">\nqx.Theme.define(\"name\",\n{\n  aliases : {\n    \"aliasKey\" : \"resourceFolderOrUri\"\n  },\n  extend : otherTheme,\n  include : [MMixinTheme],\n  patch : [MMixinTheme],\n  colors : {},\n  decorations : {},\n  fonts : {},\n  widgets : {},\n  appearances : {},\n  meta : {}\n});\n</pre>\n\n<p>For more details, take a look at the\n<a href=\"http://manual.qooxdoo.org/4.1/pages/desktop/ui_theming.html\" target=\"_blank\">\ndocumentation of the theme system in the qooxdoo manual.</a></p>","!type":"fn(name: string, config: +Map)"},"genericToString":{"!doc":"<p>This method will be attached to all themes to return\na nice identifier for them.</p>","!type":"fn() -> string"},"getAll":{"!doc":"<p>Return a map of all known themes</p>","!type":"fn() -> +Map"},"getByName":{"!doc":"<p>Returns a theme by name</p>","!type":"fn(name: string) -> Object"},"getTotalNumber":{"!doc":"<p>Determine the number of themes which are defined</p>","!type":"fn() -> number"},"include":{"!doc":"<p>Include all keys of the given mixin theme into the theme. If the\nmixin includes any keys that are already available in the\nclass, they will be silently ignored. Use the {@link #patch} method\nif you need to overwrite keys in the current class.</p>","!type":"fn(theme: +Theme, mixinTheme: +Theme)"},"isDefined":{"!doc":"<p>Determine if theme exists</p>","!type":"fn(name: string) -> bool"},"patch":{"!doc":"<p>Include all keys of the given mixin theme into the theme. The mixin may\ninclude keys which are already defined in the target theme. Existing\nfeatures of equal name will be overwritten.</p>","!type":"fn(theme: +Theme, mixinTheme: +Theme)"}},"type":{"Array":{"!proto":"qx.type.BaseArray","!doc":"<p>An extended array class which adds a lot of often used\nconvenience methods to the regular array like <code>remove</code> or\n<code>contains</code>.</p>","!type":"fn()","prototype":{"__toPlainArray":{"!doc":"<p>Helper which checks for the given element and converts that to a\nnative array if necessary.</p>","!type":"fn(arr: +Array) -> +Array"},"append":{"!doc":"<p>Append the elements of the given array</p>","!type":"fn(arr: +Array) -> +Array"},"clone":{"!doc":"<p>Returns a clone of the array. Primitive values are copied.\nOthers are referenced.</p>","!type":"fn() -> +Array"},"contains":{"!doc":"<p>Whether the array contains the given element</p>","!type":"fn(obj: Object) -> bool"},"insertAfter":{"!doc":"<p>Insert an element after a given second element</p>","!type":"fn(obj: Object, obj2: Object) -> +Array"},"insertAt":{"!doc":"<p>Insert an element at a given position</p>","!type":"fn(obj: Object, i: +Integer) -> +Array"},"insertBefore":{"!doc":"<p>Insert an element before a given second element</p>","!type":"fn(obj: Object, obj2: Object) -> +Array"},"prepend":{"!doc":"<p>Prepend the elements of the given array.</p>","!type":"fn(arr: +Array) -> +Array"},"remove":{"!doc":"<p>Remove an element</p>","!type":"fn(obj: Object) -> Object"},"removeAll":{"!doc":"<p>Remove all elements</p>","!type":"fn() -> +Array"},"removeAt":{"!doc":"<p>Remove an element at the given index</p>","!type":"fn(i: +Integer) -> Object"}}},"BaseArray":{"!proto":"Array","!doc":"<p>This class is the common superclass for most array classes in\nqooxdoo. It supports all of the shiny 1.6 JavaScript array features\nlike <code>forEach</code> and <code>map</code>.</p>\n\n<p>This class may be instantiated instead of the native Array if\none wants to work with a feature-unified Array instead of the native\none. This class uses native features whereever possible but fills\nall missing implementations with custom ones.</p>\n\n<p>Through the ability to extend from this class one could add even\nmore utility features on top of it.</p>","!type":"fn()","prototype":{"concat":{"!doc":"<p>Returns a new array comprised of this array joined with other array(s) and/or value(s).</p>\n\n<p>This method does not modify the array and returns a modified copy of the original.</p>","!type":"fn(varargs: +Array) -> +qx.type.BaseArray"},"every":{"!doc":"<p>Tests whether all elements in the array pass the test implemented by the provided function.</p>\n\n<code>every</code> executes the provided <code>callback</code> function once for each element\npresent in the array until it finds one where <code>callback</code> returns a false value. If\nsuch an element is found, the <code>every</code> method immediately returns <code>false</code>.\nOtherwise, if <code>callback</code> returned a true value for all elements, <code>every</code>\nwill return <code>true</code>.  <code>callback</code> is invoked only for indexes of the array\nwhich have assigned values; it is not invoked for indexes which have been deleted or which have\nnever been assigned values.\n\n<code>callback</code> is invoked with three arguments: the value of the element, the index of\nthe element, and the Array object being traversed.\n\n<p>If a <code>obj</code> parameter is provided to <code>every</code>, it will be used as\nthe <code>this</code> for each invocation of the <code>callback</code>. If it is not provided,\nor is <code>null</code>, the global object associated with <code>callback</code> is used instead.</p>\n\n<code>every</code> does not mutate the array on which it is called. The range of elements processed\nby <code>every</code> is set before the first invocation of <code>callback</code>. Elements which\nare appended to the array after the call to <code>every</code> begins will not be visited by\n<code>callback</code>.  If existing elements of the array are changed, their value as passed\nto <code>callback</code> will be the value at the time <code>every</code> visits them; elements\nthat are deleted are not visited.","!type":"fn(callback: fn(), obj: Object) -> bool"},"filter":{"!doc":"<p>Creates a new array with all elements that pass the test implemented by the provided\nfunction.</p>\n\n<code>filter</code> calls a provided <code>callback</code> function once for each\nelement in an array, and constructs a new array of all the values for which\n<code>callback</code> returns a true value.  <code>callback</code> is invoked only\nfor indexes of the array which have assigned values; it is not invoked for indexes\nwhich have been deleted or which have never been assigned values.  Array elements which\ndo not pass the <code>callback</code> test are simply skipped, and are not included\nin the new array.\n\n<code>callback</code> is invoked with three arguments: the value of the element, the\nindex of the element, and the Array object being traversed.\n\n<p>If a <code>obj</code> parameter is provided to <code>filter</code>, it will\nbe used as the <code>this</code> for each invocation of the <code>callback</code>.\nIf it is not provided, or is <code>null</code>, the global object associated with\n<code>callback</code> is used instead.</p>\n\n<code>filter</code> does not mutate the array on which it is called. The range of\nelements processed by <code>filter</code> is set before the first invocation of\n<code>callback</code>. Elements which are appended to the array after the call to\n<code>filter</code> begins will not be visited by <code>callback</code>. If existing\nelements of the array are changed, or deleted, their value as passed to <code>callback</code>\nwill be the value at the time <code>filter</code> visits them; elements that are deleted\nare not visited.","!type":"fn(callback: fn(), obj: Object) -> +BaseArray"},"forEach":{"!doc":"<p>Executes a provided function once per array element.</p>\n\n<code>forEach</code> executes the provided function (<code>callback</code>) once for each\nelement present in the array.  <code>callback</code> is invoked only for indexes of the array\nwhich have assigned values; it is not invoked for indexes which have been deleted or which\nhave never been assigned values.\n\n<code>callback</code> is invoked with three arguments: the value of the element, the index\nof the element, and the Array object being traversed.\n\n<p>If a <code>obj</code> parameter is provided to <code>forEach</code>, it will be used\nas the <code>this</code> for each invocation of the <code>callback</code>.  If it is not\nprovided, or is <code>null</code>, the global object associated with <code>callback</code>\nis used instead.</p>\n\n<code>forEach</code> does not mutate the array on which it is called.\n\n<p>The range of elements processed by <code>forEach</code> is set before the first invocation of\n<code>callback</code>.  Elements which are appended to the array after the call to\n<code>forEach</code> begins will not be visited by <code>callback</code>. If existing elements\nof the array are changed, or deleted, their value as passed to <code>callback</code> will be\nthe value at the time <code>forEach</code> visits them; elements that are deleted are not visited.</p>","!type":"fn(callback: fn(), obj: Object)"},"indexOf":{"!doc":"<p>Returns the first (least) index of an element within the array equal to the specified value, or -1 if none is found.</p>","!type":"fn(searchElement: Object, fromIndex?: +Integer) -> +Integer"},"join":{"!doc":"<p>Joins all elements of an array into a string.</p>","!type":"fn(separator: string) -> string"},"lastIndexOf":{"!doc":"<p>Returns the last (greatest) index of an element within the array equal to the specified value, or -1 if none is found.</p>","!type":"fn(searchElement: Object, fromIndex?: +Integer) -> +Integer"},"map":{"!doc":"<p>Creates a new array with the results of calling a provided function on every element in this array.</p>\n\n<code>map</code> calls a provided <code>callback</code> function once for each element in an array,\nin order, and constructs a new array from the results.  <code>callback</code> is invoked only for\nindexes of the array which have assigned values; it is not invoked for indexes which have been\ndeleted or which have never been assigned values.\n\n<code>callback</code> is invoked with three arguments: the value of the element, the index of the\nelement, and the Array object being traversed.\n\n<p>If a <code>obj</code> parameter is provided to <code>map</code>, it will be used as the\n<code>this</code> for each invocation of the <code>callback</code>. If it is not provided, or is\n<code>null</code>, the global object associated with <code>callback</code> is used instead.</p>\n\n<code>map</code> does not mutate the array on which it is called.\n\n<p>The range of elements processed by <code>map</code> is set before the first invocation of\n<code>callback</code>. Elements which are appended to the array after the call to <code>map</code>\nbegins will not be visited by <code>callback</code>.  If existing elements of the array are changed,\nor deleted, their value as passed to <code>callback</code> will be the value at the time\n<code>map</code> visits them; elements that are deleted are not visited.</p>","!type":"fn(callback: fn(), obj: Object) -> +BaseArray"},"pop":{"!doc":"<p>Removes the last element from an array and returns that element.</p>\n\n<p>This method modifies the array.</p>","!type":"fn() -> Object"},"push":{"!doc":"<p>Adds one or more elements to the end of an array and returns the new length of the array.</p>\n\n<p>This method modifies the array.</p>","!type":"fn(varargs: Object) -> +Integer"},"reverse":{"!doc":"<p>Reverses the order of the elements of an array&#8212;the first becomes the last, and the last becomes the first.</p>\n\n<p>This method modifies the array.</p>","!type":"fn() -> +Array"},"shift":{"!doc":"<p>Removes the first element from an array and returns that element.</p>\n\n<p>This method modifies the array.</p>","!type":"fn() -> Object"},"slice":{"!doc":"<p>Extracts a section of an array and returns a new array.</p>","!type":"fn(begin: +Integer, end?: +Integer) -> +BaseArray"},"some":{"!doc":"<p>Tests whether some element in the array passes the test implemented by the provided function.</p>\n\n<code>some</code> executes the <code>callback</code> function once for each element present in\nthe array until it finds one where <code>callback</code> returns a true value. If such an element\nis found, <code>some</code> immediately returns <code>true</code>. Otherwise, <code>some</code>\nreturns <code>false</code>. <code>callback</code> is invoked only for indexes of the array which\nhave assigned values; it is not invoked for indexes which have been deleted or which have never\nbeen assigned values.\n\n<code>callback</code> is invoked with three arguments: the value of the element, the index of the\nelement, and the Array object being traversed.\n\n<p>If a <code>obj</code> parameter is provided to <code>some</code>, it will be used as the\n<code>this</code> for each invocation of the <code>callback</code>. If it is not provided, or is\n<code>null</code>, the global object associated with <code>callback</code> is used instead.</p>\n\n<code>some</code> does not mutate the array on which it is called.\n\n<p>The range of elements processed by <code>some</code> is set before the first invocation of\n<code>callback</code>.  Elements that are appended to the array after the call to <code>some</code>\nbegins will not be visited by <code>callback</code>. If an existing, unvisited element of the array\nis changed by <code>callback</code>, its value passed to the visiting <code>callback</code> will\nbe the value at the time that <code>some</code> visits that element&#8217;s index; elements that are\ndeleted are not visited.</p>","!type":"fn(callback: fn(), obj: Object) -> bool"},"sort":{"!doc":"<p>Sorts the elements of an array.</p>\n\n<p>This method modifies the array.</p>","!type":"fn(compareFunction?: fn()) -> +Array"},"splice":{"!doc":"<p>Adds and/or removes elements from an array.</p>","!type":"fn(index: +Integer, howMany: +Integer, varargs?: Object) -> +BaseArray"},"toArray":{"!doc":"<p>Converts a base array to a native Array</p>","!type":"fn() -> +Array"},"toString":{"!doc":"<p>Returns a string representing the array and its elements. Overrides the Object.prototype.toString method.</p>","!type":"fn() -> string"},"unshift":{"!doc":"<p>Adds one or more elements to the front of an array and returns the new length of the array.</p>\n\n<p>This method modifies the array.</p>","!type":"fn(varargs: Object) -> +Integer"},"valueOf":{"!doc":"<p>Returns the current number of items stored in the Array</p>","!type":"fn() -> +Integer"}}},"BaseError":{"!proto":"Error","!doc":"<p>This class is the common super class for all error classes in qooxdoo.</p>\n\n<p>It has a comment and a fail message as members. The toString method returns\nthe comment and the fail message separated by a colon.</p>","!type":"fn()","prototype":{"getComment":{"!doc":"<p>Comment passed to the assertion call</p>","!type":"fn() -> string"},"toString":{"!doc":"<p>Get the error message</p>","!type":"fn() -> string"}}},"BaseString":{"!proto":"Object","!doc":"<p>This class emulates the built-in JavaScript String class. It can be used as\nbase class for classes, which need to derive from String.</p>\n\n<p>Instances of this class can be used in any place a JavaScript string can.</p>","!type":"fn()","prototype":{"base":{"!doc":"<p>Call the same method of the super class.</p>","!type":"fn(args: +arguments, varags: Object) -> Object"},"charAt":{"!doc":"<p>Returns the specified character from a string.</p>\n\n<p>Characters in a string are indexed from left to right. The index of the\nfirst character is 0, and the index of the last character in a string\ncalled stringName is stringName.length &#8211; 1. If the index you supply is\nout of range, JavaScript returns an empty string.</p>","!type":"fn(index: +Integer) -> string"},"charCodeAt":{"!doc":"<p>Returns a number indicating the Unicode value of the character at the given index.</p>","!type":"fn(index: +Integer) -> +Integer"},"concat":{"!doc":"<p>Combines the text of two or more strings and returns a new string.\nChanges to the text in one string do not affect the other string.</p>","!type":"fn(stringN: string) -> string"},"indexOf":{"!doc":"<p>Returns the index within the calling String object of the first\noccurrence of the specified value, starting the search at fromIndex,\nreturns -1 if the value is not found.</p>","!type":"fn(index: string, offset?: +Integer) -> +Integer"},"lastIndexOf":{"!doc":"<p>Returns the index within the calling String object of the last occurrence\nof the specified value, or -1 if not found. The calling string is\nsearched backward, starting at fromIndex.</p>","!type":"fn(index: string, offset?: +Integer) -> +Integer"},"match":{"!doc":"<p>Used to retrieve the matches when matching a string against a regular\nexpression.</p>\n\n<p>If the regular expression does not include the g flag, returns the same\nresult as regexp.exec(string). If the regular expression includes the g\nflag, the method returns an Array containing all matches.</p>","!type":"fn(regexp: Object) -> Object"},"replace":{"!doc":"<p>Finds a match between a regular expression and a string, and replaces the\nmatched substring with a new substring.</p>","!type":"fn(regexp: Object, aFunction: fn()) -> string"},"search":{"!doc":"<p>Executes the search for a match between a regular expression and this\nString object.</p>\n\n<p>If successful, search returns the index of the regular expression inside\nthe string. Otherwise, it returns -1.</p>","!type":"fn(regexp: Object) -> Object"},"slice":{"!doc":"<p>Extracts a section of a string and returns a new string.</p>\n\n<p>Slice extracts the text from one string and returns a new string. Changes\nto the text in one string do not affect the other string.\nAs a negative index, endSlice indicates an offset from the end of the\nstring.</p>","!type":"fn(beginslice: +Integer, endSlice?: +Integer) -> string"},"split":{"!doc":"<p>Splits a String object into an array of strings by separating the string\ninto substrings.</p>\n\n<p>When found, separator is removed from the string and the substrings are\nreturned in an array. If separator is omitted, the array contains one\nelement consisting of the entire string.</p>\n\n<p>If separator is a regular expression that contains capturing parentheses,\nthen each time separator is matched the results (including any undefined\nresults) of the capturing parentheses are spliced into the output array.\nHowever, not all browsers support this capability.</p>\n\n<p>Note: When the string is empty, split returns an array containing one</p>","!type":"fn(separator?: string, limit?: +Integer) -> +Array"},"substr":{"!doc":"<p>Returns the characters in a string beginning at the specified location\nthrough the specified number of characters.</p>\n\n<p>Start is a character index. The index of the first character is 0, and the\nindex of the last character is 1 less than the length of the string. substr\n begins extracting characters at start and collects length characters\n(unless it reaches the end of the string first, in which case it will\nreturn fewer).\nIf start is positive and is greater than or equal to the length of the\nstring, substr returns an empty string.</p>","!type":"fn(start: +Integer, length?: +Integer) -> string"},"substring":{"!doc":"<p>Returns a subset of a String object.</p>\n\n<p>substring extracts characters from indexA up to but not including indexB.\nIn particular:\nIf indexA equals indexB, substring returns an empty string.\nIf indexB is omitted, substring extracts characters to the end of the\nstring.\nIf either argument is less than 0 or is NaN, it is treated as if it were\n0.\nIf either argument is greater than stringName.length, it is treated as if\nit were stringName.length.\nIf indexA is larger than indexB, then the effect of substring is as if\nthe two arguments were swapped; for example, str.substring(1, 0) == str.substring(0, 1).</p>","!type":"fn(indexA: +Integer, indexB?: +Integer) -> string"},"toHashCode":{"!doc":"<p>Return unique hash code of object</p>","!type":"fn() -> +Integer"},"toLocaleLowerCase":{"!doc":"<p>The characters within a string are converted to lower case while\nrespecting the current locale.</p>\n\n<p>The toLowerCase method returns the value of the string converted to\nlowercase. toLowerCase does not affect the value of the string itself.</p>","!type":"fn() -> string"},"toLocaleUpperCase":{"!doc":"<p>The characters within a string are converted to upper case while\nrespecting the current locale.\nThe toUpperCase method returns the value of the string converted to\nuppercase. toUpperCase does not affect the value of the string itself.</p>","!type":"fn() -> string"},"toLowerCase":{"!doc":"<p>Returns the calling string value converted to lowercase.\nThe toLowerCase method returns the value of the string converted to\nlowercase. toLowerCase does not affect the value of the string itself.</p>","!type":"fn() -> string"},"toString":{"!doc":"<p>Returns a string representing the specified object.</p>\n\n<p>The valueOf method of String returns the primitive value of a String\nobject as a string data type.\nThis method is usually called internally by JavaScript and not\nexplicitly in code.</p>","!type":"fn() -> string"},"toUpperCase":{"!doc":"<p>Returns the calling string value converted to uppercase.\nThe toUpperCase method returns the value of the string converted to\nuppercase. toUpperCase does not affect the value of the string itself.</p>","!type":"fn() -> string"},"valueOf":{"!doc":"<p>Returns the primitive value of a String object.</p>\n\n<p>The valueOf method of String returns the primitive value of a String\nobject as a string data type.\nThis method is usually called internally by JavaScript and not\nexplicitly in code.</p>","!type":"fn() -> string"}}}},"ui":{"basic":{"Atom":{"!proto":"qx.ui.core.Widget","!doc":"<p>A multi-purpose widget, which combines a label with an icon.</p>\n\n<p>The intended purpose of qx.ui.basic.Atom is to easily align the common icon-text\ncombination in different ways.</p>\n\n<p>This is useful for all types of buttons, tooltips, ...</p>\n\n<p><strong>Example</strong></p>\n\n<p>Here is a little example of how to use the widget.</p>\n\n<pre class=\"javascript\">\n  var atom = new qx.ui.basic.Atom(\"Icon Right\", \"icon/32/actions/go-next.png\");\n  this.getRoot().add(atom);\n</pre>\n\n<p>This example creates an atom with the label &#8220;Icon Right&#8221; and an icon.</p>\n\n<p><strong>External Documentation</strong></p>\n\n<a href=\"http://manual.qooxdoo.org/4.1/pages/widget/atom.html\" target=\"_blank\">\nDocumentation of this widget in the qooxdoo manual.</a>","!type":"fn()","prototype":{"_applyCenter":{"!doc":"<p>Applies changes of the property value of the property <code>center</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #center}.</p>","!type":"fn(value: bool, old: bool)"},"_applyGap":{"!doc":"<p>Applies changes of the property value of the property <code>gap</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #gap}.</p>","!type":"fn(value: +Integer, old: +Integer)"},"_applyIcon":{"!doc":"<p>Applies changes of the property value of the property <code>icon</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #icon}.</p>","!type":"fn(value: string, old: string)"},"_applyIconPosition":{"!doc":"<p>Applies changes of the property value of the property <code>iconPosition</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #iconPosition}.</p>","!type":"fn(value: Object, old: Object)"},"_applyLabel":{"!doc":"<p>Applies changes of the property value of the property <code>label</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #label}.</p>","!type":"fn(value: string, old: string)"},"_applyRich":{"!doc":"<p>Applies changes of the property value of the property <code>rich</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #rich}.</p>","!type":"fn(value: bool, old: bool)"},"_applySelectable":{"!doc":"<p>Applies changes of the property value of the property <code>selectable</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #selectable}.</p>","!type":"fn(value: bool, old: bool)"},"_applyShow":{"!doc":"<p>Applies changes of the property value of the property <code>show</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #show}.</p>","!type":"fn(value: Object, old: Object)"},"_createChildControlImpl":{"!type":"fn(id: +undefined, hash: +undefined)"},"_handleIcon":{"!doc":"<p>Updates the visibility of the icon</p>","!type":"fn()"},"_handleLabel":{"!doc":"<p>Updates the visibility of the label</p>","!type":"fn()"},"getCenter":{"!doc":"<p>Returns the (computed) value of the property <code>center</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #center}.</p>","!type":"fn() -> Object"},"getGap":{"!doc":"<p>Returns the (computed) value of the property <code>gap</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #gap}.</p>","!type":"fn() -> Object"},"getIcon":{"!doc":"<p>Returns the (computed) value of the property <code>icon</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #icon}.</p>","!type":"fn() -> Object"},"getIconPosition":{"!doc":"<p>Returns the (computed) value of the property <code>iconPosition</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #iconPosition}.</p>","!type":"fn() -> Object"},"getLabel":{"!doc":"<p>Returns the (computed) value of the property <code>label</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #label}.</p>","!type":"fn() -> Object"},"getRich":{"!doc":"<p>Returns the (computed) value of the property <code>rich</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #rich}.</p>","!type":"fn() -> Object"},"getShow":{"!doc":"<p>Returns the (computed) value of the property <code>show</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #show}.</p>","!type":"fn() -> Object"},"initCenter":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>center</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #center}.</p>","!type":"fn(value: Object) -> Object"},"initGap":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>gap</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #gap}.</p>","!type":"fn(value: Object) -> Object"},"initIcon":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>icon</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #icon}.</p>","!type":"fn(value: Object) -> Object"},"initIconPosition":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>iconPosition</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #iconPosition}.</p>","!type":"fn(value: Object) -> Object"},"initLabel":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>label</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #label}.</p>","!type":"fn(value: Object) -> Object"},"initRich":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>rich</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #rich}.</p>","!type":"fn(value: Object) -> Object"},"initShow":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>show</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #show}.</p>","!type":"fn(value: Object) -> Object"},"isCenter":{"!doc":"<p>Check whether the (computed) value of the boolean property <code>center</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #center}.</p>","!type":"fn() -> bool"},"isRich":{"!doc":"<p>Check whether the (computed) value of the boolean property <code>rich</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #rich}.</p>","!type":"fn() -> bool"},"resetCenter":{"!doc":"<p>Resets the user value of the property <code>center</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #center}.</p>","!type":"fn()"},"resetGap":{"!doc":"<p>Resets the user value of the property <code>gap</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #gap}.</p>","!type":"fn()"},"resetIcon":{"!doc":"<p>Resets the user value of the property <code>icon</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #icon}.</p>","!type":"fn()"},"resetIconPosition":{"!doc":"<p>Resets the user value of the property <code>iconPosition</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #iconPosition}.</p>","!type":"fn()"},"resetLabel":{"!doc":"<p>Resets the user value of the property <code>label</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #label}.</p>","!type":"fn()"},"resetRich":{"!doc":"<p>Resets the user value of the property <code>rich</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #rich}.</p>","!type":"fn()"},"resetShow":{"!doc":"<p>Resets the user value of the property <code>show</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #show}.</p>","!type":"fn()"},"setCenter":{"!doc":"<p>Sets the user value of the property <code>center</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #center}.</p>","!type":"fn(value: Object) -> Object"},"setGap":{"!doc":"<p>Sets the user value of the property <code>gap</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #gap}.</p>","!type":"fn(value: Object) -> Object"},"setIcon":{"!doc":"<p>Sets the user value of the property <code>icon</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #icon}.</p>","!type":"fn(value: Object) -> Object"},"setIconPosition":{"!doc":"<p>Sets the user value of the property <code>iconPosition</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #iconPosition}.</p>","!type":"fn(value: Object) -> Object"},"setLabel":{"!doc":"<p>Sets the user value of the property <code>label</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #label}.</p>","!type":"fn(value: Object) -> Object"},"setRich":{"!doc":"<p>Sets the user value of the property <code>rich</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #rich}.</p>","!type":"fn(value: Object) -> Object"},"setShow":{"!doc":"<p>Sets the user value of the property <code>show</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #show}.</p>","!type":"fn(value: Object) -> Object"},"toggleCenter":{"!doc":"<p>Toggles the (computed) value of the boolean property <code>center</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #center}.</p>","!type":"fn() -> bool"},"toggleRich":{"!doc":"<p>Toggles the (computed) value of the boolean property <code>rich</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #rich}.</p>","!type":"fn() -> bool"}}},"Image":{"!proto":"qx.ui.core.Widget","!doc":"<p>The image class displays an image file</p>\n\n<p>This class supports image clipping, which means that multiple images can be combined\ninto one large image and only the relevant part is shown.</p>\n\n<p><strong>Example</strong></p>\n\n<p>Here is a little example of how to use the widget.</p>\n\n<pre class=\"javascript\">\n  var image = new qx.ui.basic.Image(\"icon/32/actions/format-justify-left.png\");\n\n  this.getRoot().add(image);\n</pre>\n\n<p>This example create a widget to display the image\n<code>icon/32/actions/format-justify-left.png</code>.</p>\n\n<p><strong>External Documentation</strong></p>\n\n<a href=\"http://manual.qooxdoo.org/4.1/pages/widget/image.html\" target=\"_blank\">\nDocumentation of this widget in the qooxdoo manual.</a>","!type":"fn()","prototype":{"__checkForContentElementReplacement":{"!doc":"<p>Checks the current child and replaces it if necessary</p>","!type":"fn(elementToAdd: +qx.html.Image)"},"__createSuitableContentElement":{"!doc":"<p>Creates a contentElement suitable for the current mode</p>","!type":"fn(mode: string) -> +qx.html.Image"},"__fireLoadEvent":{"!doc":"<p>Helper function, which fires <code>loaded</code> event asynchronously.\nIt emulates native <code>loaded</code> event of an image object. This\nhelper will be called, if you try to load a managed image or an\npreviously loaded unmanaged image.</p>","!type":"fn()"},"__getContentElement":{"!doc":"<p>Returns the content element.</p>","!type":"fn() -> +qx.html.Image"},"__getMode":{"!doc":"<p>Returns the current mode if set. Otherwise checks the current source and\nthe current scaling to determine the current mode.</p>","!type":"fn() -> string"},"__getSuitableContentElement":{"!doc":"<p>Returns a contentElement suitable for the current mode</p>","!type":"fn() -> +qx.html.Image"},"__loaderCallback":{"!doc":"<p>Event handler fired after the preloader has finished loading the icon</p>","!type":"fn(source: string, imageInfo: +Map)"},"__loadUnmanagedImage":{"!doc":"<p>Use the ImageLoader to load an unmanaged image</p>","!type":"fn(el: +Element, source: string)"},"__setManagedImage":{"!doc":"<p>Use the ResourceManager to set a managed image</p>","!type":"fn(el: +Element, source: string)"},"__setMode":{"!doc":"<p>Remembers the mode to keep track which contentElement is currently in use.</p>","!type":"fn(mode: string)"},"__setSource":{"!doc":"<p>Combines the decorator&#8217;s image styles with our own image to make sure\ngradient and backgroundImage decorators work on Images.</p>","!type":"fn(el: +Element, source: string)"},"__setUnmanagedImage":{"!doc":"<p>Use the infos of the ImageLoader to set an unmanaged image</p>","!type":"fn(el: +Element, source: string)"},"__updateContentHint":{"!doc":"<p>Updates the content hint when the image size has been changed</p>","!type":"fn(width: +Integer, height: +Integer)"},"_applyDecorator":{"!doc":"<p>Applies changes of the property value of the property <code>decorator</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #decorator}.</p>","!type":"fn(value: +Decorator, old: +Decorator)"},"_applyEnabled":{"!doc":"<p>Applies changes of the property value of the property <code>enabled</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #enabled}.</p>","!type":"fn(value: bool, old: bool)"},"_applyPadding":{"!doc":"<p>Applies changes of the property value of the properties <code>paddingBottom</code>, <code>paddingLeft</code>, <code>paddingRight</code> and <code>paddingTop</code>.</p>\n\n<p>For further details take a look at the property definitions: {@link #paddingBottom}, {@link #paddingLeft}, {@link #paddingRight} and {@link #paddingTop}.</p>","!type":"fn(value: +Integer, old: +Integer)"},"_applyScale":{"!doc":"<p>Applies changes of the property value of the property <code>scale</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #scale}.</p>","!type":"fn(value: bool, old: bool)"},"_applySource":{"!doc":"<p>Applies changes of the property value of the property <code>source</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #source}.</p>","!type":"fn(value: string, old: string)"},"_createContentElement":{"!type":"fn()"},"_getContentHint":{"!type":"fn()"},"_onChangeTheme":{"!type":"fn()"},"_styleSource":{"!doc":"<p>Applies the source to the clipped image instance or preload\nan image to detect sizes and apply it afterwards.</p>","!type":"fn()"},"getContentElement":{"!type":"fn()"},"getScale":{"!doc":"<p>Returns the (computed) value of the property <code>scale</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #scale}.</p>","!type":"fn() -> Object"},"getSource":{"!doc":"<p>Returns the (computed) value of the property <code>source</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #source}.</p>","!type":"fn() -> Object"},"initScale":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>scale</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #scale}.</p>","!type":"fn(value: Object) -> Object"},"initSource":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>source</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #source}.</p>","!type":"fn(value: Object) -> Object"},"isScale":{"!doc":"<p>Check whether the (computed) value of the boolean property <code>scale</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #scale}.</p>","!type":"fn() -> bool"},"renderLayout":{"!type":"fn(left: +undefined, top: +undefined, width: +undefined, height: +undefined)"},"resetScale":{"!doc":"<p>Resets the user value of the property <code>scale</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #scale}.</p>","!type":"fn()"},"resetSource":{"!doc":"<p>Resets the user value of the property <code>source</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #source}.</p>","!type":"fn()"},"setScale":{"!doc":"<p>Sets the user value of the property <code>scale</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #scale}.</p>","!type":"fn(value: Object) -> Object"},"setSource":{"!doc":"<p>Sets the user value of the property <code>source</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #source}.</p>","!type":"fn(value: Object) -> Object"},"toggleScale":{"!doc":"<p>Toggles the (computed) value of the boolean property <code>scale</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #scale}.</p>","!type":"fn() -> bool"}}},"Label":{"!proto":"qx.ui.core.Widget","!doc":"<p>The label class brings typical text content to the widget system.</p>\n\n<p>It supports simple text nodes and complex <span class=\"caps\">HTML</span> (rich). The default\ncontent mode is for text only. The mode is changeable through the property\n{@link #rich}.</p>\n\n<p>The label supports heightForWidth when used in <span class=\"caps\">HTML</span> mode. This means\nthat multi line <span class=\"caps\">HTML</span> automatically computes the correct preferred height.</p>\n\n<p><strong>Example</strong></p>\n\n<p>Here is a little example of how to use the widget.</p>\n\n<pre class=\"javascript\">\n  // a simple text label without wrapping and markup support\n  var label1 = new qx.ui.basic.Label(\"Simple text label\");\n  this.getRoot().add(label1, {left:20, top:10});\n\n  // a HTML label with automatic line wrapping\n  var label2 = new qx.ui.basic.Label().set({\n    value: \"A <b>long label</b> text with auto-wrapping. This also may contain <b>rich HTML</b> markup.\",\n    rich : true,\n    width: 120\n  });\n  this.getRoot().add(label2, {left:20, top:50});\n</pre>\n\n<p>The first label in this example is a basic text only label. As such no\nautomatic wrapping is supported. The second label is a long label containing\n<span class=\"caps\">HTML</span> markup with automatic line wrapping.</p>\n\n<p><strong>External Documentation</strong></p>\n\n<a href=\"http://manual.qooxdoo.org/4.1/pages/widget/label.html\" target=\"_blank\">\nDocumentation of this widget in the qooxdoo manual.</a>","!type":"fn()","prototype":{"__computeContentSize":{"!doc":"<p>Internal utility to compute the content dimensions.</p>","!type":"fn(width?: +Integer) -> +Map"},"__fixEllipsis":{"!doc":"<p>Firefox > 9 on OS X will draw an ellipsis on top of the label content even\nthough there is enough space for the text. Re-applying the content forces\na recalculation and fixes the problem. See qx bug #6293</p>","!type":"fn()"},"_applyBuddy":{"!doc":"<p>Applies changes of the property value of the property <code>buddy</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #buddy}.</p>","!type":"fn(value: +qx.ui.core.Widget, old: +qx.ui.core.Widget)"},"_applyFont":{"!doc":"<p>Applies changes of the property value of the property <code>font</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #font}.</p>","!type":"fn(value: +Font, old: +Font)"},"_applyRich":{"!doc":"<p>Applies changes of the property value of the property <code>rich</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #rich}.</p>","!type":"fn(value: bool, old: bool)"},"_applySelectable":{"!doc":"<p>Applies changes of the property value of the property <code>selectable</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #selectable}.</p>","!type":"fn(value: bool, old: bool)"},"_applyTextAlign":{"!doc":"<p>Applies changes of the property value of the property <code>textAlign</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #textAlign}.</p>","!type":"fn(value: Object, old: Object)"},"_applyTextColor":{"!doc":"<p>Applies changes of the property value of the property <code>textColor</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #textColor}.</p>","!type":"fn(value: +Color, old: +Color)"},"_applyValue":{"!doc":"<p>Applies changes of the property value of the property <code>value</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #value}.</p>","!type":"fn(value: string, old: string)"},"_applyWrap":{"!doc":"<p>Applies changes of the property value of the property <code>wrap</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #wrap}.</p>","!type":"fn(value: bool, old: bool)"},"_createContentElement":{"!type":"fn()"},"_getContentHeightForWidth":{"!type":"fn(width: +undefined)"},"_getContentHint":{"!type":"fn()"},"_hasHeightForWidth":{"!type":"fn()"},"_onChangeLocale":{"!doc":"<p>Locale change event handler</p>","!type":"fn(e: +Event)"},"_onWebFontStatusChange":{"!doc":"<p>Triggers layout recalculation after a web font was loaded</p>","!type":"fn(ev: +qx.event.type.Data)"},"getBuddy":{"!doc":"<p>Returns the (computed) value of the property <code>buddy</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #buddy}.</p>","!type":"fn() -> Object"},"getRich":{"!doc":"<p>Returns the (computed) value of the property <code>rich</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #rich}.</p>","!type":"fn() -> Object"},"getTextAlign":{"!doc":"<p>Returns the (computed) value of the property <code>textAlign</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #textAlign}.</p>","!type":"fn() -> Object"},"getValue":{"!doc":"<p>Returns the (computed) value of the property <code>value</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #value}.</p>","!type":"fn() -> Object"},"getWrap":{"!doc":"<p>Returns the (computed) value of the property <code>wrap</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #wrap}.</p>","!type":"fn() -> Object"},"initBuddy":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>buddy</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #buddy}.</p>","!type":"fn(value: Object) -> Object"},"initRich":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>rich</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #rich}.</p>","!type":"fn(value: Object) -> Object"},"initTextAlign":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>textAlign</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #textAlign}.</p>","!type":"fn(value: Object) -> Object"},"initValue":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>value</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #value}.</p>","!type":"fn(value: Object) -> Object"},"initWrap":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>wrap</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #wrap}.</p>","!type":"fn(value: Object) -> Object"},"isRich":{"!doc":"<p>Check whether the (computed) value of the boolean property <code>rich</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #rich}.</p>","!type":"fn() -> bool"},"isWrap":{"!doc":"<p>Check whether the (computed) value of the boolean property <code>wrap</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #wrap}.</p>","!type":"fn() -> bool"},"resetBuddy":{"!doc":"<p>Resets the user value of the property <code>buddy</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #buddy}.</p>","!type":"fn()"},"resetRich":{"!doc":"<p>Resets the user value of the property <code>rich</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #rich}.</p>","!type":"fn()"},"resetTextAlign":{"!doc":"<p>Resets the user value of the property <code>textAlign</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #textAlign}.</p>","!type":"fn()"},"resetValue":{"!doc":"<p>Resets the user value of the property <code>value</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #value}.</p>","!type":"fn()"},"resetWrap":{"!doc":"<p>Resets the user value of the property <code>wrap</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #wrap}.</p>","!type":"fn()"},"setBuddy":{"!doc":"<p>Sets the user value of the property <code>buddy</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #buddy}.</p>","!type":"fn(value: Object) -> Object"},"setRich":{"!doc":"<p>Sets the user value of the property <code>rich</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #rich}.</p>","!type":"fn(value: Object) -> Object"},"setTextAlign":{"!doc":"<p>Sets the user value of the property <code>textAlign</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #textAlign}.</p>","!type":"fn(value: Object) -> Object"},"setValue":{"!doc":"<p>Sets the user value of the property <code>value</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #value}.</p>","!type":"fn(value: Object) -> Object"},"setWrap":{"!doc":"<p>Sets the user value of the property <code>wrap</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #wrap}.</p>","!type":"fn(value: Object) -> Object"},"toggleRich":{"!doc":"<p>Toggles the (computed) value of the boolean property <code>rich</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #rich}.</p>","!type":"fn() -> bool"},"toggleWrap":{"!doc":"<p>Toggles the (computed) value of the boolean property <code>wrap</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #wrap}.</p>","!type":"fn() -> bool"}}}},"container":{"Composite":{"!proto":"qx.ui.core.Widget","!doc":"<p>The Composite is a generic container widget.</p>\n\n<p>It exposes all methods to set layouts and to manage child widgets\nas public methods. You must configure this widget with a layout manager to\ndefine the way the widget&#8217;s children are positioned.</p>\n\n<p><strong>Example</strong></p>\n\n<p>Here is a little example of how to use the widget.</p>\n\n<pre class=\"javascript\">\n  // create the composite\n  var composite = new qx.ui.container.Composite()\n\n  // configure it with a horizontal box layout with a spacing of '5'\n  composite.setLayout(new qx.ui.layout.HBox(5));\n\n  // add some children\n  composite.add(new qx.ui.basic.Label(\"Name: \"));\n  composite.add(new qx.ui.form.TextField());\n\n  this.getRoot().add(composite);\n</pre>\n\n<p>This example horizontally groups a label and text field by using a\nComposite configured with a horizontal box layout as a container.</p>\n\n<p><strong>External Documentation</strong></p>\n\n<a href=\"http://manual.qooxdoo.org/4.1/pages/widget/composite.html\" target=\"_blank\">\nDocumentation of this widget in the qooxdoo manual.</a>","!type":"fn()","prototype":{"_afterAddChild":{"!type":"fn(child: +undefined)"},"_afterRemoveChild":{"!type":"fn(child: +undefined)"}}},"Resizer":{"!proto":"qx.ui.container.Composite","!doc":"<p>The Resizer is a resizable container widget.</p>\n\n<p>It allows to be resized (not moved), normally in\nthe right and/or bottom directions. It is an alternative to splitters.</p>\n\n<p><strong>Example</strong></p>\n\n<p>Here is a little example of how to use the widget.</p>\n\n<pre class=\"javascript\">\n  var resizer = new qx.ui.container.Resizer().set({\n    width: 200,\n    height: 100\n  });\n\n  resizer.setLayout(new qx.ui.layout.Canvas());\n  var text = new qx.ui.form.TextArea(\"Resize me\\nI'm resizable\");\n  resizer.add(text, {edge: 0});\n\n  this.getRoot().add(resizer);\n</pre>\n\n<p>This example creates a resizer, configures it with a canvas layout and\nadds a text area to it.</p>\n\n<p><strong>External Documentation</strong></p>\n\n<a href=\"http://manual.qooxdoo.org/4.1/pages/widget/resizer.html\" target=\"_blank\">\nDocumentation of this widget in the qooxdoo manual.</a>"},"Scroll":{"!proto":"qx.ui.core.scroll.AbstractScrollArea","!doc":"<p>Container, which allows vertical and horizontal scrolling if the contents is\nlarger than the container.</p>\n\n<p>Note that this class can only have one child widget. This container has a\nfixed layout, which cannot be changed.</p>\n\n<p><strong>Example</strong></p>\n\n<p>Here is a little example of how to use the widget.</p>\n\n<pre class=\"javascript\">\n  // create scroll container\n  var scroll = new qx.ui.container.Scroll().set({\n    width: 300,\n    height: 200\n  });\n\n  // add a widget which is larger than the container\n  scroll.add(new qx.ui.core.Widget().set({\n    width: 600,\n    minWidth: 600,\n    height: 400,\n    minHeight: 400\n  }));\n\n  this.getRoot().add(scroll);\n</pre>\n\n<p>This example creates a scroll container and adds a widget, which is larger\nthan the container. This will cause the container to display vertical\nand horizontal toolbars.</p>\n\n<p><strong>External Documentation</strong></p>\n\n<a href=\"http://manual.qooxdoo.org/4.1/pages/widget/scroll.html\" target=\"_blank\">\nDocumentation of this widget in the qooxdoo manual.</a>","!type":"fn()","prototype":{"_getContentPaddingTarget":{"!doc":"<p>Returns the element, to which the content padding should be applied.</p>","!type":"fn() -> +qx.ui.core.Widget"},"add":{"!doc":"<p>Sets the content of the scroll container. Scroll containers\nmay only have one child, so it always replaces the current\nchild with the given one.</p>","!type":"fn(widget: +qx.ui.core.Widget)"},"getChildren":{"!doc":"<p>Returns the content of the scroll container.</p>\n\n<p>Scroll containers may only have one child. This\nmethod returns an array containing the child or an empty array.</p>","!type":"fn() -> Object"},"remove":{"!doc":"<p>Returns the content of the scroll area.</p>","!type":"fn(widget: +qx.ui.core.Widget)"}}},"SlideBar":{"!proto":"qx.ui.core.Widget","!doc":"<p>Container, which provides scrolling in one dimension (vertical or horizontal).</p>","!type":"fn()","prototype":{"_applyEnabled":{"!doc":"<p>Applies changes of the property value of the property <code>enabled</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #enabled}.</p>","!type":"fn(value: bool, old: bool)"},"_applyOrientation":{"!doc":"<p>Applies changes of the property value of the property <code>orientation</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #orientation}.</p>","!type":"fn(value: Object, old: Object)"},"_createChildControlImpl":{"!type":"fn(id: +undefined, hash: +undefined)"},"_hideArrows":{"!doc":"<p>Hide the arrows (Called from resize event)</p>","!type":"fn()"},"_onExecuteBackward":{"!doc":"<p>Scroll handler for left scrolling</p>","!type":"fn()"},"_onExecuteForward":{"!doc":"<p>Scroll handler for right scrolling</p>","!type":"fn()"},"_onResize":{"!doc":"<p>Listener for resize event. This event is fired after the\nfirst flush of the element which leads to another queuing\nwhen the changes modify the visibility of the scroll buttons.</p>","!type":"fn(e: +Event)"},"_onRoll":{"!doc":"<p>Scrolls pane on roll events</p>","!type":"fn(e: +qx.event.type.Roll)"},"_onScroll":{"!doc":"<p>Update arrow enabled state after scrolling</p>","!type":"fn()"},"_onScrollAnimationEnd":{"!doc":"<p>Handler to fire the &#8216;scrollAnimationEnd&#8217; event.</p>","!type":"fn()"},"_showArrows":{"!doc":"<p>Show the arrows (Called from resize event)</p>","!type":"fn()"},"_updateArrowsEnabled":{"!doc":"<p>Update arrow enabled state</p>","!type":"fn()"},"getChildrenContainer":{"!type":"fn()"},"getOrientation":{"!doc":"<p>Returns the (computed) value of the property <code>orientation</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #orientation}.</p>","!type":"fn() -> Object"},"getScrollStep":{"!doc":"<p>Returns the (computed) value of the property <code>scrollStep</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #scrollStep}.</p>","!type":"fn() -> Object"},"initOrientation":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>orientation</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #orientation}.</p>","!type":"fn(value: Object) -> Object"},"initScrollStep":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>scrollStep</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #scrollStep}.</p>","!type":"fn(value: Object) -> Object"},"resetOrientation":{"!doc":"<p>Resets the user value of the property <code>orientation</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #orientation}.</p>","!type":"fn()"},"resetScrollStep":{"!doc":"<p>Resets the user value of the property <code>scrollStep</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #scrollStep}.</p>","!type":"fn()"},"scrollBy":{"!doc":"<p>Scrolls the element&#8217;s content by the given amount.</p>","!type":"fn(offset?: +Integer, duration?: number)"},"scrollTo":{"!doc":"<p>Scrolls the element&#8217;s content to the given coordinate</p>","!type":"fn(value: +Integer, duration?: number)"},"setOrientation":{"!doc":"<p>Sets the user value of the property <code>orientation</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #orientation}.</p>","!type":"fn(value: Object) -> Object"},"setScrollStep":{"!doc":"<p>Sets the user value of the property <code>scrollStep</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #scrollStep}.</p>","!type":"fn(value: Object) -> Object"}}},"Stack":{"!proto":"qx.ui.core.Widget","!doc":"<p>The stack container puts its child widgets on top of each other and only the\ntopmost widget is visible.</p>\n\n<p>This is used e.g. in the tab view widget. Which widget is visible can be\ncontrolled by using the {@link #getSelection} method.</p>\n\n<p><strong>Example</strong></p>\n\n<p>Here is a little example of how to use the widget.</p>\n\n<pre class=\"javascript\">\n  // create stack container\n  var stack = new qx.ui.container.Stack();\n\n  // add some children\n  stack.add(new qx.ui.core.Widget().set({\n   backgroundColor: \"red\"\n  }));\n  stack.add(new qx.ui.core.Widget().set({\n   backgroundColor: \"green\"\n  }));\n  stack.add(new qx.ui.core.Widget().set({\n   backgroundColor: \"blue\"\n  }));\n\n  // select green widget\n  stack.setSelection([stack.getChildren()[1]]);\n\n  this.getRoot().add(stack);\n</pre>\n\n<p>This example creates an stack with three children. Only the selected &#8220;green&#8221;\nwidget is visible.</p>\n\n<p><strong>External Documentation</strong></p>\n\n<a href=\"http://manual.qooxdoo.org/4.1/pages/widget/stack.html\" target=\"_blank\">\nDocumentation of this widget in the qooxdoo manual.</a>","!type":"fn()","prototype":{"__onChangeSelection":{"!doc":"<p>Event handler for <code>changeSelection</code>.</p>\n\n<p>Shows the new selected widget and hide the old one.</p>","!type":"fn(e: +qx.event.type.Data)"},"_afterAddChild":{"!type":"fn(child: +undefined)"},"_afterRemoveChild":{"!type":"fn(child: +undefined)"},"_applyDynamic":{"!doc":"<p>Applies changes of the property value of the property <code>dynamic</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #dynamic}.</p>","!type":"fn(value: bool, old: bool)"},"_getItems":{"!doc":"<p>Returns the widget for the selection.</p>","!type":"fn() -> +qx.ui.core.Widget"},"_isAllowEmptySelection":{"!doc":"<p>Returns if the selection could be empty or not.</p>","!type":"fn() -> bool"},"_isItemSelectable":{"!doc":"<p>Returns whether the given item is selectable.</p>","!type":"fn(item: +qx.ui.core.Widget) -> bool"},"getDynamic":{"!doc":"<p>Returns the (computed) value of the property <code>dynamic</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #dynamic}.</p>","!type":"fn() -> Object"},"initDynamic":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>dynamic</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #dynamic}.</p>","!type":"fn(value: Object) -> Object"},"isDynamic":{"!doc":"<p>Check whether the (computed) value of the boolean property <code>dynamic</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #dynamic}.</p>","!type":"fn() -> bool"},"next":{"!doc":"<p>Go to the next child in the children list.</p>","!type":"fn()"},"previous":{"!doc":"<p>Go to the previous child in the children list.</p>","!type":"fn()"},"resetDynamic":{"!doc":"<p>Resets the user value of the property <code>dynamic</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #dynamic}.</p>","!type":"fn()"},"setDynamic":{"!doc":"<p>Sets the user value of the property <code>dynamic</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #dynamic}.</p>","!type":"fn(value: Object) -> Object"},"toggleDynamic":{"!doc":"<p>Toggles the (computed) value of the boolean property <code>dynamic</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #dynamic}.</p>","!type":"fn() -> bool"}}}},"control":{"ColorPopup":{"!proto":"qx.ui.popup.Popup","!doc":"<p>A popup which contains palettes of colors and the possibility to open the\nColorselector to choose a color.</p>","!type":"fn()","prototype":{"_applyValue":{"!doc":"<p>Applies changes of the property value of the property <code>value</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #value}.</p>","!type":"fn(value: Object, old: Object)"},"_createBoxes":{"!doc":"<p>Creates the GroupBoxes containing the colored fields.</p>","!type":"fn()"},"_createChildControlImpl":{"!type":"fn(id: +undefined, hash: +undefined)"},"_createColorSelector":{"!doc":"<p>Creates the ColorSelector and adds buttons.</p>","!type":"fn()"},"_onAutomaticBtnExecute":{"!doc":"<p>Listener of execute event on the &#8220;cancel&#8221; button.\nHides the ColorPopup and resets it&#8217;s color value.</p>","!type":"fn()"},"_onChangeVisibility":{"!doc":"<p>Listener for visibility changes.\nSets preview pane&#8217;s background color to the current color,\nwhen the popup is visible.</p>","!type":"fn(e: +qx.event.type.Data)"},"_onColorSelectorCancel":{"!doc":"<p>Listener of execute event on the &#8220;Cancel&#8221; button.\nHides the ColorPopup.</p>","!type":"fn()"},"_onColorSelectorOk":{"!doc":"<p>Listener of execute event on the &#8220;OK&#8221; button.\nHides the ColorPopup and sets it&#8217;s color value to the selected color.</p>","!type":"fn()"},"_onFieldPointerDown":{"!doc":"<p>Listener of pointerdown event on a color field. Sets the ColorPoup&#8217;s value\nto field&#8217;s color value and paint the preview pane.</p>","!type":"fn(e: +qx.event.type.Pointer)"},"_onFieldPointerOut":{"!doc":"<p>Listener of pointerout event on a color field. Reset the preview pane&#8217;s\nbackground color to the old color value.</p>","!type":"fn(e: +qx.event.type.Pointer)"},"_onFieldPointerOver":{"!doc":"<p>Listener of pointermove event on a color field. Sets preview pane&#8217;s\nbackground color to the field&#8217;s color value.</p>","!type":"fn(e: +qx.event.type.Pointer)"},"_onSelectorButtonExecute":{"!doc":"<p>Listener of execute event on the &#8220;Open ColorSelector&#8221; button.\nOpens a ColorSelector widget and hides the ColorPopup.</p>","!type":"fn()"},"_rotatePreviousColors":{"!doc":"<p>Adds the most recent selected color to the &#8220;Recent colors&#8221; list.\nIf this list is full, the first color will be removed before inserting\nthe new one.</p>","!type":"fn()"},"getBlue":{"!doc":"<p>Returns the (computed) value of the property <code>blue</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #blue}.</p>","!type":"fn() -> Object"},"getGreen":{"!doc":"<p>Returns the (computed) value of the property <code>green</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #green}.</p>","!type":"fn() -> Object"},"getRed":{"!doc":"<p>Returns the (computed) value of the property <code>red</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #red}.</p>","!type":"fn() -> Object"},"getValue":{"!doc":"<p>Returns the (computed) value of the property <code>value</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #value}.</p>","!type":"fn() -> Object"},"initBlue":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>blue</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #blue}.</p>","!type":"fn(value: Object) -> Object"},"initGreen":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>green</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #green}.</p>","!type":"fn(value: Object) -> Object"},"initRed":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>red</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #red}.</p>","!type":"fn(value: Object) -> Object"},"initValue":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>value</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #value}.</p>","!type":"fn(value: Object) -> Object"},"resetBlue":{"!doc":"<p>Resets the user value of the property <code>blue</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #blue}.</p>","!type":"fn()"},"resetGreen":{"!doc":"<p>Resets the user value of the property <code>green</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #green}.</p>","!type":"fn()"},"resetRed":{"!doc":"<p>Resets the user value of the property <code>red</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #red}.</p>","!type":"fn()"},"resetValue":{"!doc":"<p>Resets the user value of the property <code>value</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #value}.</p>","!type":"fn()"},"setBlue":{"!doc":"<p>Sets the user value of the property <code>blue</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #blue}.</p>","!type":"fn(value: Object) -> Object"},"setGreen":{"!doc":"<p>Sets the user value of the property <code>green</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #green}.</p>","!type":"fn(value: Object) -> Object"},"setRed":{"!doc":"<p>Sets the user value of the property <code>red</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #red}.</p>","!type":"fn(value: Object) -> Object"},"setValue":{"!doc":"<p>Sets the user value of the property <code>value</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #value}.</p>","!type":"fn(value: Object) -> Object"}}},"ColorSelector":{"!proto":"qx.ui.core.Widget","!doc":"<p>A typical color selector as known from native applications.</p>\n\n<p>Includes support for <span class=\"caps\">RGB</span> and <span class=\"caps\">HSB</span> color areas.</p>","!type":"fn()","prototype":{"__fireChangeValueEvent":{"!doc":"<p>Helper for firing the changeValue event and checking for the mutex.</p>","!type":"fn()"},"_applyBlue":{"!doc":"<p>Applies changes of the property value of the property <code>blue</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #blue}.</p>","!type":"fn(value: +Integer, old: +Integer)"},"_applyBrightness":{"!doc":"<p>Applies changes of the property value of the property <code>brightness</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #brightness}.</p>","!type":"fn(value: number, old: number)"},"_applyGreen":{"!doc":"<p>Applies changes of the property value of the property <code>green</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #green}.</p>","!type":"fn(value: +Integer, old: +Integer)"},"_applyHue":{"!doc":"<p>Applies changes of the property value of the property <code>hue</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #hue}.</p>","!type":"fn(value: number, old: number)"},"_applyRed":{"!doc":"<p>Applies changes of the property value of the property <code>red</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #red}.</p>","!type":"fn(value: +Integer, old: +Integer)"},"_applySaturation":{"!doc":"<p>Applies changes of the property value of the property <code>saturation</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #saturation}.</p>","!type":"fn(value: number, old: number)"},"_createChildControlImpl":{"!type":"fn(id: +undefined, hash: +undefined)"},"_onAppear":{"!doc":"<p>Listener for appear.\nSets preview pane&#8217;s background color to the current color.</p>","!type":"fn(e: +qx.event.type.Data)"},"_onBrightnessFieldPointerDown":{"!doc":"<p>Listener of pointerdown event on the brightness field.\nAdjusts the color by changing the brightness.</p>","!type":"fn(e: +qx.event.type.Pointer)"},"_onBrightnessHandlePointerDown":{"!doc":"<p>Listener of pointerdown event on the brightness handle.\nAdjusts the color by changing the brightness.</p>","!type":"fn(e: +qx.event.type.Pointer)"},"_onBrightnessHandlePointerMove":{"!doc":"<p>Listener of pointermove event on the brightness handle.\nForwards the event to _setBrightnessOnFieldEvent().</p>","!type":"fn(e: +qx.event.type.Pointer)"},"_onBrightnessHandlePointerUp":{"!doc":"<p>Listener of pointerup event on the brightness handle.\nReleases the capture.</p>","!type":"fn(e: +qx.event.type.Pointer)"},"_onBrightnessPaneRoll":{"!doc":"<p>Listener of roll event on the brightness pane.\nAdjusts the color by changing the brightness.</p>","!type":"fn(e: +qx.event.type.Roll)"},"_onColorFieldTap":{"!doc":"<p>Listener of tap event on the color field.\nSets red, green and blue values to tapped color field&#8217;s background color.</p>","!type":"fn(e: +qx.event.type.Pointer)"},"_onHexFieldChange":{"!doc":"<p>Changes red, green and blue value to the corresponding hexfield value.</p>","!type":"fn(e: +qx.event.type.Data)"},"_onHueSaturationFieldPointerDown":{"!doc":"<p>Listener of pointerdown event on the saturation field.\nAdjusts the color by changing the saturation.\nSets pointer capture.</p>","!type":"fn(e: +qx.event.type.Pointer)"},"_onHueSaturationHandlePointerMove":{"!doc":"<p>Listener of pointermove event on the saturation handle.\nForwards the event to _onHueSaturationHandlePointerMove().</p>","!type":"fn(e: +qx.event.type.Pointer)"},"_onHueSaturationHandlePointerUp":{"!doc":"<p>Listener of pointerup event on the saturation handle.\nReleases pointer capture.</p>","!type":"fn(e: +qx.event.type.Pointer)"},"_onHueSaturationPaneRoll":{"!doc":"<p>Listener of roll event on the saturation pane.\nAdjusts the color by changing the saturation.</p>","!type":"fn(e: +qx.event.type.Roll)"},"_setBlueFromSpinner":{"!doc":"<p>Sets widget&#8217;s blue value to spinner&#8217;s value.</p>","!type":"fn()"},"_setBrightnessFromSpinner":{"!doc":"<p>Sets widget&#8217;s brightness value to spinner&#8217;s value.</p>","!type":"fn()"},"_setBrightnessGradiant":{"!doc":"<p>Updates the background of the brightness field to give a nicer gradient</p>","!type":"fn()"},"_setBrightnessOnFieldEvent":{"!doc":"<p>Sets the brightness and moves the brightness handle.</p>","!type":"fn(e: +qx.event.type.Pointer)"},"_setGreenFromSpinner":{"!doc":"<p>Sets widget&#8217;s green value to spinner&#8217;s value.</p>","!type":"fn()"},"_setHexFromRgb":{"!doc":"<p>Sets hexfield value to it&#8217;s corresponding red, green and blue value.</p>","!type":"fn()"},"_setHueFromRgb":{"!doc":"<p>Sets hue value to it&#8217;s corresponding red, green and blue value.</p>","!type":"fn()"},"_setHueFromSpinner":{"!doc":"<p>Sets widget&#8217;s hue value to spinner&#8217;s value.</p>","!type":"fn()"},"_setHueSaturationOnFieldEvent":{"!doc":"<p>Sets the saturation and moves the saturation handle.</p>","!type":"fn(e: +qx.event.type.Pointer)"},"_setPreviewFromRgb":{"!doc":"<p>Sets preview pane&#8217;s background color to corresponding red, green and blue color values.</p>","!type":"fn()"},"_setRedFromSpinner":{"!doc":"<p>Sets widget&#8217;s red value to spinner&#8217;s value.</p>","!type":"fn()"},"_setRgbFromHue":{"!doc":"<p>Sets red, green and blue value to corresponding hue value.</p>","!type":"fn()"},"_setSaturationFromSpinner":{"!doc":"<p>Sets widget&#8217;s saturation value to spinner&#8217;s value.</p>","!type":"fn()"},"getBlue":{"!doc":"<p>Returns the (computed) value of the property <code>blue</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #blue}.</p>","!type":"fn() -> Object"},"getBrightness":{"!doc":"<p>Returns the (computed) value of the property <code>brightness</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #brightness}.</p>","!type":"fn() -> Object"},"getGreen":{"!doc":"<p>Returns the (computed) value of the property <code>green</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #green}.</p>","!type":"fn() -> Object"},"getHue":{"!doc":"<p>Returns the (computed) value of the property <code>hue</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #hue}.</p>","!type":"fn() -> Object"},"getRed":{"!doc":"<p>Returns the (computed) value of the property <code>red</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #red}.</p>","!type":"fn() -> Object"},"getSaturation":{"!doc":"<p>Returns the (computed) value of the property <code>saturation</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #saturation}.</p>","!type":"fn() -> Object"},"getValue":{"!doc":"<p>Returns the currently selected color.</p>","!type":"fn() -> string"},"initBlue":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>blue</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #blue}.</p>","!type":"fn(value: Object) -> Object"},"initBrightness":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>brightness</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #brightness}.</p>","!type":"fn(value: Object) -> Object"},"initGreen":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>green</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #green}.</p>","!type":"fn(value: Object) -> Object"},"initHue":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>hue</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #hue}.</p>","!type":"fn(value: Object) -> Object"},"initRed":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>red</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #red}.</p>","!type":"fn(value: Object) -> Object"},"initSaturation":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>saturation</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #saturation}.</p>","!type":"fn(value: Object) -> Object"},"resetBlue":{"!doc":"<p>Resets the user value of the property <code>blue</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #blue}.</p>","!type":"fn()"},"resetBrightness":{"!doc":"<p>Resets the user value of the property <code>brightness</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #brightness}.</p>","!type":"fn()"},"resetGreen":{"!doc":"<p>Resets the user value of the property <code>green</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #green}.</p>","!type":"fn()"},"resetHue":{"!doc":"<p>Resets the user value of the property <code>hue</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #hue}.</p>","!type":"fn()"},"resetRed":{"!doc":"<p>Resets the user value of the property <code>red</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #red}.</p>","!type":"fn()"},"resetSaturation":{"!doc":"<p>Resets the user value of the property <code>saturation</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #saturation}.</p>","!type":"fn()"},"resetValue":{"!doc":"<p>Resets the color to null.</p>","!type":"fn()"},"setBlue":{"!doc":"<p>Sets the user value of the property <code>blue</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #blue}.</p>","!type":"fn(value: Object) -> Object"},"setBrightness":{"!doc":"<p>Sets the user value of the property <code>brightness</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #brightness}.</p>","!type":"fn(value: Object) -> Object"},"setGreen":{"!doc":"<p>Sets the user value of the property <code>green</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #green}.</p>","!type":"fn(value: Object) -> Object"},"setHue":{"!doc":"<p>Sets the user value of the property <code>hue</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #hue}.</p>","!type":"fn(value: Object) -> Object"},"setPreviousColor":{"!doc":"<p>Sets previous color&#8217;s to given values.</p>","!type":"fn(red: number, green: number, blue: number)"},"setRed":{"!doc":"<p>Sets the user value of the property <code>red</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #red}.</p>","!type":"fn(value: Object) -> Object"},"setSaturation":{"!doc":"<p>Sets the user value of the property <code>saturation</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #saturation}.</p>","!type":"fn(value: Object) -> Object"},"setValue":{"!doc":"<p>The value of the ColorSelector is a string containing the <span class=\"caps\">HEX</span> value of\nthe currently selected color. Take a look at\n{@link qx.util.ColorUtil#stringToRgb} to see what kind of input the\nmethod can handle.</p>","!type":"fn(value: string)"}}},"DateChooser":{"!proto":"qx.ui.core.Widget","!doc":"<p>A <strong>date chooser</strong> is a small calendar including a navigation bar to switch the shown\nmonth. It includes a column for the calendar week and shows one month. Selecting\na date is as easy as tapping on it.</p>\n\n<p>To be conform with all form widgets, the {@link qx.ui.form.IForm} interface\nis implemented.</p>\n\n<p>The following example creates and adds a date chooser to the root element.\nA listener alerts the user if a new date is selected.</p>\n\n<pre class=\"javascript\">\nvar chooser = new qx.ui.control.DateChooser();\nthis.getRoot().add(chooser, { left : 20, top: 20});\n\nchooser.addListener(\"changeValue\", function(e) {\n  alert(e.getData());\n});\n</pre>\n\n<p>Additionally to a selection event an execute event is available which is\nfired by doubletap or tapping the space / enter key. With this event you\ncan for example save the selection and close the date chooser.</p>","!type":"fn()","prototype":{"_applyValue":{"!doc":"<p>Applies changes of the property value of the property <code>value</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #value}.</p>","!type":"fn(value: +Date, old: +Date)"},"_createChildControlImpl":{"!type":"fn(id: +undefined, hash: +undefined)"},"_onDayDblTap":{"!doc":"<p>Event handler. Called when a day has been double-tapped.</p>","!type":"fn()"},"_onDayTap":{"!doc":"<p>Event handler. Called when a day has been tapped.</p>","!type":"fn(evt: +qx.event.type.Data)"},"_onKeyPress":{"!doc":"<p>Event handler. Called when a key was pressed.</p>","!type":"fn(evt: +qx.event.type.Data)"},"_onNavButtonTap":{"!doc":"<p>Event handler. Called when a navigation button has been tapped.</p>","!type":"fn(evt: +qx.event.type.Data)"},"_onPointerUpDown":{"!doc":"<p>Handler which stops the propagation of the tap event if\nthe navigation bar or calendar headers will be tapped.</p>","!type":"fn(e: +qx.event.type.Pointer)"},"_updateDatePane":{"!doc":"<p>Updates the date pane.</p>","!type":"fn()"},"getShownMonth":{"!doc":"<p>Returns the (computed) value of the property <code>shownMonth</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #shownMonth}.</p>","!type":"fn() -> Object"},"getShownYear":{"!doc":"<p>Returns the (computed) value of the property <code>shownYear</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #shownYear}.</p>","!type":"fn() -> Object"},"getValue":{"!doc":"<p>Returns the (computed) value of the property <code>value</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #value}.</p>","!type":"fn() -> Object"},"handleKeyPress":{"!doc":"<p>Event handler. Used to handle the key events.</p>","!type":"fn(e: +qx.event.type.Data)"},"initShownMonth":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>shownMonth</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #shownMonth}.</p>","!type":"fn(value: Object) -> Object"},"initShownYear":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>shownYear</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #shownYear}.</p>","!type":"fn(value: Object) -> Object"},"initValue":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>value</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #value}.</p>","!type":"fn(value: Object) -> Object"},"resetShownMonth":{"!doc":"<p>Resets the user value of the property <code>shownMonth</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #shownMonth}.</p>","!type":"fn()"},"resetShownYear":{"!doc":"<p>Resets the user value of the property <code>shownYear</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #shownYear}.</p>","!type":"fn()"},"resetValue":{"!doc":"<p>Resets the user value of the property <code>value</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #value}.</p>","!type":"fn()"},"setShownMonth":{"!doc":"<p>Sets the user value of the property <code>shownMonth</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #shownMonth}.</p>","!type":"fn(value: Object) -> Object"},"setShownYear":{"!doc":"<p>Sets the user value of the property <code>shownYear</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #shownYear}.</p>","!type":"fn(value: Object) -> Object"},"setValue":{"!doc":"<p>Sets the user value of the property <code>value</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #value}.</p>","!type":"fn(value: Object) -> Object"},"showMonth":{"!doc":"<p>Shows a certain month.</p>","!type":"fn(month?: +Integer, year?: +Integer)"}}}},"core":{"Blocker":{"!proto":"qx.core.Object","!doc":"<p>This class blocks events and can be included into all widgets.</p>\n\n<p>The {@link #block} and {@link #unblock} methods provided by this class can be used\nto block any event from the widget. When blocked,\nthe blocker widget overlays the widget to block, including the padding area.</p>","!type":"fn()","prototype":{"__activateBlockerElement":{"!doc":"<p>Sets the blocker element to avtive.</p>","!type":"fn()"},"__createBlockerElement":{"!doc":"<p>Creates the blocker element.</p>","!type":"fn() -> +qx.html.Element"},"__onBoundsChange":{"!doc":"<p>Adjust html element size on layout resizes.</p>","!type":"fn(e: +qx.event.type.Data)"},"__onWidgetAppear":{"!doc":"<p>Widget re-appears: Update blocker size/position and attach to (new) parent</p>","!type":"fn()"},"__onWidgetDisappear":{"!doc":"<p>Remove the blocker if the widget disappears</p>","!type":"fn()"},"__setBlockersStyle":{"!doc":"<p>Set the style to all blockers (blocker and content blocker).</p>","!type":"fn(key: string, value: string)"},"__stopTabEvent":{"!doc":"<p>Stops the passed &#8220;Tab&#8221; event.</p>","!type":"fn(e: +qx.event.type.KeySequence)"},"__unblock":{"!doc":"<p>Unblock the widget blocked by {@link #block}.</p>","!type":"fn()"},"_applyColor":{"!doc":"<p>Applies changes of the property value of the property <code>color</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #color}.</p>","!type":"fn(value: +Color, old: +Color)"},"_applyOpacity":{"!doc":"<p>Applies changes of the property value of the property <code>opacity</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #opacity}.</p>","!type":"fn(value: number, old: number)"},"_backupActiveWidget":{"!doc":"<p>Backup the current active and focused widget.</p>","!type":"fn()"},"_block":{"!doc":"<p>Adds the blocker to the appropriate element and includes it.</p>","!type":"fn(zIndex: number, blockContent: bool)"},"_onChangeTheme":{"!doc":"<p>Handler for the theme change.</p>","!type":"fn()"},"_restoreActiveWidget":{"!doc":"<p>Restore the current active and focused widget.</p>","!type":"fn()"},"_updateBlockerBounds":{"!doc":"<p>set the blocker&#8217;s size and position</p>","!type":"fn(bounds: +Map)"},"block":{"!doc":"<p>Block all events from this widget by placing a transparent overlay widget,\nwhich receives all events, exactly over the widget.</p>","!type":"fn()"},"blockContent":{"!doc":"<p>Block direct child widgets with a zIndex below <code>zIndex</code></p>","!type":"fn(zIndex: +Integer)"},"forceUnblock":{"!doc":"<p>Unblock the widget blocked by {@link #block}, but it doesn&#8217;t take care of\nthe amount of {@link #block} calls. The blocker is directly removed.</p>","!type":"fn()"},"getBlockerElement":{"!doc":"<p>Get/create the blocker element</p>","!type":"fn(widget: +qx.ui.core.Widget) -> +qx.html.Element"},"getColor":{"!doc":"<p>Returns the (computed) value of the property <code>color</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #color}.</p>","!type":"fn() -> Object"},"getKeepBlockerActive":{"!doc":"<p>Returns the (computed) value of the property <code>keepBlockerActive</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #keepBlockerActive}.</p>","!type":"fn() -> Object"},"getOpacity":{"!doc":"<p>Returns the (computed) value of the property <code>opacity</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #opacity}.</p>","!type":"fn() -> Object"},"initColor":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>color</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #color}.</p>","!type":"fn(value: Object) -> Object"},"initKeepBlockerActive":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>keepBlockerActive</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #keepBlockerActive}.</p>","!type":"fn(value: Object) -> Object"},"initOpacity":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>opacity</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #opacity}.</p>","!type":"fn(value: Object) -> Object"},"isBlocked":{"!doc":"<p>Returns whether the widget is blocked.</p>","!type":"fn() -> bool"},"isKeepBlockerActive":{"!doc":"<p>Check whether the (computed) value of the boolean property <code>keepBlockerActive</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #keepBlockerActive}.</p>","!type":"fn() -> bool"},"resetColor":{"!doc":"<p>Resets the user value of the property <code>color</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #color}.</p>","!type":"fn()"},"resetKeepBlockerActive":{"!doc":"<p>Resets the user value of the property <code>keepBlockerActive</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #keepBlockerActive}.</p>","!type":"fn()"},"resetOpacity":{"!doc":"<p>Resets the user value of the property <code>opacity</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #opacity}.</p>","!type":"fn()"},"setColor":{"!doc":"<p>Sets the user value of the property <code>color</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #color}.</p>","!type":"fn(value: Object) -> Object"},"setKeepBlockerActive":{"!doc":"<p>Sets the user value of the property <code>keepBlockerActive</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #keepBlockerActive}.</p>","!type":"fn(value: Object) -> Object"},"setOpacity":{"!doc":"<p>Sets the user value of the property <code>opacity</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #opacity}.</p>","!type":"fn(value: Object) -> Object"},"toggleKeepBlockerActive":{"!doc":"<p>Toggles the (computed) value of the boolean property <code>keepBlockerActive</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #keepBlockerActive}.</p>","!type":"fn() -> bool"},"unblock":{"!doc":"<p>Unblock the widget blocked by {@link #block}, but it takes care of\nthe amount of {@link #block} calls. The blocker is only removed if\nthe numer of {@link #unblock} calls is identical to {@link #block} calls.</p>","!type":"fn()"}}},"ColumnData":{"!proto":"qx.ui.core.LayoutItem","!doc":"<p>All of the resizing information about a column.</p>\n\n<p>This is used internally by qx.ui.table and qx.ui.progressive&#8217;s table and\n may be used for other widgets as well.</p>","!type":"fn()","prototype":{"getComputedWidth":{"!doc":"<p>Get the computed width of the column.</p>","!type":"fn() -> +Integer"},"getFlex":{"!doc":"<p>Get the column&#8217;s flex value</p>","!type":"fn() -> +Integer"},"renderLayout":{"!type":"fn(left: +undefined, top: +undefined, width: +undefined, height: +undefined)"},"setColumnWidth":{"!doc":"<p>Set the column width. The column width can be one of the following\nvalues:</p>\n\n<ul>\n<li>Pixels: e.g. <code>23</code></li>\n<li>Autosized: <code>&#8220;auto&#8221;</code></li>\n<li>Flex: e.g. <code>&#8220;1*&#8221;</code></li>\n<li>Percent: e.g. <code>&#8220;33%&#8221;</code></li>\n</ul>","!type":"fn(width: +Integer, flex?: +Integer)"}}},"Command":{"!proto":"qx.core.Object","!doc":"<p>Commands can be used to globally define keyboard shortcuts. They could\nalso be used to assign an execution of a command sequence to multiple\nwidgets. It is possible to use the same Command in a MenuButton and\nToolBarButton for example.</p>","!type":"fn()","prototype":{"_applyEnabled":{"!doc":"<p>Applies changes of the property value of the property <code>enabled</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #enabled}.</p>","!type":"fn(value: bool, old: bool)"},"_applyShortcut":{"!doc":"<p>Applies changes of the property value of the property <code>shortcut</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #shortcut}.</p>","!type":"fn(value: string, old: string)"},"execute":{"!doc":"<p>Fire the &#8220;execute&#8221; event on this command.</p>","!type":"fn(target: Object)"},"getEnabled":{"!doc":"<p>Returns the (computed) value of the property <code>enabled</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #enabled}.</p>","!type":"fn() -> Object"},"getIcon":{"!doc":"<p>Returns the (computed) value of the property <code>icon</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #icon}.</p>","!type":"fn() -> Object"},"getLabel":{"!doc":"<p>Returns the (computed) value of the property <code>label</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #label}.</p>","!type":"fn() -> Object"},"getMenu":{"!doc":"<p>Returns the (computed) value of the property <code>menu</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #menu}.</p>","!type":"fn() -> Object"},"getShortcut":{"!doc":"<p>Returns the (computed) value of the property <code>shortcut</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #shortcut}.</p>","!type":"fn() -> Object"},"getToolTipText":{"!doc":"<p>Returns the (computed) value of the property <code>toolTipText</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #toolTipText}.</p>","!type":"fn() -> Object"},"getValue":{"!doc":"<p>Returns the (computed) value of the property <code>value</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #value}.</p>","!type":"fn() -> Object"},"initEnabled":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>enabled</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #enabled}.</p>","!type":"fn(value: Object) -> Object"},"initIcon":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>icon</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #icon}.</p>","!type":"fn(value: Object) -> Object"},"initLabel":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>label</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #label}.</p>","!type":"fn(value: Object) -> Object"},"initMenu":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>menu</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #menu}.</p>","!type":"fn(value: Object) -> Object"},"initShortcut":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>shortcut</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #shortcut}.</p>","!type":"fn(value: Object) -> Object"},"initToolTipText":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>toolTipText</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #toolTipText}.</p>","!type":"fn(value: Object) -> Object"},"initValue":{"!doc":"<p>Calls the apply method and dispatches the change event of the property <code>value</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #value}.</p>","!type":"fn(value: Object) -> Object"},"isEnabled":{"!doc":"<p>Check whether the (computed) value of the boolean property <code>enabled</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #enabled}.</p>","!type":"fn() -> bool"},"resetEnabled":{"!doc":"<p>Resets the user value of the property <code>enabled</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #enabled}.</p>","!type":"fn()"},"resetIcon":{"!doc":"<p>Resets the user value of the property <code>icon</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #icon}.</p>","!type":"fn()"},"resetLabel":{"!doc":"<p>Resets the user value of the property <code>label</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #label}.</p>","!type":"fn()"},"resetMenu":{"!doc":"<p>Resets the user value of the property <code>menu</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #menu}.</p>","!type":"fn()"},"resetShortcut":{"!doc":"<p>Resets the user value of the property <code>